package vtk;

import java.util.Properties;
import java.util.StringTokenizer;

public class vtkSettings
{
  private static String GetVTKBuildLibDir() { return "/build/vtk/src/build/lib"; }
  private static String GetVTKInstallLibDir() { return "/usr/"; }

  private static String[] Split(String str, String sep)
    {
    StringTokenizer st = new StringTokenizer(str, sep);
    int size = st.countTokens();
    String[] res = new String[size];
    int cnt = 0;
    while (st.hasMoreTokens())
      {
      res[cnt] = st.nextToken();
      cnt ++;
      }
    return res;
    }

  public static String GetVTKLibraryDir()
    {
    String lpath = null;
    Properties p = System.getProperties();
    String path_separator = p.getProperty("path.separator");
    String s = p.getProperty("java.class.path");
    String[] paths = vtkSettings.Split(s, path_separator);
    int cc;
    for ( cc = 0; cc < paths.length; cc ++ )
      {
      if ( paths[cc].endsWith("vtk.jar") )
        {
        lpath = paths[cc].substring(0, paths[cc].length()-"vtk.jar".length()-1);
        }
      }
    if ( lpath == null )
      {
      lpath = vtkSettings.GetVTKInstallLibDir();
      }
    return lpath;
    }

  public static String[] GetKits()
    {
    return vtkSettings.Split("CommonCore;CommonMath;CommonMisc;CommonSystem;CommonTransforms;CommonDataModel;CommonColor;CommonExecutionModel;CommonComputationalGeometry;FiltersCore;FiltersGeneral;ImagingCore;ImagingFourier;FiltersStatistics;FiltersExtraction;InfovisCore;FiltersGeometry;FiltersSources;RenderingCore;RenderingFreeType;RenderingContext2D;ChartsCore;IOCore;IOLegacy;IOXMLParser;IOXML;IOInfovis;RenderingOpenGL2;RenderingContextOpenGL2;IOImage;TestingRendering;ImagingSources;FiltersHybrid;FiltersModeling;ImagingColor;ImagingGeneral;ImagingHybrid;InteractionStyle;RenderingAnnotation;RenderingVolume;InteractionWidgets;ViewsCore;ViewsContext2D;FiltersProgrammable;FiltersVerdict;FiltersGeneric;IOGeometry;DomainsChemistry;DomainsChemistryOpenGL2;ParallelCore;FiltersParallel;ParallelMPI;FiltersParallelMPI;DomainsParallelChemistry;FiltersAMR;IOAMR;IOExodus;ImagingMath;RenderingVolumeOpenGL2;FiltersFlowPaths;FiltersImaging;RenderingLabel;FiltersHyperTree;ImagingStencil;FiltersParallelGeometry;FiltersParallelImaging;IOParallelExodus;RenderingParallel;FiltersParallelDIY2;FiltersParallelFlowPaths;IONetCDF;IOParallel;IOParallelXML;FiltersParallelStatistics;FiltersParallelVerdict;FiltersPoints;FiltersReebGraph;FiltersSMP;FiltersSelection;FiltersTexture;FiltersTopology;IOSQL;InfovisLayout;GeovisCore;ViewsInfovis;ViewsGeovis;IOGDAL;GeovisGDAL;ImagingStatistics;InteractionImage;IOAsynchronous;IOCityGML;IOEnSight;RenderingGL2PSOpenGL2;IOExport;IOExportOpenGL2;IOExportPDF;IOMovie;IOVideo;IOFFMPEG;IOGeoJSON;IOImport;IOLSDyna;IOMINC;IOMPIImage;IOMPIParallel;IOMotionFX;IOMySQL;IOODBC;IOPDAL;IOPLY;IOParallelLSDyna;IOParallelNetCDF;IOXdmf3;IOParallelXdmf3;IOPostgreSQL;IOSegY;IOTRUCHAS;IOTecplotTable;IOVPIC;IOVeraOut;IOXdmf2;RenderingImage;ImagingMorphological;InfovisBoostGraphAlgorithms;RenderingLOD;RenderingLICOpenGL2;RenderingMatplotlib;RenderingParallelLIC;RenderingQt;RenderingSceneGraph;RenderingVolumeAMR", ";");
    }
}
