/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.impl.models.http.request;

import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.zaproxy.zap.extension.httppanel.InvalidMessageDataException;
import org.zaproxy.zap.extension.httppanel.view.impl.models.http.AbstractHttpByteHttpPanelViewModel;

public class RequestHeaderByteHttpPanelViewModel
extends AbstractHttpByteHttpPanelViewModel {
    private static final Logger logger = LogManager.getLogger(RequestHeaderByteHttpPanelViewModel.class);

    @Override
    public byte[] getData() {
        if (this.httpMessage == null) {
            return new byte[0];
        }
        return this.httpMessage.getRequestHeader().toString().getBytes();
    }

    @Override
    public void setData(byte[] data) {
        if (this.httpMessage == null) {
            return;
        }
        try {
            this.httpMessage.setRequestHeader(new String(data));
        }
        catch (HttpMalformedHeaderException e) {
            logger.warn("Could not Save Header: " + Arrays.toString(data), (Throwable)e);
            throw new InvalidMessageDataException(Constant.messages.getString("http.panel.model.header.warn.malformed"), e);
        }
    }
}

