/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.spider;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.renderer.DefaultTableRenderer;
import org.jdesktop.swingx.renderer.IconValues;
import org.jdesktop.swingx.renderer.MappedValue;
import org.jdesktop.swingx.renderer.StringValue;
import org.jdesktop.swingx.renderer.StringValues;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.spider.ExtensionSpider;
import org.zaproxy.zap.extension.spider.SpiderMessagesTable;
import org.zaproxy.zap.extension.spider.SpiderMessagesTableModel;
import org.zaproxy.zap.extension.spider.SpiderPanelTableModel;
import org.zaproxy.zap.extension.spider.SpiderScan;
import org.zaproxy.zap.model.ScanController;
import org.zaproxy.zap.model.ScanListenner2;
import org.zaproxy.zap.spider.SpiderParam;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.utils.TableExportButton;
import org.zaproxy.zap.view.ScanPanel2;
import org.zaproxy.zap.view.ZapTable;
import org.zaproxy.zap.view.table.decorator.AbstractTableCellItemIconHighlighter;

public class SpiderPanel
extends ScanPanel2<SpiderScan, ScanController<SpiderScan>>
implements ScanListenner2 {
    public static final String HTTP_MESSAGE_CONTAINER_NAME = "SpiderHttpMessageContainer";
    private static final long serialVersionUID = 1L;
    private static final Logger log = LogManager.getLogger(SpiderPanel.class);
    private static final String ZERO_REQUESTS_LABEL_TEXT = "0";
    private static final SpiderPanelTableModel EMPTY_URLS_TABLE_MODEL = new SpiderPanelTableModel();
    private static final SpiderPanelTableModel EMPTY_URLS_NO_FLAGS_TABLE_MODEL = new SpiderPanelTableModel(false);
    private static final SpiderMessagesTableModel EMPTY_MESSAGES_TABLE_MODEL = new SpiderMessagesTableModel(false);
    public static final String PANEL_NAME = "SpiderPanel";
    private static final String ADDED_NODES_CONTAINER_NAME = "SpiderAddedNodesContainer";
    private JPanel mainPanel;
    private JTabbedPane tabbedPane;
    private JButton scanButton = null;
    private ZapTable urlsTable;
    private ZapTable addedNodesTable;
    private JScrollPane urlsTableScrollPane;
    private JScrollPane addedNodesTableScrollPane;
    private SpiderMessagesTable messagesTable;
    private JScrollPane messagesTableScrollPane;
    private JLabel foundCountNameLabel;
    private JLabel foundCountValueLabel;
    private JLabel addedCountNameLabel;
    private JLabel addedCountValueLabel;
    private TableExportButton<JXTable> exportButton;
    private ExtensionSpider extension = null;

    public SpiderPanel(ExtensionSpider extension, SpiderParam spiderScanParam) {
        super("spider", new ImageIcon(SpiderPanel.class.getResource("/resource/icon/16/spider.png")), extension);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                switch (SpiderPanel.this.tabbedPane.getSelectedIndex()) {
                    case 0: {
                        SpiderPanel.this.getExportButton().setTable(SpiderPanel.this.getUrlsTable());
                        break;
                    }
                    case 1: {
                        SpiderPanel.this.getExportButton().setTable(SpiderPanel.this.getAddedNodesTable());
                        break;
                    }
                    case 2: {
                        SpiderPanel.this.getExportButton().setTable(SpiderPanel.this.getMessagesTable());
                    }
                }
            }
        });
        this.extension = extension;
        this.setDefaultAccelerator(extension.getView().getMenuShortcutKeyStroke(68, 64, false));
        this.setMnemonic(Constant.messages.getChar("spider.panel.mnemonic"));
    }

    @Override
    protected JPanel getWorkPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel(new BorderLayout());
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.addTab(Constant.messages.getString("spider.panel.tab.urls"), this.getUrlsTableScrollPane());
            this.tabbedPane.addTab(Constant.messages.getString("spider.panel.tab.addednodes"), this.getAddedNodesTableScrollPane());
            this.tabbedPane.addTab(Constant.messages.getString("spider.panel.tab.messages"), this.getMessagesTableScrollPanel());
            this.tabbedPane.setSelectedIndex(0);
            this.mainPanel.add(this.tabbedPane);
        }
        return this.mainPanel;
    }

    private JScrollPane getUrlsTableScrollPane() {
        if (this.urlsTableScrollPane == null) {
            this.urlsTableScrollPane = new JScrollPane();
            this.urlsTableScrollPane.setName("SpiderUrlsPane");
            this.urlsTableScrollPane.setViewportView((Component)this.getUrlsTable());
        }
        return this.urlsTableScrollPane;
    }

    private JScrollPane getAddedNodesTableScrollPane() {
        if (this.addedNodesTableScrollPane == null) {
            this.addedNodesTableScrollPane = new JScrollPane();
            this.addedNodesTableScrollPane.setName("SpiderAddedUrlsPane");
            this.addedNodesTableScrollPane.setViewportView((Component)this.getAddedNodesTable());
        }
        return this.addedNodesTableScrollPane;
    }

    private JXTable getUrlsTable() {
        if (this.urlsTable == null) {
            this.urlsTable = new ZapTable(EMPTY_URLS_TABLE_MODEL);
            this.urlsTable.setColumnSelectionAllowed(false);
            this.urlsTable.setCellSelectionEnabled(false);
            this.urlsTable.setRowSelectionAllowed(true);
            this.urlsTable.setAutoCreateRowSorter(true);
            this.urlsTable.setAutoCreateColumnsFromModel(false);
            this.urlsTable.getColumnExt(0).setCellRenderer((TableCellRenderer)new DefaultTableRenderer((StringValue)new MappedValue(StringValues.EMPTY, IconValues.NONE), 0));
            this.urlsTable.getColumnExt(0).setHighlighters(new Highlighter[]{new ProcessedCellItemIconHighlighter(0)});
            this.urlsTable.getColumnModel().getColumn(0).setMinWidth(80);
            this.urlsTable.getColumnModel().getColumn(0).setPreferredWidth(90);
            this.urlsTable.getColumnModel().getColumn(1).setMinWidth(60);
            this.urlsTable.getColumnModel().getColumn(1).setPreferredWidth(70);
            this.urlsTable.getColumnModel().getColumn(2).setMinWidth(300);
            this.urlsTable.getColumnModel().getColumn(3).setMinWidth(50);
            this.urlsTable.getColumnModel().getColumn(3).setPreferredWidth(250);
            this.urlsTable.setName(PANEL_NAME);
            this.urlsTable.setDoubleBuffered(true);
            this.urlsTable.setSelectionMode(2);
            this.urlsTable.setComponentPopupMenu(new JPopupMenu(){
                private static final long serialVersionUID = 6608291059686282641L;

                @Override
                public void show(Component invoker, int x, int y) {
                    View.getSingleton().getPopupMenu().show(invoker, x, y);
                }
            });
        }
        return this.urlsTable;
    }

    private JXTable getAddedNodesTable() {
        if (this.addedNodesTable == null) {
            this.addedNodesTable = new ZapTable(EMPTY_URLS_NO_FLAGS_TABLE_MODEL);
            this.addedNodesTable.setColumnSelectionAllowed(false);
            this.addedNodesTable.setCellSelectionEnabled(false);
            this.addedNodesTable.setRowSelectionAllowed(true);
            this.addedNodesTable.setAutoCreateRowSorter(true);
            this.addedNodesTable.setAutoCreateColumnsFromModel(false);
            this.addedNodesTable.getColumnExt(0).setCellRenderer((TableCellRenderer)new DefaultTableRenderer((StringValue)new MappedValue(StringValues.EMPTY, IconValues.NONE), 0));
            this.addedNodesTable.getColumnExt(0).setHighlighters(new Highlighter[]{new ProcessedCellItemIconHighlighter(0)});
            this.addedNodesTable.getColumnModel().getColumn(0).setMinWidth(80);
            this.addedNodesTable.getColumnModel().getColumn(0).setPreferredWidth(90);
            this.addedNodesTable.getColumnModel().getColumn(1).setMinWidth(60);
            this.addedNodesTable.getColumnModel().getColumn(1).setPreferredWidth(70);
            this.addedNodesTable.getColumnModel().getColumn(2).setMinWidth(400);
            this.addedNodesTable.getColumnModel().getColumn(2).setPreferredWidth(1000);
            this.addedNodesTable.setName(ADDED_NODES_CONTAINER_NAME);
            this.addedNodesTable.setDoubleBuffered(true);
            this.addedNodesTable.setSelectionMode(2);
            this.addedNodesTable.setComponentPopupMenu(new JPopupMenu(){
                private static final long serialVersionUID = 6608291059686282641L;

                @Override
                public void show(Component invoker, int x, int y) {
                    View.getSingleton().getPopupMenu().show(invoker, x, y);
                }
            });
        }
        return this.addedNodesTable;
    }

    private JScrollPane getMessagesTableScrollPanel() {
        if (this.messagesTableScrollPane == null) {
            this.messagesTableScrollPane = new JScrollPane();
            this.messagesTableScrollPane.setName("SpiderMessagesPane");
            this.messagesTableScrollPane.setViewportView((Component)((Object)this.getMessagesTable()));
        }
        return this.messagesTableScrollPane;
    }

    private SpiderMessagesTable getMessagesTable() {
        if (this.messagesTable == null) {
            this.messagesTable = new SpiderMessagesTable(EMPTY_MESSAGES_TABLE_MODEL);
            this.messagesTable.setName(HTTP_MESSAGE_CONTAINER_NAME);
        }
        return this.messagesTable;
    }

    private JLabel getFoundCountNameLabel() {
        if (this.foundCountNameLabel == null) {
            this.foundCountNameLabel = new JLabel();
            this.foundCountNameLabel.setText(Constant.messages.getString("spider.toolbar.found.label"));
        }
        return this.foundCountNameLabel;
    }

    private JLabel getFoundCountValueLabel() {
        if (this.foundCountValueLabel == null) {
            this.foundCountValueLabel = new JLabel();
            this.foundCountValueLabel.setText(ZERO_REQUESTS_LABEL_TEXT);
        }
        return this.foundCountValueLabel;
    }

    private JLabel getAddedCountNameLabel() {
        if (this.addedCountNameLabel == null) {
            this.addedCountNameLabel = new JLabel();
            this.addedCountNameLabel.setText(Constant.messages.getString("spider.toolbar.added.label"));
        }
        return this.addedCountNameLabel;
    }

    private JLabel getAddedCountValueLabel() {
        if (this.addedCountValueLabel == null) {
            this.addedCountValueLabel = new JLabel();
            this.addedCountValueLabel.setText(ZERO_REQUESTS_LABEL_TEXT);
        }
        return this.addedCountValueLabel;
    }

    @Override
    protected int addToolBarElements(JToolBar toolBar, ScanPanel2.Location location, int gridX) {
        if (ScanPanel2.Location.afterProgressBar == location) {
            toolBar.add((Component)new JToolBar.Separator(), this.getGBC(gridX++, 0));
            toolBar.add((Component)this.getFoundCountNameLabel(), this.getGBC(gridX++, 0));
            toolBar.add((Component)this.getFoundCountValueLabel(), this.getGBC(gridX++, 0));
            toolBar.add((Component)new JToolBar.Separator(), this.getGBC(gridX++, 0));
            toolBar.add((Component)this.getAddedCountNameLabel(), this.getGBC(gridX++, 0));
            toolBar.add((Component)this.getAddedCountValueLabel(), this.getGBC(gridX++, 0));
            toolBar.add((Component)new JToolBar.Separator(), this.getGBC(gridX++, 0));
            toolBar.add(this.getExportButton(), this.getGBC(gridX++, 0));
        }
        return gridX;
    }

    private TableExportButton<JXTable> getExportButton() {
        if (this.exportButton == null) {
            this.exportButton = new TableExportButton<JXTable>(this.getUrlsTable());
        }
        return this.exportButton;
    }

    protected void updateFoundCount() {
        SpiderScan sc = (SpiderScan)this.getSelectedScanner();
        if (sc != null) {
            this.getFoundCountValueLabel().setText(Integer.toString(sc.getNumberOfURIsFound()));
        } else {
            this.getFoundCountValueLabel().setText(ZERO_REQUESTS_LABEL_TEXT);
        }
    }

    protected void updateAddedCount() {
        SpiderScan sc = (SpiderScan)this.getSelectedScanner();
        if (sc != null) {
            this.getAddedCountValueLabel().setText(Integer.toString(sc.getNumberOfNodesAdded()));
        } else {
            this.getAddedCountValueLabel().setText(ZERO_REQUESTS_LABEL_TEXT);
        }
    }

    @Override
    protected void switchView(final SpiderScan scanner) {
        if (View.isInitialised() && !EventQueue.isDispatchThread()) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        SpiderPanel.this.switchView(scanner);
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException e) {
                log.error("Failed to switch view: " + e.getMessage(), (Throwable)e);
            }
            return;
        }
        if (scanner != null) {
            this.getUrlsTable().setModel(scanner.getResultsTableModel());
            this.getMessagesTable().setModel(scanner.getMessagesTableModel());
            this.getAddedNodesTable().setModel((TableModel)scanner.getAddedNodesTableModel());
        } else {
            this.getUrlsTable().setModel((TableModel)EMPTY_URLS_TABLE_MODEL);
            this.getMessagesTable().setModel(EMPTY_MESSAGES_TABLE_MODEL);
            this.getAddedNodesTable().setModel((TableModel)EMPTY_URLS_TABLE_MODEL);
        }
        this.updateFoundCount();
        this.updateAddedCount();
    }

    @Override
    public JButton getNewScanButton() {
        if (this.scanButton == null) {
            this.scanButton = new JButton(Constant.messages.getString("spider.toolbar.button.new"));
            this.scanButton.setIcon(DisplayUtils.getScaledIcon(new ImageIcon(SpiderPanel.class.getResource("/resource/icon/16/spider.png"))));
            this.scanButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpiderPanel.this.extension.showSpiderDialog(SpiderPanel.this.getSiteTreeTarget());
                }
            });
        }
        return this.scanButton;
    }

    @Override
    protected int getNumberOfScansToShow() {
        return this.extension.getSpiderParam().getMaxScansInUI();
    }

    private SiteNode getSiteTreeTarget() {
        if (!this.extension.getView().getSiteTreePanel().getTreeSite().isSelectionEmpty()) {
            return (SiteNode)this.extension.getView().getSiteTreePanel().getTreeSite().getSelectionPath().getLastPathComponent();
        }
        return null;
    }

    private static class ProcessedCellItemIconHighlighter
    extends AbstractTableCellItemIconHighlighter {
        private static final ImageIcon PROCESSED_ICON = new ImageIcon(SpiderPanelTableModel.class.getResource("/resource/icon/16/152.png"));
        private static final ImageIcon NOT_PROCESSED_ICON = new ImageIcon(SpiderPanelTableModel.class.getResource("/resource/icon/16/149.png"));

        public ProcessedCellItemIconHighlighter(int columnIndex) {
            super(columnIndex);
        }

        @Override
        protected Icon getIcon(Object cellItem) {
            return ProcessedCellItemIconHighlighter.getProcessedIcon((Boolean)cellItem);
        }

        private static Icon getProcessedIcon(boolean processed) {
            return processed ? PROCESSED_ICON : NOT_PROCESSED_ICON;
        }

        @Override
        protected boolean isHighlighted(Object cellItem) {
            return true;
        }
    }
}

