/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.socket.jdk8;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetBoundException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.ice4j.socket.DatagramPacketFilter;
import org.ice4j.socket.jdk8.DelegatingServerSocketChannel;
import org.ice4j.socket.jdk8.MuxServerSocket;
import org.ice4j.socket.jdk8.MuxingServerSocket;
import org.ice4j.socket.jdk8.MuxingServerSocketChannel;
import org.ice4j.socket.jdk8.PreReadSocketChannel;
import org.ice4j.socket.jdk8.Timestamped;

public class MuxServerSocketChannel
extends DelegatingServerSocketChannel<MuxingServerSocketChannel> {
    private final Queue<Timestamped<SocketChannel>> acceptQ = new LinkedList<Timestamped<SocketChannel>>();
    protected final DatagramPacketFilter filter;
    private final Object syncRoot = new Object();

    public static <T> T assertIsNotNull(T t, String message) throws NullPointerException {
        if (t == null) {
            throw new NullPointerException(message);
        }
        return t;
    }

    public static MuxServerSocketChannel openAndBind(Map<String, Object> properties, SocketAddress endpoint, int backlog, DatagramPacketFilter filter) throws IOException {
        return MuxingServerSocketChannel.openAndBind(properties, endpoint, backlog, filter);
    }

    protected MuxServerSocketChannel(MuxingServerSocketChannel delegate, DatagramPacketFilter filter) {
        super((ServerSocketChannel)MuxServerSocketChannel.assertIsNotNull(delegate, "delegate"));
        this.filter = MuxServerSocketChannel.assertIsNotNull(filter, "filter");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SocketChannel accept() throws IOException {
        SocketChannel accepted = null;
        boolean interrupted = false;
        try {
            while (true) {
                if (!this.isOpen()) {
                    throw new ClosedChannelException();
                }
                if (!this.isBound()) {
                    throw new NotYetBoundException();
                }
                Object object = this.syncRoot;
                synchronized (object) {
                    Timestamped<SocketChannel> timestamped = this.acceptQ.poll();
                    if (timestamped == null) {
                        if (!this.isBlocking()) return accepted;
                        try {
                            this.syncRoot.wait();
                        }
                        catch (InterruptedException ie) {
                            interrupted = true;
                        }
                    } else {
                        accepted = (SocketChannel)timestamped.o;
                        if (accepted.isOpen() && (accepted = this.implAccept(accepted)) != null) {
                            return accepted;
                        }
                    }
                }
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeAbandonedSocketChannels(long now) {
        Object object = this.syncRoot;
        synchronized (object) {
            Queue<Timestamped<SocketChannel>> chs = this.acceptQ;
            if (!chs.isEmpty()) {
                Iterator i = chs.iterator();
                while (i.hasNext()) {
                    Timestamped ch = (Timestamped)i.next();
                    if (now - ch.timestamp < 15000L) continue;
                    i.remove();
                    MuxingServerSocketChannel.closeNoExceptions((Channel)ch.o);
                }
            }
        }
    }

    protected boolean filterAccept(DatagramPacket p, SocketChannel channel) {
        return this.filter.accept(p) && this.qAccept(new PreReadSocketChannel(p, channel));
    }

    @Override
    protected void implConfigureBlocking(boolean block) throws IOException {
        if (!block) {
            ((MuxingServerSocketChannel)this.delegate).configureBlocking(block);
        }
    }

    @Override
    protected MuxServerSocket implSocket(ServerSocket socket) throws IOException {
        return new MuxServerSocket((MuxingServerSocket)socket, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean qAccept(SocketChannel channel) {
        boolean b;
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.acceptQ.offer(new Timestamped<SocketChannel>(channel, System.currentTimeMillis()))) {
                this.syncRoot.notifyAll();
                b = true;
            } else {
                b = false;
            }
        }
        return b;
    }
}

