/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.appearance.plugin;

import java.awt.Dimension;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gephi.appearance.api.RankingFunction;
import org.gephi.appearance.plugin.RankingNodeSizeTransformer;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class RankingSizeTransformerPanel
extends JPanel {
    private RankingNodeSizeTransformer sizeTransformer;
    private JLabel labelMaxSize;
    private JLabel labelMinSize;
    private JSpinner maxSize;
    private JSpinner minSize;

    public RankingSizeTransformerPanel() {
        this.initComponents();
    }

    public void setup(RankingFunction function) {
        this.sizeTransformer = (RankingNodeSizeTransformer)function.getTransformer();
        final String MIN_SIZE = "RankingSizeTransformerPanel_" + this.sizeTransformer.getClass().getSimpleName() + "_min";
        final String MAX_SIZE = "RankingSizeTransformerPanel_" + this.sizeTransformer.getClass().getSimpleName() + "_max";
        float minSizeStart = NbPreferences.forModule(RankingSizeTransformerPanel.class).getFloat(MIN_SIZE, this.sizeTransformer.getMinSize());
        float maxSizeStart = NbPreferences.forModule(RankingSizeTransformerPanel.class).getFloat(MAX_SIZE, this.sizeTransformer.getMaxSize());
        this.sizeTransformer.setMinSize(minSizeStart);
        this.sizeTransformer.setMaxSize(maxSizeStart);
        this.minSize.setValue(Float.valueOf(minSizeStart));
        this.maxSize.setValue(Float.valueOf(maxSizeStart));
        this.minSize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RankingSizeTransformerPanel.this.sizeTransformer.setMinSize(((Float)RankingSizeTransformerPanel.this.minSize.getValue()).floatValue());
                NbPreferences.forModule(RankingSizeTransformerPanel.class).putFloat(MIN_SIZE, ((Float)RankingSizeTransformerPanel.this.minSize.getValue()).floatValue());
            }
        });
        this.maxSize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RankingSizeTransformerPanel.this.sizeTransformer.setMaxSize(((Float)RankingSizeTransformerPanel.this.maxSize.getValue()).floatValue());
                NbPreferences.forModule(RankingSizeTransformerPanel.class).putFloat(MAX_SIZE, ((Float)RankingSizeTransformerPanel.this.maxSize.getValue()).floatValue());
            }
        });
    }

    private void initComponents() {
        this.labelMinSize = new JLabel();
        this.minSize = new JSpinner();
        this.labelMaxSize = new JLabel();
        this.maxSize = new JSpinner();
        this.setPreferredSize(new Dimension(225, 114));
        this.labelMinSize.setText(NbBundle.getMessage(RankingSizeTransformerPanel.class, (String)"RankingSizeTransformerPanel.labelMinSize.text"));
        this.minSize.setModel(new SpinnerNumberModel(Float.valueOf(1.0f), Float.valueOf(0.1f), null, Float.valueOf(0.5f)));
        this.labelMaxSize.setText(NbBundle.getMessage(RankingSizeTransformerPanel.class, (String)"RankingSizeTransformerPanel.labelMaxSize.text"));
        this.maxSize.setModel(new SpinnerNumberModel(Float.valueOf(4.0f), Float.valueOf(0.5f), null, Float.valueOf(0.5f)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.labelMinSize).addGap(8, 8, 8).addComponent(this.minSize, -2, 50, -2).addGap(18, 18, 18).addComponent(this.labelMaxSize).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxSize, -2, 50, -2).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minSize, -2, -1, -2).addComponent(this.maxSize, -2, -1, -2).addComponent(this.labelMaxSize).addComponent(this.labelMinSize)).addContainerGap(80, Short.MAX_VALUE)));
    }
}

