/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.profile;

import tim.prune.I18nManager;
import tim.prune.data.DataPoint;
import tim.prune.data.Track;
import tim.prune.data.UnitSet;
import tim.prune.gui.profile.ProfileData;

public class AltitudeData
extends ProfileData {
    public AltitudeData(Track track) {
        super(track);
    }

    @Override
    public void init(UnitSet unitSet) {
        this.setUnitSet(unitSet);
        this.initArrays();
        this._hasData = false;
        double d = this._unitSet.getAltitudeUnit().getMultFactorFromStd();
        if (this._track != null) {
            try {
                int n = 0;
                while (n < this._track.getNumPoints()) {
                    DataPoint dataPoint = this._track.getPoint(n);
                    if (dataPoint != null && dataPoint.hasAltitude()) {
                        double d2;
                        this._pointValues[n] = d2 = dataPoint.getAltitude().getMetricValue() * d;
                        if (d2 < this._minValue || !this._hasData) {
                            this._minValue = d2;
                        }
                        if (d2 > this._maxValue || !this._hasData) {
                            this._maxValue = d2;
                        }
                        this._hasData = this._hasData || dataPoint.getAltitude().getValue() != 0;
                        this._pointHasData[n] = true;
                    } else {
                        this._pointHasData[n] = false;
                    }
                    ++n;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getLabel() {
        return String.valueOf(I18nManager.getText("fieldname.altitude")) + " (" + I18nManager.getText(this._unitSet.getAltitudeUnit().getShortnameKey()) + ")";
    }

    @Override
    public String getNoDataKey() {
        return "display.noaltitudes";
    }
}

