/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.util;

public abstract class Cancellable
implements Runnable {
    private boolean done = false;
    private Thread thread;
    private Throwable throwable;

    protected Cancellable() {
    }

    protected abstract void perform() throws Throwable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.perform();
            Cancellable cancellable = this;
            synchronized (cancellable) {
                this.done = true;
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (ThreadDeath re) {
        }
        catch (Throwable t) {
            this.throwable = t;
        }
    }

    public boolean isDone() {
        return this.done;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(int timeout) {
        boolean kill;
        this.thread = new Thread(this);
        this.thread.start();
        try {
            this.thread.join(timeout);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        Cancellable cancellable = this;
        synchronized (cancellable) {
            kill = !this.done;
        }
        if (kill) {
            this.thread.stop();
        }
    }
}

