/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.compression;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.media.j3d.CompressedGeometry;
import javax.media.j3d.CompressedGeometryHeader;

public class CompressedGeometryFile {
    private static final boolean print = false;
    private static final boolean benchmark = false;
    static final int MAGIC_NUMBER = -1159857484;
    static final int MAGIC_NUMBER_OFFSET = 0;
    static final int MAJOR_VERSION_OFFSET = 4;
    static final int MINOR_VERSION_OFFSET = 8;
    static final int MINOR_MINOR_VERSION_OFFSET = 12;
    static final int OBJECT_COUNT_OFFSET = 16;
    static final int DIRECTORY_OFFSET_OFFSET = 24;
    static final int HEADER_SIZE = 32;
    static final int OBJECT_SIZE_OFFSET = 0;
    static final int GEOM_DATA_OFFSET = 4;
    static final int TYPE_MASK = 3;
    static final int NORMAL_PRESENT_MASK = 4;
    static final int COLOR_PRESENT_MASK = 8;
    static final int ALPHA_PRESENT_MASK = 16;
    static final int TYPE_POINT = 1;
    static final int TYPE_LINE = 2;
    static final int TYPE_TRIANGLE = 3;
    static final int BLOCK_HEADER_SIZE = 8;
    String fileName = null;
    int majorVersionNumber;
    int minorVersionNumber;
    int minorMinorVersionNumber;
    int objectCount;
    int objectIndex = 0;
    RandomAccessFile cgFile = null;
    int magicNumber;
    byte[] cgBuffer;
    int geomSize;
    int geomStart;
    int geomDataType;
    long[] directory;
    long directoryOffset;
    int[] objectSizes;
    int bufferObjectStart;
    int bufferObjectCount;
    int bufferNextObjectCount;
    int bufferNextObjectOffset;
    CompressedGeometryHeader cgh;
    boolean fileUpdate = false;

    public CompressedGeometryFile(String string) throws IOException {
        this(string, false);
    }

    public CompressedGeometryFile(String string, boolean bl) throws IOException {
        this.open(string, bl);
        this.fileName = new String(string);
        this.initialize();
    }

    public CompressedGeometryFile(RandomAccessFile randomAccessFile) throws IOException {
        this.cgFile = randomAccessFile;
        this.initialize();
    }

    public void clear() throws IOException {
        this.cgFile.setLength(0L);
        this.initialize();
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getMajorVersionNumber() {
        return this.majorVersionNumber;
    }

    public int getMinorVersionNumber() {
        return this.minorVersionNumber;
    }

    public int getMinorMinorVersionNumber() {
        return this.minorMinorVersionNumber;
    }

    public int getObjectCount() {
        return this.objectCount;
    }

    public int getCurrentIndex() {
        if (this.objectIndex == this.objectCount) {
            return -1;
        }
        return this.objectIndex;
    }

    public CompressedGeometry readNext() throws IOException {
        return this.readNext(this.cgBuffer.length);
    }

    public CompressedGeometry[] read() throws IOException {
        long l = 0L;
        CompressedGeometry[] compressedGeometryArray = new CompressedGeometry[this.objectCount];
        this.objectIndex = 0;
        this.setFilePointer(this.directory[0]);
        this.bufferNextObjectCount = 0;
        for (int i = 0; i < this.objectCount; ++i) {
            compressedGeometryArray[i] = this.readNext(this.cgBuffer.length);
        }
        return compressedGeometryArray;
    }

    public CompressedGeometry read(int n) throws IOException {
        this.objectIndex = n;
        if (this.objectIndex < 0) {
            throw new IndexOutOfBoundsException("\nobject index must be >= 0");
        }
        if (this.objectIndex >= this.objectCount) {
            throw new IndexOutOfBoundsException("\nobject index must be < " + this.objectCount);
        }
        if (this.objectIndex >= this.bufferObjectStart && this.objectIndex < this.bufferObjectStart + this.bufferObjectCount) {
            this.bufferNextObjectOffset = (int)(this.directory[this.objectIndex] - this.directory[this.bufferObjectStart]);
            this.bufferNextObjectCount = this.bufferObjectCount - (this.objectIndex - this.bufferObjectStart);
            return this.readNext();
        }
        this.setFilePointer(this.directory[this.objectIndex]);
        this.bufferNextObjectCount = 0;
        return this.readNext(this.objectSizes[this.objectIndex]);
    }

    public void write(CompressedGeometry compressedGeometry) throws IOException {
        CompressedGeometryHeader compressedGeometryHeader = new CompressedGeometryHeader();
        compressedGeometry.getCompressedGeometryHeader(compressedGeometryHeader);
        if (compressedGeometryHeader.size + 8 > this.cgBuffer.length) {
            this.cgBuffer = new byte[compressedGeometryHeader.size + 8];
        }
        compressedGeometry.getCompressedGeometry(this.cgBuffer);
        this.write(compressedGeometryHeader, this.cgBuffer);
    }

    public void write(CompressedGeometryHeader compressedGeometryHeader, byte[] byArray) throws IOException {
        if (compressedGeometryHeader.size + 8 > this.cgBuffer.length) {
            this.cgBuffer = new byte[compressedGeometryHeader.size + 8];
        }
        if (compressedGeometryHeader.majorVersionNumber > this.majorVersionNumber || compressedGeometryHeader.majorVersionNumber == this.majorVersionNumber && compressedGeometryHeader.minorVersionNumber > this.minorVersionNumber || compressedGeometryHeader.majorVersionNumber == this.majorVersionNumber && compressedGeometryHeader.minorVersionNumber == this.minorVersionNumber && compressedGeometryHeader.minorMinorVersionNumber > this.minorMinorVersionNumber) {
            this.majorVersionNumber = compressedGeometryHeader.majorVersionNumber;
            this.minorVersionNumber = compressedGeometryHeader.minorVersionNumber;
            this.minorMinorVersionNumber = compressedGeometryHeader.minorMinorVersionNumber;
            this.cgh.majorVersionNumber = compressedGeometryHeader.majorVersionNumber;
            this.cgh.minorVersionNumber = compressedGeometryHeader.minorVersionNumber;
            this.cgh.minorMinorVersionNumber = compressedGeometryHeader.minorMinorVersionNumber;
        }
        int n = 0;
        switch (compressedGeometryHeader.bufferType) {
            case 0: {
                n = 1;
                break;
            }
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 3;
            }
        }
        if ((compressedGeometryHeader.bufferDataPresent & 1) != 0) {
            n |= 4;
        }
        if ((compressedGeometryHeader.bufferDataPresent & 2) != 0) {
            n |= 8;
        }
        if ((compressedGeometryHeader.bufferDataPresent & 4) != 0) {
            n |= 0x10;
        }
        if (this.objectCount == this.directory.length) {
            long[] lArray = new long[2 * this.objectCount];
            int[] nArray = new int[2 * this.objectCount];
            System.arraycopy(this.directory, 0, lArray, 0, this.objectCount);
            System.arraycopy(this.objectSizes, 0, nArray, 0, this.objectCount);
            this.directory = lArray;
            this.objectSizes = nArray;
        }
        this.directory[this.objectCount] = this.directoryOffset;
        this.objectSizes[this.objectCount] = compressedGeometryHeader.size + 8;
        ++this.objectCount;
        this.setFilePointer(this.directoryOffset);
        this.cgFile.writeInt(compressedGeometryHeader.size);
        this.cgFile.writeInt(n);
        this.cgFile.write(byArray, 0, compressedGeometryHeader.size);
        this.directoryOffset += (long)(compressedGeometryHeader.size + 8);
        this.objectIndex = this.objectCount;
        this.fileUpdate = true;
    }

    public void close() {
        if (this.cgFile != null) {
            try {
                if (this.fileUpdate) {
                    this.writeFileDirectory();
                    this.writeFileHeader();
                }
                this.cgFile.close();
            }
            catch (IOException iOException) {
                System.out.println("\nException: " + iOException.getMessage());
                System.out.println("failed to close " + this.fileName);
            }
        }
        this.cgFile = null;
        this.cgBuffer = null;
        this.directory = null;
        this.objectSizes = null;
    }

    void open(String string, boolean bl) throws FileNotFoundException, IOException {
        this.cgFile = null;
        String string2 = bl ? "rw" : "r";
        try {
            this.cgFile = new RandomAccessFile(string, string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FileNotFoundException(fileNotFoundException.getMessage() + "\n" + string + ": open mode " + string2 + " failed");
        }
    }

    void setFilePointer(long l) throws IOException {
        this.cgFile.seek(l);
        this.bufferNextObjectCount = 0;
    }

    void initialize() throws IOException {
        int n = 0;
        if (this.cgFile.length() == 0L) {
            this.objectCount = 0;
            this.cgBuffer = new byte[32768];
            this.directory = new long[16];
            this.objectSizes = new int[this.directory.length];
            this.magicNumber = -1159857484;
            this.majorVersionNumber = 1;
            this.minorVersionNumber = 0;
            this.minorMinorVersionNumber = 0;
            this.directoryOffset = 32L;
            this.writeFileHeader();
        } else {
            this.readFileHeader();
            if (this.magicNumber != -1159857484) {
                this.close();
                throw new IllegalArgumentException("\n" + this.fileName + " is not a compressed geometry file");
            }
            this.directory = new long[this.objectCount];
            this.readDirectory(this.directoryOffset, this.directory);
            this.objectSizes = new int[this.objectCount];
            for (int i = 0; i < this.objectCount - 1; ++i) {
                this.objectSizes[i] = (int)(this.directory[i + 1] - this.directory[i]);
                if (this.objectSizes[i] <= n) continue;
                n = this.objectSizes[i];
            }
            if (this.objectCount > 0) {
                this.objectSizes[this.objectCount - 1] = (int)(this.directoryOffset - this.directory[this.objectCount - 1]);
                if (this.objectSizes[this.objectCount - 1] > n) {
                    n = this.objectSizes[this.objectCount - 1];
                }
            }
            this.cgBuffer = new byte[n];
            this.setFilePointer(32L);
        }
        this.cgh = new CompressedGeometryHeader();
        this.cgh.majorVersionNumber = this.majorVersionNumber;
        this.cgh.minorVersionNumber = this.minorVersionNumber;
        this.cgh.minorMinorVersionNumber = this.minorMinorVersionNumber;
    }

    void readFileHeader() throws IOException {
        byte[] byArray = new byte[32];
        try {
            this.setFilePointer(0L);
            if (this.cgFile.read(byArray) != 32) {
                this.close();
                throw new IOException("failed header read");
            }
        }
        catch (IOException iOException) {
            if (this.cgFile != null) {
                this.close();
            }
            throw iOException;
        }
        this.magicNumber = (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        this.majorVersionNumber = (byArray[4] & 0xFF) << 24 | (byArray[5] & 0xFF) << 16 | (byArray[6] & 0xFF) << 8 | byArray[7] & 0xFF;
        this.minorVersionNumber = (byArray[8] & 0xFF) << 24 | (byArray[9] & 0xFF) << 16 | (byArray[10] & 0xFF) << 8 | byArray[11] & 0xFF;
        this.minorMinorVersionNumber = (byArray[12] & 0xFF) << 24 | (byArray[13] & 0xFF) << 16 | (byArray[14] & 0xFF) << 8 | byArray[15] & 0xFF;
        this.objectCount = (byArray[16] & 0xFF) << 24 | (byArray[17] & 0xFF) << 16 | (byArray[18] & 0xFF) << 8 | byArray[19] & 0xFF;
        this.directoryOffset = (long)(byArray[24] & 0xFF) << 56 | (long)(byArray[25] & 0xFF) << 48 | (long)(byArray[26] & 0xFF) << 40 | (long)(byArray[27] & 0xFF) << 32 | (long)(byArray[28] & 0xFF) << 24 | (long)(byArray[29] & 0xFF) << 16 | (long)(byArray[30] & 0xFF) << 8 | (long)(byArray[31] & 0xFF);
    }

    void writeFileHeader() throws IOException {
        this.setFilePointer(0L);
        try {
            this.cgFile.writeInt(-1159857484);
            this.cgFile.writeInt(this.majorVersionNumber);
            this.cgFile.writeInt(this.minorVersionNumber);
            this.cgFile.writeInt(this.minorMinorVersionNumber);
            this.cgFile.writeInt(this.objectCount);
            this.cgFile.writeInt(0);
            this.cgFile.writeLong(this.directoryOffset);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage() + "\ncould not write file header for " + this.fileName);
        }
    }

    void readDirectory(long l, long[] lArray) throws IOException {
        byte[] byArray = new byte[lArray.length * 8];
        this.setFilePointer(l);
        try {
            this.cgFile.read(byArray);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage() + "\nfailed to read " + byArray.length + " byte directory, offset " + l + " in file " + this.fileName);
        }
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = (long)(byArray[i * 8 + 0] & 0xFF) << 56 | (long)(byArray[i * 8 + 1] & 0xFF) << 48 | (long)(byArray[i * 8 + 2] & 0xFF) << 40 | (long)(byArray[i * 8 + 3] & 0xFF) << 32 | (long)(byArray[i * 8 + 4] & 0xFF) << 24 | (long)(byArray[i * 8 + 5] & 0xFF) << 16 | (long)(byArray[i * 8 + 6] & 0xFF) << 8 | (long)(byArray[i * 8 + 7] & 0xFF);
        }
    }

    void writeFileDirectory() throws IOException {
        this.setFilePointer(this.directoryOffset);
        int n = (int)(this.directoryOffset % 8L);
        if (n != 0) {
            byte[] byArray = new byte[8 - n];
            try {
                this.cgFile.write(byArray);
            }
            catch (IOException iOException) {
                throw new IOException(iOException.getMessage() + "\ncould not write " + n + " bytes to long word align directory for " + this.fileName);
            }
            this.directoryOffset += (long)(8 - n);
        }
        try {
            for (int i = 0; i < this.objectCount; ++i) {
                this.cgFile.writeLong(this.directory[i]);
            }
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage() + "\ncould not write directory for " + this.fileName);
        }
    }

    CompressedGeometry readNext(int n) throws IOException {
        if (this.objectIndex == this.objectCount) {
            return null;
        }
        if (this.bufferNextObjectCount == 0) {
            int n2;
            int n3 = 0;
            this.bufferObjectCount = 0;
            for (n2 = this.objectIndex; n2 < this.objectCount && n3 + this.objectSizes[n2] <= n; ++n2) {
                n3 += this.objectSizes[n2];
                ++this.bufferObjectCount;
            }
            try {
                n2 = this.cgFile.read(this.cgBuffer, 0, n3);
            }
            catch (IOException iOException) {
                throw new IOException(iOException.getMessage() + "\nfailed to read " + n3 + " bytes, object " + this.objectIndex + " in file " + this.fileName);
            }
            this.bufferObjectStart = this.objectIndex;
            this.bufferNextObjectCount = this.bufferObjectCount;
            this.bufferNextObjectOffset = 0;
        }
        this.geomSize = (this.cgBuffer[this.bufferNextObjectOffset + 0 + 0] & 0xFF) << 24 | (this.cgBuffer[this.bufferNextObjectOffset + 0 + 1] & 0xFF) << 16 | (this.cgBuffer[this.bufferNextObjectOffset + 0 + 2] & 0xFF) << 8 | this.cgBuffer[this.bufferNextObjectOffset + 0 + 3] & 0xFF;
        this.geomDataType = (this.cgBuffer[this.bufferNextObjectOffset + 4 + 0] & 0xFF) << 24 | (this.cgBuffer[this.bufferNextObjectOffset + 4 + 1] & 0xFF) << 16 | (this.cgBuffer[this.bufferNextObjectOffset + 4 + 2] & 0xFF) << 8 | this.cgBuffer[this.bufferNextObjectOffset + 4 + 3] & 0xFF;
        this.geomStart = this.bufferNextObjectOffset + 8;
        this.bufferNextObjectOffset += this.objectSizes[this.objectIndex];
        --this.bufferNextObjectCount;
        ++this.objectIndex;
        return this.newCG(this.geomSize, this.geomStart, this.geomDataType);
    }

    CompressedGeometry newCG(int n, int n2, int n3) {
        this.cgh.size = n;
        this.cgh.start = n2;
        if ((n3 & 3) == 1) {
            this.cgh.bufferType = 0;
        } else if ((n3 & 3) == 2) {
            this.cgh.bufferType = 1;
        } else if ((n3 & 3) == 3) {
            this.cgh.bufferType = 2;
        }
        this.cgh.bufferDataPresent = 0;
        if ((n3 & 4) != 0) {
            this.cgh.bufferDataPresent |= 1;
        }
        if ((n3 & 8) != 0) {
            this.cgh.bufferDataPresent |= 2;
        }
        if ((n3 & 0x10) != 0) {
            this.cgh.bufferDataPresent |= 4;
        }
        return new CompressedGeometry(this.cgh, this.cgBuffer);
    }

    protected void finalize() {
        this.close();
    }
}

