/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.jdbc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.classfile.ClassRepository;
import org.netbeans.lib.profiler.classfile.DynamicClassInfo;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.filters.InstrumentationFilter;
import org.netbeans.lib.profiler.filters.TextFilter;
import org.netbeans.lib.profiler.results.BaseCallGraphBuilder;
import org.netbeans.lib.profiler.results.RuntimeCCTNode;
import org.netbeans.lib.profiler.results.RuntimeCCTNodeProcessor;
import org.netbeans.lib.profiler.results.cpu.CPUProfilingResultListener;
import org.netbeans.lib.profiler.results.cpu.FlatProfileContainer;
import org.netbeans.lib.profiler.results.cpu.FlatProfileContainerFree;
import org.netbeans.lib.profiler.results.cpu.ThreadInfo;
import org.netbeans.lib.profiler.results.cpu.ThreadInfos;
import org.netbeans.lib.profiler.results.cpu.cct.CCTFlattener;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.MethodCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.SimpleCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.ThreadCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.TimedCPUCCTNode;
import org.netbeans.lib.profiler.results.jdbc.JdbcCCTProvider;
import org.netbeans.lib.profiler.results.jdbc.SQLConnection;
import org.netbeans.lib.profiler.results.jdbc.SQLParser;
import org.netbeans.lib.profiler.results.jdbc.SQLStatement;
import org.netbeans.lib.profiler.results.memory.JMethodIdTable;
import org.netbeans.lib.profiler.results.memory.PresoObjAllocCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeMemoryCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeObjAllocTermCCTNode;

public class JdbcGraphBuilder
extends BaseCallGraphBuilder
implements CPUProfilingResultListener,
JdbcCCTProvider {
    static final Logger JDBC_LOGGER = Logger.getLogger(JdbcGraphBuilder.class.getName());
    private Map statements;
    private Map connections;
    private Map<Select, Integer> selectsToId;
    private Map<Integer, Select> idsToSelect;
    private Map<ThreadInfo, SQLStatement> currentObject;
    private Map<ThreadInfo, Integer> currentSqlLevel;
    private int lastSelectId;
    private RuntimeMemoryCCTNode[] stacksForSelects;
    private final ThreadInfos threadInfos = new ThreadInfos();
    private final SQLParser sqlParser = new SQLParser();
    private TextFilter filter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected RuntimeCCTNode getAppRootNode() {
        if (this.threadInfos.isEmpty()) {
            return null;
        }
        SimpleCPUCCTNode simpleCPUCCTNode = null;
        this.beginTrans(false);
        try {
            ProfilerClient profilerClient = this.getClient();
            simpleCPUCCTNode = profilerClient != null ? new SimpleCPUCCTNode(this.lastSelectId + 1) : new SimpleCPUCCTNode(true);
            int n = this.threadInfos.getThreadNames() != null ? this.threadInfos.getThreadNames().length : 0;
            for (int i = 0; i < n; ++i) {
                ThreadInfo threadInfo = this.threadInfos.threadInfos[i];
                if (threadInfo == null || threadInfo.stack[0] == null) continue;
                simpleCPUCCTNode.attachNodeAsChild(threadInfo.stack[0]);
            }
        }
        finally {
            this.endTrans();
        }
        return simpleCPUCCTNode;
    }

    @Override
    public RuntimeMemoryCCTNode[] getStacksForSelects() {
        this.beginTrans(false);
        try {
            RuntimeMemoryCCTNode[] runtimeMemoryCCTNodeArray = this.stacksForSelects;
            return runtimeMemoryCCTNodeArray;
        }
        finally {
            this.endTrans();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FlatProfileContainer createFlatProfile() {
        this.beginTrans(false);
        try {
            RuntimeCCTNode runtimeCCTNode = this.getAppRootNode();
            if (runtimeCCTNode != null) {
                JdbcCCTFlattener jdbcCCTFlattener = new JdbcCCTFlattener(this.getClient());
                RuntimeCCTNodeProcessor.process(runtimeCCTNode, jdbcCCTFlattener);
                FlatProfileContainer flatProfileContainer = jdbcCCTFlattener.getFlatProfile();
                return flatProfileContainer;
            }
            FlatProfileContainer flatProfileContainer = null;
            return flatProfileContainer;
        }
        finally {
            this.endTrans();
        }
    }

    @Override
    protected void doBatchStart() {
        this.beginTrans(true);
    }

    @Override
    protected void doBatchStop() {
        this.endTrans();
    }

    @Override
    protected void doReset() {
        this.beginTrans(true);
        try {
            this.threadInfos.reset();
            this.selectsToId.clear();
            this.idsToSelect.clear();
            this.currentObject.clear();
            this.currentSqlLevel.clear();
            this.lastSelectId = 0;
            if (this.stacksForSelects != null) {
                Arrays.fill(this.stacksForSelects, null);
            }
        }
        finally {
            this.endTrans();
        }
    }

    @Override
    protected void doShutdown() {
        this.statements = null;
        this.connections = null;
        this.selectsToId = null;
        this.idsToSelect = null;
        this.currentObject = null;
        this.currentSqlLevel = null;
        this.stacksForSelects = null;
    }

    @Override
    protected void doStartup(ProfilerClient profilerClient) {
        this.statements = new HashMap();
        this.connections = new HashMap();
        this.selectsToId = new HashMap<Select, Integer>();
        this.idsToSelect = new HashMap<Integer, Select>();
        this.currentObject = new HashMap<ThreadInfo, SQLStatement>();
        this.currentSqlLevel = new HashMap<ThreadInfo, Integer>();
        this.threadInfos.reset();
        this.stacksForSelects = null;
        this.lastSelectId = 0;
        profilerClient.registerJdbcCCTProvider(this);
        InstrumentationFilter instrumentationFilter = profilerClient.getSettings().getInstrumentationFilter();
        this.filter = new TextFilter(instrumentationFilter.getValue(), instrumentationFilter.getType(), false);
    }

    @Override
    public void profilingPoint(int n, int n2, long l) {
    }

    @Override
    public void methodEntry(int n, int n2, int n3, long l, long l2, List list, int[] nArray) {
        if (n3 == 3) {
            String string;
            if (this.threadInfos.threadInfos == null) {
                return;
            }
            ThreadInfo threadInfo = this.threadInfos.threadInfos[n2];
            if (threadInfo == null) {
                return;
            }
            int n4 = this.incrementSqlLevel(threadInfo);
            if (JDBC_LOGGER.isLoggable(Level.FINEST)) {
                string = this.status.getInstrMethodClasses()[n];
                String string2 = this.status.getInstrMethodNames()[n];
                JDBC_LOGGER.log(Level.FINEST, "markerMethodEntry, mId = {0}, {1}.{2}{3}", new Object[]{n, string, string2, list.toString()});
            }
            if (n4 > 1) {
                if (threadInfo.peek() instanceof MethodCPUCCTNode) {
                    this.markerMethodEntry(-1, threadInfo, l, l2, true);
                    this.batchNotEmpty = true;
                }
                return;
            }
            if (JDBC_LOGGER.isLoggable(Level.FINEST) && nArray != null) {
                this.debugStackTrace(nArray);
            }
            if (this.hasThis(n)) {
                Object object;
                string = (String)list.get(0);
                int n5 = string.indexOf(64);
                String string3 = string.substring(0, n5);
                String string4 = string.substring(n5 + 1);
                if (this.implementsInterface(string3, STATEMENT_INTERFACE)) {
                    String string5;
                    object = (SQLStatement)this.statements.get(string4);
                    if (object == null) {
                        object = new SQLStatement(-1);
                        this.statements.put(string4, object);
                    }
                    if ((string5 = ((SQLStatement)object).invoke(this.status.getInstrMethodNames()[n], this.status.getInstrMethodSignatures()[n], list)) != null && this.filter.passes(string5)) {
                        int n6 = this.getSelectId(((SQLStatement)object).getType(), string5);
                        this.markerMethodEntry(n6, threadInfo, l, l2, true);
                        RuntimeObjAllocTermCCTNode runtimeObjAllocTermCCTNode = (RuntimeObjAllocTermCCTNode)this.processStackTrace(n6, nArray);
                        if (runtimeObjAllocTermCCTNode != null) {
                            runtimeObjAllocTermCCTNode.updateForNewObject(0L);
                        }
                        this.batchNotEmpty = true;
                    }
                }
                if (this.implementsInterface(string3, CONNECTION_INTERFACE)) {
                    object = (SQLConnection)this.connections.get(string4);
                    if (object == null) {
                        object = new SQLConnection();
                        this.connections.put(string4, object);
                    }
                    ((SQLConnection)object).invoke(this.status.getInstrMethodNames()[n], this.status.getInstrMethodSignatures()[n], list);
                    assert (this.currentObject.get(threadInfo) == null);
                    this.currentObject.put(threadInfo, ((SQLConnection)object).useCurrentStatement());
                }
            }
        }
    }

    @Override
    public void methodEntryUnstamped(int n, int n2, int n3, List list, int[] nArray) {
    }

    @Override
    public void methodExit(int n, int n2, int n3, long l, long l2, Object object) {
        if (n3 == 3) {
            if (this.status == null || this.threadInfos.threadInfos == null) {
                return;
            }
            ThreadInfo threadInfo = this.threadInfos.threadInfos[n2];
            if (threadInfo == null) {
                return;
            }
            int n4 = this.decrementSqlLevel(threadInfo);
            this.plainMethodExit(n, threadInfo, l, l2, true);
            if (n4 == 0) {
                SQLStatement sQLStatement = this.currentObject.get(threadInfo);
                if (sQLStatement != null && object instanceof String) {
                    String string = (String)object;
                    int n5 = string.indexOf(64);
                    String string2 = string.substring(0, n5);
                    String string3 = string.substring(n5 + 1);
                    if (this.implementsInterface(string2, STATEMENT_INTERFACE)) {
                        assert (sQLStatement != null);
                        this.statements.put(string3, sQLStatement);
                    }
                }
                this.currentObject.remove(threadInfo);
            }
            this.batchNotEmpty = true;
        }
    }

    @Override
    public void methodExitUnstamped(int n, int n2, int n3) {
    }

    @Override
    public void servletRequest(int n, int n2, String string, int n3) {
    }

    @Override
    public void sleepEntry(int n, long l, long l2) {
    }

    @Override
    public void sleepExit(int n, long l, long l2) {
    }

    @Override
    public void threadsResume(long l, long l2) {
    }

    @Override
    public void threadsSuspend(long l, long l2) {
    }

    @Override
    public void waitEntry(int n, long l, long l2) {
    }

    @Override
    public void waitExit(int n, long l, long l2) {
    }

    @Override
    public void parkEntry(int n, long l, long l2) {
    }

    @Override
    public void parkExit(int n, long l, long l2) {
    }

    @Override
    public void monitorEntry(int n, long l, long l2, int n2, int n3) {
    }

    @Override
    public void monitorExit(int n, long l, long l2, int n2) {
    }

    @Override
    public void newThread(int n, String string, String string2) {
        if (this.status == null) {
            return;
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "New thread creation for thread id = {0}, name = {1}", new Object[]{n, string});
        }
        this.threadInfos.newThreadInfo(n, string, string2);
    }

    @Override
    public void newMonitor(int n, String string) {
    }

    @Override
    public void timeAdjust(int n, long l, long l2) {
        if (this.status == null || this.threadInfos.threadInfos == null) {
            return;
        }
        ThreadInfo threadInfo = this.threadInfos.threadInfos[n];
        threadInfo.rootMethodEntryTimeAbs += l;
        threadInfo.rootMethodEntryTimeThreadCPU += l2;
        threadInfo.topMethodEntryTime0 += l;
        if (this.isCollectingTwoTimeStamps()) {
            threadInfo.topMethodEntryTime1 += l2;
        }
    }

    private boolean hasThis(int n) {
        String string = this.status.getInstrMethodNames()[n];
        if (string.equals("<init>")) {
            return false;
        }
        String string2 = this.status.getInstrMethodClasses()[n];
        String string3 = this.status.getInstrMethodSignatures()[n];
        int n2 = this.status.getClassLoaderIds()[n];
        try {
            DynamicClassInfo dynamicClassInfo = ClassRepository.lookupClass(string2, n2);
            int n3 = dynamicClassInfo.getMethodIndex(string, string3);
            return !dynamicClassInfo.isMethodStatic(n3);
        }
        catch (IOException iOException) {
            Logger.getLogger(JdbcGraphBuilder.class.getName()).log(Level.SEVERE, null, iOException);
        }
        catch (ClassFormatError classFormatError) {
            Logger.getLogger(JdbcGraphBuilder.class.getName()).log(Level.SEVERE, null, classFormatError);
        }
        return false;
    }

    private boolean implementsInterface(String string, String string2) {
        try {
            ArrayList arrayList;
            String string3 = string.replace('.', '/');
            DynamicClassInfo dynamicClassInfo = ClassRepository.lookupClass(string2, 0);
            if (dynamicClassInfo != null && (arrayList = dynamicClassInfo.getSubclasses()) != null) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    DynamicClassInfo dynamicClassInfo2 = (DynamicClassInfo)arrayList.get(i);
                    if (!dynamicClassInfo2.getName().equals(string3)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (IOException iOException) {
            Logger.getLogger(JdbcGraphBuilder.class.getName()).log(Level.SEVERE, null, iOException);
        }
        catch (ClassFormatError classFormatError) {
            Logger.getLogger(JdbcGraphBuilder.class.getName()).log(Level.SEVERE, null, classFormatError);
        }
        return false;
    }

    private int getSelectId(int n, String string) {
        Select select = new Select(n, string);
        Integer n2 = this.selectsToId.get(select);
        if (n2 == null) {
            n2 = ++this.lastSelectId;
            select.setCommandType(this.extractSQLCommandType(string));
            select.setTables(this.extractTables(string));
            this.selectsToId.put(select, n2);
            this.idsToSelect.put(n2, select);
            this.updateNumberOfSelects();
        }
        return n2;
    }

    private boolean isCollectingTwoTimeStamps() {
        return this.status.collectingTwoTimeStamps();
    }

    private TimedCPUCCTNode markerMethodEntry(int n, ThreadInfo threadInfo, long l, long l2, boolean bl) {
        TimedCPUCCTNode timedCPUCCTNode;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "MarkerMEntry{0} for tId = {1}, time: {2}, method:  {3}, inRoot: {4}, rootEntryTimeThread: {5}", new Object[]{!bl ? "(unstamped)" : "", threadInfo.threadId, l, this.debugSelect(n), threadInfo.rootMethodEntryTimeAbs, threadInfo.rootMethodEntryTimeThreadCPU});
        }
        if ((timedCPUCCTNode = threadInfo.peek()) == null) {
            ThreadCPUCCTNode threadCPUCCTNode = new ThreadCPUCCTNode(threadInfo.threadId);
            ++threadInfo.totalNNodes;
            threadInfo.push(threadCPUCCTNode);
            --threadInfo.totalNInv;
            timedCPUCCTNode = new MethodCPUCCTNode(n);
            threadCPUCCTNode.attachNodeAsChild(timedCPUCCTNode);
            ++threadInfo.totalNNodes;
            threadInfo.push(timedCPUCCTNode);
            threadInfo.topMethodEntryTime0 = l;
            if (this.isCollectingTwoTimeStamps()) {
                threadInfo.topMethodEntryTime1 = l2;
            }
        } else {
            MethodCPUCCTNode methodCPUCCTNode;
            if (bl) {
                long l3 = l - threadInfo.topMethodEntryTime0;
                if (l3 > 0L) {
                    timedCPUCCTNode.addNetTime0(l3);
                } else {
                    l = threadInfo.topMethodEntryTime0;
                }
                threadInfo.topMethodEntryTime0 = l;
                if (this.isCollectingTwoTimeStamps()) {
                    l3 = l2 - threadInfo.topMethodEntryTime1;
                    if (l3 > 0L) {
                        timedCPUCCTNode.addNetTime1(l3);
                    } else {
                        l2 = threadInfo.topMethodEntryTime1;
                    }
                    threadInfo.topMethodEntryTime1 = l2;
                }
            }
            if ((methodCPUCCTNode = MethodCPUCCTNode.Locator.locate(n, timedCPUCCTNode.getChildren())) == null) {
                methodCPUCCTNode = new MethodCPUCCTNode(n);
                timedCPUCCTNode.attachNodeAsChild(methodCPUCCTNode);
                ++threadInfo.totalNNodes;
            }
            threadInfo.push(methodCPUCCTNode);
            timedCPUCCTNode = methodCPUCCTNode;
        }
        if (n == -1) {
            timedCPUCCTNode.setFilteredStatus(2);
        }
        if (bl) {
            threadInfo.rootMethodEntryTimeAbs = l;
            threadInfo.rootMethodEntryTimeThreadCPU = l2;
            threadInfo.topMethodEntryTime0 = l;
            if (this.isCollectingTwoTimeStamps()) {
                threadInfo.topMethodEntryTime1 = l2;
            }
        }
        return timedCPUCCTNode;
    }

    private TimedCPUCCTNode plainMethodExit(int n, ThreadInfo threadInfo, long l, long l2, boolean bl) {
        TimedCPUCCTNode timedCPUCCTNode;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "MethodExit  {0}: for tId = {1}, time: {2}, method:  {3}", new Object[]{!bl ? "(unstamped)" : "", threadInfo.threadId, l, n});
        }
        if (!((timedCPUCCTNode = threadInfo.peek()) instanceof MethodCPUCCTNode)) {
            return null;
        }
        if (bl) {
            long l3 = l - threadInfo.topMethodEntryTime0;
            if (l3 > 0L) {
                timedCPUCCTNode.addNetTime0(l3);
            } else {
                l = threadInfo.topMethodEntryTime0;
            }
            if (this.isCollectingTwoTimeStamps()) {
                l3 = l2 - threadInfo.topMethodEntryTime1;
                if (l3 > 0L) {
                    timedCPUCCTNode.addNetTime1(l3);
                } else {
                    l2 = threadInfo.topMethodEntryTime1;
                }
            }
        }
        TimedCPUCCTNode timedCPUCCTNode2 = threadInfo.pop();
        if (bl) {
            threadInfo.topMethodEntryTime0 = l;
            if (this.isCollectingTwoTimeStamps()) {
                threadInfo.topMethodEntryTime1 = l2;
            }
        }
        return timedCPUCCTNode2;
    }

    private RuntimeMemoryCCTNode processStackTrace(int n, int[] nArray) {
        int n2;
        RuntimeMemoryCCTNode[] runtimeMemoryCCTNodeArray;
        if (n >= this.stacksForSelects.length) {
            LOGGER.severe("Received stack for non existent select Id: " + n + ", current length: " + this.stacksForSelects.length);
            return null;
        }
        Object object = this.stacksForSelects[n];
        Object object2 = null;
        if (object == null) {
            object = new RuntimeMemoryCCTNode(0);
            this.stacksForSelects[n] = object;
        }
        int n3 = nArray.length;
        int n4 = n3 - 1;
        for (int i = 0; i < n3; ++i) {
            Object object3;
            int n5;
            block14: {
                block15: {
                    n5 = nArray[i];
                    object2 = object;
                    runtimeMemoryCCTNodeArray = object.children;
                    n2 = 0;
                    if (runtimeMemoryCCTNodeArray == null) break block14;
                    if (!(runtimeMemoryCCTNodeArray instanceof RuntimeMemoryCCTNode)) break block15;
                    if (((RuntimeMemoryCCTNode)runtimeMemoryCCTNodeArray).methodId != n5) break block14;
                    object = (RuntimeMemoryCCTNode)runtimeMemoryCCTNodeArray;
                    n2 = 1;
                    break block14;
                }
                object3 = runtimeMemoryCCTNodeArray;
                for (int j = 0; j < ((RuntimeMemoryCCTNode[])object3).length; ++j) {
                    if (object3[j].methodId != n5) continue;
                    object = object3[j];
                    n2 = 1;
                    break;
                }
            }
            if (n2 != 0) continue;
            if (i < n4) {
                object = object.addNewChild(n5);
                continue;
            }
            object3 = new RuntimeObjAllocTermCCTNode(n5);
            object.attachNodeAsChild((RuntimeMemoryCCTNode)object3);
            object = object3;
        }
        if (object.getClass() == RuntimeMemoryCCTNode.class) {
            RuntimeObjAllocTermCCTNode runtimeObjAllocTermCCTNode = new RuntimeObjAllocTermCCTNode(object.methodId);
            runtimeObjAllocTermCCTNode.children = object.children;
            if (object2 != null) {
                Object object4 = object2.children;
                assert (object4 != null);
                if (object4 instanceof RuntimeMemoryCCTNode) {
                    if (object4 == object) {
                        object2.children = runtimeObjAllocTermCCTNode;
                    }
                } else {
                    runtimeMemoryCCTNodeArray = (RuntimeMemoryCCTNode[])object4;
                    for (n2 = 0; n2 < runtimeMemoryCCTNodeArray.length; ++n2) {
                        if (runtimeMemoryCCTNodeArray[n2] != object) continue;
                        runtimeMemoryCCTNodeArray[n2] = runtimeObjAllocTermCCTNode;
                        break;
                    }
                }
            } else {
                this.stacksForSelects[n] = runtimeObjAllocTermCCTNode;
            }
            object = runtimeObjAllocTermCCTNode;
        }
        return object;
    }

    private void updateNumberOfSelects() {
        int n = this.lastSelectId + 1;
        if (this.stacksForSelects == null || this.stacksForSelects.length <= n) {
            int n2 = n * 3 / 2;
            RuntimeMemoryCCTNode[] runtimeMemoryCCTNodeArray = new RuntimeMemoryCCTNode[n2];
            if (this.stacksForSelects != null) {
                System.arraycopy(this.stacksForSelects, 0, runtimeMemoryCCTNodeArray, 0, this.stacksForSelects.length);
            }
            this.stacksForSelects = runtimeMemoryCCTNodeArray;
        }
    }

    private String debugSelect(int n) {
        if (n == -1) {
            return "-1";
        }
        Select select = this.idsToSelect.get(n);
        if (select == null) {
            return "Null select for SelectId " + n;
        }
        return select.getSelect();
    }

    private void debugStackTrace(int[] nArray) {
        int n;
        JMethodIdTable jMethodIdTable = JMethodIdTable.getDefault();
        for (n = 0; n < nArray.length; ++n) {
            jMethodIdTable.checkMethodId(nArray[n]);
        }
        try {
            jMethodIdTable.getNamesForMethodIds(this.getClient());
            for (n = 0; n < nArray.length; ++n) {
                JMethodIdTable.JMethodIdTableEntry jMethodIdTableEntry = jMethodIdTable.getEntry(nArray[n]);
                JDBC_LOGGER.log(Level.FINEST, "{0}.{1}", new Object[]{jMethodIdTableEntry.className, jMethodIdTableEntry.methodName});
            }
        }
        catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
            Logger.getLogger(JdbcGraphBuilder.class.getName()).log(Level.SEVERE, null, targetAppOrVMTerminated);
        }
    }

    int extractSQLCommandType(String string) {
        return this.sqlParser.extractSQLCommandType(string);
    }

    String[] extractTables(String string) {
        return this.sqlParser.extractTables(string);
    }

    @Override
    public void beginTrans(boolean bl) {
        this.threadInfos.beginTrans(bl);
    }

    @Override
    public void endTrans() {
        this.threadInfos.endTrans();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateInternals() {
        ProfilerClient profilerClient = this.getClient();
        if (profilerClient != null) {
            ProfilerClient profilerClient2 = profilerClient;
            synchronized (profilerClient2) {
                this.beginTrans(false);
                try {
                    PresoObjAllocCCTNode.getNamesForMethodIdsFromVM(profilerClient, this.stacksForSelects);
                }
                catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                    ProfilerLogger.log(targetAppOrVMTerminated.getMessage());
                }
                finally {
                    this.endTrans();
                }
            }
        }
    }

    @Override
    public int getCommandType(int n) {
        Select select = this.idsToSelect.get(n);
        if (select != null) {
            return select.getType();
        }
        return -1;
    }

    @Override
    public int getSQLCommand(int n) {
        Select select = this.idsToSelect.get(n);
        if (select != null) {
            return select.getCommandType();
        }
        return -1;
    }

    @Override
    public String[] getTables(int n) {
        Select select = this.idsToSelect.get(n);
        if (select != null) {
            return select.getTables();
        }
        return new String[0];
    }

    private int incrementSqlLevel(ThreadInfo threadInfo) {
        Integer n = this.currentSqlLevel.get(threadInfo);
        n = n == null ? Integer.valueOf(1) : Integer.valueOf(n + 1);
        this.currentSqlLevel.put(threadInfo, n);
        return n;
    }

    private int decrementSqlLevel(ThreadInfo threadInfo) {
        Integer n = this.currentSqlLevel.get(threadInfo);
        assert (n != null);
        n = n - 1;
        this.currentSqlLevel.put(threadInfo, n);
        return n;
    }

    private static class Select {
        private final int type;
        private int commandType;
        private final String select;
        private String[] tables;

        Select(int n, String string) {
            this.type = n;
            this.select = string;
        }

        private int getType() {
            return this.type;
        }

        private void setCommandType(int n) {
            this.commandType = n;
        }

        private void setTables(String[] stringArray) {
            this.tables = stringArray;
        }

        private int getCommandType() {
            return this.commandType;
        }

        public String[] getTables() {
            return this.tables;
        }

        private String getSelect() {
            return this.select;
        }

        public int hashCode() {
            return this.type ^ this.select.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Select select = (Select)object;
            if (this.type != select.type) {
                return false;
            }
            return Objects.equals(this.select, select.select);
        }
    }

    private class JdbcFlatProfileContainer
    extends FlatProfileContainerFree {
        private JdbcFlatProfileContainer(long[] lArray, long[] lArray2, long[] lArray3, long[] lArray4, int[] nArray, double d, double d2) {
            super(JdbcGraphBuilder.this.getClient().getStatus(), lArray, lArray2, lArray3, lArray4, nArray, new char[0], d, d2, nArray.length);
        }

        @Override
        public String getMethodNameAtRow(int n) {
            int n2 = this.getMethodIdAtRow(n);
            return ((Select)JdbcGraphBuilder.this.idsToSelect.get(n2)).getSelect();
        }
    }

    private class JdbcCCTFlattener
    extends CCTFlattener {
        public JdbcCCTFlattener(ProfilerClient profilerClient) {
            super(profilerClient, null);
        }

        @Override
        protected int getMaxMethodId() {
            return JdbcGraphBuilder.this.lastSelectId + 1;
        }

        @Override
        protected String getInstrMethodClass(int n) {
            Select select = (Select)JdbcGraphBuilder.this.idsToSelect.get(n);
            if (select == null) {
                return "Unknown select for selectId " + n;
            }
            return select.getSelect();
        }

        @Override
        protected String getInstrMethodName(int n) {
            return "";
        }

        @Override
        protected FlatProfileContainer createContainer(long[] lArray, long[] lArray2, long[] lArray3, long[] lArray4, int[] nArray, double d, double d2) {
            return new JdbcFlatProfileContainer(lArray, lArray2, lArray3, lArray4, nArray, d, d2);
        }
    }
}

