/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.netbeans.core.windows.Central;
import org.netbeans.core.windows.FloatingWindowTransparencyManager;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.PersistenceHandler;
import org.netbeans.core.windows.RecentViewList;
import org.netbeans.core.windows.RegistryImpl;
import org.netbeans.core.windows.SplitConstraint;
import org.netbeans.core.windows.Switches;
import org.netbeans.core.windows.TopComponentGroupImpl;
import org.netbeans.core.windows.TopComponentTracker;
import org.netbeans.core.windows.WindowSystemEventType;
import org.netbeans.core.windows.WindowSystemImpl;
import org.netbeans.core.windows.actions.ActionUtils;
import org.netbeans.core.windows.options.WinSysPrefs;
import org.netbeans.core.windows.persistence.PersistenceManager;
import org.netbeans.core.windows.persistence.PersistenceObserver;
import org.netbeans.core.windows.view.dnd.TopComponentDraggable;
import org.netbeans.core.windows.view.ui.MainWindow;
import org.netbeans.swing.tabcontrol.plaf.BusyTabsSupport;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.Mode;
import org.openide.windows.ModeSelector;
import org.openide.windows.TopComponent;
import org.openide.windows.TopComponentGroup;
import org.openide.windows.WindowManager;
import org.openide.windows.WindowSystemEvent;
import org.openide.windows.WindowSystemListener;
import org.openide.windows.Workspace;

public final class WindowManagerImpl
extends WindowManager
implements Workspace {
    public static final String PROP_ACTIVE_MODE = "activeMode";
    public static final String PROP_MAXIMIZED_MODE = "maximizedMode";
    public static final String PROP_EDITOR_AREA_STATE = "editorAreaState";
    private static final Object LOCK_INIT = new Object();
    private static WindowManagerImpl defaultInstance;
    static boolean assertsEnabled;
    private final Central central = new Central();
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport((Object)this);
    private final RecentViewList recentViewList = new RecentViewList(this);
    private TopComponent persistenceShowingTC;
    private Exclusive exclusive;
    private boolean exclusivesCompleted = false;
    private Throwable createdBy;
    private final Collection<WindowSystemListener> listeners = new ArrayList<WindowSystemListener>(10);
    private static final String ASSERTION_ERROR_MESSAGE = "Window System API is required to be called from AWT thread only, see http://core.netbeans.org/proposals/threading/";
    private String currentRole = null;
    private static final Object BUSY_FLAG;
    private static final String BUSY_PROP_NAME = "nbwinsys.tc.isbusy";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WindowManagerImpl() {
        Object object = LOCK_INIT;
        synchronized (object) {
            if (defaultInstance != null) {
                IllegalStateException illegalStateException = new IllegalStateException("Instance already exists");
                if (WindowManagerImpl.defaultInstance.createdBy != null) {
                    illegalStateException.initCause(WindowManagerImpl.defaultInstance.createdBy);
                }
                throw illegalStateException;
            }
            boolean bl = false;
            if (!$assertionsDisabled) {
                bl = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            if (bl) {
                this.createdBy = new Exception("createdBy");
            }
            defaultInstance = this;
        }
        this.busyIconWarmUp();
    }

    public static WindowManagerImpl getInstance() {
        if (defaultInstance != null) {
            return defaultInstance;
        }
        return (WindowManagerImpl)((Object)Lookup.getDefault().lookup(WindowManager.class));
    }

    public void topComponentRequestAttention(TopComponent topComponent) {
        if (topComponent.isOpened()) {
            ModeImpl modeImpl = (ModeImpl)this.findMode(topComponent);
            this.central.topComponentRequestAttention(modeImpl, topComponent);
        }
    }

    public void topComponentCancelRequestAttention(TopComponent topComponent) {
        if (topComponent.isOpened()) {
            ModeImpl modeImpl = (ModeImpl)this.findMode(topComponent);
            this.central.topComponentCancelRequestAttention(modeImpl, topComponent);
        }
    }

    public void topComponentAttentionHighlight(TopComponent topComponent, boolean bl) {
        if (topComponent.isOpened()) {
            ModeImpl modeImpl = (ModeImpl)this.findMode(topComponent);
            this.central.topComponentAttentionHighlight(modeImpl, topComponent, bl);
        }
    }

    public Frame getMainWindow() {
        WindowManagerImpl.warnIfNotInEDT();
        return this.central.getMainWindow();
    }

    public void updateUI() {
        WindowManagerImpl.warnIfNotInEDT();
        this.central.updateUI();
    }

    protected synchronized WindowManager.Component createTopComponentManager(TopComponent topComponent) {
        WindowManagerImpl.warnIfNotInEDT();
        return null;
    }

    public Workspace createWorkspace(String string, String string2) {
        WindowManagerImpl.warnIfNotInEDT();
        return this;
    }

    public Workspace findWorkspace(String string) {
        WindowManagerImpl.warnIfNotInEDT();
        return this;
    }

    public Workspace[] getWorkspaces() {
        WindowManagerImpl.warnIfNotInEDT();
        return new Workspace[]{this};
    }

    public void setWorkspaces(Workspace[] workspaceArray) {
        WindowManagerImpl.warnIfNotInEDT();
    }

    public Workspace getCurrentWorkspace() {
        WindowManagerImpl.warnIfNotInEDT();
        return this;
    }

    public TopComponentGroup findTopComponentGroup(String string) {
        WindowManagerImpl.assertEventDispatchThread();
        for (TopComponentGroupImpl topComponentGroupImpl : this.getTopComponentGroups()) {
            if (!topComponentGroupImpl.getName().equals(string)) continue;
            return topComponentGroupImpl;
        }
        return null;
    }

    public TopComponent findTopComponent(String string) {
        WindowManagerImpl.warnIfNotInEDT();
        return this.getTopComponentForID(string);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public String getName() {
        return "FakeWorkspace";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(WindowManagerImpl.class, (String)"LBL_FakeWorkspace");
    }

    public Set<? extends ModeImpl> getModes() {
        return this.central.getModes();
    }

    public Rectangle getBounds() {
        if (this.getEditorAreaState() == 0) {
            return this.getMainWindowBoundsJoined();
        }
        return this.getMainWindowBoundsSeparated();
    }

    public void activate() {
    }

    public Mode createMode(String string, String string2, URL uRL) {
        if (this.getEditorAreaState() == 0) {
            return new WrapMode(this.createMode(string, 1, 0, false, null));
        }
        return this.createMode(string, 0, 1, false, new SplitConstraint[]{new SplitConstraint(1, 1, 0.2)});
    }

    public void userUndockedMode(ModeImpl modeImpl) {
        if (modeImpl.getState() != 0) {
            throw new IllegalStateException("Mode is already in floating state: " + modeImpl);
        }
        this.central.userUndockedMode(modeImpl);
    }

    public void userDockedMode(ModeImpl modeImpl) {
        if (modeImpl.getState() != 1) {
            throw new IllegalStateException("Mode is not in floating state: " + modeImpl);
        }
        this.central.userDockedMode(modeImpl);
    }

    public void userMinimizedMode(ModeImpl modeImpl) {
        WindowManagerImpl.assertEventDispatchThread();
        this.getCentral().userMinimizedMode(modeImpl);
    }

    public void userRestoredMode(ModeImpl modeImpl, ModeImpl modeImpl2) {
        WindowManagerImpl.assertEventDispatchThread();
        this.getCentral().userRestoredMode(modeImpl, modeImpl2);
    }

    public void userClosedMode(ModeImpl modeImpl) {
        WindowManagerImpl.assertEventDispatchThread();
        this.getCentral().userClosedMode(modeImpl);
    }

    private Exclusive getExclusive() {
        if (this.exclusive == null) {
            this.exclusive = new Exclusive();
        }
        return this.exclusive;
    }

    private void toggleUseNativeFileChooser() {
        if (null == System.getProperty("nb.native.filechooser")) {
            boolean bl = WinSysPrefs.HANDLER.getBoolean("laf.maximize.native", false);
            System.setProperty("nb.native.filechooser", bl ? "true" : "false");
        }
    }

    public Mode findMode(String string) {
        return this.findModeImpl(string);
    }

    public Mode findMode(TopComponent topComponent) {
        if (topComponent == null) {
            return null;
        }
        TopComponent topComponent2 = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, (Component)topComponent);
        if (null != topComponent2) {
            topComponent = topComponent2;
        }
        for (ModeImpl modeImpl : this.getModes()) {
            if (!modeImpl.containsTopComponent(topComponent)) continue;
            return modeImpl;
        }
        return null;
    }

    public void remove() {
    }

    public void addTopComponentGroup(TopComponentGroupImpl topComponentGroupImpl) {
        this.central.addTopComponentGroup(topComponentGroupImpl);
    }

    public void removeTopComponentGroup(TopComponentGroupImpl topComponentGroupImpl) {
        this.central.removeTopComponentGroup(topComponentGroupImpl);
    }

    public Set<TopComponentGroupImpl> getTopComponentGroups() {
        return this.central.getTopComponentGroups();
    }

    public ModeImpl createMode(String string, int n, int n2, boolean bl, SplitConstraint[] splitConstraintArray) {
        ModeImpl modeImpl = (ModeImpl)this.findMode(string);
        if (modeImpl != null) {
            return modeImpl;
        }
        if (splitConstraintArray == null && n != 2) {
            if (n == 1) {
                return this.getDefaultEditorMode();
            }
            return this.getDefaultViewMode();
        }
        modeImpl = this.createModeImpl(string, n, n2, bl);
        this.addMode(modeImpl, splitConstraintArray);
        return modeImpl;
    }

    public ModeImpl createSlidingMode(String string, boolean bl, String string2, Map<String, Integer> map) {
        ModeImpl modeImpl = (ModeImpl)this.findMode(string);
        if (modeImpl != null) {
            return modeImpl;
        }
        modeImpl = this.createModeImpl(string, 2, bl);
        this.central.addSlidingMode(modeImpl, null, string2, map);
        return modeImpl;
    }

    ModeImpl createModeImpl(String string, int n, boolean bl) {
        int n2 = this.getEditorAreaState() == 0 ? 0 : 1;
        return this.createModeImpl(string, n, n2, bl);
    }

    ModeImpl createModeImpl(String string, int n, int n2, boolean bl) {
        if (string == null) {
            string = ModeImpl.getUnusedModeName();
        }
        ModeImpl modeImpl = ModeImpl.createModeImpl(string, n2, n, bl);
        return modeImpl;
    }

    ModeImpl getDefaultEditorMode() {
        ModeImpl modeImpl = this.findModeImpl("editor");
        if (modeImpl == null) {
            Logger.getLogger(WindowManagerImpl.class.getName()).log(Level.FINE, null, new IllegalStateException("Creating default editor mode. It shouldn't happen this way"));
            ModeImpl modeImpl2 = this.createModeImpl("editor", 1, true);
            this.addMode(modeImpl2, new SplitConstraint[0]);
            return modeImpl2;
        }
        return modeImpl;
    }

    ModeImpl getDefaultEditorModeForOpen() {
        ModeImpl modeImpl = this.central.getLastActiveEditorMode();
        if (modeImpl == null) {
            return this.getDefaultEditorMode();
        }
        return modeImpl;
    }

    ModeImpl getDefaultViewMode() {
        ModeImpl modeImpl = this.findModeImpl("explorer");
        if (modeImpl == null) {
            Logger.getLogger(WindowManagerImpl.class.getName()).log(Level.INFO, null, new IllegalStateException("Creating default view mode. It shouldn't happen this way"));
            ModeImpl modeImpl2 = this.createModeImpl("explorer", 0, true);
            this.addMode(modeImpl2, new SplitConstraint[]{new SplitConstraint(0, 0, 0.7), new SplitConstraint(1, 0, 0.25)});
            return modeImpl2;
        }
        return modeImpl;
    }

    ModeImpl getDefaultSlidingMode() {
        ModeImpl modeImpl = this.findModeImpl("sliding");
        if (modeImpl == null) {
            Logger.getLogger(WindowManagerImpl.class.getName()).log(Level.INFO, null, new IllegalStateException("Creating default sliding mode. It shouldn't happen this way"));
            ModeImpl modeImpl2 = this.createModeImpl("sliding", 2, true);
            this.addMode(modeImpl2, new SplitConstraint[]{new SplitConstraint(0, 0, 0.7), new SplitConstraint(1, 0, 0.25)});
            return modeImpl2;
        }
        return modeImpl;
    }

    private ModeImpl findModeImpl(String string) {
        if (string == null) {
            return null;
        }
        for (ModeImpl modeImpl : this.getModes()) {
            if (!string.equals(modeImpl.getName()) && !modeImpl.getOtherNames().contains(string)) continue;
            return modeImpl;
        }
        return null;
    }

    public TopComponent getSelectedTopComponent(Mode mode) {
        return this.central.getModeSelectedTopComponent((ModeImpl)mode);
    }

    public Rectangle getMainWindowBoundsJoined() {
        return this.central.getMainWindowBoundsJoined();
    }

    public void setMainWindowBoundsJoined(Rectangle rectangle) {
        this.central.setMainWindowBoundsJoined(rectangle);
    }

    public Rectangle getMainWindowBoundsSeparated() {
        return this.central.getMainWindowBoundsSeparated();
    }

    public void setMainWindowBoundsSeparated(Rectangle rectangle) {
        this.central.setMainWindowBoundsSeparated(rectangle);
    }

    public int getMainWindowFrameStateJoined() {
        return this.central.getMainWindowFrameStateJoined();
    }

    public void setMainWindowFrameStateJoined(int n) {
        this.central.setMainWindowFrameStateJoined(n);
    }

    public int getMainWindowFrameStateSeparated() {
        return this.central.getMainWindowFrameStateSeparated();
    }

    public void setMainWindowFrameStateSeparated(int n) {
        this.central.setMainWindowFrameStateSeparated(n);
    }

    public ModeImpl getActiveMode() {
        return this.central.getActiveMode();
    }

    public void setActiveMode(ModeImpl modeImpl) {
        this.central.setActiveMode(modeImpl);
    }

    public void setEditorAreaBounds(Rectangle rectangle) {
        this.central.setEditorAreaBounds(rectangle);
    }

    public Rectangle getEditorAreaBounds() {
        return this.central.getEditorAreaBounds();
    }

    public void setEditorAreaConstraints(SplitConstraint[] splitConstraintArray) {
        this.central.setEditorAreaConstraints(splitConstraintArray);
    }

    public Component getEditorAreaComponent() {
        return this.central.getEditorAreaComponent();
    }

    public SplitConstraint[] getEditorAreaConstraints() {
        return this.central.getEditorAreaConstraints();
    }

    public void setEditorAreaState(int n) {
        this.setEditorAreaStateImpl(n);
    }

    void setEditorAreaStateImpl(int n) {
        this.central.setEditorAreaState(n);
    }

    public int getEditorAreaState() {
        return this.central.getEditorAreaState();
    }

    public void setEditorAreaFrameState(int n) {
        this.central.setEditorAreaFrameState(n);
    }

    public int getEditorAreaFrameState() {
        return this.central.getEditorAreaFrameState();
    }

    public void switchMaximizedMode(ModeImpl modeImpl) {
        this.central.switchMaximizedMode(modeImpl);
    }

    public void setEditorMaximizedMode(ModeImpl modeImpl) {
        this.central.setEditorMaximizedMode(modeImpl);
    }

    public void setViewMaximizedMode(ModeImpl modeImpl) {
        this.central.setViewMaximizedMode(modeImpl);
    }

    public ModeImpl getCurrentMaximizedMode() {
        return this.central.getCurrentMaximizedMode();
    }

    public ModeImpl getEditorMaximizedMode() {
        return this.central.getEditorMaximizedMode();
    }

    public ModeImpl getViewMaximizedMode() {
        return this.central.getViewMaximizedMode();
    }

    public void setModeConstraints(ModeImpl modeImpl, SplitConstraint[] splitConstraintArray) {
        this.central.setModeConstraints(modeImpl, splitConstraintArray);
    }

    public SplitConstraint[] getModeConstraints(ModeImpl modeImpl) {
        return this.central.getModeConstraints(modeImpl);
    }

    private void addMode(ModeImpl modeImpl, SplitConstraint[] splitConstraintArray) {
        if (modeImpl.getKind() == 2) {
            this.central.addSlidingMode(modeImpl, null, "left", null);
        } else {
            this.central.addMode(modeImpl, splitConstraintArray);
        }
    }

    public void removeMode(ModeImpl modeImpl) {
        if (modeImpl.getKind() != 2) {
            this.central.removeMode(modeImpl);
        }
    }

    public void setToolbarConfigName(String string) {
        this.central.setToolbarConfigName(string);
    }

    public String getToolbarConfigName() {
        return this.central.getToolbarConfigName();
    }

    public void setVisible(boolean bl) {
        if (!bl) {
            FloatingWindowTransparencyManager.getDefault().stop();
        }
        this.central.setVisible(bl);
        if (bl) {
            if (!this.exclusivesCompleted) {
                this.getExclusive().restart();
            } else {
                FloatingWindowTransparencyManager.getDefault().start();
            }
            this.toggleUseNativeFileChooser();
        } else {
            this.getExclusive().stop();
            this.exclusivesCompleted = false;
        }
    }

    public ModeImpl attachModeToSide(ModeImpl modeImpl, String string, String string2, int n, boolean bl) {
        return this.central.attachModeToSide(modeImpl, string, string2, n, bl);
    }

    public boolean isVisible() {
        return this.central.isVisible();
    }

    public TopComponent getTopComponentForID(String string) {
        return PersistenceHandler.getDefault().getTopComponentForID(string, true);
    }

    public boolean isTopComponentAllowedToMoveAnywhere(TopComponent topComponent) {
        return Boolean.TRUE.equals(topComponent.getClientProperty((Object)"TopComponentAllowDockAnywhere"));
    }

    public ModeImpl findModeForOpenedID(String string) {
        if (string == null) {
            return null;
        }
        for (ModeImpl modeImpl : this.getModes()) {
            if (!modeImpl.getOpenedTopComponentsIDs().contains(string)) continue;
            return modeImpl;
        }
        return null;
    }

    public ModeImpl findModeForClosedID(String string) {
        if (string == null) {
            return null;
        }
        for (ModeImpl modeImpl : this.getModes()) {
            if (!modeImpl.getClosedTopComponentsIDs().contains(string)) continue;
            return modeImpl;
        }
        return null;
    }

    public String getTopComponentDisplayName(TopComponent topComponent) {
        if (topComponent == null) {
            return null;
        }
        String string = topComponent.getHtmlDisplayName();
        if (string == null) {
            string = topComponent.getDisplayName();
        }
        if (string == null) {
            string = topComponent.getName();
        }
        return string;
    }

    Central getCentral() {
        return this.central;
    }

    public boolean isDragInProgress() {
        return this.central.isDragInProgress();
    }

    public String guessSlideSide(TopComponent topComponent) {
        return this.central.guessSlideSide(topComponent);
    }

    public boolean isDocked(TopComponent topComponent) {
        return this.central.isDocked(topComponent);
    }

    public void userUndockedTopComponent(TopComponent topComponent, ModeImpl modeImpl) {
        if (!this.isDocked(topComponent)) {
            throw new IllegalStateException("TopComponent is already in floating state: " + topComponent);
        }
        this.central.userUndockedTopComponent(topComponent, modeImpl);
    }

    public void userDockedTopComponent(TopComponent topComponent, ModeImpl modeImpl) {
        if (this.isDocked(topComponent)) {
            throw new IllegalStateException("TopComponent is already inside main window: " + topComponent);
        }
        this.central.userDockedTopComponent(topComponent, modeImpl);
    }

    public void setTopComponentMinimized(TopComponent topComponent, boolean bl) {
        WindowManagerImpl.assertEventDispatchThread();
        this.central.setTopComponentMinimized(topComponent, bl);
    }

    public boolean isTopComponentMinimized(TopComponent topComponent) {
        WindowManagerImpl.assertEventDispatchThread();
        return this.central.isTopComponentMinimized(topComponent);
    }

    public void setRecentViewList(String[] stringArray) {
        this.recentViewList.setTopComponents(stringArray);
    }

    public TopComponent[] getRecentViewList() {
        return this.recentViewList.getTopComponents();
    }

    public String[] getRecentViewIDList() {
        return this.recentViewList.getTopComponentIDs();
    }

    void doFirePropertyChange(final String string, final Object object, final Object object2) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.changeSupport.firePropertyChange(string, object, object2);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WindowManagerImpl.this.changeSupport.firePropertyChange(string, object, object2);
                }
            });
        }
    }

    public PersistenceObserver getPersistenceObserver() {
        return PersistenceHandler.getDefault();
    }

    public void notifyTopComponentOpened(TopComponent topComponent) {
        this.componentOpenNotify(topComponent);
        WindowManagerImpl.notifyRegistryTopComponentOpened(topComponent);
    }

    public void notifyTopComponentClosed(TopComponent topComponent) {
        this.componentCloseNotify(topComponent);
        WindowManagerImpl.notifyRegistryTopComponentClosed(topComponent);
    }

    static void notifyRegistryTopComponentActivated(final TopComponent topComponent) {
        ((RegistryImpl)WindowManagerImpl.getDefault().getRegistry()).topComponentActivated(topComponent);
        if (SwingUtilities.isEventDispatchThread()) {
            WindowManagerImpl.getInstance().activateComponent(topComponent);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WindowManagerImpl.getInstance().activateComponent(topComponent);
                }
            });
        }
    }

    private static void notifyRegistryTopComponentOpened(TopComponent topComponent) {
        ((RegistryImpl)WindowManagerImpl.getDefault().getRegistry()).topComponentOpened(topComponent);
    }

    private static void notifyRegistryTopComponentClosed(TopComponent topComponent) {
        ((RegistryImpl)WindowManagerImpl.getDefault().getRegistry()).topComponentClosed(topComponent);
    }

    private static void notifyRegistrySelectedNodesChanged(TopComponent topComponent, Node[] nodeArray) {
        ((RegistryImpl)WindowManagerImpl.getDefault().getRegistry()).selectedNodesChanged(topComponent, nodeArray);
    }

    public void componentShowing(TopComponent topComponent) {
        if (topComponent != null && topComponent != this.persistenceShowingTC) {
            super.componentShowing(topComponent);
        }
    }

    void specialPersistenceCompShow(TopComponent topComponent) {
        this.componentShowing(topComponent);
        this.persistenceShowingTC = topComponent;
    }

    public void componentHidden(TopComponent topComponent) {
        if (topComponent != null) {
            super.componentHidden(topComponent);
            if (topComponent == this.persistenceShowingTC) {
                this.persistenceShowingTC = null;
            }
        }
    }

    protected void topComponentOpen(TopComponent topComponent) {
        this.topComponentOpenAtTabPosition(topComponent, -1);
    }

    protected void topComponentOpenAtTabPosition(TopComponent topComponent, int n) {
        Object object2;
        WindowManagerImpl.warnIfNotInEDT();
        if (topComponent == null) {
            throw new IllegalArgumentException("Cannot open a null TopComponent");
        }
        ModeImpl modeImpl = this.getMode(topComponent);
        if (modeImpl == null) {
            modeImpl = this.getDefaultEditorModeForOpen();
            Collection collection = Lookup.getDefault().lookupAll(ModeSelector.class);
            for (Object object2 : collection) {
                Mode mode = object2.selectModeForOpen(topComponent, (Mode)modeImpl);
                if (!(mode instanceof ModeImpl)) continue;
                modeImpl = (ModeImpl)mode;
                break;
            }
            assert (this.getModes().contains(modeImpl)) : "Mode " + modeImpl.getName() + " is not in model.";
            if (topComponent.getClientProperty((Object)"TopComponentAllowDockAnywhere") == null) {
                topComponent.putClientProperty((Object)"TopComponentAllowDockAnywhere", (Object)Boolean.TRUE);
            }
        }
        boolean bl = modeImpl.getOpenedTopComponents().contains(topComponent);
        TopComponentTracker.getDefault().add(topComponent, modeImpl);
        ModeImpl modeImpl2 = this.getCurrentMaximizedMode();
        if (modeImpl2 != null && modeImpl != modeImpl2 && modeImpl.getKind() != 2 && (this.central.isViewMaximized() || modeImpl.getKind() == 1)) {
            this.switchMaximizedMode(null);
        }
        if (n == -1) {
            modeImpl.addOpenedTopComponent(topComponent);
        } else {
            modeImpl.addOpenedTopComponent(topComponent, n);
        }
        if (this.central.isEditorMaximized() && !bl && modeImpl.getState() != 1 && !this.isTopComponentDockedInMaximizedMode((String)(object2 = this.findTopComponentID(topComponent))) && modeImpl.getKind() == 0) {
            this.central.slide(topComponent, modeImpl, this.central.getSlideSideForMode(modeImpl));
            this.topComponentRequestActive(topComponent);
            return;
        }
        if (modeImpl.isMinimized() && Switches.isTopComponentAutoSlideInMinimizedModeEnabled()) {
            this.central.slide(topComponent, modeImpl, this.central.getSlideSideForMode(modeImpl));
            this.topComponentRequestActive(topComponent);
        }
    }

    protected int topComponentGetTabPosition(TopComponent topComponent) {
        WindowManagerImpl.warnIfNotInEDT();
        ModeImpl modeImpl = this.getModeForOpenedTopComponent(topComponent);
        if (modeImpl != null) {
            return modeImpl.getTopComponentTabPosition(topComponent);
        }
        return -1;
    }

    protected void topComponentClose(TopComponent topComponent) {
        WindowManagerImpl.warnIfNotInEDT();
        boolean bl = this.topComponentIsOpened(topComponent);
        boolean bl2 = topComponent.getClientProperty((Object)"inCloseAll") != null;
        topComponent.putClientProperty((Object)"inCloseAll", null);
        if (!bl) {
            return;
        }
        ModeImpl modeImpl = this.getModeForOpenedTopComponent(topComponent);
        if (modeImpl != null) {
            if (modeImpl == this.central.getCurrentMaximizedMode() && this.central.isViewMaximized()) {
                this.central.switchMaximizedMode(null);
                this.topComponentClose(topComponent);
            } else {
                TopComponent topComponent2 = null;
                if (modeImpl.getKind() == 1 && !bl2) {
                    topComponent2 = this.central.getRecentTopComponent(modeImpl, topComponent);
                }
                modeImpl.close(topComponent);
                if (!topComponent.isOpened() && null != topComponent2) {
                    modeImpl.setSelectedTopComponent(topComponent2);
                }
            }
        }
    }

    protected void topComponentRequestActive(TopComponent topComponent) {
        WindowManagerImpl.warnIfNotInEDT();
        ModeImpl modeImpl = this.getModeForOpenedTopComponent(topComponent);
        if (modeImpl != null) {
            this.central.activateModeTopComponent(modeImpl, topComponent);
        }
    }

    protected void topComponentRequestVisible(TopComponent topComponent) {
        WindowManagerImpl.warnIfNotInEDT();
        ModeImpl modeImpl = this.getModeForOpenedTopComponent(topComponent);
        if (modeImpl != null) {
            this.central.setModeSelectedTopComponent(modeImpl, topComponent);
            if (modeImpl.getState() == 1) {
                topComponent.toFront();
            }
        }
    }

    protected void topComponentDisplayNameChanged(TopComponent topComponent, String string) {
        WindowManagerImpl.warnIfNotInEDT();
        ModeImpl modeImpl = this.getModeForOpenedTopComponent(topComponent);
        if (modeImpl != null) {
            this.central.topComponentDisplayNameChanged(modeImpl, topComponent);
        }
    }

    protected void topComponentHtmlDisplayNameChanged(TopComponent topComponent, String string) {
        this.topComponentDisplayNameChanged(topComponent, null);
    }

    protected void topComponentToolTipChanged(TopComponent topComponent, String string) {
        WindowManagerImpl.warnIfNotInEDT();
        ModeImpl modeImpl = this.getModeForOpenedTopComponent(topComponent);
        if (modeImpl != null) {
            this.central.topComponentToolTipChanged(modeImpl, topComponent);
        }
    }

    protected void topComponentIconChanged(TopComponent topComponent, Image image) {
        WindowManagerImpl.warnIfNotInEDT();
        ModeImpl modeImpl = this.getModeForOpenedTopComponent(topComponent);
        if (modeImpl != null) {
            this.central.topComponentIconChanged(modeImpl, topComponent);
        }
    }

    protected void topComponentActivatedNodesChanged(TopComponent topComponent, Node[] nodeArray) {
        WindowManagerImpl.warnIfNotInEDT();
        WindowManagerImpl.notifyRegistrySelectedNodesChanged(topComponent, nodeArray);
    }

    protected boolean topComponentIsOpened(TopComponent topComponent) {
        WindowManagerImpl.warnIfNotInEDT();
        return this.getModeForOpenedTopComponent(topComponent) != null;
    }

    protected Action[] topComponentDefaultActions(TopComponent topComponent) {
        WindowManagerImpl.warnIfNotInEDT();
        return ActionUtils.createDefaultPopupActions(topComponent);
    }

    protected String topComponentID(TopComponent topComponent, String string) {
        WindowManagerImpl.warnIfNotInEDT();
        if (string == null) {
            Logger.getLogger(WindowManagerImpl.class.getName()).log(Level.WARNING, null, new IllegalStateException("Assertion failed. " + topComponent.getClass().getName() + ".preferredID method shouldn't be overriden to return null. Please change your impl to return non-null string."));
        }
        return PersistenceManager.getDefault().getGlobalTopComponentID(topComponent, string);
    }

    public void invokeWhenUIReady(Runnable runnable) {
        this.getExclusive().register(runnable);
    }

    public boolean isEditorTopComponent(TopComponent topComponent) {
        if (null == topComponent) {
            return false;
        }
        for (ModeImpl modeImpl : this.getModes()) {
            if (modeImpl.getKind() != 1 || !modeImpl.containsTopComponent(topComponent)) continue;
            return true;
        }
        return false;
    }

    public boolean isOpenedEditorTopComponent(TopComponent topComponent) {
        if (null == topComponent) {
            return false;
        }
        for (ModeImpl modeImpl : this.getModes()) {
            if (modeImpl.getKind() != 1 || !modeImpl.getOpenedTopComponents().contains(topComponent)) continue;
            return true;
        }
        return false;
    }

    public boolean isEditorMode(Mode mode) {
        if (null == mode) {
            return false;
        }
        ModeImpl modeImpl = this.findModeImpl(mode.getName());
        return null != modeImpl && modeImpl.getKind() == 1;
    }

    public void newTabGroup(TopComponent topComponent) {
        WindowManagerImpl.assertEventDispatchThread();
        this.central.newTabGroup(topComponent);
    }

    public void collapseTabGroup(ModeImpl modeImpl) {
        WindowManagerImpl.assertEventDispatchThread();
        this.central.collapseTabGroup(modeImpl);
    }

    public final void mainWindowPainted() {
        if (!this.exclusivesCompleted && WindowManagerImpl.getInstance().isVisible()) {
            this.exclusivesCompleted = true;
            this.getExclusive().stop();
            this.getExclusive().register(new Runnable(){

                @Override
                public void run() {
                    FloatingWindowTransparencyManager.getDefault().start();
                }
            });
            SwingUtilities.invokeLater(this.getExclusive());
        }
    }

    private void busyIconWarmUp() {
        this.invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        BusyTabsSupport.getDefault().getBusyIcon(false);
                    }
                });
            }
        });
    }

    public void resetModel() {
        this.central.resetModel();
        RegistryImpl registryImpl = (RegistryImpl)this.componentRegistry();
        registryImpl.clear();
    }

    private ModeImpl getMode(TopComponent topComponent) {
        return (ModeImpl)this.findMode(topComponent);
    }

    private ModeImpl getModeForOpenedTopComponent(TopComponent topComponent) {
        if (topComponent == null) {
            return null;
        }
        for (ModeImpl modeImpl : this.getModes()) {
            if (!modeImpl.getOpenedTopComponents().contains(topComponent)) continue;
            return modeImpl;
        }
        return null;
    }

    public ModeImpl getPreviousModeForTopComponent(String string, ModeImpl modeImpl) {
        return this.getCentral().getModeTopComponentPreviousMode(string, modeImpl);
    }

    public int getPreviousIndexForTopComponent(String string, ModeImpl modeImpl) {
        return this.getCentral().getModeTopComponentPreviousIndex(string, modeImpl);
    }

    public void setPreviousModeForTopComponent(String string, ModeImpl modeImpl, ModeImpl modeImpl2, int n) {
        this.getCentral().setModeTopComponentPreviousMode(string, modeImpl, modeImpl2, n);
    }

    public void setTopComponentDockedInMaximizedMode(String string, boolean bl) {
        this.getCentral().setTopComponentDockedInMaximizedMode(string, bl);
    }

    public boolean isTopComponentDockedInMaximizedMode(String string) {
        return this.getCentral().isTopComponentDockedInMaximizedMode(string);
    }

    public void setTopComponentSlidedInDefaultMode(String string, boolean bl) {
        this.getCentral().setTopComponentSlidedInDefaultMode(string, bl);
    }

    public boolean isTopComponentSlidedInDefaultMode(String string) {
        return this.getCentral().isTopComponentSlidedInDefaultMode(string);
    }

    public boolean isTopComponentMaximizedWhenSlidedIn(String string) {
        return this.getCentral().isTopComponentMaximizedWhenSlidedIn(string);
    }

    public void setTopComponentMaximizedWhenSlidedIn(String string, boolean bl) {
        this.getCentral().setTopComponentMaximizedWhenSlidedIn(string, bl);
    }

    public void userToggledTopComponentSlideInMaximize(String string) {
        this.getCentral().userToggledTopComponentSlideInMaximize(string);
    }

    public static boolean isSeparateWindow(Window window) {
        if (!(window instanceof RootPaneContainer)) {
            return false;
        }
        JRootPane jRootPane = ((RootPaneContainer)((Object)window)).getRootPane();
        if (jRootPane == null) {
            return false;
        }
        return jRootPane.getClientProperty("SeparateWindow") != null;
    }

    static void assertEventDispatchThread() {
        assert (SwingUtilities.isEventDispatchThread()) : "Window System API is required to be called from AWT thread only, see http://core.netbeans.org/proposals/threading/";
    }

    static void warnIfNotInEDT() {
        Level level;
        Level level2 = level = assertsEnabled ? Level.WARNING : Level.FINE;
        if (!SwingUtilities.isEventDispatchThread()) {
            StackTraceElement[] stackTraceElementArray;
            boolean bl = false;
            for (StackTraceElement stackTraceElement : stackTraceElementArray = Thread.currentThread().getStackTrace()) {
                if (!"java.awt.EventDispatchThread".equals(stackTraceElement.getClassName())) continue;
                bl = true;
                break;
            }
            if (!bl) {
                Logger.getLogger(WindowManagerImpl.class.getName()).log(level, null, new IllegalStateException("Problem in some module which uses Window System: Window System API is required to be called from AWT thread only, see http://core.netbeans.org/proposals/threading/"));
            } else {
                Logger.getLogger(WindowManagerImpl.class.getName()).log(level, null, new IllegalStateException("Known problem in JDK occurred. If you are interested, vote and report at:\nhttp://bugs.sun.com/view_bug.do?bug_id=6424157, http://bugs.sun.com/view_bug.do?bug_id=6553239 \nAlso see related discussion at http://www.netbeans.org/issues/show_bug.cgi?id=90590"));
            }
        }
    }

    public TopComponent[] getEditorTopComponents() {
        TopComponentTracker topComponentTracker = TopComponentTracker.getDefault();
        ArrayList<TopComponent> arrayList = new ArrayList<TopComponent>();
        for (TopComponent topComponent : this.getRegistry().getOpened()) {
            if (topComponentTracker.isViewTopComponent(topComponent)) continue;
            arrayList.add(topComponent);
        }
        return arrayList.toArray(new TopComponent[arrayList.size()]);
    }

    public TopComponent getArbitrarySelectedEditorTopComponent() {
        TopComponentTracker topComponentTracker = TopComponentTracker.getDefault();
        Set<? extends ModeImpl> set = this.getModes();
        for (Mode mode : set) {
            TopComponent topComponent;
            ModeImpl modeImpl = this.findModeImpl(mode.getName());
            if (modeImpl.getKind() != 1 || null == (topComponent = mode.getSelectedTopComponent()) || !topComponentTracker.isEditorTopComponent(topComponent)) continue;
            return topComponent;
        }
        return null;
    }

    public void deselectEditorTopComponents() {
        for (ModeImpl modeImpl : this.getModes()) {
            if (modeImpl.getKind() != 1) continue;
            DummyTopComponent dummyTopComponent = new DummyTopComponent();
            modeImpl.addOpenedTopComponent(dummyTopComponent);
            modeImpl.setSelectedTopComponent(dummyTopComponent);
        }
    }

    public void closeNonEditorViews() {
        TopComponentTracker topComponentTracker = TopComponentTracker.getDefault();
        for (ModeImpl modeImpl : this.getModes()) {
            if (null == modeImpl) continue;
            List<TopComponent> list = modeImpl.getOpenedTopComponents();
            for (TopComponent topComponent : list) {
                if (!topComponentTracker.isViewTopComponent(topComponent)) continue;
                topComponent.close();
            }
        }
    }

    public TopComponent[] getOpenedTopComponents(Mode mode) {
        if (mode instanceof ModeImpl) {
            List<TopComponent> list = ((ModeImpl)mode).getOpenedTopComponents();
            return list.toArray(new TopComponent[list.size()]);
        }
        return super.getOpenedTopComponents(mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWindowSystemListener(WindowSystemListener windowSystemListener) {
        Collection<WindowSystemListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.add(windowSystemListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWindowSystemListener(WindowSystemListener windowSystemListener) {
        Collection<WindowSystemListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.remove(windowSystemListener);
        }
    }

    public String getRole() {
        return this.currentRole;
    }

    public void setRole(String string) {
        this.setRole(string, false);
    }

    public void setRole(String string, boolean bl) {
        if (null != string && string.isEmpty()) {
            throw new IllegalArgumentException("Role name cannot be empty.");
        }
        if (!PersistenceHandler.getDefault().isLoaded()) {
            this.currentRole = string;
            PersistenceManager.getDefault().setRole(this.currentRole);
        } else {
            if (this.currentRole == null ? string == null : this.currentRole.equals(string)) {
                return;
            }
            this.switchRole(string, bl);
        }
    }

    boolean switchRole(String string, boolean bl) {
        Object object2;
        WindowSystemImpl windowSystemImpl = (WindowSystemImpl)Lookup.getDefault().lookup(WindowSystemImpl.class);
        assert (null != windowSystemImpl);
        PersistenceManager persistenceManager = PersistenceManager.getDefault();
        PersistenceHandler.getDefault().finishLazyLoading();
        MainWindow.getInstance().setFullScreenMode(false);
        TopComponent topComponent = this.getEditorTopComponents();
        if (!bl) {
            for (Object object2 : topComponent) {
                if (object2.canClose()) continue;
                return false;
            }
        }
        TopComponent topComponent2 = this.getArbitrarySelectedEditorTopComponent();
        HashSet hashSet = new HashSet(this.getRegistry().getOpened());
        int n = Switches.isShowAndHideMainWindowWhileSwitchingRole() ? 1 : 0;
        if (n != 0) {
            windowSystemImpl.hide();
        } else {
            this.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
        }
        windowSystemImpl.save();
        this.deselectEditorTopComponents();
        this.resetModel();
        persistenceManager.reset();
        PersistenceHandler.getDefault().clear();
        this.currentRole = string;
        persistenceManager.setRole(string);
        windowSystemImpl.load();
        if (bl) {
            object2 = (ModeImpl)this.findMode("editor");
            for (int i = 0; i < ((TopComponent)topComponent).length && null != object2; ++i) {
                TopComponent topComponent3 = topComponent[i];
                if (topComponent3.getPersistenceType() == 2) continue;
                ModeImpl modeImpl = (ModeImpl)this.findMode(topComponent3);
                if (null == modeImpl) {
                    modeImpl = object2;
                }
                if (null == modeImpl) continue;
                String string2 = this.findTopComponentID(topComponent3);
                if (!(modeImpl.getOpenedTopComponents().contains(topComponent3) || null != string2 && modeImpl.getOpenedTopComponentsIDs().contains(string2))) {
                    modeImpl.addOpenedTopComponentNoNotify(topComponent3);
                }
                hashSet.remove(topComponent3);
            }
        }
        object2 = this.getRegistry().getOpened();
        hashSet.removeAll((Collection<?>)object2);
        for (TopComponent topComponent3 : hashSet) {
            this.componentCloseNotify(topComponent3);
        }
        if (n != 0) {
            windowSystemImpl.show();
        } else {
            this.getMainWindow().setCursor(null);
        }
        TopComponent topComponent4 = topComponent2;
        if (null != topComponent4 && !topComponent4.isOpened()) {
            topComponent4 = this.getArbitrarySelectedEditorTopComponent();
        }
        if (null != topComponent4) {
            topComponent4.requestActive();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Frame frame = WindowManagerImpl.this.getMainWindow();
                frame.invalidate();
                frame.repaint();
            }
        });
        return true;
    }

    public void userStartedKeyboardDragAndDrop(TopComponentDraggable topComponentDraggable) {
        this.central.userStartedKeyboardDragAndDrop(topComponentDraggable);
    }

    protected void topComponentMakeBusy(TopComponent topComponent, boolean bl) {
        ModeImpl modeImpl;
        boolean bl2 = this.isTopComponentBusy(topComponent);
        topComponent.putClientProperty((Object)BUSY_PROP_NAME, bl ? BUSY_FLAG : null);
        if (bl != bl2 && null != (modeImpl = (ModeImpl)this.findMode(topComponent))) {
            this.central.topComponentMakeBusy(modeImpl, topComponent, bl);
        }
    }

    public boolean isTopComponentBusy(TopComponent topComponent) {
        return topComponent.getClientProperty((Object)BUSY_PROP_NAME) == BUSY_FLAG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireEvent(WindowSystemEventType windowSystemEventType) {
        WindowManagerImpl.assertEventDispatchThread();
        ArrayList<WindowSystemListener> arrayList = null;
        WindowSystemEvent windowSystemEvent = this.listeners;
        synchronized (windowSystemEvent) {
            arrayList = new ArrayList<WindowSystemListener>(this.listeners);
        }
        windowSystemEvent = new WindowSystemEvent((Object)this);
        for (WindowSystemListener windowSystemListener : arrayList) {
            switch (windowSystemEventType) {
                case beforeLoad: {
                    windowSystemListener.beforeLoad(windowSystemEvent);
                    break;
                }
                case beforeSave: {
                    windowSystemListener.beforeSave(windowSystemEvent);
                    break;
                }
                case afterLoad: {
                    windowSystemListener.afterLoad(windowSystemEvent);
                    break;
                }
                case afterSave: {
                    windowSystemListener.afterSave(windowSystemEvent);
                }
            }
        }
    }

    public boolean isHeavyWeightShowing() {
        TopComponent.Registry registry = TopComponent.getRegistry();
        HashSet hashSet = new HashSet(registry.getOpened());
        for (TopComponent topComponent : hashSet) {
            if (!topComponent.isShowing() || !this.isHeavyWeight((Component)topComponent)) continue;
            return true;
        }
        return false;
    }

    private boolean isHeavyWeight(Component component) {
        if (null != component && !component.isLightweight()) {
            return true;
        }
        if (component instanceof Container) {
            for (Component component2 : ((Container)component).getComponents()) {
                if (!this.isHeavyWeight(component2)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isTopComponentFloating(TopComponent topComponent) {
        WindowManagerImpl.assertEventDispatchThread();
        return !this.isDocked(topComponent);
    }

    public void setTopComponentFloating(TopComponent topComponent, boolean bl) {
        boolean bl2;
        WindowManagerImpl.assertEventDispatchThread();
        boolean bl3 = bl2 = !this.isDocked(topComponent);
        if (bl2 == bl) {
            return;
        }
        ModeImpl modeImpl = (ModeImpl)this.findMode(topComponent);
        if (null == modeImpl) {
            throw new IllegalStateException("Cannot find Mode for TopComponent: " + topComponent);
        }
        if (bl) {
            this.userUndockedTopComponent(topComponent, modeImpl);
        } else {
            this.userDockedTopComponent(topComponent, modeImpl);
        }
    }

    static {
        assertsEnabled = false;
        if (!$assertionsDisabled) {
            assertsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        BUSY_FLAG = new Object();
    }

    private static class DummyTopComponent
    extends TopComponent {
        private DummyTopComponent() {
        }

        protected String preferredID() {
            return "temp";
        }

        public int getPersistenceType() {
            return 2;
        }
    }

    private static final class Exclusive
    implements Runnable,
    ActionListener {
        private ArrayList<Runnable> arr = new ArrayList();
        private Timer paintedTimer = new Timer(5000, this);

        public Exclusive() {
            this.paintedTimer.setRepeats(false);
        }

        final void stop() {
            this.paintedTimer.stop();
        }

        final void restart() {
            this.paintedTimer.restart();
        }

        public synchronized void register(Runnable runnable) {
            this.arr.add(runnable);
            SwingUtilities.invokeLater(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!WindowManagerImpl.getInstance().isVisible()) {
                return;
            }
            Exclusive exclusive = this;
            synchronized (exclusive) {
                if (this.arr.isEmpty()) {
                    return;
                }
                final Runnable runnable = this.arr.remove(0);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Logger logger = Logger.getLogger("org.netbeans.log.startup");
                        try {
                            logger.log(Level.FINE, "start", "invokeWhenUIReady: " + runnable.getClass().getName());
                            runnable.run();
                            logger.log(Level.FINE, "end", "invokeWhenUIReady: " + runnable.getClass().getName());
                        }
                        catch (RuntimeException runtimeException) {
                            Logger.getLogger(WindowManagerImpl.class.getName()).log(Level.WARNING, null, runtimeException);
                        }
                        SwingUtilities.invokeLater(Exclusive.this);
                    }
                });
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Logger.getLogger(WindowManagerImpl.class.getName()).log(Level.FINE, "Painted timer action invoked, which probably means that MainWindow.paint was not called!");
            WindowManagerImpl.getInstance().mainWindowPainted();
        }
    }

    private static class WrapMode
    implements Mode {
        private Mode wrap;

        public WrapMode(Mode mode) {
            this.wrap = mode;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.wrap.addPropertyChangeListener(propertyChangeListener);
        }

        public boolean canDock(TopComponent topComponent) {
            return this.wrap.canDock(topComponent);
        }

        public boolean dockInto(TopComponent topComponent) {
            if (topComponent.getClientProperty((Object)"TopComponentAllowDockAnywhere") == null) {
                topComponent.putClientProperty((Object)"TopComponentAllowDockAnywhere", (Object)Boolean.TRUE);
            }
            return this.wrap.dockInto(topComponent);
        }

        public Rectangle getBounds() {
            return this.wrap.getBounds();
        }

        public String getDisplayName() {
            return this.wrap.getDisplayName();
        }

        public Image getIcon() {
            return this.wrap.getIcon();
        }

        public String getName() {
            return this.wrap.getName();
        }

        public TopComponent getSelectedTopComponent() {
            return this.wrap.getSelectedTopComponent();
        }

        public TopComponent[] getTopComponents() {
            return this.wrap.getTopComponents();
        }

        public Workspace getWorkspace() {
            return this.wrap.getWorkspace();
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.wrap.removePropertyChangeListener(propertyChangeListener);
        }

        public void setBounds(Rectangle rectangle) {
            this.wrap.setBounds(rectangle);
        }
    }
}

