/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.instrumentation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import org.netbeans.lib.profiler.classfile.BaseClassInfo;
import org.netbeans.lib.profiler.classfile.ClassInfo;
import org.netbeans.lib.profiler.classfile.ClassRepository;
import org.netbeans.lib.profiler.classfile.DynamicClassInfo;
import org.netbeans.lib.profiler.classfile.PlaceholderClassInfo;
import org.netbeans.lib.profiler.client.RuntimeProfilingPoint;
import org.netbeans.lib.profiler.global.CommonConstants;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.instrumentation.JavaClassConstants;
import org.netbeans.lib.profiler.utils.MiscUtils;
import org.netbeans.lib.profiler.wireprotocol.RootClassLoadedCommand;

public class ClassManager
implements JavaClassConstants,
CommonConstants {
    private static final RuntimeProfilingPoint[] EMPTY_PROFILEPOINT_ARRAY = new RuntimeProfilingPoint[0];
    private static Comparator ByBciComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            RuntimeProfilingPoint runtimeProfilingPoint = (RuntimeProfilingPoint)object;
            RuntimeProfilingPoint runtimeProfilingPoint2 = (RuntimeProfilingPoint)object2;
            return runtimeProfilingPoint.getBci() - runtimeProfilingPoint2.getBci();
        }
    };
    protected ProfilingSessionStatus status;

    protected ClassManager(ProfilingSessionStatus profilingSessionStatus) {
        this.status = profilingSessionStatus;
    }

    protected static RuntimeProfilingPoint[] getRuntimeProfilingPoints(RuntimeProfilingPoint[] runtimeProfilingPointArray, ClassInfo classInfo) {
        ArrayList<RuntimeProfilingPoint> arrayList = null;
        String string = classInfo.getName().replace('/', '.');
        for (int i = 0; i < runtimeProfilingPointArray.length; ++i) {
            RuntimeProfilingPoint runtimeProfilingPoint = runtimeProfilingPointArray[i];
            if (!string.equals(runtimeProfilingPoint.getClassName()) || !runtimeProfilingPoint.resolve(classInfo)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<RuntimeProfilingPoint>(2);
            }
            arrayList.add(runtimeProfilingPoint);
        }
        if (arrayList == null) {
            return EMPTY_PROFILEPOINT_ARRAY;
        }
        return arrayList.toArray(new RuntimeProfilingPoint[0]);
    }

    protected static RuntimeProfilingPoint[] getRuntimeProfilingPoints(RuntimeProfilingPoint[] runtimeProfilingPointArray, int n) {
        ArrayList<RuntimeProfilingPoint> arrayList = null;
        for (int i = 0; i < runtimeProfilingPointArray.length; ++i) {
            RuntimeProfilingPoint runtimeProfilingPoint = runtimeProfilingPointArray[i];
            if (runtimeProfilingPoint.getMethodIdx() != n) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<RuntimeProfilingPoint>(2);
            }
            arrayList.add(runtimeProfilingPoint);
        }
        if (arrayList == null) {
            return EMPTY_PROFILEPOINT_ARRAY;
        }
        if (arrayList.size() > 1) {
            Collections.sort(arrayList, ByBciComparator);
        }
        return arrayList.toArray(new RuntimeProfilingPoint[0]);
    }

    protected static RuntimeProfilingPoint[] getRuntimeProfilingPoints(RuntimeProfilingPoint[] runtimeProfilingPointArray, ClassInfo classInfo, int n) {
        ArrayList<RuntimeProfilingPoint> arrayList = null;
        String string = classInfo.getName().replace('/', '.');
        for (int i = 0; i < runtimeProfilingPointArray.length; ++i) {
            RuntimeProfilingPoint runtimeProfilingPoint = runtimeProfilingPointArray[i];
            if (!string.equals(runtimeProfilingPoint.getClassName()) || !runtimeProfilingPoint.resolve(classInfo) || runtimeProfilingPoint.getMethodIdx() != n) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<RuntimeProfilingPoint>(2);
            }
            arrayList.add(runtimeProfilingPoint);
        }
        if (arrayList == null) {
            return EMPTY_PROFILEPOINT_ARRAY;
        }
        if (arrayList.size() > 1) {
            Collections.sort(arrayList, ByBciComparator);
        }
        return arrayList.toArray(new RuntimeProfilingPoint[0]);
    }

    protected static DynamicClassInfo javaClassForName(String string, int n) {
        try {
            return ClassRepository.lookupClass(string, n);
        }
        catch (IOException iOException) {
            MiscUtils.printWarningMessage("Error reading class " + string);
            MiscUtils.printWarningMessage(iOException.getMessage());
        }
        catch (ClassFormatError classFormatError) {
            MiscUtils.printWarningMessage(classFormatError.getMessage());
        }
        return null;
    }

    protected static BaseClassInfo javaClassForObjectArrayType(String string) {
        BaseClassInfo baseClassInfo = ClassRepository.lookupSpecialClass("[" + string);
        return baseClassInfo;
    }

    protected static BaseClassInfo javaClassForPrimitiveArrayType(int n) {
        BaseClassInfo baseClassInfo = ClassRepository.lookupSpecialClass(PRIMITIVE_ARRAY_TYPE_NAMES[n]);
        return baseClassInfo;
    }

    protected static BaseClassInfo javaClassOrPlaceholderForName(String string, int n) {
        return ClassRepository.lookupClassOrCreatePlaceholder(string, n);
    }

    protected static BaseClassInfo loadedJavaClassOrExistingPlaceholderForName(String string, int n) {
        return ClassRepository.lookupLoadedClass(string, n, true);
    }

    protected static void registerPlaceholder(PlaceholderClassInfo placeholderClassInfo) {
        ClassRepository.addClassInfo(placeholderClassInfo);
    }

    protected static void resetLoadedClassData() {
        ClassRepository.clearCache();
    }

    protected static void storeClassFileBytesForCustomLoaderClasses(RootClassLoadedCommand rootClassLoadedCommand) {
        Object object;
        int n;
        String[] stringArray = rootClassLoadedCommand.getAllLoadedClassNames();
        byte[][] byArray = rootClassLoadedCommand.getCachedClassFileBytes();
        int[] nArray = rootClassLoadedCommand.getAllLoadedClassLoaderIds();
        int[] nArray2 = rootClassLoadedCommand.getAllLoaderSuperClassIds();
        int[][] nArray3 = rootClassLoadedCommand.getAllLoadedInterfaceIds();
        int n2 = stringArray.length;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int i = 0; i < n2; ++i) {
            if (byArray[i] == null) continue;
            String string = stringArray[i];
            n = nArray[i];
            object = byArray[i];
            if (object != null && ((byte[])object).length == 0) {
                int n3 = nArray2[i];
                String string2 = n3 != -1 ? stringArray[n3] : "java/lang/Object";
                int[] nArray4 = nArray3[i];
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int j = 0; j < nArray4.length; ++j) {
                    int n4 = nArray4[j];
                    if (n4 == -1) continue;
                    arrayList.add(stringArray[n4]);
                    hashSet.add(n4);
                }
                ClassRepository.addVMSuppliedClassFile(string, n, object, string2, arrayList.toArray(new String[0]));
                continue;
            }
            ClassRepository.addVMSuppliedClassFile(string, n, object);
        }
        for (Object e : hashSet) {
            n = (Integer)e;
            if (byArray[n] == null) continue;
            object = ClassManager.javaClassForName(stringArray[n], nArray[n]);
            object.setInterface();
        }
    }
}

