/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.memory;

import org.netbeans.lib.profiler.results.DataManager;

public class ClassHistoryDataManager
extends DataManager {
    private int trackedClassID;
    private String trackedClassName;
    public long[] timeStamps;
    public int[] nTotalAllocObjects;
    public long[] totalAllocObjectsSize;
    public int[] nTrackedLiveObjects;
    public long[] trackedLiveObjectsSize;
    private int arrayBufferSize;
    private int currentArraysSize;
    private int itemCount;

    public ClassHistoryDataManager() {
        this(50);
    }

    public ClassHistoryDataManager(int n) {
        this.arrayBufferSize = n;
        this.reset();
    }

    public synchronized void setArrayBufferSize(int n) {
        this.arrayBufferSize = n;
    }

    public synchronized int getArrayBufferSize() {
        return this.arrayBufferSize;
    }

    public synchronized int getItemCount() {
        return this.itemCount;
    }

    public synchronized int getTrackedClassID() {
        return this.trackedClassID;
    }

    public synchronized String getTrackedClassName() {
        return this.trackedClassName;
    }

    public synchronized boolean isTrackingClass() {
        return this.trackedClassName != null;
    }

    public synchronized void setupClass(int n, String string) {
        this.reset();
        this.trackedClassID = n;
        this.trackedClassName = string;
    }

    public synchronized void resetClass() {
        this.reset();
    }

    public synchronized void processData(int[] nArray, long[] lArray) {
        this.checkArraysSize();
        this.timeStamps[this.itemCount] = System.currentTimeMillis();
        this.nTotalAllocObjects[this.itemCount] = nArray[this.trackedClassID];
        this.totalAllocObjectsSize[this.itemCount] = lArray[this.trackedClassID];
        ++this.itemCount;
        this.fireDataChanged();
    }

    public synchronized void processData(int[] nArray, int[] nArray2, long[] lArray) {
        this.checkArraysSize();
        this.timeStamps[this.itemCount] = System.currentTimeMillis();
        this.nTotalAllocObjects[this.itemCount] = nArray[this.trackedClassID];
        this.nTrackedLiveObjects[this.itemCount] = nArray2[this.trackedClassID];
        this.trackedLiveObjectsSize[this.itemCount] = lArray[this.trackedClassID];
        ++this.itemCount;
        this.fireDataChanged();
    }

    private void reset() {
        this.itemCount = 0;
        this.trackedClassID = -1;
        this.trackedClassName = null;
        this.timeStamps = new long[this.arrayBufferSize];
        this.nTotalAllocObjects = new int[this.arrayBufferSize];
        this.totalAllocObjectsSize = new long[this.arrayBufferSize];
        this.nTrackedLiveObjects = new int[this.arrayBufferSize];
        this.trackedLiveObjectsSize = new long[this.arrayBufferSize];
        this.currentArraysSize = this.arrayBufferSize;
        this.fireDataReset();
    }

    private void checkArraysSize() {
        if (this.currentArraysSize == this.itemCount) {
            this.timeStamps = ClassHistoryDataManager.extendArray(this.timeStamps, this.arrayBufferSize);
            this.nTotalAllocObjects = ClassHistoryDataManager.extendArray(this.nTotalAllocObjects, this.arrayBufferSize);
            this.totalAllocObjectsSize = ClassHistoryDataManager.extendArray(this.totalAllocObjectsSize, this.arrayBufferSize);
            this.nTrackedLiveObjects = ClassHistoryDataManager.extendArray(this.nTrackedLiveObjects, this.arrayBufferSize);
            this.trackedLiveObjectsSize = ClassHistoryDataManager.extendArray(this.trackedLiveObjectsSize, this.arrayBufferSize);
            this.currentArraysSize += this.arrayBufferSize;
        }
    }

    private static long[] extendArray(long[] lArray, int n) {
        int n2 = lArray.length;
        long[] lArray2 = new long[n2 + n];
        System.arraycopy(lArray, 0, lArray2, 0, n2);
        return lArray2;
    }

    private static int[] extendArray(int[] nArray, int n) {
        int n2 = nArray.length;
        int[] nArray2 = new int[n2 + n];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        return nArray2;
    }
}

