/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.v2.ui;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.swing.GenericToolbar;
import org.netbeans.lib.profiler.ui.swing.SmallButton;
import org.netbeans.modules.profiler.api.icons.Icons;

public class DropdownButton
extends JPanel {
    private static final Icon DROPDOWN_ICON = Icons.getIcon((String)"GeneralIcons.PopupArrow");
    private static final int DROPDOWN_ICON_WIDTH = DROPDOWN_ICON.getIconWidth();
    private static final int DROPDOWN_ICON_HEIGHT = DROPDOWN_ICON.getIconHeight();
    private static final String NO_ACTION = "none";
    private static final String POPUP_ACTION = "displayPopup";
    private static final int POPUP_EXTENT;
    private static final int POPUP_OFFSET;
    private static final int POPUP_XWIDTH;
    private static final int POPUP_MARGIN;
    private final JComponent container;
    private final Button button;
    private final Popup popup;
    private boolean pushed;
    private boolean wasIn;

    public DropdownButton(String string, Icon icon, boolean bl) {
        Object object;
        this.setOpaque(false);
        if (bl) {
            object = new GenericToolbar(){

                public void doLayout() {
                    for (Component component : this.getComponents()) {
                        component.setBounds(0, 0, this.getWidth(), this.getHeight());
                    }
                }

                public void paint(Graphics graphics) {
                    this.paintChildren(graphics);
                }
            };
            object.setFloatable(false);
            object.setFocusable(false);
            this.container = object;
            this.add(this.container);
        } else {
            this.container = this;
        }
        this.button = new Button(string, icon);
        this.container.add((Component)((Object)this.button));
        this.popup = new Popup();
        this.container.add(this.popup);
        object = KeyStroke.getKeyStroke(40, 0);
        this.container.getInputMap(1).put((KeyStroke)object, POPUP_ACTION);
        this.container.getActionMap().put(POPUP_ACTION, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DropdownButton.this.displayPopup();
            }
        });
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.popup.isFocusable() ? this.popup.requestFocusInWindow() : this.button.requestFocusInWindow();
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.button != null) {
            this.button.setEnabled(bl);
            if (bl) {
                this.exposeButton();
            } else {
                this.exposePopup();
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return this.button == null ? false : this.button.isEnabled();
    }

    public void setPopupEnabled(boolean bl) {
        if (this.popup != null) {
            this.popup.setEnabled(bl);
        }
    }

    public boolean isPopupEnabled() {
        return this.popup == null ? false : this.popup.isEnabled();
    }

    public void setPushed(boolean bl) {
        this.pushed = bl;
        this.repaint();
    }

    public boolean isPushed() {
        return this.pushed;
    }

    @Override
    public void setToolTipText(String string) {
        this.button.setToolTipText(string);
    }

    public void setPushedToolTipText(String string) {
        this.button.putClientProperty("PUSHED_TOOLTIP", string);
    }

    public void setPopupToolTipText(String string) {
        this.popup.setToolTipText(string);
    }

    public void setText(String string) {
        if (this.button != null) {
            String string2 = this.button.getText();
            this.button.setText(string);
            Container container = this.getParent();
            if (!Objects.equals(string, string2) && container != null) {
                ((Component)container).invalidate();
                container.revalidate();
                container.repaint();
            }
        }
    }

    public String getText() {
        return this.button == null ? null : this.button.getText();
    }

    public void setIcon(Icon icon) {
        if (this.button != null) {
            Icon icon2 = this.button.getIcon();
            this.button.setIcon(icon);
            Container container = this.getParent();
            if (!Objects.equals(icon, icon2) && container != null) {
                ((Component)container).invalidate();
                container.revalidate();
                container.repaint();
            }
        }
    }

    public Icon getIcon() {
        return this.button == null ? null : this.button.getIcon();
    }

    public void clickPopup() {
        if (this.popup != null) {
            this.popup.doClick();
        }
    }

    public void displayPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.populatePopup(jPopupMenu);
        if (jPopupMenu.getComponentCount() > 0) {
            Dimension dimension = jPopupMenu.getPreferredSize();
            dimension.width = Math.max(dimension.width, this.getWidth());
            jPopupMenu.setPreferredSize(dimension);
            jPopupMenu.show(this, 0, this.getHeight());
        }
    }

    protected void populatePopup(JPopupMenu jPopupMenu) {
    }

    protected void performAction() {
    }

    @Override
    public void paint(Graphics graphics) {
        this.paintChildren(graphics);
    }

    @Override
    protected void paintChildren(Graphics graphics) {
        super.paintChildren(graphics);
        DROPDOWN_ICON.paintIcon(this, graphics, this.getWidth() - DROPDOWN_ICON_WIDTH - POPUP_OFFSET, (this.getHeight() - DROPDOWN_ICON_HEIGHT) / 2);
        if (this.pushed || !this.button.isEnabled() || this.container.getComponent(0) == this.popup || this.button.getModel().isRollover() || this.button.isFocusOwner()) {
            graphics.setColor(Color.GRAY);
            graphics.drawLine(this.getWidth() - POPUP_EXTENT, POPUP_MARGIN, this.getWidth() - POPUP_EXTENT, this.getHeight() - POPUP_MARGIN);
        }
    }

    private void processChildMouseEvent(MouseEvent mouseEvent) {
        boolean bl = this.contains(mouseEvent.getX(), mouseEvent.getY());
        boolean bl2 = mouseEvent.getX() >= this.getWidth() - POPUP_EXTENT;
        switch (mouseEvent.getID()) {
            case 504: {
                if (this.wasIn) break;
                this.button.processEventImpl(DropdownButton.fromEvent(mouseEvent, (Component)((Object)this.button), 504));
                this.popup.processEventImpl(DropdownButton.fromEvent(mouseEvent, this.popup, 504));
                break;
            }
            case 505: {
                if (bl) break;
                this.popup.processEventImpl(DropdownButton.fromEvent(mouseEvent, this.popup, 505));
                this.button.processEventImpl(DropdownButton.fromEvent(mouseEvent, (Component)((Object)this.button), 505));
                this.exposeButton();
                break;
            }
            case 503: {
                if (bl2) {
                    this.exposePopup();
                    MouseEvent mouseEvent2 = DropdownButton.fromEvent(mouseEvent, this.popup, 503);
                    this.popup.processEventImpl(mouseEvent2);
                    ToolTipManager.sharedInstance().mouseMoved(mouseEvent2);
                    break;
                }
                this.exposeButton();
                MouseEvent mouseEvent3 = DropdownButton.fromEvent(mouseEvent, (Component)((Object)this.button), 503);
                this.button.processEventImpl(mouseEvent3);
                ToolTipManager.sharedInstance().mouseMoved(mouseEvent3);
                break;
            }
            default: {
                if (bl2) {
                    this.popup.processEventImpl(mouseEvent);
                    break;
                }
                this.button.processEventImpl(mouseEvent);
            }
        }
        this.wasIn = bl;
    }

    private static MouseEvent fromEvent(MouseEvent mouseEvent, Component component, int n) {
        return new MouseEvent(component, n, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
    }

    private boolean exposeButton() {
        if (this.container.getComponent(0) == this.button) {
            return false;
        }
        this.container.setComponentZOrder((Component)((Object)this.button), 0);
        this.repaint();
        return true;
    }

    private boolean exposePopup() {
        if (this.container.getComponent(0) == this.popup) {
            return false;
        }
        this.container.setComponentZOrder(this.popup, 0);
        this.repaint();
        return true;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = this.button.getPreferredSize();
        dimension.width += POPUP_EXTENT + POPUP_XWIDTH;
        return dimension;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void doLayout() {
        for (Component component : this.getComponents()) {
            component.setBounds(0, 0, this.getWidth(), this.getHeight());
        }
    }

    static {
        if (UIUtils.isWindowsClassicLookAndFeel()) {
            POPUP_EXTENT = 18;
            POPUP_OFFSET = 6;
            POPUP_XWIDTH = -1;
            POPUP_MARGIN = 6;
        } else if (UIUtils.isWindowsLookAndFeel()) {
            POPUP_EXTENT = 15;
            POPUP_OFFSET = 4;
            POPUP_XWIDTH = -1;
            POPUP_MARGIN = 6;
        } else if (UIUtils.isNimbus()) {
            POPUP_EXTENT = 17;
            POPUP_OFFSET = 6;
            POPUP_XWIDTH = -1;
            POPUP_MARGIN = 6;
        } else if (UIUtils.isMetalLookAndFeel()) {
            POPUP_EXTENT = 16;
            POPUP_OFFSET = 5;
            POPUP_XWIDTH = -2;
            POPUP_MARGIN = 6;
        } else if (UIUtils.isAquaLookAndFeel()) {
            POPUP_EXTENT = 19;
            POPUP_OFFSET = 7;
            POPUP_XWIDTH = -8;
            POPUP_MARGIN = 6;
        } else {
            POPUP_EXTENT = 16;
            POPUP_OFFSET = 5;
            POPUP_XWIDTH = -2;
            POPUP_MARGIN = 6;
        }
    }

    private class Popup
    extends JButton {
        Popup() {
            super(" ");
            this.putClientProperty("MetalListener", new Object());
            this.setModel(new DefaultButtonModel(){

                @Override
                public boolean isRollover() {
                    return super.isRollover() || DropdownButton.this.pushed;
                }
            });
            this.setHorizontalAlignment(10);
            this.setDefaultCapable(false);
            this.getInputMap().put(KeyStroke.getKeyStroke(32, 0, false), DropdownButton.NO_ACTION);
            this.getInputMap().put(KeyStroke.getKeyStroke(32, 0, true), DropdownButton.NO_ACTION);
        }

        @Override
        protected void fireActionPerformed(ActionEvent actionEvent) {
            super.fireActionPerformed(actionEvent);
            DropdownButton.this.displayPopup();
        }

        @Override
        protected void processEvent(AWTEvent aWTEvent) {
            if (!(aWTEvent instanceof MouseEvent)) {
                this.processEventImpl(aWTEvent);
            } else {
                DropdownButton.this.processChildMouseEvent((MouseEvent)aWTEvent);
            }
        }

        private void processEventImpl(AWTEvent aWTEvent) {
            super.processEvent(aWTEvent);
            if (aWTEvent.getID() == 501) {
                if (this.isFocusable()) {
                    this.requestFocus();
                } else {
                    DropdownButton.this.button.requestFocus();
                }
            }
        }

        @Override
        public boolean hasFocus() {
            return this.isFocusable() ? super.hasFocus() : DropdownButton.this.button.hasFocus();
        }

        @Override
        public boolean isFocusable() {
            return !DropdownButton.this.button.isEnabled();
        }

        @Override
        public void paint(Graphics graphics) {
            if (DropdownButton.this.pushed || !DropdownButton.this.button.isEnabled() || DropdownButton.this.container.getComponent(0) == this) {
                Rectangle rectangle = graphics.getClipBounds();
                graphics.setClip(this.getWidth() - POPUP_EXTENT, 0, POPUP_EXTENT, this.getHeight());
                super.paint(graphics);
                graphics.setClip(rectangle);
            }
        }

        @Override
        public void repaint() {
            DropdownButton.this.repaint();
        }
    }

    private class Button
    extends SmallButton {
        Button(String string, Icon icon) {
            super(string, icon);
            this.putClientProperty("MetalListener", new Object());
            if (UIUtils.isAquaLookAndFeel()) {
                this.putClientProperty("JComponent.sizeVariant", "regular");
            }
            this.setModel(new DefaultButtonModel(){

                @Override
                public boolean isRollover() {
                    return super.isRollover() || this.isEnabled() && DropdownButton.this.popup != null && DropdownButton.this.popup.getModel().isRollover();
                }

                @Override
                public boolean isPressed() {
                    return DropdownButton.this.pushed || super.isPressed();
                }

                @Override
                public boolean isArmed() {
                    return DropdownButton.this.pushed || super.isArmed();
                }
            });
            this.setHorizontalAlignment(10);
            this.setDefaultCapable(false);
        }

        public String getToolTipText() {
            Object object;
            if (DropdownButton.this.pushed && (object = this.getClientProperty("PUSHED_TOOLTIP")) != null) {
                return object.toString();
            }
            return super.getToolTipText();
        }

        protected void fireActionPerformed(ActionEvent actionEvent) {
            super.fireActionPerformed(actionEvent);
            DropdownButton.this.performAction();
        }

        protected void processEvent(AWTEvent aWTEvent) {
            if (!(aWTEvent instanceof MouseEvent)) {
                this.processEventImpl(aWTEvent);
            } else {
                DropdownButton.this.processChildMouseEvent((MouseEvent)aWTEvent);
            }
        }

        private void processEventImpl(AWTEvent aWTEvent) {
            super.processEvent(aWTEvent);
        }

        public boolean hasFocus() {
            return this.isEnabled() ? super.hasFocus() : DropdownButton.this.popup.hasFocus();
        }

        public void paint(Graphics graphics) {
            Rectangle rectangle = graphics.getClipBounds();
            if (DropdownButton.this.pushed || !this.isEnabled() || DropdownButton.this.container.getComponent(0) != this) {
                graphics.setClip(0, 0, this.getWidth() - POPUP_EXTENT, this.getHeight());
            }
            super.paint(graphics);
            graphics.setClip(rectangle);
        }

        public void repaint() {
            DropdownButton.this.repaint();
        }

        public Insets getMargin() {
            Insets insets = super.getMargin();
            if (UIUtils.isWindowsClassicLookAndFeel()) {
                if (insets == null) {
                    insets = new Insets(1, 1, 1, 1);
                } else {
                    insets.top = 1;
                    insets.left = 1;
                    insets.bottom = 1;
                    insets.right = 1;
                }
            } else if (UIUtils.isNimbusLookAndFeel()) {
                if (insets == null) {
                    insets = new Insets(0, 2, 0, 2);
                } else {
                    insets.left = 2;
                    insets.right = 2;
                }
            } else if (UIUtils.isAquaLookAndFeel()) {
                if (insets == null) {
                    insets = new Insets(0, -6, 0, 0);
                } else {
                    insets.left = -6;
                    insets.right = 0;
                }
            }
            return insets;
        }
    }
}

