/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import org.netbeans.lib.profiler.server.ProfilerRuntimeMemory;
import org.netbeans.lib.profiler.server.ThreadInfo;
import org.netbeans.lib.profiler.server.system.GC;
import org.netbeans.lib.profiler.server.system.Threads;

public class ProfilerRuntimeObjLiveness
extends ProfilerRuntimeMemory {
    protected static ReferenceQueue rq;
    protected static WeakRefSet objSet;
    protected static ReferenceManagerThread rmt;
    protected static boolean runGCOnGetResults;
    protected static boolean objLivenessProfilingDisabled;

    public static void enableProfiling(boolean bl) {
        if (bl) {
            ProfilerRuntimeObjLiveness.createNewDataStructures();
            GC.resetGCEpochCounter();
            ProfilerRuntimeMemory.enableProfiling(true);
            objLivenessProfilingDisabled = false;
        } else {
            objLivenessProfilingDisabled = true;
            ProfilerRuntimeMemory.enableProfiling(false);
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ProfilerRuntimeObjLiveness.clearDataStructures();
        }
    }

    public static void resetProfilerCollectors() {
        if (rmt != null) {
            GC.runGC();
            rmt.terminate();
        }
        ProfilerRuntimeObjLiveness.createNewDataStructures();
    }

    public static void signalObjGC(ProfilerRuntimeObjLivenessWeakRef profilerRuntimeObjLivenessWeakRef) {
        long l = profilerRuntimeObjLivenessWeakRef.objId;
        objSet.remove(profilerRuntimeObjLivenessWeakRef);
        ProfilerRuntimeObjLiveness.writeObjGCEvent(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void traceObjAlloc(Object object, char c) {
        int n;
        if (objLivenessProfilingDisabled) {
            return;
        }
        if (ThreadInfo.profilingSuspended() || ThreadInfo.isCurrentThreadProfilerServerThread() || c == '\u0000' && ProfilerRuntimeObjLiveness.isInternalClass(object.getClass())) {
            return;
        }
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        if (!threadInfo.isInitialized()) {
            threadInfo.initialize();
            if (lockContentionMonitoringEnabled) {
                ProfilerRuntimeObjLiveness.writeThreadCreationEvent(threadInfo);
            }
        }
        if (threadInfo.inProfilingRuntimeMethod > 0) {
            return;
        }
        ++threadInfo.inProfilingRuntimeMethod;
        if (c == '\u0000') {
            n = ProfilerRuntimeObjLiveness.getClassId(object.getClass());
            if (n == -1) {
                --threadInfo.inProfilingRuntimeMethod;
                return;
            }
        } else {
            n = c & 0xFF;
            n |= c & 0xFF00;
        }
        int n2 = 0;
        int[] nArray = allocatedInstancesCount;
        synchronized (allocatedInstancesCount) {
            int n3 = n;
            int n4 = allocatedInstancesCount[n3] + 1;
            allocatedInstancesCount[n3] = n4;
            n2 = n4;
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (allocatedInstThreshold[n] <= 0) {
                char c2 = (char)GC.getCurrentGCEpoch();
                long l = (long)n << 48 | (long)c2 << 32 | (long)n2;
                ProfilerRuntimeObjLivenessWeakRef profilerRuntimeObjLivenessWeakRef = new ProfilerRuntimeObjLivenessWeakRef(object, rq, l);
                objSet.put(profilerRuntimeObjLivenessWeakRef);
                long l2 = ProfilerRuntimeObjLiveness.getCachedObjectSize(n, object);
                ProfilerRuntimeObjLiveness.getAndSendCurrentStackTrace(n, c2, n2, l2);
                ProfilerRuntimeObjLiveness.allocatedInstThreshold[n] = ProfilerRuntimeObjLiveness.nextRandomizedInterval();
            }
            int n5 = n;
            allocatedInstThreshold[n5] = (short)(allocatedInstThreshold[n5] - 1);
            --threadInfo.inProfilingRuntimeMethod;
            return;
        }
    }

    protected static void setRunGCOnGetResults(boolean bl) {
        runGCOnGetResults = bl;
    }

    protected static boolean getRunGCOnGetResults() {
        return runGCOnGetResults;
    }

    protected static void clearDataStructures() {
        ProfilerRuntimeMemory.clearDataStructures();
        if (rmt != null) {
            GC.runGC();
            rmt.terminate();
        }
        rq = null;
        objSet = null;
        rmt = null;
    }

    protected static void createNewDataStructures() {
        ProfilerRuntimeMemory.createNewDataStructures();
        rq = new ReferenceQueue();
        objSet = new WeakRefSet();
        rmt = new ReferenceManagerThread();
        Threads.recordAdditionalProfilerOwnThread(rmt);
        rmt.start();
    }

    static {
        objLivenessProfilingDisabled = true;
    }

    static class WeakRefSet {
        private WeakReference[] keys;
        private int capacity = 1003;
        private int nObjects;
        private int threshold;

        WeakRefSet() {
            this.setThreshold();
            this.keys = new WeakReference[this.capacity];
        }

        public synchronized void put(WeakReference weakReference) {
            if (this.nObjects > this.threshold) {
                this.rehash();
            }
            int n = (weakReference.hashCode() & Integer.MAX_VALUE) % this.capacity;
            while (this.keys[n] != null) {
                n = (n + 1) % this.capacity;
            }
            this.keys[n] = weakReference;
            ++this.nObjects;
        }

        public synchronized void remove(WeakReference weakReference) {
            int n = (weakReference.hashCode() & Integer.MAX_VALUE) % this.capacity;
            while (this.keys[n] != weakReference) {
                n = (n + 1) % this.capacity;
            }
            this.keys[n] = null;
            --this.nObjects;
        }

        private void setThreshold() {
            this.threshold = this.capacity * 3 / 4;
        }

        private void rehash() {
            WeakReference[] weakReferenceArray = this.keys;
            int n = this.capacity;
            this.capacity = this.capacity * 2 + 1;
            this.keys = new WeakReference[this.capacity];
            for (int i = 0; i < n; ++i) {
                if (weakReferenceArray[i] == null) continue;
                int n2 = (weakReferenceArray[i].hashCode() & Integer.MAX_VALUE) % this.capacity;
                while (this.keys[n2] != null) {
                    n2 = (n2 + 1) % this.capacity;
                }
                this.keys[n2] = weakReferenceArray[i];
            }
            this.setThreshold();
        }
    }

    static class ReferenceManagerThread
    extends Thread {
        private volatile boolean terminated;

        ReferenceManagerThread() {
            ThreadInfo.addProfilerServerThread(this);
            this.setName("*** Profiler Agent Special Execution Thread 3");
        }

        public void run() {
            while (!this.terminated) {
                try {
                    ProfilerRuntimeObjLivenessWeakRef profilerRuntimeObjLivenessWeakRef = (ProfilerRuntimeObjLivenessWeakRef)rq.remove(200L);
                    if (profilerRuntimeObjLivenessWeakRef == null || this.terminated) continue;
                    ProfilerRuntimeObjLiveness.signalObjGC(profilerRuntimeObjLivenessWeakRef);
                }
                catch (InterruptedException interruptedException) {}
            }
            ThreadInfo.removeProfilerServerThread(this);
        }

        public void terminate() {
            this.terminated = true;
        }
    }

    static class ProfilerRuntimeObjLivenessWeakRef
    extends WeakReference {
        long objId;

        ProfilerRuntimeObjLivenessWeakRef(Object object, ReferenceQueue referenceQueue, long l) {
            super(object, referenceQueue);
            this.objId = l;
        }
    }
}

