/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.jvm;

import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.application.jvm.Jvm;
import com.sun.tools.visualvm.jvm.JRockitJVMImpl;
import com.sun.tools.visualvm.jvm.JvmProvider;
import com.sun.tools.visualvm.tools.jmx.JmxModel;
import com.sun.tools.visualvm.tools.jmx.JmxModelFactory;
import com.sun.tools.visualvm.tools.jmx.JvmMXBeans;
import com.sun.tools.visualvm.tools.jmx.JvmMXBeansFactory;
import com.sun.tools.visualvm.tools.jvmstat.JvmstatModel;
import com.sun.tools.visualvm.tools.jvmstat.JvmstatModelFactory;
import java.lang.management.RuntimeMXBean;

public class JRockitJvmProvider
extends JvmProvider {
    private static final String JROCKIT_VM_NAME = "BEA JRockit(R)";
    private static final String VM_NAME = "java.property.java.vm.name";

    @Override
    public Jvm createModelFor(Application app) {
        JRockitJVMImpl jvm = null;
        JvmstatModel jvmstat = JvmstatModelFactory.getJvmstatFor((Application)app);
        if (jvmstat != null) {
            String vmName = jvmstat.findByName(VM_NAME);
            if (JROCKIT_VM_NAME.equals(vmName)) {
                jvm = new JRockitJVMImpl(app, jvmstat);
            }
        } else {
            RuntimeMXBean runtime;
            JvmMXBeans mxbeans;
            JmxModel jmxModel = JmxModelFactory.getJmxModelFor((Application)app);
            if (jmxModel != null && jmxModel.getConnectionState() == JmxModel.ConnectionState.CONNECTED && (mxbeans = JvmMXBeansFactory.getJvmMXBeans((JmxModel)jmxModel)) != null && (runtime = mxbeans.getRuntimeMXBean()) != null && JROCKIT_VM_NAME.equals(runtime.getVmName())) {
                jvm = new JRockitJVMImpl(app);
            }
        }
        return jvm;
    }
}

