/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multitabs.impl;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.ToolTipManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.TableUI;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.core.multitabs.impl.TabDataRenderer;
import org.netbeans.core.multitabs.impl.TabTableModel;
import org.netbeans.core.multitabs.impl.TabTableUI;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDataModel;
import org.openide.util.NbBundle;

public class TabTable
extends JTable {
    private final int orientation;
    private final TabDataRenderer renderer = new TabDataRenderer();
    private int closeButtonRow = -1;
    private int closeButtonCol = -1;

    public TabTable(TabDataModel tabDataModel, int n) {
        this(TabTableModel.create(tabDataModel, n), n == 1 || n == 3 ? 0 : 1);
    }

    protected TabTable(TabTableModel tabTableModel, int n) {
        super(tabTableModel);
        this.orientation = n;
        this.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                if (tableModelEvent.getFirstRow() != -1) {
                    TabTable.this.adjustColumnWidths();
                }
            }
        });
        this.configure();
    }

    private void configure() {
        this.setRowSelectionAllowed(false);
        this.setColumnSelectionAllowed(false);
        this.setCellSelectionEnabled(true);
        this.setTableHeader(null);
        this.setSelectionMode(0);
        this.getColumnModel().getSelectionModel().setSelectionMode(0);
        this.setAutoResizeMode(0);
        this.setOpaque(false);
        this.setFocusable(false);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setDefaultRenderer(Object.class, this.renderer);
    }

    @Override
    protected void initializeLocalVars() {
        super.initializeLocalVars();
        this.setRowHeight(TabDataRenderer.getPreferredTableRowHeight());
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return this.orientation == 0 ? true : super.getScrollableTracksViewportHeight();
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return this.orientation == 0 ? super.getScrollableTracksViewportHeight() : true;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        int n3 = 0;
        if (n == 1) {
            n3 = this.getRowHeight() / 2;
        } else {
            Point point = rectangle.getLocation();
            ++point.x;
            int n4 = this.columnAtPoint(point);
            if (n4 >= 0) {
                Rectangle rectangle2 = this.getCellRect(0, n4, true);
                n3 = rectangle2.width / 2;
            } else {
                n3 = super.getScrollableUnitIncrement(rectangle, n, n2);
            }
        }
        if (n2 < 0) {
            n3 *= -1;
        }
        return n3;
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        int n = this.rowAtPoint(mouseEvent.getPoint());
        int n2 = this.columnAtPoint(mouseEvent.getPoint());
        if (n >= 0 && n2 >= 0) {
            if (this.isCloseButtonHighlighted(n, n2)) {
                return NbBundle.getMessage(TabTable.class, (String)"BtnClose_Tooltip");
            }
            TabData tabData = (TabData)this.getValueAt(n, n2);
            if (null != tabData) {
                return tabData.getTooltip();
            }
        }
        return super.getToolTipText(mouseEvent);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public void createDefaultColumnsFromModel() {
        super.createDefaultColumnsFromModel();
        this.adjustColumnWidths();
    }

    protected void adjustColumnWidths() {
        TableColumnModel tableColumnModel = this.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            int n = 0;
            for (int j = 0; j < this.getRowCount(); ++j) {
                n = Math.max(this.renderer.getPreferredWidth(this.getValueAt(j, i)), n);
            }
            n = Math.max(n, 30);
            tableColumn.setWidth(n += this.getIntercellSpacing().width);
            tableColumn.setMinWidth(n);
            tableColumn.setMaxWidth(n);
            tableColumn.setPreferredWidth(n);
            tableColumn.setResizable(false);
        }
    }

    TabData getTabAt(Point point) {
        if (point.x < 0 || point.y < 0) {
            return null;
        }
        int n = this.rowAtPoint(point);
        int n2 = this.columnAtPoint(point);
        if (n < 0 || n2 < 0) {
            return null;
        }
        return (TabData)this.getValueAt(n, n2);
    }

    void setCurrentCloseButtonCoords(int n, int n2) {
        int n3 = this.closeButtonRow;
        int n4 = this.closeButtonCol;
        boolean bl = n != this.closeButtonRow || n2 != this.closeButtonCol;
        this.closeButtonCol = n2;
        this.closeButtonRow = n;
        if (bl) {
            Rectangle rectangle;
            if (n3 >= 0 && n4 >= 0 && null != (rectangle = this.getCellRect(n3, n4, true))) {
                this.repaint(rectangle);
            }
            if (this.closeButtonRow >= 0 && this.closeButtonCol >= 0 && null != (rectangle = this.getCellRect(this.closeButtonRow, this.closeButtonCol, true))) {
                this.repaint(rectangle);
            }
        }
    }

    boolean isCloseButtonHighlighted(int n, int n2) {
        return n == this.closeButtonRow && this.closeButtonCol == n2;
    }

    Rectangle getTabBounds(int n) {
        TabTableModel tabTableModel = (TabTableModel)this.getModel();
        int n2 = tabTableModel.toColumnIndex(n);
        int n3 = tabTableModel.toRowIndex(n);
        if (n3 >= 0 && n2 >= 0) {
            n2 = this.convertColumnIndexToView(n2);
            n3 = this.convertRowIndexToView(n3);
            return this.getCellRect(n3, n2, true);
        }
        return null;
    }

    @Override
    public void setUI(TableUI tableUI) {
        super.setUI(new TabTableUI());
    }
}

