/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.util.prefs.Preferences;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.api.keyring.Keyring;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

final class NbAuthenticatorPanel
extends JPanel {
    private String realmName;
    private final Preferences prefs;
    private final String keyringKey;
    private JPasswordField password;
    private JLabel passwordLbl;
    private JLabel realmNameLbl;
    private JTextField userName;
    private JLabel userNameLbl;

    public NbAuthenticatorPanel(String string) {
        this.realmName = string;
        this.initComponents();
        this.prefs = NbPreferences.forModule(NbAuthenticatorPanel.class).node("authentication");
        this.keyringKey = "authentication." + string;
        String string2 = this.prefs.get(string, null);
        if (string2 != null) {
            this.userName.setText(string2);
            char[] cArray = Keyring.read((String)this.keyringKey);
            if (cArray != null) {
                this.password.setText(new String(cArray));
            }
        }
    }

    private void initComponents() {
        this.userNameLbl = new JLabel();
        this.userName = new JTextField();
        this.passwordLbl = new JLabel();
        this.password = new JPasswordField();
        this.realmNameLbl = new JLabel();
        this.userNameLbl.setLabelFor(this.userName);
        Mnemonics.setLocalizedText((JLabel)this.userNameLbl, (String)NbBundle.getMessage(NbAuthenticatorPanel.class, (String)"NbAuthenticatorPanel.userNameLbl.text"));
        this.passwordLbl.setLabelFor(this.password);
        Mnemonics.setLocalizedText((JLabel)this.passwordLbl, (String)NbBundle.getMessage(NbAuthenticatorPanel.class, (String)"NbAuthenticatorPanel.passwordLbl.text"));
        this.realmNameLbl.setText(this.realmName);
        this.realmNameLbl.setFocusable(false);
        this.realmNameLbl.setHorizontalTextPosition(0);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.userNameLbl).addComponent(this.passwordLbl)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.realmNameLbl, -1, 287, Short.MAX_VALUE).addComponent(this.password, -1, 287, Short.MAX_VALUE).addComponent(this.userName, -1, 287, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addComponent(this.realmNameLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.userNameLbl).addComponent(this.userName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.passwordLbl).addComponent(this.password, -2, -1, -2)).addContainerGap()));
    }

    public char[] getPassword() {
        Keyring.save((String)this.keyringKey, (char[])this.password.getPassword(), (String)NbBundle.getMessage(NbAuthenticatorPanel.class, (String)"NbAuthenticatorPanel.password.description", (Object)this.realmName));
        return this.password.getPassword();
    }

    public String getUserName() {
        String string = this.userName.getText();
        this.prefs.put(this.realmName, string);
        return string;
    }
}

