/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.memory;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.filters.GenericFilter;
import org.netbeans.lib.profiler.results.memory.MemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.SampledMemoryResultsDiff;
import org.netbeans.lib.profiler.results.memory.SampledMemoryResultsSnapshot;
import org.netbeans.lib.profiler.ui.Formatters;
import org.netbeans.lib.profiler.ui.memory.MemoryView;
import org.netbeans.lib.profiler.ui.swing.ExportUtils;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTableContainer;
import org.netbeans.lib.profiler.ui.swing.renderer.CheckBoxRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.HideableBarRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.JavaNameRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.NumberPercentRenderer;
import org.netbeans.modules.profiler.api.icons.Icons;

abstract class SampledTableView
extends MemoryView {
    private MemoryTableModel tableModel;
    private ProfilerTable table;
    private String[] names;
    private int[] instances;
    private long[] bytes;
    private ClientUtils.SourceCodeSelection[] classNames;
    private final Set<ClientUtils.SourceCodeSelection> selection;
    private HideableBarRenderer[] renderers;

    public SampledTableView(Set<ClientUtils.SourceCodeSelection> set) {
        this.selection = set;
        this.initUI();
    }

    @Override
    protected ProfilerTable getResultsComponent() {
        return this.table;
    }

    @Override
    public void setData(MemoryResultsSnapshot memoryResultsSnapshot, GenericFilter genericFilter, int n) {
        final SampledMemoryResultsSnapshot sampledMemoryResultsSnapshot = (SampledMemoryResultsSnapshot)memoryResultsSnapshot;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean bl = sampledMemoryResultsSnapshot instanceof SampledMemoryResultsDiff;
                long l = 0L;
                long l2 = 0L;
                long l3 = 0L;
                long l4 = 0L;
                SampledTableView.access$002(SampledTableView.this, sampledMemoryResultsSnapshot.getClassNames());
                SampledTableView.access$102(SampledTableView.this, sampledMemoryResultsSnapshot.getObjectsCounts());
                SampledTableView.access$202(SampledTableView.this, sampledMemoryResultsSnapshot.getObjectsSizePerClass());
                SampledTableView.access$302(SampledTableView.this, new ClientUtils.SourceCodeSelection[SampledTableView.this.names.length]);
                for (int i = 0; i < SampledTableView.this.names.length; ++i) {
                    if (bl) {
                        l3 = Math.max(l3, (long)SampledTableView.this.instances[i]);
                        l4 = Math.min(l4, (long)SampledTableView.this.instances[i]);
                        l = Math.max(l, SampledTableView.this.bytes[i]);
                        l2 = Math.min(l2, SampledTableView.this.bytes[i]);
                    } else {
                        l3 += (long)SampledTableView.this.instances[i];
                        l += SampledTableView.this.bytes[i];
                    }
                    ((SampledTableView)SampledTableView.this).classNames[i] = new ClientUtils.SourceCodeSelection(SampledTableView.this.names[i], "*", null);
                }
                if (bl) {
                    SampledTableView.this.renderers[0].setMaxValue(Math.max(Math.abs(l), Math.abs(l2)));
                    SampledTableView.this.renderers[1].setMaxValue(Math.max(Math.abs(l3), Math.abs(l4)));
                } else {
                    SampledTableView.this.renderers[0].setMaxValue(l);
                    SampledTableView.this.renderers[1].setMaxValue(l3);
                }
                SampledTableView.this.renderers[0].setDiffMode(bl);
                SampledTableView.this.renderers[1].setDiffMode(bl);
                SampledTableView.this.tableModel.fireTableDataChanged();
            }
        });
    }

    @Override
    public void resetData() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SampledTableView.access$002(SampledTableView.this, null);
                SampledTableView.access$102(SampledTableView.this, null);
                SampledTableView.access$202(SampledTableView.this, null);
                SampledTableView.access$302(SampledTableView.this, null);
                SampledTableView.this.renderers[0].setMaxValue(0L);
                SampledTableView.this.renderers[1].setMaxValue(0L);
                SampledTableView.this.renderers[0].setDiffMode(false);
                SampledTableView.this.renderers[1].setDiffMode(false);
                SampledTableView.this.tableModel.fireTableDataChanged();
            }
        });
    }

    @Override
    public void showSelectionColumn() {
        this.table.setColumnVisibility(0, true);
    }

    @Override
    public void refreshSelection() {
        this.tableModel.fireTableDataChanged();
    }

    @Override
    public ExportUtils.ExportProvider[] getExportProviders() {
        ExportUtils.ExportProvider[] exportProviderArray;
        if (this.table.getRowCount() == 0) {
            exportProviderArray = null;
        } else {
            ExportUtils.ExportProvider[] exportProviderArray2 = new ExportUtils.ExportProvider[4];
            exportProviderArray2[0] = new ExportUtils.CSVExportProvider(this.table);
            exportProviderArray2[1] = new ExportUtils.HTMLExportProvider(this.table, EXPORT_LIVE);
            exportProviderArray2[2] = new ExportUtils.XMLExportProvider(this.table, EXPORT_LIVE);
            exportProviderArray = exportProviderArray2;
            exportProviderArray2[3] = new ExportUtils.PNGExportProvider(this.table);
        }
        return exportProviderArray;
    }

    @Override
    protected abstract void performDefaultAction(ClientUtils.SourceCodeSelection var1);

    protected abstract void populatePopup(JPopupMenu var1, Object var2, ClientUtils.SourceCodeSelection var3);

    protected void popupShowing() {
    }

    protected void popupHidden() {
    }

    private void initUI() {
        String[] stringArray;
        int n = this.selection == null ? -1 : 0;
        this.tableModel = new MemoryTableModel();
        this.table = new ProfilerTable(this.tableModel, true, true, null){

            public ClientUtils.SourceCodeSelection getUserValueForRow(int n) {
                return SampledTableView.this.getUserValueForRow(n);
            }

            @Override
            protected void populatePopup(JPopupMenu jPopupMenu, Object object, Object object2) {
                SampledTableView.this.populatePopup(jPopupMenu, object, (ClientUtils.SourceCodeSelection)object2);
            }

            @Override
            protected void popupShowing() {
                SampledTableView.this.popupShowing();
            }

            @Override
            protected void popupHidden() {
                SampledTableView.this.popupHidden();
            }
        };
        if (this.selection == null) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = NAME_COLUMN_TOOLTIP;
            stringArray2[1] = LIVE_SIZE_COLUMN_TOOLTIP;
            stringArray = stringArray2;
            stringArray2[2] = LIVE_COUNT_COLUMN_TOOLTIP;
        } else {
            String[] stringArray3 = new String[4];
            stringArray3[0] = SELECTED_COLUMN_TOOLTIP;
            stringArray3[1] = NAME_COLUMN_TOOLTIP;
            stringArray3[2] = LIVE_SIZE_COLUMN_TOOLTIP;
            stringArray = stringArray3;
            stringArray3[3] = LIVE_COUNT_COLUMN_TOOLTIP;
        }
        this.table.setColumnToolTips(stringArray);
        this.table.providePopupMenu(true);
        this.installDefaultAction();
        this.table.setMainColumn(1 + n);
        this.table.setFitWidthColumn(1 + n);
        this.table.setSortColumn(2 + n);
        this.table.setDefaultSortOrder(1 + n, SortOrder.ASCENDING);
        if (this.selection != null) {
            this.table.setColumnVisibility(0, false);
        }
        this.renderers = new HideableBarRenderer[2];
        this.renderers[0] = new HideableBarRenderer(new NumberPercentRenderer(Formatters.bytesFormat()));
        this.renderers[1] = new HideableBarRenderer(new NumberPercentRenderer());
        this.renderers[0].setMaxValue(123456789L);
        this.renderers[1].setMaxValue(12345678L);
        if (this.selection != null) {
            this.table.setColumnRenderer(0, new CheckBoxRenderer());
        }
        this.table.setColumnRenderer(1 + n, new JavaNameRenderer(Icons.getIcon((String)"LanguageIcons.Class")));
        this.table.setColumnRenderer(2 + n, this.renderers[0]);
        this.table.setColumnRenderer(3 + n, this.renderers[1]);
        if (this.selection != null) {
            int n2 = new JLabel((String)this.table.getColumnName((int)0)).getPreferredSize().width;
            this.table.setDefaultColumnWidth(0, n2 + 15);
        }
        this.table.setDefaultColumnWidth(2 + n, this.renderers[0].getOptimalWidth());
        this.table.setDefaultColumnWidth(3 + n, this.renderers[1].getMaxNoBarWidth());
        ProfilerTableContainer profilerTableContainer = new ProfilerTableContainer(this.table, false, null);
        this.setLayout(new BorderLayout());
        this.add((Component)profilerTableContainer, "Center");
    }

    @Override
    protected ClientUtils.SourceCodeSelection getUserValueForRow(int n) {
        if (this.names == null || n == -1) {
            return null;
        }
        if (n >= this.tableModel.getRowCount()) {
            return null;
        }
        return this.classNames[this.table.convertRowIndexToModel(n)];
    }

    static /* synthetic */ String[] access$002(SampledTableView sampledTableView, String[] stringArray) {
        sampledTableView.names = stringArray;
        return stringArray;
    }

    static /* synthetic */ int[] access$102(SampledTableView sampledTableView, int[] nArray) {
        sampledTableView.instances = nArray;
        return nArray;
    }

    static /* synthetic */ long[] access$202(SampledTableView sampledTableView, long[] lArray) {
        sampledTableView.bytes = lArray;
        return lArray;
    }

    static /* synthetic */ ClientUtils.SourceCodeSelection[] access$302(SampledTableView sampledTableView, ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray) {
        sampledTableView.classNames = sourceCodeSelectionArray;
        return sourceCodeSelectionArray;
    }

    private class MemoryTableModel
    extends AbstractTableModel {
        private MemoryTableModel() {
        }

        @Override
        public String getColumnName(int n) {
            if (SampledTableView.this.selection == null) {
                ++n;
            }
            if (n == 1) {
                return MemoryView.COLUMN_NAME;
            }
            if (n == 2) {
                return MemoryView.COLUMN_LIVE_BYTES;
            }
            if (n == 3) {
                return MemoryView.COLUMN_LIVE_OBJECTS;
            }
            if (n == 0) {
                return MemoryView.COLUMN_SELECTED;
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (SampledTableView.this.selection == null) {
                ++n;
            }
            if (n == 1) {
                return String.class;
            }
            if (n == 0) {
                return Boolean.class;
            }
            return Long.class;
        }

        @Override
        public int getRowCount() {
            return SampledTableView.this.names == null ? 0 : SampledTableView.this.names.length;
        }

        @Override
        public int getColumnCount() {
            return SampledTableView.this.selection == null ? 3 : 4;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (SampledTableView.this.names == null) {
                return null;
            }
            if (SampledTableView.this.selection == null) {
                ++n2;
            }
            if (n2 == 1) {
                return SampledTableView.this.names[n];
            }
            if (n2 == 2) {
                return SampledTableView.this.bytes[n];
            }
            if (n2 == 3) {
                return SampledTableView.this.instances[n];
            }
            if (n2 == 0) {
                if (SampledTableView.this.selection.isEmpty()) {
                    return Boolean.FALSE;
                }
                return SampledTableView.this.selection.contains(SampledTableView.this.classNames[n]);
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (SampledTableView.this.selection == null) {
                ++n2;
            }
            if (n2 == 0) {
                if (Boolean.FALSE.equals(object)) {
                    SampledTableView.this.selection.remove(SampledTableView.this.classNames[n]);
                } else {
                    SampledTableView.this.selection.add(SampledTableView.this.classNames[n]);
                }
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (SampledTableView.this.selection == null) {
                ++n2;
            }
            return n2 == 0;
        }
    }
}

