/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.nio.charset.Charset;
import java.util.List;
import org.netbeans.modules.search.ArraySet;
import org.netbeans.modules.search.BasicComposition;
import org.netbeans.modules.search.BasicSearchCriteria;
import org.netbeans.modules.search.Constants;
import org.netbeans.modules.search.MatchingObject;
import org.netbeans.modules.search.TextDetail;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;

public final class ResultModel {
    public static final String PROP_SELECTION = "selection";
    public static final String PROP_VALID = "valid";
    public static final String PROP_MATCHING_OBJECTS = "matchingObjects";
    public static final String PROP_RESULTS_EDIT = "resultsEdit";
    private long startTime;
    private int totalDetailsCount = 0;
    private Constants.Limit limitReached = null;
    final BasicSearchCriteria basicCriteria;
    final BasicComposition basicComposition;
    private final boolean isFullText;
    final String replaceString;
    final boolean searchAndReplace;
    private final List<MatchingObject> matchingObjects = new ArraySet(500).ordering(false).nullIsAllowed(false);
    private String finishMessage;
    private volatile boolean valid = true;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private int selectedMatches = 0;
    private final MatchingObjectListener matchingObjectListener = new MatchingObjectListener();
    private MatchingObject infoCacheMatchingObject;
    private Boolean infoCacheHasDetails;
    private int infoCacheDetailsCount;
    private Node[] infoCacheDetailNodes;
    private final Node[] EMPTY_NODES_ARRAY = new Node[0];

    ResultModel(BasicSearchCriteria basicSearchCriteria, String string, BasicComposition basicComposition) {
        this.replaceString = string;
        this.searchAndReplace = string != null;
        this.basicComposition = basicComposition;
        this.basicCriteria = basicSearchCriteria;
        this.isFullText = this.basicCriteria != null && this.basicCriteria.isFullText();
        this.startTime = -1L;
    }

    public synchronized boolean remove(MatchingObject matchingObject) {
        if (this.matchingObjects.remove(matchingObject)) {
            this.totalDetailsCount -= matchingObject.getMatchesCount();
            int n = 0;
            if (matchingObject.getTextDetails() != null) {
                for (TextDetail textDetail : matchingObject.getTextDetails()) {
                    n += textDetail.isSelected() ? -1 : 0;
                }
            }
            matchingObject.cleanup();
            this.propertyChangeSupport.firePropertyChange(PROP_RESULTS_EDIT, null, null);
            if (n < 0) {
                this.updateSelected(n);
            }
            if (matchingObject.isSelected() && !matchingObject.isValid()) {
                this.checkValid();
            }
            return true;
        }
        return false;
    }

    public synchronized void removeDetailMatch(MatchingObject matchingObject, TextDetail textDetail) {
        if (textDetail.isSelected()) {
            this.updateSelected(-1);
        }
        --this.totalDetailsCount;
        this.propertyChangeSupport.firePropertyChange(PROP_RESULTS_EDIT, null, null);
        if (matchingObject.textDetails.isEmpty()) {
            this.remove(matchingObject);
        }
    }

    synchronized long getStartTime() {
        if (this.startTime == -1L) {
            throw new IllegalStateException("Search has not started yet");
        }
        return this.startTime;
    }

    public synchronized void close() {
        if (this.matchingObjects != null && !this.matchingObjects.isEmpty()) {
            for (MatchingObject matchingObject : this.matchingObjects) {
                matchingObject.cleanup();
            }
        }
    }

    public synchronized boolean objectFound(FileObject fileObject, Charset charset, List<TextDetail> list) {
        assert (this.limitReached == null);
        MatchingObject matchingObject = new MatchingObject(this, fileObject, charset, list);
        boolean bl = this.add(matchingObject);
        if (bl) {
            this.totalDetailsCount += this.getDetailsCount(matchingObject);
            int n = 0;
            if (matchingObject.getTextDetails() != null) {
                matchingObject.addPropertyChangeListener(this.matchingObjectListener);
                for (TextDetail textDetail : matchingObject.getTextDetails()) {
                    if (!textDetail.isSelected()) continue;
                    ++n;
                }
                this.updateSelected(n);
            }
            this.propertyChangeSupport.firePropertyChange(PROP_MATCHING_OBJECTS, null, null);
        } else {
            matchingObject.cleanup();
        }
        this.checkLimits();
        return bl;
    }

    private boolean add(MatchingObject matchingObject) {
        try {
            return this.matchingObjects.add(matchingObject);
        }
        catch (IllegalStateException illegalStateException) {
            this.limitReached = Constants.Limit.FILES_COUNT_LIMIT;
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    private boolean checkLimits() {
        if (this.totalDetailsCount >= 5000) {
            this.limitReached = Constants.Limit.MATCHES_COUNT_LIMIT;
            return true;
        }
        return false;
    }

    private void setInvalid() {
        if (this.valid) {
            this.valid = false;
            this.propertyChangeSupport.firePropertyChange(PROP_VALID, true, false);
        }
    }

    private void checkValid() {
        boolean bl = true;
        for (MatchingObject matchingObject : this.getMatchingObjects()) {
            if (!matchingObject.isSelected() || matchingObject.isValid()) continue;
            bl = false;
        }
        if (this.valid != bl) {
            this.valid = bl;
            this.propertyChangeSupport.firePropertyChange(PROP_VALID, !bl, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void objectValidityChanged(MatchingObject matchingObject) {
        if (matchingObject.isSelected()) {
            if (matchingObject.isValid()) {
                ResultModel resultModel = this;
                synchronized (resultModel) {
                    this.totalDetailsCount = 0;
                    for (MatchingObject matchingObject2 : this.matchingObjects) {
                        this.totalDetailsCount += matchingObject2.getDetailsCount();
                    }
                }
                this.checkValid();
            } else {
                this.setInvalid();
            }
        }
    }

    private void objectSelectionChanged(MatchingObject matchingObject) {
        if (!matchingObject.isValid()) {
            if (matchingObject.isSelected()) {
                this.setInvalid();
            } else {
                this.checkValid();
            }
        }
    }

    public synchronized int getTotalDetailsCount() {
        return this.totalDetailsCount;
    }

    public synchronized List<MatchingObject> getMatchingObjects() {
        return this.matchingObjects;
    }

    public boolean hasDetails() {
        return this.totalDetailsCount != 0;
    }

    public boolean canHaveDetails() {
        return this.isFullText;
    }

    private void prepareCacheFor(MatchingObject matchingObject) {
        if (matchingObject != this.infoCacheMatchingObject) {
            this.infoCacheHasDetails = null;
            this.infoCacheDetailsCount = -1;
            this.infoCacheDetailNodes = null;
            this.infoCacheMatchingObject = matchingObject;
        }
    }

    synchronized int getDetailsCount(MatchingObject matchingObject) {
        this.prepareCacheFor(matchingObject);
        if (this.infoCacheDetailsCount == -1) {
            this.infoCacheDetailsCount = this.getDetailsCountReal(matchingObject);
            if (this.infoCacheDetailsCount == 0) {
                this.infoCacheDetailNodes = this.EMPTY_NODES_ARRAY;
            }
        }
        assert (this.infoCacheDetailsCount >= 0);
        return this.infoCacheDetailsCount;
    }

    private int getDetailsCountReal(MatchingObject matchingObject) {
        int n = this.isFullText ? matchingObject.getDetailsCount() : 0;
        return n;
    }

    synchronized Node[] getDetails(MatchingObject matchingObject) {
        Node[] nodeArray;
        if (matchingObject == null) {
            return null;
        }
        this.prepareCacheFor(matchingObject);
        if (this.infoCacheDetailNodes == null) {
            nodeArray = this.getDetailsReal(matchingObject);
            this.infoCacheDetailNodes = nodeArray != null ? nodeArray : this.EMPTY_NODES_ARRAY;
            this.infoCacheDetailsCount = this.infoCacheDetailNodes.length;
        } else {
            Node[] nodeArray2 = nodeArray = this.infoCacheDetailNodes != this.EMPTY_NODES_ARRAY ? this.infoCacheDetailNodes : null;
        }
        assert (this.infoCacheDetailNodes != null && (this.infoCacheDetailNodes == this.EMPTY_NODES_ARRAY || this.infoCacheDetailNodes.length > 0));
        assert (nodeArray == null || nodeArray.length > 0);
        return nodeArray;
    }

    private Node[] getDetailsReal(MatchingObject matchingObject) {
        Node[] nodeArray = null;
        if (this.basicCriteria != null) {
            nodeArray = this.basicCriteria.isFullText() ? matchingObject.getDetails() : null;
        }
        return nodeArray;
    }

    public synchronized int size() {
        return this.matchingObjects.size();
    }

    public synchronized boolean wasLimitReached() {
        return this.limitReached != null;
    }

    public String getLimitDisplayName() {
        return this.limitReached != null ? this.limitReached.getDisplayName() : null;
    }

    synchronized void searchException(RuntimeException runtimeException) {
        ErrorManager.Annotation[] annotationArray;
        for (ErrorManager.Annotation annotation : annotationArray = ErrorManager.getDefault().findAnnotations((Throwable)runtimeException)) {
            if (annotation.getSeverity() != 256) continue;
            this.finishMessage = annotation.getLocalizedMessage();
            if (this.finishMessage == null) continue;
            return;
        }
        this.finishMessage = runtimeException.getLocalizedMessage();
    }

    public synchronized String getExceptionMsg() {
        return this.finishMessage;
    }

    public boolean isSearchAndReplace() {
        return this.searchAndReplace;
    }

    public synchronized int getSelectedMatchesCount() {
        return this.selectedMatches;
    }

    public boolean isValid() {
        return this.valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSelected(int n) {
        int n2;
        int n3;
        ResultModel resultModel = this;
        synchronized (resultModel) {
            n3 = this.selectedMatches;
            this.selectedMatches = n2 = n3 + n;
        }
        this.propertyChangeSupport.firePropertyChange(PROP_SELECTION, n3, n2);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    synchronized void setStartTime() {
        if (this.startTime != -1L) {
            throw new IllegalStateException();
        }
        this.startTime = System.currentTimeMillis();
    }

    private class MatchingObjectListener
    implements PropertyChangeListener {
        private MatchingObjectListener() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getSource();
            if (!(object instanceof MatchingObject)) {
                throw new IllegalArgumentException();
            }
            MatchingObject matchingObject = (MatchingObject)object;
            String string = propertyChangeEvent.getPropertyName();
            if ("matchesSelected".equals(string)) {
                Object object2 = propertyChangeEvent.getNewValue();
                Object object3 = propertyChangeEvent.getOldValue();
                if (!(object2 instanceof Integer) || !(object3 instanceof Integer)) throw new IllegalArgumentException();
                ResultModel.this.updateSelected((Integer)object2 - (Integer)object3);
                return;
            } else if ("invalidityStatus".equals(string)) {
                ResultModel.this.objectValidityChanged(matchingObject);
                return;
            } else {
                if (!"selected".equals(string)) return;
                ResultModel.this.objectSelectionChanged(matchingObject);
            }
        }
    }
}

