/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.details.jdk;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsProvider;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsUtils;

public final class NetDetailsProvider
extends DetailsProvider.Basic {
    private static final String URL_MASK = "java.net.URL";
    private static final String INET4_ADDRESS_MASK = "java.net.Inet4Address";
    private static final String INET6_ADDRESS_MASK = "java.net.Inet6Address";
    private static final String NETWORK_IF_MASK = "java.net.NetworkInterface";
    private static final String IF_ADDRESS_MASK = "java.net.InterfaceAddress+";
    private static final String URL_CONN_MASK = "java.net.URLConnection+";
    private static final String URI_MASK = "java.net.URI";
    private static final String HTTP_COOKIE_MASK = "java.net.HttpCookie";
    private static final String INET_SOCKET_ADDRERSS = "java.net.InetSocketAddress+";

    public NetDetailsProvider() {
        super(URL_MASK, INET4_ADDRESS_MASK, INET6_ADDRESS_MASK, NETWORK_IF_MASK, IF_ADDRESS_MASK, URL_CONN_MASK, URI_MASK, HTTP_COOKIE_MASK, INET_SOCKET_ADDRERSS);
    }

    @Override
    public String getDetailsString(String string, Instance instance, Heap heap) {
        if (URL_MASK.equals(string)) {
            String string2 = DetailsUtils.getInstanceFieldString(instance, "file", heap);
            String string3 = DetailsUtils.getInstanceFieldString(instance, "host", heap);
            String string4 = DetailsUtils.getInstanceFieldString(instance, "protocol", heap);
            int n = DetailsUtils.getIntFieldValue(instance, "port", -1);
            if (string2 != null && string4 != null) {
                try {
                    return new URL(string4, string3, n, string2).toExternalForm();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return DetailsUtils.getInstanceFieldString(instance, "path", heap);
        }
        if (INET4_ADDRESS_MASK.equals(string) || INET6_ADDRESS_MASK.equals(string)) {
            String string5;
            Instance instance2 = (Instance)instance.getValueOfField("holder");
            if (instance2 != null) {
                string5 = DetailsUtils.getInstanceFieldString(instance2, "hostName", heap);
                instance = INET4_ADDRESS_MASK.equals(string) ? instance2 : (Instance)instance.getValueOfField("holder6");
            } else {
                string5 = DetailsUtils.getInstanceFieldString(instance, "hostName", heap);
            }
            String string6 = null;
            if (!"0.0.0.0".equals(string5)) {
                if (INET4_ADDRESS_MASK.equals(string)) {
                    int n = DetailsUtils.getIntFieldValue(instance, "address", 0);
                    string6 = NetDetailsProvider.getHostInet4Address(n);
                } else {
                    Object object;
                    List<String> list = DetailsUtils.getPrimitiveArrayFieldValues(instance, "ipaddress");
                    byte[] byArray = DetailsUtils.getByteArray(list);
                    boolean bl = DetailsUtils.getBooleanFieldValue(instance, "scope_ifname_set", false);
                    String string7 = null;
                    if (bl && (object = instance.getValueOfField("scope_ifname")) instanceof Instance) {
                        string7 = DetailsUtils.getInstanceFieldString(instance, "name", heap);
                    }
                    boolean bl2 = DetailsUtils.getBooleanFieldValue(instance, "scope_id_set", false);
                    int n = DetailsUtils.getIntFieldValue(instance, "scope_id", 0);
                    string6 = this.getHostInet6Address(byArray, bl, string7, bl2, n);
                }
            }
            if (string5 == null) {
                return string6;
            }
            if (string6 == null) {
                return string5;
            }
            return string5 + " [" + string6 + "]";
        }
        if (NETWORK_IF_MASK.equals(string)) {
            String string8;
            String string9 = DetailsUtils.getInstanceFieldString(instance, "name", heap);
            if (string9 == null) {
                string9 = new String();
            }
            if ((string8 = DetailsUtils.getInstanceFieldString(instance, "displayName", heap)) == null) {
                string8 = new String();
            }
            if (!string9.isEmpty() && !string8.isEmpty()) {
                string9 = string9 + " - ";
            }
            return string9 + string8;
        }
        if (IF_ADDRESS_MASK.equals(string)) {
            String string10;
            String string11 = DetailsUtils.getInstanceFieldString(instance, "address", heap);
            if (string11 == null) {
                string11 = "";
            }
            if ((string10 = DetailsUtils.getInstanceFieldString(instance, "broadcast", heap)) == null) {
                string10 = new String();
            }
            short s = DetailsUtils.getShortFieldValue(instance, "maskLength", (short)0);
            return string11 + "/" + s + " [" + string10 + "]";
        }
        if (URL_CONN_MASK.equals(string)) {
            String string12 = DetailsUtils.getInstanceFieldString(instance, "url", heap);
            if (string12 == null) {
                string12 = "";
            }
            return string12;
        }
        if (URI_MASK.equals(string)) {
            String string13 = DetailsUtils.getInstanceFieldString(instance, "string", heap);
            if (string13 != null) {
                return string13;
            }
            String string14 = DetailsUtils.getInstanceFieldString(instance, "scheme", heap);
            String string15 = DetailsUtils.getInstanceFieldString(instance, "path", heap);
            String string16 = DetailsUtils.getInstanceFieldString(instance, "schemeSpecificPart", heap);
            String string17 = DetailsUtils.getInstanceFieldString(instance, "host", heap);
            String string18 = DetailsUtils.getInstanceFieldString(instance, "userInfo", heap);
            int n = DetailsUtils.getIntFieldValue(instance, "name", -1);
            String string19 = DetailsUtils.getInstanceFieldString(instance, "authority", heap);
            String string20 = DetailsUtils.getInstanceFieldString(instance, "query", heap);
            String string21 = DetailsUtils.getInstanceFieldString(instance, "fragment", heap);
            return this.defineURIString(string14, string15, string16, string17, string18, n, string19, string20, string21);
        }
        if (HTTP_COOKIE_MASK.equals(string)) {
            String string22 = DetailsUtils.getInstanceFieldString(instance, "name", heap);
            String string23 = DetailsUtils.getInstanceFieldString(instance, "value", heap);
            return string22 + "=" + string23;
        }
        if (INET_SOCKET_ADDRERSS.equals(string)) {
            String string24 = DetailsUtils.getInstanceFieldString(instance, "hostname", heap);
            String string25 = DetailsUtils.getInstanceFieldString(instance, "addr", heap);
            int n = DetailsUtils.getIntFieldValue(instance, "port", -1);
            StringBuilder stringBuilder = new StringBuilder();
            if (string24 != null) {
                stringBuilder.append(string24);
            }
            if (string25 != null) {
                if (string24 != null) {
                    stringBuilder.append("[").append(string25).append("]");
                } else {
                    stringBuilder.append(string25);
                }
            }
            stringBuilder.append(":").append(n);
            return stringBuilder.toString();
        }
        return null;
    }

    private static String getHostInet4Address(int n) {
        return NetDetailsProvider.numericToTextFormatInet4(NetDetailsProvider.getInet4Address(n));
    }

    private static byte[] getInet4Address(int n) {
        byte[] byArray = new byte[]{(byte)(n >>> 24 & 0xFF), (byte)(n >>> 16 & 0xFF), (byte)(n >>> 8 & 0xFF), (byte)(n & 0xFF)};
        return byArray;
    }

    private static String numericToTextFormatInet4(byte[] byArray) {
        return (byArray[0] & 0xFF) + "." + (byArray[1] & 0xFF) + "." + (byArray[2] & 0xFF) + "." + (byArray[3] & 0xFF);
    }

    public String getHostInet6Address(byte[] byArray, boolean bl, String string, boolean bl2, int n) {
        String string2 = NetDetailsProvider.numericToTextFormatInet6(byArray);
        if (bl) {
            string2 = string2 + "%" + string;
        } else if (bl2) {
            string2 = string2 + "%" + n;
        }
        return string2;
    }

    private static String numericToTextFormatInet6(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(39);
        for (int i = 0; i < 8; ++i) {
            stringBuilder.append(Integer.toHexString(byArray[i << 1] << 8 & 0xFF00 | byArray[(i << 1) + 1] & 0xFF));
            if (i >= 7) continue;
            stringBuilder.append(":");
        }
        return stringBuilder.toString();
    }

    private String defineURIString(String string, String string2, String string3, String string4, String string5, int n, String string6, String string7, String string8) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null) {
            stringBuilder.append(string);
            stringBuilder.append(':');
        }
        if (string2 == null) {
            stringBuilder.append(string3);
        } else {
            if (string4 != null) {
                boolean bl;
                stringBuilder.append("//");
                if (string5 != null) {
                    stringBuilder.append(string5);
                    stringBuilder.append('@');
                }
                boolean bl2 = bl = string4.indexOf(58) >= 0 && !string4.startsWith("[") && !string4.endsWith("]");
                if (bl) {
                    stringBuilder.append('[');
                }
                stringBuilder.append(string4);
                if (bl) {
                    stringBuilder.append(']');
                }
                if (n != -1) {
                    stringBuilder.append(':');
                    stringBuilder.append(n);
                }
            } else if (string6 != null) {
                stringBuilder.append("//");
                stringBuilder.append(string6);
            }
            if (string2 != null) {
                stringBuilder.append(string2);
            }
            if (string7 != null) {
                stringBuilder.append('?');
                stringBuilder.append(string7);
            }
        }
        if (string8 != null) {
            stringBuilder.append('#');
            stringBuilder.append(string8);
        }
        return stringBuilder.toString();
    }
}

