/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.layout.plugin.forceAtlas2;

import org.gephi.graph.api.Node;
import org.gephi.layout.plugin.forceAtlas2.ForceAtlas2LayoutData;
import org.gephi.layout.plugin.forceAtlas2.Region;

public class ForceFactory {
    public static ForceFactory builder = new ForceFactory();

    private ForceFactory() {
    }

    public RepulsionForce buildRepulsion(boolean adjustBySize, double coefficient) {
        if (adjustBySize) {
            return new linRepulsion_antiCollision(coefficient);
        }
        return new linRepulsion(coefficient);
    }

    public RepulsionForce getStrongGravity(double coefficient) {
        return new strongGravity(coefficient);
    }

    public AttractionForce buildAttraction(boolean logAttraction2, boolean distributedAttraction, boolean adjustBySize, double coefficient) {
        if (adjustBySize) {
            if (logAttraction2) {
                if (distributedAttraction) {
                    return new logAttraction_degreeDistributed_antiCollision(coefficient);
                }
                return new logAttraction_antiCollision(coefficient);
            }
            if (distributedAttraction) {
                return new linAttraction_degreeDistributed_antiCollision(coefficient);
            }
            return new linAttraction_antiCollision(coefficient);
        }
        if (logAttraction2) {
            if (distributedAttraction) {
                return new logAttraction_degreeDistributed(coefficient);
            }
            return new logAttraction(coefficient);
        }
        if (distributedAttraction) {
            return new linAttraction_massDistributed(coefficient);
        }
        return new linAttraction(coefficient);
    }

    private class logAttraction_degreeDistributed_antiCollision
    extends AttractionForce {
        private double coefficient;

        public logAttraction_degreeDistributed_antiCollision(double c) {
            this.coefficient = c;
        }

        @Override
        public void apply(Node n1, Node n2, double e) {
            double yDist;
            ForceAtlas2LayoutData n1Layout = (ForceAtlas2LayoutData)n1.getLayoutData();
            ForceAtlas2LayoutData n2Layout = (ForceAtlas2LayoutData)n2.getLayoutData();
            double xDist = n1.x() - n2.x();
            double distance = Math.sqrt(xDist * xDist + (yDist = (double)(n1.y() - n2.y())) * yDist) - (double)n1.size() - (double)n2.size();
            if (distance > 0.0) {
                double factor = -this.coefficient * e * Math.log(1.0 + distance) / distance / n1Layout.mass;
                n1Layout.dx += xDist * factor;
                n1Layout.dy += yDist * factor;
                n2Layout.dx -= xDist * factor;
                n2Layout.dy -= yDist * factor;
            }
        }
    }

    private class logAttraction_antiCollision
    extends AttractionForce {
        private double coefficient;

        public logAttraction_antiCollision(double c) {
            this.coefficient = c;
        }

        @Override
        public void apply(Node n1, Node n2, double e) {
            double yDist;
            ForceAtlas2LayoutData n1Layout = (ForceAtlas2LayoutData)n1.getLayoutData();
            ForceAtlas2LayoutData n2Layout = (ForceAtlas2LayoutData)n2.getLayoutData();
            double xDist = n1.x() - n2.x();
            double distance = Math.sqrt(xDist * xDist + (yDist = (double)(n1.y() - n2.y())) * yDist) - (double)n1.size() - (double)n2.size();
            if (distance > 0.0) {
                double factor = -this.coefficient * e * Math.log(1.0 + distance) / distance;
                n1Layout.dx += xDist * factor;
                n1Layout.dy += yDist * factor;
                n2Layout.dx -= xDist * factor;
                n2Layout.dy -= yDist * factor;
            }
        }
    }

    private class linAttraction_degreeDistributed_antiCollision
    extends AttractionForce {
        private double coefficient;

        public linAttraction_degreeDistributed_antiCollision(double c) {
            this.coefficient = c;
        }

        @Override
        public void apply(Node n1, Node n2, double e) {
            double yDist;
            ForceAtlas2LayoutData n1Layout = (ForceAtlas2LayoutData)n1.getLayoutData();
            ForceAtlas2LayoutData n2Layout = (ForceAtlas2LayoutData)n2.getLayoutData();
            double xDist = n1.x() - n2.x();
            double distance = Math.sqrt(xDist * xDist + (yDist = (double)(n1.y() - n2.y())) * yDist) - (double)n1.size() - (double)n2.size();
            if (distance > 0.0) {
                double factor = -this.coefficient * e / n1Layout.mass;
                n1Layout.dx += xDist * factor;
                n1Layout.dy += yDist * factor;
                n2Layout.dx -= xDist * factor;
                n2Layout.dy -= yDist * factor;
            }
        }
    }

    private class linAttraction_antiCollision
    extends AttractionForce {
        private double coefficient;

        public linAttraction_antiCollision(double c) {
            this.coefficient = c;
        }

        @Override
        public void apply(Node n1, Node n2, double e) {
            double yDist;
            ForceAtlas2LayoutData n1Layout = (ForceAtlas2LayoutData)n1.getLayoutData();
            ForceAtlas2LayoutData n2Layout = (ForceAtlas2LayoutData)n2.getLayoutData();
            double xDist = n1.x() - n2.x();
            double distance = Math.sqrt(xDist * xDist + (yDist = (double)(n1.y() - n2.y())) * yDist) - (double)n1.size() - (double)n2.size();
            if (distance > 0.0) {
                double factor = -this.coefficient * e;
                n1Layout.dx += xDist * factor;
                n1Layout.dy += yDist * factor;
                n2Layout.dx -= xDist * factor;
                n2Layout.dy -= yDist * factor;
            }
        }
    }

    private class logAttraction_degreeDistributed
    extends AttractionForce {
        private double coefficient;

        public logAttraction_degreeDistributed(double c) {
            this.coefficient = c;
        }

        @Override
        public void apply(Node n1, Node n2, double e) {
            double yDist;
            ForceAtlas2LayoutData n1Layout = (ForceAtlas2LayoutData)n1.getLayoutData();
            ForceAtlas2LayoutData n2Layout = (ForceAtlas2LayoutData)n2.getLayoutData();
            double xDist = n1.x() - n2.x();
            double distance = (float)Math.sqrt(xDist * xDist + (yDist = (double)(n1.y() - n2.y())) * yDist);
            if (distance > 0.0) {
                double factor = -this.coefficient * e * Math.log(1.0 + distance) / distance / n1Layout.mass;
                n1Layout.dx += xDist * factor;
                n1Layout.dy += yDist * factor;
                n2Layout.dx -= xDist * factor;
                n2Layout.dy -= yDist * factor;
            }
        }
    }

    private class logAttraction
    extends AttractionForce {
        private double coefficient;

        public logAttraction(double c) {
            this.coefficient = c;
        }

        @Override
        public void apply(Node n1, Node n2, double e) {
            double yDist;
            ForceAtlas2LayoutData n1Layout = (ForceAtlas2LayoutData)n1.getLayoutData();
            ForceAtlas2LayoutData n2Layout = (ForceAtlas2LayoutData)n2.getLayoutData();
            double xDist = n1.x() - n2.x();
            double distance = (float)Math.sqrt(xDist * xDist + (yDist = (double)(n1.y() - n2.y())) * yDist);
            if (distance > 0.0) {
                double factor = -this.coefficient * e * Math.log(1.0 + distance) / distance;
                n1Layout.dx += xDist * factor;
                n1Layout.dy += yDist * factor;
                n2Layout.dx -= xDist * factor;
                n2Layout.dy -= yDist * factor;
            }
        }
    }

    private class linAttraction_massDistributed
    extends AttractionForce {
        private double coefficient;

        public linAttraction_massDistributed(double c) {
            this.coefficient = c;
        }

        @Override
        public void apply(Node n1, Node n2, double e) {
            ForceAtlas2LayoutData n1Layout = (ForceAtlas2LayoutData)n1.getLayoutData();
            ForceAtlas2LayoutData n2Layout = (ForceAtlas2LayoutData)n2.getLayoutData();
            double xDist = n1.x() - n2.x();
            double yDist = n1.y() - n2.y();
            double factor = -this.coefficient * e / n1Layout.mass;
            n1Layout.dx += xDist * factor;
            n1Layout.dy += yDist * factor;
            n2Layout.dx -= xDist * factor;
            n2Layout.dy -= yDist * factor;
        }
    }

    private class linAttraction
    extends AttractionForce {
        private double coefficient;

        public linAttraction(double c) {
            this.coefficient = c;
        }

        @Override
        public void apply(Node n1, Node n2, double e) {
            ForceAtlas2LayoutData n1Layout = (ForceAtlas2LayoutData)n1.getLayoutData();
            ForceAtlas2LayoutData n2Layout = (ForceAtlas2LayoutData)n2.getLayoutData();
            double xDist = n1.x() - n2.x();
            double yDist = n1.y() - n2.y();
            double factor = -this.coefficient * e;
            n1Layout.dx += xDist * factor;
            n1Layout.dy += yDist * factor;
            n2Layout.dx -= xDist * factor;
            n2Layout.dy -= yDist * factor;
        }
    }

    private class strongGravity
    extends RepulsionForce {
        private double coefficient;

        public strongGravity(double c) {
            this.coefficient = c;
        }

        @Override
        public void apply(Node n1, Node n2) {
        }

        @Override
        public void apply(Node n, Region r) {
        }

        @Override
        public void apply(Node n, double g) {
            double yDist;
            ForceAtlas2LayoutData nLayout = (ForceAtlas2LayoutData)n.getLayoutData();
            double xDist = n.x();
            double distance = (float)Math.sqrt(xDist * xDist + (yDist = (double)n.y()) * yDist);
            if (distance > 0.0) {
                double factor = this.coefficient * nLayout.mass * g;
                nLayout.dx -= xDist * factor;
                nLayout.dy -= yDist * factor;
            }
        }
    }

    private class linRepulsion_antiCollision
    extends RepulsionForce {
        private double coefficient;

        public linRepulsion_antiCollision(double c) {
            this.coefficient = c;
        }

        @Override
        public void apply(Node n1, Node n2) {
            double yDist;
            ForceAtlas2LayoutData n1Layout = (ForceAtlas2LayoutData)n1.getLayoutData();
            ForceAtlas2LayoutData n2Layout = (ForceAtlas2LayoutData)n2.getLayoutData();
            double xDist = n1.x() - n2.x();
            double distance = Math.sqrt(xDist * xDist + (yDist = (double)(n1.y() - n2.y())) * yDist) - (double)n1.size() - (double)n2.size();
            if (distance > 0.0) {
                double factor = this.coefficient * n1Layout.mass * n2Layout.mass / distance / distance;
                n1Layout.dx += xDist * factor;
                n1Layout.dy += yDist * factor;
                n2Layout.dx -= xDist * factor;
                n2Layout.dy -= yDist * factor;
            } else if (distance < 0.0) {
                double factor = 100.0 * this.coefficient * n1Layout.mass * n2Layout.mass;
                n1Layout.dx += xDist * factor;
                n1Layout.dy += yDist * factor;
                n2Layout.dx -= xDist * factor;
                n2Layout.dy -= yDist * factor;
            }
        }

        @Override
        public void apply(Node n, Region r) {
            double yDist;
            ForceAtlas2LayoutData nLayout = (ForceAtlas2LayoutData)n.getLayoutData();
            double xDist = (double)n.x() - r.getMassCenterX();
            double distance = (float)Math.sqrt(xDist * xDist + (yDist = (double)n.y() - r.getMassCenterY()) * yDist);
            if (distance > 0.0) {
                double factor = this.coefficient * nLayout.mass * r.getMass() / distance / distance;
                nLayout.dx += xDist * factor;
                nLayout.dy += yDist * factor;
            } else if (distance < 0.0) {
                double factor = -this.coefficient * nLayout.mass * r.getMass() / distance;
                nLayout.dx += xDist * factor;
                nLayout.dy += yDist * factor;
            }
        }

        @Override
        public void apply(Node n, double g) {
            double yDist;
            ForceAtlas2LayoutData nLayout = (ForceAtlas2LayoutData)n.getLayoutData();
            double xDist = n.x();
            double distance = (float)Math.sqrt(xDist * xDist + (yDist = (double)n.y()) * yDist);
            if (distance > 0.0) {
                double factor = this.coefficient * nLayout.mass * g / distance;
                nLayout.dx -= xDist * factor;
                nLayout.dy -= yDist * factor;
            }
        }
    }

    private class linRepulsion
    extends RepulsionForce {
        private double coefficient;

        public linRepulsion(double c) {
            this.coefficient = c;
        }

        @Override
        public void apply(Node n1, Node n2) {
            double yDist;
            ForceAtlas2LayoutData n1Layout = (ForceAtlas2LayoutData)n1.getLayoutData();
            ForceAtlas2LayoutData n2Layout = (ForceAtlas2LayoutData)n2.getLayoutData();
            double xDist = n1.x() - n2.x();
            double distance = (float)Math.sqrt(xDist * xDist + (yDist = (double)(n1.y() - n2.y())) * yDist);
            if (distance > 0.0) {
                double factor = this.coefficient * n1Layout.mass * n2Layout.mass / distance / distance;
                n1Layout.dx += xDist * factor;
                n1Layout.dy += yDist * factor;
                n2Layout.dx -= xDist * factor;
                n2Layout.dy -= yDist * factor;
            }
        }

        @Override
        public void apply(Node n, Region r) {
            double yDist;
            ForceAtlas2LayoutData nLayout = (ForceAtlas2LayoutData)n.getLayoutData();
            double xDist = (double)n.x() - r.getMassCenterX();
            double distance = (float)Math.sqrt(xDist * xDist + (yDist = (double)n.y() - r.getMassCenterY()) * yDist);
            if (distance > 0.0) {
                double factor = this.coefficient * nLayout.mass * r.getMass() / distance / distance;
                nLayout.dx += xDist * factor;
                nLayout.dy += yDist * factor;
            }
        }

        @Override
        public void apply(Node n, double g) {
            double yDist;
            ForceAtlas2LayoutData nLayout = (ForceAtlas2LayoutData)n.getLayoutData();
            double xDist = n.x();
            double distance = (float)Math.sqrt(xDist * xDist + (yDist = (double)n.y()) * yDist);
            if (distance > 0.0) {
                double factor = this.coefficient * nLayout.mass * g / distance;
                nLayout.dx -= xDist * factor;
                nLayout.dy -= yDist * factor;
            }
        }
    }

    public abstract class RepulsionForce {
        public abstract void apply(Node var1, Node var2);

        public abstract void apply(Node var1, Region var2);

        public abstract void apply(Node var1, double var2);
    }

    public abstract class AttractionForce {
        public abstract void apply(Node var1, Node var2, double var3);
    }
}

