/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.CompressedGeometryHeader;
import javax.media.j3d.CompressedGeometryRetained;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryDecompressorShape3D;
import javax.media.j3d.J3DBuffer;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.NodeComponent;
import javax.media.j3d.Shape3D;

public class CompressedGeometry
extends Geometry {
    CompressedGeometryHeader cgHeader;
    public static final int ALLOW_COUNT_READ = 0;
    public static final int ALLOW_HEADER_READ = 1;
    public static final int ALLOW_GEOMETRY_READ = 2;
    public static final int ALLOW_REF_DATA_READ = 3;
    private static final int[] readCapabilities = new int[]{0, 1, 2, 3};

    CompressedGeometry() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public CompressedGeometry(CompressedGeometryHeader compressedGeometryHeader, byte[] byArray) {
        this(compressedGeometryHeader, byArray, false);
    }

    public CompressedGeometry(CompressedGeometryHeader compressedGeometryHeader, byte[] byArray, boolean bl) {
        if (compressedGeometryHeader.size + compressedGeometryHeader.start > byArray.length) {
            throw new IllegalArgumentException(J3dI18N.getString("CompressedGeometry0"));
        }
        this.setDefaultReadCapabilities(readCapabilities);
        this.cgHeader = new CompressedGeometryHeader();
        compressedGeometryHeader.copy(this.cgHeader);
        ((CompressedGeometryRetained)this.retained).createCompressedGeometry(this.cgHeader, byArray, bl);
        if (!bl) {
            this.cgHeader.start = 0;
        }
    }

    public CompressedGeometry(CompressedGeometryHeader compressedGeometryHeader, J3DBuffer j3DBuffer) {
        throw new UnsupportedOperationException(J3dI18N.getString("CompressedGeometry9"));
    }

    public int getByteCount() {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("CompressedGeometry1"));
        }
        return this.cgHeader.size;
    }

    public void getCompressedGeometryHeader(CompressedGeometryHeader compressedGeometryHeader) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("CompressedGeometry2"));
        }
        this.cgHeader.copy(compressedGeometryHeader);
    }

    public void getCompressedGeometry(byte[] byArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("CompressedGeometry3"));
        }
        if (this.isByReference()) {
            throw new IllegalStateException(J3dI18N.getString("CompressedGeometry7"));
        }
        if (this.cgHeader.size > byArray.length) {
            throw new ArrayIndexOutOfBoundsException(J3dI18N.getString("CompressedGeometry4"));
        }
        ((CompressedGeometryRetained)this.retained).copy(byArray);
    }

    public Shape3D[] decompress() {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("CompressedGeometry5"));
        }
        CompressedGeometryRetained compressedGeometryRetained = (CompressedGeometryRetained)this.retained;
        GeometryDecompressorShape3D geometryDecompressorShape3D = new GeometryDecompressorShape3D();
        return geometryDecompressorShape3D.toTriangleStripArrays(compressedGeometryRetained);
    }

    public boolean isByReference() {
        return ((CompressedGeometryRetained)this.retained).isByReference();
    }

    public byte[] getCompressedGeometryRef() {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("CompressedGeometry6"));
        }
        if (!this.isByReference()) {
            throw new IllegalStateException(J3dI18N.getString("CompressedGeometry8"));
        }
        return ((CompressedGeometryRetained)this.retained).getReference();
    }

    public J3DBuffer getCompressedGeometryBuffer() {
        if (this.isLiveOrCompiled() && !this.getCapability(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("CompressedGeometry6"));
        }
        return null;
    }

    @Override
    void createRetained() {
        this.retained = new CompressedGeometryRetained();
        this.retained.setSource(this);
    }

    @Override
    public NodeComponent cloneNodeComponent() {
        CompressedGeometry compressedGeometry = new CompressedGeometry();
        compressedGeometry.cgHeader = new CompressedGeometryHeader();
        this.cgHeader.copy(compressedGeometry.cgHeader);
        CompressedGeometryRetained compressedGeometryRetained = (CompressedGeometryRetained)this.retained;
        compressedGeometryRetained.duplicate((CompressedGeometryRetained)compressedGeometry.retained);
        compressedGeometry.duplicateNodeComponent(this);
        return compressedGeometry;
    }
}

