# To use SymEngine from another CMake project include the following in your
# `CMakeLists.txt` file

#    `find_package(SymEngine CONFIG)`

# You can give the path to the SymEngine installation directory if it was
# installed to a non standard location by,

#    `find_package(SymEngine CONFIG Paths /path/to/install/dir)`

# Alternatively, you can give the path to the build directory.

# Variable exported are
# SYMENGINE_BUILD_TYPE         - Cofiguration Type Debug or Release
# SYMENGINE_INCLUDE_DIRS       - Header file directories
# SYMENGINE_LIBRARIES          - SymEngine libraries and dependency libraries to link against
# SYMENGINE_FOUND              - Set to yes
# SYMENGINE_CXX_FLAGS_RELEASE  - C++ flags for Release configuration
# SYMENGINE_CXX_FLAGS_DEBUG    - C++ flags for Debug configuration
# SYMENGINE_C_FLAGS_RELEASE    - C flags for Release configuration
# SYMENGINE_C_FLAGS_DEBUG      - C flags for Debug configuration

# An example project would be,
#
# cmake_minimum_required(VERSION 2.8)
# find_package(symengine CONFIG)
# set(CMAKE_CXX_FLAGS_RELEASE ${SYMENGINE_CXX_FLAGS_RELEASE})
#
# include_directories(${SYMENGINE_INCLUDE_DIRS})
# add_executable(example main.cpp)
# target_link_libraries(example ${SYMENGINE_LIBRARIES})
#

cmake_minimum_required(VERSION 2.8)

set(SYMENGINE_CXX_FLAGS "-D_FORTIFY_SOURCE=2 -march=armv7-a -mfloat-abi=hard -mfpu=vfpv3-d16 -O2 -pipe -fno-plt")
set(SYMENGINE_CXX_FLAGS_RELEASE "-Wall -Wextra -Wno-unused-parameter -fno-common -O3 -funroll-loops -std=c++14 -fPIC -D_GNU_SOURCE -D_LARGEFILE_SOURCE -D_FILE_OFFSET_BITS=64 -D__STDC_CONSTANT_MACROS -D__STDC_FORMAT_MACROS -D__STDC_LIMIT_MACROS -DNDEBUG -fno-builtin-malloc -fno-builtin-calloc -fno-builtin-realloc -fno-builtin-free -Wno-unknown-pragmas")
set(SYMENGINE_CXX_FLAGS_DEBUG "-Wall -Wextra -Wno-unused-parameter -fno-common -g -ggdb -std=c++14 -fPIC -D_GNU_SOURCE -D_LARGEFILE_SOURCE -D_FILE_OFFSET_BITS=64 -D__STDC_CONSTANT_MACROS -D__STDC_FORMAT_MACROS -D__STDC_LIMIT_MACROS -fno-builtin-malloc -fno-builtin-calloc -fno-builtin-realloc -fno-builtin-free -Wno-unknown-pragmas")
set(SYMENGINE_C_FLAGS "-D_FORTIFY_SOURCE=2 -march=armv7-a -mfloat-abi=hard -mfpu=vfpv3-d16 -O2 -pipe -fno-plt")
set(SYMENGINE_C_FLAGS_RELEASE "-O3 -DNDEBUG")
set(SYMENGINE_C_FLAGS_DEBUG "-g")

# ... for the build tree
get_filename_component(SYMENGINE_CMAKE_DIR "${CMAKE_CURRENT_LIST_FILE}" PATH)

set(SYMENGINE_BUILD_TREE no)

if(NOT TARGET symengine)
    include("${SYMENGINE_CMAKE_DIR}/SymEngineTargets.cmake")
endif()

if(SYMENGINE_BUILD_TREE)
    set(SYMENGINE_INSTALL_CMAKE_DIR "${SYMENGINE_CMAKE_DIR}")
    set(SYMENGINE_INCLUDE_DIRS /build/symengine/src/symengine-0.6.0;/build/symengine/src/build ${SYMENGINE_CMAKE_DIR})
    if (TARGET teuchos)
        set(SYMENGINE_INCLUDE_DIRS ${SYMENGINE_INCLUDE_DIRS} ${SYMENGINE_CMAKE_DIR}/symengine/teuchos)
    endif()
else()
    set(SYMENGINE_INSTALL_CMAKE_DIR "/usr/lib/cmake/symengine")
    set(SYMENGINE_INCLUDE_DIRS "${SYMENGINE_CMAKE_DIR}/../../../include")
endif()


set(SYMENGINE_GMP_LIBRARIES /usr/lib/libgmp.so)
set(SYMENGINE_GMP_INCLUDE_DIRS /usr/include)
set(HAVE_SYMENGINE_GMP True)
set(SYMENGINE_ECM_LIBRARIES /usr/lib/libecm.so)
set(SYMENGINE_ECM_INCLUDE_DIRS /usr/include)
set(HAVE_SYMENGINE_ECM True)
set(SYMENGINE_PRIMESIEVE_LIBRARIES /usr/lib/libprimesieve.so)
set(SYMENGINE_PRIMESIEVE_INCLUDE_DIRS /usr/include)
set(HAVE_SYMENGINE_PRIMESIEVE True)
set(SYMENGINE_FLINT_LIBRARIES /usr/lib/libflint.so)
set(SYMENGINE_FLINT_INCLUDE_DIRS /usr/include)
set(HAVE_SYMENGINE_FLINT True)
set(SYMENGINE_ARB_LIBRARIES /usr/lib/libarb.so)
set(SYMENGINE_ARB_INCLUDE_DIRS /usr/include)
set(HAVE_SYMENGINE_ARB True)
set(SYMENGINE_MPC_LIBRARIES /usr/lib/libmpc.so)
set(SYMENGINE_MPC_INCLUDE_DIRS /usr/include)
set(HAVE_SYMENGINE_MPC True)
set(SYMENGINE_PTHREAD_LIBRARIES /usr/lib/libpthread.so)
set(SYMENGINE_PTHREAD_INCLUDE_DIRS /usr/include)
set(HAVE_SYMENGINE_PTHREAD True)
set(SYMENGINE_MPFR_LIBRARIES /usr/lib/libmpfr.so)
set(SYMENGINE_MPFR_INCLUDE_DIRS /usr/include)
set(HAVE_SYMENGINE_MPFR True)
set(SYMENGINE_LLVM_LIBRARIES )
set(SYMENGINE_LLVM_INCLUDE_DIRS /usr/include)
set(HAVE_SYMENGINE_LLVM True)
set(SYMENGINE_TCMALLOC_LIBRARIES /usr/lib/libtcmalloc.so)
set(SYMENGINE_TCMALLOC_INCLUDE_DIRS )
set(HAVE_SYMENGINE_TCMALLOC True)

set(SYMENGINE_LLVM_COMPONENTS )

if (NOT "${SYMENGINE_LLVM_COMPONENTS}" STREQUAL "")
    find_package(LLVM REQUIRED ${SYMENGINE_LLVM_COMPONENTS} HINTS /usr/lib/cmake/llvm)
    llvm_map_components_to_libnames(llvm_libs ${SYMENGINE_LLVM_COMPONENTS})
    set(SYMENGINE_LIBRARIES ${SYMENGINE_LIBRARIES} ${llvm_libs})
else()
    set(SYMENGINE_LLVM_INCLUDE_DIRS)
endif()

if (TARGET gmp)
    # Avoid defining targets again
    set(SYMENGINE_SKIP_DEPENDENCIES yes CACHE BOOL "Skip finding dependencies")
else()
    set(SYMENGINE_SKIP_DEPENDENCIES no CACHE BOOL "Skip finding dependencies")
endif()

foreach(PKG GMP;ECM;PRIMESIEVE;FLINT;ARB;MPC;PTHREAD;MPFR;LLVM;TCMALLOC)
    set(SYMENGINE_INCLUDE_DIRS ${SYMENGINE_INCLUDE_DIRS} ${SYMENGINE_${PKG}_INCLUDE_DIRS})
    set(SYMENGINE_LIBRARIES ${SYMENGINE_LIBRARIES} ${SYMENGINE_${PKG}_LIBRARIES})
endforeach()

#Use CMake provided find_package(BOOST) module
if (NOT "/usr/include" STREQUAL "")
    set(SYMENGINE_INCLUDE_DIRS ${SYMENGINE_INCLUDE_DIRS} /usr/include)
    set(SYMENGINE_LIBRARIES ${SYMENGINE_LIBRARIES} )
endif()

list(REMOVE_DUPLICATES SYMENGINE_INCLUDE_DIRS)

foreach(LIB "symengine")
    # Remove linking of dependencies to later add them as targets
    set_target_properties(${LIB} PROPERTIES IMPORTED_LINK_INTERFACE_LIBRARIES_RELEASE "")
    set_target_properties(${LIB} PROPERTIES IMPORTED_LINK_INTERFACE_LIBRARIES_DEBUG "")
endforeach()

set(SYMENGINE_LIBRARIES symengine ${SYMENGINE_LIBRARIES})
set(SYMENGINE_BUILD_TYPE "Release")
set(SYMENGINE_FOUND yes)
