/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.IOException;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Credentials;
import sun.security.krb5.EncryptedData;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbApReq;
import sun.security.krb5.KrbCryptoException;
import sun.security.krb5.KrbException;
import sun.security.krb5.internal.APRep;
import sun.security.krb5.internal.EncAPRepPart;
import sun.security.krb5.internal.KRBError;
import sun.security.krb5.internal.KdcErrException;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.LocalSeqNumber;
import sun.security.krb5.internal.SeqNumber;
import sun.security.util.DerValue;

public class KrbApRep {
    private byte[] obuf;
    private byte[] ibuf;
    private EncAPRepPart encPart;
    private APRep apRepMessg;

    public KrbApRep(KrbApReq incomingReq, boolean useSeqNumber, EncryptionKey subKey) throws KrbException, IOException {
        LocalSeqNumber seqNum = new LocalSeqNumber();
        this.init(incomingReq, subKey, seqNum);
    }

    public KrbApRep(byte[] message, Credentials tgtCreds, KrbApReq outgoingReq) throws KrbException, IOException {
        this(message, tgtCreds);
        this.authenticate(outgoingReq);
    }

    private void init(KrbApReq apReq, EncryptionKey subKey, SeqNumber seqNumber) throws KrbException, IOException {
        this.createMessage(apReq.getCreds().key, apReq.getCtime(), apReq.cusec(), subKey, seqNumber);
        this.obuf = this.apRepMessg.asn1Encode();
    }

    private KrbApRep(byte[] msg, Credentials tgs_creds) throws KrbException, IOException {
        this(new DerValue(msg), tgs_creds);
    }

    private KrbApRep(DerValue encoding, Credentials tgs_creds) throws KrbException, IOException {
        APRep rep = null;
        try {
            rep = new APRep(encoding);
        }
        catch (Asn1Exception e) {
            rep = null;
            KRBError err = new KRBError(encoding);
            String errStr = err.getErrorString();
            String eText = errStr.charAt(errStr.length() - 1) == '\u0000' ? errStr.substring(0, errStr.length() - 1) : errStr;
            KrbException ke = new KrbException(err.getErrorCode(), eText);
            ke.initCause(e);
            throw ke;
        }
        byte[] temp = rep.encPart.decrypt(tgs_creds.key, 12);
        byte[] enc_ap_rep_part = rep.encPart.reset(temp);
        encoding = new DerValue(enc_ap_rep_part);
        this.encPart = new EncAPRepPart(encoding);
    }

    private void authenticate(KrbApReq apReq) throws KrbException, IOException {
        if (this.encPart.ctime.getSeconds() != apReq.getCtime().getSeconds() || this.encPart.cusec != apReq.getCtime().getMicroSeconds()) {
            throw new KrbApErrException(46);
        }
    }

    public EncryptionKey getSubKey() {
        return this.encPart.getSubKey();
    }

    public Integer getSeqNumber() {
        return this.encPart.getSeqNumber();
    }

    public byte[] getMessage() {
        return this.obuf;
    }

    private void createMessage(EncryptionKey key, KerberosTime ctime, int cusec, EncryptionKey subKey, SeqNumber seqNumber) throws Asn1Exception, IOException, KdcErrException, KrbCryptoException {
        Integer seqno = null;
        if (seqNumber != null) {
            seqno = new Integer(seqNumber.current());
        }
        this.encPart = new EncAPRepPart(ctime, cusec, subKey, seqno);
        byte[] encPartEncoding = this.encPart.asn1Encode();
        EncryptedData encEncPart = new EncryptedData(key, encPartEncoding, 12);
        this.apRepMessg = new APRep(encEncPart);
    }
}

