/*
 * Decompiled with CFR 0.152.
 */
package sun.swing.plaf.synth;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthUI;
import sun.swing.plaf.synth.SynthFileChooserUIImpl;

public abstract class SynthFileChooserUI
extends BasicFileChooserUI
implements SynthUI {
    private JButton approveButton;
    private JButton cancelButton;
    private SynthStyle style;
    private Action fileNameCompletionAction = new FileNameCompletionAction();
    private FileFilter actualFileFilter = null;
    private GlobFilter globFilter = null;
    private String fileNameCompletionString;

    public static ComponentUI createUI(JComponent c) {
        return new SynthFileChooserUIImpl((JFileChooser)c);
    }

    public SynthFileChooserUI(JFileChooser b) {
        super(b);
    }

    @Override
    public SynthContext getContext(JComponent c) {
        return new SynthContext(c, Region.FILE_CHOOSER, this.style, this.getComponentState(c));
    }

    protected SynthContext getContext(JComponent c, int state) {
        Region region = SynthLookAndFeel.getRegion(c);
        return new SynthContext(c, Region.FILE_CHOOSER, this.style, state);
    }

    private Region getRegion(JComponent c) {
        return SynthLookAndFeel.getRegion(c);
    }

    private int getComponentState(JComponent c) {
        if (c.isEnabled()) {
            if (c.isFocusOwner()) {
                return 257;
            }
            return 1;
        }
        return 8;
    }

    private void updateStyle(JComponent c) {
        SynthStyle newStyle = SynthLookAndFeel.getStyleFactory().getStyle(c, Region.FILE_CHOOSER);
        if (newStyle != this.style) {
            if (this.style != null) {
                this.style.uninstallDefaults(this.getContext(c, 1));
            }
            this.style = newStyle;
            SynthContext context = this.getContext(c, 1);
            this.style.installDefaults(context);
            Border border = c.getBorder();
            if (border == null || border instanceof UIResource) {
                c.setBorder(new UIBorder(this.style.getInsets(context, null)));
            }
            this.directoryIcon = this.style.getIcon(context, "FileView.directoryIcon");
            this.fileIcon = this.style.getIcon(context, "FileView.fileIcon");
            this.computerIcon = this.style.getIcon(context, "FileView.computerIcon");
            this.hardDriveIcon = this.style.getIcon(context, "FileView.hardDriveIcon");
            this.floppyDriveIcon = this.style.getIcon(context, "FileView.floppyDriveIcon");
            this.newFolderIcon = this.style.getIcon(context, "FileChooser.newFolderIcon");
            this.upFolderIcon = this.style.getIcon(context, "FileChooser.upFolderIcon");
            this.homeFolderIcon = this.style.getIcon(context, "FileChooser.homeFolderIcon");
            this.detailsViewIcon = this.style.getIcon(context, "FileChooser.detailsViewIcon");
            this.listViewIcon = this.style.getIcon(context, "FileChooser.listViewIcon");
        }
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        SwingUtilities.replaceUIActionMap(c, this.createActionMap());
    }

    @Override
    public void installComponents(JFileChooser fc) {
        SynthContext context = this.getContext(fc, 1);
        this.cancelButton = new JButton(this.cancelButtonText);
        this.cancelButton.setName("SynthFileChooser.cancelButton");
        this.cancelButton.setIcon(context.getStyle().getIcon(context, "FileChooser.cancelIcon"));
        this.cancelButton.setMnemonic(this.cancelButtonMnemonic);
        this.cancelButton.setToolTipText(this.cancelButtonToolTipText);
        this.cancelButton.addActionListener(this.getCancelSelectionAction());
        this.approveButton = new JButton(this.getApproveButtonText(fc));
        this.approveButton.setName("SynthFileChooser.approveButton");
        this.approveButton.setIcon(context.getStyle().getIcon(context, "FileChooser.okIcon"));
        this.approveButton.setMnemonic(this.getApproveButtonMnemonic(fc));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(fc));
        this.approveButton.addActionListener(this.getApproveSelectionAction());
    }

    @Override
    public void uninstallComponents(JFileChooser fc) {
        fc.removeAll();
    }

    @Override
    protected void installListeners(JFileChooser fc) {
        super.installListeners(fc);
        this.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent e) {
                new DelayedSelectionUpdater();
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                new DelayedSelectionUpdater();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }
        });
    }

    protected abstract ActionMap createActionMap();

    @Override
    protected void installDefaults(JFileChooser fc) {
        super.installDefaults(fc);
        this.updateStyle(fc);
    }

    @Override
    protected void uninstallDefaults(JFileChooser fc) {
        super.uninstallDefaults(fc);
        SynthContext context = this.getContext(this.getFileChooser(), 1);
        this.style.uninstallDefaults(context);
        this.style = null;
    }

    @Override
    protected void installIcons(JFileChooser fc) {
    }

    @Override
    public void update(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        if (c.isOpaque()) {
            g.setColor(this.style.getColor(context, ColorType.BACKGROUND));
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        this.style.getPainter(context).paintFileChooserBackground(context, g, 0, 0, c.getWidth(), c.getHeight());
        this.paint(context, g);
    }

    @Override
    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        this.paint(context, g);
    }

    protected void paint(SynthContext context, Graphics g) {
    }

    @Override
    public abstract void setFileName(String var1);

    @Override
    public abstract String getFileName();

    protected void doSelectedFileChanged(PropertyChangeEvent e) {
    }

    protected void doSelectedFilesChanged(PropertyChangeEvent e) {
    }

    protected void doDirectoryChanged(PropertyChangeEvent e) {
    }

    protected void doAccessoryChanged(PropertyChangeEvent e) {
    }

    protected void doFileSelectionModeChanged(PropertyChangeEvent e) {
    }

    protected void doMultiSelectionChanged(PropertyChangeEvent e) {
        if (!this.getFileChooser().isMultiSelectionEnabled()) {
            this.getFileChooser().setSelectedFiles(null);
        }
    }

    protected void doControlButtonsChanged(PropertyChangeEvent e) {
        if (this.getFileChooser().getControlButtonsAreShown()) {
            this.approveButton.setText(this.getApproveButtonText(this.getFileChooser()));
            this.approveButton.setToolTipText(this.getApproveButtonToolTipText(this.getFileChooser()));
            this.approveButton.setMnemonic(this.getApproveButtonMnemonic(this.getFileChooser()));
        }
    }

    protected void doAncestorChanged(PropertyChangeEvent e) {
    }

    @Override
    public PropertyChangeListener createPropertyChangeListener(JFileChooser fc) {
        return new SynthFCPropertyChangeListener();
    }

    private void updateFileNameCompletion() {
        if (this.fileNameCompletionString != null && this.fileNameCompletionString.equals(this.getFileName())) {
            File[] files = this.getModel().getFiles().toArray(new File[0]);
            String str = this.getCommonStartString(files);
            if (str != null && str.startsWith(this.fileNameCompletionString)) {
                this.setFileName(str);
            }
            this.fileNameCompletionString = null;
        }
    }

    private String getCommonStartString(File[] files) {
        String str = null;
        String str2 = null;
        int i = 0;
        if (files.length == 0) {
            return null;
        }
        while (true) {
            for (int f = 0; f < files.length; ++f) {
                String name = files[f].getName();
                if (f == 0) {
                    if (name.length() == i) {
                        return str;
                    }
                    str2 = name.substring(0, i + 1);
                }
                if (name.startsWith(str2)) continue;
                return str;
            }
            str = str2;
            ++i;
        }
    }

    private void resetGlobFilter() {
        if (this.actualFileFilter != null) {
            JFileChooser chooser = this.getFileChooser();
            FileFilter currentFilter = chooser.getFileFilter();
            if (currentFilter != null && currentFilter.equals(this.globFilter)) {
                chooser.setFileFilter(this.actualFileFilter);
                chooser.removeChoosableFileFilter(this.globFilter);
            }
            this.actualFileFilter = null;
        }
    }

    private static boolean isGlobPattern(String fileName) {
        return File.separatorChar == '\\' && fileName.indexOf(42) >= 0 || File.separatorChar == '/' && (fileName.indexOf(42) >= 0 || fileName.indexOf(63) >= 0 || fileName.indexOf(91) >= 0);
    }

    public Action getFileNameCompletionAction() {
        return this.fileNameCompletionAction;
    }

    @Override
    protected JButton getApproveButton(JFileChooser fc) {
        return this.approveButton;
    }

    protected JButton getCancelButton(JFileChooser fc) {
        return this.cancelButton;
    }

    @Override
    public void clearIconCache() {
    }

    private class UIBorder
    extends AbstractBorder
    implements UIResource {
        private Insets _insets;

        UIBorder(Insets insets) {
            this._insets = insets != null ? new Insets(insets.top, insets.left, insets.bottom, insets.right) : null;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (!(c instanceof JComponent)) {
                return;
            }
            JComponent jc = (JComponent)c;
            SynthContext context = SynthFileChooserUI.this.getContext(jc);
            SynthStyle style = context.getStyle();
            if (style != null) {
                style.getPainter(context).paintFileChooserBorder(context, g, x, y, width, height);
            }
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            if (insets == null) {
                insets = new Insets(0, 0, 0, 0);
            }
            if (this._insets != null) {
                insets.top = this._insets.top;
                insets.bottom = this._insets.bottom;
                insets.left = this._insets.left;
                insets.right = this._insets.right;
            } else {
                insets.left = 0;
                insets.right = 0;
                insets.bottom = 0;
                insets.top = 0;
            }
            return insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }

    class GlobFilter
    extends FileFilter {
        Pattern pattern;
        String globPattern;

        GlobFilter() {
        }

        public void setPattern(String globPattern) {
            char[] gPat = globPattern.toCharArray();
            char[] rPat = new char[gPat.length * 2];
            boolean isWin32 = File.separatorChar == '\\';
            boolean inBrackets = false;
            int j = 0;
            this.globPattern = globPattern;
            if (isWin32) {
                int len = gPat.length;
                if (globPattern.endsWith("*.*")) {
                    len -= 2;
                }
                for (int i = 0; i < len; ++i) {
                    if (gPat[i] == '*') {
                        rPat[j++] = 46;
                    }
                    rPat[j++] = gPat[i];
                }
            } else {
                block12: for (int i = 0; i < gPat.length; ++i) {
                    switch (gPat[i]) {
                        case '*': {
                            if (!inBrackets) {
                                rPat[j++] = 46;
                            }
                            rPat[j++] = 42;
                            continue block12;
                        }
                        case '?': {
                            rPat[j++] = inBrackets ? 63 : 46;
                            continue block12;
                        }
                        case '[': {
                            inBrackets = true;
                            rPat[j++] = gPat[i];
                            if (i >= gPat.length - 1) continue block12;
                            switch (gPat[i + 1]) {
                                case '!': 
                                case '^': {
                                    rPat[j++] = 94;
                                    ++i;
                                    break;
                                }
                                case ']': {
                                    rPat[j++] = gPat[++i];
                                }
                            }
                            continue block12;
                        }
                        case ']': {
                            rPat[j++] = gPat[i];
                            inBrackets = false;
                            continue block12;
                        }
                        case '\\': {
                            if (i == 0 && gPat.length > 1 && gPat[1] == '~') {
                                rPat[j++] = gPat[++i];
                                continue block12;
                            }
                            rPat[j++] = 92;
                            if (i < gPat.length - 1 && "*?[]".indexOf(gPat[i + 1]) >= 0) {
                                rPat[j++] = gPat[++i];
                                continue block12;
                            }
                            rPat[j++] = 92;
                            continue block12;
                        }
                        default: {
                            if (!Character.isLetterOrDigit(gPat[i])) {
                                rPat[j++] = 92;
                            }
                            rPat[j++] = gPat[i];
                        }
                    }
                }
            }
            this.pattern = Pattern.compile(new String(rPat, 0, j), 2);
        }

        @Override
        public boolean accept(File f) {
            if (f == null) {
                return false;
            }
            if (f.isDirectory()) {
                return true;
            }
            return this.pattern.matcher(f.getName()).matches();
        }

        @Override
        public String getDescription() {
            return this.globPattern;
        }
    }

    private class FileNameCompletionAction
    extends AbstractAction {
        protected FileNameCompletionAction() {
            super("fileNameCompletion");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = SynthFileChooserUI.this.getFileChooser();
            String fileName = SynthFileChooserUI.this.getFileName();
            if (fileName != null) {
                fileName = fileName.trim();
            }
            SynthFileChooserUI.this.resetGlobFilter();
            if (fileName == null || fileName.equals("") || chooser.isMultiSelectionEnabled() && fileName.startsWith("\"")) {
                return;
            }
            FileFilter currentFilter = chooser.getFileFilter();
            if (SynthFileChooserUI.this.globFilter == null) {
                SynthFileChooserUI.this.globFilter = new GlobFilter();
            }
            try {
                SynthFileChooserUI.this.globFilter.setPattern(!SynthFileChooserUI.isGlobPattern(fileName) ? fileName + "*" : fileName);
                if (!(currentFilter instanceof GlobFilter)) {
                    SynthFileChooserUI.this.actualFileFilter = currentFilter;
                }
                chooser.setFileFilter(null);
                chooser.setFileFilter(SynthFileChooserUI.this.globFilter);
                SynthFileChooserUI.this.fileNameCompletionString = fileName;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
    }

    private class SynthFCPropertyChangeListener
    implements PropertyChangeListener {
        private SynthFCPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (prop.equals("fileSelectionChanged")) {
                SynthFileChooserUI.this.doFileSelectionModeChanged(e);
            } else if (prop.equals("SelectedFileChangedProperty")) {
                SynthFileChooserUI.this.doSelectedFileChanged(e);
            } else if (prop.equals("SelectedFilesChangedProperty")) {
                SynthFileChooserUI.this.doSelectedFilesChanged(e);
            } else if (prop.equals("directoryChanged")) {
                SynthFileChooserUI.this.doDirectoryChanged(e);
            } else if (prop == "MultiSelectionEnabledChangedProperty") {
                SynthFileChooserUI.this.doMultiSelectionChanged(e);
            } else if (prop == "AccessoryChangedProperty") {
                SynthFileChooserUI.this.doAccessoryChanged(e);
            } else if (prop == "ApproveButtonTextChangedProperty" || prop == "ApproveButtonToolTipTextChangedProperty" || prop == "DialogTypeChangedProperty" || prop == "ControlButtonsAreShownChangedProperty") {
                SynthFileChooserUI.this.doControlButtonsChanged(e);
            } else if (prop.equals("componentOrientation")) {
                ComponentOrientation o = (ComponentOrientation)e.getNewValue();
                JFileChooser cc = (JFileChooser)e.getSource();
                if (o != (ComponentOrientation)e.getOldValue()) {
                    cc.applyComponentOrientation(o);
                }
            } else if (prop.equals("ancestor")) {
                SynthFileChooserUI.this.doAncestorChanged(e);
            }
        }
    }

    private class DelayedSelectionUpdater
    implements Runnable {
        DelayedSelectionUpdater() {
            SwingUtilities.invokeLater(this);
        }

        @Override
        public void run() {
            SynthFileChooserUI.this.updateFileNameCompletion();
        }
    }
}

