/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp.cpdsadapter;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;
import org.apache.tomcat.dbcp.dbcp.DelegatingConnection;
import org.apache.tomcat.dbcp.dbcp.DelegatingPreparedStatement;
import org.apache.tomcat.dbcp.dbcp.PStmtKey;
import org.apache.tomcat.dbcp.dbcp.PoolableCallableStatement;
import org.apache.tomcat.dbcp.dbcp.PoolablePreparedStatement;
import org.apache.tomcat.dbcp.dbcp.PoolingConnection;
import org.apache.tomcat.dbcp.dbcp.cpdsadapter.ConnectionImpl;
import org.apache.tomcat.dbcp.pool.KeyedObjectPool;
import org.apache.tomcat.dbcp.pool.KeyedPoolableObjectFactory;
import org.apache.tomcat.util.compat.JreCompat;

class PooledConnectionImpl
implements PooledConnection,
KeyedPoolableObjectFactory<PStmtKey, DelegatingPreparedStatement> {
    private static final String CLOSED = "Attempted to use PooledConnection after closed() was called.";
    private Connection connection = null;
    private final DelegatingConnection delegatingConnection;
    private Connection logicalConnection = null;
    private final Vector<ConnectionEventListener> eventListeners;
    private final Vector<StatementEventListener> statementEventListeners = new Vector();
    boolean isClosed;
    protected KeyedObjectPool<PStmtKey, DelegatingPreparedStatement> pstmtPool = null;
    private boolean accessToUnderlyingConnectionAllowed = false;

    PooledConnectionImpl(Connection connection, KeyedObjectPool<PStmtKey, DelegatingPreparedStatement> keyedObjectPool) {
        this.connection = connection;
        this.delegatingConnection = connection instanceof DelegatingConnection ? (DelegatingConnection)connection : new DelegatingConnection(connection);
        this.eventListeners = new Vector();
        this.isClosed = false;
        if (keyedObjectPool != null) {
            this.pstmtPool = keyedObjectPool;
            this.pstmtPool.setFactory(this);
        }
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (!this.eventListeners.contains(connectionEventListener)) {
            this.eventListeners.add(connectionEventListener);
        }
    }

    @Override
    public void addStatementEventListener(StatementEventListener statementEventListener) {
        if (!this.statementEventListeners.contains(statementEventListener)) {
            this.statementEventListeners.add(statementEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        block14: {
            this.assertOpen();
            this.isClosed = true;
            try {
                if (this.pstmtPool == null) break block14;
                try {
                    this.pstmtPool.close();
                }
                finally {
                    this.pstmtPool = null;
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new SQLException("Cannot close connection (return to pool failed)", exception);
            }
            finally {
                try {
                    this.connection.close();
                }
                finally {
                    this.connection = null;
                }
            }
        }
    }

    private void assertOpen() throws SQLException {
        if (this.isClosed) {
            throw new SQLException(CLOSED);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.assertOpen();
        if (this.logicalConnection != null && !this.logicalConnection.isClosed()) {
            throw new SQLException("PooledConnection was reused, withoutits previous Connection being closed.");
        }
        this.logicalConnection = new ConnectionImpl(this, this.connection, this.isAccessToUnderlyingConnectionAllowed());
        return this.logicalConnection;
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.eventListeners.remove(connectionEventListener);
    }

    @Override
    public void removeStatementEventListener(StatementEventListener statementEventListener) {
        this.statementEventListeners.remove(statementEventListener);
    }

    protected void finalize() throws Throwable {
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.logicalConnection != null && !this.logicalConnection.isClosed()) {
            throw new SQLException("PooledConnection was gc'ed, withoutits last Connection being closed.");
        }
    }

    void notifyListeners() {
        ConnectionEvent connectionEvent = new ConnectionEvent(this);
        Object[] objectArray = this.eventListeners.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            ((ConnectionEventListener)objectArray[i]).connectionClosed(connectionEvent);
        }
    }

    PreparedStatement prepareStatement(String string) throws SQLException {
        if (this.pstmtPool == null) {
            return this.connection.prepareStatement(string);
        }
        try {
            return this.pstmtPool.borrowObject(this.createKey(string));
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLException("Borrow prepareStatement from pool failed", exception);
        }
    }

    PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        if (this.pstmtPool == null) {
            return this.connection.prepareStatement(string, n, n2);
        }
        try {
            return this.pstmtPool.borrowObject(this.createKey(string, n, n2));
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLException("Borrow prepareStatement from pool failed", exception);
        }
    }

    PreparedStatement prepareStatement(String string, int n) throws SQLException {
        if (this.pstmtPool == null) {
            return this.connection.prepareStatement(string, n);
        }
        try {
            return this.pstmtPool.borrowObject(this.createKey(string, n));
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLException("Borrow prepareStatement from pool failed", exception);
        }
    }

    PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        if (this.pstmtPool == null) {
            return this.connection.prepareStatement(string, n, n2, n3);
        }
        try {
            return this.pstmtPool.borrowObject(this.createKey(string, n, n2, n3));
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLException("Borrow prepareStatement from pool failed", exception);
        }
    }

    PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        if (this.pstmtPool == null) {
            return this.connection.prepareStatement(string, nArray);
        }
        try {
            return this.pstmtPool.borrowObject(this.createKey(string, nArray));
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLException("Borrow prepareStatement from pool failed", exception);
        }
    }

    PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        if (this.pstmtPool == null) {
            return this.connection.prepareStatement(string, stringArray);
        }
        try {
            return this.pstmtPool.borrowObject(this.createKey(string, stringArray));
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLException("Borrow prepareStatement from pool failed", exception);
        }
    }

    protected PStmtKey createKey(String string, int n) {
        return new PStmtKey(this.normalizeSQL(string), this.getCatalogOrNull(), this.getSchemaOrNull(), n);
    }

    protected PStmtKey createKey(String string, int n, int n2, int n3) {
        return new PStmtKey(this.normalizeSQL(string), this.getCatalogOrNull(), this.getSchemaOrNull(), n, n2, n3);
    }

    protected PStmtKey createKey(String string, int[] nArray) {
        return new PStmtKey(this.normalizeSQL(string), this.getCatalogOrNull(), this.getSchemaOrNull(), nArray);
    }

    protected PStmtKey createKey(String string, String[] stringArray) {
        return new PStmtKey(this.normalizeSQL(string), this.getCatalogOrNull(), this.getSchemaOrNull(), stringArray);
    }

    protected PStmtKey createKey(String string, int n, int n2) {
        return new PStmtKey(this.normalizeSQL(string), this.getCatalogOrNull(), this.getSchemaOrNull(), n, n2);
    }

    protected PStmtKey createKey(String string) {
        return new PStmtKey(this.normalizeSQL(string), this.getCatalogOrNull(), this.getSchemaOrNull());
    }

    protected String normalizeSQL(String string) {
        return string.trim();
    }

    private String getCatalogOrNull() {
        try {
            return this.connection == null ? null : this.connection.getCatalog();
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    private String getSchemaOrNull() {
        try {
            return this.connection == null ? null : JreCompat.getInstance().getSchema(this.connection);
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    @Override
    public DelegatingPreparedStatement makeObject(PStmtKey pStmtKey) throws Exception {
        if (null == pStmtKey) {
            throw new IllegalArgumentException();
        }
        if (pStmtKey.getStmtType() == PoolingConnection.StatementType.PREPARED_STATEMENT) {
            PreparedStatement preparedStatement = (PreparedStatement)pStmtKey.createStatement(this.connection);
            PoolablePreparedStatement<PStmtKey> poolablePreparedStatement = new PoolablePreparedStatement<PStmtKey>(preparedStatement, pStmtKey, this.pstmtPool, this.delegatingConnection);
            return poolablePreparedStatement;
        }
        CallableStatement callableStatement = (CallableStatement)pStmtKey.createStatement(this.connection);
        return new PoolableCallableStatement(callableStatement, pStmtKey, this.pstmtPool, this.delegatingConnection);
    }

    @Override
    public void destroyObject(PStmtKey pStmtKey, DelegatingPreparedStatement delegatingPreparedStatement) throws Exception {
        delegatingPreparedStatement.getInnermostDelegate().close();
    }

    @Override
    public boolean validateObject(PStmtKey pStmtKey, DelegatingPreparedStatement delegatingPreparedStatement) {
        return true;
    }

    @Override
    public void activateObject(PStmtKey pStmtKey, DelegatingPreparedStatement delegatingPreparedStatement) throws Exception {
        delegatingPreparedStatement.activate();
    }

    @Override
    public void passivateObject(PStmtKey pStmtKey, DelegatingPreparedStatement delegatingPreparedStatement) throws Exception {
        delegatingPreparedStatement.clearParameters();
        delegatingPreparedStatement.passivate();
    }

    public synchronized boolean isAccessToUnderlyingConnectionAllowed() {
        return this.accessToUnderlyingConnectionAllowed;
    }

    public synchronized void setAccessToUnderlyingConnectionAllowed(boolean bl) {
        this.accessToUnderlyingConnectionAllowed = bl;
    }
}

