/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.PermissionCollection;
import org.apache.jasper.Constants;

public class JasperLoader
extends URLClassLoader {
    private PermissionCollection permissionCollection;
    private ClassLoader parent;
    private SecurityManager securityManager;

    public JasperLoader(URL[] uRLArray, ClassLoader classLoader, PermissionCollection permissionCollection) {
        super(uRLArray, classLoader);
        this.permissionCollection = permissionCollection;
        this.parent = classLoader;
        this.securityManager = System.getSecurityManager();
    }

    @Override
    public Class<?> loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(string, false);
    }

    @Override
    public synchronized Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
        int n;
        Class<?> clazz = null;
        clazz = this.findLoadedClass(string);
        if (clazz != null) {
            if (bl) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        if (this.securityManager != null && (n = string.lastIndexOf(46)) >= 0) {
            try {
                if (!"org.apache.jasper.runtime".equalsIgnoreCase(string.substring(0, n))) {
                    this.securityManager.checkPackageAccess(string.substring(0, n));
                }
            }
            catch (SecurityException securityException) {
                String string2 = "Security Violation, attempt to use Restricted Class: " + string;
                securityException.printStackTrace();
                throw new ClassNotFoundException(string2);
            }
        }
        if (!string.startsWith(Constants.JSP_PACKAGE_NAME + '.')) {
            clazz = this.parent.loadClass(string);
            if (bl) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        return this.findClass(string);
    }

    @Override
    public InputStream getResourceAsStream(String string) {
        URL uRL;
        InputStream inputStream = this.parent.getResourceAsStream(string);
        if (inputStream == null && (uRL = this.findResource(string)) != null) {
            try {
                inputStream = uRL.openStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return inputStream;
    }

    @Override
    public final PermissionCollection getPermissions(CodeSource codeSource) {
        return this.permissionCollection;
    }
}

