/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.generator;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Iterator;
import org.hamcrest.generator.FactoryMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectiveFactoryReader
implements Iterable<FactoryMethod> {
    private final Class<?> cls;
    private final ClassLoader classLoader;

    public ReflectiveFactoryReader(Class<?> cls) {
        this.cls = cls;
        this.classLoader = cls.getClassLoader();
    }

    @Override
    public Iterator<FactoryMethod> iterator() {
        return new Iterator<FactoryMethod>(){
            private int currentMethod = -1;
            private Method[] allMethods = ReflectiveFactoryReader.access$000(ReflectiveFactoryReader.this).getMethods();

            @Override
            public boolean hasNext() {
                do {
                    ++this.currentMethod;
                    if (this.currentMethod < this.allMethods.length) continue;
                    return false;
                } while (!ReflectiveFactoryReader.this.isFactoryMethod(this.allMethods[this.currentMethod]));
                return true;
            }

            @Override
            public FactoryMethod next() {
                if (this.outsideArrayBounds()) {
                    throw new IllegalStateException("next() called without hasNext() check.");
                }
                return ReflectiveFactoryReader.buildFactoryMethod(this.allMethods[this.currentMethod]);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private boolean outsideArrayBounds() {
                return this.currentMethod < 0 || this.allMethods.length <= this.currentMethod;
            }
        };
    }

    protected boolean isFactoryMethod(Method javaMethod) {
        return Modifier.isStatic(javaMethod.getModifiers()) && Modifier.isPublic(javaMethod.getModifiers()) && this.hasFactoryAnnotation(javaMethod) && !Void.TYPE.equals(javaMethod.getReturnType());
    }

    private boolean hasFactoryAnnotation(Method javaMethod) {
        try {
            Class<?> factoryClass = this.classLoader.loadClass("org.hamcrest.Factory");
            if (!Annotation.class.isAssignableFrom(factoryClass)) {
                throw new RuntimeException("Not an annotation class: " + factoryClass.getCanonicalName());
            }
            return javaMethod.getAnnotation(factoryClass) != null;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Cannot load hamcrest core", e);
        }
    }

    private static FactoryMethod buildFactoryMethod(Method javaMethod) {
        FactoryMethod result = new FactoryMethod(ReflectiveFactoryReader.classToString(javaMethod.getDeclaringClass()), javaMethod.getName(), ReflectiveFactoryReader.classToString(javaMethod.getReturnType()));
        for (TypeVariable<Method> typeVariable : javaMethod.getTypeParameters()) {
            boolean hasBound = false;
            StringBuilder stringBuilder = new StringBuilder(typeVariable.getName());
            for (Type bound : typeVariable.getBounds()) {
                if (bound == Object.class) continue;
                if (hasBound) {
                    stringBuilder.append(" & ");
                } else {
                    stringBuilder.append(" extends ");
                    hasBound = true;
                }
                stringBuilder.append(ReflectiveFactoryReader.typeToString(bound));
            }
            result.addGenericTypeParameter(stringBuilder.toString());
        }
        Type returnType = javaMethod.getGenericReturnType();
        if (returnType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)returnType;
            Type generifiedType = parameterizedType.getActualTypeArguments()[0];
            result.setGenerifiedType(ReflectiveFactoryReader.typeToString(generifiedType));
        }
        int paramNumber = 0;
        for (Type type : javaMethod.getGenericParameterTypes()) {
            String type2 = ReflectiveFactoryReader.typeToString(type);
            if (javaMethod.isVarArgs() && paramNumber == javaMethod.getParameterTypes().length - 1) {
                type2 = type2.replaceFirst("\\[\\]$", "...");
            }
            result.addParameter(type2, "param" + ++paramNumber);
        }
        for (Type type : javaMethod.getExceptionTypes()) {
            result.addException(ReflectiveFactoryReader.typeToString(type));
        }
        return result;
    }

    private static String typeToString(Type type) {
        return type instanceof Class ? ReflectiveFactoryReader.classToString((Class)type) : type.toString();
    }

    private static String classToString(Class<?> cls) {
        String name = cls.isArray() ? cls.getComponentType().getName() + "[]" : cls.getName();
        return name.replace('$', '.');
    }

    static /* synthetic */ Class access$000(ReflectiveFactoryReader x0) {
        return x0.cls;
    }
}

