/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.Collection;
import java.util.Comparator;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.Utils;

public class AbstractGoods
extends FreeColObject
implements Named {
    public static final Comparator<AbstractGoods> abstractGoodsComparator = new Comparator<AbstractGoods>(){

        @Override
        public int compare(AbstractGoods a1, AbstractGoods a2) {
            int cmp = a2.getAmount() - a1.getAmount();
            return cmp != 0 ? cmp : GoodsType.goodsTypeComparator.compare(a1.getType(), a2.getType());
        }
    };
    private GoodsType type;
    private int amount;
    private static final String AMOUNT_TAG = "amount";
    private static final String TYPE_TAG = "type";

    public AbstractGoods() {
    }

    public AbstractGoods(GoodsType type, int amount) {
        this.setId(type.getId());
        this.type = type;
        this.amount = amount;
    }

    public AbstractGoods(AbstractGoods other) {
        this.setId(other.type.getId());
        this.type = other.type;
        this.amount = other.amount;
    }

    public final GoodsType getType() {
        return this.type;
    }

    public final void setType(GoodsType newType) {
        this.type = newType;
    }

    public final int getAmount() {
        return this.amount;
    }

    public final void setAmount(int newAmount) {
        this.amount = newAmount;
    }

    public StringTemplate getLabel() {
        return AbstractGoods.getLabel(this.getType(), this.getAmount());
    }

    public StringTemplate getLabel(boolean sellable) {
        return sellable ? this.getLabel() : StringTemplate.template("model.abstractGoods.boycotted").addNamed("%goods%", this.getType()).addAmount("%amount%", this.getAmount());
    }

    public static StringTemplate getLabel(GoodsType type, int amount) {
        return StringTemplate.template("model.abstractGoods.label").addNamed("%goods%", type).addAmount("%amount%", amount);
    }

    public static StringTemplate getLabel(String key, int amount) {
        return StringTemplate.template("model.abstractGoods.label").add("%goods%", key).addAmount("%amount%", amount);
    }

    public static AbstractGoods findByType(GoodsType type, Collection<? extends AbstractGoods> goods) {
        for (AbstractGoods abstractGoods : goods) {
            if (abstractGoods.getType() != type) continue;
            return abstractGoods;
        }
        return null;
    }

    public static int getCount(GoodsType type, Collection<? extends AbstractGoods> goods) {
        AbstractGoods ag = AbstractGoods.findByType(type, goods);
        return ag == null ? 0 : ag.getAmount();
    }

    public static boolean containsType(GoodsType type, Collection<? extends AbstractGoods> goods) {
        return CollectionUtils.contains(goods, ag -> ag.getType() == type);
    }

    public int evaluateFor(Player player) {
        Market market = player.getMarket();
        return market == null ? this.getAmount() * 2 : market.getSalePrice(this.getType(), this.getAmount());
    }

    @Override
    public String getNameKey() {
        return this.getType().getNameKey();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof AbstractGoods) {
            AbstractGoods ag = (AbstractGoods)o;
            return this.type == ag.type && this.amount == ag.amount;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + Utils.hashCode(this.type);
        hash = 31 * hash + this.amount;
        return hash;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(TYPE_TAG, this.type);
        xw.writeAttribute(AMOUNT_TAG, this.amount);
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        super.readAttributes(xr);
        this.type = xr.getType(spec, TYPE_TAG, GoodsType.class, null);
        if (this.type == null) {
            throw new XMLStreamException("Null goods type.");
        }
        this.setId(this.type.getId());
        this.amount = xr.getAttribute(AMOUNT_TAG, 0);
    }

    @Override
    public String toString() {
        return AbstractGoods.toString(this);
    }

    public static String toString(AbstractGoods ag) {
        return AbstractGoods.toString(ag.getType(), ag.getAmount());
    }

    public static String toString(GoodsType goodsType, int amount) {
        return amount + " " + (goodsType == null ? "(null)" : goodsType.getSuffix());
    }

    @Override
    public String getXMLTagName() {
        return AbstractGoods.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "abstractGoods";
    }
}

