/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.prefix;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.vocab.Namespaces;

public final class PrefixedNameRenderer {
    private final ImmutableSortedMap<String, String> prefix2PrefixNameMap;

    private PrefixedNameRenderer(@Nonnull ImmutableSortedMap<String, String> prefix2PrefixNameMap) {
        this.prefix2PrefixNameMap = (ImmutableSortedMap)Preconditions.checkNotNull(prefix2PrefixNameMap);
    }

    public static PrefixedNameRenderer get(@Nonnull Map<String, String> prefixName2PrefixMap) {
        Comparator<String> stringLengthReversed = Comparator.comparing(String::length).thenComparing(Comparator.naturalOrder()).reversed();
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.orderedBy(stringLengthReversed);
        prefixName2PrefixMap.forEach((arg_0, arg_1) -> ((ImmutableSortedMap.Builder)builder).put(arg_0, arg_1));
        return new PrefixedNameRenderer((ImmutableSortedMap<String, String>)builder.build());
    }

    public String getPrefixedNameOrQuotedIri(@Nonnull IRI iri) {
        return this.getPrefixedNameOrElse(iri, iri.toQuotedString());
    }

    public String getPrefixedNameOrElse(@Nonnull IRI iri, String alternate) {
        String iriString = iri.toString();
        return this.prefix2PrefixNameMap.entrySet().stream().filter(e -> iriString.startsWith((String)e.getKey())).map(e -> (String)e.getValue() + iriString.substring(((String)e.getKey()).length())).findFirst().orElse(alternate);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Map<String, String> prefix2PrefixNameMap = new HashMap<String, String>();

        public Builder withPrefix(@Nonnull String prefixName, @Nonnull String prefix) {
            Preconditions.checkNotNull((Object)prefixName);
            Preconditions.checkNotNull((Object)prefix);
            if (!prefixName.endsWith(":")) {
                throw new IllegalArgumentException("Prefix name must end with a colon character");
            }
            this.prefix2PrefixNameMap.put(prefix, prefixName);
            return this;
        }

        public Builder withOwlPrefixes() {
            this.with(Namespaces.OWL);
            this.with(Namespaces.RDFS);
            this.with(Namespaces.RDF);
            this.with(Namespaces.XSD);
            return this;
        }

        public Builder withWellKnownPrefixes() {
            Arrays.stream(Namespaces.values()).forEach(ns -> this.withPrefix(ns.getPrefixName() + ":", ns.getPrefixIRI()));
            return this;
        }

        public PrefixedNameRenderer build() {
            return PrefixedNameRenderer.get(this.prefix2PrefixNameMap);
        }

        private void with(Namespaces ns) {
            this.withPrefix(ns.getPrefixName() + ":", ns.getPrefixIRI());
        }
    }
}

