/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.plugin.manipulators.nodes.ui;

import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.gephi.datalab.plugin.manipulators.nodes.LinkNodes;
import org.gephi.datalab.spi.DialogControls;
import org.gephi.datalab.spi.Manipulator;
import org.gephi.datalab.spi.ManipulatorUI;
import org.gephi.graph.api.Node;
import org.openide.util.NbBundle;

public class LinkNodesUI
extends JPanel
implements ManipulatorUI {
    private LinkNodes manipulator;
    private Node[] nodes;
    private JLabel descriptionLabel;
    private JRadioButton directedEdge;
    private ButtonGroup edgeTypeButtonGroup;
    private JLabel edgeTypeLabel;
    private JComboBox sourceNodeComboBox;
    private JLabel sourceNodeLabel;
    private JRadioButton undirectedEdge;

    public LinkNodesUI() {
        this.initComponents();
    }

    public void setup(Manipulator m, DialogControls dialogControls) {
        this.manipulator = (LinkNodes)m;
        this.nodes = this.manipulator.getNodes();
        if (this.manipulator.isDirected()) {
            this.directedEdge.setSelected(true);
        } else {
            this.undirectedEdge.setSelected(true);
        }
        Node sourceNode = this.manipulator.getSourceNode();
        for (int i = 0; i < this.nodes.length; ++i) {
            this.sourceNodeComboBox.addItem(this.nodes[i].getId() + " - " + this.nodes[i].getLabel());
            if (this.nodes[i] != sourceNode) continue;
            this.sourceNodeComboBox.setSelectedIndex(i);
        }
    }

    public void unSetup() {
        this.manipulator.setSourceNode(this.nodes[this.sourceNodeComboBox.getSelectedIndex()]);
        this.manipulator.setDirected(this.directedEdge.isSelected());
    }

    public String getDisplayName() {
        return this.manipulator.getName();
    }

    public JPanel getSettingsPanel() {
        return this;
    }

    public boolean isModal() {
        return true;
    }

    private void initComponents() {
        this.edgeTypeButtonGroup = new ButtonGroup();
        this.descriptionLabel = new JLabel();
        this.directedEdge = new JRadioButton();
        this.undirectedEdge = new JRadioButton();
        this.sourceNodeComboBox = new JComboBox();
        this.sourceNodeLabel = new JLabel();
        this.edgeTypeLabel = new JLabel();
        this.descriptionLabel.setText(NbBundle.getMessage(LinkNodesUI.class, (String)"LinkNodesUI.descriptionLabel.text"));
        this.edgeTypeButtonGroup.add(this.directedEdge);
        this.directedEdge.setText(NbBundle.getMessage(LinkNodesUI.class, (String)"LinkNodesUI.directedEdge.text"));
        this.edgeTypeButtonGroup.add(this.undirectedEdge);
        this.undirectedEdge.setText(NbBundle.getMessage(LinkNodesUI.class, (String)"LinkNodesUI.undirectedEdge.text"));
        this.sourceNodeLabel.setText(NbBundle.getMessage(LinkNodesUI.class, (String)"LinkNodesUI.sourceNodeLabel.text"));
        this.edgeTypeLabel.setText(NbBundle.getMessage(LinkNodesUI.class, (String)"LinkNodesUI.edgeTypeLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.descriptionLabel, -1, 242, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sourceNodeLabel).addComponent(this.edgeTypeLabel)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.directedEdge).addGap(18, 18, 18).addComponent(this.undirectedEdge)).addComponent(this.sourceNodeComboBox, -2, 160, -2)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.descriptionLabel, -2, 51, -2).addGap(5, 5, 5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sourceNodeLabel).addComponent(this.sourceNodeComboBox, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.directedEdge, -2, 23, -2).addComponent(this.undirectedEdge).addComponent(this.edgeTypeLabel)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

