# KubeOne Addons

**Author:** Marko Mudrinić ([@xmudrii](https://github.com/xmudrii))  
**Status:** Draft | Review | **Final**  
**Created:** 2020-02-05  
**Last updated:** 2020-02-12

## Abstract

Some components might differ between various setups, such as logging and
monitoring stacks, log rotating, backup and recovery mechanisms. `kubeone` should
allow operators to use non-default components and deploy them on the provisioning
time. To accomplish this, this proposal introduces the concept of **Addons**.

## Goals

* Provide a mechanism for defining addons
* Reconcile addons on the provisioning and upgrade time
  * This includes modifying addons that have gotten changed and/or removing addons
  that are not present anymore.

## Non-goals

* Support for hooks
  * Operators will not be able to choose when addons will be deployed.
* Default addons and the addons marketplace
  * This proposal focuses only on the implementation of the addons mechanism.
  For now, we will not be shipping default addons or a marketplace for addons.

## Implementation

The KubeOne Addons are defined in a form of the addons manifest. The addons manifest
is a Kubernetes YAML file containing a list of resources to be deployed. A single manifest
corresponds to a single addon, i.e. one addon can have only one manifest.

To use addons, operators need to update the KubeOneCluster manifest to enable 
the addons support and specify a path to the directory containing manifests.

The following example shows how to enable addons:
```yaml
apiVersion: kubeone.io/v1alpha1
kind: KubeOneCluster
versions:
  kubernetes: 1.16.1
cloudProvider:
  name: aws
addons:
  enable: true
  path: "./addons"
```

KubeOne will apply manifests when running `kubeone install` or `kubeone upgrade` after
installing/upgrading MachineDeployments. Addons are applied in alphabetical order,
so the operator control which addon will be deployed first by setting the appropriate file name.

On top of that, addons manifest supports templating, based on [Go templates][go-templates].
Operators will be able to access properties of the KubeOneCluster object and credentials.
For example, you can get the name of the cluster with the following property:
`{{ .KubeOne.Cluster.Name }}`. Templating is done on the run-time, before applying addons.

In the addons reconciliation phase, addons will be uploaded to a control plane
instance and then applied by running `kubectl` over SSH. All defined resources
will have the `kubeone.io/addon: ""` label meaning that the resource
has been deployed as a KubeOne addon. Labeling resources allows us to use commands such
as `kubectl apply --prune` to remove resources that are deployed but not present in the
addons manifest anymore.

## Tasks & Efforts

* Extended the API to enable configuring addons
* Source addons manifests from a given directory
* Add support for templating addons
* Implement reconciliation of addons
* Extend the `kubeone install` and `kubeone upgrade` commands to run reconciliation
* Write the documentation explaining how to use and write addons

[go-templates]: (https://golang.org/pkg/text/template/)