/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.time;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.python.core.ClassDictInit;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyInteger;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.__builtin__;
import org.python.modules._locale.DateSymbolLocale;
import org.python.modules._locale._locale;
import org.python.modules.time.PyTimeTuple;
import org.python.modules.time.TimeFunctions;

public class Time
implements ClassDictInit {
    public static final PyString __doc__ = new PyString("This module provides various functions to manipulate time values.\n\nThere are two standard representations of time.  One is the number\nof seconds since the Epoch, in UTC (a.k.a. GMT).  It may be an integer\nor a floating point number (to represent fractions of seconds).\nThe Epoch is system-defined; on Unix, it is generally January 1st, 1970.\nThe actual value can be retrieved by calling gmtime(0).\n\nThe other representation is a tuple of 9 integers giving local time.\nThe tuple items are:\n  year (four digits, e.g. 1998)\n  month (1-12)\n  day (1-31)\n  hours (0-23)\n  minutes (0-59)\n  seconds (0-59)\n  weekday (0-6, Monday is 0)\n  Julian day (day in the year, 1-366)\n  DST (Daylight Savings Time) flag (-1, 0 or 1)\nIf the DST flag is 0, the time is given in the regular time zone;\nif it is 1, the time is given in the DST time zone;\nif it is -1, mktime() should guess based on the date and time.\n\nVariables:\n\ntimezone -- difference in seconds between UTC and local standard time\naltzone -- difference in  seconds between UTC and local DST time\ndaylight -- whether local time should reflect DST\ntzname -- tuple of (standard time zone name, DST time zone name)\n\nFunctions:\n\ntime() -- return current time in seconds since the Epoch as a float\nclock() -- return CPU time since process start as a float\nsleep() -- delay for a number of seconds given as a float\ngmtime() -- convert seconds since Epoch to UTC tuple\nlocaltime() -- convert seconds since Epoch to local time tuple\nasctime() -- convert time tuple to string\nctime() -- convert time in seconds to string\nmktime() -- convert local time tuple to seconds since Epoch\nstrftime() -- convert time tuple to string according to format specification\nstrptime() -- parse string to time tuple according to format specification\n");
    private static final double NANOS_PER_SECOND = 1.0E9;
    private static long initialClock;
    private static volatile boolean clockInitialized;
    protected static DateSymbolLocale datesyms;
    protected static String[] shortdays;
    protected static String[] shortmonths;
    private static String[] enshortdays;
    private static String[] enshortmonths;
    public static int timezone;
    public static int altzone;
    public static int daylight;
    public static PyTuple tzname;
    public static final int accept2dyear = 0;
    private static final String DEFAULT_FORMAT_PY = "%a %b %d %H:%M:%S %Y";

    public static void classDictInit(PyObject dict) {
        dict.__setitem__("time", (PyObject)new TimeFunctions("time", 0, 0));
        dict.__setitem__("clock", (PyObject)new TimeFunctions("clock", 1, 0));
        dict.__setitem__("struct_time", (PyObject)PyTimeTuple.TYPE);
        dict.__setitem__("__name__", (PyObject)Py.newString("time"));
        TimeZone tz = TimeZone.getDefault();
        tzname = new PyTuple(new PyString(tz.getDisplayName(false, 0)), new PyString(tz.getDisplayName(true, 0)));
        daylight = tz.useDaylightTime() ? 1 : 0;
        timezone = -tz.getRawOffset() / 1000;
        altzone = timezone - tz.getDSTSavings() / 1000;
    }

    public static double time() {
        return (double)System.currentTimeMillis() / 1000.0;
    }

    public static double clock() {
        if (!clockInitialized) {
            initialClock = System.nanoTime();
            clockInitialized = true;
            return 0.0;
        }
        return (double)(System.nanoTime() - initialClock) / 1.0E9;
    }

    private static void throwValueError(String msg2) {
        throw new PyException(Py.ValueError, new PyString(msg2));
    }

    private static int item(PyTuple tup, int i) {
        int val = tup.__getitem__(i).asInt();
        boolean valid = true;
        switch (i) {
            case 0: {
                break;
            }
            case 1: {
                valid = 0 <= val && val <= 12;
                break;
            }
            case 2: {
                valid = 0 <= val && val <= 31;
                break;
            }
            case 3: {
                valid = 0 <= val && val <= 23;
                break;
            }
            case 4: {
                valid = 0 <= val && val <= 59;
                break;
            }
            case 5: {
                valid = 0 <= val && val <= 61;
                break;
            }
            case 6: {
                valid = 0 <= val && val <= 6;
                break;
            }
            case 7: {
                valid = 0 <= val && val < 367;
                break;
            }
            case 8: {
                boolean bl = valid = -1 <= val && val <= 1;
            }
        }
        if (!valid) {
            String msg2;
            switch (i) {
                case 1: {
                    msg2 = "month out of range (1-12)";
                    break;
                }
                case 2: {
                    msg2 = "day out of range (1-31)";
                    break;
                }
                case 3: {
                    msg2 = "hour out of range (0-23)";
                    break;
                }
                case 4: {
                    msg2 = "minute out of range (0-59)";
                    break;
                }
                case 5: {
                    msg2 = "second out of range (0-59)";
                    break;
                }
                case 6: {
                    msg2 = "day of week out of range (0-6)";
                    break;
                }
                case 7: {
                    msg2 = "day of year out of range (1-366)";
                    break;
                }
                case 8: {
                    msg2 = "daylight savings flag out of range (-1,0,1)";
                    break;
                }
                default: {
                    msg2 = "ignore";
                }
            }
            Time.throwValueError(msg2);
        }
        switch (i) {
            case 1: {
                if (val <= 0) break;
                --val;
                break;
            }
            case 2: 
            case 7: {
                if (val != 0) break;
                val = 1;
            }
        }
        return val;
    }

    private static GregorianCalendar _tupletocal(PyTuple tup) {
        GregorianCalendar gc2 = new GregorianCalendar(Time.item(tup, 0), Time.item(tup, 1), Time.item(tup, 2), Time.item(tup, 3), Time.item(tup, 4), Time.item(tup, 5));
        gc2.setGregorianChange(new Date(Long.MIN_VALUE));
        return gc2;
    }

    public static double mktime(PyTuple tup) {
        GregorianCalendar cal;
        try {
            cal = Time._tupletocal(tup);
        }
        catch (PyException e) {
            e.type = Py.OverflowError;
            throw e;
        }
        int dst = Time.item(tup, 8);
        if (dst == 0 || dst == 1) {
            cal.set(16, dst * cal.getTimeZone().getDSTSavings());
        }
        return (double)cal.getTime().getTime() / 1000.0;
    }

    protected static PyTimeTuple _timefields(double secs, TimeZone tz) {
        GregorianCalendar cal = new GregorianCalendar(tz);
        cal.clear();
        cal.setGregorianChange(new Date(Long.MIN_VALUE));
        if ((secs *= 1000.0) < -9.223372036854776E18 || secs > 9.223372036854776E18) {
            throw Py.ValueError("timestamp out of range for platform time_t");
        }
        cal.setTime(new Date((long)secs));
        int isdst = tz.inDaylightTime(cal.getTime()) ? 1 : 0;
        return Time.toTimeTuple(cal, isdst);
    }

    private static PyTimeTuple toTimeTuple(Calendar cal, int isdst) {
        int dow = cal.get(7) - 2;
        if (dow < 0) {
            dow += 7;
        }
        return new PyTimeTuple(new PyInteger(cal.get(1)), new PyInteger(cal.get(2) + 1), new PyInteger(cal.get(5)), new PyInteger(cal.get(10) + 12 * cal.get(9)), new PyInteger(cal.get(12)), new PyInteger(cal.get(13)), new PyInteger(dow), new PyInteger(cal.get(6)), new PyInteger(isdst));
    }

    public static double parseTimeDoubleArg(PyObject arg) {
        if (arg == Py.None) {
            return Time.time();
        }
        Object result = arg.__tojava__(Double.class);
        if (result == Py.NoConversion) {
            throw Py.TypeError("a float is required");
        }
        return (Double)result;
    }

    public static PyTuple localtime() {
        return Time.localtime(Py.None);
    }

    public static PyTuple localtime(PyObject secs) {
        return Time._timefields(Time.parseTimeDoubleArg(secs), TimeZone.getDefault());
    }

    public static PyTuple gmtime() {
        return Time.gmtime(Py.None);
    }

    public static PyTuple gmtime(PyObject arg) {
        return Time._timefields(Time.parseTimeDoubleArg(arg), TimeZone.getTimeZone("GMT"));
    }

    public static PyString ctime() {
        return Time.ctime(Py.None);
    }

    public static PyString ctime(PyObject secs) {
        return Time.asctime(Time.localtime(secs));
    }

    private static synchronized String _shortday(int dow) {
        if (shortdays == null) {
            shortdays = new String[7];
            String[] names = datesyms.getShortWeekdays();
            for (int i = 0; i < 6; ++i) {
                Time.shortdays[i] = names[i + 2];
            }
            Time.shortdays[6] = names[1];
        }
        try {
            return shortdays[dow];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new PyException(Py.ValueError, new PyString("day of week out of range (0-6)"));
        }
    }

    private static synchronized String _shortmonth(int month0to11) {
        if (shortmonths == null) {
            shortmonths = new String[12];
            String[] names = datesyms.getShortMonths();
            for (int i = 0; i < 12; ++i) {
                Time.shortmonths[i] = names[i];
            }
        }
        try {
            return shortmonths[month0to11];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new PyException(Py.ValueError, new PyString("month out of range (1-12)"));
        }
    }

    private static String _padint(int i, int target) {
        String s = Integer.toString(i);
        int sz = s.length();
        if (target <= sz) {
            return s;
        }
        if (target == sz + 1) {
            return "0" + s;
        }
        if (target == sz + 2) {
            return "00" + s;
        }
        char[] c = new char[target - sz];
        Arrays.fill(c, '0');
        return new String(c) + s;
    }

    private static String _twodigit(int i) {
        return Time._padint(i, 2);
    }

    private static String _truncyear(int year) {
        String yearstr = Time._padint(year, 4);
        return yearstr.substring(yearstr.length() - 2, yearstr.length());
    }

    public static PyString asctime() {
        return Time.asctime(Time.localtime());
    }

    public static PyString asctime(PyObject obj) {
        PyTuple tup = obj instanceof PyTuple ? (PyTuple)obj : PyTuple.fromIterable(obj);
        int len = tup.__len__();
        if (len != 9) {
            throw Py.TypeError(String.format("argument must be sequence of length 9, not %d", len));
        }
        StringBuilder buf = new StringBuilder(25);
        buf.append(enshortdays[Time.item(tup, 6)]).append(' ');
        buf.append(enshortmonths[Time.item(tup, 1)]).append(' ');
        int dayOfMonth = Time.item(tup, 2);
        if (dayOfMonth < 10) {
            buf.append(' ');
        }
        buf.append(dayOfMonth).append(' ');
        buf.append(Time._twodigit(Time.item(tup, 3))).append(':');
        buf.append(Time._twodigit(Time.item(tup, 4))).append(':');
        buf.append(Time._twodigit(Time.item(tup, 5))).append(' ');
        return new PyString(buf.append(Time.item(tup, 0)).toString());
    }

    public static String locale_asctime(PyTuple tup) {
        Time.checkLocale();
        int day = Time.item(tup, 6);
        int mon = Time.item(tup, 1);
        return Time._shortday(day) + " " + Time._shortmonth(mon) + " " + Time._twodigit(Time.item(tup, 2)) + " " + Time._twodigit(Time.item(tup, 3)) + ":" + Time._twodigit(Time.item(tup, 4)) + ":" + Time._twodigit(Time.item(tup, 5)) + " " + Time.item(tup, 0);
    }

    public static void sleep(double secs) {
        if (secs == 0.0) {
            Thread.yield();
        } else {
            try {
                Thread.sleep((long)(secs * 1000.0));
            }
            catch (InterruptedException e) {
                throw new PyException(Py.KeyboardInterrupt, "interrupted sleep");
            }
        }
    }

    public static PyString strftime(String format) {
        return Time.strftime(format, Time.localtime());
    }

    public static PyString strftime(String format, PyTuple tup) {
        Time.checkLocale();
        int[] items = new int[9];
        for (int i = 0; i < 9; ++i) {
            items[i] = Time.item(tup, i);
        }
        String s = "";
        int lastc = 0;
        GregorianCalendar cal = null;
        while (lastc < format.length()) {
            int i = format.indexOf("%", lastc);
            if (i < 0) {
                s = s + format.substring(lastc);
                break;
            }
            if (i == format.length() - 1) {
                s = s + "%";
                break;
            }
            s = s + format.substring(lastc, i);
            switch (format.charAt(++i)) {
                case 'a': {
                    int j = items[6];
                    s = s + Time._shortday(j);
                    break;
                }
                case 'A': {
                    String[] syms = datesyms.getWeekdays();
                    int j = items[6];
                    if (0 <= j && j < 6) {
                        s = s + syms[j + 2];
                        break;
                    }
                    if (j == 6) {
                        s = s + syms[1];
                        break;
                    }
                    Time.throwValueError("day of week out of range (0 - 6)");
                    break;
                }
                case 'b': {
                    int j = items[1];
                    s = s + Time._shortmonth(j);
                    break;
                }
                case 'B': {
                    String[] syms = datesyms.getMonths();
                    int j = items[1];
                    s = s + syms[j];
                    break;
                }
                case 'c': {
                    s = s + Time.locale_asctime(tup);
                    break;
                }
                case 'd': {
                    s = s + Time._twodigit(items[2]);
                    break;
                }
                case 'H': {
                    s = s + Time._twodigit(items[3]);
                    break;
                }
                case 'I': {
                    int j = items[3] % 12;
                    if (j == 0) {
                        j = 12;
                    }
                    s = s + Time._twodigit(j);
                    break;
                }
                case 'j': {
                    s = s + Time._padint(items[7], 3);
                    break;
                }
                case 'm': {
                    s = s + Time._twodigit(items[1] + 1);
                    break;
                }
                case 'M': {
                    s = s + Time._twodigit(items[4]);
                    break;
                }
                case 'p': {
                    int j = items[3];
                    String[] syms = datesyms.getAmPmStrings();
                    if (0 <= j && j < 12) {
                        s = s + syms[0];
                        break;
                    }
                    if (12 <= j && j < 24) {
                        s = s + syms[1];
                        break;
                    }
                    Time.throwValueError("hour out of range (0-23)");
                    break;
                }
                case 'S': {
                    s = s + Time._twodigit(items[5]);
                    break;
                }
                case 'U': {
                    if (cal == null) {
                        cal = Time._tupletocal(tup);
                    }
                    cal.setFirstDayOfWeek(1);
                    cal.setMinimalDaysInFirstWeek(7);
                    int j = cal.get(3);
                    if (cal.get(2) == 0 && j >= 52) {
                        j = 0;
                    }
                    s = s + Time._twodigit(j);
                    break;
                }
                case 'w': {
                    int j = (items[6] + 1) % 7;
                    s = s + j;
                    break;
                }
                case 'W': {
                    if (cal == null) {
                        cal = Time._tupletocal(tup);
                    }
                    cal.setFirstDayOfWeek(2);
                    cal.setMinimalDaysInFirstWeek(7);
                    int j = cal.get(3);
                    if (cal.get(2) == 0 && j >= 52) {
                        j = 0;
                    }
                    s = s + Time._twodigit(j);
                    break;
                }
                case 'x': {
                    s = s + Time._twodigit(items[1] + 1) + "/" + Time._twodigit(items[2]) + "/" + Time._truncyear(items[0]);
                    break;
                }
                case 'X': {
                    s = s + Time._twodigit(items[3]) + ":" + Time._twodigit(items[4]) + ":" + Time._twodigit(items[5]);
                    break;
                }
                case 'Y': {
                    s = s + Time._padint(items[0], 4);
                    break;
                }
                case 'y': {
                    s = s + Time._truncyear(items[0]);
                    break;
                }
                case 'Z': {
                    if (cal == null) {
                        cal = Time._tupletocal(tup);
                    }
                    s = s + cal.getTimeZone().getDisplayName(items[8] > 0, 0);
                    break;
                }
                case '%': {
                    s = s + "%";
                    break;
                }
                default: {
                    s = s + "%" + format.charAt(i);
                    ++i;
                }
            }
            lastc = i + 1;
            ++i;
        }
        return Py.newStringUTF8(s);
    }

    private static void checkLocale() {
        DateSymbolLocale latestLocale = _locale.getDateSymbolLocale();
        if (!latestLocale.equals(datesyms)) {
            datesyms = latestLocale;
            shortdays = null;
            shortmonths = null;
        }
    }

    public static PyTuple strptime(String data_string) {
        return Time.strptime(data_string, DEFAULT_FORMAT_PY);
    }

    private static PyTuple pystrptime(String data_string, String format) {
        return (PyTuple)__builtin__.__import__("_strptime").invoke("_strptime_time", Py.newUnicode(data_string), Py.newUnicode(format));
    }

    public static PyTuple strptime(String data_string, String format) {
        return Time.pystrptime(data_string, format);
    }

    static {
        datesyms = _locale.getDateSymbolLocale();
        shortdays = null;
        shortmonths = null;
        enshortdays = new String[]{"Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"};
        enshortmonths = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
        altzone = -1;
        tzname = null;
    }
}

