/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui;

import java.awt.Dimension;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class DecimalNumberField
extends JTextField {
    public DecimalNumberField() {
        this(false);
    }

    public DecimalNumberField(boolean bl) {
        super(6);
        this.setDocument(new DecimalNumberDocument(bl));
    }

    public double getValue() {
        return DecimalNumberField.parseValue(this.getText());
    }

    public void setValue(double d) {
        this.setText("" + d);
    }

    private static double parseValue(String string) {
        double d = 0.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (d < 0.0) {
            d = 0.0;
        }
        return d;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        if (dimension.width < 50) {
            dimension.width = 50;
        }
        return dimension;
    }

    protected static class DecimalNumberDocument
    extends PlainDocument {
        private boolean _allowNegative = false;

        DecimalNumberDocument(boolean bl) {
            this._allowNegative = bl;
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            char[] cArray = string.toCharArray();
            char[] cArray2 = new char[cArray.length];
            int n2 = 0;
            int n3 = 0;
            while (n3 < cArray2.length) {
                if (!Character.isLetter(cArray[n3]) && (this._allowNegative || cArray[n3] != '-') && cArray[n3] != ' ') {
                    cArray2[n2++] = cArray[n3];
                }
                ++n3;
            }
            super.insertString(n, new String(cArray2, 0, n2), attributeSet);
        }
    }
}

