/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multitabs.impl;

import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.multitabs.impl.MultiRowTabDisplayer;
import org.netbeans.core.multitabs.impl.ProjectSupport;
import org.netbeans.core.multitabs.impl.SingleRowTabTable;
import org.netbeans.swing.tabcontrol.TabDataModel;

public class RowPerProjectTabDisplayer
extends MultiRowTabDisplayer
implements ChangeListener {
    public RowPerProjectTabDisplayer(TabDataModel tabModel, int tabsLocation) {
        super(tabModel, tabsLocation);
    }

    @Override
    void initRows() {
        int rowCount = ProjectSupport.getDefault().getOpenProjects().length;
        if (rowCount > 1) {
            ++rowCount;
        }
        for (int i = 0; i < rowCount; ++i) {
            this.addRowTable();
        }
    }

    private void adjustRows(int projectCount) {
        int rowCount = projectCount;
        if (rowCount > 1) {
            ++rowCount;
        }
        while (rowCount < this.rowTables.size() && this.rowTables.size() > 1) {
            this.removeTable();
        }
        while (rowCount > this.rowTables.size()) {
            this.addRowTable();
        }
        this.layoutManager.invalidate();
    }

    private void removeTable() {
        if (this.rowTables.size() < 2) {
            return;
        }
        SingleRowTabTable table = (SingleRowTabTable)this.rowTables.get(this.rowTables.size() - 1);
        table.removeMouseWheelListener(this);
        table.removeMouseListener(this.controller);
        table.removeMouseListener(this.closeHandler);
        table.removeMouseMotionListener(this.closeHandler);
        table.getSelectionModel().removeListSelectionListener(this);
        table.getColumnModel().getSelectionModel().removeListSelectionListener(this);
        this.rowTables.remove(table);
        this.rowPanel.remove(table);
    }

    @Override
    public void addNotify() {
        ProjectSupport.getDefault().addChangeListener(this);
        super.addNotify();
        this.layoutManager.invalidate();
    }

    @Override
    public void removeNotify() {
        ProjectSupport.getDefault().removeChangeListener(this);
        super.removeNotify();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        final int projectCount = ProjectSupport.getDefault().getOpenProjects().length;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RowPerProjectTabDisplayer.this.adjustRows(projectCount);
            }
        });
    }
}

