/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.plugin.manipulators.columns.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.gephi.datalab.plugin.manipulators.columns.ConvertColumnToDynamic;
import org.gephi.datalab.spi.DialogControls;
import org.gephi.datalab.spi.columns.AttributeColumnsManipulator;
import org.gephi.datalab.spi.columns.AttributeColumnsManipulatorUI;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Table;
import org.gephi.ui.utils.ColumnTitleValidator;
import org.gephi.ui.utils.IntervalBoundValidator;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.ValidationPanel;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class ConvertColumnToDynamicTimestampsUI
extends JPanel
implements AttributeColumnsManipulatorUI {
    private static final String TIMESTAMP_PREFERENCE = "ConvertColumnToDynamicTimestampsUI.intervalStart";
    private static final String REPLACE_COLUMN_PREFERENCE = "ConvertColumnToDynamicTimestampsUI.replaceColumn";
    private static final String DEFAULT_TIMESTAMP = "0";
    private ConvertColumnToDynamic manipulator;
    private Table table;
    private DialogControls dialogControls;
    private ValidationPanel validationPanel;
    private JLabel descriptionLabel;
    private JCheckBox replaceColumnCheckbox;
    private JLabel timestampLabel;
    private JTextField timestampText;
    private JLabel titleLabel;
    private JTextField titleTextField;

    public ConvertColumnToDynamicTimestampsUI() {
        this.initComponents();
        this.timestampText.setText(NbPreferences.forModule(ConvertColumnToDynamicTimestampsUI.class).get(TIMESTAMP_PREFERENCE, DEFAULT_TIMESTAMP));
        this.replaceColumnCheckbox.setSelected(NbPreferences.forModule(ConvertColumnToDynamicTimestampsUI.class).getBoolean(REPLACE_COLUMN_PREFERENCE, false));
    }

    private void buildValidationPanel() {
        this.validationPanel = new ValidationPanel();
        this.validationPanel.setInnerComponent((Component)this);
        ValidationGroup group = this.validationPanel.getValidationGroup();
        group.add((JTextComponent)this.titleTextField, new Validator[]{new ColumnTitleValidator(this.table)});
        group.add((JTextComponent)this.timestampText, new Validator[]{new IntervalBoundValidator()});
        this.validationPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ConvertColumnToDynamicTimestampsUI.this.dialogControls.setOkButtonEnabled(!ConvertColumnToDynamicTimestampsUI.this.validationPanel.isProblem());
            }
        });
    }

    public void setup(AttributeColumnsManipulator m, GraphModel graphModel, Table table, Column column, DialogControls dialogControls) {
        this.table = table;
        this.dialogControls = dialogControls;
        this.manipulator = (ConvertColumnToDynamic)m;
        this.buildValidationPanel();
        this.descriptionLabel.setText(NbBundle.getMessage(ConvertColumnToDynamicTimestampsUI.class, (String)"ConvertColumnToDynamicUI.descriptionLabel.text", (Object)column.getTitle()));
        this.titleTextField.setText(NbBundle.getMessage(ConvertColumnToDynamicTimestampsUI.class, (String)"ConvertColumnToDynamicUI.new.title", (Object)column.getTitle()));
        this.refreshTitleEnabledState();
    }

    public void unSetup() {
        String timestampString = this.timestampText.getText();
        boolean replaceColumn = this.replaceColumnCheckbox.isSelected();
        NbPreferences.forModule(ConvertColumnToDynamicTimestampsUI.class).put(TIMESTAMP_PREFERENCE, timestampString);
        NbPreferences.forModule(ConvertColumnToDynamicTimestampsUI.class).putBoolean(REPLACE_COLUMN_PREFERENCE, replaceColumn);
        if (!this.validationPanel.isProblem()) {
            this.manipulator.setTitle(this.titleTextField.getText());
            this.manipulator.setReplaceColumn(replaceColumn);
            double timestamp = AttributeUtils.parseDateTimeOrTimestamp((String)timestampString);
            this.manipulator.setLow(timestamp);
            this.manipulator.setHigh(timestamp);
        }
    }

    public String getDisplayName() {
        return this.manipulator.getName();
    }

    public JPanel getSettingsPanel() {
        return this.validationPanel;
    }

    public boolean isModal() {
        return true;
    }

    private void refreshTitleEnabledState() {
        boolean enabled = !this.replaceColumnCheckbox.isSelected();
        this.titleTextField.setEnabled(enabled);
    }

    private void initComponents() {
        this.titleLabel = new JLabel();
        this.titleTextField = new JTextField();
        this.descriptionLabel = new JLabel();
        this.replaceColumnCheckbox = new JCheckBox();
        this.timestampLabel = new JLabel();
        this.timestampText = new JTextField();
        this.titleLabel.setText(NbBundle.getMessage(ConvertColumnToDynamicTimestampsUI.class, (String)"ConvertColumnToDynamicTimestampsUI.titleLabel.text"));
        this.titleTextField.setText(NbBundle.getMessage(ConvertColumnToDynamicTimestampsUI.class, (String)"ConvertColumnToDynamicTimestampsUI.titleTextField.text"));
        this.descriptionLabel.setHorizontalAlignment(0);
        this.descriptionLabel.setText(null);
        this.replaceColumnCheckbox.setText(NbBundle.getMessage(ConvertColumnToDynamicTimestampsUI.class, (String)"ConvertColumnToDynamicTimestampsUI.replaceColumnCheckbox.text"));
        this.replaceColumnCheckbox.setToolTipText(NbBundle.getMessage(ConvertColumnToDynamicTimestampsUI.class, (String)"ConvertColumnToDynamicTimestampsUI.replaceColumnCheckbox.toolTipText"));
        this.replaceColumnCheckbox.setHorizontalTextPosition(10);
        this.replaceColumnCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConvertColumnToDynamicTimestampsUI.this.replaceColumnCheckboxActionPerformed(evt);
            }
        });
        this.timestampLabel.setText(NbBundle.getMessage(ConvertColumnToDynamicTimestampsUI.class, (String)"ConvertColumnToDynamicTimestampsUI.timestampLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.descriptionLabel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.replaceColumnCheckbox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.titleLabel, -2, 61, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.titleTextField, -1, 177, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.timestampLabel, -2, 108, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.timestampText))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.descriptionLabel, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.timestampLabel).addComponent(this.timestampText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.titleLabel).addComponent(this.titleTextField, -2, -1, -2).addComponent(this.replaceColumnCheckbox)).addGap(24, 24, 24)));
    }

    private void replaceColumnCheckboxActionPerformed(ActionEvent evt) {
        this.refreshTitleEnabledState();
    }
}

