/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.xdevapi;

import com.mysql.cj.api.conf.PropertySet;
import com.mysql.cj.api.conf.ReadableProperty;
import com.mysql.cj.api.result.Row;
import com.mysql.cj.api.xdevapi.BaseSession;
import com.mysql.cj.api.xdevapi.Schema;
import com.mysql.cj.core.conf.PropertyDefinitions;
import com.mysql.cj.core.conf.url.ConnectionUrl;
import com.mysql.cj.core.exceptions.WrongArgumentException;
import com.mysql.cj.core.io.StringValueFactory;
import com.mysql.cj.core.util.StringUtils;
import com.mysql.cj.x.core.MysqlxSession;
import com.mysql.cj.x.core.XDevAPIError;
import com.mysql.cj.xdevapi.SchemaImpl;
import java.util.List;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class AbstractSession
implements BaseSession {
    protected MysqlxSession session;
    protected String defaultSchemaName;

    public AbstractSession(Properties properties) {
        this.session = new MysqlxSession(properties);
        this.session.changeUser(properties.getProperty("user"), properties.getProperty("password"), properties.getProperty("DBNAME"));
        this.defaultSchemaName = properties.getProperty("DBNAME");
    }

    protected AbstractSession() {
    }

    @Override
    public List<Schema> getSchemas() {
        Function<Row, String> rowToName = r -> r.getValue(0, new StringValueFactory());
        Function<Row, Schema> rowToSchema = rowToName.andThen(n -> new SchemaImpl(this.session, this, (String)n));
        return this.session.query("select schema_name from information_schema.schemata", rowToSchema, Collectors.toList());
    }

    @Override
    public Schema getSchema(String schemaName) {
        return new SchemaImpl(this.session, this, schemaName);
    }

    @Override
    public String getDefaultSchemaName() {
        return this.defaultSchemaName;
    }

    @Override
    public Schema getDefaultSchema() {
        if (this.defaultSchemaName == null) {
            throw new WrongArgumentException("Default schema not provided");
        }
        return new SchemaImpl(this.session, this, this.defaultSchemaName);
    }

    @Override
    public Schema createSchema(String schemaName) {
        StringBuilder stmtString = new StringBuilder("CREATE DATABASE ");
        stmtString.append(StringUtils.quoteIdentifier(schemaName, true));
        this.session.update(stmtString.toString());
        return this.getSchema(schemaName);
    }

    @Override
    public Schema createSchema(String schemaName, boolean reuseExistingObject) {
        try {
            return this.createSchema(schemaName);
        }
        catch (XDevAPIError ex) {
            if (ex.getErrorCode() == 1007) {
                return this.getSchema(schemaName);
            }
            throw ex;
        }
    }

    @Override
    public void dropSchema(String schemaName) {
        StringBuilder stmtString = new StringBuilder("DROP DATABASE ");
        stmtString.append(StringUtils.quoteIdentifier(schemaName, true));
        this.session.update(stmtString.toString());
    }

    @Override
    public void dropCollection(String schemaName, String collectionName) {
        this.session.dropCollection(schemaName, collectionName);
    }

    @Override
    public void dropTable(String schemaName, String tableName) {
        this.session.dropCollection(schemaName, tableName);
    }

    @Override
    public void startTransaction() {
        this.session.update("START TRANSACTION");
    }

    @Override
    public void commit() {
        this.session.update("COMMIT");
    }

    @Override
    public void rollback() {
        this.session.update("ROLLBACK");
    }

    @Override
    public String getUri() {
        PropertySet pset = this.session.getPropertySet();
        StringBuilder sb = new StringBuilder(ConnectionUrl.Type.XDEVAPI_SESSION.getProtocol());
        sb.append("//").append(this.session.getHost()).append(":").append(this.session.getPort()).append("/").append(this.defaultSchemaName).append("?");
        for (String propName : PropertyDefinitions.PROPERTY_NAME_TO_PROPERTY_DEFINITION.keySet()) {
            ReadableProperty propToGet = pset.getReadableProperty(propName);
            String propValue = propToGet.getStringValue();
            if (propValue == null || propValue.equals(propToGet.getPropertyDefinition().getDefaultValue().toString())) continue;
            sb.append(",");
            sb.append(propName);
            sb.append("=");
            sb.append(propValue);
        }
        return sb.toString();
    }

    @Override
    public boolean isOpen() {
        return this.session.isOpen();
    }

    @Override
    public void close() {
        this.session.close();
    }
}

