/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import javajs.util.PT;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class EspressoReader
extends AtomSetCollectionReader {
    private float[] cellParams;
    private Double totEnergy;
    private boolean endFlag;
    private float aPar;

    @Override
    protected void initializeReader() {
        this.setSpaceGroupName("P1");
        this.doApplySymmetry = true;
    }

    @Override
    protected boolean checkLine() throws Exception {
        if (this.line.contains("lattice parameter (a_0)") || this.line.contains("lattice parameter (alat)")) {
            this.readAparam();
        } else if (this.line.contains("crystal axes:")) {
            this.readCellParam(false);
        } else if (this.line.contains("CELL_PARAMETERS (")) {
            this.readCellParam(true);
        } else if (this.line.contains("Cartesian axes")) {
            this.discardLinesUntilContains("positions (");
            if (this.doGetModel(++this.modelNumber, null)) {
                this.readAtoms();
            }
        } else if (this.line.contains("POSITIONS (")) {
            if (this.doGetModel(++this.modelNumber, null)) {
                this.readAtoms();
            }
        } else if (this.line.contains("!    total energy")) {
            this.readEnergy();
        } else if (this.line.contains("A final scf")) {
            this.endFlag = true;
        }
        return true;
    }

    private void readAparam() throws Exception {
        this.aPar = this.parseFloatStr(this.getTokens()[4]) * 0.5291772f;
    }

    private void readCellParam(boolean andAPar) throws Exception {
        int i0;
        int n = i0 = andAPar ? 0 : 3;
        if (this.line.contains("bohr")) {
            this.aPar = 0.5291772f;
        }
        if (andAPar && this.line.contains("=")) {
            this.aPar = this.parseFloatStr(this.line.substring(this.line.indexOf("=") + 1)) * 0.5291772f;
        }
        this.cellParams = new float[9];
        int i = 0;
        for (int n2 = 0; n2 < 3; ++n2) {
            String[] tokens = PT.getTokens(this.rd());
            this.cellParams[i++] = this.parseFloatStr(tokens[i0]) * this.aPar;
            this.cellParams[i++] = this.parseFloatStr(tokens[i0 + 1]) * this.aPar;
            this.cellParams[i++] = this.parseFloatStr(tokens[i0 + 2]) * this.aPar;
        }
    }

    private void newAtomSet() throws Exception {
        this.asc.newAtomSet();
        if (this.totEnergy != null) {
            this.setEnergy();
        }
    }

    private void setCellParams() throws Exception {
        if (this.cellParams != null) {
            this.addExplicitLatticeVector(0, this.cellParams, 0);
            this.addExplicitLatticeVector(1, this.cellParams, 3);
            this.addExplicitLatticeVector(2, this.cellParams, 6);
            this.setSpaceGroupName("P1");
        }
    }

    private void readAtoms() throws Exception {
        this.newAtomSet();
        boolean isAlat = this.line.contains("alat") || this.line.contains("a_0");
        boolean firstStr = this.line.contains("site n.");
        boolean isFractional = this.line.contains("crystal");
        boolean isBohr = this.line.contains("bohr");
        boolean isAngstrom = this.line.contains("angstrom");
        if (isAlat || isFractional || isAngstrom) {
            this.setCellParams();
        }
        this.setFractionalCoordinates(isFractional);
        while (this.rd() != null && this.line.length() > 45) {
            String[] tokens = this.getTokens();
            Atom atom = this.asc.addNewAtom();
            atom.atomName = tokens[isBohr || tokens.length == 4 || !firstStr ? 0 : 1];
            int i1 = isBohr || tokens.length == 4 || !firstStr ? 1 : tokens.length - 4;
            float x = this.parseFloatStr(tokens[i1++]);
            float y = this.parseFloatStr(tokens[i1++]);
            float z = this.parseFloatStr(tokens[i1++]);
            atom.set(x, y, z);
            if (isBohr) {
                atom.scale(0.5291772f);
            } else if (isAlat) {
                atom.scale(this.aPar);
            }
            this.setAtomCoord(atom);
        }
        this.applySymmetryAndSetTrajectory();
        if (this.endFlag) {
            this.discardLinesUntilContains("Harris-Foulkes estimate");
        }
    }

    private void readEnergy() throws Exception {
        this.totEnergy = Double.parseDouble(PT.getTokens(this.line.substring(this.line.indexOf("=") + 1))[0]);
    }

    private void setEnergy() {
        this.asc.setAtomSetEnergy("" + this.totEnergy, this.totEnergy.floatValue());
        this.asc.setInfo("Energy", this.totEnergy);
        this.asc.setAtomSetName("E = " + this.totEnergy + " Ry");
    }
}

