/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr310.deser;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.datatype.jsr310.deser.JSR310DeserializerBase;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Locale;

public abstract class JSR310DateTimeDeserializerBase<T>
extends JSR310DeserializerBase<T>
implements ContextualDeserializer {
    protected final DateTimeFormatter _formatter;
    protected final boolean _isLenient;

    protected JSR310DateTimeDeserializerBase(Class<T> supportedType, DateTimeFormatter f) {
        super(supportedType);
        this._formatter = f;
        this._isLenient = true;
    }

    protected JSR310DateTimeDeserializerBase(JSR310DateTimeDeserializerBase<T> base2, DateTimeFormatter f) {
        super((JSR310DeserializerBase<?>)base2);
        this._formatter = f;
        this._isLenient = base2._isLenient;
    }

    protected JSR310DateTimeDeserializerBase(JSR310DateTimeDeserializerBase<T> base2, Boolean leniency) {
        super((JSR310DeserializerBase<?>)base2);
        this._formatter = base2._formatter;
        this._isLenient = !Boolean.FALSE.equals(leniency);
    }

    protected abstract JSR310DateTimeDeserializerBase<T> withDateFormat(DateTimeFormatter var1);

    protected abstract JSR310DateTimeDeserializerBase<T> withLeniency(Boolean var1);

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property2) throws JsonMappingException {
        JsonFormat.Value format = this.findFormatOverrides(ctxt, property2, this.handledType());
        JSR310DateTimeDeserializerBase<T> deser = this;
        if (format != null) {
            Boolean leniency;
            if (format.hasPattern()) {
                String pattern = format.getPattern();
                Locale locale = format.hasLocale() ? format.getLocale() : ctxt.getLocale();
                DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
                if (super.acceptCaseInsensitiveValues(ctxt, format)) {
                    builder.parseCaseInsensitive();
                }
                builder.appendPattern(pattern);
                DateTimeFormatter df = locale == null ? builder.toFormatter() : builder.toFormatter(locale);
                if (format.hasTimeZone()) {
                    df = df.withZone(format.getTimeZone().toZoneId());
                }
                deser = deser.withDateFormat(df);
            }
            if (format.hasLenient() && (leniency = format.getLenient()) != null) {
                deser = deser.withLeniency(leniency);
            }
        }
        return deser;
    }

    protected boolean isLenient() {
        return this._isLenient;
    }

    private boolean acceptCaseInsensitiveValues(DeserializationContext ctxt, JsonFormat.Value format) {
        Boolean enabled2 = format.getFeature(JsonFormat.Feature.ACCEPT_CASE_INSENSITIVE_VALUES);
        if (enabled2 == null) {
            enabled2 = ctxt.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_VALUES);
        }
        return enabled2;
    }

    protected void _throwNoNumericTimestampNeedTimeZone(JsonParser p, DeserializationContext ctxt) throws IOException {
        ctxt.reportInputMismatch(this.handledType(), "raw timestamp (%d) not allowed for `%s`: need additional information such as an offset or time-zone (see class Javadocs)", p.getNumberValue(), this.handledType().getName());
    }

    protected T _failForNotLenient(JsonParser p, DeserializationContext ctxt, JsonToken expToken) throws IOException {
        return (T)ctxt.handleUnexpectedToken(this.handledType(), expToken, p, "Cannot deserialize instance of %s out of %s token: not allowed because 'strict' mode set for property or type (enable 'lenient' handling to allow)", new Object[]{ClassUtil.nameOf(this.handledType()), p.currentToken()});
    }
}

