"use strict";

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; subClass.__proto__ = superClass; }

var Comment = require('postcss/lib/comment');

var Parser = require('postcss/lib/parser');

var NestedDeclaration = require('./nested-declaration');

var scssTokenizer = require('./scss-tokenize');

var ScssParser =
/*#__PURE__*/
function (_Parser) {
  _inheritsLoose(ScssParser, _Parser);

  function ScssParser() {
    return _Parser.apply(this, arguments) || this;
  }

  var _proto = ScssParser.prototype;

  _proto.createTokenizer = function createTokenizer() {
    this.tokenizer = scssTokenizer(this.input);
  };

  _proto.rule = function rule(tokens) {
    var withColon = false;
    var brackets = 0;
    var value = '';

    for (var _iterator = tokens, _isArray = Array.isArray(_iterator), _i = 0, _iterator = _isArray ? _iterator : _iterator[Symbol.iterator]();;) {
      var _ref;

      if (_isArray) {
        if (_i >= _iterator.length) break;
        _ref = _iterator[_i++];
      } else {
        _i = _iterator.next();
        if (_i.done) break;
        _ref = _i.value;
      }

      var _i2 = _ref;

      if (withColon) {
        if (_i2[0] !== 'comment' && _i2[0] !== '{') {
          value += _i2[1];
        }
      } else if (_i2[0] === 'space' && _i2[1].indexOf('\n') !== -1) {
        break;
      } else if (_i2[0] === '(') {
        brackets += 1;
      } else if (_i2[0] === ')') {
        brackets -= 1;
      } else if (brackets === 0 && _i2[0] === ':') {
        withColon = true;
      }
    }

    if (!withColon || value.trim() === '' || /^[a-zA-Z-:#]/.test(value)) {
      _Parser.prototype.rule.call(this, tokens);
    } else {
      tokens.pop();
      var node = new NestedDeclaration();
      this.init(node);
      var last = tokens[tokens.length - 1];

      if (last[4]) {
        node.source.end = {
          line: last[4],
          column: last[5]
        };
      } else {
        node.source.end = {
          line: last[2],
          column: last[3]
        };
      }

      while (tokens[0][0] !== 'word') {
        node.raws.before += tokens.shift()[1];
      }

      node.source.start = {
        line: tokens[0][2],
        column: tokens[0][3]
      };
      node.prop = '';

      while (tokens.length) {
        var type = tokens[0][0];

        if (type === ':' || type === 'space' || type === 'comment') {
          break;
        }

        node.prop += tokens.shift()[1];
      }

      node.raws.between = '';
      var token;

      while (tokens.length) {
        token = tokens.shift();

        if (token[0] === ':') {
          node.raws.between += token[1];
          break;
        } else {
          node.raws.between += token[1];
        }
      }

      if (node.prop[0] === '_' || node.prop[0] === '*') {
        node.raws.before += node.prop[0];
        node.prop = node.prop.slice(1);
      }

      node.raws.between += this.spacesAndCommentsFromStart(tokens);
      this.precheckMissedSemicolon(tokens);

      for (var i = tokens.length - 1; i > 0; i--) {
        token = tokens[i];

        if (token[1] === '!important') {
          node.important = true;
          var string = this.stringFrom(tokens, i);
          string = this.spacesFromEnd(tokens) + string;

          if (string !== ' !important') {
            node.raws.important = string;
          }

          break;
        } else if (token[1] === 'important') {
          var cache = tokens.slice(0);
          var str = '';

          for (var j = i; j > 0; j--) {
            var _type = cache[j][0];

            if (str.trim().indexOf('!') === 0 && _type !== 'space') {
              break;
            }

            str = cache.pop()[1] + str;
          }

          if (str.trim().indexOf('!') === 0) {
            node.important = true;
            node.raws.important = str;
            tokens = cache;
          }
        }

        if (token[0] !== 'space' && token[0] !== 'comment') {
          break;
        }
      }

      this.raw(node, 'value', tokens);

      if (node.value.indexOf(':') !== -1) {
        this.checkMissedSemicolon(tokens);
      }

      this.current = node;
    }
  };

  _proto.comment = function comment(token) {
    if (token[6] === 'inline') {
      var node = new Comment();
      this.init(node, token[2], token[3]);
      node.raws.inline = true;
      node.source.end = {
        line: token[4],
        column: token[5]
      };
      var text = token[1].slice(2);

      if (/^\s*$/.test(text)) {
        node.text = '';
        node.raws.left = text;
        node.raws.right = '';
      } else {
        var match = text.match(/^(\s*)([^]*[^\s])(\s*)$/);
        var fixed = match[2].replace(/(\*\/|\/\*)/g, '*//*');
        node.text = fixed;
        node.raws.left = match[1];
        node.raws.right = match[3];
        node.raws.text = match[2];
      }
    } else {
      _Parser.prototype.comment.call(this, token);
    }
  };

  _proto.raw = function raw(node, prop, tokens) {
    _Parser.prototype.raw.call(this, node, prop, tokens);

    if (node.raws[prop]) {
      var scss = node.raws[prop].raw;
      node.raws[prop].raw = tokens.reduce(function (all, i) {
        if (i[0] === 'comment' && i[6] === 'inline') {
          var text = i[1].slice(2).replace(/(\*\/|\/\*)/g, '*//*');
          return all + '/*' + text + '*/';
        } else {
          return all + i[1];
        }
      }, '');

      if (scss !== node.raws[prop].raw) {
        node.raws[prop].scss = scss;
      }
    }
  };

  return ScssParser;
}(Parser);

module.exports = ScssParser;
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
