// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from STM32F411.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/STMicro

// +build stm32,stm32f411

// STM32F411
//

package stm32

import (
	"runtime/interrupt"
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	DEVICE = "STM32F411"
)

// Interrupt numbers.
const (
	IRQ_PVD                = 1  // Window watchdog
	IRQ_TAMP_STAMP         = 2  // External interrupt/event controller
	IRQ_RTC_WKUP           = 3  //
	IRQ_FLASH              = 4  // FLASH
	IRQ_RCC                = 5  // DMA controller
	IRQ_EXTI0              = 6  // External interrupt/event controller
	IRQ_EXTI1              = 7  // External interrupt/event controller
	IRQ_EXTI2              = 8  // External interrupt/event controller
	IRQ_EXTI3              = 9  // External interrupt/event controller
	IRQ_EXTI4              = 10 // External interrupt/event controller
	IRQ_ADC                = 18 // Analog-to-digital converter
	IRQ_EXTI9_5            = 23 // External interrupt/event controller
	IRQ_TIM1_BRK_TIM9      = 24 //
	IRQ_TIM1_UP_TIM10      = 25 //
	IRQ_TIM1_TRG_COM_TIM11 = 26 // General-purpose I/Os //
	IRQ_TIM1_CC            = 27 //
	IRQ_TIM2               = 28 // General-purpose I/Os
	IRQ_TIM3               = 29 // Inter-integrated circuit
	IRQ_I2C1_EV            = 31 // Reset and clock control // Serial peripheral interface
	IRQ_I2C1_ER            = 32 // Reset and clock control // Serial peripheral interface
	IRQ_I2C2_EV            = 33 // Real-time clock //
	IRQ_I2C2_ER            = 34 // Real-time clock //
	IRQ_SPI1               = 35 // General-purpose-timers //
	IRQ_SPI2               = 36 // General-purpose-timers //
	IRQ_EXTI15_10          = 40 // External interrupt/event controller
	IRQ_RTC_Alarm          = 41 //
	IRQ_OTG_FS_WKUP        = 42 // Universal synchronous asynchronous receiver transmitter
	IRQ_SDIO               = 49 // General-purpose I/Os
	IRQ_SPI3               = 51 // General purpose timers //
	IRQ_OTG_FS             = 67 // Universal synchronous asynchronous receiver transmitter
	IRQ_I2C3_EV            = 72 // Secure digital input/output interface //
	IRQ_I2C3_ER            = 73 // Secure digital input/output interface //
	IRQ_FPU                = 81 // ADC common registers // Floting point unit
	IRQ_SPI4               = 84 // General purpose timers
	IRQ_max                = 84 // Highest interrupt number on this device.
)

// Map interrupt numbers to function names.
// These aren't real calls, they're removed by the compiler.
var (
	_ = interrupt.Register(IRQ_PVD, "PVD_IRQHandler")
	_ = interrupt.Register(IRQ_TAMP_STAMP, "TAMP_STAMP_IRQHandler")
	_ = interrupt.Register(IRQ_RTC_WKUP, "RTC_WKUP_IRQHandler")
	_ = interrupt.Register(IRQ_FLASH, "FLASH_IRQHandler")
	_ = interrupt.Register(IRQ_RCC, "RCC_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI0, "EXTI0_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI1, "EXTI1_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI2, "EXTI2_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI3, "EXTI3_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI4, "EXTI4_IRQHandler")
	_ = interrupt.Register(IRQ_ADC, "ADC_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI9_5, "EXTI9_5_IRQHandler")
	_ = interrupt.Register(IRQ_TIM1_BRK_TIM9, "TIM1_BRK_TIM9_IRQHandler")
	_ = interrupt.Register(IRQ_TIM1_UP_TIM10, "TIM1_UP_TIM10_IRQHandler")
	_ = interrupt.Register(IRQ_TIM1_TRG_COM_TIM11, "TIM1_TRG_COM_TIM11_IRQHandler")
	_ = interrupt.Register(IRQ_TIM1_CC, "TIM1_CC_IRQHandler")
	_ = interrupt.Register(IRQ_TIM2, "TIM2_IRQHandler")
	_ = interrupt.Register(IRQ_TIM3, "TIM3_IRQHandler")
	_ = interrupt.Register(IRQ_I2C1_EV, "I2C1_EV_IRQHandler")
	_ = interrupt.Register(IRQ_I2C1_ER, "I2C1_ER_IRQHandler")
	_ = interrupt.Register(IRQ_I2C2_EV, "I2C2_EV_IRQHandler")
	_ = interrupt.Register(IRQ_I2C2_ER, "I2C2_ER_IRQHandler")
	_ = interrupt.Register(IRQ_SPI1, "SPI1_IRQHandler")
	_ = interrupt.Register(IRQ_SPI2, "SPI2_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI15_10, "EXTI15_10_IRQHandler")
	_ = interrupt.Register(IRQ_RTC_Alarm, "RTC_Alarm_IRQHandler")
	_ = interrupt.Register(IRQ_OTG_FS_WKUP, "OTG_FS_WKUP_IRQHandler")
	_ = interrupt.Register(IRQ_SDIO, "SDIO_IRQHandler")
	_ = interrupt.Register(IRQ_SPI3, "SPI3_IRQHandler")
	_ = interrupt.Register(IRQ_OTG_FS, "OTG_FS_IRQHandler")
	_ = interrupt.Register(IRQ_I2C3_EV, "I2C3_EV_IRQHandler")
	_ = interrupt.Register(IRQ_I2C3_ER, "I2C3_ER_IRQHandler")
	_ = interrupt.Register(IRQ_FPU, "FPU_IRQHandler")
	_ = interrupt.Register(IRQ_SPI4, "SPI4_IRQHandler")
)

// Peripherals.
var (
	ADC_Common    = (*ADC_Type)(unsafe.Pointer(uintptr(0x40012300)))        // ADC common registers
	ADC1          = (*ADC_Type)(unsafe.Pointer(uintptr(0x40012000)))        // Analog-to-digital converter
	CRC           = (*CRC_Type)(unsafe.Pointer(uintptr(0x40023000)))        // Cryptographic processor
	DBG           = (*DBG_Type)(unsafe.Pointer(uintptr(0xe0042000)))        // Debug support
	EXTI          = (*EXTI_Type)(unsafe.Pointer(uintptr(0x40013c00)))       // External interrupt/event controller
	FLASH         = (*FLASH_Type)(unsafe.Pointer(uintptr(0x40023c00)))      // FLASH
	IWDG          = (*IWDG_Type)(unsafe.Pointer(uintptr(0x40003000)))       // Independent watchdog
	OTG_FS_DEVICE = (*USB_OTG_FS_Type)(unsafe.Pointer(uintptr(0x50000800))) // USB on the go full speed
	OTG_FS_GLOBAL = (*USB_OTG_FS_Type)(unsafe.Pointer(uintptr(0x50000000))) // USB on the go full speed
	OTG_FS_HOST   = (*USB_OTG_FS_Type)(unsafe.Pointer(uintptr(0x50000400))) // USB on the go full speed
	OTG_FS_PWRCLK = (*USB_OTG_FS_Type)(unsafe.Pointer(uintptr(0x50000e00))) // USB on the go full speed
	PWR           = (*PWR_Type)(unsafe.Pointer(uintptr(0x40007000)))        // Power control
	RCC           = (*RCC_Type)(unsafe.Pointer(uintptr(0x40023800)))        // Reset and clock control
	RTC           = (*RTC_Type)(unsafe.Pointer(uintptr(0x40002800)))        // Real-time clock
	SDIO          = (*SDIO_Type)(unsafe.Pointer(uintptr(0x40012c00)))       // Secure digital input/output interface
	SYSCFG        = (*SYSCFG_Type)(unsafe.Pointer(uintptr(0x40013800)))     // System configuration controller
	TIM1          = (*TIM_Type)(unsafe.Pointer(uintptr(0x40010000)))        // Advanced-timers
	TIM10         = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014400)))        // General-purpose-timers
	TIM11         = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014800)))        // General-purpose-timers
	TIM2          = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000000)))        // General purpose timers
	TIM3          = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000400)))        // General purpose timers
	TIM5          = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000c00)))        // General-purpose-timers
	TIM9          = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014000)))        // General purpose timers
	USART1        = (*USART_Type)(unsafe.Pointer(uintptr(0x40011000)))      // Universal synchronous asynchronous receiver transmitter
	WWDG          = (*WWDG_Type)(unsafe.Pointer(uintptr(0x40002c00)))       // Window watchdog
	DMA2          = (*DMA_Type)(unsafe.Pointer(uintptr(0x40026400)))        // DMA controller
	GPIOH         = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40021c00)))       // General-purpose I/Os
	GPIOB         = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40020400)))       // General-purpose I/Os
	GPIOA         = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40020000)))       // General-purpose I/Os
	I2C3          = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005c00)))        // Inter-integrated circuit
	I2S2ext       = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003400)))        // Serial peripheral interface
	NVIC          = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000e100)))       // Nested Vectored Interrupt Controller
	FPU           = (*FPU_Type)(unsafe.Pointer(uintptr(0xe000ef34)))        // Floting point unit
	MPU           = (*MPU_Type)(unsafe.Pointer(uintptr(0xe000ed90)))        // Memory protection unit
	STK           = (*STK_Type)(unsafe.Pointer(uintptr(0xe000e010)))        // SysTick timer
	SCB           = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000ed00)))        // System control block
	NVIC_STIR     = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000ef00)))       // Nested vectored interrupt controller
	FPU_CPACR     = (*FPU_Type)(unsafe.Pointer(uintptr(0xe000ed88)))        // Floating point unit CPACR
	SCB_ACTRL     = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000e008)))        // System control block ACTLR
	TIM8          = (*TIM_Type)(unsafe.Pointer(uintptr(0x40010400)))        // Advanced-timers
	TIM4          = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000800)))        // General purpose timers
	USART2        = (*USART_Type)(unsafe.Pointer(uintptr(0x40004400)))      // Universal synchronous asynchronous receiver transmitter
	USART6        = (*USART_Type)(unsafe.Pointer(uintptr(0x40011400)))      // Universal synchronous asynchronous receiver transmitter
	DMA1          = (*DMA_Type)(unsafe.Pointer(uintptr(0x40026000)))        // DMA controller
	GPIOE         = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40021000)))       // General-purpose I/Os
	GPIOD         = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40020c00)))       // General-purpose I/Os
	GPIOC         = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40020800)))       // General-purpose I/Os
	I2C2          = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005800)))        // Inter-integrated circuit
	I2C1          = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005400)))        // Inter-integrated circuit
	I2S3ext       = (*SPI_Type)(unsafe.Pointer(uintptr(0x40004000)))        // Serial peripheral interface
	SPI1          = (*SPI_Type)(unsafe.Pointer(uintptr(0x40013000)))        // Serial peripheral interface
	SPI2          = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003800)))        // Serial peripheral interface
	SPI3          = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003c00)))        // Serial peripheral interface
	SPI4          = (*SPI_Type)(unsafe.Pointer(uintptr(0x40013400)))        // Serial peripheral interface
	SPI5          = (*SPI_Type)(unsafe.Pointer(uintptr(0x40015000)))        // Serial peripheral interface
)

// ADC common registers
type ADC_Type struct {
	CSR volatile.Register32 // 0x0
	CCR volatile.Register32 // 0x4
}

// Cryptographic processor
type CRC_Type struct {
	DR  volatile.Register32 // 0x0
	IDR volatile.Register32 // 0x4
	CR  volatile.Register32 // 0x8
}

// Debug support
type DBG_Type struct {
	DBGMCU_IDCODE  volatile.Register32 // 0x0
	DBGMCU_CR      volatile.Register32 // 0x4
	DBGMCU_APB1_FZ volatile.Register32 // 0x8
	DBGMCU_APB2_FZ volatile.Register32 // 0xC
}

// External interrupt/event controller
type EXTI_Type struct {
	IMR   volatile.Register32 // 0x0
	EMR   volatile.Register32 // 0x4
	RTSR  volatile.Register32 // 0x8
	FTSR  volatile.Register32 // 0xC
	SWIER volatile.Register32 // 0x10
	PR    volatile.Register32 // 0x14
}

// FLASH
type FLASH_Type struct {
	ACR     volatile.Register32 // 0x0
	KEYR    volatile.Register32 // 0x4
	OPTKEYR volatile.Register32 // 0x8
	SR      volatile.Register32 // 0xC
	CR      volatile.Register32 // 0x10
	OPTCR   volatile.Register32 // 0x14
}

// Independent watchdog
type IWDG_Type struct {
	KR  volatile.Register32 // 0x0
	PR  volatile.Register32 // 0x4
	RLR volatile.Register32 // 0x8
	SR  volatile.Register32 // 0xC
}

// USB on the go full speed
type USB_OTG_FS_Type struct {
	FS_DCFG     volatile.Register32 // 0x0
	FS_DCTL     volatile.Register32 // 0x4
	FS_DSTS     volatile.Register32 // 0x8
	_           [4]byte
	FS_DIEPMSK  volatile.Register32 // 0x10
	FS_DOEPMSK  volatile.Register32 // 0x14
	FS_DAINT    volatile.Register32 // 0x18
	FS_DAINTMSK volatile.Register32 // 0x1C
	_           [8]byte
	DVBUSDIS    volatile.Register32 // 0x28
	DVBUSPULSE  volatile.Register32 // 0x2C
	_           [4]byte
	DIEPEMPMSK  volatile.Register32 // 0x34
	_           [200]byte
	FS_DIEPCTL0 volatile.Register32 // 0x100
	_           [4]byte
	DIEPINT0    volatile.Register32 // 0x108
	_           [4]byte
	DIEPTSIZ0   volatile.Register32 // 0x110
	_           [4]byte
	DTXFSTS0    volatile.Register32 // 0x118
	_           [4]byte
	DIEPCTL1    volatile.Register32 // 0x120
	_           [4]byte
	DIEPINT1    volatile.Register32 // 0x128
	_           [4]byte
	DIEPTSIZ1   volatile.Register32 // 0x130
	_           [4]byte
	DTXFSTS1    volatile.Register32 // 0x138
	_           [4]byte
	DIEPCTL2    volatile.Register32 // 0x140
	_           [4]byte
	DIEPINT2    volatile.Register32 // 0x148
	_           [4]byte
	DIEPTSIZ2   volatile.Register32 // 0x150
	_           [4]byte
	DTXFSTS2    volatile.Register32 // 0x158
	_           [4]byte
	DIEPCTL3    volatile.Register32 // 0x160
	_           [4]byte
	DIEPINT3    volatile.Register32 // 0x168
	_           [4]byte
	DIEPTSIZ3   volatile.Register32 // 0x170
	_           [4]byte
	DTXFSTS3    volatile.Register32 // 0x178
	_           [388]byte
	DOEPCTL0    volatile.Register32 // 0x300
	_           [4]byte
	DOEPINT0    volatile.Register32 // 0x308
	_           [4]byte
	DOEPTSIZ0   volatile.Register32 // 0x310
	_           [12]byte
	DOEPCTL1    volatile.Register32 // 0x320
	_           [4]byte
	DOEPINT1    volatile.Register32 // 0x328
	_           [4]byte
	DOEPTSIZ1   volatile.Register32 // 0x330
	_           [12]byte
	DOEPCTL2    volatile.Register32 // 0x340
	_           [4]byte
	DOEPINT2    volatile.Register32 // 0x348
	_           [4]byte
	DOEPTSIZ2   volatile.Register32 // 0x350
	_           [12]byte
	DOEPCTL3    volatile.Register32 // 0x360
	_           [4]byte
	DOEPINT3    volatile.Register32 // 0x368
	_           [4]byte
	DOEPTSIZ3   volatile.Register32 // 0x370
}

// Power control
type PWR_Type struct {
	CR  volatile.Register32 // 0x0
	CSR volatile.Register32 // 0x4
}

// Reset and clock control
type RCC_Type struct {
	CR         volatile.Register32 // 0x0
	PLLCFGR    volatile.Register32 // 0x4
	CFGR       volatile.Register32 // 0x8
	CIR        volatile.Register32 // 0xC
	AHB1RSTR   volatile.Register32 // 0x10
	AHB2RSTR   volatile.Register32 // 0x14
	_          [8]byte
	APB1RSTR   volatile.Register32 // 0x20
	APB2RSTR   volatile.Register32 // 0x24
	_          [8]byte
	AHB1ENR    volatile.Register32 // 0x30
	AHB2ENR    volatile.Register32 // 0x34
	_          [8]byte
	APB1ENR    volatile.Register32 // 0x40
	APB2ENR    volatile.Register32 // 0x44
	_          [8]byte
	AHB1LPENR  volatile.Register32 // 0x50
	AHB2LPENR  volatile.Register32 // 0x54
	_          [8]byte
	APB1LPENR  volatile.Register32 // 0x60
	APB2LPENR  volatile.Register32 // 0x64
	_          [8]byte
	BDCR       volatile.Register32 // 0x70
	CSR        volatile.Register32 // 0x74
	_          [8]byte
	SSCGR      volatile.Register32 // 0x80
	PLLI2SCFGR volatile.Register32 // 0x84
}

// Real-time clock
type RTC_Type struct {
	TR       volatile.Register32 // 0x0
	DR       volatile.Register32 // 0x4
	CR       volatile.Register32 // 0x8
	ISR      volatile.Register32 // 0xC
	PRER     volatile.Register32 // 0x10
	WUTR     volatile.Register32 // 0x14
	CALIBR   volatile.Register32 // 0x18
	ALRMAR   volatile.Register32 // 0x1C
	ALRMBR   volatile.Register32 // 0x20
	WPR      volatile.Register32 // 0x24
	SSR      volatile.Register32 // 0x28
	SHIFTR   volatile.Register32 // 0x2C
	TSTR     volatile.Register32 // 0x30
	TSDR     volatile.Register32 // 0x34
	TSSSR    volatile.Register32 // 0x38
	CALR     volatile.Register32 // 0x3C
	TAFCR    volatile.Register32 // 0x40
	ALRMASSR volatile.Register32 // 0x44
	ALRMBSSR volatile.Register32 // 0x48
	_        [4]byte
	BKP0R    volatile.Register32 // 0x50
	BKP1R    volatile.Register32 // 0x54
	BKP2R    volatile.Register32 // 0x58
	BKP3R    volatile.Register32 // 0x5C
	BKP4R    volatile.Register32 // 0x60
	BKP5R    volatile.Register32 // 0x64
	BKP6R    volatile.Register32 // 0x68
	BKP7R    volatile.Register32 // 0x6C
	BKP8R    volatile.Register32 // 0x70
	BKP9R    volatile.Register32 // 0x74
	BKP10R   volatile.Register32 // 0x78
	BKP11R   volatile.Register32 // 0x7C
	BKP12R   volatile.Register32 // 0x80
	BKP13R   volatile.Register32 // 0x84
	BKP14R   volatile.Register32 // 0x88
	BKP15R   volatile.Register32 // 0x8C
	BKP16R   volatile.Register32 // 0x90
	BKP17R   volatile.Register32 // 0x94
	BKP18R   volatile.Register32 // 0x98
	BKP19R   volatile.Register32 // 0x9C
}

// Secure digital input/output interface
type SDIO_Type struct {
	POWER   volatile.Register32 // 0x0
	CLKCR   volatile.Register32 // 0x4
	ARG     volatile.Register32 // 0x8
	CMD     volatile.Register32 // 0xC
	RESPCMD volatile.Register32 // 0x10
	RESP1   volatile.Register32 // 0x14
	RESP2   volatile.Register32 // 0x18
	RESP3   volatile.Register32 // 0x1C
	RESP4   volatile.Register32 // 0x20
	DTIMER  volatile.Register32 // 0x24
	DLEN    volatile.Register32 // 0x28
	DCTRL   volatile.Register32 // 0x2C
	DCOUNT  volatile.Register32 // 0x30
	STA     volatile.Register32 // 0x34
	ICR     volatile.Register32 // 0x38
	MASK    volatile.Register32 // 0x3C
	_       [8]byte
	FIFOCNT volatile.Register32 // 0x48
	_       [52]byte
	FIFO    volatile.Register32 // 0x80
}

// System configuration controller
type SYSCFG_Type struct {
	MEMRM   volatile.Register32 // 0x0
	PMC     volatile.Register32 // 0x4
	EXTICR1 volatile.Register32 // 0x8
	EXTICR2 volatile.Register32 // 0xC
	EXTICR3 volatile.Register32 // 0x10
	EXTICR4 volatile.Register32 // 0x14
	_       [8]byte
	CMPCR   volatile.Register32 // 0x20
}

// Advanced-timers
type TIM_Type struct {
	CR1          volatile.Register32 // 0x0
	CR2          volatile.Register32 // 0x4
	SMCR         volatile.Register32 // 0x8
	DIER         volatile.Register32 // 0xC
	SR           volatile.Register32 // 0x10
	EGR          volatile.Register32 // 0x14
	CCMR1_Output volatile.Register32 // 0x18
	CCMR2_Output volatile.Register32 // 0x1C
	CCER         volatile.Register32 // 0x20
	CNT          volatile.Register32 // 0x24
	PSC          volatile.Register32 // 0x28
	ARR          volatile.Register32 // 0x2C
	RCR          volatile.Register32 // 0x30
	CCR1         volatile.Register32 // 0x34
	CCR2         volatile.Register32 // 0x38
	CCR3         volatile.Register32 // 0x3C
	CCR4         volatile.Register32 // 0x40
	BDTR         volatile.Register32 // 0x44
	DCR          volatile.Register32 // 0x48
	DMAR         volatile.Register32 // 0x4C
}

// Universal synchronous asynchronous receiver transmitter
type USART_Type struct {
	SR   volatile.Register32 // 0x0
	DR   volatile.Register32 // 0x4
	BRR  volatile.Register32 // 0x8
	CR1  volatile.Register32 // 0xC
	CR2  volatile.Register32 // 0x10
	CR3  volatile.Register32 // 0x14
	GTPR volatile.Register32 // 0x18
}

// Window watchdog
type WWDG_Type struct {
	CR  volatile.Register32 // 0x0
	CFR volatile.Register32 // 0x4
	SR  volatile.Register32 // 0x8
}

// DMA controller
type DMA_Type struct {
	LISR   volatile.Register32 // 0x0
	HISR   volatile.Register32 // 0x4
	LIFCR  volatile.Register32 // 0x8
	HIFCR  volatile.Register32 // 0xC
	S0CR   volatile.Register32 // 0x10
	S0NDTR volatile.Register32 // 0x14
	S0PAR  volatile.Register32 // 0x18
	S0M0AR volatile.Register32 // 0x1C
	S0M1AR volatile.Register32 // 0x20
	S0FCR  volatile.Register32 // 0x24
	S1CR   volatile.Register32 // 0x28
	S1NDTR volatile.Register32 // 0x2C
	S1PAR  volatile.Register32 // 0x30
	S1M0AR volatile.Register32 // 0x34
	S1M1AR volatile.Register32 // 0x38
	S1FCR  volatile.Register32 // 0x3C
	S2CR   volatile.Register32 // 0x40
	S2NDTR volatile.Register32 // 0x44
	S2PAR  volatile.Register32 // 0x48
	S2M0AR volatile.Register32 // 0x4C
	S2M1AR volatile.Register32 // 0x50
	S2FCR  volatile.Register32 // 0x54
	S3CR   volatile.Register32 // 0x58
	S3NDTR volatile.Register32 // 0x5C
	S3PAR  volatile.Register32 // 0x60
	S3M0AR volatile.Register32 // 0x64
	S3M1AR volatile.Register32 // 0x68
	S3FCR  volatile.Register32 // 0x6C
	S4CR   volatile.Register32 // 0x70
	S4NDTR volatile.Register32 // 0x74
	S4PAR  volatile.Register32 // 0x78
	S4M0AR volatile.Register32 // 0x7C
	S4M1AR volatile.Register32 // 0x80
	S4FCR  volatile.Register32 // 0x84
	S5CR   volatile.Register32 // 0x88
	S5NDTR volatile.Register32 // 0x8C
	S5PAR  volatile.Register32 // 0x90
	S5M0AR volatile.Register32 // 0x94
	S5M1AR volatile.Register32 // 0x98
	S5FCR  volatile.Register32 // 0x9C
	S6CR   volatile.Register32 // 0xA0
	S6NDTR volatile.Register32 // 0xA4
	S6PAR  volatile.Register32 // 0xA8
	S6M0AR volatile.Register32 // 0xAC
	S6M1AR volatile.Register32 // 0xB0
	S6FCR  volatile.Register32 // 0xB4
	S7CR   volatile.Register32 // 0xB8
	S7NDTR volatile.Register32 // 0xBC
	S7PAR  volatile.Register32 // 0xC0
	S7M0AR volatile.Register32 // 0xC4
	S7M1AR volatile.Register32 // 0xC8
	S7FCR  volatile.Register32 // 0xCC
}

// General-purpose I/Os
type GPIO_Type struct {
	MODER   volatile.Register32 // 0x0
	OTYPER  volatile.Register32 // 0x4
	OSPEEDR volatile.Register32 // 0x8
	PUPDR   volatile.Register32 // 0xC
	IDR     volatile.Register32 // 0x10
	ODR     volatile.Register32 // 0x14
	BSRR    volatile.Register32 // 0x18
	LCKR    volatile.Register32 // 0x1C
	AFRL    volatile.Register32 // 0x20
	AFRH    volatile.Register32 // 0x24
}

// Inter-integrated circuit
type I2C_Type struct {
	CR1   volatile.Register32 // 0x0
	CR2   volatile.Register32 // 0x4
	OAR1  volatile.Register32 // 0x8
	OAR2  volatile.Register32 // 0xC
	DR    volatile.Register32 // 0x10
	SR1   volatile.Register32 // 0x14
	SR2   volatile.Register32 // 0x18
	CCR   volatile.Register32 // 0x1C
	TRISE volatile.Register32 // 0x20
}

// Serial peripheral interface
type SPI_Type struct {
	CR1     volatile.Register32 // 0x0
	CR2     volatile.Register32 // 0x4
	SR      volatile.Register32 // 0x8
	DR      volatile.Register32 // 0xC
	CRCPR   volatile.Register32 // 0x10
	RXCRCR  volatile.Register32 // 0x14
	TXCRCR  volatile.Register32 // 0x18
	I2SCFGR volatile.Register32 // 0x1C
	I2SPR   volatile.Register32 // 0x20
}

// Nested Vectored Interrupt Controller
type NVIC_Type struct {
	ISER0 volatile.Register32 // 0x0
	ISER1 volatile.Register32 // 0x4
	ISER2 volatile.Register32 // 0x8
	_     [116]byte
	ICER0 volatile.Register32 // 0x80
	ICER1 volatile.Register32 // 0x84
	ICER2 volatile.Register32 // 0x88
	_     [116]byte
	ISPR0 volatile.Register32 // 0x100
	ISPR1 volatile.Register32 // 0x104
	ISPR2 volatile.Register32 // 0x108
	_     [116]byte
	ICPR0 volatile.Register32 // 0x180
	ICPR1 volatile.Register32 // 0x184
	ICPR2 volatile.Register32 // 0x188
	_     [116]byte
	IABR0 volatile.Register32 // 0x200
	IABR1 volatile.Register32 // 0x204
	IABR2 volatile.Register32 // 0x208
	_     [244]byte
	IPR0  volatile.Register32 // 0x300
	IPR1  volatile.Register32 // 0x304
	IPR2  volatile.Register32 // 0x308
	IPR3  volatile.Register32 // 0x30C
	IPR4  volatile.Register32 // 0x310
	IPR5  volatile.Register32 // 0x314
	IPR6  volatile.Register32 // 0x318
	IPR7  volatile.Register32 // 0x31C
	IPR8  volatile.Register32 // 0x320
	IPR9  volatile.Register32 // 0x324
	IPR10 volatile.Register32 // 0x328
	IPR11 volatile.Register32 // 0x32C
	IPR12 volatile.Register32 // 0x330
	IPR13 volatile.Register32 // 0x334
	IPR14 volatile.Register32 // 0x338
	IPR15 volatile.Register32 // 0x33C
	IPR16 volatile.Register32 // 0x340
	IPR17 volatile.Register32 // 0x344
	IPR18 volatile.Register32 // 0x348
	IPR19 volatile.Register32 // 0x34C
}

// Floting point unit
type FPU_Type struct {
	FPCCR volatile.Register32 // 0x0
	FPCAR volatile.Register32 // 0x4
	FPSCR volatile.Register32 // 0x8
}

// Memory protection unit
type MPU_Type struct {
	MPU_TYPER volatile.Register32 // 0x0
	MPU_CTRL  volatile.Register32 // 0x4
	MPU_RNR   volatile.Register32 // 0x8
	MPU_RBAR  volatile.Register32 // 0xC
	MPU_RASR  volatile.Register32 // 0x10
}

// SysTick timer
type STK_Type struct {
	CTRL  volatile.Register32 // 0x0
	LOAD  volatile.Register32 // 0x4
	VAL   volatile.Register32 // 0x8
	CALIB volatile.Register32 // 0xC
}

// System control block
type SCB_Type struct {
	CPUID                volatile.Register32 // 0x0
	ICSR                 volatile.Register32 // 0x4
	VTOR                 volatile.Register32 // 0x8
	AIRCR                volatile.Register32 // 0xC
	SCR                  volatile.Register32 // 0x10
	CCR                  volatile.Register32 // 0x14
	SHPR1                volatile.Register32 // 0x18
	SHPR2                volatile.Register32 // 0x1C
	SHPR3                volatile.Register32 // 0x20
	SHCRS                volatile.Register32 // 0x24
	CFSR_UFSR_BFSR_MMFSR volatile.Register32 // 0x28
	HFSR                 volatile.Register32 // 0x2C
	_                    [4]byte
	MMFAR                volatile.Register32 // 0x34
	BFAR                 volatile.Register32 // 0x38
	AFSR                 volatile.Register32 // 0x3C
}

// Bitfields for ADC_Common: ADC common registers
const (
	// CSR: ADC Common status register
	ADC_CSR_OVR3_Pos   = 0x15     // Position of OVR3 field.
	ADC_CSR_OVR3_Msk   = 0x200000 // Bit mask of OVR3 field.
	ADC_CSR_OVR3       = 0x200000 // Bit OVR3.
	ADC_CSR_STRT3_Pos  = 0x14     // Position of STRT3 field.
	ADC_CSR_STRT3_Msk  = 0x100000 // Bit mask of STRT3 field.
	ADC_CSR_STRT3      = 0x100000 // Bit STRT3.
	ADC_CSR_JSTRT3_Pos = 0x13     // Position of JSTRT3 field.
	ADC_CSR_JSTRT3_Msk = 0x80000  // Bit mask of JSTRT3 field.
	ADC_CSR_JSTRT3     = 0x80000  // Bit JSTRT3.
	ADC_CSR_JEOC3_Pos  = 0x12     // Position of JEOC3 field.
	ADC_CSR_JEOC3_Msk  = 0x40000  // Bit mask of JEOC3 field.
	ADC_CSR_JEOC3      = 0x40000  // Bit JEOC3.
	ADC_CSR_EOC3_Pos   = 0x11     // Position of EOC3 field.
	ADC_CSR_EOC3_Msk   = 0x20000  // Bit mask of EOC3 field.
	ADC_CSR_EOC3       = 0x20000  // Bit EOC3.
	ADC_CSR_AWD3_Pos   = 0x10     // Position of AWD3 field.
	ADC_CSR_AWD3_Msk   = 0x10000  // Bit mask of AWD3 field.
	ADC_CSR_AWD3       = 0x10000  // Bit AWD3.
	ADC_CSR_OVR2_Pos   = 0xd      // Position of OVR2 field.
	ADC_CSR_OVR2_Msk   = 0x2000   // Bit mask of OVR2 field.
	ADC_CSR_OVR2       = 0x2000   // Bit OVR2.
	ADC_CSR_STRT2_Pos  = 0xc      // Position of STRT2 field.
	ADC_CSR_STRT2_Msk  = 0x1000   // Bit mask of STRT2 field.
	ADC_CSR_STRT2      = 0x1000   // Bit STRT2.
	ADC_CSR_JSTRT2_Pos = 0xb      // Position of JSTRT2 field.
	ADC_CSR_JSTRT2_Msk = 0x800    // Bit mask of JSTRT2 field.
	ADC_CSR_JSTRT2     = 0x800    // Bit JSTRT2.
	ADC_CSR_JEOC2_Pos  = 0xa      // Position of JEOC2 field.
	ADC_CSR_JEOC2_Msk  = 0x400    // Bit mask of JEOC2 field.
	ADC_CSR_JEOC2      = 0x400    // Bit JEOC2.
	ADC_CSR_EOC2_Pos   = 0x9      // Position of EOC2 field.
	ADC_CSR_EOC2_Msk   = 0x200    // Bit mask of EOC2 field.
	ADC_CSR_EOC2       = 0x200    // Bit EOC2.
	ADC_CSR_AWD2_Pos   = 0x8      // Position of AWD2 field.
	ADC_CSR_AWD2_Msk   = 0x100    // Bit mask of AWD2 field.
	ADC_CSR_AWD2       = 0x100    // Bit AWD2.
	ADC_CSR_OVR1_Pos   = 0x5      // Position of OVR1 field.
	ADC_CSR_OVR1_Msk   = 0x20     // Bit mask of OVR1 field.
	ADC_CSR_OVR1       = 0x20     // Bit OVR1.
	ADC_CSR_STRT1_Pos  = 0x4      // Position of STRT1 field.
	ADC_CSR_STRT1_Msk  = 0x10     // Bit mask of STRT1 field.
	ADC_CSR_STRT1      = 0x10     // Bit STRT1.
	ADC_CSR_JSTRT1_Pos = 0x3      // Position of JSTRT1 field.
	ADC_CSR_JSTRT1_Msk = 0x8      // Bit mask of JSTRT1 field.
	ADC_CSR_JSTRT1     = 0x8      // Bit JSTRT1.
	ADC_CSR_JEOC1_Pos  = 0x2      // Position of JEOC1 field.
	ADC_CSR_JEOC1_Msk  = 0x4      // Bit mask of JEOC1 field.
	ADC_CSR_JEOC1      = 0x4      // Bit JEOC1.
	ADC_CSR_EOC1_Pos   = 0x1      // Position of EOC1 field.
	ADC_CSR_EOC1_Msk   = 0x2      // Bit mask of EOC1 field.
	ADC_CSR_EOC1       = 0x2      // Bit EOC1.
	ADC_CSR_AWD1_Pos   = 0x0      // Position of AWD1 field.
	ADC_CSR_AWD1_Msk   = 0x1      // Bit mask of AWD1 field.
	ADC_CSR_AWD1       = 0x1      // Bit AWD1.

	// CCR: ADC common control register
	ADC_CCR_TSVREFE_Pos = 0x17     // Position of TSVREFE field.
	ADC_CCR_TSVREFE_Msk = 0x800000 // Bit mask of TSVREFE field.
	ADC_CCR_TSVREFE     = 0x800000 // Bit TSVREFE.
	ADC_CCR_VBATE_Pos   = 0x16     // Position of VBATE field.
	ADC_CCR_VBATE_Msk   = 0x400000 // Bit mask of VBATE field.
	ADC_CCR_VBATE       = 0x400000 // Bit VBATE.
	ADC_CCR_ADCPRE_Pos  = 0x10     // Position of ADCPRE field.
	ADC_CCR_ADCPRE_Msk  = 0x30000  // Bit mask of ADCPRE field.
	ADC_CCR_DMA_Pos     = 0xe      // Position of DMA field.
	ADC_CCR_DMA_Msk     = 0xc000   // Bit mask of DMA field.
	ADC_CCR_DDS_Pos     = 0xd      // Position of DDS field.
	ADC_CCR_DDS_Msk     = 0x2000   // Bit mask of DDS field.
	ADC_CCR_DDS         = 0x2000   // Bit DDS.
	ADC_CCR_DELAY_Pos   = 0x8      // Position of DELAY field.
	ADC_CCR_DELAY_Msk   = 0xf00    // Bit mask of DELAY field.
)

// Bitfields for CRC: Cryptographic processor
const (
	// DR: Data register
	CRC_DR_DR_Pos = 0x0        // Position of DR field.
	CRC_DR_DR_Msk = 0xffffffff // Bit mask of DR field.

	// IDR: Independent Data register
	CRC_IDR_IDR_Pos = 0x0  // Position of IDR field.
	CRC_IDR_IDR_Msk = 0xff // Bit mask of IDR field.

	// CR: Control register
	CRC_CR_CR_Pos = 0x0 // Position of CR field.
	CRC_CR_CR_Msk = 0x1 // Bit mask of CR field.
	CRC_CR_CR     = 0x1 // Bit CR.
)

// Bitfields for DBG: Debug support
const (
	// DBGMCU_IDCODE: IDCODE
	DBG_DBGMCU_IDCODE_DEV_ID_Pos = 0x0        // Position of DEV_ID field.
	DBG_DBGMCU_IDCODE_DEV_ID_Msk = 0xfff      // Bit mask of DEV_ID field.
	DBG_DBGMCU_IDCODE_REV_ID_Pos = 0x10       // Position of REV_ID field.
	DBG_DBGMCU_IDCODE_REV_ID_Msk = 0xffff0000 // Bit mask of REV_ID field.

	// DBGMCU_CR: Control Register
	DBG_DBGMCU_CR_DBG_SLEEP_Pos   = 0x0  // Position of DBG_SLEEP field.
	DBG_DBGMCU_CR_DBG_SLEEP_Msk   = 0x1  // Bit mask of DBG_SLEEP field.
	DBG_DBGMCU_CR_DBG_SLEEP       = 0x1  // Bit DBG_SLEEP.
	DBG_DBGMCU_CR_DBG_STOP_Pos    = 0x1  // Position of DBG_STOP field.
	DBG_DBGMCU_CR_DBG_STOP_Msk    = 0x2  // Bit mask of DBG_STOP field.
	DBG_DBGMCU_CR_DBG_STOP        = 0x2  // Bit DBG_STOP.
	DBG_DBGMCU_CR_DBG_STANDBY_Pos = 0x2  // Position of DBG_STANDBY field.
	DBG_DBGMCU_CR_DBG_STANDBY_Msk = 0x4  // Bit mask of DBG_STANDBY field.
	DBG_DBGMCU_CR_DBG_STANDBY     = 0x4  // Bit DBG_STANDBY.
	DBG_DBGMCU_CR_TRACE_IOEN_Pos  = 0x5  // Position of TRACE_IOEN field.
	DBG_DBGMCU_CR_TRACE_IOEN_Msk  = 0x20 // Bit mask of TRACE_IOEN field.
	DBG_DBGMCU_CR_TRACE_IOEN      = 0x20 // Bit TRACE_IOEN.
	DBG_DBGMCU_CR_TRACE_MODE_Pos  = 0x6  // Position of TRACE_MODE field.
	DBG_DBGMCU_CR_TRACE_MODE_Msk  = 0xc0 // Bit mask of TRACE_MODE field.

	// DBGMCU_APB1_FZ: Debug MCU APB1 Freeze registe
	DBG_DBGMCU_APB1_FZ_DBG_TIM2_STOP_Pos          = 0x0      // Position of DBG_TIM2_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_TIM2_STOP_Msk          = 0x1      // Bit mask of DBG_TIM2_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_TIM2_STOP              = 0x1      // Bit DBG_TIM2_STOP.
	DBG_DBGMCU_APB1_FZ_DBG_TIM3_STOP_Pos          = 0x1      // Position of DBG_TIM3_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_TIM3_STOP_Msk          = 0x2      // Bit mask of DBG_TIM3_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_TIM3_STOP              = 0x2      // Bit DBG_TIM3_STOP.
	DBG_DBGMCU_APB1_FZ_DBG_TIM4_STOP_Pos          = 0x2      // Position of DBG_TIM4_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_TIM4_STOP_Msk          = 0x4      // Bit mask of DBG_TIM4_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_TIM4_STOP              = 0x4      // Bit DBG_TIM4_STOP.
	DBG_DBGMCU_APB1_FZ_DBG_TIM5_STOP_Pos          = 0x3      // Position of DBG_TIM5_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_TIM5_STOP_Msk          = 0x8      // Bit mask of DBG_TIM5_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_TIM5_STOP              = 0x8      // Bit DBG_TIM5_STOP.
	DBG_DBGMCU_APB1_FZ_DBG_RTC_Stop_Pos           = 0xa      // Position of DBG_RTC_Stop field.
	DBG_DBGMCU_APB1_FZ_DBG_RTC_Stop_Msk           = 0x400    // Bit mask of DBG_RTC_Stop field.
	DBG_DBGMCU_APB1_FZ_DBG_RTC_Stop               = 0x400    // Bit DBG_RTC_Stop.
	DBG_DBGMCU_APB1_FZ_DBG_WWDG_STOP_Pos          = 0xb      // Position of DBG_WWDG_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_WWDG_STOP_Msk          = 0x800    // Bit mask of DBG_WWDG_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_WWDG_STOP              = 0x800    // Bit DBG_WWDG_STOP.
	DBG_DBGMCU_APB1_FZ_DBG_IWDEG_STOP_Pos         = 0xc      // Position of DBG_IWDEG_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_IWDEG_STOP_Msk         = 0x1000   // Bit mask of DBG_IWDEG_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_IWDEG_STOP             = 0x1000   // Bit DBG_IWDEG_STOP.
	DBG_DBGMCU_APB1_FZ_DBG_I2C1_SMBUS_TIMEOUT_Pos = 0x15     // Position of DBG_I2C1_SMBUS_TIMEOUT field.
	DBG_DBGMCU_APB1_FZ_DBG_I2C1_SMBUS_TIMEOUT_Msk = 0x200000 // Bit mask of DBG_I2C1_SMBUS_TIMEOUT field.
	DBG_DBGMCU_APB1_FZ_DBG_I2C1_SMBUS_TIMEOUT     = 0x200000 // Bit DBG_I2C1_SMBUS_TIMEOUT.
	DBG_DBGMCU_APB1_FZ_DBG_I2C2_SMBUS_TIMEOUT_Pos = 0x16     // Position of DBG_I2C2_SMBUS_TIMEOUT field.
	DBG_DBGMCU_APB1_FZ_DBG_I2C2_SMBUS_TIMEOUT_Msk = 0x400000 // Bit mask of DBG_I2C2_SMBUS_TIMEOUT field.
	DBG_DBGMCU_APB1_FZ_DBG_I2C2_SMBUS_TIMEOUT     = 0x400000 // Bit DBG_I2C2_SMBUS_TIMEOUT.
	DBG_DBGMCU_APB1_FZ_DBG_I2C3SMBUS_TIMEOUT_Pos  = 0x17     // Position of DBG_I2C3SMBUS_TIMEOUT field.
	DBG_DBGMCU_APB1_FZ_DBG_I2C3SMBUS_TIMEOUT_Msk  = 0x800000 // Bit mask of DBG_I2C3SMBUS_TIMEOUT field.
	DBG_DBGMCU_APB1_FZ_DBG_I2C3SMBUS_TIMEOUT      = 0x800000 // Bit DBG_I2C3SMBUS_TIMEOUT.

	// DBGMCU_APB2_FZ: Debug MCU APB2 Freeze registe
	DBG_DBGMCU_APB2_FZ_DBG_TIM1_STOP_Pos  = 0x0     // Position of DBG_TIM1_STOP field.
	DBG_DBGMCU_APB2_FZ_DBG_TIM1_STOP_Msk  = 0x1     // Bit mask of DBG_TIM1_STOP field.
	DBG_DBGMCU_APB2_FZ_DBG_TIM1_STOP      = 0x1     // Bit DBG_TIM1_STOP.
	DBG_DBGMCU_APB2_FZ_DBG_TIM9_STOP_Pos  = 0x10    // Position of DBG_TIM9_STOP field.
	DBG_DBGMCU_APB2_FZ_DBG_TIM9_STOP_Msk  = 0x10000 // Bit mask of DBG_TIM9_STOP field.
	DBG_DBGMCU_APB2_FZ_DBG_TIM9_STOP      = 0x10000 // Bit DBG_TIM9_STOP.
	DBG_DBGMCU_APB2_FZ_DBG_TIM10_STOP_Pos = 0x11    // Position of DBG_TIM10_STOP field.
	DBG_DBGMCU_APB2_FZ_DBG_TIM10_STOP_Msk = 0x20000 // Bit mask of DBG_TIM10_STOP field.
	DBG_DBGMCU_APB2_FZ_DBG_TIM10_STOP     = 0x20000 // Bit DBG_TIM10_STOP.
	DBG_DBGMCU_APB2_FZ_DBG_TIM11_STOP_Pos = 0x12    // Position of DBG_TIM11_STOP field.
	DBG_DBGMCU_APB2_FZ_DBG_TIM11_STOP_Msk = 0x40000 // Bit mask of DBG_TIM11_STOP field.
	DBG_DBGMCU_APB2_FZ_DBG_TIM11_STOP     = 0x40000 // Bit DBG_TIM11_STOP.
)

// Bitfields for EXTI: External interrupt/event controller
const (
	// IMR: Interrupt mask register           (EXTI_IMR)
	EXTI_IMR_MR0_Pos  = 0x0      // Position of MR0 field.
	EXTI_IMR_MR0_Msk  = 0x1      // Bit mask of MR0 field.
	EXTI_IMR_MR0      = 0x1      // Bit MR0.
	EXTI_IMR_MR1_Pos  = 0x1      // Position of MR1 field.
	EXTI_IMR_MR1_Msk  = 0x2      // Bit mask of MR1 field.
	EXTI_IMR_MR1      = 0x2      // Bit MR1.
	EXTI_IMR_MR2_Pos  = 0x2      // Position of MR2 field.
	EXTI_IMR_MR2_Msk  = 0x4      // Bit mask of MR2 field.
	EXTI_IMR_MR2      = 0x4      // Bit MR2.
	EXTI_IMR_MR3_Pos  = 0x3      // Position of MR3 field.
	EXTI_IMR_MR3_Msk  = 0x8      // Bit mask of MR3 field.
	EXTI_IMR_MR3      = 0x8      // Bit MR3.
	EXTI_IMR_MR4_Pos  = 0x4      // Position of MR4 field.
	EXTI_IMR_MR4_Msk  = 0x10     // Bit mask of MR4 field.
	EXTI_IMR_MR4      = 0x10     // Bit MR4.
	EXTI_IMR_MR5_Pos  = 0x5      // Position of MR5 field.
	EXTI_IMR_MR5_Msk  = 0x20     // Bit mask of MR5 field.
	EXTI_IMR_MR5      = 0x20     // Bit MR5.
	EXTI_IMR_MR6_Pos  = 0x6      // Position of MR6 field.
	EXTI_IMR_MR6_Msk  = 0x40     // Bit mask of MR6 field.
	EXTI_IMR_MR6      = 0x40     // Bit MR6.
	EXTI_IMR_MR7_Pos  = 0x7      // Position of MR7 field.
	EXTI_IMR_MR7_Msk  = 0x80     // Bit mask of MR7 field.
	EXTI_IMR_MR7      = 0x80     // Bit MR7.
	EXTI_IMR_MR8_Pos  = 0x8      // Position of MR8 field.
	EXTI_IMR_MR8_Msk  = 0x100    // Bit mask of MR8 field.
	EXTI_IMR_MR8      = 0x100    // Bit MR8.
	EXTI_IMR_MR9_Pos  = 0x9      // Position of MR9 field.
	EXTI_IMR_MR9_Msk  = 0x200    // Bit mask of MR9 field.
	EXTI_IMR_MR9      = 0x200    // Bit MR9.
	EXTI_IMR_MR10_Pos = 0xa      // Position of MR10 field.
	EXTI_IMR_MR10_Msk = 0x400    // Bit mask of MR10 field.
	EXTI_IMR_MR10     = 0x400    // Bit MR10.
	EXTI_IMR_MR11_Pos = 0xb      // Position of MR11 field.
	EXTI_IMR_MR11_Msk = 0x800    // Bit mask of MR11 field.
	EXTI_IMR_MR11     = 0x800    // Bit MR11.
	EXTI_IMR_MR12_Pos = 0xc      // Position of MR12 field.
	EXTI_IMR_MR12_Msk = 0x1000   // Bit mask of MR12 field.
	EXTI_IMR_MR12     = 0x1000   // Bit MR12.
	EXTI_IMR_MR13_Pos = 0xd      // Position of MR13 field.
	EXTI_IMR_MR13_Msk = 0x2000   // Bit mask of MR13 field.
	EXTI_IMR_MR13     = 0x2000   // Bit MR13.
	EXTI_IMR_MR14_Pos = 0xe      // Position of MR14 field.
	EXTI_IMR_MR14_Msk = 0x4000   // Bit mask of MR14 field.
	EXTI_IMR_MR14     = 0x4000   // Bit MR14.
	EXTI_IMR_MR15_Pos = 0xf      // Position of MR15 field.
	EXTI_IMR_MR15_Msk = 0x8000   // Bit mask of MR15 field.
	EXTI_IMR_MR15     = 0x8000   // Bit MR15.
	EXTI_IMR_MR16_Pos = 0x10     // Position of MR16 field.
	EXTI_IMR_MR16_Msk = 0x10000  // Bit mask of MR16 field.
	EXTI_IMR_MR16     = 0x10000  // Bit MR16.
	EXTI_IMR_MR17_Pos = 0x11     // Position of MR17 field.
	EXTI_IMR_MR17_Msk = 0x20000  // Bit mask of MR17 field.
	EXTI_IMR_MR17     = 0x20000  // Bit MR17.
	EXTI_IMR_MR18_Pos = 0x12     // Position of MR18 field.
	EXTI_IMR_MR18_Msk = 0x40000  // Bit mask of MR18 field.
	EXTI_IMR_MR18     = 0x40000  // Bit MR18.
	EXTI_IMR_MR19_Pos = 0x13     // Position of MR19 field.
	EXTI_IMR_MR19_Msk = 0x80000  // Bit mask of MR19 field.
	EXTI_IMR_MR19     = 0x80000  // Bit MR19.
	EXTI_IMR_MR20_Pos = 0x14     // Position of MR20 field.
	EXTI_IMR_MR20_Msk = 0x100000 // Bit mask of MR20 field.
	EXTI_IMR_MR20     = 0x100000 // Bit MR20.
	EXTI_IMR_MR21_Pos = 0x15     // Position of MR21 field.
	EXTI_IMR_MR21_Msk = 0x200000 // Bit mask of MR21 field.
	EXTI_IMR_MR21     = 0x200000 // Bit MR21.
	EXTI_IMR_MR22_Pos = 0x16     // Position of MR22 field.
	EXTI_IMR_MR22_Msk = 0x400000 // Bit mask of MR22 field.
	EXTI_IMR_MR22     = 0x400000 // Bit MR22.

	// EMR: Event mask register (EXTI_EMR)
	EXTI_EMR_MR0_Pos  = 0x0      // Position of MR0 field.
	EXTI_EMR_MR0_Msk  = 0x1      // Bit mask of MR0 field.
	EXTI_EMR_MR0      = 0x1      // Bit MR0.
	EXTI_EMR_MR1_Pos  = 0x1      // Position of MR1 field.
	EXTI_EMR_MR1_Msk  = 0x2      // Bit mask of MR1 field.
	EXTI_EMR_MR1      = 0x2      // Bit MR1.
	EXTI_EMR_MR2_Pos  = 0x2      // Position of MR2 field.
	EXTI_EMR_MR2_Msk  = 0x4      // Bit mask of MR2 field.
	EXTI_EMR_MR2      = 0x4      // Bit MR2.
	EXTI_EMR_MR3_Pos  = 0x3      // Position of MR3 field.
	EXTI_EMR_MR3_Msk  = 0x8      // Bit mask of MR3 field.
	EXTI_EMR_MR3      = 0x8      // Bit MR3.
	EXTI_EMR_MR4_Pos  = 0x4      // Position of MR4 field.
	EXTI_EMR_MR4_Msk  = 0x10     // Bit mask of MR4 field.
	EXTI_EMR_MR4      = 0x10     // Bit MR4.
	EXTI_EMR_MR5_Pos  = 0x5      // Position of MR5 field.
	EXTI_EMR_MR5_Msk  = 0x20     // Bit mask of MR5 field.
	EXTI_EMR_MR5      = 0x20     // Bit MR5.
	EXTI_EMR_MR6_Pos  = 0x6      // Position of MR6 field.
	EXTI_EMR_MR6_Msk  = 0x40     // Bit mask of MR6 field.
	EXTI_EMR_MR6      = 0x40     // Bit MR6.
	EXTI_EMR_MR7_Pos  = 0x7      // Position of MR7 field.
	EXTI_EMR_MR7_Msk  = 0x80     // Bit mask of MR7 field.
	EXTI_EMR_MR7      = 0x80     // Bit MR7.
	EXTI_EMR_MR8_Pos  = 0x8      // Position of MR8 field.
	EXTI_EMR_MR8_Msk  = 0x100    // Bit mask of MR8 field.
	EXTI_EMR_MR8      = 0x100    // Bit MR8.
	EXTI_EMR_MR9_Pos  = 0x9      // Position of MR9 field.
	EXTI_EMR_MR9_Msk  = 0x200    // Bit mask of MR9 field.
	EXTI_EMR_MR9      = 0x200    // Bit MR9.
	EXTI_EMR_MR10_Pos = 0xa      // Position of MR10 field.
	EXTI_EMR_MR10_Msk = 0x400    // Bit mask of MR10 field.
	EXTI_EMR_MR10     = 0x400    // Bit MR10.
	EXTI_EMR_MR11_Pos = 0xb      // Position of MR11 field.
	EXTI_EMR_MR11_Msk = 0x800    // Bit mask of MR11 field.
	EXTI_EMR_MR11     = 0x800    // Bit MR11.
	EXTI_EMR_MR12_Pos = 0xc      // Position of MR12 field.
	EXTI_EMR_MR12_Msk = 0x1000   // Bit mask of MR12 field.
	EXTI_EMR_MR12     = 0x1000   // Bit MR12.
	EXTI_EMR_MR13_Pos = 0xd      // Position of MR13 field.
	EXTI_EMR_MR13_Msk = 0x2000   // Bit mask of MR13 field.
	EXTI_EMR_MR13     = 0x2000   // Bit MR13.
	EXTI_EMR_MR14_Pos = 0xe      // Position of MR14 field.
	EXTI_EMR_MR14_Msk = 0x4000   // Bit mask of MR14 field.
	EXTI_EMR_MR14     = 0x4000   // Bit MR14.
	EXTI_EMR_MR15_Pos = 0xf      // Position of MR15 field.
	EXTI_EMR_MR15_Msk = 0x8000   // Bit mask of MR15 field.
	EXTI_EMR_MR15     = 0x8000   // Bit MR15.
	EXTI_EMR_MR16_Pos = 0x10     // Position of MR16 field.
	EXTI_EMR_MR16_Msk = 0x10000  // Bit mask of MR16 field.
	EXTI_EMR_MR16     = 0x10000  // Bit MR16.
	EXTI_EMR_MR17_Pos = 0x11     // Position of MR17 field.
	EXTI_EMR_MR17_Msk = 0x20000  // Bit mask of MR17 field.
	EXTI_EMR_MR17     = 0x20000  // Bit MR17.
	EXTI_EMR_MR18_Pos = 0x12     // Position of MR18 field.
	EXTI_EMR_MR18_Msk = 0x40000  // Bit mask of MR18 field.
	EXTI_EMR_MR18     = 0x40000  // Bit MR18.
	EXTI_EMR_MR19_Pos = 0x13     // Position of MR19 field.
	EXTI_EMR_MR19_Msk = 0x80000  // Bit mask of MR19 field.
	EXTI_EMR_MR19     = 0x80000  // Bit MR19.
	EXTI_EMR_MR20_Pos = 0x14     // Position of MR20 field.
	EXTI_EMR_MR20_Msk = 0x100000 // Bit mask of MR20 field.
	EXTI_EMR_MR20     = 0x100000 // Bit MR20.
	EXTI_EMR_MR21_Pos = 0x15     // Position of MR21 field.
	EXTI_EMR_MR21_Msk = 0x200000 // Bit mask of MR21 field.
	EXTI_EMR_MR21     = 0x200000 // Bit MR21.
	EXTI_EMR_MR22_Pos = 0x16     // Position of MR22 field.
	EXTI_EMR_MR22_Msk = 0x400000 // Bit mask of MR22 field.
	EXTI_EMR_MR22     = 0x400000 // Bit MR22.

	// RTSR: Rising Trigger selection register           (EXTI_RTSR)
	EXTI_RTSR_TR0_Pos  = 0x0      // Position of TR0 field.
	EXTI_RTSR_TR0_Msk  = 0x1      // Bit mask of TR0 field.
	EXTI_RTSR_TR0      = 0x1      // Bit TR0.
	EXTI_RTSR_TR1_Pos  = 0x1      // Position of TR1 field.
	EXTI_RTSR_TR1_Msk  = 0x2      // Bit mask of TR1 field.
	EXTI_RTSR_TR1      = 0x2      // Bit TR1.
	EXTI_RTSR_TR2_Pos  = 0x2      // Position of TR2 field.
	EXTI_RTSR_TR2_Msk  = 0x4      // Bit mask of TR2 field.
	EXTI_RTSR_TR2      = 0x4      // Bit TR2.
	EXTI_RTSR_TR3_Pos  = 0x3      // Position of TR3 field.
	EXTI_RTSR_TR3_Msk  = 0x8      // Bit mask of TR3 field.
	EXTI_RTSR_TR3      = 0x8      // Bit TR3.
	EXTI_RTSR_TR4_Pos  = 0x4      // Position of TR4 field.
	EXTI_RTSR_TR4_Msk  = 0x10     // Bit mask of TR4 field.
	EXTI_RTSR_TR4      = 0x10     // Bit TR4.
	EXTI_RTSR_TR5_Pos  = 0x5      // Position of TR5 field.
	EXTI_RTSR_TR5_Msk  = 0x20     // Bit mask of TR5 field.
	EXTI_RTSR_TR5      = 0x20     // Bit TR5.
	EXTI_RTSR_TR6_Pos  = 0x6      // Position of TR6 field.
	EXTI_RTSR_TR6_Msk  = 0x40     // Bit mask of TR6 field.
	EXTI_RTSR_TR6      = 0x40     // Bit TR6.
	EXTI_RTSR_TR7_Pos  = 0x7      // Position of TR7 field.
	EXTI_RTSR_TR7_Msk  = 0x80     // Bit mask of TR7 field.
	EXTI_RTSR_TR7      = 0x80     // Bit TR7.
	EXTI_RTSR_TR8_Pos  = 0x8      // Position of TR8 field.
	EXTI_RTSR_TR8_Msk  = 0x100    // Bit mask of TR8 field.
	EXTI_RTSR_TR8      = 0x100    // Bit TR8.
	EXTI_RTSR_TR9_Pos  = 0x9      // Position of TR9 field.
	EXTI_RTSR_TR9_Msk  = 0x200    // Bit mask of TR9 field.
	EXTI_RTSR_TR9      = 0x200    // Bit TR9.
	EXTI_RTSR_TR10_Pos = 0xa      // Position of TR10 field.
	EXTI_RTSR_TR10_Msk = 0x400    // Bit mask of TR10 field.
	EXTI_RTSR_TR10     = 0x400    // Bit TR10.
	EXTI_RTSR_TR11_Pos = 0xb      // Position of TR11 field.
	EXTI_RTSR_TR11_Msk = 0x800    // Bit mask of TR11 field.
	EXTI_RTSR_TR11     = 0x800    // Bit TR11.
	EXTI_RTSR_TR12_Pos = 0xc      // Position of TR12 field.
	EXTI_RTSR_TR12_Msk = 0x1000   // Bit mask of TR12 field.
	EXTI_RTSR_TR12     = 0x1000   // Bit TR12.
	EXTI_RTSR_TR13_Pos = 0xd      // Position of TR13 field.
	EXTI_RTSR_TR13_Msk = 0x2000   // Bit mask of TR13 field.
	EXTI_RTSR_TR13     = 0x2000   // Bit TR13.
	EXTI_RTSR_TR14_Pos = 0xe      // Position of TR14 field.
	EXTI_RTSR_TR14_Msk = 0x4000   // Bit mask of TR14 field.
	EXTI_RTSR_TR14     = 0x4000   // Bit TR14.
	EXTI_RTSR_TR15_Pos = 0xf      // Position of TR15 field.
	EXTI_RTSR_TR15_Msk = 0x8000   // Bit mask of TR15 field.
	EXTI_RTSR_TR15     = 0x8000   // Bit TR15.
	EXTI_RTSR_TR16_Pos = 0x10     // Position of TR16 field.
	EXTI_RTSR_TR16_Msk = 0x10000  // Bit mask of TR16 field.
	EXTI_RTSR_TR16     = 0x10000  // Bit TR16.
	EXTI_RTSR_TR17_Pos = 0x11     // Position of TR17 field.
	EXTI_RTSR_TR17_Msk = 0x20000  // Bit mask of TR17 field.
	EXTI_RTSR_TR17     = 0x20000  // Bit TR17.
	EXTI_RTSR_TR18_Pos = 0x12     // Position of TR18 field.
	EXTI_RTSR_TR18_Msk = 0x40000  // Bit mask of TR18 field.
	EXTI_RTSR_TR18     = 0x40000  // Bit TR18.
	EXTI_RTSR_TR19_Pos = 0x13     // Position of TR19 field.
	EXTI_RTSR_TR19_Msk = 0x80000  // Bit mask of TR19 field.
	EXTI_RTSR_TR19     = 0x80000  // Bit TR19.
	EXTI_RTSR_TR20_Pos = 0x14     // Position of TR20 field.
	EXTI_RTSR_TR20_Msk = 0x100000 // Bit mask of TR20 field.
	EXTI_RTSR_TR20     = 0x100000 // Bit TR20.
	EXTI_RTSR_TR21_Pos = 0x15     // Position of TR21 field.
	EXTI_RTSR_TR21_Msk = 0x200000 // Bit mask of TR21 field.
	EXTI_RTSR_TR21     = 0x200000 // Bit TR21.
	EXTI_RTSR_TR22_Pos = 0x16     // Position of TR22 field.
	EXTI_RTSR_TR22_Msk = 0x400000 // Bit mask of TR22 field.
	EXTI_RTSR_TR22     = 0x400000 // Bit TR22.

	// FTSR: Falling Trigger selection register           (EXTI_FTSR)
	EXTI_FTSR_TR0_Pos  = 0x0      // Position of TR0 field.
	EXTI_FTSR_TR0_Msk  = 0x1      // Bit mask of TR0 field.
	EXTI_FTSR_TR0      = 0x1      // Bit TR0.
	EXTI_FTSR_TR1_Pos  = 0x1      // Position of TR1 field.
	EXTI_FTSR_TR1_Msk  = 0x2      // Bit mask of TR1 field.
	EXTI_FTSR_TR1      = 0x2      // Bit TR1.
	EXTI_FTSR_TR2_Pos  = 0x2      // Position of TR2 field.
	EXTI_FTSR_TR2_Msk  = 0x4      // Bit mask of TR2 field.
	EXTI_FTSR_TR2      = 0x4      // Bit TR2.
	EXTI_FTSR_TR3_Pos  = 0x3      // Position of TR3 field.
	EXTI_FTSR_TR3_Msk  = 0x8      // Bit mask of TR3 field.
	EXTI_FTSR_TR3      = 0x8      // Bit TR3.
	EXTI_FTSR_TR4_Pos  = 0x4      // Position of TR4 field.
	EXTI_FTSR_TR4_Msk  = 0x10     // Bit mask of TR4 field.
	EXTI_FTSR_TR4      = 0x10     // Bit TR4.
	EXTI_FTSR_TR5_Pos  = 0x5      // Position of TR5 field.
	EXTI_FTSR_TR5_Msk  = 0x20     // Bit mask of TR5 field.
	EXTI_FTSR_TR5      = 0x20     // Bit TR5.
	EXTI_FTSR_TR6_Pos  = 0x6      // Position of TR6 field.
	EXTI_FTSR_TR6_Msk  = 0x40     // Bit mask of TR6 field.
	EXTI_FTSR_TR6      = 0x40     // Bit TR6.
	EXTI_FTSR_TR7_Pos  = 0x7      // Position of TR7 field.
	EXTI_FTSR_TR7_Msk  = 0x80     // Bit mask of TR7 field.
	EXTI_FTSR_TR7      = 0x80     // Bit TR7.
	EXTI_FTSR_TR8_Pos  = 0x8      // Position of TR8 field.
	EXTI_FTSR_TR8_Msk  = 0x100    // Bit mask of TR8 field.
	EXTI_FTSR_TR8      = 0x100    // Bit TR8.
	EXTI_FTSR_TR9_Pos  = 0x9      // Position of TR9 field.
	EXTI_FTSR_TR9_Msk  = 0x200    // Bit mask of TR9 field.
	EXTI_FTSR_TR9      = 0x200    // Bit TR9.
	EXTI_FTSR_TR10_Pos = 0xa      // Position of TR10 field.
	EXTI_FTSR_TR10_Msk = 0x400    // Bit mask of TR10 field.
	EXTI_FTSR_TR10     = 0x400    // Bit TR10.
	EXTI_FTSR_TR11_Pos = 0xb      // Position of TR11 field.
	EXTI_FTSR_TR11_Msk = 0x800    // Bit mask of TR11 field.
	EXTI_FTSR_TR11     = 0x800    // Bit TR11.
	EXTI_FTSR_TR12_Pos = 0xc      // Position of TR12 field.
	EXTI_FTSR_TR12_Msk = 0x1000   // Bit mask of TR12 field.
	EXTI_FTSR_TR12     = 0x1000   // Bit TR12.
	EXTI_FTSR_TR13_Pos = 0xd      // Position of TR13 field.
	EXTI_FTSR_TR13_Msk = 0x2000   // Bit mask of TR13 field.
	EXTI_FTSR_TR13     = 0x2000   // Bit TR13.
	EXTI_FTSR_TR14_Pos = 0xe      // Position of TR14 field.
	EXTI_FTSR_TR14_Msk = 0x4000   // Bit mask of TR14 field.
	EXTI_FTSR_TR14     = 0x4000   // Bit TR14.
	EXTI_FTSR_TR15_Pos = 0xf      // Position of TR15 field.
	EXTI_FTSR_TR15_Msk = 0x8000   // Bit mask of TR15 field.
	EXTI_FTSR_TR15     = 0x8000   // Bit TR15.
	EXTI_FTSR_TR16_Pos = 0x10     // Position of TR16 field.
	EXTI_FTSR_TR16_Msk = 0x10000  // Bit mask of TR16 field.
	EXTI_FTSR_TR16     = 0x10000  // Bit TR16.
	EXTI_FTSR_TR17_Pos = 0x11     // Position of TR17 field.
	EXTI_FTSR_TR17_Msk = 0x20000  // Bit mask of TR17 field.
	EXTI_FTSR_TR17     = 0x20000  // Bit TR17.
	EXTI_FTSR_TR18_Pos = 0x12     // Position of TR18 field.
	EXTI_FTSR_TR18_Msk = 0x40000  // Bit mask of TR18 field.
	EXTI_FTSR_TR18     = 0x40000  // Bit TR18.
	EXTI_FTSR_TR19_Pos = 0x13     // Position of TR19 field.
	EXTI_FTSR_TR19_Msk = 0x80000  // Bit mask of TR19 field.
	EXTI_FTSR_TR19     = 0x80000  // Bit TR19.
	EXTI_FTSR_TR20_Pos = 0x14     // Position of TR20 field.
	EXTI_FTSR_TR20_Msk = 0x100000 // Bit mask of TR20 field.
	EXTI_FTSR_TR20     = 0x100000 // Bit TR20.
	EXTI_FTSR_TR21_Pos = 0x15     // Position of TR21 field.
	EXTI_FTSR_TR21_Msk = 0x200000 // Bit mask of TR21 field.
	EXTI_FTSR_TR21     = 0x200000 // Bit TR21.
	EXTI_FTSR_TR22_Pos = 0x16     // Position of TR22 field.
	EXTI_FTSR_TR22_Msk = 0x400000 // Bit mask of TR22 field.
	EXTI_FTSR_TR22     = 0x400000 // Bit TR22.

	// SWIER: Software interrupt event register           (EXTI_SWIER)
	EXTI_SWIER_SWIER0_Pos  = 0x0      // Position of SWIER0 field.
	EXTI_SWIER_SWIER0_Msk  = 0x1      // Bit mask of SWIER0 field.
	EXTI_SWIER_SWIER0      = 0x1      // Bit SWIER0.
	EXTI_SWIER_SWIER1_Pos  = 0x1      // Position of SWIER1 field.
	EXTI_SWIER_SWIER1_Msk  = 0x2      // Bit mask of SWIER1 field.
	EXTI_SWIER_SWIER1      = 0x2      // Bit SWIER1.
	EXTI_SWIER_SWIER2_Pos  = 0x2      // Position of SWIER2 field.
	EXTI_SWIER_SWIER2_Msk  = 0x4      // Bit mask of SWIER2 field.
	EXTI_SWIER_SWIER2      = 0x4      // Bit SWIER2.
	EXTI_SWIER_SWIER3_Pos  = 0x3      // Position of SWIER3 field.
	EXTI_SWIER_SWIER3_Msk  = 0x8      // Bit mask of SWIER3 field.
	EXTI_SWIER_SWIER3      = 0x8      // Bit SWIER3.
	EXTI_SWIER_SWIER4_Pos  = 0x4      // Position of SWIER4 field.
	EXTI_SWIER_SWIER4_Msk  = 0x10     // Bit mask of SWIER4 field.
	EXTI_SWIER_SWIER4      = 0x10     // Bit SWIER4.
	EXTI_SWIER_SWIER5_Pos  = 0x5      // Position of SWIER5 field.
	EXTI_SWIER_SWIER5_Msk  = 0x20     // Bit mask of SWIER5 field.
	EXTI_SWIER_SWIER5      = 0x20     // Bit SWIER5.
	EXTI_SWIER_SWIER6_Pos  = 0x6      // Position of SWIER6 field.
	EXTI_SWIER_SWIER6_Msk  = 0x40     // Bit mask of SWIER6 field.
	EXTI_SWIER_SWIER6      = 0x40     // Bit SWIER6.
	EXTI_SWIER_SWIER7_Pos  = 0x7      // Position of SWIER7 field.
	EXTI_SWIER_SWIER7_Msk  = 0x80     // Bit mask of SWIER7 field.
	EXTI_SWIER_SWIER7      = 0x80     // Bit SWIER7.
	EXTI_SWIER_SWIER8_Pos  = 0x8      // Position of SWIER8 field.
	EXTI_SWIER_SWIER8_Msk  = 0x100    // Bit mask of SWIER8 field.
	EXTI_SWIER_SWIER8      = 0x100    // Bit SWIER8.
	EXTI_SWIER_SWIER9_Pos  = 0x9      // Position of SWIER9 field.
	EXTI_SWIER_SWIER9_Msk  = 0x200    // Bit mask of SWIER9 field.
	EXTI_SWIER_SWIER9      = 0x200    // Bit SWIER9.
	EXTI_SWIER_SWIER10_Pos = 0xa      // Position of SWIER10 field.
	EXTI_SWIER_SWIER10_Msk = 0x400    // Bit mask of SWIER10 field.
	EXTI_SWIER_SWIER10     = 0x400    // Bit SWIER10.
	EXTI_SWIER_SWIER11_Pos = 0xb      // Position of SWIER11 field.
	EXTI_SWIER_SWIER11_Msk = 0x800    // Bit mask of SWIER11 field.
	EXTI_SWIER_SWIER11     = 0x800    // Bit SWIER11.
	EXTI_SWIER_SWIER12_Pos = 0xc      // Position of SWIER12 field.
	EXTI_SWIER_SWIER12_Msk = 0x1000   // Bit mask of SWIER12 field.
	EXTI_SWIER_SWIER12     = 0x1000   // Bit SWIER12.
	EXTI_SWIER_SWIER13_Pos = 0xd      // Position of SWIER13 field.
	EXTI_SWIER_SWIER13_Msk = 0x2000   // Bit mask of SWIER13 field.
	EXTI_SWIER_SWIER13     = 0x2000   // Bit SWIER13.
	EXTI_SWIER_SWIER14_Pos = 0xe      // Position of SWIER14 field.
	EXTI_SWIER_SWIER14_Msk = 0x4000   // Bit mask of SWIER14 field.
	EXTI_SWIER_SWIER14     = 0x4000   // Bit SWIER14.
	EXTI_SWIER_SWIER15_Pos = 0xf      // Position of SWIER15 field.
	EXTI_SWIER_SWIER15_Msk = 0x8000   // Bit mask of SWIER15 field.
	EXTI_SWIER_SWIER15     = 0x8000   // Bit SWIER15.
	EXTI_SWIER_SWIER16_Pos = 0x10     // Position of SWIER16 field.
	EXTI_SWIER_SWIER16_Msk = 0x10000  // Bit mask of SWIER16 field.
	EXTI_SWIER_SWIER16     = 0x10000  // Bit SWIER16.
	EXTI_SWIER_SWIER17_Pos = 0x11     // Position of SWIER17 field.
	EXTI_SWIER_SWIER17_Msk = 0x20000  // Bit mask of SWIER17 field.
	EXTI_SWIER_SWIER17     = 0x20000  // Bit SWIER17.
	EXTI_SWIER_SWIER18_Pos = 0x12     // Position of SWIER18 field.
	EXTI_SWIER_SWIER18_Msk = 0x40000  // Bit mask of SWIER18 field.
	EXTI_SWIER_SWIER18     = 0x40000  // Bit SWIER18.
	EXTI_SWIER_SWIER19_Pos = 0x13     // Position of SWIER19 field.
	EXTI_SWIER_SWIER19_Msk = 0x80000  // Bit mask of SWIER19 field.
	EXTI_SWIER_SWIER19     = 0x80000  // Bit SWIER19.
	EXTI_SWIER_SWIER20_Pos = 0x14     // Position of SWIER20 field.
	EXTI_SWIER_SWIER20_Msk = 0x100000 // Bit mask of SWIER20 field.
	EXTI_SWIER_SWIER20     = 0x100000 // Bit SWIER20.
	EXTI_SWIER_SWIER21_Pos = 0x15     // Position of SWIER21 field.
	EXTI_SWIER_SWIER21_Msk = 0x200000 // Bit mask of SWIER21 field.
	EXTI_SWIER_SWIER21     = 0x200000 // Bit SWIER21.
	EXTI_SWIER_SWIER22_Pos = 0x16     // Position of SWIER22 field.
	EXTI_SWIER_SWIER22_Msk = 0x400000 // Bit mask of SWIER22 field.
	EXTI_SWIER_SWIER22     = 0x400000 // Bit SWIER22.

	// PR: Pending register (EXTI_PR)
	EXTI_PR_PR0_Pos  = 0x0      // Position of PR0 field.
	EXTI_PR_PR0_Msk  = 0x1      // Bit mask of PR0 field.
	EXTI_PR_PR0      = 0x1      // Bit PR0.
	EXTI_PR_PR1_Pos  = 0x1      // Position of PR1 field.
	EXTI_PR_PR1_Msk  = 0x2      // Bit mask of PR1 field.
	EXTI_PR_PR1      = 0x2      // Bit PR1.
	EXTI_PR_PR2_Pos  = 0x2      // Position of PR2 field.
	EXTI_PR_PR2_Msk  = 0x4      // Bit mask of PR2 field.
	EXTI_PR_PR2      = 0x4      // Bit PR2.
	EXTI_PR_PR3_Pos  = 0x3      // Position of PR3 field.
	EXTI_PR_PR3_Msk  = 0x8      // Bit mask of PR3 field.
	EXTI_PR_PR3      = 0x8      // Bit PR3.
	EXTI_PR_PR4_Pos  = 0x4      // Position of PR4 field.
	EXTI_PR_PR4_Msk  = 0x10     // Bit mask of PR4 field.
	EXTI_PR_PR4      = 0x10     // Bit PR4.
	EXTI_PR_PR5_Pos  = 0x5      // Position of PR5 field.
	EXTI_PR_PR5_Msk  = 0x20     // Bit mask of PR5 field.
	EXTI_PR_PR5      = 0x20     // Bit PR5.
	EXTI_PR_PR6_Pos  = 0x6      // Position of PR6 field.
	EXTI_PR_PR6_Msk  = 0x40     // Bit mask of PR6 field.
	EXTI_PR_PR6      = 0x40     // Bit PR6.
	EXTI_PR_PR7_Pos  = 0x7      // Position of PR7 field.
	EXTI_PR_PR7_Msk  = 0x80     // Bit mask of PR7 field.
	EXTI_PR_PR7      = 0x80     // Bit PR7.
	EXTI_PR_PR8_Pos  = 0x8      // Position of PR8 field.
	EXTI_PR_PR8_Msk  = 0x100    // Bit mask of PR8 field.
	EXTI_PR_PR8      = 0x100    // Bit PR8.
	EXTI_PR_PR9_Pos  = 0x9      // Position of PR9 field.
	EXTI_PR_PR9_Msk  = 0x200    // Bit mask of PR9 field.
	EXTI_PR_PR9      = 0x200    // Bit PR9.
	EXTI_PR_PR10_Pos = 0xa      // Position of PR10 field.
	EXTI_PR_PR10_Msk = 0x400    // Bit mask of PR10 field.
	EXTI_PR_PR10     = 0x400    // Bit PR10.
	EXTI_PR_PR11_Pos = 0xb      // Position of PR11 field.
	EXTI_PR_PR11_Msk = 0x800    // Bit mask of PR11 field.
	EXTI_PR_PR11     = 0x800    // Bit PR11.
	EXTI_PR_PR12_Pos = 0xc      // Position of PR12 field.
	EXTI_PR_PR12_Msk = 0x1000   // Bit mask of PR12 field.
	EXTI_PR_PR12     = 0x1000   // Bit PR12.
	EXTI_PR_PR13_Pos = 0xd      // Position of PR13 field.
	EXTI_PR_PR13_Msk = 0x2000   // Bit mask of PR13 field.
	EXTI_PR_PR13     = 0x2000   // Bit PR13.
	EXTI_PR_PR14_Pos = 0xe      // Position of PR14 field.
	EXTI_PR_PR14_Msk = 0x4000   // Bit mask of PR14 field.
	EXTI_PR_PR14     = 0x4000   // Bit PR14.
	EXTI_PR_PR15_Pos = 0xf      // Position of PR15 field.
	EXTI_PR_PR15_Msk = 0x8000   // Bit mask of PR15 field.
	EXTI_PR_PR15     = 0x8000   // Bit PR15.
	EXTI_PR_PR16_Pos = 0x10     // Position of PR16 field.
	EXTI_PR_PR16_Msk = 0x10000  // Bit mask of PR16 field.
	EXTI_PR_PR16     = 0x10000  // Bit PR16.
	EXTI_PR_PR17_Pos = 0x11     // Position of PR17 field.
	EXTI_PR_PR17_Msk = 0x20000  // Bit mask of PR17 field.
	EXTI_PR_PR17     = 0x20000  // Bit PR17.
	EXTI_PR_PR18_Pos = 0x12     // Position of PR18 field.
	EXTI_PR_PR18_Msk = 0x40000  // Bit mask of PR18 field.
	EXTI_PR_PR18     = 0x40000  // Bit PR18.
	EXTI_PR_PR19_Pos = 0x13     // Position of PR19 field.
	EXTI_PR_PR19_Msk = 0x80000  // Bit mask of PR19 field.
	EXTI_PR_PR19     = 0x80000  // Bit PR19.
	EXTI_PR_PR20_Pos = 0x14     // Position of PR20 field.
	EXTI_PR_PR20_Msk = 0x100000 // Bit mask of PR20 field.
	EXTI_PR_PR20     = 0x100000 // Bit PR20.
	EXTI_PR_PR21_Pos = 0x15     // Position of PR21 field.
	EXTI_PR_PR21_Msk = 0x200000 // Bit mask of PR21 field.
	EXTI_PR_PR21     = 0x200000 // Bit PR21.
	EXTI_PR_PR22_Pos = 0x16     // Position of PR22 field.
	EXTI_PR_PR22_Msk = 0x400000 // Bit mask of PR22 field.
	EXTI_PR_PR22     = 0x400000 // Bit PR22.
)

// Bitfields for FLASH: FLASH
const (
	// ACR: Flash access control register
	FLASH_ACR_LATENCY_Pos = 0x0    // Position of LATENCY field.
	FLASH_ACR_LATENCY_Msk = 0x7    // Bit mask of LATENCY field.
	FLASH_ACR_PRFTEN_Pos  = 0x8    // Position of PRFTEN field.
	FLASH_ACR_PRFTEN_Msk  = 0x100  // Bit mask of PRFTEN field.
	FLASH_ACR_PRFTEN      = 0x100  // Bit PRFTEN.
	FLASH_ACR_ICEN_Pos    = 0x9    // Position of ICEN field.
	FLASH_ACR_ICEN_Msk    = 0x200  // Bit mask of ICEN field.
	FLASH_ACR_ICEN        = 0x200  // Bit ICEN.
	FLASH_ACR_DCEN_Pos    = 0xa    // Position of DCEN field.
	FLASH_ACR_DCEN_Msk    = 0x400  // Bit mask of DCEN field.
	FLASH_ACR_DCEN        = 0x400  // Bit DCEN.
	FLASH_ACR_ICRST_Pos   = 0xb    // Position of ICRST field.
	FLASH_ACR_ICRST_Msk   = 0x800  // Bit mask of ICRST field.
	FLASH_ACR_ICRST       = 0x800  // Bit ICRST.
	FLASH_ACR_DCRST_Pos   = 0xc    // Position of DCRST field.
	FLASH_ACR_DCRST_Msk   = 0x1000 // Bit mask of DCRST field.
	FLASH_ACR_DCRST       = 0x1000 // Bit DCRST.

	// KEYR: Flash key register
	FLASH_KEYR_KEY_Pos = 0x0        // Position of KEY field.
	FLASH_KEYR_KEY_Msk = 0xffffffff // Bit mask of KEY field.

	// OPTKEYR: Flash option key register
	FLASH_OPTKEYR_OPTKEY_Pos = 0x0        // Position of OPTKEY field.
	FLASH_OPTKEYR_OPTKEY_Msk = 0xffffffff // Bit mask of OPTKEY field.

	// SR: Status register
	FLASH_SR_EOP_Pos    = 0x0     // Position of EOP field.
	FLASH_SR_EOP_Msk    = 0x1     // Bit mask of EOP field.
	FLASH_SR_EOP        = 0x1     // Bit EOP.
	FLASH_SR_OPERR_Pos  = 0x1     // Position of OPERR field.
	FLASH_SR_OPERR_Msk  = 0x2     // Bit mask of OPERR field.
	FLASH_SR_OPERR      = 0x2     // Bit OPERR.
	FLASH_SR_WRPERR_Pos = 0x4     // Position of WRPERR field.
	FLASH_SR_WRPERR_Msk = 0x10    // Bit mask of WRPERR field.
	FLASH_SR_WRPERR     = 0x10    // Bit WRPERR.
	FLASH_SR_PGAERR_Pos = 0x5     // Position of PGAERR field.
	FLASH_SR_PGAERR_Msk = 0x20    // Bit mask of PGAERR field.
	FLASH_SR_PGAERR     = 0x20    // Bit PGAERR.
	FLASH_SR_PGPERR_Pos = 0x6     // Position of PGPERR field.
	FLASH_SR_PGPERR_Msk = 0x40    // Bit mask of PGPERR field.
	FLASH_SR_PGPERR     = 0x40    // Bit PGPERR.
	FLASH_SR_PGSERR_Pos = 0x7     // Position of PGSERR field.
	FLASH_SR_PGSERR_Msk = 0x80    // Bit mask of PGSERR field.
	FLASH_SR_PGSERR     = 0x80    // Bit PGSERR.
	FLASH_SR_BSY_Pos    = 0x10    // Position of BSY field.
	FLASH_SR_BSY_Msk    = 0x10000 // Bit mask of BSY field.
	FLASH_SR_BSY        = 0x10000 // Bit BSY.

	// CR: Control register
	FLASH_CR_PG_Pos    = 0x0        // Position of PG field.
	FLASH_CR_PG_Msk    = 0x1        // Bit mask of PG field.
	FLASH_CR_PG        = 0x1        // Bit PG.
	FLASH_CR_SER_Pos   = 0x1        // Position of SER field.
	FLASH_CR_SER_Msk   = 0x2        // Bit mask of SER field.
	FLASH_CR_SER       = 0x2        // Bit SER.
	FLASH_CR_MER_Pos   = 0x2        // Position of MER field.
	FLASH_CR_MER_Msk   = 0x4        // Bit mask of MER field.
	FLASH_CR_MER       = 0x4        // Bit MER.
	FLASH_CR_SNB_Pos   = 0x3        // Position of SNB field.
	FLASH_CR_SNB_Msk   = 0x78       // Bit mask of SNB field.
	FLASH_CR_PSIZE_Pos = 0x8        // Position of PSIZE field.
	FLASH_CR_PSIZE_Msk = 0x300      // Bit mask of PSIZE field.
	FLASH_CR_STRT_Pos  = 0x10       // Position of STRT field.
	FLASH_CR_STRT_Msk  = 0x10000    // Bit mask of STRT field.
	FLASH_CR_STRT      = 0x10000    // Bit STRT.
	FLASH_CR_EOPIE_Pos = 0x18       // Position of EOPIE field.
	FLASH_CR_EOPIE_Msk = 0x1000000  // Bit mask of EOPIE field.
	FLASH_CR_EOPIE     = 0x1000000  // Bit EOPIE.
	FLASH_CR_ERRIE_Pos = 0x19       // Position of ERRIE field.
	FLASH_CR_ERRIE_Msk = 0x2000000  // Bit mask of ERRIE field.
	FLASH_CR_ERRIE     = 0x2000000  // Bit ERRIE.
	FLASH_CR_LOCK_Pos  = 0x1f       // Position of LOCK field.
	FLASH_CR_LOCK_Msk  = 0x80000000 // Bit mask of LOCK field.
	FLASH_CR_LOCK      = 0x80000000 // Bit LOCK.

	// OPTCR: Flash option control register
	FLASH_OPTCR_OPTLOCK_Pos    = 0x0       // Position of OPTLOCK field.
	FLASH_OPTCR_OPTLOCK_Msk    = 0x1       // Bit mask of OPTLOCK field.
	FLASH_OPTCR_OPTLOCK        = 0x1       // Bit OPTLOCK.
	FLASH_OPTCR_OPTSTRT_Pos    = 0x1       // Position of OPTSTRT field.
	FLASH_OPTCR_OPTSTRT_Msk    = 0x2       // Bit mask of OPTSTRT field.
	FLASH_OPTCR_OPTSTRT        = 0x2       // Bit OPTSTRT.
	FLASH_OPTCR_BOR_LEV_Pos    = 0x2       // Position of BOR_LEV field.
	FLASH_OPTCR_BOR_LEV_Msk    = 0xc       // Bit mask of BOR_LEV field.
	FLASH_OPTCR_WDG_SW_Pos     = 0x5       // Position of WDG_SW field.
	FLASH_OPTCR_WDG_SW_Msk     = 0x20      // Bit mask of WDG_SW field.
	FLASH_OPTCR_WDG_SW         = 0x20      // Bit WDG_SW.
	FLASH_OPTCR_NRST_STOP_Pos  = 0x6       // Position of NRST_STOP field.
	FLASH_OPTCR_NRST_STOP_Msk  = 0x40      // Bit mask of NRST_STOP field.
	FLASH_OPTCR_NRST_STOP      = 0x40      // Bit NRST_STOP.
	FLASH_OPTCR_NRST_STDBY_Pos = 0x7       // Position of NRST_STDBY field.
	FLASH_OPTCR_NRST_STDBY_Msk = 0x80      // Bit mask of NRST_STDBY field.
	FLASH_OPTCR_NRST_STDBY     = 0x80      // Bit NRST_STDBY.
	FLASH_OPTCR_RDP_Pos        = 0x8       // Position of RDP field.
	FLASH_OPTCR_RDP_Msk        = 0xff00    // Bit mask of RDP field.
	FLASH_OPTCR_NWRP_Pos       = 0x10      // Position of NWRP field.
	FLASH_OPTCR_NWRP_Msk       = 0xfff0000 // Bit mask of NWRP field.
)

// Bitfields for IWDG: Independent watchdog
const (
	// KR: Key register
	IWDG_KR_KEY_Pos = 0x0    // Position of KEY field.
	IWDG_KR_KEY_Msk = 0xffff // Bit mask of KEY field.

	// PR: Prescaler register
	IWDG_PR_PR_Pos = 0x0 // Position of PR field.
	IWDG_PR_PR_Msk = 0x7 // Bit mask of PR field.

	// RLR: Reload register
	IWDG_RLR_RL_Pos = 0x0   // Position of RL field.
	IWDG_RLR_RL_Msk = 0xfff // Bit mask of RL field.

	// SR: Status register
	IWDG_SR_RVU_Pos = 0x1 // Position of RVU field.
	IWDG_SR_RVU_Msk = 0x2 // Bit mask of RVU field.
	IWDG_SR_RVU     = 0x2 // Bit RVU.
	IWDG_SR_PVU_Pos = 0x0 // Position of PVU field.
	IWDG_SR_PVU_Msk = 0x1 // Bit mask of PVU field.
	IWDG_SR_PVU     = 0x1 // Bit PVU.
)

// Bitfields for OTG_FS_DEVICE: USB on the go full speed
const (
	// FS_DCFG: OTG_FS device configuration register           (OTG_FS_DCFG)
	USB_OTG_FS_FS_DCFG_DSPD_Pos     = 0x0    // Position of DSPD field.
	USB_OTG_FS_FS_DCFG_DSPD_Msk     = 0x3    // Bit mask of DSPD field.
	USB_OTG_FS_FS_DCFG_NZLSOHSK_Pos = 0x2    // Position of NZLSOHSK field.
	USB_OTG_FS_FS_DCFG_NZLSOHSK_Msk = 0x4    // Bit mask of NZLSOHSK field.
	USB_OTG_FS_FS_DCFG_NZLSOHSK     = 0x4    // Bit NZLSOHSK.
	USB_OTG_FS_FS_DCFG_DAD_Pos      = 0x4    // Position of DAD field.
	USB_OTG_FS_FS_DCFG_DAD_Msk      = 0x7f0  // Bit mask of DAD field.
	USB_OTG_FS_FS_DCFG_PFIVL_Pos    = 0xb    // Position of PFIVL field.
	USB_OTG_FS_FS_DCFG_PFIVL_Msk    = 0x1800 // Bit mask of PFIVL field.

	// FS_DCTL: OTG_FS device control register           (OTG_FS_DCTL)
	USB_OTG_FS_FS_DCTL_RWUSIG_Pos   = 0x0   // Position of RWUSIG field.
	USB_OTG_FS_FS_DCTL_RWUSIG_Msk   = 0x1   // Bit mask of RWUSIG field.
	USB_OTG_FS_FS_DCTL_RWUSIG       = 0x1   // Bit RWUSIG.
	USB_OTG_FS_FS_DCTL_SDIS_Pos     = 0x1   // Position of SDIS field.
	USB_OTG_FS_FS_DCTL_SDIS_Msk     = 0x2   // Bit mask of SDIS field.
	USB_OTG_FS_FS_DCTL_SDIS         = 0x2   // Bit SDIS.
	USB_OTG_FS_FS_DCTL_GINSTS_Pos   = 0x2   // Position of GINSTS field.
	USB_OTG_FS_FS_DCTL_GINSTS_Msk   = 0x4   // Bit mask of GINSTS field.
	USB_OTG_FS_FS_DCTL_GINSTS       = 0x4   // Bit GINSTS.
	USB_OTG_FS_FS_DCTL_GONSTS_Pos   = 0x3   // Position of GONSTS field.
	USB_OTG_FS_FS_DCTL_GONSTS_Msk   = 0x8   // Bit mask of GONSTS field.
	USB_OTG_FS_FS_DCTL_GONSTS       = 0x8   // Bit GONSTS.
	USB_OTG_FS_FS_DCTL_TCTL_Pos     = 0x4   // Position of TCTL field.
	USB_OTG_FS_FS_DCTL_TCTL_Msk     = 0x70  // Bit mask of TCTL field.
	USB_OTG_FS_FS_DCTL_SGINAK_Pos   = 0x7   // Position of SGINAK field.
	USB_OTG_FS_FS_DCTL_SGINAK_Msk   = 0x80  // Bit mask of SGINAK field.
	USB_OTG_FS_FS_DCTL_SGINAK       = 0x80  // Bit SGINAK.
	USB_OTG_FS_FS_DCTL_CGINAK_Pos   = 0x8   // Position of CGINAK field.
	USB_OTG_FS_FS_DCTL_CGINAK_Msk   = 0x100 // Bit mask of CGINAK field.
	USB_OTG_FS_FS_DCTL_CGINAK       = 0x100 // Bit CGINAK.
	USB_OTG_FS_FS_DCTL_SGONAK_Pos   = 0x9   // Position of SGONAK field.
	USB_OTG_FS_FS_DCTL_SGONAK_Msk   = 0x200 // Bit mask of SGONAK field.
	USB_OTG_FS_FS_DCTL_SGONAK       = 0x200 // Bit SGONAK.
	USB_OTG_FS_FS_DCTL_CGONAK_Pos   = 0xa   // Position of CGONAK field.
	USB_OTG_FS_FS_DCTL_CGONAK_Msk   = 0x400 // Bit mask of CGONAK field.
	USB_OTG_FS_FS_DCTL_CGONAK       = 0x400 // Bit CGONAK.
	USB_OTG_FS_FS_DCTL_POPRGDNE_Pos = 0xb   // Position of POPRGDNE field.
	USB_OTG_FS_FS_DCTL_POPRGDNE_Msk = 0x800 // Bit mask of POPRGDNE field.
	USB_OTG_FS_FS_DCTL_POPRGDNE     = 0x800 // Bit POPRGDNE.

	// FS_DSTS: OTG_FS device status register           (OTG_FS_DSTS)
	USB_OTG_FS_FS_DSTS_SUSPSTS_Pos = 0x0      // Position of SUSPSTS field.
	USB_OTG_FS_FS_DSTS_SUSPSTS_Msk = 0x1      // Bit mask of SUSPSTS field.
	USB_OTG_FS_FS_DSTS_SUSPSTS     = 0x1      // Bit SUSPSTS.
	USB_OTG_FS_FS_DSTS_ENUMSPD_Pos = 0x1      // Position of ENUMSPD field.
	USB_OTG_FS_FS_DSTS_ENUMSPD_Msk = 0x6      // Bit mask of ENUMSPD field.
	USB_OTG_FS_FS_DSTS_EERR_Pos    = 0x3      // Position of EERR field.
	USB_OTG_FS_FS_DSTS_EERR_Msk    = 0x8      // Bit mask of EERR field.
	USB_OTG_FS_FS_DSTS_EERR        = 0x8      // Bit EERR.
	USB_OTG_FS_FS_DSTS_FNSOF_Pos   = 0x8      // Position of FNSOF field.
	USB_OTG_FS_FS_DSTS_FNSOF_Msk   = 0x3fff00 // Bit mask of FNSOF field.

	// FS_DIEPMSK: OTG_FS device IN endpoint common interrupt           mask register (OTG_FS_DIEPMSK)
	USB_OTG_FS_FS_DIEPMSK_XFRCM_Pos     = 0x0  // Position of XFRCM field.
	USB_OTG_FS_FS_DIEPMSK_XFRCM_Msk     = 0x1  // Bit mask of XFRCM field.
	USB_OTG_FS_FS_DIEPMSK_XFRCM         = 0x1  // Bit XFRCM.
	USB_OTG_FS_FS_DIEPMSK_EPDM_Pos      = 0x1  // Position of EPDM field.
	USB_OTG_FS_FS_DIEPMSK_EPDM_Msk      = 0x2  // Bit mask of EPDM field.
	USB_OTG_FS_FS_DIEPMSK_EPDM          = 0x2  // Bit EPDM.
	USB_OTG_FS_FS_DIEPMSK_TOM_Pos       = 0x3  // Position of TOM field.
	USB_OTG_FS_FS_DIEPMSK_TOM_Msk       = 0x8  // Bit mask of TOM field.
	USB_OTG_FS_FS_DIEPMSK_TOM           = 0x8  // Bit TOM.
	USB_OTG_FS_FS_DIEPMSK_ITTXFEMSK_Pos = 0x4  // Position of ITTXFEMSK field.
	USB_OTG_FS_FS_DIEPMSK_ITTXFEMSK_Msk = 0x10 // Bit mask of ITTXFEMSK field.
	USB_OTG_FS_FS_DIEPMSK_ITTXFEMSK     = 0x10 // Bit ITTXFEMSK.
	USB_OTG_FS_FS_DIEPMSK_INEPNMM_Pos   = 0x5  // Position of INEPNMM field.
	USB_OTG_FS_FS_DIEPMSK_INEPNMM_Msk   = 0x20 // Bit mask of INEPNMM field.
	USB_OTG_FS_FS_DIEPMSK_INEPNMM       = 0x20 // Bit INEPNMM.
	USB_OTG_FS_FS_DIEPMSK_INEPNEM_Pos   = 0x6  // Position of INEPNEM field.
	USB_OTG_FS_FS_DIEPMSK_INEPNEM_Msk   = 0x40 // Bit mask of INEPNEM field.
	USB_OTG_FS_FS_DIEPMSK_INEPNEM       = 0x40 // Bit INEPNEM.

	// FS_DOEPMSK: OTG_FS device OUT endpoint common interrupt           mask register (OTG_FS_DOEPMSK)
	USB_OTG_FS_FS_DOEPMSK_XFRCM_Pos  = 0x0  // Position of XFRCM field.
	USB_OTG_FS_FS_DOEPMSK_XFRCM_Msk  = 0x1  // Bit mask of XFRCM field.
	USB_OTG_FS_FS_DOEPMSK_XFRCM      = 0x1  // Bit XFRCM.
	USB_OTG_FS_FS_DOEPMSK_EPDM_Pos   = 0x1  // Position of EPDM field.
	USB_OTG_FS_FS_DOEPMSK_EPDM_Msk   = 0x2  // Bit mask of EPDM field.
	USB_OTG_FS_FS_DOEPMSK_EPDM       = 0x2  // Bit EPDM.
	USB_OTG_FS_FS_DOEPMSK_STUPM_Pos  = 0x3  // Position of STUPM field.
	USB_OTG_FS_FS_DOEPMSK_STUPM_Msk  = 0x8  // Bit mask of STUPM field.
	USB_OTG_FS_FS_DOEPMSK_STUPM      = 0x8  // Bit STUPM.
	USB_OTG_FS_FS_DOEPMSK_OTEPDM_Pos = 0x4  // Position of OTEPDM field.
	USB_OTG_FS_FS_DOEPMSK_OTEPDM_Msk = 0x10 // Bit mask of OTEPDM field.
	USB_OTG_FS_FS_DOEPMSK_OTEPDM     = 0x10 // Bit OTEPDM.

	// FS_DAINT: OTG_FS device all endpoints interrupt           register (OTG_FS_DAINT)
	USB_OTG_FS_FS_DAINT_IEPINT_Pos = 0x0        // Position of IEPINT field.
	USB_OTG_FS_FS_DAINT_IEPINT_Msk = 0xffff     // Bit mask of IEPINT field.
	USB_OTG_FS_FS_DAINT_OEPINT_Pos = 0x10       // Position of OEPINT field.
	USB_OTG_FS_FS_DAINT_OEPINT_Msk = 0xffff0000 // Bit mask of OEPINT field.

	// FS_DAINTMSK: OTG_FS all endpoints interrupt mask register           (OTG_FS_DAINTMSK)
	USB_OTG_FS_FS_DAINTMSK_IEPM_Pos   = 0x0        // Position of IEPM field.
	USB_OTG_FS_FS_DAINTMSK_IEPM_Msk   = 0xffff     // Bit mask of IEPM field.
	USB_OTG_FS_FS_DAINTMSK_OEPINT_Pos = 0x10       // Position of OEPINT field.
	USB_OTG_FS_FS_DAINTMSK_OEPINT_Msk = 0xffff0000 // Bit mask of OEPINT field.

	// DVBUSDIS: OTG_FS device VBUS discharge time           register
	USB_OTG_FS_DVBUSDIS_VBUSDT_Pos = 0x0    // Position of VBUSDT field.
	USB_OTG_FS_DVBUSDIS_VBUSDT_Msk = 0xffff // Bit mask of VBUSDT field.

	// DVBUSPULSE: OTG_FS device VBUS pulsing time           register
	USB_OTG_FS_DVBUSPULSE_DVBUSP_Pos = 0x0   // Position of DVBUSP field.
	USB_OTG_FS_DVBUSPULSE_DVBUSP_Msk = 0xfff // Bit mask of DVBUSP field.

	// DIEPEMPMSK: OTG_FS device IN endpoint FIFO empty           interrupt mask register
	USB_OTG_FS_DIEPEMPMSK_INEPTXFEM_Pos = 0x0    // Position of INEPTXFEM field.
	USB_OTG_FS_DIEPEMPMSK_INEPTXFEM_Msk = 0xffff // Bit mask of INEPTXFEM field.

	// FS_DIEPCTL0: OTG_FS device control IN endpoint 0 control           register (OTG_FS_DIEPCTL0)
	USB_OTG_FS_FS_DIEPCTL0_MPSIZ_Pos  = 0x0        // Position of MPSIZ field.
	USB_OTG_FS_FS_DIEPCTL0_MPSIZ_Msk  = 0x3        // Bit mask of MPSIZ field.
	USB_OTG_FS_FS_DIEPCTL0_USBAEP_Pos = 0xf        // Position of USBAEP field.
	USB_OTG_FS_FS_DIEPCTL0_USBAEP_Msk = 0x8000     // Bit mask of USBAEP field.
	USB_OTG_FS_FS_DIEPCTL0_USBAEP     = 0x8000     // Bit USBAEP.
	USB_OTG_FS_FS_DIEPCTL0_NAKSTS_Pos = 0x11       // Position of NAKSTS field.
	USB_OTG_FS_FS_DIEPCTL0_NAKSTS_Msk = 0x20000    // Bit mask of NAKSTS field.
	USB_OTG_FS_FS_DIEPCTL0_NAKSTS     = 0x20000    // Bit NAKSTS.
	USB_OTG_FS_FS_DIEPCTL0_EPTYP_Pos  = 0x12       // Position of EPTYP field.
	USB_OTG_FS_FS_DIEPCTL0_EPTYP_Msk  = 0xc0000    // Bit mask of EPTYP field.
	USB_OTG_FS_FS_DIEPCTL0_STALL_Pos  = 0x15       // Position of STALL field.
	USB_OTG_FS_FS_DIEPCTL0_STALL_Msk  = 0x200000   // Bit mask of STALL field.
	USB_OTG_FS_FS_DIEPCTL0_STALL      = 0x200000   // Bit STALL.
	USB_OTG_FS_FS_DIEPCTL0_TXFNUM_Pos = 0x16       // Position of TXFNUM field.
	USB_OTG_FS_FS_DIEPCTL0_TXFNUM_Msk = 0x3c00000  // Bit mask of TXFNUM field.
	USB_OTG_FS_FS_DIEPCTL0_CNAK_Pos   = 0x1a       // Position of CNAK field.
	USB_OTG_FS_FS_DIEPCTL0_CNAK_Msk   = 0x4000000  // Bit mask of CNAK field.
	USB_OTG_FS_FS_DIEPCTL0_CNAK       = 0x4000000  // Bit CNAK.
	USB_OTG_FS_FS_DIEPCTL0_SNAK_Pos   = 0x1b       // Position of SNAK field.
	USB_OTG_FS_FS_DIEPCTL0_SNAK_Msk   = 0x8000000  // Bit mask of SNAK field.
	USB_OTG_FS_FS_DIEPCTL0_SNAK       = 0x8000000  // Bit SNAK.
	USB_OTG_FS_FS_DIEPCTL0_EPDIS_Pos  = 0x1e       // Position of EPDIS field.
	USB_OTG_FS_FS_DIEPCTL0_EPDIS_Msk  = 0x40000000 // Bit mask of EPDIS field.
	USB_OTG_FS_FS_DIEPCTL0_EPDIS      = 0x40000000 // Bit EPDIS.
	USB_OTG_FS_FS_DIEPCTL0_EPENA_Pos  = 0x1f       // Position of EPENA field.
	USB_OTG_FS_FS_DIEPCTL0_EPENA_Msk  = 0x80000000 // Bit mask of EPENA field.
	USB_OTG_FS_FS_DIEPCTL0_EPENA      = 0x80000000 // Bit EPENA.

	// DIEPINT0: device endpoint-x interrupt           register
	USB_OTG_FS_DIEPINT0_TXFE_Pos   = 0x7  // Position of TXFE field.
	USB_OTG_FS_DIEPINT0_TXFE_Msk   = 0x80 // Bit mask of TXFE field.
	USB_OTG_FS_DIEPINT0_TXFE       = 0x80 // Bit TXFE.
	USB_OTG_FS_DIEPINT0_INEPNE_Pos = 0x6  // Position of INEPNE field.
	USB_OTG_FS_DIEPINT0_INEPNE_Msk = 0x40 // Bit mask of INEPNE field.
	USB_OTG_FS_DIEPINT0_INEPNE     = 0x40 // Bit INEPNE.
	USB_OTG_FS_DIEPINT0_ITTXFE_Pos = 0x4  // Position of ITTXFE field.
	USB_OTG_FS_DIEPINT0_ITTXFE_Msk = 0x10 // Bit mask of ITTXFE field.
	USB_OTG_FS_DIEPINT0_ITTXFE     = 0x10 // Bit ITTXFE.
	USB_OTG_FS_DIEPINT0_TOC_Pos    = 0x3  // Position of TOC field.
	USB_OTG_FS_DIEPINT0_TOC_Msk    = 0x8  // Bit mask of TOC field.
	USB_OTG_FS_DIEPINT0_TOC        = 0x8  // Bit TOC.
	USB_OTG_FS_DIEPINT0_EPDISD_Pos = 0x1  // Position of EPDISD field.
	USB_OTG_FS_DIEPINT0_EPDISD_Msk = 0x2  // Bit mask of EPDISD field.
	USB_OTG_FS_DIEPINT0_EPDISD     = 0x2  // Bit EPDISD.
	USB_OTG_FS_DIEPINT0_XFRC_Pos   = 0x0  // Position of XFRC field.
	USB_OTG_FS_DIEPINT0_XFRC_Msk   = 0x1  // Bit mask of XFRC field.
	USB_OTG_FS_DIEPINT0_XFRC       = 0x1  // Bit XFRC.

	// DIEPTSIZ0: device endpoint-0 transfer size           register
	USB_OTG_FS_DIEPTSIZ0_PKTCNT_Pos = 0x13     // Position of PKTCNT field.
	USB_OTG_FS_DIEPTSIZ0_PKTCNT_Msk = 0x180000 // Bit mask of PKTCNT field.
	USB_OTG_FS_DIEPTSIZ0_XFRSIZ_Pos = 0x0      // Position of XFRSIZ field.
	USB_OTG_FS_DIEPTSIZ0_XFRSIZ_Msk = 0x7f     // Bit mask of XFRSIZ field.

	// DTXFSTS0: OTG_FS device IN endpoint transmit FIFO           status register
	USB_OTG_FS_DTXFSTS0_INEPTFSAV_Pos = 0x0    // Position of INEPTFSAV field.
	USB_OTG_FS_DTXFSTS0_INEPTFSAV_Msk = 0xffff // Bit mask of INEPTFSAV field.

	// DIEPCTL1: OTG device endpoint-1 control           register
	USB_OTG_FS_DIEPCTL1_EPENA_Pos          = 0x1f       // Position of EPENA field.
	USB_OTG_FS_DIEPCTL1_EPENA_Msk          = 0x80000000 // Bit mask of EPENA field.
	USB_OTG_FS_DIEPCTL1_EPENA              = 0x80000000 // Bit EPENA.
	USB_OTG_FS_DIEPCTL1_EPDIS_Pos          = 0x1e       // Position of EPDIS field.
	USB_OTG_FS_DIEPCTL1_EPDIS_Msk          = 0x40000000 // Bit mask of EPDIS field.
	USB_OTG_FS_DIEPCTL1_EPDIS              = 0x40000000 // Bit EPDIS.
	USB_OTG_FS_DIEPCTL1_SODDFRM_SD1PID_Pos = 0x1d       // Position of SODDFRM_SD1PID field.
	USB_OTG_FS_DIEPCTL1_SODDFRM_SD1PID_Msk = 0x20000000 // Bit mask of SODDFRM_SD1PID field.
	USB_OTG_FS_DIEPCTL1_SODDFRM_SD1PID     = 0x20000000 // Bit SODDFRM_SD1PID.
	USB_OTG_FS_DIEPCTL1_SD0PID_SEVNFRM_Pos = 0x1c       // Position of SD0PID_SEVNFRM field.
	USB_OTG_FS_DIEPCTL1_SD0PID_SEVNFRM_Msk = 0x10000000 // Bit mask of SD0PID_SEVNFRM field.
	USB_OTG_FS_DIEPCTL1_SD0PID_SEVNFRM     = 0x10000000 // Bit SD0PID_SEVNFRM.
	USB_OTG_FS_DIEPCTL1_SNAK_Pos           = 0x1b       // Position of SNAK field.
	USB_OTG_FS_DIEPCTL1_SNAK_Msk           = 0x8000000  // Bit mask of SNAK field.
	USB_OTG_FS_DIEPCTL1_SNAK               = 0x8000000  // Bit SNAK.
	USB_OTG_FS_DIEPCTL1_CNAK_Pos           = 0x1a       // Position of CNAK field.
	USB_OTG_FS_DIEPCTL1_CNAK_Msk           = 0x4000000  // Bit mask of CNAK field.
	USB_OTG_FS_DIEPCTL1_CNAK               = 0x4000000  // Bit CNAK.
	USB_OTG_FS_DIEPCTL1_TXFNUM_Pos         = 0x16       // Position of TXFNUM field.
	USB_OTG_FS_DIEPCTL1_TXFNUM_Msk         = 0x3c00000  // Bit mask of TXFNUM field.
	USB_OTG_FS_DIEPCTL1_Stall_Pos          = 0x15       // Position of Stall field.
	USB_OTG_FS_DIEPCTL1_Stall_Msk          = 0x200000   // Bit mask of Stall field.
	USB_OTG_FS_DIEPCTL1_Stall              = 0x200000   // Bit Stall.
	USB_OTG_FS_DIEPCTL1_EPTYP_Pos          = 0x12       // Position of EPTYP field.
	USB_OTG_FS_DIEPCTL1_EPTYP_Msk          = 0xc0000    // Bit mask of EPTYP field.
	USB_OTG_FS_DIEPCTL1_NAKSTS_Pos         = 0x11       // Position of NAKSTS field.
	USB_OTG_FS_DIEPCTL1_NAKSTS_Msk         = 0x20000    // Bit mask of NAKSTS field.
	USB_OTG_FS_DIEPCTL1_NAKSTS             = 0x20000    // Bit NAKSTS.
	USB_OTG_FS_DIEPCTL1_EONUM_DPID_Pos     = 0x10       // Position of EONUM_DPID field.
	USB_OTG_FS_DIEPCTL1_EONUM_DPID_Msk     = 0x10000    // Bit mask of EONUM_DPID field.
	USB_OTG_FS_DIEPCTL1_EONUM_DPID         = 0x10000    // Bit EONUM_DPID.
	USB_OTG_FS_DIEPCTL1_USBAEP_Pos         = 0xf        // Position of USBAEP field.
	USB_OTG_FS_DIEPCTL1_USBAEP_Msk         = 0x8000     // Bit mask of USBAEP field.
	USB_OTG_FS_DIEPCTL1_USBAEP             = 0x8000     // Bit USBAEP.
	USB_OTG_FS_DIEPCTL1_MPSIZ_Pos          = 0x0        // Position of MPSIZ field.
	USB_OTG_FS_DIEPCTL1_MPSIZ_Msk          = 0x7ff      // Bit mask of MPSIZ field.

	// DIEPINT1: device endpoint-1 interrupt           register
	USB_OTG_FS_DIEPINT1_TXFE_Pos   = 0x7  // Position of TXFE field.
	USB_OTG_FS_DIEPINT1_TXFE_Msk   = 0x80 // Bit mask of TXFE field.
	USB_OTG_FS_DIEPINT1_TXFE       = 0x80 // Bit TXFE.
	USB_OTG_FS_DIEPINT1_INEPNE_Pos = 0x6  // Position of INEPNE field.
	USB_OTG_FS_DIEPINT1_INEPNE_Msk = 0x40 // Bit mask of INEPNE field.
	USB_OTG_FS_DIEPINT1_INEPNE     = 0x40 // Bit INEPNE.
	USB_OTG_FS_DIEPINT1_ITTXFE_Pos = 0x4  // Position of ITTXFE field.
	USB_OTG_FS_DIEPINT1_ITTXFE_Msk = 0x10 // Bit mask of ITTXFE field.
	USB_OTG_FS_DIEPINT1_ITTXFE     = 0x10 // Bit ITTXFE.
	USB_OTG_FS_DIEPINT1_TOC_Pos    = 0x3  // Position of TOC field.
	USB_OTG_FS_DIEPINT1_TOC_Msk    = 0x8  // Bit mask of TOC field.
	USB_OTG_FS_DIEPINT1_TOC        = 0x8  // Bit TOC.
	USB_OTG_FS_DIEPINT1_EPDISD_Pos = 0x1  // Position of EPDISD field.
	USB_OTG_FS_DIEPINT1_EPDISD_Msk = 0x2  // Bit mask of EPDISD field.
	USB_OTG_FS_DIEPINT1_EPDISD     = 0x2  // Bit EPDISD.
	USB_OTG_FS_DIEPINT1_XFRC_Pos   = 0x0  // Position of XFRC field.
	USB_OTG_FS_DIEPINT1_XFRC_Msk   = 0x1  // Bit mask of XFRC field.
	USB_OTG_FS_DIEPINT1_XFRC       = 0x1  // Bit XFRC.

	// DIEPTSIZ1: device endpoint-1 transfer size           register
	USB_OTG_FS_DIEPTSIZ1_MCNT_Pos   = 0x1d       // Position of MCNT field.
	USB_OTG_FS_DIEPTSIZ1_MCNT_Msk   = 0x60000000 // Bit mask of MCNT field.
	USB_OTG_FS_DIEPTSIZ1_PKTCNT_Pos = 0x13       // Position of PKTCNT field.
	USB_OTG_FS_DIEPTSIZ1_PKTCNT_Msk = 0x1ff80000 // Bit mask of PKTCNT field.
	USB_OTG_FS_DIEPTSIZ1_XFRSIZ_Pos = 0x0        // Position of XFRSIZ field.
	USB_OTG_FS_DIEPTSIZ1_XFRSIZ_Msk = 0x7ffff    // Bit mask of XFRSIZ field.

	// DTXFSTS1: OTG_FS device IN endpoint transmit FIFO           status register
	USB_OTG_FS_DTXFSTS1_INEPTFSAV_Pos = 0x0    // Position of INEPTFSAV field.
	USB_OTG_FS_DTXFSTS1_INEPTFSAV_Msk = 0xffff // Bit mask of INEPTFSAV field.

	// DIEPCTL2: OTG device endpoint-2 control           register
	USB_OTG_FS_DIEPCTL2_EPENA_Pos          = 0x1f       // Position of EPENA field.
	USB_OTG_FS_DIEPCTL2_EPENA_Msk          = 0x80000000 // Bit mask of EPENA field.
	USB_OTG_FS_DIEPCTL2_EPENA              = 0x80000000 // Bit EPENA.
	USB_OTG_FS_DIEPCTL2_EPDIS_Pos          = 0x1e       // Position of EPDIS field.
	USB_OTG_FS_DIEPCTL2_EPDIS_Msk          = 0x40000000 // Bit mask of EPDIS field.
	USB_OTG_FS_DIEPCTL2_EPDIS              = 0x40000000 // Bit EPDIS.
	USB_OTG_FS_DIEPCTL2_SODDFRM_Pos        = 0x1d       // Position of SODDFRM field.
	USB_OTG_FS_DIEPCTL2_SODDFRM_Msk        = 0x20000000 // Bit mask of SODDFRM field.
	USB_OTG_FS_DIEPCTL2_SODDFRM            = 0x20000000 // Bit SODDFRM.
	USB_OTG_FS_DIEPCTL2_SD0PID_SEVNFRM_Pos = 0x1c       // Position of SD0PID_SEVNFRM field.
	USB_OTG_FS_DIEPCTL2_SD0PID_SEVNFRM_Msk = 0x10000000 // Bit mask of SD0PID_SEVNFRM field.
	USB_OTG_FS_DIEPCTL2_SD0PID_SEVNFRM     = 0x10000000 // Bit SD0PID_SEVNFRM.
	USB_OTG_FS_DIEPCTL2_SNAK_Pos           = 0x1b       // Position of SNAK field.
	USB_OTG_FS_DIEPCTL2_SNAK_Msk           = 0x8000000  // Bit mask of SNAK field.
	USB_OTG_FS_DIEPCTL2_SNAK               = 0x8000000  // Bit SNAK.
	USB_OTG_FS_DIEPCTL2_CNAK_Pos           = 0x1a       // Position of CNAK field.
	USB_OTG_FS_DIEPCTL2_CNAK_Msk           = 0x4000000  // Bit mask of CNAK field.
	USB_OTG_FS_DIEPCTL2_CNAK               = 0x4000000  // Bit CNAK.
	USB_OTG_FS_DIEPCTL2_TXFNUM_Pos         = 0x16       // Position of TXFNUM field.
	USB_OTG_FS_DIEPCTL2_TXFNUM_Msk         = 0x3c00000  // Bit mask of TXFNUM field.
	USB_OTG_FS_DIEPCTL2_Stall_Pos          = 0x15       // Position of Stall field.
	USB_OTG_FS_DIEPCTL2_Stall_Msk          = 0x200000   // Bit mask of Stall field.
	USB_OTG_FS_DIEPCTL2_Stall              = 0x200000   // Bit Stall.
	USB_OTG_FS_DIEPCTL2_EPTYP_Pos          = 0x12       // Position of EPTYP field.
	USB_OTG_FS_DIEPCTL2_EPTYP_Msk          = 0xc0000    // Bit mask of EPTYP field.
	USB_OTG_FS_DIEPCTL2_NAKSTS_Pos         = 0x11       // Position of NAKSTS field.
	USB_OTG_FS_DIEPCTL2_NAKSTS_Msk         = 0x20000    // Bit mask of NAKSTS field.
	USB_OTG_FS_DIEPCTL2_NAKSTS             = 0x20000    // Bit NAKSTS.
	USB_OTG_FS_DIEPCTL2_EONUM_DPID_Pos     = 0x10       // Position of EONUM_DPID field.
	USB_OTG_FS_DIEPCTL2_EONUM_DPID_Msk     = 0x10000    // Bit mask of EONUM_DPID field.
	USB_OTG_FS_DIEPCTL2_EONUM_DPID         = 0x10000    // Bit EONUM_DPID.
	USB_OTG_FS_DIEPCTL2_USBAEP_Pos         = 0xf        // Position of USBAEP field.
	USB_OTG_FS_DIEPCTL2_USBAEP_Msk         = 0x8000     // Bit mask of USBAEP field.
	USB_OTG_FS_DIEPCTL2_USBAEP             = 0x8000     // Bit USBAEP.
	USB_OTG_FS_DIEPCTL2_MPSIZ_Pos          = 0x0        // Position of MPSIZ field.
	USB_OTG_FS_DIEPCTL2_MPSIZ_Msk          = 0x7ff      // Bit mask of MPSIZ field.

	// DIEPINT2: device endpoint-2 interrupt           register
	USB_OTG_FS_DIEPINT2_TXFE_Pos   = 0x7  // Position of TXFE field.
	USB_OTG_FS_DIEPINT2_TXFE_Msk   = 0x80 // Bit mask of TXFE field.
	USB_OTG_FS_DIEPINT2_TXFE       = 0x80 // Bit TXFE.
	USB_OTG_FS_DIEPINT2_INEPNE_Pos = 0x6  // Position of INEPNE field.
	USB_OTG_FS_DIEPINT2_INEPNE_Msk = 0x40 // Bit mask of INEPNE field.
	USB_OTG_FS_DIEPINT2_INEPNE     = 0x40 // Bit INEPNE.
	USB_OTG_FS_DIEPINT2_ITTXFE_Pos = 0x4  // Position of ITTXFE field.
	USB_OTG_FS_DIEPINT2_ITTXFE_Msk = 0x10 // Bit mask of ITTXFE field.
	USB_OTG_FS_DIEPINT2_ITTXFE     = 0x10 // Bit ITTXFE.
	USB_OTG_FS_DIEPINT2_TOC_Pos    = 0x3  // Position of TOC field.
	USB_OTG_FS_DIEPINT2_TOC_Msk    = 0x8  // Bit mask of TOC field.
	USB_OTG_FS_DIEPINT2_TOC        = 0x8  // Bit TOC.
	USB_OTG_FS_DIEPINT2_EPDISD_Pos = 0x1  // Position of EPDISD field.
	USB_OTG_FS_DIEPINT2_EPDISD_Msk = 0x2  // Bit mask of EPDISD field.
	USB_OTG_FS_DIEPINT2_EPDISD     = 0x2  // Bit EPDISD.
	USB_OTG_FS_DIEPINT2_XFRC_Pos   = 0x0  // Position of XFRC field.
	USB_OTG_FS_DIEPINT2_XFRC_Msk   = 0x1  // Bit mask of XFRC field.
	USB_OTG_FS_DIEPINT2_XFRC       = 0x1  // Bit XFRC.

	// DIEPTSIZ2: device endpoint-2 transfer size           register
	USB_OTG_FS_DIEPTSIZ2_MCNT_Pos   = 0x1d       // Position of MCNT field.
	USB_OTG_FS_DIEPTSIZ2_MCNT_Msk   = 0x60000000 // Bit mask of MCNT field.
	USB_OTG_FS_DIEPTSIZ2_PKTCNT_Pos = 0x13       // Position of PKTCNT field.
	USB_OTG_FS_DIEPTSIZ2_PKTCNT_Msk = 0x1ff80000 // Bit mask of PKTCNT field.
	USB_OTG_FS_DIEPTSIZ2_XFRSIZ_Pos = 0x0        // Position of XFRSIZ field.
	USB_OTG_FS_DIEPTSIZ2_XFRSIZ_Msk = 0x7ffff    // Bit mask of XFRSIZ field.

	// DTXFSTS2: OTG_FS device IN endpoint transmit FIFO           status register
	USB_OTG_FS_DTXFSTS2_INEPTFSAV_Pos = 0x0    // Position of INEPTFSAV field.
	USB_OTG_FS_DTXFSTS2_INEPTFSAV_Msk = 0xffff // Bit mask of INEPTFSAV field.

	// DIEPCTL3: OTG device endpoint-3 control           register
	USB_OTG_FS_DIEPCTL3_EPENA_Pos          = 0x1f       // Position of EPENA field.
	USB_OTG_FS_DIEPCTL3_EPENA_Msk          = 0x80000000 // Bit mask of EPENA field.
	USB_OTG_FS_DIEPCTL3_EPENA              = 0x80000000 // Bit EPENA.
	USB_OTG_FS_DIEPCTL3_EPDIS_Pos          = 0x1e       // Position of EPDIS field.
	USB_OTG_FS_DIEPCTL3_EPDIS_Msk          = 0x40000000 // Bit mask of EPDIS field.
	USB_OTG_FS_DIEPCTL3_EPDIS              = 0x40000000 // Bit EPDIS.
	USB_OTG_FS_DIEPCTL3_SODDFRM_Pos        = 0x1d       // Position of SODDFRM field.
	USB_OTG_FS_DIEPCTL3_SODDFRM_Msk        = 0x20000000 // Bit mask of SODDFRM field.
	USB_OTG_FS_DIEPCTL3_SODDFRM            = 0x20000000 // Bit SODDFRM.
	USB_OTG_FS_DIEPCTL3_SD0PID_SEVNFRM_Pos = 0x1c       // Position of SD0PID_SEVNFRM field.
	USB_OTG_FS_DIEPCTL3_SD0PID_SEVNFRM_Msk = 0x10000000 // Bit mask of SD0PID_SEVNFRM field.
	USB_OTG_FS_DIEPCTL3_SD0PID_SEVNFRM     = 0x10000000 // Bit SD0PID_SEVNFRM.
	USB_OTG_FS_DIEPCTL3_SNAK_Pos           = 0x1b       // Position of SNAK field.
	USB_OTG_FS_DIEPCTL3_SNAK_Msk           = 0x8000000  // Bit mask of SNAK field.
	USB_OTG_FS_DIEPCTL3_SNAK               = 0x8000000  // Bit SNAK.
	USB_OTG_FS_DIEPCTL3_CNAK_Pos           = 0x1a       // Position of CNAK field.
	USB_OTG_FS_DIEPCTL3_CNAK_Msk           = 0x4000000  // Bit mask of CNAK field.
	USB_OTG_FS_DIEPCTL3_CNAK               = 0x4000000  // Bit CNAK.
	USB_OTG_FS_DIEPCTL3_TXFNUM_Pos         = 0x16       // Position of TXFNUM field.
	USB_OTG_FS_DIEPCTL3_TXFNUM_Msk         = 0x3c00000  // Bit mask of TXFNUM field.
	USB_OTG_FS_DIEPCTL3_Stall_Pos          = 0x15       // Position of Stall field.
	USB_OTG_FS_DIEPCTL3_Stall_Msk          = 0x200000   // Bit mask of Stall field.
	USB_OTG_FS_DIEPCTL3_Stall              = 0x200000   // Bit Stall.
	USB_OTG_FS_DIEPCTL3_EPTYP_Pos          = 0x12       // Position of EPTYP field.
	USB_OTG_FS_DIEPCTL3_EPTYP_Msk          = 0xc0000    // Bit mask of EPTYP field.
	USB_OTG_FS_DIEPCTL3_NAKSTS_Pos         = 0x11       // Position of NAKSTS field.
	USB_OTG_FS_DIEPCTL3_NAKSTS_Msk         = 0x20000    // Bit mask of NAKSTS field.
	USB_OTG_FS_DIEPCTL3_NAKSTS             = 0x20000    // Bit NAKSTS.
	USB_OTG_FS_DIEPCTL3_EONUM_DPID_Pos     = 0x10       // Position of EONUM_DPID field.
	USB_OTG_FS_DIEPCTL3_EONUM_DPID_Msk     = 0x10000    // Bit mask of EONUM_DPID field.
	USB_OTG_FS_DIEPCTL3_EONUM_DPID         = 0x10000    // Bit EONUM_DPID.
	USB_OTG_FS_DIEPCTL3_USBAEP_Pos         = 0xf        // Position of USBAEP field.
	USB_OTG_FS_DIEPCTL3_USBAEP_Msk         = 0x8000     // Bit mask of USBAEP field.
	USB_OTG_FS_DIEPCTL3_USBAEP             = 0x8000     // Bit USBAEP.
	USB_OTG_FS_DIEPCTL3_MPSIZ_Pos          = 0x0        // Position of MPSIZ field.
	USB_OTG_FS_DIEPCTL3_MPSIZ_Msk          = 0x7ff      // Bit mask of MPSIZ field.

	// DIEPINT3: device endpoint-3 interrupt           register
	USB_OTG_FS_DIEPINT3_TXFE_Pos   = 0x7  // Position of TXFE field.
	USB_OTG_FS_DIEPINT3_TXFE_Msk   = 0x80 // Bit mask of TXFE field.
	USB_OTG_FS_DIEPINT3_TXFE       = 0x80 // Bit TXFE.
	USB_OTG_FS_DIEPINT3_INEPNE_Pos = 0x6  // Position of INEPNE field.
	USB_OTG_FS_DIEPINT3_INEPNE_Msk = 0x40 // Bit mask of INEPNE field.
	USB_OTG_FS_DIEPINT3_INEPNE     = 0x40 // Bit INEPNE.
	USB_OTG_FS_DIEPINT3_ITTXFE_Pos = 0x4  // Position of ITTXFE field.
	USB_OTG_FS_DIEPINT3_ITTXFE_Msk = 0x10 // Bit mask of ITTXFE field.
	USB_OTG_FS_DIEPINT3_ITTXFE     = 0x10 // Bit ITTXFE.
	USB_OTG_FS_DIEPINT3_TOC_Pos    = 0x3  // Position of TOC field.
	USB_OTG_FS_DIEPINT3_TOC_Msk    = 0x8  // Bit mask of TOC field.
	USB_OTG_FS_DIEPINT3_TOC        = 0x8  // Bit TOC.
	USB_OTG_FS_DIEPINT3_EPDISD_Pos = 0x1  // Position of EPDISD field.
	USB_OTG_FS_DIEPINT3_EPDISD_Msk = 0x2  // Bit mask of EPDISD field.
	USB_OTG_FS_DIEPINT3_EPDISD     = 0x2  // Bit EPDISD.
	USB_OTG_FS_DIEPINT3_XFRC_Pos   = 0x0  // Position of XFRC field.
	USB_OTG_FS_DIEPINT3_XFRC_Msk   = 0x1  // Bit mask of XFRC field.
	USB_OTG_FS_DIEPINT3_XFRC       = 0x1  // Bit XFRC.

	// DIEPTSIZ3: device endpoint-3 transfer size           register
	USB_OTG_FS_DIEPTSIZ3_MCNT_Pos   = 0x1d       // Position of MCNT field.
	USB_OTG_FS_DIEPTSIZ3_MCNT_Msk   = 0x60000000 // Bit mask of MCNT field.
	USB_OTG_FS_DIEPTSIZ3_PKTCNT_Pos = 0x13       // Position of PKTCNT field.
	USB_OTG_FS_DIEPTSIZ3_PKTCNT_Msk = 0x1ff80000 // Bit mask of PKTCNT field.
	USB_OTG_FS_DIEPTSIZ3_XFRSIZ_Pos = 0x0        // Position of XFRSIZ field.
	USB_OTG_FS_DIEPTSIZ3_XFRSIZ_Msk = 0x7ffff    // Bit mask of XFRSIZ field.

	// DTXFSTS3: OTG_FS device IN endpoint transmit FIFO           status register
	USB_OTG_FS_DTXFSTS3_INEPTFSAV_Pos = 0x0    // Position of INEPTFSAV field.
	USB_OTG_FS_DTXFSTS3_INEPTFSAV_Msk = 0xffff // Bit mask of INEPTFSAV field.

	// DOEPCTL0: device endpoint-0 control           register
	USB_OTG_FS_DOEPCTL0_EPENA_Pos  = 0x1f       // Position of EPENA field.
	USB_OTG_FS_DOEPCTL0_EPENA_Msk  = 0x80000000 // Bit mask of EPENA field.
	USB_OTG_FS_DOEPCTL0_EPENA      = 0x80000000 // Bit EPENA.
	USB_OTG_FS_DOEPCTL0_EPDIS_Pos  = 0x1e       // Position of EPDIS field.
	USB_OTG_FS_DOEPCTL0_EPDIS_Msk  = 0x40000000 // Bit mask of EPDIS field.
	USB_OTG_FS_DOEPCTL0_EPDIS      = 0x40000000 // Bit EPDIS.
	USB_OTG_FS_DOEPCTL0_SNAK_Pos   = 0x1b       // Position of SNAK field.
	USB_OTG_FS_DOEPCTL0_SNAK_Msk   = 0x8000000  // Bit mask of SNAK field.
	USB_OTG_FS_DOEPCTL0_SNAK       = 0x8000000  // Bit SNAK.
	USB_OTG_FS_DOEPCTL0_CNAK_Pos   = 0x1a       // Position of CNAK field.
	USB_OTG_FS_DOEPCTL0_CNAK_Msk   = 0x4000000  // Bit mask of CNAK field.
	USB_OTG_FS_DOEPCTL0_CNAK       = 0x4000000  // Bit CNAK.
	USB_OTG_FS_DOEPCTL0_Stall_Pos  = 0x15       // Position of Stall field.
	USB_OTG_FS_DOEPCTL0_Stall_Msk  = 0x200000   // Bit mask of Stall field.
	USB_OTG_FS_DOEPCTL0_Stall      = 0x200000   // Bit Stall.
	USB_OTG_FS_DOEPCTL0_SNPM_Pos   = 0x14       // Position of SNPM field.
	USB_OTG_FS_DOEPCTL0_SNPM_Msk   = 0x100000   // Bit mask of SNPM field.
	USB_OTG_FS_DOEPCTL0_SNPM       = 0x100000   // Bit SNPM.
	USB_OTG_FS_DOEPCTL0_EPTYP_Pos  = 0x12       // Position of EPTYP field.
	USB_OTG_FS_DOEPCTL0_EPTYP_Msk  = 0xc0000    // Bit mask of EPTYP field.
	USB_OTG_FS_DOEPCTL0_NAKSTS_Pos = 0x11       // Position of NAKSTS field.
	USB_OTG_FS_DOEPCTL0_NAKSTS_Msk = 0x20000    // Bit mask of NAKSTS field.
	USB_OTG_FS_DOEPCTL0_NAKSTS     = 0x20000    // Bit NAKSTS.
	USB_OTG_FS_DOEPCTL0_USBAEP_Pos = 0xf        // Position of USBAEP field.
	USB_OTG_FS_DOEPCTL0_USBAEP_Msk = 0x8000     // Bit mask of USBAEP field.
	USB_OTG_FS_DOEPCTL0_USBAEP     = 0x8000     // Bit USBAEP.
	USB_OTG_FS_DOEPCTL0_MPSIZ_Pos  = 0x0        // Position of MPSIZ field.
	USB_OTG_FS_DOEPCTL0_MPSIZ_Msk  = 0x3        // Bit mask of MPSIZ field.

	// DOEPINT0: device endpoint-0 interrupt           register
	USB_OTG_FS_DOEPINT0_B2BSTUP_Pos = 0x6  // Position of B2BSTUP field.
	USB_OTG_FS_DOEPINT0_B2BSTUP_Msk = 0x40 // Bit mask of B2BSTUP field.
	USB_OTG_FS_DOEPINT0_B2BSTUP     = 0x40 // Bit B2BSTUP.
	USB_OTG_FS_DOEPINT0_OTEPDIS_Pos = 0x4  // Position of OTEPDIS field.
	USB_OTG_FS_DOEPINT0_OTEPDIS_Msk = 0x10 // Bit mask of OTEPDIS field.
	USB_OTG_FS_DOEPINT0_OTEPDIS     = 0x10 // Bit OTEPDIS.
	USB_OTG_FS_DOEPINT0_STUP_Pos    = 0x3  // Position of STUP field.
	USB_OTG_FS_DOEPINT0_STUP_Msk    = 0x8  // Bit mask of STUP field.
	USB_OTG_FS_DOEPINT0_STUP        = 0x8  // Bit STUP.
	USB_OTG_FS_DOEPINT0_EPDISD_Pos  = 0x1  // Position of EPDISD field.
	USB_OTG_FS_DOEPINT0_EPDISD_Msk  = 0x2  // Bit mask of EPDISD field.
	USB_OTG_FS_DOEPINT0_EPDISD      = 0x2  // Bit EPDISD.
	USB_OTG_FS_DOEPINT0_XFRC_Pos    = 0x0  // Position of XFRC field.
	USB_OTG_FS_DOEPINT0_XFRC_Msk    = 0x1  // Bit mask of XFRC field.
	USB_OTG_FS_DOEPINT0_XFRC        = 0x1  // Bit XFRC.

	// DOEPTSIZ0: device OUT endpoint-0 transfer size           register
	USB_OTG_FS_DOEPTSIZ0_STUPCNT_Pos = 0x1d       // Position of STUPCNT field.
	USB_OTG_FS_DOEPTSIZ0_STUPCNT_Msk = 0x60000000 // Bit mask of STUPCNT field.
	USB_OTG_FS_DOEPTSIZ0_PKTCNT_Pos  = 0x13       // Position of PKTCNT field.
	USB_OTG_FS_DOEPTSIZ0_PKTCNT_Msk  = 0x80000    // Bit mask of PKTCNT field.
	USB_OTG_FS_DOEPTSIZ0_PKTCNT      = 0x80000    // Bit PKTCNT.
	USB_OTG_FS_DOEPTSIZ0_XFRSIZ_Pos  = 0x0        // Position of XFRSIZ field.
	USB_OTG_FS_DOEPTSIZ0_XFRSIZ_Msk  = 0x7f       // Bit mask of XFRSIZ field.

	// DOEPCTL1: device endpoint-1 control           register
	USB_OTG_FS_DOEPCTL1_EPENA_Pos          = 0x1f       // Position of EPENA field.
	USB_OTG_FS_DOEPCTL1_EPENA_Msk          = 0x80000000 // Bit mask of EPENA field.
	USB_OTG_FS_DOEPCTL1_EPENA              = 0x80000000 // Bit EPENA.
	USB_OTG_FS_DOEPCTL1_EPDIS_Pos          = 0x1e       // Position of EPDIS field.
	USB_OTG_FS_DOEPCTL1_EPDIS_Msk          = 0x40000000 // Bit mask of EPDIS field.
	USB_OTG_FS_DOEPCTL1_EPDIS              = 0x40000000 // Bit EPDIS.
	USB_OTG_FS_DOEPCTL1_SODDFRM_Pos        = 0x1d       // Position of SODDFRM field.
	USB_OTG_FS_DOEPCTL1_SODDFRM_Msk        = 0x20000000 // Bit mask of SODDFRM field.
	USB_OTG_FS_DOEPCTL1_SODDFRM            = 0x20000000 // Bit SODDFRM.
	USB_OTG_FS_DOEPCTL1_SD0PID_SEVNFRM_Pos = 0x1c       // Position of SD0PID_SEVNFRM field.
	USB_OTG_FS_DOEPCTL1_SD0PID_SEVNFRM_Msk = 0x10000000 // Bit mask of SD0PID_SEVNFRM field.
	USB_OTG_FS_DOEPCTL1_SD0PID_SEVNFRM     = 0x10000000 // Bit SD0PID_SEVNFRM.
	USB_OTG_FS_DOEPCTL1_SNAK_Pos           = 0x1b       // Position of SNAK field.
	USB_OTG_FS_DOEPCTL1_SNAK_Msk           = 0x8000000  // Bit mask of SNAK field.
	USB_OTG_FS_DOEPCTL1_SNAK               = 0x8000000  // Bit SNAK.
	USB_OTG_FS_DOEPCTL1_CNAK_Pos           = 0x1a       // Position of CNAK field.
	USB_OTG_FS_DOEPCTL1_CNAK_Msk           = 0x4000000  // Bit mask of CNAK field.
	USB_OTG_FS_DOEPCTL1_CNAK               = 0x4000000  // Bit CNAK.
	USB_OTG_FS_DOEPCTL1_Stall_Pos          = 0x15       // Position of Stall field.
	USB_OTG_FS_DOEPCTL1_Stall_Msk          = 0x200000   // Bit mask of Stall field.
	USB_OTG_FS_DOEPCTL1_Stall              = 0x200000   // Bit Stall.
	USB_OTG_FS_DOEPCTL1_SNPM_Pos           = 0x14       // Position of SNPM field.
	USB_OTG_FS_DOEPCTL1_SNPM_Msk           = 0x100000   // Bit mask of SNPM field.
	USB_OTG_FS_DOEPCTL1_SNPM               = 0x100000   // Bit SNPM.
	USB_OTG_FS_DOEPCTL1_EPTYP_Pos          = 0x12       // Position of EPTYP field.
	USB_OTG_FS_DOEPCTL1_EPTYP_Msk          = 0xc0000    // Bit mask of EPTYP field.
	USB_OTG_FS_DOEPCTL1_NAKSTS_Pos         = 0x11       // Position of NAKSTS field.
	USB_OTG_FS_DOEPCTL1_NAKSTS_Msk         = 0x20000    // Bit mask of NAKSTS field.
	USB_OTG_FS_DOEPCTL1_NAKSTS             = 0x20000    // Bit NAKSTS.
	USB_OTG_FS_DOEPCTL1_EONUM_DPID_Pos     = 0x10       // Position of EONUM_DPID field.
	USB_OTG_FS_DOEPCTL1_EONUM_DPID_Msk     = 0x10000    // Bit mask of EONUM_DPID field.
	USB_OTG_FS_DOEPCTL1_EONUM_DPID         = 0x10000    // Bit EONUM_DPID.
	USB_OTG_FS_DOEPCTL1_USBAEP_Pos         = 0xf        // Position of USBAEP field.
	USB_OTG_FS_DOEPCTL1_USBAEP_Msk         = 0x8000     // Bit mask of USBAEP field.
	USB_OTG_FS_DOEPCTL1_USBAEP             = 0x8000     // Bit USBAEP.
	USB_OTG_FS_DOEPCTL1_MPSIZ_Pos          = 0x0        // Position of MPSIZ field.
	USB_OTG_FS_DOEPCTL1_MPSIZ_Msk          = 0x7ff      // Bit mask of MPSIZ field.

	// DOEPINT1: device endpoint-1 interrupt           register
	USB_OTG_FS_DOEPINT1_B2BSTUP_Pos = 0x6  // Position of B2BSTUP field.
	USB_OTG_FS_DOEPINT1_B2BSTUP_Msk = 0x40 // Bit mask of B2BSTUP field.
	USB_OTG_FS_DOEPINT1_B2BSTUP     = 0x40 // Bit B2BSTUP.
	USB_OTG_FS_DOEPINT1_OTEPDIS_Pos = 0x4  // Position of OTEPDIS field.
	USB_OTG_FS_DOEPINT1_OTEPDIS_Msk = 0x10 // Bit mask of OTEPDIS field.
	USB_OTG_FS_DOEPINT1_OTEPDIS     = 0x10 // Bit OTEPDIS.
	USB_OTG_FS_DOEPINT1_STUP_Pos    = 0x3  // Position of STUP field.
	USB_OTG_FS_DOEPINT1_STUP_Msk    = 0x8  // Bit mask of STUP field.
	USB_OTG_FS_DOEPINT1_STUP        = 0x8  // Bit STUP.
	USB_OTG_FS_DOEPINT1_EPDISD_Pos  = 0x1  // Position of EPDISD field.
	USB_OTG_FS_DOEPINT1_EPDISD_Msk  = 0x2  // Bit mask of EPDISD field.
	USB_OTG_FS_DOEPINT1_EPDISD      = 0x2  // Bit EPDISD.
	USB_OTG_FS_DOEPINT1_XFRC_Pos    = 0x0  // Position of XFRC field.
	USB_OTG_FS_DOEPINT1_XFRC_Msk    = 0x1  // Bit mask of XFRC field.
	USB_OTG_FS_DOEPINT1_XFRC        = 0x1  // Bit XFRC.

	// DOEPTSIZ1: device OUT endpoint-1 transfer size           register
	USB_OTG_FS_DOEPTSIZ1_RXDPID_STUPCNT_Pos = 0x1d       // Position of RXDPID_STUPCNT field.
	USB_OTG_FS_DOEPTSIZ1_RXDPID_STUPCNT_Msk = 0x60000000 // Bit mask of RXDPID_STUPCNT field.
	USB_OTG_FS_DOEPTSIZ1_PKTCNT_Pos         = 0x13       // Position of PKTCNT field.
	USB_OTG_FS_DOEPTSIZ1_PKTCNT_Msk         = 0x1ff80000 // Bit mask of PKTCNT field.
	USB_OTG_FS_DOEPTSIZ1_XFRSIZ_Pos         = 0x0        // Position of XFRSIZ field.
	USB_OTG_FS_DOEPTSIZ1_XFRSIZ_Msk         = 0x7ffff    // Bit mask of XFRSIZ field.

	// DOEPCTL2: device endpoint-2 control           register
	USB_OTG_FS_DOEPCTL2_EPENA_Pos          = 0x1f       // Position of EPENA field.
	USB_OTG_FS_DOEPCTL2_EPENA_Msk          = 0x80000000 // Bit mask of EPENA field.
	USB_OTG_FS_DOEPCTL2_EPENA              = 0x80000000 // Bit EPENA.
	USB_OTG_FS_DOEPCTL2_EPDIS_Pos          = 0x1e       // Position of EPDIS field.
	USB_OTG_FS_DOEPCTL2_EPDIS_Msk          = 0x40000000 // Bit mask of EPDIS field.
	USB_OTG_FS_DOEPCTL2_EPDIS              = 0x40000000 // Bit EPDIS.
	USB_OTG_FS_DOEPCTL2_SODDFRM_Pos        = 0x1d       // Position of SODDFRM field.
	USB_OTG_FS_DOEPCTL2_SODDFRM_Msk        = 0x20000000 // Bit mask of SODDFRM field.
	USB_OTG_FS_DOEPCTL2_SODDFRM            = 0x20000000 // Bit SODDFRM.
	USB_OTG_FS_DOEPCTL2_SD0PID_SEVNFRM_Pos = 0x1c       // Position of SD0PID_SEVNFRM field.
	USB_OTG_FS_DOEPCTL2_SD0PID_SEVNFRM_Msk = 0x10000000 // Bit mask of SD0PID_SEVNFRM field.
	USB_OTG_FS_DOEPCTL2_SD0PID_SEVNFRM     = 0x10000000 // Bit SD0PID_SEVNFRM.
	USB_OTG_FS_DOEPCTL2_SNAK_Pos           = 0x1b       // Position of SNAK field.
	USB_OTG_FS_DOEPCTL2_SNAK_Msk           = 0x8000000  // Bit mask of SNAK field.
	USB_OTG_FS_DOEPCTL2_SNAK               = 0x8000000  // Bit SNAK.
	USB_OTG_FS_DOEPCTL2_CNAK_Pos           = 0x1a       // Position of CNAK field.
	USB_OTG_FS_DOEPCTL2_CNAK_Msk           = 0x4000000  // Bit mask of CNAK field.
	USB_OTG_FS_DOEPCTL2_CNAK               = 0x4000000  // Bit CNAK.
	USB_OTG_FS_DOEPCTL2_Stall_Pos          = 0x15       // Position of Stall field.
	USB_OTG_FS_DOEPCTL2_Stall_Msk          = 0x200000   // Bit mask of Stall field.
	USB_OTG_FS_DOEPCTL2_Stall              = 0x200000   // Bit Stall.
	USB_OTG_FS_DOEPCTL2_SNPM_Pos           = 0x14       // Position of SNPM field.
	USB_OTG_FS_DOEPCTL2_SNPM_Msk           = 0x100000   // Bit mask of SNPM field.
	USB_OTG_FS_DOEPCTL2_SNPM               = 0x100000   // Bit SNPM.
	USB_OTG_FS_DOEPCTL2_EPTYP_Pos          = 0x12       // Position of EPTYP field.
	USB_OTG_FS_DOEPCTL2_EPTYP_Msk          = 0xc0000    // Bit mask of EPTYP field.
	USB_OTG_FS_DOEPCTL2_NAKSTS_Pos         = 0x11       // Position of NAKSTS field.
	USB_OTG_FS_DOEPCTL2_NAKSTS_Msk         = 0x20000    // Bit mask of NAKSTS field.
	USB_OTG_FS_DOEPCTL2_NAKSTS             = 0x20000    // Bit NAKSTS.
	USB_OTG_FS_DOEPCTL2_EONUM_DPID_Pos     = 0x10       // Position of EONUM_DPID field.
	USB_OTG_FS_DOEPCTL2_EONUM_DPID_Msk     = 0x10000    // Bit mask of EONUM_DPID field.
	USB_OTG_FS_DOEPCTL2_EONUM_DPID         = 0x10000    // Bit EONUM_DPID.
	USB_OTG_FS_DOEPCTL2_USBAEP_Pos         = 0xf        // Position of USBAEP field.
	USB_OTG_FS_DOEPCTL2_USBAEP_Msk         = 0x8000     // Bit mask of USBAEP field.
	USB_OTG_FS_DOEPCTL2_USBAEP             = 0x8000     // Bit USBAEP.
	USB_OTG_FS_DOEPCTL2_MPSIZ_Pos          = 0x0        // Position of MPSIZ field.
	USB_OTG_FS_DOEPCTL2_MPSIZ_Msk          = 0x7ff      // Bit mask of MPSIZ field.

	// DOEPINT2: device endpoint-2 interrupt           register
	USB_OTG_FS_DOEPINT2_B2BSTUP_Pos = 0x6  // Position of B2BSTUP field.
	USB_OTG_FS_DOEPINT2_B2BSTUP_Msk = 0x40 // Bit mask of B2BSTUP field.
	USB_OTG_FS_DOEPINT2_B2BSTUP     = 0x40 // Bit B2BSTUP.
	USB_OTG_FS_DOEPINT2_OTEPDIS_Pos = 0x4  // Position of OTEPDIS field.
	USB_OTG_FS_DOEPINT2_OTEPDIS_Msk = 0x10 // Bit mask of OTEPDIS field.
	USB_OTG_FS_DOEPINT2_OTEPDIS     = 0x10 // Bit OTEPDIS.
	USB_OTG_FS_DOEPINT2_STUP_Pos    = 0x3  // Position of STUP field.
	USB_OTG_FS_DOEPINT2_STUP_Msk    = 0x8  // Bit mask of STUP field.
	USB_OTG_FS_DOEPINT2_STUP        = 0x8  // Bit STUP.
	USB_OTG_FS_DOEPINT2_EPDISD_Pos  = 0x1  // Position of EPDISD field.
	USB_OTG_FS_DOEPINT2_EPDISD_Msk  = 0x2  // Bit mask of EPDISD field.
	USB_OTG_FS_DOEPINT2_EPDISD      = 0x2  // Bit EPDISD.
	USB_OTG_FS_DOEPINT2_XFRC_Pos    = 0x0  // Position of XFRC field.
	USB_OTG_FS_DOEPINT2_XFRC_Msk    = 0x1  // Bit mask of XFRC field.
	USB_OTG_FS_DOEPINT2_XFRC        = 0x1  // Bit XFRC.

	// DOEPTSIZ2: device OUT endpoint-2 transfer size           register
	USB_OTG_FS_DOEPTSIZ2_RXDPID_STUPCNT_Pos = 0x1d       // Position of RXDPID_STUPCNT field.
	USB_OTG_FS_DOEPTSIZ2_RXDPID_STUPCNT_Msk = 0x60000000 // Bit mask of RXDPID_STUPCNT field.
	USB_OTG_FS_DOEPTSIZ2_PKTCNT_Pos         = 0x13       // Position of PKTCNT field.
	USB_OTG_FS_DOEPTSIZ2_PKTCNT_Msk         = 0x1ff80000 // Bit mask of PKTCNT field.
	USB_OTG_FS_DOEPTSIZ2_XFRSIZ_Pos         = 0x0        // Position of XFRSIZ field.
	USB_OTG_FS_DOEPTSIZ2_XFRSIZ_Msk         = 0x7ffff    // Bit mask of XFRSIZ field.

	// DOEPCTL3: device endpoint-3 control           register
	USB_OTG_FS_DOEPCTL3_EPENA_Pos          = 0x1f       // Position of EPENA field.
	USB_OTG_FS_DOEPCTL3_EPENA_Msk          = 0x80000000 // Bit mask of EPENA field.
	USB_OTG_FS_DOEPCTL3_EPENA              = 0x80000000 // Bit EPENA.
	USB_OTG_FS_DOEPCTL3_EPDIS_Pos          = 0x1e       // Position of EPDIS field.
	USB_OTG_FS_DOEPCTL3_EPDIS_Msk          = 0x40000000 // Bit mask of EPDIS field.
	USB_OTG_FS_DOEPCTL3_EPDIS              = 0x40000000 // Bit EPDIS.
	USB_OTG_FS_DOEPCTL3_SODDFRM_Pos        = 0x1d       // Position of SODDFRM field.
	USB_OTG_FS_DOEPCTL3_SODDFRM_Msk        = 0x20000000 // Bit mask of SODDFRM field.
	USB_OTG_FS_DOEPCTL3_SODDFRM            = 0x20000000 // Bit SODDFRM.
	USB_OTG_FS_DOEPCTL3_SD0PID_SEVNFRM_Pos = 0x1c       // Position of SD0PID_SEVNFRM field.
	USB_OTG_FS_DOEPCTL3_SD0PID_SEVNFRM_Msk = 0x10000000 // Bit mask of SD0PID_SEVNFRM field.
	USB_OTG_FS_DOEPCTL3_SD0PID_SEVNFRM     = 0x10000000 // Bit SD0PID_SEVNFRM.
	USB_OTG_FS_DOEPCTL3_SNAK_Pos           = 0x1b       // Position of SNAK field.
	USB_OTG_FS_DOEPCTL3_SNAK_Msk           = 0x8000000  // Bit mask of SNAK field.
	USB_OTG_FS_DOEPCTL3_SNAK               = 0x8000000  // Bit SNAK.
	USB_OTG_FS_DOEPCTL3_CNAK_Pos           = 0x1a       // Position of CNAK field.
	USB_OTG_FS_DOEPCTL3_CNAK_Msk           = 0x4000000  // Bit mask of CNAK field.
	USB_OTG_FS_DOEPCTL3_CNAK               = 0x4000000  // Bit CNAK.
	USB_OTG_FS_DOEPCTL3_Stall_Pos          = 0x15       // Position of Stall field.
	USB_OTG_FS_DOEPCTL3_Stall_Msk          = 0x200000   // Bit mask of Stall field.
	USB_OTG_FS_DOEPCTL3_Stall              = 0x200000   // Bit Stall.
	USB_OTG_FS_DOEPCTL3_SNPM_Pos           = 0x14       // Position of SNPM field.
	USB_OTG_FS_DOEPCTL3_SNPM_Msk           = 0x100000   // Bit mask of SNPM field.
	USB_OTG_FS_DOEPCTL3_SNPM               = 0x100000   // Bit SNPM.
	USB_OTG_FS_DOEPCTL3_EPTYP_Pos          = 0x12       // Position of EPTYP field.
	USB_OTG_FS_DOEPCTL3_EPTYP_Msk          = 0xc0000    // Bit mask of EPTYP field.
	USB_OTG_FS_DOEPCTL3_NAKSTS_Pos         = 0x11       // Position of NAKSTS field.
	USB_OTG_FS_DOEPCTL3_NAKSTS_Msk         = 0x20000    // Bit mask of NAKSTS field.
	USB_OTG_FS_DOEPCTL3_NAKSTS             = 0x20000    // Bit NAKSTS.
	USB_OTG_FS_DOEPCTL3_EONUM_DPID_Pos     = 0x10       // Position of EONUM_DPID field.
	USB_OTG_FS_DOEPCTL3_EONUM_DPID_Msk     = 0x10000    // Bit mask of EONUM_DPID field.
	USB_OTG_FS_DOEPCTL3_EONUM_DPID         = 0x10000    // Bit EONUM_DPID.
	USB_OTG_FS_DOEPCTL3_USBAEP_Pos         = 0xf        // Position of USBAEP field.
	USB_OTG_FS_DOEPCTL3_USBAEP_Msk         = 0x8000     // Bit mask of USBAEP field.
	USB_OTG_FS_DOEPCTL3_USBAEP             = 0x8000     // Bit USBAEP.
	USB_OTG_FS_DOEPCTL3_MPSIZ_Pos          = 0x0        // Position of MPSIZ field.
	USB_OTG_FS_DOEPCTL3_MPSIZ_Msk          = 0x7ff      // Bit mask of MPSIZ field.

	// DOEPINT3: device endpoint-3 interrupt           register
	USB_OTG_FS_DOEPINT3_B2BSTUP_Pos = 0x6  // Position of B2BSTUP field.
	USB_OTG_FS_DOEPINT3_B2BSTUP_Msk = 0x40 // Bit mask of B2BSTUP field.
	USB_OTG_FS_DOEPINT3_B2BSTUP     = 0x40 // Bit B2BSTUP.
	USB_OTG_FS_DOEPINT3_OTEPDIS_Pos = 0x4  // Position of OTEPDIS field.
	USB_OTG_FS_DOEPINT3_OTEPDIS_Msk = 0x10 // Bit mask of OTEPDIS field.
	USB_OTG_FS_DOEPINT3_OTEPDIS     = 0x10 // Bit OTEPDIS.
	USB_OTG_FS_DOEPINT3_STUP_Pos    = 0x3  // Position of STUP field.
	USB_OTG_FS_DOEPINT3_STUP_Msk    = 0x8  // Bit mask of STUP field.
	USB_OTG_FS_DOEPINT3_STUP        = 0x8  // Bit STUP.
	USB_OTG_FS_DOEPINT3_EPDISD_Pos  = 0x1  // Position of EPDISD field.
	USB_OTG_FS_DOEPINT3_EPDISD_Msk  = 0x2  // Bit mask of EPDISD field.
	USB_OTG_FS_DOEPINT3_EPDISD      = 0x2  // Bit EPDISD.
	USB_OTG_FS_DOEPINT3_XFRC_Pos    = 0x0  // Position of XFRC field.
	USB_OTG_FS_DOEPINT3_XFRC_Msk    = 0x1  // Bit mask of XFRC field.
	USB_OTG_FS_DOEPINT3_XFRC        = 0x1  // Bit XFRC.

	// DOEPTSIZ3: device OUT endpoint-3 transfer size           register
	USB_OTG_FS_DOEPTSIZ3_RXDPID_STUPCNT_Pos = 0x1d       // Position of RXDPID_STUPCNT field.
	USB_OTG_FS_DOEPTSIZ3_RXDPID_STUPCNT_Msk = 0x60000000 // Bit mask of RXDPID_STUPCNT field.
	USB_OTG_FS_DOEPTSIZ3_PKTCNT_Pos         = 0x13       // Position of PKTCNT field.
	USB_OTG_FS_DOEPTSIZ3_PKTCNT_Msk         = 0x1ff80000 // Bit mask of PKTCNT field.
	USB_OTG_FS_DOEPTSIZ3_XFRSIZ_Pos         = 0x0        // Position of XFRSIZ field.
	USB_OTG_FS_DOEPTSIZ3_XFRSIZ_Msk         = 0x7ffff    // Bit mask of XFRSIZ field.
)

// Bitfields for PWR: Power control
const (
	// CR: power control register
	PWR_CR_VOS_Pos    = 0xe    // Position of VOS field.
	PWR_CR_VOS_Msk    = 0xc000 // Bit mask of VOS field.
	PWR_CR_ADCDC1_Pos = 0xd    // Position of ADCDC1 field.
	PWR_CR_ADCDC1_Msk = 0x2000 // Bit mask of ADCDC1 field.
	PWR_CR_ADCDC1     = 0x2000 // Bit ADCDC1.
	PWR_CR_FPDS_Pos   = 0x9    // Position of FPDS field.
	PWR_CR_FPDS_Msk   = 0x200  // Bit mask of FPDS field.
	PWR_CR_FPDS       = 0x200  // Bit FPDS.
	PWR_CR_DBP_Pos    = 0x8    // Position of DBP field.
	PWR_CR_DBP_Msk    = 0x100  // Bit mask of DBP field.
	PWR_CR_DBP        = 0x100  // Bit DBP.
	PWR_CR_PLS_Pos    = 0x5    // Position of PLS field.
	PWR_CR_PLS_Msk    = 0xe0   // Bit mask of PLS field.
	PWR_CR_PVDE_Pos   = 0x4    // Position of PVDE field.
	PWR_CR_PVDE_Msk   = 0x10   // Bit mask of PVDE field.
	PWR_CR_PVDE       = 0x10   // Bit PVDE.
	PWR_CR_CSBF_Pos   = 0x3    // Position of CSBF field.
	PWR_CR_CSBF_Msk   = 0x8    // Bit mask of CSBF field.
	PWR_CR_CSBF       = 0x8    // Bit CSBF.
	PWR_CR_CWUF_Pos   = 0x2    // Position of CWUF field.
	PWR_CR_CWUF_Msk   = 0x4    // Bit mask of CWUF field.
	PWR_CR_CWUF       = 0x4    // Bit CWUF.
	PWR_CR_PDDS_Pos   = 0x1    // Position of PDDS field.
	PWR_CR_PDDS_Msk   = 0x2    // Bit mask of PDDS field.
	PWR_CR_PDDS       = 0x2    // Bit PDDS.
	PWR_CR_LPDS_Pos   = 0x0    // Position of LPDS field.
	PWR_CR_LPDS_Msk   = 0x1    // Bit mask of LPDS field.
	PWR_CR_LPDS       = 0x1    // Bit LPDS.

	// CSR: power control/status register
	PWR_CSR_WUF_Pos    = 0x0    // Position of WUF field.
	PWR_CSR_WUF_Msk    = 0x1    // Bit mask of WUF field.
	PWR_CSR_WUF        = 0x1    // Bit WUF.
	PWR_CSR_SBF_Pos    = 0x1    // Position of SBF field.
	PWR_CSR_SBF_Msk    = 0x2    // Bit mask of SBF field.
	PWR_CSR_SBF        = 0x2    // Bit SBF.
	PWR_CSR_PVDO_Pos   = 0x2    // Position of PVDO field.
	PWR_CSR_PVDO_Msk   = 0x4    // Bit mask of PVDO field.
	PWR_CSR_PVDO       = 0x4    // Bit PVDO.
	PWR_CSR_BRR_Pos    = 0x3    // Position of BRR field.
	PWR_CSR_BRR_Msk    = 0x8    // Bit mask of BRR field.
	PWR_CSR_BRR        = 0x8    // Bit BRR.
	PWR_CSR_EWUP_Pos   = 0x8    // Position of EWUP field.
	PWR_CSR_EWUP_Msk   = 0x100  // Bit mask of EWUP field.
	PWR_CSR_EWUP       = 0x100  // Bit EWUP.
	PWR_CSR_BRE_Pos    = 0x9    // Position of BRE field.
	PWR_CSR_BRE_Msk    = 0x200  // Bit mask of BRE field.
	PWR_CSR_BRE        = 0x200  // Bit BRE.
	PWR_CSR_VOSRDY_Pos = 0xe    // Position of VOSRDY field.
	PWR_CSR_VOSRDY_Msk = 0x4000 // Bit mask of VOSRDY field.
	PWR_CSR_VOSRDY     = 0x4000 // Bit VOSRDY.
)

// Bitfields for RCC: Reset and clock control
const (
	// CR: clock control register
	RCC_CR_PLLI2SRDY_Pos = 0x1b      // Position of PLLI2SRDY field.
	RCC_CR_PLLI2SRDY_Msk = 0x8000000 // Bit mask of PLLI2SRDY field.
	RCC_CR_PLLI2SRDY     = 0x8000000 // Bit PLLI2SRDY.
	RCC_CR_PLLI2SON_Pos  = 0x1a      // Position of PLLI2SON field.
	RCC_CR_PLLI2SON_Msk  = 0x4000000 // Bit mask of PLLI2SON field.
	RCC_CR_PLLI2SON      = 0x4000000 // Bit PLLI2SON.
	RCC_CR_PLLRDY_Pos    = 0x19      // Position of PLLRDY field.
	RCC_CR_PLLRDY_Msk    = 0x2000000 // Bit mask of PLLRDY field.
	RCC_CR_PLLRDY        = 0x2000000 // Bit PLLRDY.
	RCC_CR_PLLON_Pos     = 0x18      // Position of PLLON field.
	RCC_CR_PLLON_Msk     = 0x1000000 // Bit mask of PLLON field.
	RCC_CR_PLLON         = 0x1000000 // Bit PLLON.
	RCC_CR_CSSON_Pos     = 0x13      // Position of CSSON field.
	RCC_CR_CSSON_Msk     = 0x80000   // Bit mask of CSSON field.
	RCC_CR_CSSON         = 0x80000   // Bit CSSON.
	RCC_CR_HSEBYP_Pos    = 0x12      // Position of HSEBYP field.
	RCC_CR_HSEBYP_Msk    = 0x40000   // Bit mask of HSEBYP field.
	RCC_CR_HSEBYP        = 0x40000   // Bit HSEBYP.
	RCC_CR_HSERDY_Pos    = 0x11      // Position of HSERDY field.
	RCC_CR_HSERDY_Msk    = 0x20000   // Bit mask of HSERDY field.
	RCC_CR_HSERDY        = 0x20000   // Bit HSERDY.
	RCC_CR_HSEON_Pos     = 0x10      // Position of HSEON field.
	RCC_CR_HSEON_Msk     = 0x10000   // Bit mask of HSEON field.
	RCC_CR_HSEON         = 0x10000   // Bit HSEON.
	RCC_CR_HSICAL_Pos    = 0x8       // Position of HSICAL field.
	RCC_CR_HSICAL_Msk    = 0xff00    // Bit mask of HSICAL field.
	RCC_CR_HSITRIM_Pos   = 0x3       // Position of HSITRIM field.
	RCC_CR_HSITRIM_Msk   = 0xf8      // Bit mask of HSITRIM field.
	RCC_CR_HSIRDY_Pos    = 0x1       // Position of HSIRDY field.
	RCC_CR_HSIRDY_Msk    = 0x2       // Bit mask of HSIRDY field.
	RCC_CR_HSIRDY        = 0x2       // Bit HSIRDY.
	RCC_CR_HSION_Pos     = 0x0       // Position of HSION field.
	RCC_CR_HSION_Msk     = 0x1       // Bit mask of HSION field.
	RCC_CR_HSION         = 0x1       // Bit HSION.

	// PLLCFGR: PLL configuration register
	RCC_PLLCFGR_PLLQ3_Pos  = 0x1b      // Position of PLLQ3 field.
	RCC_PLLCFGR_PLLQ3_Msk  = 0x8000000 // Bit mask of PLLQ3 field.
	RCC_PLLCFGR_PLLQ3      = 0x8000000 // Bit PLLQ3.
	RCC_PLLCFGR_PLLQ2_Pos  = 0x1a      // Position of PLLQ2 field.
	RCC_PLLCFGR_PLLQ2_Msk  = 0x4000000 // Bit mask of PLLQ2 field.
	RCC_PLLCFGR_PLLQ2      = 0x4000000 // Bit PLLQ2.
	RCC_PLLCFGR_PLLQ1_Pos  = 0x19      // Position of PLLQ1 field.
	RCC_PLLCFGR_PLLQ1_Msk  = 0x2000000 // Bit mask of PLLQ1 field.
	RCC_PLLCFGR_PLLQ1      = 0x2000000 // Bit PLLQ1.
	RCC_PLLCFGR_PLLQ0_Pos  = 0x18      // Position of PLLQ0 field.
	RCC_PLLCFGR_PLLQ0_Msk  = 0x1000000 // Bit mask of PLLQ0 field.
	RCC_PLLCFGR_PLLQ0      = 0x1000000 // Bit PLLQ0.
	RCC_PLLCFGR_PLLSRC_Pos = 0x16      // Position of PLLSRC field.
	RCC_PLLCFGR_PLLSRC_Msk = 0x400000  // Bit mask of PLLSRC field.
	RCC_PLLCFGR_PLLSRC     = 0x400000  // Bit PLLSRC.
	RCC_PLLCFGR_PLLP1_Pos  = 0x11      // Position of PLLP1 field.
	RCC_PLLCFGR_PLLP1_Msk  = 0x20000   // Bit mask of PLLP1 field.
	RCC_PLLCFGR_PLLP1      = 0x20000   // Bit PLLP1.
	RCC_PLLCFGR_PLLP0_Pos  = 0x10      // Position of PLLP0 field.
	RCC_PLLCFGR_PLLP0_Msk  = 0x10000   // Bit mask of PLLP0 field.
	RCC_PLLCFGR_PLLP0      = 0x10000   // Bit PLLP0.
	RCC_PLLCFGR_PLLN8_Pos  = 0xe       // Position of PLLN8 field.
	RCC_PLLCFGR_PLLN8_Msk  = 0x4000    // Bit mask of PLLN8 field.
	RCC_PLLCFGR_PLLN8      = 0x4000    // Bit PLLN8.
	RCC_PLLCFGR_PLLN7_Pos  = 0xd       // Position of PLLN7 field.
	RCC_PLLCFGR_PLLN7_Msk  = 0x2000    // Bit mask of PLLN7 field.
	RCC_PLLCFGR_PLLN7      = 0x2000    // Bit PLLN7.
	RCC_PLLCFGR_PLLN6_Pos  = 0xc       // Position of PLLN6 field.
	RCC_PLLCFGR_PLLN6_Msk  = 0x1000    // Bit mask of PLLN6 field.
	RCC_PLLCFGR_PLLN6      = 0x1000    // Bit PLLN6.
	RCC_PLLCFGR_PLLN5_Pos  = 0xb       // Position of PLLN5 field.
	RCC_PLLCFGR_PLLN5_Msk  = 0x800     // Bit mask of PLLN5 field.
	RCC_PLLCFGR_PLLN5      = 0x800     // Bit PLLN5.
	RCC_PLLCFGR_PLLN4_Pos  = 0xa       // Position of PLLN4 field.
	RCC_PLLCFGR_PLLN4_Msk  = 0x400     // Bit mask of PLLN4 field.
	RCC_PLLCFGR_PLLN4      = 0x400     // Bit PLLN4.
	RCC_PLLCFGR_PLLN3_Pos  = 0x9       // Position of PLLN3 field.
	RCC_PLLCFGR_PLLN3_Msk  = 0x200     // Bit mask of PLLN3 field.
	RCC_PLLCFGR_PLLN3      = 0x200     // Bit PLLN3.
	RCC_PLLCFGR_PLLN2_Pos  = 0x8       // Position of PLLN2 field.
	RCC_PLLCFGR_PLLN2_Msk  = 0x100     // Bit mask of PLLN2 field.
	RCC_PLLCFGR_PLLN2      = 0x100     // Bit PLLN2.
	RCC_PLLCFGR_PLLN1_Pos  = 0x7       // Position of PLLN1 field.
	RCC_PLLCFGR_PLLN1_Msk  = 0x80      // Bit mask of PLLN1 field.
	RCC_PLLCFGR_PLLN1      = 0x80      // Bit PLLN1.
	RCC_PLLCFGR_PLLN0_Pos  = 0x6       // Position of PLLN0 field.
	RCC_PLLCFGR_PLLN0_Msk  = 0x40      // Bit mask of PLLN0 field.
	RCC_PLLCFGR_PLLN0      = 0x40      // Bit PLLN0.
	RCC_PLLCFGR_PLLM5_Pos  = 0x5       // Position of PLLM5 field.
	RCC_PLLCFGR_PLLM5_Msk  = 0x20      // Bit mask of PLLM5 field.
	RCC_PLLCFGR_PLLM5      = 0x20      // Bit PLLM5.
	RCC_PLLCFGR_PLLM4_Pos  = 0x4       // Position of PLLM4 field.
	RCC_PLLCFGR_PLLM4_Msk  = 0x10      // Bit mask of PLLM4 field.
	RCC_PLLCFGR_PLLM4      = 0x10      // Bit PLLM4.
	RCC_PLLCFGR_PLLM3_Pos  = 0x3       // Position of PLLM3 field.
	RCC_PLLCFGR_PLLM3_Msk  = 0x8       // Bit mask of PLLM3 field.
	RCC_PLLCFGR_PLLM3      = 0x8       // Bit PLLM3.
	RCC_PLLCFGR_PLLM2_Pos  = 0x2       // Position of PLLM2 field.
	RCC_PLLCFGR_PLLM2_Msk  = 0x4       // Bit mask of PLLM2 field.
	RCC_PLLCFGR_PLLM2      = 0x4       // Bit PLLM2.
	RCC_PLLCFGR_PLLM1_Pos  = 0x1       // Position of PLLM1 field.
	RCC_PLLCFGR_PLLM1_Msk  = 0x2       // Bit mask of PLLM1 field.
	RCC_PLLCFGR_PLLM1      = 0x2       // Bit PLLM1.
	RCC_PLLCFGR_PLLM0_Pos  = 0x0       // Position of PLLM0 field.
	RCC_PLLCFGR_PLLM0_Msk  = 0x1       // Bit mask of PLLM0 field.
	RCC_PLLCFGR_PLLM0      = 0x1       // Bit PLLM0.

	// CFGR: clock configuration register
	RCC_CFGR_MCO2_Pos    = 0x1e       // Position of MCO2 field.
	RCC_CFGR_MCO2_Msk    = 0xc0000000 // Bit mask of MCO2 field.
	RCC_CFGR_MCO2PRE_Pos = 0x1b       // Position of MCO2PRE field.
	RCC_CFGR_MCO2PRE_Msk = 0x38000000 // Bit mask of MCO2PRE field.
	RCC_CFGR_MCO1PRE_Pos = 0x18       // Position of MCO1PRE field.
	RCC_CFGR_MCO1PRE_Msk = 0x7000000  // Bit mask of MCO1PRE field.
	RCC_CFGR_I2SSRC_Pos  = 0x17       // Position of I2SSRC field.
	RCC_CFGR_I2SSRC_Msk  = 0x800000   // Bit mask of I2SSRC field.
	RCC_CFGR_I2SSRC      = 0x800000   // Bit I2SSRC.
	RCC_CFGR_MCO1_Pos    = 0x15       // Position of MCO1 field.
	RCC_CFGR_MCO1_Msk    = 0x600000   // Bit mask of MCO1 field.
	RCC_CFGR_RTCPRE_Pos  = 0x10       // Position of RTCPRE field.
	RCC_CFGR_RTCPRE_Msk  = 0x1f0000   // Bit mask of RTCPRE field.
	RCC_CFGR_PPRE2_Pos   = 0xd        // Position of PPRE2 field.
	RCC_CFGR_PPRE2_Msk   = 0xe000     // Bit mask of PPRE2 field.
	RCC_CFGR_PPRE1_Pos   = 0xa        // Position of PPRE1 field.
	RCC_CFGR_PPRE1_Msk   = 0x1c00     // Bit mask of PPRE1 field.
	RCC_CFGR_HPRE_Pos    = 0x4        // Position of HPRE field.
	RCC_CFGR_HPRE_Msk    = 0xf0       // Bit mask of HPRE field.
	RCC_CFGR_SWS1_Pos    = 0x3        // Position of SWS1 field.
	RCC_CFGR_SWS1_Msk    = 0x8        // Bit mask of SWS1 field.
	RCC_CFGR_SWS1        = 0x8        // Bit SWS1.
	RCC_CFGR_SWS0_Pos    = 0x2        // Position of SWS0 field.
	RCC_CFGR_SWS0_Msk    = 0x4        // Bit mask of SWS0 field.
	RCC_CFGR_SWS0        = 0x4        // Bit SWS0.
	RCC_CFGR_SW1_Pos     = 0x1        // Position of SW1 field.
	RCC_CFGR_SW1_Msk     = 0x2        // Bit mask of SW1 field.
	RCC_CFGR_SW1         = 0x2        // Bit SW1.
	RCC_CFGR_SW0_Pos     = 0x0        // Position of SW0 field.
	RCC_CFGR_SW0_Msk     = 0x1        // Bit mask of SW0 field.
	RCC_CFGR_SW0         = 0x1        // Bit SW0.

	// CIR: clock interrupt register
	RCC_CIR_CSSC_Pos        = 0x17     // Position of CSSC field.
	RCC_CIR_CSSC_Msk        = 0x800000 // Bit mask of CSSC field.
	RCC_CIR_CSSC            = 0x800000 // Bit CSSC.
	RCC_CIR_PLLI2SRDYC_Pos  = 0x15     // Position of PLLI2SRDYC field.
	RCC_CIR_PLLI2SRDYC_Msk  = 0x200000 // Bit mask of PLLI2SRDYC field.
	RCC_CIR_PLLI2SRDYC      = 0x200000 // Bit PLLI2SRDYC.
	RCC_CIR_PLLRDYC_Pos     = 0x14     // Position of PLLRDYC field.
	RCC_CIR_PLLRDYC_Msk     = 0x100000 // Bit mask of PLLRDYC field.
	RCC_CIR_PLLRDYC         = 0x100000 // Bit PLLRDYC.
	RCC_CIR_HSERDYC_Pos     = 0x13     // Position of HSERDYC field.
	RCC_CIR_HSERDYC_Msk     = 0x80000  // Bit mask of HSERDYC field.
	RCC_CIR_HSERDYC         = 0x80000  // Bit HSERDYC.
	RCC_CIR_HSIRDYC_Pos     = 0x12     // Position of HSIRDYC field.
	RCC_CIR_HSIRDYC_Msk     = 0x40000  // Bit mask of HSIRDYC field.
	RCC_CIR_HSIRDYC         = 0x40000  // Bit HSIRDYC.
	RCC_CIR_LSERDYC_Pos     = 0x11     // Position of LSERDYC field.
	RCC_CIR_LSERDYC_Msk     = 0x20000  // Bit mask of LSERDYC field.
	RCC_CIR_LSERDYC         = 0x20000  // Bit LSERDYC.
	RCC_CIR_LSIRDYC_Pos     = 0x10     // Position of LSIRDYC field.
	RCC_CIR_LSIRDYC_Msk     = 0x10000  // Bit mask of LSIRDYC field.
	RCC_CIR_LSIRDYC         = 0x10000  // Bit LSIRDYC.
	RCC_CIR_PLLI2SRDYIE_Pos = 0xd      // Position of PLLI2SRDYIE field.
	RCC_CIR_PLLI2SRDYIE_Msk = 0x2000   // Bit mask of PLLI2SRDYIE field.
	RCC_CIR_PLLI2SRDYIE     = 0x2000   // Bit PLLI2SRDYIE.
	RCC_CIR_PLLRDYIE_Pos    = 0xc      // Position of PLLRDYIE field.
	RCC_CIR_PLLRDYIE_Msk    = 0x1000   // Bit mask of PLLRDYIE field.
	RCC_CIR_PLLRDYIE        = 0x1000   // Bit PLLRDYIE.
	RCC_CIR_HSERDYIE_Pos    = 0xb      // Position of HSERDYIE field.
	RCC_CIR_HSERDYIE_Msk    = 0x800    // Bit mask of HSERDYIE field.
	RCC_CIR_HSERDYIE        = 0x800    // Bit HSERDYIE.
	RCC_CIR_HSIRDYIE_Pos    = 0xa      // Position of HSIRDYIE field.
	RCC_CIR_HSIRDYIE_Msk    = 0x400    // Bit mask of HSIRDYIE field.
	RCC_CIR_HSIRDYIE        = 0x400    // Bit HSIRDYIE.
	RCC_CIR_LSERDYIE_Pos    = 0x9      // Position of LSERDYIE field.
	RCC_CIR_LSERDYIE_Msk    = 0x200    // Bit mask of LSERDYIE field.
	RCC_CIR_LSERDYIE        = 0x200    // Bit LSERDYIE.
	RCC_CIR_LSIRDYIE_Pos    = 0x8      // Position of LSIRDYIE field.
	RCC_CIR_LSIRDYIE_Msk    = 0x100    // Bit mask of LSIRDYIE field.
	RCC_CIR_LSIRDYIE        = 0x100    // Bit LSIRDYIE.
	RCC_CIR_CSSF_Pos        = 0x7      // Position of CSSF field.
	RCC_CIR_CSSF_Msk        = 0x80     // Bit mask of CSSF field.
	RCC_CIR_CSSF            = 0x80     // Bit CSSF.
	RCC_CIR_PLLI2SRDYF_Pos  = 0x5      // Position of PLLI2SRDYF field.
	RCC_CIR_PLLI2SRDYF_Msk  = 0x20     // Bit mask of PLLI2SRDYF field.
	RCC_CIR_PLLI2SRDYF      = 0x20     // Bit PLLI2SRDYF.
	RCC_CIR_PLLRDYF_Pos     = 0x4      // Position of PLLRDYF field.
	RCC_CIR_PLLRDYF_Msk     = 0x10     // Bit mask of PLLRDYF field.
	RCC_CIR_PLLRDYF         = 0x10     // Bit PLLRDYF.
	RCC_CIR_HSERDYF_Pos     = 0x3      // Position of HSERDYF field.
	RCC_CIR_HSERDYF_Msk     = 0x8      // Bit mask of HSERDYF field.
	RCC_CIR_HSERDYF         = 0x8      // Bit HSERDYF.
	RCC_CIR_HSIRDYF_Pos     = 0x2      // Position of HSIRDYF field.
	RCC_CIR_HSIRDYF_Msk     = 0x4      // Bit mask of HSIRDYF field.
	RCC_CIR_HSIRDYF         = 0x4      // Bit HSIRDYF.
	RCC_CIR_LSERDYF_Pos     = 0x1      // Position of LSERDYF field.
	RCC_CIR_LSERDYF_Msk     = 0x2      // Bit mask of LSERDYF field.
	RCC_CIR_LSERDYF         = 0x2      // Bit LSERDYF.
	RCC_CIR_LSIRDYF_Pos     = 0x0      // Position of LSIRDYF field.
	RCC_CIR_LSIRDYF_Msk     = 0x1      // Bit mask of LSIRDYF field.
	RCC_CIR_LSIRDYF         = 0x1      // Bit LSIRDYF.

	// AHB1RSTR: AHB1 peripheral reset register
	RCC_AHB1RSTR_DMA2RST_Pos  = 0x16     // Position of DMA2RST field.
	RCC_AHB1RSTR_DMA2RST_Msk  = 0x400000 // Bit mask of DMA2RST field.
	RCC_AHB1RSTR_DMA2RST      = 0x400000 // Bit DMA2RST.
	RCC_AHB1RSTR_DMA1RST_Pos  = 0x15     // Position of DMA1RST field.
	RCC_AHB1RSTR_DMA1RST_Msk  = 0x200000 // Bit mask of DMA1RST field.
	RCC_AHB1RSTR_DMA1RST      = 0x200000 // Bit DMA1RST.
	RCC_AHB1RSTR_CRCRST_Pos   = 0xc      // Position of CRCRST field.
	RCC_AHB1RSTR_CRCRST_Msk   = 0x1000   // Bit mask of CRCRST field.
	RCC_AHB1RSTR_CRCRST       = 0x1000   // Bit CRCRST.
	RCC_AHB1RSTR_GPIOHRST_Pos = 0x7      // Position of GPIOHRST field.
	RCC_AHB1RSTR_GPIOHRST_Msk = 0x80     // Bit mask of GPIOHRST field.
	RCC_AHB1RSTR_GPIOHRST     = 0x80     // Bit GPIOHRST.
	RCC_AHB1RSTR_GPIOERST_Pos = 0x4      // Position of GPIOERST field.
	RCC_AHB1RSTR_GPIOERST_Msk = 0x10     // Bit mask of GPIOERST field.
	RCC_AHB1RSTR_GPIOERST     = 0x10     // Bit GPIOERST.
	RCC_AHB1RSTR_GPIODRST_Pos = 0x3      // Position of GPIODRST field.
	RCC_AHB1RSTR_GPIODRST_Msk = 0x8      // Bit mask of GPIODRST field.
	RCC_AHB1RSTR_GPIODRST     = 0x8      // Bit GPIODRST.
	RCC_AHB1RSTR_GPIOCRST_Pos = 0x2      // Position of GPIOCRST field.
	RCC_AHB1RSTR_GPIOCRST_Msk = 0x4      // Bit mask of GPIOCRST field.
	RCC_AHB1RSTR_GPIOCRST     = 0x4      // Bit GPIOCRST.
	RCC_AHB1RSTR_GPIOBRST_Pos = 0x1      // Position of GPIOBRST field.
	RCC_AHB1RSTR_GPIOBRST_Msk = 0x2      // Bit mask of GPIOBRST field.
	RCC_AHB1RSTR_GPIOBRST     = 0x2      // Bit GPIOBRST.
	RCC_AHB1RSTR_GPIOARST_Pos = 0x0      // Position of GPIOARST field.
	RCC_AHB1RSTR_GPIOARST_Msk = 0x1      // Bit mask of GPIOARST field.
	RCC_AHB1RSTR_GPIOARST     = 0x1      // Bit GPIOARST.

	// AHB2RSTR: AHB2 peripheral reset register
	RCC_AHB2RSTR_OTGFSRST_Pos = 0x7  // Position of OTGFSRST field.
	RCC_AHB2RSTR_OTGFSRST_Msk = 0x80 // Bit mask of OTGFSRST field.
	RCC_AHB2RSTR_OTGFSRST     = 0x80 // Bit OTGFSRST.

	// APB1RSTR: APB1 peripheral reset register
	RCC_APB1RSTR_PWRRST_Pos   = 0x1c       // Position of PWRRST field.
	RCC_APB1RSTR_PWRRST_Msk   = 0x10000000 // Bit mask of PWRRST field.
	RCC_APB1RSTR_PWRRST       = 0x10000000 // Bit PWRRST.
	RCC_APB1RSTR_I2C3RST_Pos  = 0x17       // Position of I2C3RST field.
	RCC_APB1RSTR_I2C3RST_Msk  = 0x800000   // Bit mask of I2C3RST field.
	RCC_APB1RSTR_I2C3RST      = 0x800000   // Bit I2C3RST.
	RCC_APB1RSTR_I2C2RST_Pos  = 0x16       // Position of I2C2RST field.
	RCC_APB1RSTR_I2C2RST_Msk  = 0x400000   // Bit mask of I2C2RST field.
	RCC_APB1RSTR_I2C2RST      = 0x400000   // Bit I2C2RST.
	RCC_APB1RSTR_I2C1RST_Pos  = 0x15       // Position of I2C1RST field.
	RCC_APB1RSTR_I2C1RST_Msk  = 0x200000   // Bit mask of I2C1RST field.
	RCC_APB1RSTR_I2C1RST      = 0x200000   // Bit I2C1RST.
	RCC_APB1RSTR_UART2RST_Pos = 0x11       // Position of UART2RST field.
	RCC_APB1RSTR_UART2RST_Msk = 0x20000    // Bit mask of UART2RST field.
	RCC_APB1RSTR_UART2RST     = 0x20000    // Bit UART2RST.
	RCC_APB1RSTR_SPI3RST_Pos  = 0xf        // Position of SPI3RST field.
	RCC_APB1RSTR_SPI3RST_Msk  = 0x8000     // Bit mask of SPI3RST field.
	RCC_APB1RSTR_SPI3RST      = 0x8000     // Bit SPI3RST.
	RCC_APB1RSTR_SPI2RST_Pos  = 0xe        // Position of SPI2RST field.
	RCC_APB1RSTR_SPI2RST_Msk  = 0x4000     // Bit mask of SPI2RST field.
	RCC_APB1RSTR_SPI2RST      = 0x4000     // Bit SPI2RST.
	RCC_APB1RSTR_WWDGRST_Pos  = 0xb        // Position of WWDGRST field.
	RCC_APB1RSTR_WWDGRST_Msk  = 0x800      // Bit mask of WWDGRST field.
	RCC_APB1RSTR_WWDGRST      = 0x800      // Bit WWDGRST.
	RCC_APB1RSTR_TIM5RST_Pos  = 0x3        // Position of TIM5RST field.
	RCC_APB1RSTR_TIM5RST_Msk  = 0x8        // Bit mask of TIM5RST field.
	RCC_APB1RSTR_TIM5RST      = 0x8        // Bit TIM5RST.
	RCC_APB1RSTR_TIM4RST_Pos  = 0x2        // Position of TIM4RST field.
	RCC_APB1RSTR_TIM4RST_Msk  = 0x4        // Bit mask of TIM4RST field.
	RCC_APB1RSTR_TIM4RST      = 0x4        // Bit TIM4RST.
	RCC_APB1RSTR_TIM3RST_Pos  = 0x1        // Position of TIM3RST field.
	RCC_APB1RSTR_TIM3RST_Msk  = 0x2        // Bit mask of TIM3RST field.
	RCC_APB1RSTR_TIM3RST      = 0x2        // Bit TIM3RST.
	RCC_APB1RSTR_TIM2RST_Pos  = 0x0        // Position of TIM2RST field.
	RCC_APB1RSTR_TIM2RST_Msk  = 0x1        // Bit mask of TIM2RST field.
	RCC_APB1RSTR_TIM2RST      = 0x1        // Bit TIM2RST.

	// APB2RSTR: APB2 peripheral reset register
	RCC_APB2RSTR_TIM11RST_Pos  = 0x12    // Position of TIM11RST field.
	RCC_APB2RSTR_TIM11RST_Msk  = 0x40000 // Bit mask of TIM11RST field.
	RCC_APB2RSTR_TIM11RST      = 0x40000 // Bit TIM11RST.
	RCC_APB2RSTR_TIM10RST_Pos  = 0x11    // Position of TIM10RST field.
	RCC_APB2RSTR_TIM10RST_Msk  = 0x20000 // Bit mask of TIM10RST field.
	RCC_APB2RSTR_TIM10RST      = 0x20000 // Bit TIM10RST.
	RCC_APB2RSTR_TIM9RST_Pos   = 0x10    // Position of TIM9RST field.
	RCC_APB2RSTR_TIM9RST_Msk   = 0x10000 // Bit mask of TIM9RST field.
	RCC_APB2RSTR_TIM9RST       = 0x10000 // Bit TIM9RST.
	RCC_APB2RSTR_SYSCFGRST_Pos = 0xe     // Position of SYSCFGRST field.
	RCC_APB2RSTR_SYSCFGRST_Msk = 0x4000  // Bit mask of SYSCFGRST field.
	RCC_APB2RSTR_SYSCFGRST     = 0x4000  // Bit SYSCFGRST.
	RCC_APB2RSTR_SPI1RST_Pos   = 0xc     // Position of SPI1RST field.
	RCC_APB2RSTR_SPI1RST_Msk   = 0x1000  // Bit mask of SPI1RST field.
	RCC_APB2RSTR_SPI1RST       = 0x1000  // Bit SPI1RST.
	RCC_APB2RSTR_SDIORST_Pos   = 0xb     // Position of SDIORST field.
	RCC_APB2RSTR_SDIORST_Msk   = 0x800   // Bit mask of SDIORST field.
	RCC_APB2RSTR_SDIORST       = 0x800   // Bit SDIORST.
	RCC_APB2RSTR_ADCRST_Pos    = 0x8     // Position of ADCRST field.
	RCC_APB2RSTR_ADCRST_Msk    = 0x100   // Bit mask of ADCRST field.
	RCC_APB2RSTR_ADCRST        = 0x100   // Bit ADCRST.
	RCC_APB2RSTR_USART6RST_Pos = 0x5     // Position of USART6RST field.
	RCC_APB2RSTR_USART6RST_Msk = 0x20    // Bit mask of USART6RST field.
	RCC_APB2RSTR_USART6RST     = 0x20    // Bit USART6RST.
	RCC_APB2RSTR_USART1RST_Pos = 0x4     // Position of USART1RST field.
	RCC_APB2RSTR_USART1RST_Msk = 0x10    // Bit mask of USART1RST field.
	RCC_APB2RSTR_USART1RST     = 0x10    // Bit USART1RST.
	RCC_APB2RSTR_TIM1RST_Pos   = 0x0     // Position of TIM1RST field.
	RCC_APB2RSTR_TIM1RST_Msk   = 0x1     // Bit mask of TIM1RST field.
	RCC_APB2RSTR_TIM1RST       = 0x1     // Bit TIM1RST.

	// AHB1ENR: AHB1 peripheral clock register
	RCC_AHB1ENR_DMA2EN_Pos  = 0x16     // Position of DMA2EN field.
	RCC_AHB1ENR_DMA2EN_Msk  = 0x400000 // Bit mask of DMA2EN field.
	RCC_AHB1ENR_DMA2EN      = 0x400000 // Bit DMA2EN.
	RCC_AHB1ENR_DMA1EN_Pos  = 0x15     // Position of DMA1EN field.
	RCC_AHB1ENR_DMA1EN_Msk  = 0x200000 // Bit mask of DMA1EN field.
	RCC_AHB1ENR_DMA1EN      = 0x200000 // Bit DMA1EN.
	RCC_AHB1ENR_CRCEN_Pos   = 0xc      // Position of CRCEN field.
	RCC_AHB1ENR_CRCEN_Msk   = 0x1000   // Bit mask of CRCEN field.
	RCC_AHB1ENR_CRCEN       = 0x1000   // Bit CRCEN.
	RCC_AHB1ENR_GPIOHEN_Pos = 0x7      // Position of GPIOHEN field.
	RCC_AHB1ENR_GPIOHEN_Msk = 0x80     // Bit mask of GPIOHEN field.
	RCC_AHB1ENR_GPIOHEN     = 0x80     // Bit GPIOHEN.
	RCC_AHB1ENR_GPIOEEN_Pos = 0x4      // Position of GPIOEEN field.
	RCC_AHB1ENR_GPIOEEN_Msk = 0x10     // Bit mask of GPIOEEN field.
	RCC_AHB1ENR_GPIOEEN     = 0x10     // Bit GPIOEEN.
	RCC_AHB1ENR_GPIODEN_Pos = 0x3      // Position of GPIODEN field.
	RCC_AHB1ENR_GPIODEN_Msk = 0x8      // Bit mask of GPIODEN field.
	RCC_AHB1ENR_GPIODEN     = 0x8      // Bit GPIODEN.
	RCC_AHB1ENR_GPIOCEN_Pos = 0x2      // Position of GPIOCEN field.
	RCC_AHB1ENR_GPIOCEN_Msk = 0x4      // Bit mask of GPIOCEN field.
	RCC_AHB1ENR_GPIOCEN     = 0x4      // Bit GPIOCEN.
	RCC_AHB1ENR_GPIOBEN_Pos = 0x1      // Position of GPIOBEN field.
	RCC_AHB1ENR_GPIOBEN_Msk = 0x2      // Bit mask of GPIOBEN field.
	RCC_AHB1ENR_GPIOBEN     = 0x2      // Bit GPIOBEN.
	RCC_AHB1ENR_GPIOAEN_Pos = 0x0      // Position of GPIOAEN field.
	RCC_AHB1ENR_GPIOAEN_Msk = 0x1      // Bit mask of GPIOAEN field.
	RCC_AHB1ENR_GPIOAEN     = 0x1      // Bit GPIOAEN.

	// AHB2ENR: AHB2 peripheral clock enable           register
	RCC_AHB2ENR_OTGFSEN_Pos = 0x7  // Position of OTGFSEN field.
	RCC_AHB2ENR_OTGFSEN_Msk = 0x80 // Bit mask of OTGFSEN field.
	RCC_AHB2ENR_OTGFSEN     = 0x80 // Bit OTGFSEN.

	// APB1ENR: APB1 peripheral clock enable           register
	RCC_APB1ENR_PWREN_Pos    = 0x1c       // Position of PWREN field.
	RCC_APB1ENR_PWREN_Msk    = 0x10000000 // Bit mask of PWREN field.
	RCC_APB1ENR_PWREN        = 0x10000000 // Bit PWREN.
	RCC_APB1ENR_I2C3EN_Pos   = 0x17       // Position of I2C3EN field.
	RCC_APB1ENR_I2C3EN_Msk   = 0x800000   // Bit mask of I2C3EN field.
	RCC_APB1ENR_I2C3EN       = 0x800000   // Bit I2C3EN.
	RCC_APB1ENR_I2C2EN_Pos   = 0x16       // Position of I2C2EN field.
	RCC_APB1ENR_I2C2EN_Msk   = 0x400000   // Bit mask of I2C2EN field.
	RCC_APB1ENR_I2C2EN       = 0x400000   // Bit I2C2EN.
	RCC_APB1ENR_I2C1EN_Pos   = 0x15       // Position of I2C1EN field.
	RCC_APB1ENR_I2C1EN_Msk   = 0x200000   // Bit mask of I2C1EN field.
	RCC_APB1ENR_I2C1EN       = 0x200000   // Bit I2C1EN.
	RCC_APB1ENR_USART2EN_Pos = 0x11       // Position of USART2EN field.
	RCC_APB1ENR_USART2EN_Msk = 0x20000    // Bit mask of USART2EN field.
	RCC_APB1ENR_USART2EN     = 0x20000    // Bit USART2EN.
	RCC_APB1ENR_SPI3EN_Pos   = 0xf        // Position of SPI3EN field.
	RCC_APB1ENR_SPI3EN_Msk   = 0x8000     // Bit mask of SPI3EN field.
	RCC_APB1ENR_SPI3EN       = 0x8000     // Bit SPI3EN.
	RCC_APB1ENR_SPI2EN_Pos   = 0xe        // Position of SPI2EN field.
	RCC_APB1ENR_SPI2EN_Msk   = 0x4000     // Bit mask of SPI2EN field.
	RCC_APB1ENR_SPI2EN       = 0x4000     // Bit SPI2EN.
	RCC_APB1ENR_WWDGEN_Pos   = 0xb        // Position of WWDGEN field.
	RCC_APB1ENR_WWDGEN_Msk   = 0x800      // Bit mask of WWDGEN field.
	RCC_APB1ENR_WWDGEN       = 0x800      // Bit WWDGEN.
	RCC_APB1ENR_TIM5EN_Pos   = 0x3        // Position of TIM5EN field.
	RCC_APB1ENR_TIM5EN_Msk   = 0x8        // Bit mask of TIM5EN field.
	RCC_APB1ENR_TIM5EN       = 0x8        // Bit TIM5EN.
	RCC_APB1ENR_TIM4EN_Pos   = 0x2        // Position of TIM4EN field.
	RCC_APB1ENR_TIM4EN_Msk   = 0x4        // Bit mask of TIM4EN field.
	RCC_APB1ENR_TIM4EN       = 0x4        // Bit TIM4EN.
	RCC_APB1ENR_TIM3EN_Pos   = 0x1        // Position of TIM3EN field.
	RCC_APB1ENR_TIM3EN_Msk   = 0x2        // Bit mask of TIM3EN field.
	RCC_APB1ENR_TIM3EN       = 0x2        // Bit TIM3EN.
	RCC_APB1ENR_TIM2EN_Pos   = 0x0        // Position of TIM2EN field.
	RCC_APB1ENR_TIM2EN_Msk   = 0x1        // Bit mask of TIM2EN field.
	RCC_APB1ENR_TIM2EN       = 0x1        // Bit TIM2EN.

	// APB2ENR: APB2 peripheral clock enable           register
	RCC_APB2ENR_TIM1EN_Pos   = 0x0     // Position of TIM1EN field.
	RCC_APB2ENR_TIM1EN_Msk   = 0x1     // Bit mask of TIM1EN field.
	RCC_APB2ENR_TIM1EN       = 0x1     // Bit TIM1EN.
	RCC_APB2ENR_USART1EN_Pos = 0x4     // Position of USART1EN field.
	RCC_APB2ENR_USART1EN_Msk = 0x10    // Bit mask of USART1EN field.
	RCC_APB2ENR_USART1EN     = 0x10    // Bit USART1EN.
	RCC_APB2ENR_USART6EN_Pos = 0x5     // Position of USART6EN field.
	RCC_APB2ENR_USART6EN_Msk = 0x20    // Bit mask of USART6EN field.
	RCC_APB2ENR_USART6EN     = 0x20    // Bit USART6EN.
	RCC_APB2ENR_ADC1EN_Pos   = 0x8     // Position of ADC1EN field.
	RCC_APB2ENR_ADC1EN_Msk   = 0x100   // Bit mask of ADC1EN field.
	RCC_APB2ENR_ADC1EN       = 0x100   // Bit ADC1EN.
	RCC_APB2ENR_SDIOEN_Pos   = 0xb     // Position of SDIOEN field.
	RCC_APB2ENR_SDIOEN_Msk   = 0x800   // Bit mask of SDIOEN field.
	RCC_APB2ENR_SDIOEN       = 0x800   // Bit SDIOEN.
	RCC_APB2ENR_SPI1EN_Pos   = 0xc     // Position of SPI1EN field.
	RCC_APB2ENR_SPI1EN_Msk   = 0x1000  // Bit mask of SPI1EN field.
	RCC_APB2ENR_SPI1EN       = 0x1000  // Bit SPI1EN.
	RCC_APB2ENR_SPI4EN_Pos   = 0xd     // Position of SPI4EN field.
	RCC_APB2ENR_SPI4EN_Msk   = 0x2000  // Bit mask of SPI4EN field.
	RCC_APB2ENR_SPI4EN       = 0x2000  // Bit SPI4EN.
	RCC_APB2ENR_SYSCFGEN_Pos = 0xe     // Position of SYSCFGEN field.
	RCC_APB2ENR_SYSCFGEN_Msk = 0x4000  // Bit mask of SYSCFGEN field.
	RCC_APB2ENR_SYSCFGEN     = 0x4000  // Bit SYSCFGEN.
	RCC_APB2ENR_TIM9EN_Pos   = 0x10    // Position of TIM9EN field.
	RCC_APB2ENR_TIM9EN_Msk   = 0x10000 // Bit mask of TIM9EN field.
	RCC_APB2ENR_TIM9EN       = 0x10000 // Bit TIM9EN.
	RCC_APB2ENR_TIM10EN_Pos  = 0x11    // Position of TIM10EN field.
	RCC_APB2ENR_TIM10EN_Msk  = 0x20000 // Bit mask of TIM10EN field.
	RCC_APB2ENR_TIM10EN      = 0x20000 // Bit TIM10EN.
	RCC_APB2ENR_TIM11EN_Pos  = 0x12    // Position of TIM11EN field.
	RCC_APB2ENR_TIM11EN_Msk  = 0x40000 // Bit mask of TIM11EN field.
	RCC_APB2ENR_TIM11EN      = 0x40000 // Bit TIM11EN.

	// AHB1LPENR: AHB1 peripheral clock enable in low power           mode register
	RCC_AHB1LPENR_DMA2LPEN_Pos  = 0x16     // Position of DMA2LPEN field.
	RCC_AHB1LPENR_DMA2LPEN_Msk  = 0x400000 // Bit mask of DMA2LPEN field.
	RCC_AHB1LPENR_DMA2LPEN      = 0x400000 // Bit DMA2LPEN.
	RCC_AHB1LPENR_DMA1LPEN_Pos  = 0x15     // Position of DMA1LPEN field.
	RCC_AHB1LPENR_DMA1LPEN_Msk  = 0x200000 // Bit mask of DMA1LPEN field.
	RCC_AHB1LPENR_DMA1LPEN      = 0x200000 // Bit DMA1LPEN.
	RCC_AHB1LPENR_SRAM1LPEN_Pos = 0x10     // Position of SRAM1LPEN field.
	RCC_AHB1LPENR_SRAM1LPEN_Msk = 0x10000  // Bit mask of SRAM1LPEN field.
	RCC_AHB1LPENR_SRAM1LPEN     = 0x10000  // Bit SRAM1LPEN.
	RCC_AHB1LPENR_FLITFLPEN_Pos = 0xf      // Position of FLITFLPEN field.
	RCC_AHB1LPENR_FLITFLPEN_Msk = 0x8000   // Bit mask of FLITFLPEN field.
	RCC_AHB1LPENR_FLITFLPEN     = 0x8000   // Bit FLITFLPEN.
	RCC_AHB1LPENR_CRCLPEN_Pos   = 0xc      // Position of CRCLPEN field.
	RCC_AHB1LPENR_CRCLPEN_Msk   = 0x1000   // Bit mask of CRCLPEN field.
	RCC_AHB1LPENR_CRCLPEN       = 0x1000   // Bit CRCLPEN.
	RCC_AHB1LPENR_GPIOHLPEN_Pos = 0x7      // Position of GPIOHLPEN field.
	RCC_AHB1LPENR_GPIOHLPEN_Msk = 0x80     // Bit mask of GPIOHLPEN field.
	RCC_AHB1LPENR_GPIOHLPEN     = 0x80     // Bit GPIOHLPEN.
	RCC_AHB1LPENR_GPIOELPEN_Pos = 0x4      // Position of GPIOELPEN field.
	RCC_AHB1LPENR_GPIOELPEN_Msk = 0x10     // Bit mask of GPIOELPEN field.
	RCC_AHB1LPENR_GPIOELPEN     = 0x10     // Bit GPIOELPEN.
	RCC_AHB1LPENR_GPIODLPEN_Pos = 0x3      // Position of GPIODLPEN field.
	RCC_AHB1LPENR_GPIODLPEN_Msk = 0x8      // Bit mask of GPIODLPEN field.
	RCC_AHB1LPENR_GPIODLPEN     = 0x8      // Bit GPIODLPEN.
	RCC_AHB1LPENR_GPIOCLPEN_Pos = 0x2      // Position of GPIOCLPEN field.
	RCC_AHB1LPENR_GPIOCLPEN_Msk = 0x4      // Bit mask of GPIOCLPEN field.
	RCC_AHB1LPENR_GPIOCLPEN     = 0x4      // Bit GPIOCLPEN.
	RCC_AHB1LPENR_GPIOBLPEN_Pos = 0x1      // Position of GPIOBLPEN field.
	RCC_AHB1LPENR_GPIOBLPEN_Msk = 0x2      // Bit mask of GPIOBLPEN field.
	RCC_AHB1LPENR_GPIOBLPEN     = 0x2      // Bit GPIOBLPEN.
	RCC_AHB1LPENR_GPIOALPEN_Pos = 0x0      // Position of GPIOALPEN field.
	RCC_AHB1LPENR_GPIOALPEN_Msk = 0x1      // Bit mask of GPIOALPEN field.
	RCC_AHB1LPENR_GPIOALPEN     = 0x1      // Bit GPIOALPEN.

	// AHB2LPENR: AHB2 peripheral clock enable in low power           mode register
	RCC_AHB2LPENR_OTGFSLPEN_Pos = 0x7  // Position of OTGFSLPEN field.
	RCC_AHB2LPENR_OTGFSLPEN_Msk = 0x80 // Bit mask of OTGFSLPEN field.
	RCC_AHB2LPENR_OTGFSLPEN     = 0x80 // Bit OTGFSLPEN.

	// APB1LPENR: APB1 peripheral clock enable in low power           mode register
	RCC_APB1LPENR_PWRLPEN_Pos    = 0x1c       // Position of PWRLPEN field.
	RCC_APB1LPENR_PWRLPEN_Msk    = 0x10000000 // Bit mask of PWRLPEN field.
	RCC_APB1LPENR_PWRLPEN        = 0x10000000 // Bit PWRLPEN.
	RCC_APB1LPENR_I2C3LPEN_Pos   = 0x17       // Position of I2C3LPEN field.
	RCC_APB1LPENR_I2C3LPEN_Msk   = 0x800000   // Bit mask of I2C3LPEN field.
	RCC_APB1LPENR_I2C3LPEN       = 0x800000   // Bit I2C3LPEN.
	RCC_APB1LPENR_I2C2LPEN_Pos   = 0x16       // Position of I2C2LPEN field.
	RCC_APB1LPENR_I2C2LPEN_Msk   = 0x400000   // Bit mask of I2C2LPEN field.
	RCC_APB1LPENR_I2C2LPEN       = 0x400000   // Bit I2C2LPEN.
	RCC_APB1LPENR_I2C1LPEN_Pos   = 0x15       // Position of I2C1LPEN field.
	RCC_APB1LPENR_I2C1LPEN_Msk   = 0x200000   // Bit mask of I2C1LPEN field.
	RCC_APB1LPENR_I2C1LPEN       = 0x200000   // Bit I2C1LPEN.
	RCC_APB1LPENR_USART2LPEN_Pos = 0x11       // Position of USART2LPEN field.
	RCC_APB1LPENR_USART2LPEN_Msk = 0x20000    // Bit mask of USART2LPEN field.
	RCC_APB1LPENR_USART2LPEN     = 0x20000    // Bit USART2LPEN.
	RCC_APB1LPENR_SPI3LPEN_Pos   = 0xf        // Position of SPI3LPEN field.
	RCC_APB1LPENR_SPI3LPEN_Msk   = 0x8000     // Bit mask of SPI3LPEN field.
	RCC_APB1LPENR_SPI3LPEN       = 0x8000     // Bit SPI3LPEN.
	RCC_APB1LPENR_SPI2LPEN_Pos   = 0xe        // Position of SPI2LPEN field.
	RCC_APB1LPENR_SPI2LPEN_Msk   = 0x4000     // Bit mask of SPI2LPEN field.
	RCC_APB1LPENR_SPI2LPEN       = 0x4000     // Bit SPI2LPEN.
	RCC_APB1LPENR_WWDGLPEN_Pos   = 0xb        // Position of WWDGLPEN field.
	RCC_APB1LPENR_WWDGLPEN_Msk   = 0x800      // Bit mask of WWDGLPEN field.
	RCC_APB1LPENR_WWDGLPEN       = 0x800      // Bit WWDGLPEN.
	RCC_APB1LPENR_TIM5LPEN_Pos   = 0x3        // Position of TIM5LPEN field.
	RCC_APB1LPENR_TIM5LPEN_Msk   = 0x8        // Bit mask of TIM5LPEN field.
	RCC_APB1LPENR_TIM5LPEN       = 0x8        // Bit TIM5LPEN.
	RCC_APB1LPENR_TIM4LPEN_Pos   = 0x2        // Position of TIM4LPEN field.
	RCC_APB1LPENR_TIM4LPEN_Msk   = 0x4        // Bit mask of TIM4LPEN field.
	RCC_APB1LPENR_TIM4LPEN       = 0x4        // Bit TIM4LPEN.
	RCC_APB1LPENR_TIM3LPEN_Pos   = 0x1        // Position of TIM3LPEN field.
	RCC_APB1LPENR_TIM3LPEN_Msk   = 0x2        // Bit mask of TIM3LPEN field.
	RCC_APB1LPENR_TIM3LPEN       = 0x2        // Bit TIM3LPEN.
	RCC_APB1LPENR_TIM2LPEN_Pos   = 0x0        // Position of TIM2LPEN field.
	RCC_APB1LPENR_TIM2LPEN_Msk   = 0x1        // Bit mask of TIM2LPEN field.
	RCC_APB1LPENR_TIM2LPEN       = 0x1        // Bit TIM2LPEN.

	// APB2LPENR: APB2 peripheral clock enabled in low power           mode register
	RCC_APB2LPENR_TIM1LPEN_Pos   = 0x0     // Position of TIM1LPEN field.
	RCC_APB2LPENR_TIM1LPEN_Msk   = 0x1     // Bit mask of TIM1LPEN field.
	RCC_APB2LPENR_TIM1LPEN       = 0x1     // Bit TIM1LPEN.
	RCC_APB2LPENR_USART1LPEN_Pos = 0x4     // Position of USART1LPEN field.
	RCC_APB2LPENR_USART1LPEN_Msk = 0x10    // Bit mask of USART1LPEN field.
	RCC_APB2LPENR_USART1LPEN     = 0x10    // Bit USART1LPEN.
	RCC_APB2LPENR_USART6LPEN_Pos = 0x5     // Position of USART6LPEN field.
	RCC_APB2LPENR_USART6LPEN_Msk = 0x20    // Bit mask of USART6LPEN field.
	RCC_APB2LPENR_USART6LPEN     = 0x20    // Bit USART6LPEN.
	RCC_APB2LPENR_ADC1LPEN_Pos   = 0x8     // Position of ADC1LPEN field.
	RCC_APB2LPENR_ADC1LPEN_Msk   = 0x100   // Bit mask of ADC1LPEN field.
	RCC_APB2LPENR_ADC1LPEN       = 0x100   // Bit ADC1LPEN.
	RCC_APB2LPENR_SDIOLPEN_Pos   = 0xb     // Position of SDIOLPEN field.
	RCC_APB2LPENR_SDIOLPEN_Msk   = 0x800   // Bit mask of SDIOLPEN field.
	RCC_APB2LPENR_SDIOLPEN       = 0x800   // Bit SDIOLPEN.
	RCC_APB2LPENR_SPI1LPEN_Pos   = 0xc     // Position of SPI1LPEN field.
	RCC_APB2LPENR_SPI1LPEN_Msk   = 0x1000  // Bit mask of SPI1LPEN field.
	RCC_APB2LPENR_SPI1LPEN       = 0x1000  // Bit SPI1LPEN.
	RCC_APB2LPENR_SPI4LPEN_Pos   = 0xd     // Position of SPI4LPEN field.
	RCC_APB2LPENR_SPI4LPEN_Msk   = 0x2000  // Bit mask of SPI4LPEN field.
	RCC_APB2LPENR_SPI4LPEN       = 0x2000  // Bit SPI4LPEN.
	RCC_APB2LPENR_SYSCFGLPEN_Pos = 0xe     // Position of SYSCFGLPEN field.
	RCC_APB2LPENR_SYSCFGLPEN_Msk = 0x4000  // Bit mask of SYSCFGLPEN field.
	RCC_APB2LPENR_SYSCFGLPEN     = 0x4000  // Bit SYSCFGLPEN.
	RCC_APB2LPENR_TIM9LPEN_Pos   = 0x10    // Position of TIM9LPEN field.
	RCC_APB2LPENR_TIM9LPEN_Msk   = 0x10000 // Bit mask of TIM9LPEN field.
	RCC_APB2LPENR_TIM9LPEN       = 0x10000 // Bit TIM9LPEN.
	RCC_APB2LPENR_TIM10LPEN_Pos  = 0x11    // Position of TIM10LPEN field.
	RCC_APB2LPENR_TIM10LPEN_Msk  = 0x20000 // Bit mask of TIM10LPEN field.
	RCC_APB2LPENR_TIM10LPEN      = 0x20000 // Bit TIM10LPEN.
	RCC_APB2LPENR_TIM11LPEN_Pos  = 0x12    // Position of TIM11LPEN field.
	RCC_APB2LPENR_TIM11LPEN_Msk  = 0x40000 // Bit mask of TIM11LPEN field.
	RCC_APB2LPENR_TIM11LPEN      = 0x40000 // Bit TIM11LPEN.

	// BDCR: Backup domain control register
	RCC_BDCR_BDRST_Pos   = 0x10    // Position of BDRST field.
	RCC_BDCR_BDRST_Msk   = 0x10000 // Bit mask of BDRST field.
	RCC_BDCR_BDRST       = 0x10000 // Bit BDRST.
	RCC_BDCR_RTCEN_Pos   = 0xf     // Position of RTCEN field.
	RCC_BDCR_RTCEN_Msk   = 0x8000  // Bit mask of RTCEN field.
	RCC_BDCR_RTCEN       = 0x8000  // Bit RTCEN.
	RCC_BDCR_RTCSEL1_Pos = 0x9     // Position of RTCSEL1 field.
	RCC_BDCR_RTCSEL1_Msk = 0x200   // Bit mask of RTCSEL1 field.
	RCC_BDCR_RTCSEL1     = 0x200   // Bit RTCSEL1.
	RCC_BDCR_RTCSEL0_Pos = 0x8     // Position of RTCSEL0 field.
	RCC_BDCR_RTCSEL0_Msk = 0x100   // Bit mask of RTCSEL0 field.
	RCC_BDCR_RTCSEL0     = 0x100   // Bit RTCSEL0.
	RCC_BDCR_LSEBYP_Pos  = 0x2     // Position of LSEBYP field.
	RCC_BDCR_LSEBYP_Msk  = 0x4     // Bit mask of LSEBYP field.
	RCC_BDCR_LSEBYP      = 0x4     // Bit LSEBYP.
	RCC_BDCR_LSERDY_Pos  = 0x1     // Position of LSERDY field.
	RCC_BDCR_LSERDY_Msk  = 0x2     // Bit mask of LSERDY field.
	RCC_BDCR_LSERDY      = 0x2     // Bit LSERDY.
	RCC_BDCR_LSEON_Pos   = 0x0     // Position of LSEON field.
	RCC_BDCR_LSEON_Msk   = 0x1     // Bit mask of LSEON field.
	RCC_BDCR_LSEON       = 0x1     // Bit LSEON.

	// CSR: clock control & status           register
	RCC_CSR_LPWRRSTF_Pos = 0x1f       // Position of LPWRRSTF field.
	RCC_CSR_LPWRRSTF_Msk = 0x80000000 // Bit mask of LPWRRSTF field.
	RCC_CSR_LPWRRSTF     = 0x80000000 // Bit LPWRRSTF.
	RCC_CSR_WWDGRSTF_Pos = 0x1e       // Position of WWDGRSTF field.
	RCC_CSR_WWDGRSTF_Msk = 0x40000000 // Bit mask of WWDGRSTF field.
	RCC_CSR_WWDGRSTF     = 0x40000000 // Bit WWDGRSTF.
	RCC_CSR_WDGRSTF_Pos  = 0x1d       // Position of WDGRSTF field.
	RCC_CSR_WDGRSTF_Msk  = 0x20000000 // Bit mask of WDGRSTF field.
	RCC_CSR_WDGRSTF      = 0x20000000 // Bit WDGRSTF.
	RCC_CSR_SFTRSTF_Pos  = 0x1c       // Position of SFTRSTF field.
	RCC_CSR_SFTRSTF_Msk  = 0x10000000 // Bit mask of SFTRSTF field.
	RCC_CSR_SFTRSTF      = 0x10000000 // Bit SFTRSTF.
	RCC_CSR_PORRSTF_Pos  = 0x1b       // Position of PORRSTF field.
	RCC_CSR_PORRSTF_Msk  = 0x8000000  // Bit mask of PORRSTF field.
	RCC_CSR_PORRSTF      = 0x8000000  // Bit PORRSTF.
	RCC_CSR_PADRSTF_Pos  = 0x1a       // Position of PADRSTF field.
	RCC_CSR_PADRSTF_Msk  = 0x4000000  // Bit mask of PADRSTF field.
	RCC_CSR_PADRSTF      = 0x4000000  // Bit PADRSTF.
	RCC_CSR_BORRSTF_Pos  = 0x19       // Position of BORRSTF field.
	RCC_CSR_BORRSTF_Msk  = 0x2000000  // Bit mask of BORRSTF field.
	RCC_CSR_BORRSTF      = 0x2000000  // Bit BORRSTF.
	RCC_CSR_RMVF_Pos     = 0x18       // Position of RMVF field.
	RCC_CSR_RMVF_Msk     = 0x1000000  // Bit mask of RMVF field.
	RCC_CSR_RMVF         = 0x1000000  // Bit RMVF.
	RCC_CSR_LSIRDY_Pos   = 0x1        // Position of LSIRDY field.
	RCC_CSR_LSIRDY_Msk   = 0x2        // Bit mask of LSIRDY field.
	RCC_CSR_LSIRDY       = 0x2        // Bit LSIRDY.
	RCC_CSR_LSION_Pos    = 0x0        // Position of LSION field.
	RCC_CSR_LSION_Msk    = 0x1        // Bit mask of LSION field.
	RCC_CSR_LSION        = 0x1        // Bit LSION.

	// SSCGR: spread spectrum clock generation           register
	RCC_SSCGR_SSCGEN_Pos    = 0x1f       // Position of SSCGEN field.
	RCC_SSCGR_SSCGEN_Msk    = 0x80000000 // Bit mask of SSCGEN field.
	RCC_SSCGR_SSCGEN        = 0x80000000 // Bit SSCGEN.
	RCC_SSCGR_SPREADSEL_Pos = 0x1e       // Position of SPREADSEL field.
	RCC_SSCGR_SPREADSEL_Msk = 0x40000000 // Bit mask of SPREADSEL field.
	RCC_SSCGR_SPREADSEL     = 0x40000000 // Bit SPREADSEL.
	RCC_SSCGR_INCSTEP_Pos   = 0xd        // Position of INCSTEP field.
	RCC_SSCGR_INCSTEP_Msk   = 0xfffe000  // Bit mask of INCSTEP field.
	RCC_SSCGR_MODPER_Pos    = 0x0        // Position of MODPER field.
	RCC_SSCGR_MODPER_Msk    = 0x1fff     // Bit mask of MODPER field.

	// PLLI2SCFGR: PLLI2S configuration register
	RCC_PLLI2SCFGR_PLLI2SRx_Pos = 0x1c       // Position of PLLI2SRx field.
	RCC_PLLI2SCFGR_PLLI2SRx_Msk = 0x70000000 // Bit mask of PLLI2SRx field.
	RCC_PLLI2SCFGR_PLLI2SNx_Pos = 0x6        // Position of PLLI2SNx field.
	RCC_PLLI2SCFGR_PLLI2SNx_Msk = 0x7fc0     // Bit mask of PLLI2SNx field.
)

// Bitfields for RTC: Real-time clock
const (
	// TR: time register
	RTC_TR_PM_Pos  = 0x16     // Position of PM field.
	RTC_TR_PM_Msk  = 0x400000 // Bit mask of PM field.
	RTC_TR_PM      = 0x400000 // Bit PM.
	RTC_TR_HT_Pos  = 0x14     // Position of HT field.
	RTC_TR_HT_Msk  = 0x300000 // Bit mask of HT field.
	RTC_TR_HU_Pos  = 0x10     // Position of HU field.
	RTC_TR_HU_Msk  = 0xf0000  // Bit mask of HU field.
	RTC_TR_MNT_Pos = 0xc      // Position of MNT field.
	RTC_TR_MNT_Msk = 0x7000   // Bit mask of MNT field.
	RTC_TR_MNU_Pos = 0x8      // Position of MNU field.
	RTC_TR_MNU_Msk = 0xf00    // Bit mask of MNU field.
	RTC_TR_ST_Pos  = 0x4      // Position of ST field.
	RTC_TR_ST_Msk  = 0x70     // Bit mask of ST field.
	RTC_TR_SU_Pos  = 0x0      // Position of SU field.
	RTC_TR_SU_Msk  = 0xf      // Bit mask of SU field.

	// DR: date register
	RTC_DR_YT_Pos  = 0x14     // Position of YT field.
	RTC_DR_YT_Msk  = 0xf00000 // Bit mask of YT field.
	RTC_DR_YU_Pos  = 0x10     // Position of YU field.
	RTC_DR_YU_Msk  = 0xf0000  // Bit mask of YU field.
	RTC_DR_WDU_Pos = 0xd      // Position of WDU field.
	RTC_DR_WDU_Msk = 0xe000   // Bit mask of WDU field.
	RTC_DR_MT_Pos  = 0xc      // Position of MT field.
	RTC_DR_MT_Msk  = 0x1000   // Bit mask of MT field.
	RTC_DR_MT      = 0x1000   // Bit MT.
	RTC_DR_MU_Pos  = 0x8      // Position of MU field.
	RTC_DR_MU_Msk  = 0xf00    // Bit mask of MU field.
	RTC_DR_DT_Pos  = 0x4      // Position of DT field.
	RTC_DR_DT_Msk  = 0x30     // Bit mask of DT field.
	RTC_DR_DU_Pos  = 0x0      // Position of DU field.
	RTC_DR_DU_Msk  = 0xf      // Bit mask of DU field.

	// CR: control register
	RTC_CR_COE_Pos     = 0x17     // Position of COE field.
	RTC_CR_COE_Msk     = 0x800000 // Bit mask of COE field.
	RTC_CR_COE         = 0x800000 // Bit COE.
	RTC_CR_OSEL_Pos    = 0x15     // Position of OSEL field.
	RTC_CR_OSEL_Msk    = 0x600000 // Bit mask of OSEL field.
	RTC_CR_POL_Pos     = 0x14     // Position of POL field.
	RTC_CR_POL_Msk     = 0x100000 // Bit mask of POL field.
	RTC_CR_POL         = 0x100000 // Bit POL.
	RTC_CR_COSEL_Pos   = 0x13     // Position of COSEL field.
	RTC_CR_COSEL_Msk   = 0x80000  // Bit mask of COSEL field.
	RTC_CR_COSEL       = 0x80000  // Bit COSEL.
	RTC_CR_BKP_Pos     = 0x12     // Position of BKP field.
	RTC_CR_BKP_Msk     = 0x40000  // Bit mask of BKP field.
	RTC_CR_BKP         = 0x40000  // Bit BKP.
	RTC_CR_SUB1H_Pos   = 0x11     // Position of SUB1H field.
	RTC_CR_SUB1H_Msk   = 0x20000  // Bit mask of SUB1H field.
	RTC_CR_SUB1H       = 0x20000  // Bit SUB1H.
	RTC_CR_ADD1H_Pos   = 0x10     // Position of ADD1H field.
	RTC_CR_ADD1H_Msk   = 0x10000  // Bit mask of ADD1H field.
	RTC_CR_ADD1H       = 0x10000  // Bit ADD1H.
	RTC_CR_TSIE_Pos    = 0xf      // Position of TSIE field.
	RTC_CR_TSIE_Msk    = 0x8000   // Bit mask of TSIE field.
	RTC_CR_TSIE        = 0x8000   // Bit TSIE.
	RTC_CR_WUTIE_Pos   = 0xe      // Position of WUTIE field.
	RTC_CR_WUTIE_Msk   = 0x4000   // Bit mask of WUTIE field.
	RTC_CR_WUTIE       = 0x4000   // Bit WUTIE.
	RTC_CR_ALRBIE_Pos  = 0xd      // Position of ALRBIE field.
	RTC_CR_ALRBIE_Msk  = 0x2000   // Bit mask of ALRBIE field.
	RTC_CR_ALRBIE      = 0x2000   // Bit ALRBIE.
	RTC_CR_ALRAIE_Pos  = 0xc      // Position of ALRAIE field.
	RTC_CR_ALRAIE_Msk  = 0x1000   // Bit mask of ALRAIE field.
	RTC_CR_ALRAIE      = 0x1000   // Bit ALRAIE.
	RTC_CR_TSE_Pos     = 0xb      // Position of TSE field.
	RTC_CR_TSE_Msk     = 0x800    // Bit mask of TSE field.
	RTC_CR_TSE         = 0x800    // Bit TSE.
	RTC_CR_WUTE_Pos    = 0xa      // Position of WUTE field.
	RTC_CR_WUTE_Msk    = 0x400    // Bit mask of WUTE field.
	RTC_CR_WUTE        = 0x400    // Bit WUTE.
	RTC_CR_ALRBE_Pos   = 0x9      // Position of ALRBE field.
	RTC_CR_ALRBE_Msk   = 0x200    // Bit mask of ALRBE field.
	RTC_CR_ALRBE       = 0x200    // Bit ALRBE.
	RTC_CR_ALRAE_Pos   = 0x8      // Position of ALRAE field.
	RTC_CR_ALRAE_Msk   = 0x100    // Bit mask of ALRAE field.
	RTC_CR_ALRAE       = 0x100    // Bit ALRAE.
	RTC_CR_DCE_Pos     = 0x7      // Position of DCE field.
	RTC_CR_DCE_Msk     = 0x80     // Bit mask of DCE field.
	RTC_CR_DCE         = 0x80     // Bit DCE.
	RTC_CR_FMT_Pos     = 0x6      // Position of FMT field.
	RTC_CR_FMT_Msk     = 0x40     // Bit mask of FMT field.
	RTC_CR_FMT         = 0x40     // Bit FMT.
	RTC_CR_BYPSHAD_Pos = 0x5      // Position of BYPSHAD field.
	RTC_CR_BYPSHAD_Msk = 0x20     // Bit mask of BYPSHAD field.
	RTC_CR_BYPSHAD     = 0x20     // Bit BYPSHAD.
	RTC_CR_REFCKON_Pos = 0x4      // Position of REFCKON field.
	RTC_CR_REFCKON_Msk = 0x10     // Bit mask of REFCKON field.
	RTC_CR_REFCKON     = 0x10     // Bit REFCKON.
	RTC_CR_TSEDGE_Pos  = 0x3      // Position of TSEDGE field.
	RTC_CR_TSEDGE_Msk  = 0x8      // Bit mask of TSEDGE field.
	RTC_CR_TSEDGE      = 0x8      // Bit TSEDGE.
	RTC_CR_WCKSEL_Pos  = 0x0      // Position of WCKSEL field.
	RTC_CR_WCKSEL_Msk  = 0x7      // Bit mask of WCKSEL field.

	// ISR: initialization and status           register
	RTC_ISR_ALRAWF_Pos  = 0x0     // Position of ALRAWF field.
	RTC_ISR_ALRAWF_Msk  = 0x1     // Bit mask of ALRAWF field.
	RTC_ISR_ALRAWF      = 0x1     // Bit ALRAWF.
	RTC_ISR_ALRBWF_Pos  = 0x1     // Position of ALRBWF field.
	RTC_ISR_ALRBWF_Msk  = 0x2     // Bit mask of ALRBWF field.
	RTC_ISR_ALRBWF      = 0x2     // Bit ALRBWF.
	RTC_ISR_WUTWF_Pos   = 0x2     // Position of WUTWF field.
	RTC_ISR_WUTWF_Msk   = 0x4     // Bit mask of WUTWF field.
	RTC_ISR_WUTWF       = 0x4     // Bit WUTWF.
	RTC_ISR_SHPF_Pos    = 0x3     // Position of SHPF field.
	RTC_ISR_SHPF_Msk    = 0x8     // Bit mask of SHPF field.
	RTC_ISR_SHPF        = 0x8     // Bit SHPF.
	RTC_ISR_INITS_Pos   = 0x4     // Position of INITS field.
	RTC_ISR_INITS_Msk   = 0x10    // Bit mask of INITS field.
	RTC_ISR_INITS       = 0x10    // Bit INITS.
	RTC_ISR_RSF_Pos     = 0x5     // Position of RSF field.
	RTC_ISR_RSF_Msk     = 0x20    // Bit mask of RSF field.
	RTC_ISR_RSF         = 0x20    // Bit RSF.
	RTC_ISR_INITF_Pos   = 0x6     // Position of INITF field.
	RTC_ISR_INITF_Msk   = 0x40    // Bit mask of INITF field.
	RTC_ISR_INITF       = 0x40    // Bit INITF.
	RTC_ISR_INIT_Pos    = 0x7     // Position of INIT field.
	RTC_ISR_INIT_Msk    = 0x80    // Bit mask of INIT field.
	RTC_ISR_INIT        = 0x80    // Bit INIT.
	RTC_ISR_ALRAF_Pos   = 0x8     // Position of ALRAF field.
	RTC_ISR_ALRAF_Msk   = 0x100   // Bit mask of ALRAF field.
	RTC_ISR_ALRAF       = 0x100   // Bit ALRAF.
	RTC_ISR_ALRBF_Pos   = 0x9     // Position of ALRBF field.
	RTC_ISR_ALRBF_Msk   = 0x200   // Bit mask of ALRBF field.
	RTC_ISR_ALRBF       = 0x200   // Bit ALRBF.
	RTC_ISR_WUTF_Pos    = 0xa     // Position of WUTF field.
	RTC_ISR_WUTF_Msk    = 0x400   // Bit mask of WUTF field.
	RTC_ISR_WUTF        = 0x400   // Bit WUTF.
	RTC_ISR_TSF_Pos     = 0xb     // Position of TSF field.
	RTC_ISR_TSF_Msk     = 0x800   // Bit mask of TSF field.
	RTC_ISR_TSF         = 0x800   // Bit TSF.
	RTC_ISR_TSOVF_Pos   = 0xc     // Position of TSOVF field.
	RTC_ISR_TSOVF_Msk   = 0x1000  // Bit mask of TSOVF field.
	RTC_ISR_TSOVF       = 0x1000  // Bit TSOVF.
	RTC_ISR_TAMP1F_Pos  = 0xd     // Position of TAMP1F field.
	RTC_ISR_TAMP1F_Msk  = 0x2000  // Bit mask of TAMP1F field.
	RTC_ISR_TAMP1F      = 0x2000  // Bit TAMP1F.
	RTC_ISR_TAMP2F_Pos  = 0xe     // Position of TAMP2F field.
	RTC_ISR_TAMP2F_Msk  = 0x4000  // Bit mask of TAMP2F field.
	RTC_ISR_TAMP2F      = 0x4000  // Bit TAMP2F.
	RTC_ISR_RECALPF_Pos = 0x10    // Position of RECALPF field.
	RTC_ISR_RECALPF_Msk = 0x10000 // Bit mask of RECALPF field.
	RTC_ISR_RECALPF     = 0x10000 // Bit RECALPF.

	// PRER: prescaler register
	RTC_PRER_PREDIV_A_Pos = 0x10     // Position of PREDIV_A field.
	RTC_PRER_PREDIV_A_Msk = 0x7f0000 // Bit mask of PREDIV_A field.
	RTC_PRER_PREDIV_S_Pos = 0x0      // Position of PREDIV_S field.
	RTC_PRER_PREDIV_S_Msk = 0x7fff   // Bit mask of PREDIV_S field.

	// WUTR: wakeup timer register
	RTC_WUTR_WUT_Pos = 0x0    // Position of WUT field.
	RTC_WUTR_WUT_Msk = 0xffff // Bit mask of WUT field.

	// CALIBR: calibration register
	RTC_CALIBR_DCS_Pos = 0x7  // Position of DCS field.
	RTC_CALIBR_DCS_Msk = 0x80 // Bit mask of DCS field.
	RTC_CALIBR_DCS     = 0x80 // Bit DCS.
	RTC_CALIBR_DC_Pos  = 0x0  // Position of DC field.
	RTC_CALIBR_DC_Msk  = 0x1f // Bit mask of DC field.

	// ALRMAR: alarm A register
	RTC_ALRMAR_MSK4_Pos  = 0x1f       // Position of MSK4 field.
	RTC_ALRMAR_MSK4_Msk  = 0x80000000 // Bit mask of MSK4 field.
	RTC_ALRMAR_MSK4      = 0x80000000 // Bit MSK4.
	RTC_ALRMAR_WDSEL_Pos = 0x1e       // Position of WDSEL field.
	RTC_ALRMAR_WDSEL_Msk = 0x40000000 // Bit mask of WDSEL field.
	RTC_ALRMAR_WDSEL     = 0x40000000 // Bit WDSEL.
	RTC_ALRMAR_DT_Pos    = 0x1c       // Position of DT field.
	RTC_ALRMAR_DT_Msk    = 0x30000000 // Bit mask of DT field.
	RTC_ALRMAR_DU_Pos    = 0x18       // Position of DU field.
	RTC_ALRMAR_DU_Msk    = 0xf000000  // Bit mask of DU field.
	RTC_ALRMAR_MSK3_Pos  = 0x17       // Position of MSK3 field.
	RTC_ALRMAR_MSK3_Msk  = 0x800000   // Bit mask of MSK3 field.
	RTC_ALRMAR_MSK3      = 0x800000   // Bit MSK3.
	RTC_ALRMAR_PM_Pos    = 0x16       // Position of PM field.
	RTC_ALRMAR_PM_Msk    = 0x400000   // Bit mask of PM field.
	RTC_ALRMAR_PM        = 0x400000   // Bit PM.
	RTC_ALRMAR_HT_Pos    = 0x14       // Position of HT field.
	RTC_ALRMAR_HT_Msk    = 0x300000   // Bit mask of HT field.
	RTC_ALRMAR_HU_Pos    = 0x10       // Position of HU field.
	RTC_ALRMAR_HU_Msk    = 0xf0000    // Bit mask of HU field.
	RTC_ALRMAR_MSK2_Pos  = 0xf        // Position of MSK2 field.
	RTC_ALRMAR_MSK2_Msk  = 0x8000     // Bit mask of MSK2 field.
	RTC_ALRMAR_MSK2      = 0x8000     // Bit MSK2.
	RTC_ALRMAR_MNT_Pos   = 0xc        // Position of MNT field.
	RTC_ALRMAR_MNT_Msk   = 0x7000     // Bit mask of MNT field.
	RTC_ALRMAR_MNU_Pos   = 0x8        // Position of MNU field.
	RTC_ALRMAR_MNU_Msk   = 0xf00      // Bit mask of MNU field.
	RTC_ALRMAR_MSK1_Pos  = 0x7        // Position of MSK1 field.
	RTC_ALRMAR_MSK1_Msk  = 0x80       // Bit mask of MSK1 field.
	RTC_ALRMAR_MSK1      = 0x80       // Bit MSK1.
	RTC_ALRMAR_ST_Pos    = 0x4        // Position of ST field.
	RTC_ALRMAR_ST_Msk    = 0x70       // Bit mask of ST field.
	RTC_ALRMAR_SU_Pos    = 0x0        // Position of SU field.
	RTC_ALRMAR_SU_Msk    = 0xf        // Bit mask of SU field.

	// ALRMBR: alarm B register
	RTC_ALRMBR_MSK4_Pos  = 0x1f       // Position of MSK4 field.
	RTC_ALRMBR_MSK4_Msk  = 0x80000000 // Bit mask of MSK4 field.
	RTC_ALRMBR_MSK4      = 0x80000000 // Bit MSK4.
	RTC_ALRMBR_WDSEL_Pos = 0x1e       // Position of WDSEL field.
	RTC_ALRMBR_WDSEL_Msk = 0x40000000 // Bit mask of WDSEL field.
	RTC_ALRMBR_WDSEL     = 0x40000000 // Bit WDSEL.
	RTC_ALRMBR_DT_Pos    = 0x1c       // Position of DT field.
	RTC_ALRMBR_DT_Msk    = 0x30000000 // Bit mask of DT field.
	RTC_ALRMBR_DU_Pos    = 0x18       // Position of DU field.
	RTC_ALRMBR_DU_Msk    = 0xf000000  // Bit mask of DU field.
	RTC_ALRMBR_MSK3_Pos  = 0x17       // Position of MSK3 field.
	RTC_ALRMBR_MSK3_Msk  = 0x800000   // Bit mask of MSK3 field.
	RTC_ALRMBR_MSK3      = 0x800000   // Bit MSK3.
	RTC_ALRMBR_PM_Pos    = 0x16       // Position of PM field.
	RTC_ALRMBR_PM_Msk    = 0x400000   // Bit mask of PM field.
	RTC_ALRMBR_PM        = 0x400000   // Bit PM.
	RTC_ALRMBR_HT_Pos    = 0x14       // Position of HT field.
	RTC_ALRMBR_HT_Msk    = 0x300000   // Bit mask of HT field.
	RTC_ALRMBR_HU_Pos    = 0x10       // Position of HU field.
	RTC_ALRMBR_HU_Msk    = 0xf0000    // Bit mask of HU field.
	RTC_ALRMBR_MSK2_Pos  = 0xf        // Position of MSK2 field.
	RTC_ALRMBR_MSK2_Msk  = 0x8000     // Bit mask of MSK2 field.
	RTC_ALRMBR_MSK2      = 0x8000     // Bit MSK2.
	RTC_ALRMBR_MNT_Pos   = 0xc        // Position of MNT field.
	RTC_ALRMBR_MNT_Msk   = 0x7000     // Bit mask of MNT field.
	RTC_ALRMBR_MNU_Pos   = 0x8        // Position of MNU field.
	RTC_ALRMBR_MNU_Msk   = 0xf00      // Bit mask of MNU field.
	RTC_ALRMBR_MSK1_Pos  = 0x7        // Position of MSK1 field.
	RTC_ALRMBR_MSK1_Msk  = 0x80       // Bit mask of MSK1 field.
	RTC_ALRMBR_MSK1      = 0x80       // Bit MSK1.
	RTC_ALRMBR_ST_Pos    = 0x4        // Position of ST field.
	RTC_ALRMBR_ST_Msk    = 0x70       // Bit mask of ST field.
	RTC_ALRMBR_SU_Pos    = 0x0        // Position of SU field.
	RTC_ALRMBR_SU_Msk    = 0xf        // Bit mask of SU field.

	// WPR: write protection register
	RTC_WPR_KEY_Pos = 0x0  // Position of KEY field.
	RTC_WPR_KEY_Msk = 0xff // Bit mask of KEY field.

	// SSR: sub second register
	RTC_SSR_SS_Pos = 0x0    // Position of SS field.
	RTC_SSR_SS_Msk = 0xffff // Bit mask of SS field.

	// SHIFTR: shift control register
	RTC_SHIFTR_ADD1S_Pos = 0x1f       // Position of ADD1S field.
	RTC_SHIFTR_ADD1S_Msk = 0x80000000 // Bit mask of ADD1S field.
	RTC_SHIFTR_ADD1S     = 0x80000000 // Bit ADD1S.
	RTC_SHIFTR_SUBFS_Pos = 0x0        // Position of SUBFS field.
	RTC_SHIFTR_SUBFS_Msk = 0x7fff     // Bit mask of SUBFS field.

	// TSTR: time stamp time register
	RTC_TSTR_PM_Pos  = 0x16     // Position of PM field.
	RTC_TSTR_PM_Msk  = 0x400000 // Bit mask of PM field.
	RTC_TSTR_PM      = 0x400000 // Bit PM.
	RTC_TSTR_HT_Pos  = 0x14     // Position of HT field.
	RTC_TSTR_HT_Msk  = 0x300000 // Bit mask of HT field.
	RTC_TSTR_HU_Pos  = 0x10     // Position of HU field.
	RTC_TSTR_HU_Msk  = 0xf0000  // Bit mask of HU field.
	RTC_TSTR_MNT_Pos = 0xc      // Position of MNT field.
	RTC_TSTR_MNT_Msk = 0x7000   // Bit mask of MNT field.
	RTC_TSTR_MNU_Pos = 0x8      // Position of MNU field.
	RTC_TSTR_MNU_Msk = 0xf00    // Bit mask of MNU field.
	RTC_TSTR_ST_Pos  = 0x4      // Position of ST field.
	RTC_TSTR_ST_Msk  = 0x70     // Bit mask of ST field.
	RTC_TSTR_SU_Pos  = 0x0      // Position of SU field.
	RTC_TSTR_SU_Msk  = 0xf      // Bit mask of SU field.

	// TSDR: time stamp date register
	RTC_TSDR_WDU_Pos = 0xd    // Position of WDU field.
	RTC_TSDR_WDU_Msk = 0xe000 // Bit mask of WDU field.
	RTC_TSDR_MT_Pos  = 0xc    // Position of MT field.
	RTC_TSDR_MT_Msk  = 0x1000 // Bit mask of MT field.
	RTC_TSDR_MT      = 0x1000 // Bit MT.
	RTC_TSDR_MU_Pos  = 0x8    // Position of MU field.
	RTC_TSDR_MU_Msk  = 0xf00  // Bit mask of MU field.
	RTC_TSDR_DT_Pos  = 0x4    // Position of DT field.
	RTC_TSDR_DT_Msk  = 0x30   // Bit mask of DT field.
	RTC_TSDR_DU_Pos  = 0x0    // Position of DU field.
	RTC_TSDR_DU_Msk  = 0xf    // Bit mask of DU field.

	// TSSSR: timestamp sub second register
	RTC_TSSSR_SS_Pos = 0x0    // Position of SS field.
	RTC_TSSSR_SS_Msk = 0xffff // Bit mask of SS field.

	// CALR: calibration register
	RTC_CALR_CALP_Pos   = 0xf    // Position of CALP field.
	RTC_CALR_CALP_Msk   = 0x8000 // Bit mask of CALP field.
	RTC_CALR_CALP       = 0x8000 // Bit CALP.
	RTC_CALR_CALW8_Pos  = 0xe    // Position of CALW8 field.
	RTC_CALR_CALW8_Msk  = 0x4000 // Bit mask of CALW8 field.
	RTC_CALR_CALW8      = 0x4000 // Bit CALW8.
	RTC_CALR_CALW16_Pos = 0xd    // Position of CALW16 field.
	RTC_CALR_CALW16_Msk = 0x2000 // Bit mask of CALW16 field.
	RTC_CALR_CALW16     = 0x2000 // Bit CALW16.
	RTC_CALR_CALM_Pos   = 0x0    // Position of CALM field.
	RTC_CALR_CALM_Msk   = 0x1ff  // Bit mask of CALM field.

	// TAFCR: tamper and alternate function configuration           register
	RTC_TAFCR_ALARMOUTTYPE_Pos = 0x12    // Position of ALARMOUTTYPE field.
	RTC_TAFCR_ALARMOUTTYPE_Msk = 0x40000 // Bit mask of ALARMOUTTYPE field.
	RTC_TAFCR_ALARMOUTTYPE     = 0x40000 // Bit ALARMOUTTYPE.
	RTC_TAFCR_TSINSEL_Pos      = 0x11    // Position of TSINSEL field.
	RTC_TAFCR_TSINSEL_Msk      = 0x20000 // Bit mask of TSINSEL field.
	RTC_TAFCR_TSINSEL          = 0x20000 // Bit TSINSEL.
	RTC_TAFCR_TAMP1INSEL_Pos   = 0x10    // Position of TAMP1INSEL field.
	RTC_TAFCR_TAMP1INSEL_Msk   = 0x10000 // Bit mask of TAMP1INSEL field.
	RTC_TAFCR_TAMP1INSEL       = 0x10000 // Bit TAMP1INSEL.
	RTC_TAFCR_TAMPPUDIS_Pos    = 0xf     // Position of TAMPPUDIS field.
	RTC_TAFCR_TAMPPUDIS_Msk    = 0x8000  // Bit mask of TAMPPUDIS field.
	RTC_TAFCR_TAMPPUDIS        = 0x8000  // Bit TAMPPUDIS.
	RTC_TAFCR_TAMPPRCH_Pos     = 0xd     // Position of TAMPPRCH field.
	RTC_TAFCR_TAMPPRCH_Msk     = 0x6000  // Bit mask of TAMPPRCH field.
	RTC_TAFCR_TAMPFLT_Pos      = 0xb     // Position of TAMPFLT field.
	RTC_TAFCR_TAMPFLT_Msk      = 0x1800  // Bit mask of TAMPFLT field.
	RTC_TAFCR_TAMPFREQ_Pos     = 0x8     // Position of TAMPFREQ field.
	RTC_TAFCR_TAMPFREQ_Msk     = 0x700   // Bit mask of TAMPFREQ field.
	RTC_TAFCR_TAMPTS_Pos       = 0x7     // Position of TAMPTS field.
	RTC_TAFCR_TAMPTS_Msk       = 0x80    // Bit mask of TAMPTS field.
	RTC_TAFCR_TAMPTS           = 0x80    // Bit TAMPTS.
	RTC_TAFCR_TAMP2TRG_Pos     = 0x4     // Position of TAMP2TRG field.
	RTC_TAFCR_TAMP2TRG_Msk     = 0x10    // Bit mask of TAMP2TRG field.
	RTC_TAFCR_TAMP2TRG         = 0x10    // Bit TAMP2TRG.
	RTC_TAFCR_TAMP2E_Pos       = 0x3     // Position of TAMP2E field.
	RTC_TAFCR_TAMP2E_Msk       = 0x8     // Bit mask of TAMP2E field.
	RTC_TAFCR_TAMP2E           = 0x8     // Bit TAMP2E.
	RTC_TAFCR_TAMPIE_Pos       = 0x2     // Position of TAMPIE field.
	RTC_TAFCR_TAMPIE_Msk       = 0x4     // Bit mask of TAMPIE field.
	RTC_TAFCR_TAMPIE           = 0x4     // Bit TAMPIE.
	RTC_TAFCR_TAMP1TRG_Pos     = 0x1     // Position of TAMP1TRG field.
	RTC_TAFCR_TAMP1TRG_Msk     = 0x2     // Bit mask of TAMP1TRG field.
	RTC_TAFCR_TAMP1TRG         = 0x2     // Bit TAMP1TRG.
	RTC_TAFCR_TAMP1E_Pos       = 0x0     // Position of TAMP1E field.
	RTC_TAFCR_TAMP1E_Msk       = 0x1     // Bit mask of TAMP1E field.
	RTC_TAFCR_TAMP1E           = 0x1     // Bit TAMP1E.

	// ALRMASSR: alarm A sub second register
	RTC_ALRMASSR_MASKSS_Pos = 0x18      // Position of MASKSS field.
	RTC_ALRMASSR_MASKSS_Msk = 0xf000000 // Bit mask of MASKSS field.
	RTC_ALRMASSR_SS_Pos     = 0x0       // Position of SS field.
	RTC_ALRMASSR_SS_Msk     = 0x7fff    // Bit mask of SS field.

	// ALRMBSSR: alarm B sub second register
	RTC_ALRMBSSR_MASKSS_Pos = 0x18      // Position of MASKSS field.
	RTC_ALRMBSSR_MASKSS_Msk = 0xf000000 // Bit mask of MASKSS field.
	RTC_ALRMBSSR_SS_Pos     = 0x0       // Position of SS field.
	RTC_ALRMBSSR_SS_Msk     = 0x7fff    // Bit mask of SS field.

	// BKP0R: backup register
	RTC_BKP0R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP0R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP1R: backup register
	RTC_BKP1R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP1R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP2R: backup register
	RTC_BKP2R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP2R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP3R: backup register
	RTC_BKP3R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP3R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP4R: backup register
	RTC_BKP4R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP4R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP5R: backup register
	RTC_BKP5R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP5R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP6R: backup register
	RTC_BKP6R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP6R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP7R: backup register
	RTC_BKP7R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP7R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP8R: backup register
	RTC_BKP8R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP8R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP9R: backup register
	RTC_BKP9R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP9R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP10R: backup register
	RTC_BKP10R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP10R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP11R: backup register
	RTC_BKP11R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP11R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP12R: backup register
	RTC_BKP12R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP12R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP13R: backup register
	RTC_BKP13R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP13R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP14R: backup register
	RTC_BKP14R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP14R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP15R: backup register
	RTC_BKP15R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP15R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP16R: backup register
	RTC_BKP16R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP16R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP17R: backup register
	RTC_BKP17R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP17R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP18R: backup register
	RTC_BKP18R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP18R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP19R: backup register
	RTC_BKP19R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP19R_BKP_Msk = 0xffffffff // Bit mask of BKP field.
)

// Bitfields for SDIO: Secure digital input/output interface
const (
	// POWER: power control register
	SDIO_POWER_PWRCTRL_Pos = 0x0 // Position of PWRCTRL field.
	SDIO_POWER_PWRCTRL_Msk = 0x3 // Bit mask of PWRCTRL field.

	// CLKCR: SDI clock control register
	SDIO_CLKCR_HWFC_EN_Pos = 0xe    // Position of HWFC_EN field.
	SDIO_CLKCR_HWFC_EN_Msk = 0x4000 // Bit mask of HWFC_EN field.
	SDIO_CLKCR_HWFC_EN     = 0x4000 // Bit HWFC_EN.
	SDIO_CLKCR_NEGEDGE_Pos = 0xd    // Position of NEGEDGE field.
	SDIO_CLKCR_NEGEDGE_Msk = 0x2000 // Bit mask of NEGEDGE field.
	SDIO_CLKCR_NEGEDGE     = 0x2000 // Bit NEGEDGE.
	SDIO_CLKCR_WIDBUS_Pos  = 0xb    // Position of WIDBUS field.
	SDIO_CLKCR_WIDBUS_Msk  = 0x1800 // Bit mask of WIDBUS field.
	SDIO_CLKCR_BYPASS_Pos  = 0xa    // Position of BYPASS field.
	SDIO_CLKCR_BYPASS_Msk  = 0x400  // Bit mask of BYPASS field.
	SDIO_CLKCR_BYPASS      = 0x400  // Bit BYPASS.
	SDIO_CLKCR_PWRSAV_Pos  = 0x9    // Position of PWRSAV field.
	SDIO_CLKCR_PWRSAV_Msk  = 0x200  // Bit mask of PWRSAV field.
	SDIO_CLKCR_PWRSAV      = 0x200  // Bit PWRSAV.
	SDIO_CLKCR_CLKEN_Pos   = 0x8    // Position of CLKEN field.
	SDIO_CLKCR_CLKEN_Msk   = 0x100  // Bit mask of CLKEN field.
	SDIO_CLKCR_CLKEN       = 0x100  // Bit CLKEN.
	SDIO_CLKCR_CLKDIV_Pos  = 0x0    // Position of CLKDIV field.
	SDIO_CLKCR_CLKDIV_Msk  = 0xff   // Bit mask of CLKDIV field.

	// ARG: argument register
	SDIO_ARG_CMDARG_Pos = 0x0        // Position of CMDARG field.
	SDIO_ARG_CMDARG_Msk = 0xffffffff // Bit mask of CMDARG field.

	// CMD: command register
	SDIO_CMD_CE_ATACMD_Pos   = 0xe    // Position of CE_ATACMD field.
	SDIO_CMD_CE_ATACMD_Msk   = 0x4000 // Bit mask of CE_ATACMD field.
	SDIO_CMD_CE_ATACMD       = 0x4000 // Bit CE_ATACMD.
	SDIO_CMD_NIEN_Pos        = 0xd    // Position of NIEN field.
	SDIO_CMD_NIEN_Msk        = 0x2000 // Bit mask of NIEN field.
	SDIO_CMD_NIEN            = 0x2000 // Bit NIEN.
	SDIO_CMD_ENCMDcompl_Pos  = 0xc    // Position of ENCMDcompl field.
	SDIO_CMD_ENCMDcompl_Msk  = 0x1000 // Bit mask of ENCMDcompl field.
	SDIO_CMD_ENCMDcompl      = 0x1000 // Bit ENCMDcompl.
	SDIO_CMD_SDIOSuspend_Pos = 0xb    // Position of SDIOSuspend field.
	SDIO_CMD_SDIOSuspend_Msk = 0x800  // Bit mask of SDIOSuspend field.
	SDIO_CMD_SDIOSuspend     = 0x800  // Bit SDIOSuspend.
	SDIO_CMD_CPSMEN_Pos      = 0xa    // Position of CPSMEN field.
	SDIO_CMD_CPSMEN_Msk      = 0x400  // Bit mask of CPSMEN field.
	SDIO_CMD_CPSMEN          = 0x400  // Bit CPSMEN.
	SDIO_CMD_WAITPEND_Pos    = 0x9    // Position of WAITPEND field.
	SDIO_CMD_WAITPEND_Msk    = 0x200  // Bit mask of WAITPEND field.
	SDIO_CMD_WAITPEND        = 0x200  // Bit WAITPEND.
	SDIO_CMD_WAITINT_Pos     = 0x8    // Position of WAITINT field.
	SDIO_CMD_WAITINT_Msk     = 0x100  // Bit mask of WAITINT field.
	SDIO_CMD_WAITINT         = 0x100  // Bit WAITINT.
	SDIO_CMD_WAITRESP_Pos    = 0x6    // Position of WAITRESP field.
	SDIO_CMD_WAITRESP_Msk    = 0xc0   // Bit mask of WAITRESP field.
	SDIO_CMD_CMDINDEX_Pos    = 0x0    // Position of CMDINDEX field.
	SDIO_CMD_CMDINDEX_Msk    = 0x3f   // Bit mask of CMDINDEX field.

	// RESPCMD: command response register
	SDIO_RESPCMD_RESPCMD_Pos = 0x0  // Position of RESPCMD field.
	SDIO_RESPCMD_RESPCMD_Msk = 0x3f // Bit mask of RESPCMD field.

	// RESP1: response 1..4 register
	SDIO_RESP1_CARDSTATUS1_Pos = 0x0        // Position of CARDSTATUS1 field.
	SDIO_RESP1_CARDSTATUS1_Msk = 0xffffffff // Bit mask of CARDSTATUS1 field.

	// RESP2: response 1..4 register
	SDIO_RESP2_CARDSTATUS2_Pos = 0x0        // Position of CARDSTATUS2 field.
	SDIO_RESP2_CARDSTATUS2_Msk = 0xffffffff // Bit mask of CARDSTATUS2 field.

	// RESP3: response 1..4 register
	SDIO_RESP3_CARDSTATUS3_Pos = 0x0        // Position of CARDSTATUS3 field.
	SDIO_RESP3_CARDSTATUS3_Msk = 0xffffffff // Bit mask of CARDSTATUS3 field.

	// RESP4: response 1..4 register
	SDIO_RESP4_CARDSTATUS4_Pos = 0x0        // Position of CARDSTATUS4 field.
	SDIO_RESP4_CARDSTATUS4_Msk = 0xffffffff // Bit mask of CARDSTATUS4 field.

	// DTIMER: data timer register
	SDIO_DTIMER_DATATIME_Pos = 0x0        // Position of DATATIME field.
	SDIO_DTIMER_DATATIME_Msk = 0xffffffff // Bit mask of DATATIME field.

	// DLEN: data length register
	SDIO_DLEN_DATALENGTH_Pos = 0x0       // Position of DATALENGTH field.
	SDIO_DLEN_DATALENGTH_Msk = 0x1ffffff // Bit mask of DATALENGTH field.

	// DCTRL: data control register
	SDIO_DCTRL_SDIOEN_Pos     = 0xb   // Position of SDIOEN field.
	SDIO_DCTRL_SDIOEN_Msk     = 0x800 // Bit mask of SDIOEN field.
	SDIO_DCTRL_SDIOEN         = 0x800 // Bit SDIOEN.
	SDIO_DCTRL_RWMOD_Pos      = 0xa   // Position of RWMOD field.
	SDIO_DCTRL_RWMOD_Msk      = 0x400 // Bit mask of RWMOD field.
	SDIO_DCTRL_RWMOD          = 0x400 // Bit RWMOD.
	SDIO_DCTRL_RWSTOP_Pos     = 0x9   // Position of RWSTOP field.
	SDIO_DCTRL_RWSTOP_Msk     = 0x200 // Bit mask of RWSTOP field.
	SDIO_DCTRL_RWSTOP         = 0x200 // Bit RWSTOP.
	SDIO_DCTRL_RWSTART_Pos    = 0x8   // Position of RWSTART field.
	SDIO_DCTRL_RWSTART_Msk    = 0x100 // Bit mask of RWSTART field.
	SDIO_DCTRL_RWSTART        = 0x100 // Bit RWSTART.
	SDIO_DCTRL_DBLOCKSIZE_Pos = 0x4   // Position of DBLOCKSIZE field.
	SDIO_DCTRL_DBLOCKSIZE_Msk = 0xf0  // Bit mask of DBLOCKSIZE field.
	SDIO_DCTRL_DMAEN_Pos      = 0x3   // Position of DMAEN field.
	SDIO_DCTRL_DMAEN_Msk      = 0x8   // Bit mask of DMAEN field.
	SDIO_DCTRL_DMAEN          = 0x8   // Bit DMAEN.
	SDIO_DCTRL_DTMODE_Pos     = 0x2   // Position of DTMODE field.
	SDIO_DCTRL_DTMODE_Msk     = 0x4   // Bit mask of DTMODE field.
	SDIO_DCTRL_DTMODE         = 0x4   // Bit DTMODE.
	SDIO_DCTRL_DTDIR_Pos      = 0x1   // Position of DTDIR field.
	SDIO_DCTRL_DTDIR_Msk      = 0x2   // Bit mask of DTDIR field.
	SDIO_DCTRL_DTDIR          = 0x2   // Bit DTDIR.
	SDIO_DCTRL_DTEN_Pos       = 0x0   // Position of DTEN field.
	SDIO_DCTRL_DTEN_Msk       = 0x1   // Bit mask of DTEN field.
	SDIO_DCTRL_DTEN           = 0x1   // Bit DTEN.

	// DCOUNT: data counter register
	SDIO_DCOUNT_DATACOUNT_Pos = 0x0       // Position of DATACOUNT field.
	SDIO_DCOUNT_DATACOUNT_Msk = 0x1ffffff // Bit mask of DATACOUNT field.

	// STA: status register
	SDIO_STA_CEATAEND_Pos = 0x17     // Position of CEATAEND field.
	SDIO_STA_CEATAEND_Msk = 0x800000 // Bit mask of CEATAEND field.
	SDIO_STA_CEATAEND     = 0x800000 // Bit CEATAEND.
	SDIO_STA_SDIOIT_Pos   = 0x16     // Position of SDIOIT field.
	SDIO_STA_SDIOIT_Msk   = 0x400000 // Bit mask of SDIOIT field.
	SDIO_STA_SDIOIT       = 0x400000 // Bit SDIOIT.
	SDIO_STA_RXDAVL_Pos   = 0x15     // Position of RXDAVL field.
	SDIO_STA_RXDAVL_Msk   = 0x200000 // Bit mask of RXDAVL field.
	SDIO_STA_RXDAVL       = 0x200000 // Bit RXDAVL.
	SDIO_STA_TXDAVL_Pos   = 0x14     // Position of TXDAVL field.
	SDIO_STA_TXDAVL_Msk   = 0x100000 // Bit mask of TXDAVL field.
	SDIO_STA_TXDAVL       = 0x100000 // Bit TXDAVL.
	SDIO_STA_RXFIFOE_Pos  = 0x13     // Position of RXFIFOE field.
	SDIO_STA_RXFIFOE_Msk  = 0x80000  // Bit mask of RXFIFOE field.
	SDIO_STA_RXFIFOE      = 0x80000  // Bit RXFIFOE.
	SDIO_STA_TXFIFOE_Pos  = 0x12     // Position of TXFIFOE field.
	SDIO_STA_TXFIFOE_Msk  = 0x40000  // Bit mask of TXFIFOE field.
	SDIO_STA_TXFIFOE      = 0x40000  // Bit TXFIFOE.
	SDIO_STA_RXFIFOF_Pos  = 0x11     // Position of RXFIFOF field.
	SDIO_STA_RXFIFOF_Msk  = 0x20000  // Bit mask of RXFIFOF field.
	SDIO_STA_RXFIFOF      = 0x20000  // Bit RXFIFOF.
	SDIO_STA_TXFIFOF_Pos  = 0x10     // Position of TXFIFOF field.
	SDIO_STA_TXFIFOF_Msk  = 0x10000  // Bit mask of TXFIFOF field.
	SDIO_STA_TXFIFOF      = 0x10000  // Bit TXFIFOF.
	SDIO_STA_RXFIFOHF_Pos = 0xf      // Position of RXFIFOHF field.
	SDIO_STA_RXFIFOHF_Msk = 0x8000   // Bit mask of RXFIFOHF field.
	SDIO_STA_RXFIFOHF     = 0x8000   // Bit RXFIFOHF.
	SDIO_STA_TXFIFOHE_Pos = 0xe      // Position of TXFIFOHE field.
	SDIO_STA_TXFIFOHE_Msk = 0x4000   // Bit mask of TXFIFOHE field.
	SDIO_STA_TXFIFOHE     = 0x4000   // Bit TXFIFOHE.
	SDIO_STA_RXACT_Pos    = 0xd      // Position of RXACT field.
	SDIO_STA_RXACT_Msk    = 0x2000   // Bit mask of RXACT field.
	SDIO_STA_RXACT        = 0x2000   // Bit RXACT.
	SDIO_STA_TXACT_Pos    = 0xc      // Position of TXACT field.
	SDIO_STA_TXACT_Msk    = 0x1000   // Bit mask of TXACT field.
	SDIO_STA_TXACT        = 0x1000   // Bit TXACT.
	SDIO_STA_CMDACT_Pos   = 0xb      // Position of CMDACT field.
	SDIO_STA_CMDACT_Msk   = 0x800    // Bit mask of CMDACT field.
	SDIO_STA_CMDACT       = 0x800    // Bit CMDACT.
	SDIO_STA_DBCKEND_Pos  = 0xa      // Position of DBCKEND field.
	SDIO_STA_DBCKEND_Msk  = 0x400    // Bit mask of DBCKEND field.
	SDIO_STA_DBCKEND      = 0x400    // Bit DBCKEND.
	SDIO_STA_STBITERR_Pos = 0x9      // Position of STBITERR field.
	SDIO_STA_STBITERR_Msk = 0x200    // Bit mask of STBITERR field.
	SDIO_STA_STBITERR     = 0x200    // Bit STBITERR.
	SDIO_STA_DATAEND_Pos  = 0x8      // Position of DATAEND field.
	SDIO_STA_DATAEND_Msk  = 0x100    // Bit mask of DATAEND field.
	SDIO_STA_DATAEND      = 0x100    // Bit DATAEND.
	SDIO_STA_CMDSENT_Pos  = 0x7      // Position of CMDSENT field.
	SDIO_STA_CMDSENT_Msk  = 0x80     // Bit mask of CMDSENT field.
	SDIO_STA_CMDSENT      = 0x80     // Bit CMDSENT.
	SDIO_STA_CMDREND_Pos  = 0x6      // Position of CMDREND field.
	SDIO_STA_CMDREND_Msk  = 0x40     // Bit mask of CMDREND field.
	SDIO_STA_CMDREND      = 0x40     // Bit CMDREND.
	SDIO_STA_RXOVERR_Pos  = 0x5      // Position of RXOVERR field.
	SDIO_STA_RXOVERR_Msk  = 0x20     // Bit mask of RXOVERR field.
	SDIO_STA_RXOVERR      = 0x20     // Bit RXOVERR.
	SDIO_STA_TXUNDERR_Pos = 0x4      // Position of TXUNDERR field.
	SDIO_STA_TXUNDERR_Msk = 0x10     // Bit mask of TXUNDERR field.
	SDIO_STA_TXUNDERR     = 0x10     // Bit TXUNDERR.
	SDIO_STA_DTIMEOUT_Pos = 0x3      // Position of DTIMEOUT field.
	SDIO_STA_DTIMEOUT_Msk = 0x8      // Bit mask of DTIMEOUT field.
	SDIO_STA_DTIMEOUT     = 0x8      // Bit DTIMEOUT.
	SDIO_STA_CTIMEOUT_Pos = 0x2      // Position of CTIMEOUT field.
	SDIO_STA_CTIMEOUT_Msk = 0x4      // Bit mask of CTIMEOUT field.
	SDIO_STA_CTIMEOUT     = 0x4      // Bit CTIMEOUT.
	SDIO_STA_DCRCFAIL_Pos = 0x1      // Position of DCRCFAIL field.
	SDIO_STA_DCRCFAIL_Msk = 0x2      // Bit mask of DCRCFAIL field.
	SDIO_STA_DCRCFAIL     = 0x2      // Bit DCRCFAIL.
	SDIO_STA_CCRCFAIL_Pos = 0x0      // Position of CCRCFAIL field.
	SDIO_STA_CCRCFAIL_Msk = 0x1      // Bit mask of CCRCFAIL field.
	SDIO_STA_CCRCFAIL     = 0x1      // Bit CCRCFAIL.

	// ICR: interrupt clear register
	SDIO_ICR_CEATAENDC_Pos = 0x17     // Position of CEATAENDC field.
	SDIO_ICR_CEATAENDC_Msk = 0x800000 // Bit mask of CEATAENDC field.
	SDIO_ICR_CEATAENDC     = 0x800000 // Bit CEATAENDC.
	SDIO_ICR_SDIOITC_Pos   = 0x16     // Position of SDIOITC field.
	SDIO_ICR_SDIOITC_Msk   = 0x400000 // Bit mask of SDIOITC field.
	SDIO_ICR_SDIOITC       = 0x400000 // Bit SDIOITC.
	SDIO_ICR_DBCKENDC_Pos  = 0xa      // Position of DBCKENDC field.
	SDIO_ICR_DBCKENDC_Msk  = 0x400    // Bit mask of DBCKENDC field.
	SDIO_ICR_DBCKENDC      = 0x400    // Bit DBCKENDC.
	SDIO_ICR_STBITERRC_Pos = 0x9      // Position of STBITERRC field.
	SDIO_ICR_STBITERRC_Msk = 0x200    // Bit mask of STBITERRC field.
	SDIO_ICR_STBITERRC     = 0x200    // Bit STBITERRC.
	SDIO_ICR_DATAENDC_Pos  = 0x8      // Position of DATAENDC field.
	SDIO_ICR_DATAENDC_Msk  = 0x100    // Bit mask of DATAENDC field.
	SDIO_ICR_DATAENDC      = 0x100    // Bit DATAENDC.
	SDIO_ICR_CMDSENTC_Pos  = 0x7      // Position of CMDSENTC field.
	SDIO_ICR_CMDSENTC_Msk  = 0x80     // Bit mask of CMDSENTC field.
	SDIO_ICR_CMDSENTC      = 0x80     // Bit CMDSENTC.
	SDIO_ICR_CMDRENDC_Pos  = 0x6      // Position of CMDRENDC field.
	SDIO_ICR_CMDRENDC_Msk  = 0x40     // Bit mask of CMDRENDC field.
	SDIO_ICR_CMDRENDC      = 0x40     // Bit CMDRENDC.
	SDIO_ICR_RXOVERRC_Pos  = 0x5      // Position of RXOVERRC field.
	SDIO_ICR_RXOVERRC_Msk  = 0x20     // Bit mask of RXOVERRC field.
	SDIO_ICR_RXOVERRC      = 0x20     // Bit RXOVERRC.
	SDIO_ICR_TXUNDERRC_Pos = 0x4      // Position of TXUNDERRC field.
	SDIO_ICR_TXUNDERRC_Msk = 0x10     // Bit mask of TXUNDERRC field.
	SDIO_ICR_TXUNDERRC     = 0x10     // Bit TXUNDERRC.
	SDIO_ICR_DTIMEOUTC_Pos = 0x3      // Position of DTIMEOUTC field.
	SDIO_ICR_DTIMEOUTC_Msk = 0x8      // Bit mask of DTIMEOUTC field.
	SDIO_ICR_DTIMEOUTC     = 0x8      // Bit DTIMEOUTC.
	SDIO_ICR_CTIMEOUTC_Pos = 0x2      // Position of CTIMEOUTC field.
	SDIO_ICR_CTIMEOUTC_Msk = 0x4      // Bit mask of CTIMEOUTC field.
	SDIO_ICR_CTIMEOUTC     = 0x4      // Bit CTIMEOUTC.
	SDIO_ICR_DCRCFAILC_Pos = 0x1      // Position of DCRCFAILC field.
	SDIO_ICR_DCRCFAILC_Msk = 0x2      // Bit mask of DCRCFAILC field.
	SDIO_ICR_DCRCFAILC     = 0x2      // Bit DCRCFAILC.
	SDIO_ICR_CCRCFAILC_Pos = 0x0      // Position of CCRCFAILC field.
	SDIO_ICR_CCRCFAILC_Msk = 0x1      // Bit mask of CCRCFAILC field.
	SDIO_ICR_CCRCFAILC     = 0x1      // Bit CCRCFAILC.

	// MASK: mask register
	SDIO_MASK_CEATAENDIE_Pos = 0x17     // Position of CEATAENDIE field.
	SDIO_MASK_CEATAENDIE_Msk = 0x800000 // Bit mask of CEATAENDIE field.
	SDIO_MASK_CEATAENDIE     = 0x800000 // Bit CEATAENDIE.
	SDIO_MASK_SDIOITIE_Pos   = 0x16     // Position of SDIOITIE field.
	SDIO_MASK_SDIOITIE_Msk   = 0x400000 // Bit mask of SDIOITIE field.
	SDIO_MASK_SDIOITIE       = 0x400000 // Bit SDIOITIE.
	SDIO_MASK_RXDAVLIE_Pos   = 0x15     // Position of RXDAVLIE field.
	SDIO_MASK_RXDAVLIE_Msk   = 0x200000 // Bit mask of RXDAVLIE field.
	SDIO_MASK_RXDAVLIE       = 0x200000 // Bit RXDAVLIE.
	SDIO_MASK_TXDAVLIE_Pos   = 0x14     // Position of TXDAVLIE field.
	SDIO_MASK_TXDAVLIE_Msk   = 0x100000 // Bit mask of TXDAVLIE field.
	SDIO_MASK_TXDAVLIE       = 0x100000 // Bit TXDAVLIE.
	SDIO_MASK_RXFIFOEIE_Pos  = 0x13     // Position of RXFIFOEIE field.
	SDIO_MASK_RXFIFOEIE_Msk  = 0x80000  // Bit mask of RXFIFOEIE field.
	SDIO_MASK_RXFIFOEIE      = 0x80000  // Bit RXFIFOEIE.
	SDIO_MASK_TXFIFOEIE_Pos  = 0x12     // Position of TXFIFOEIE field.
	SDIO_MASK_TXFIFOEIE_Msk  = 0x40000  // Bit mask of TXFIFOEIE field.
	SDIO_MASK_TXFIFOEIE      = 0x40000  // Bit TXFIFOEIE.
	SDIO_MASK_RXFIFOFIE_Pos  = 0x11     // Position of RXFIFOFIE field.
	SDIO_MASK_RXFIFOFIE_Msk  = 0x20000  // Bit mask of RXFIFOFIE field.
	SDIO_MASK_RXFIFOFIE      = 0x20000  // Bit RXFIFOFIE.
	SDIO_MASK_TXFIFOFIE_Pos  = 0x10     // Position of TXFIFOFIE field.
	SDIO_MASK_TXFIFOFIE_Msk  = 0x10000  // Bit mask of TXFIFOFIE field.
	SDIO_MASK_TXFIFOFIE      = 0x10000  // Bit TXFIFOFIE.
	SDIO_MASK_RXFIFOHFIE_Pos = 0xf      // Position of RXFIFOHFIE field.
	SDIO_MASK_RXFIFOHFIE_Msk = 0x8000   // Bit mask of RXFIFOHFIE field.
	SDIO_MASK_RXFIFOHFIE     = 0x8000   // Bit RXFIFOHFIE.
	SDIO_MASK_TXFIFOHEIE_Pos = 0xe      // Position of TXFIFOHEIE field.
	SDIO_MASK_TXFIFOHEIE_Msk = 0x4000   // Bit mask of TXFIFOHEIE field.
	SDIO_MASK_TXFIFOHEIE     = 0x4000   // Bit TXFIFOHEIE.
	SDIO_MASK_RXACTIE_Pos    = 0xd      // Position of RXACTIE field.
	SDIO_MASK_RXACTIE_Msk    = 0x2000   // Bit mask of RXACTIE field.
	SDIO_MASK_RXACTIE        = 0x2000   // Bit RXACTIE.
	SDIO_MASK_TXACTIE_Pos    = 0xc      // Position of TXACTIE field.
	SDIO_MASK_TXACTIE_Msk    = 0x1000   // Bit mask of TXACTIE field.
	SDIO_MASK_TXACTIE        = 0x1000   // Bit TXACTIE.
	SDIO_MASK_CMDACTIE_Pos   = 0xb      // Position of CMDACTIE field.
	SDIO_MASK_CMDACTIE_Msk   = 0x800    // Bit mask of CMDACTIE field.
	SDIO_MASK_CMDACTIE       = 0x800    // Bit CMDACTIE.
	SDIO_MASK_DBCKENDIE_Pos  = 0xa      // Position of DBCKENDIE field.
	SDIO_MASK_DBCKENDIE_Msk  = 0x400    // Bit mask of DBCKENDIE field.
	SDIO_MASK_DBCKENDIE      = 0x400    // Bit DBCKENDIE.
	SDIO_MASK_STBITERRIE_Pos = 0x9      // Position of STBITERRIE field.
	SDIO_MASK_STBITERRIE_Msk = 0x200    // Bit mask of STBITERRIE field.
	SDIO_MASK_STBITERRIE     = 0x200    // Bit STBITERRIE.
	SDIO_MASK_DATAENDIE_Pos  = 0x8      // Position of DATAENDIE field.
	SDIO_MASK_DATAENDIE_Msk  = 0x100    // Bit mask of DATAENDIE field.
	SDIO_MASK_DATAENDIE      = 0x100    // Bit DATAENDIE.
	SDIO_MASK_CMDSENTIE_Pos  = 0x7      // Position of CMDSENTIE field.
	SDIO_MASK_CMDSENTIE_Msk  = 0x80     // Bit mask of CMDSENTIE field.
	SDIO_MASK_CMDSENTIE      = 0x80     // Bit CMDSENTIE.
	SDIO_MASK_CMDRENDIE_Pos  = 0x6      // Position of CMDRENDIE field.
	SDIO_MASK_CMDRENDIE_Msk  = 0x40     // Bit mask of CMDRENDIE field.
	SDIO_MASK_CMDRENDIE      = 0x40     // Bit CMDRENDIE.
	SDIO_MASK_RXOVERRIE_Pos  = 0x5      // Position of RXOVERRIE field.
	SDIO_MASK_RXOVERRIE_Msk  = 0x20     // Bit mask of RXOVERRIE field.
	SDIO_MASK_RXOVERRIE      = 0x20     // Bit RXOVERRIE.
	SDIO_MASK_TXUNDERRIE_Pos = 0x4      // Position of TXUNDERRIE field.
	SDIO_MASK_TXUNDERRIE_Msk = 0x10     // Bit mask of TXUNDERRIE field.
	SDIO_MASK_TXUNDERRIE     = 0x10     // Bit TXUNDERRIE.
	SDIO_MASK_DTIMEOUTIE_Pos = 0x3      // Position of DTIMEOUTIE field.
	SDIO_MASK_DTIMEOUTIE_Msk = 0x8      // Bit mask of DTIMEOUTIE field.
	SDIO_MASK_DTIMEOUTIE     = 0x8      // Bit DTIMEOUTIE.
	SDIO_MASK_CTIMEOUTIE_Pos = 0x2      // Position of CTIMEOUTIE field.
	SDIO_MASK_CTIMEOUTIE_Msk = 0x4      // Bit mask of CTIMEOUTIE field.
	SDIO_MASK_CTIMEOUTIE     = 0x4      // Bit CTIMEOUTIE.
	SDIO_MASK_DCRCFAILIE_Pos = 0x1      // Position of DCRCFAILIE field.
	SDIO_MASK_DCRCFAILIE_Msk = 0x2      // Bit mask of DCRCFAILIE field.
	SDIO_MASK_DCRCFAILIE     = 0x2      // Bit DCRCFAILIE.
	SDIO_MASK_CCRCFAILIE_Pos = 0x0      // Position of CCRCFAILIE field.
	SDIO_MASK_CCRCFAILIE_Msk = 0x1      // Bit mask of CCRCFAILIE field.
	SDIO_MASK_CCRCFAILIE     = 0x1      // Bit CCRCFAILIE.

	// FIFOCNT: FIFO counter register
	SDIO_FIFOCNT_FIFOCOUNT_Pos = 0x0      // Position of FIFOCOUNT field.
	SDIO_FIFOCNT_FIFOCOUNT_Msk = 0xffffff // Bit mask of FIFOCOUNT field.

	// FIFO: data FIFO register
	SDIO_FIFO_FIFOData_Pos = 0x0        // Position of FIFOData field.
	SDIO_FIFO_FIFOData_Msk = 0xffffffff // Bit mask of FIFOData field.
)

// Bitfields for SYSCFG: System configuration controller
const (
	// MEMRM: memory remap register
	SYSCFG_MEMRM_MEM_MODE_Pos = 0x0 // Position of MEM_MODE field.
	SYSCFG_MEMRM_MEM_MODE_Msk = 0x3 // Bit mask of MEM_MODE field.

	// PMC: peripheral mode configuration           register
	SYSCFG_PMC_ADC1DC2_Pos = 0x10    // Position of ADC1DC2 field.
	SYSCFG_PMC_ADC1DC2_Msk = 0x10000 // Bit mask of ADC1DC2 field.
	SYSCFG_PMC_ADC1DC2     = 0x10000 // Bit ADC1DC2.

	// EXTICR1: external interrupt configuration register           1
	SYSCFG_EXTICR1_EXTI3_Pos = 0xc    // Position of EXTI3 field.
	SYSCFG_EXTICR1_EXTI3_Msk = 0xf000 // Bit mask of EXTI3 field.
	SYSCFG_EXTICR1_EXTI2_Pos = 0x8    // Position of EXTI2 field.
	SYSCFG_EXTICR1_EXTI2_Msk = 0xf00  // Bit mask of EXTI2 field.
	SYSCFG_EXTICR1_EXTI1_Pos = 0x4    // Position of EXTI1 field.
	SYSCFG_EXTICR1_EXTI1_Msk = 0xf0   // Bit mask of EXTI1 field.
	SYSCFG_EXTICR1_EXTI0_Pos = 0x0    // Position of EXTI0 field.
	SYSCFG_EXTICR1_EXTI0_Msk = 0xf    // Bit mask of EXTI0 field.

	// EXTICR2: external interrupt configuration register           2
	SYSCFG_EXTICR2_EXTI7_Pos = 0xc    // Position of EXTI7 field.
	SYSCFG_EXTICR2_EXTI7_Msk = 0xf000 // Bit mask of EXTI7 field.
	SYSCFG_EXTICR2_EXTI6_Pos = 0x8    // Position of EXTI6 field.
	SYSCFG_EXTICR2_EXTI6_Msk = 0xf00  // Bit mask of EXTI6 field.
	SYSCFG_EXTICR2_EXTI5_Pos = 0x4    // Position of EXTI5 field.
	SYSCFG_EXTICR2_EXTI5_Msk = 0xf0   // Bit mask of EXTI5 field.
	SYSCFG_EXTICR2_EXTI4_Pos = 0x0    // Position of EXTI4 field.
	SYSCFG_EXTICR2_EXTI4_Msk = 0xf    // Bit mask of EXTI4 field.

	// EXTICR3: external interrupt configuration register           3
	SYSCFG_EXTICR3_EXTI11_Pos = 0xc    // Position of EXTI11 field.
	SYSCFG_EXTICR3_EXTI11_Msk = 0xf000 // Bit mask of EXTI11 field.
	SYSCFG_EXTICR3_EXTI10_Pos = 0x8    // Position of EXTI10 field.
	SYSCFG_EXTICR3_EXTI10_Msk = 0xf00  // Bit mask of EXTI10 field.
	SYSCFG_EXTICR3_EXTI9_Pos  = 0x4    // Position of EXTI9 field.
	SYSCFG_EXTICR3_EXTI9_Msk  = 0xf0   // Bit mask of EXTI9 field.
	SYSCFG_EXTICR3_EXTI8_Pos  = 0x0    // Position of EXTI8 field.
	SYSCFG_EXTICR3_EXTI8_Msk  = 0xf    // Bit mask of EXTI8 field.

	// EXTICR4: external interrupt configuration register           4
	SYSCFG_EXTICR4_EXTI15_Pos = 0xc    // Position of EXTI15 field.
	SYSCFG_EXTICR4_EXTI15_Msk = 0xf000 // Bit mask of EXTI15 field.
	SYSCFG_EXTICR4_EXTI14_Pos = 0x8    // Position of EXTI14 field.
	SYSCFG_EXTICR4_EXTI14_Msk = 0xf00  // Bit mask of EXTI14 field.
	SYSCFG_EXTICR4_EXTI13_Pos = 0x4    // Position of EXTI13 field.
	SYSCFG_EXTICR4_EXTI13_Msk = 0xf0   // Bit mask of EXTI13 field.
	SYSCFG_EXTICR4_EXTI12_Pos = 0x0    // Position of EXTI12 field.
	SYSCFG_EXTICR4_EXTI12_Msk = 0xf    // Bit mask of EXTI12 field.

	// CMPCR: Compensation cell control           register
	SYSCFG_CMPCR_READY_Pos  = 0x8   // Position of READY field.
	SYSCFG_CMPCR_READY_Msk  = 0x100 // Bit mask of READY field.
	SYSCFG_CMPCR_READY      = 0x100 // Bit READY.
	SYSCFG_CMPCR_CMP_PD_Pos = 0x0   // Position of CMP_PD field.
	SYSCFG_CMPCR_CMP_PD_Msk = 0x1   // Bit mask of CMP_PD field.
	SYSCFG_CMPCR_CMP_PD     = 0x1   // Bit CMP_PD.
)

// Bitfields for TIM1: Advanced-timers
const (
	// CR1: control register 1
	TIM_CR1_CKD_Pos  = 0x8   // Position of CKD field.
	TIM_CR1_CKD_Msk  = 0x300 // Bit mask of CKD field.
	TIM_CR1_ARPE_Pos = 0x7   // Position of ARPE field.
	TIM_CR1_ARPE_Msk = 0x80  // Bit mask of ARPE field.
	TIM_CR1_ARPE     = 0x80  // Bit ARPE.
	TIM_CR1_CMS_Pos  = 0x5   // Position of CMS field.
	TIM_CR1_CMS_Msk  = 0x60  // Bit mask of CMS field.
	TIM_CR1_DIR_Pos  = 0x4   // Position of DIR field.
	TIM_CR1_DIR_Msk  = 0x10  // Bit mask of DIR field.
	TIM_CR1_DIR      = 0x10  // Bit DIR.
	TIM_CR1_OPM_Pos  = 0x3   // Position of OPM field.
	TIM_CR1_OPM_Msk  = 0x8   // Bit mask of OPM field.
	TIM_CR1_OPM      = 0x8   // Bit OPM.
	TIM_CR1_URS_Pos  = 0x2   // Position of URS field.
	TIM_CR1_URS_Msk  = 0x4   // Bit mask of URS field.
	TIM_CR1_URS      = 0x4   // Bit URS.
	TIM_CR1_UDIS_Pos = 0x1   // Position of UDIS field.
	TIM_CR1_UDIS_Msk = 0x2   // Bit mask of UDIS field.
	TIM_CR1_UDIS     = 0x2   // Bit UDIS.
	TIM_CR1_CEN_Pos  = 0x0   // Position of CEN field.
	TIM_CR1_CEN_Msk  = 0x1   // Bit mask of CEN field.
	TIM_CR1_CEN      = 0x1   // Bit CEN.

	// CR2: control register 2
	TIM_CR2_OIS4_Pos  = 0xe    // Position of OIS4 field.
	TIM_CR2_OIS4_Msk  = 0x4000 // Bit mask of OIS4 field.
	TIM_CR2_OIS4      = 0x4000 // Bit OIS4.
	TIM_CR2_OIS3N_Pos = 0xd    // Position of OIS3N field.
	TIM_CR2_OIS3N_Msk = 0x2000 // Bit mask of OIS3N field.
	TIM_CR2_OIS3N     = 0x2000 // Bit OIS3N.
	TIM_CR2_OIS3_Pos  = 0xc    // Position of OIS3 field.
	TIM_CR2_OIS3_Msk  = 0x1000 // Bit mask of OIS3 field.
	TIM_CR2_OIS3      = 0x1000 // Bit OIS3.
	TIM_CR2_OIS2N_Pos = 0xb    // Position of OIS2N field.
	TIM_CR2_OIS2N_Msk = 0x800  // Bit mask of OIS2N field.
	TIM_CR2_OIS2N     = 0x800  // Bit OIS2N.
	TIM_CR2_OIS2_Pos  = 0xa    // Position of OIS2 field.
	TIM_CR2_OIS2_Msk  = 0x400  // Bit mask of OIS2 field.
	TIM_CR2_OIS2      = 0x400  // Bit OIS2.
	TIM_CR2_OIS1N_Pos = 0x9    // Position of OIS1N field.
	TIM_CR2_OIS1N_Msk = 0x200  // Bit mask of OIS1N field.
	TIM_CR2_OIS1N     = 0x200  // Bit OIS1N.
	TIM_CR2_OIS1_Pos  = 0x8    // Position of OIS1 field.
	TIM_CR2_OIS1_Msk  = 0x100  // Bit mask of OIS1 field.
	TIM_CR2_OIS1      = 0x100  // Bit OIS1.
	TIM_CR2_TI1S_Pos  = 0x7    // Position of TI1S field.
	TIM_CR2_TI1S_Msk  = 0x80   // Bit mask of TI1S field.
	TIM_CR2_TI1S      = 0x80   // Bit TI1S.
	TIM_CR2_MMS_Pos   = 0x4    // Position of MMS field.
	TIM_CR2_MMS_Msk   = 0x70   // Bit mask of MMS field.
	TIM_CR2_CCDS_Pos  = 0x3    // Position of CCDS field.
	TIM_CR2_CCDS_Msk  = 0x8    // Bit mask of CCDS field.
	TIM_CR2_CCDS      = 0x8    // Bit CCDS.
	TIM_CR2_CCUS_Pos  = 0x2    // Position of CCUS field.
	TIM_CR2_CCUS_Msk  = 0x4    // Bit mask of CCUS field.
	TIM_CR2_CCUS      = 0x4    // Bit CCUS.
	TIM_CR2_CCPC_Pos  = 0x0    // Position of CCPC field.
	TIM_CR2_CCPC_Msk  = 0x1    // Bit mask of CCPC field.
	TIM_CR2_CCPC      = 0x1    // Bit CCPC.

	// SMCR: slave mode control register
	TIM_SMCR_ETP_Pos  = 0xf    // Position of ETP field.
	TIM_SMCR_ETP_Msk  = 0x8000 // Bit mask of ETP field.
	TIM_SMCR_ETP      = 0x8000 // Bit ETP.
	TIM_SMCR_ECE_Pos  = 0xe    // Position of ECE field.
	TIM_SMCR_ECE_Msk  = 0x4000 // Bit mask of ECE field.
	TIM_SMCR_ECE      = 0x4000 // Bit ECE.
	TIM_SMCR_ETPS_Pos = 0xc    // Position of ETPS field.
	TIM_SMCR_ETPS_Msk = 0x3000 // Bit mask of ETPS field.
	TIM_SMCR_ETF_Pos  = 0x8    // Position of ETF field.
	TIM_SMCR_ETF_Msk  = 0xf00  // Bit mask of ETF field.
	TIM_SMCR_MSM_Pos  = 0x7    // Position of MSM field.
	TIM_SMCR_MSM_Msk  = 0x80   // Bit mask of MSM field.
	TIM_SMCR_MSM      = 0x80   // Bit MSM.
	TIM_SMCR_TS_Pos   = 0x4    // Position of TS field.
	TIM_SMCR_TS_Msk   = 0x70   // Bit mask of TS field.
	TIM_SMCR_SMS_Pos  = 0x0    // Position of SMS field.
	TIM_SMCR_SMS_Msk  = 0x7    // Bit mask of SMS field.

	// DIER: DMA/Interrupt enable register
	TIM_DIER_TDE_Pos   = 0xe    // Position of TDE field.
	TIM_DIER_TDE_Msk   = 0x4000 // Bit mask of TDE field.
	TIM_DIER_TDE       = 0x4000 // Bit TDE.
	TIM_DIER_COMDE_Pos = 0xd    // Position of COMDE field.
	TIM_DIER_COMDE_Msk = 0x2000 // Bit mask of COMDE field.
	TIM_DIER_COMDE     = 0x2000 // Bit COMDE.
	TIM_DIER_CC4DE_Pos = 0xc    // Position of CC4DE field.
	TIM_DIER_CC4DE_Msk = 0x1000 // Bit mask of CC4DE field.
	TIM_DIER_CC4DE     = 0x1000 // Bit CC4DE.
	TIM_DIER_CC3DE_Pos = 0xb    // Position of CC3DE field.
	TIM_DIER_CC3DE_Msk = 0x800  // Bit mask of CC3DE field.
	TIM_DIER_CC3DE     = 0x800  // Bit CC3DE.
	TIM_DIER_CC2DE_Pos = 0xa    // Position of CC2DE field.
	TIM_DIER_CC2DE_Msk = 0x400  // Bit mask of CC2DE field.
	TIM_DIER_CC2DE     = 0x400  // Bit CC2DE.
	TIM_DIER_CC1DE_Pos = 0x9    // Position of CC1DE field.
	TIM_DIER_CC1DE_Msk = 0x200  // Bit mask of CC1DE field.
	TIM_DIER_CC1DE     = 0x200  // Bit CC1DE.
	TIM_DIER_UDE_Pos   = 0x8    // Position of UDE field.
	TIM_DIER_UDE_Msk   = 0x100  // Bit mask of UDE field.
	TIM_DIER_UDE       = 0x100  // Bit UDE.
	TIM_DIER_BIE_Pos   = 0x7    // Position of BIE field.
	TIM_DIER_BIE_Msk   = 0x80   // Bit mask of BIE field.
	TIM_DIER_BIE       = 0x80   // Bit BIE.
	TIM_DIER_TIE_Pos   = 0x6    // Position of TIE field.
	TIM_DIER_TIE_Msk   = 0x40   // Bit mask of TIE field.
	TIM_DIER_TIE       = 0x40   // Bit TIE.
	TIM_DIER_COMIE_Pos = 0x5    // Position of COMIE field.
	TIM_DIER_COMIE_Msk = 0x20   // Bit mask of COMIE field.
	TIM_DIER_COMIE     = 0x20   // Bit COMIE.
	TIM_DIER_CC4IE_Pos = 0x4    // Position of CC4IE field.
	TIM_DIER_CC4IE_Msk = 0x10   // Bit mask of CC4IE field.
	TIM_DIER_CC4IE     = 0x10   // Bit CC4IE.
	TIM_DIER_CC3IE_Pos = 0x3    // Position of CC3IE field.
	TIM_DIER_CC3IE_Msk = 0x8    // Bit mask of CC3IE field.
	TIM_DIER_CC3IE     = 0x8    // Bit CC3IE.
	TIM_DIER_CC2IE_Pos = 0x2    // Position of CC2IE field.
	TIM_DIER_CC2IE_Msk = 0x4    // Bit mask of CC2IE field.
	TIM_DIER_CC2IE     = 0x4    // Bit CC2IE.
	TIM_DIER_CC1IE_Pos = 0x1    // Position of CC1IE field.
	TIM_DIER_CC1IE_Msk = 0x2    // Bit mask of CC1IE field.
	TIM_DIER_CC1IE     = 0x2    // Bit CC1IE.
	TIM_DIER_UIE_Pos   = 0x0    // Position of UIE field.
	TIM_DIER_UIE_Msk   = 0x1    // Bit mask of UIE field.
	TIM_DIER_UIE       = 0x1    // Bit UIE.

	// SR: status register
	TIM_SR_CC4OF_Pos = 0xc    // Position of CC4OF field.
	TIM_SR_CC4OF_Msk = 0x1000 // Bit mask of CC4OF field.
	TIM_SR_CC4OF     = 0x1000 // Bit CC4OF.
	TIM_SR_CC3OF_Pos = 0xb    // Position of CC3OF field.
	TIM_SR_CC3OF_Msk = 0x800  // Bit mask of CC3OF field.
	TIM_SR_CC3OF     = 0x800  // Bit CC3OF.
	TIM_SR_CC2OF_Pos = 0xa    // Position of CC2OF field.
	TIM_SR_CC2OF_Msk = 0x400  // Bit mask of CC2OF field.
	TIM_SR_CC2OF     = 0x400  // Bit CC2OF.
	TIM_SR_CC1OF_Pos = 0x9    // Position of CC1OF field.
	TIM_SR_CC1OF_Msk = 0x200  // Bit mask of CC1OF field.
	TIM_SR_CC1OF     = 0x200  // Bit CC1OF.
	TIM_SR_BIF_Pos   = 0x7    // Position of BIF field.
	TIM_SR_BIF_Msk   = 0x80   // Bit mask of BIF field.
	TIM_SR_BIF       = 0x80   // Bit BIF.
	TIM_SR_TIF_Pos   = 0x6    // Position of TIF field.
	TIM_SR_TIF_Msk   = 0x40   // Bit mask of TIF field.
	TIM_SR_TIF       = 0x40   // Bit TIF.
	TIM_SR_COMIF_Pos = 0x5    // Position of COMIF field.
	TIM_SR_COMIF_Msk = 0x20   // Bit mask of COMIF field.
	TIM_SR_COMIF     = 0x20   // Bit COMIF.
	TIM_SR_CC4IF_Pos = 0x4    // Position of CC4IF field.
	TIM_SR_CC4IF_Msk = 0x10   // Bit mask of CC4IF field.
	TIM_SR_CC4IF     = 0x10   // Bit CC4IF.
	TIM_SR_CC3IF_Pos = 0x3    // Position of CC3IF field.
	TIM_SR_CC3IF_Msk = 0x8    // Bit mask of CC3IF field.
	TIM_SR_CC3IF     = 0x8    // Bit CC3IF.
	TIM_SR_CC2IF_Pos = 0x2    // Position of CC2IF field.
	TIM_SR_CC2IF_Msk = 0x4    // Bit mask of CC2IF field.
	TIM_SR_CC2IF     = 0x4    // Bit CC2IF.
	TIM_SR_CC1IF_Pos = 0x1    // Position of CC1IF field.
	TIM_SR_CC1IF_Msk = 0x2    // Bit mask of CC1IF field.
	TIM_SR_CC1IF     = 0x2    // Bit CC1IF.
	TIM_SR_UIF_Pos   = 0x0    // Position of UIF field.
	TIM_SR_UIF_Msk   = 0x1    // Bit mask of UIF field.
	TIM_SR_UIF       = 0x1    // Bit UIF.

	// EGR: event generation register
	TIM_EGR_BG_Pos   = 0x7  // Position of BG field.
	TIM_EGR_BG_Msk   = 0x80 // Bit mask of BG field.
	TIM_EGR_BG       = 0x80 // Bit BG.
	TIM_EGR_TG_Pos   = 0x6  // Position of TG field.
	TIM_EGR_TG_Msk   = 0x40 // Bit mask of TG field.
	TIM_EGR_TG       = 0x40 // Bit TG.
	TIM_EGR_COMG_Pos = 0x5  // Position of COMG field.
	TIM_EGR_COMG_Msk = 0x20 // Bit mask of COMG field.
	TIM_EGR_COMG     = 0x20 // Bit COMG.
	TIM_EGR_CC4G_Pos = 0x4  // Position of CC4G field.
	TIM_EGR_CC4G_Msk = 0x10 // Bit mask of CC4G field.
	TIM_EGR_CC4G     = 0x10 // Bit CC4G.
	TIM_EGR_CC3G_Pos = 0x3  // Position of CC3G field.
	TIM_EGR_CC3G_Msk = 0x8  // Bit mask of CC3G field.
	TIM_EGR_CC3G     = 0x8  // Bit CC3G.
	TIM_EGR_CC2G_Pos = 0x2  // Position of CC2G field.
	TIM_EGR_CC2G_Msk = 0x4  // Bit mask of CC2G field.
	TIM_EGR_CC2G     = 0x4  // Bit CC2G.
	TIM_EGR_CC1G_Pos = 0x1  // Position of CC1G field.
	TIM_EGR_CC1G_Msk = 0x2  // Bit mask of CC1G field.
	TIM_EGR_CC1G     = 0x2  // Bit CC1G.
	TIM_EGR_UG_Pos   = 0x0  // Position of UG field.
	TIM_EGR_UG_Msk   = 0x1  // Bit mask of UG field.
	TIM_EGR_UG       = 0x1  // Bit UG.

	// CCMR1_Output: capture/compare mode register 1 (output           mode)
	TIM_CCMR1_Output_OC2CE_Pos = 0xf    // Position of OC2CE field.
	TIM_CCMR1_Output_OC2CE_Msk = 0x8000 // Bit mask of OC2CE field.
	TIM_CCMR1_Output_OC2CE     = 0x8000 // Bit OC2CE.
	TIM_CCMR1_Output_OC2M_Pos  = 0xc    // Position of OC2M field.
	TIM_CCMR1_Output_OC2M_Msk  = 0x7000 // Bit mask of OC2M field.
	TIM_CCMR1_Output_OC2PE_Pos = 0xb    // Position of OC2PE field.
	TIM_CCMR1_Output_OC2PE_Msk = 0x800  // Bit mask of OC2PE field.
	TIM_CCMR1_Output_OC2PE     = 0x800  // Bit OC2PE.
	TIM_CCMR1_Output_OC2FE_Pos = 0xa    // Position of OC2FE field.
	TIM_CCMR1_Output_OC2FE_Msk = 0x400  // Bit mask of OC2FE field.
	TIM_CCMR1_Output_OC2FE     = 0x400  // Bit OC2FE.
	TIM_CCMR1_Output_CC2S_Pos  = 0x8    // Position of CC2S field.
	TIM_CCMR1_Output_CC2S_Msk  = 0x300  // Bit mask of CC2S field.
	TIM_CCMR1_Output_OC1CE_Pos = 0x7    // Position of OC1CE field.
	TIM_CCMR1_Output_OC1CE_Msk = 0x80   // Bit mask of OC1CE field.
	TIM_CCMR1_Output_OC1CE     = 0x80   // Bit OC1CE.
	TIM_CCMR1_Output_OC1M_Pos  = 0x4    // Position of OC1M field.
	TIM_CCMR1_Output_OC1M_Msk  = 0x70   // Bit mask of OC1M field.
	TIM_CCMR1_Output_OC1PE_Pos = 0x3    // Position of OC1PE field.
	TIM_CCMR1_Output_OC1PE_Msk = 0x8    // Bit mask of OC1PE field.
	TIM_CCMR1_Output_OC1PE     = 0x8    // Bit OC1PE.
	TIM_CCMR1_Output_OC1FE_Pos = 0x2    // Position of OC1FE field.
	TIM_CCMR1_Output_OC1FE_Msk = 0x4    // Bit mask of OC1FE field.
	TIM_CCMR1_Output_OC1FE     = 0x4    // Bit OC1FE.
	TIM_CCMR1_Output_CC1S_Pos  = 0x0    // Position of CC1S field.
	TIM_CCMR1_Output_CC1S_Msk  = 0x3    // Bit mask of CC1S field.

	// CCMR1_Input: capture/compare mode register 1 (input           mode)
	TIM_CCMR1_Input_IC2F_Pos   = 0xc    // Position of IC2F field.
	TIM_CCMR1_Input_IC2F_Msk   = 0xf000 // Bit mask of IC2F field.
	TIM_CCMR1_Input_IC2PCS_Pos = 0xa    // Position of IC2PCS field.
	TIM_CCMR1_Input_IC2PCS_Msk = 0xc00  // Bit mask of IC2PCS field.
	TIM_CCMR1_Input_CC2S_Pos   = 0x8    // Position of CC2S field.
	TIM_CCMR1_Input_CC2S_Msk   = 0x300  // Bit mask of CC2S field.
	TIM_CCMR1_Input_IC1F_Pos   = 0x4    // Position of IC1F field.
	TIM_CCMR1_Input_IC1F_Msk   = 0xf0   // Bit mask of IC1F field.
	TIM_CCMR1_Input_ICPCS_Pos  = 0x2    // Position of ICPCS field.
	TIM_CCMR1_Input_ICPCS_Msk  = 0xc    // Bit mask of ICPCS field.
	TIM_CCMR1_Input_CC1S_Pos   = 0x0    // Position of CC1S field.
	TIM_CCMR1_Input_CC1S_Msk   = 0x3    // Bit mask of CC1S field.

	// CCMR2_Output: capture/compare mode register 2 (output           mode)
	TIM_CCMR2_Output_OC4CE_Pos = 0xf    // Position of OC4CE field.
	TIM_CCMR2_Output_OC4CE_Msk = 0x8000 // Bit mask of OC4CE field.
	TIM_CCMR2_Output_OC4CE     = 0x8000 // Bit OC4CE.
	TIM_CCMR2_Output_OC4M_Pos  = 0xc    // Position of OC4M field.
	TIM_CCMR2_Output_OC4M_Msk  = 0x7000 // Bit mask of OC4M field.
	TIM_CCMR2_Output_OC4PE_Pos = 0xb    // Position of OC4PE field.
	TIM_CCMR2_Output_OC4PE_Msk = 0x800  // Bit mask of OC4PE field.
	TIM_CCMR2_Output_OC4PE     = 0x800  // Bit OC4PE.
	TIM_CCMR2_Output_OC4FE_Pos = 0xa    // Position of OC4FE field.
	TIM_CCMR2_Output_OC4FE_Msk = 0x400  // Bit mask of OC4FE field.
	TIM_CCMR2_Output_OC4FE     = 0x400  // Bit OC4FE.
	TIM_CCMR2_Output_CC4S_Pos  = 0x8    // Position of CC4S field.
	TIM_CCMR2_Output_CC4S_Msk  = 0x300  // Bit mask of CC4S field.
	TIM_CCMR2_Output_OC3CE_Pos = 0x7    // Position of OC3CE field.
	TIM_CCMR2_Output_OC3CE_Msk = 0x80   // Bit mask of OC3CE field.
	TIM_CCMR2_Output_OC3CE     = 0x80   // Bit OC3CE.
	TIM_CCMR2_Output_OC3M_Pos  = 0x4    // Position of OC3M field.
	TIM_CCMR2_Output_OC3M_Msk  = 0x70   // Bit mask of OC3M field.
	TIM_CCMR2_Output_OC3PE_Pos = 0x3    // Position of OC3PE field.
	TIM_CCMR2_Output_OC3PE_Msk = 0x8    // Bit mask of OC3PE field.
	TIM_CCMR2_Output_OC3PE     = 0x8    // Bit OC3PE.
	TIM_CCMR2_Output_OC3FE_Pos = 0x2    // Position of OC3FE field.
	TIM_CCMR2_Output_OC3FE_Msk = 0x4    // Bit mask of OC3FE field.
	TIM_CCMR2_Output_OC3FE     = 0x4    // Bit OC3FE.
	TIM_CCMR2_Output_CC3S_Pos  = 0x0    // Position of CC3S field.
	TIM_CCMR2_Output_CC3S_Msk  = 0x3    // Bit mask of CC3S field.

	// CCMR2_Input: capture/compare mode register 2 (input           mode)
	TIM_CCMR2_Input_IC4F_Pos   = 0xc    // Position of IC4F field.
	TIM_CCMR2_Input_IC4F_Msk   = 0xf000 // Bit mask of IC4F field.
	TIM_CCMR2_Input_IC4PSC_Pos = 0xa    // Position of IC4PSC field.
	TIM_CCMR2_Input_IC4PSC_Msk = 0xc00  // Bit mask of IC4PSC field.
	TIM_CCMR2_Input_CC4S_Pos   = 0x8    // Position of CC4S field.
	TIM_CCMR2_Input_CC4S_Msk   = 0x300  // Bit mask of CC4S field.
	TIM_CCMR2_Input_IC3F_Pos   = 0x4    // Position of IC3F field.
	TIM_CCMR2_Input_IC3F_Msk   = 0xf0   // Bit mask of IC3F field.
	TIM_CCMR2_Input_IC3PSC_Pos = 0x2    // Position of IC3PSC field.
	TIM_CCMR2_Input_IC3PSC_Msk = 0xc    // Bit mask of IC3PSC field.
	TIM_CCMR2_Input_CC3S_Pos   = 0x0    // Position of CC3S field.
	TIM_CCMR2_Input_CC3S_Msk   = 0x3    // Bit mask of CC3S field.

	// CCER: capture/compare enable           register
	TIM_CCER_CC4P_Pos  = 0xd    // Position of CC4P field.
	TIM_CCER_CC4P_Msk  = 0x2000 // Bit mask of CC4P field.
	TIM_CCER_CC4P      = 0x2000 // Bit CC4P.
	TIM_CCER_CC4E_Pos  = 0xc    // Position of CC4E field.
	TIM_CCER_CC4E_Msk  = 0x1000 // Bit mask of CC4E field.
	TIM_CCER_CC4E      = 0x1000 // Bit CC4E.
	TIM_CCER_CC3NP_Pos = 0xb    // Position of CC3NP field.
	TIM_CCER_CC3NP_Msk = 0x800  // Bit mask of CC3NP field.
	TIM_CCER_CC3NP     = 0x800  // Bit CC3NP.
	TIM_CCER_CC3NE_Pos = 0xa    // Position of CC3NE field.
	TIM_CCER_CC3NE_Msk = 0x400  // Bit mask of CC3NE field.
	TIM_CCER_CC3NE     = 0x400  // Bit CC3NE.
	TIM_CCER_CC3P_Pos  = 0x9    // Position of CC3P field.
	TIM_CCER_CC3P_Msk  = 0x200  // Bit mask of CC3P field.
	TIM_CCER_CC3P      = 0x200  // Bit CC3P.
	TIM_CCER_CC3E_Pos  = 0x8    // Position of CC3E field.
	TIM_CCER_CC3E_Msk  = 0x100  // Bit mask of CC3E field.
	TIM_CCER_CC3E      = 0x100  // Bit CC3E.
	TIM_CCER_CC2NP_Pos = 0x7    // Position of CC2NP field.
	TIM_CCER_CC2NP_Msk = 0x80   // Bit mask of CC2NP field.
	TIM_CCER_CC2NP     = 0x80   // Bit CC2NP.
	TIM_CCER_CC2NE_Pos = 0x6    // Position of CC2NE field.
	TIM_CCER_CC2NE_Msk = 0x40   // Bit mask of CC2NE field.
	TIM_CCER_CC2NE     = 0x40   // Bit CC2NE.
	TIM_CCER_CC2P_Pos  = 0x5    // Position of CC2P field.
	TIM_CCER_CC2P_Msk  = 0x20   // Bit mask of CC2P field.
	TIM_CCER_CC2P      = 0x20   // Bit CC2P.
	TIM_CCER_CC2E_Pos  = 0x4    // Position of CC2E field.
	TIM_CCER_CC2E_Msk  = 0x10   // Bit mask of CC2E field.
	TIM_CCER_CC2E      = 0x10   // Bit CC2E.
	TIM_CCER_CC1NP_Pos = 0x3    // Position of CC1NP field.
	TIM_CCER_CC1NP_Msk = 0x8    // Bit mask of CC1NP field.
	TIM_CCER_CC1NP     = 0x8    // Bit CC1NP.
	TIM_CCER_CC1NE_Pos = 0x2    // Position of CC1NE field.
	TIM_CCER_CC1NE_Msk = 0x4    // Bit mask of CC1NE field.
	TIM_CCER_CC1NE     = 0x4    // Bit CC1NE.
	TIM_CCER_CC1P_Pos  = 0x1    // Position of CC1P field.
	TIM_CCER_CC1P_Msk  = 0x2    // Bit mask of CC1P field.
	TIM_CCER_CC1P      = 0x2    // Bit CC1P.
	TIM_CCER_CC1E_Pos  = 0x0    // Position of CC1E field.
	TIM_CCER_CC1E_Msk  = 0x1    // Bit mask of CC1E field.
	TIM_CCER_CC1E      = 0x1    // Bit CC1E.

	// CNT: counter
	TIM_CNT_CNT_Pos = 0x0    // Position of CNT field.
	TIM_CNT_CNT_Msk = 0xffff // Bit mask of CNT field.

	// PSC: prescaler
	TIM_PSC_PSC_Pos = 0x0    // Position of PSC field.
	TIM_PSC_PSC_Msk = 0xffff // Bit mask of PSC field.

	// ARR: auto-reload register
	TIM_ARR_ARR_Pos = 0x0    // Position of ARR field.
	TIM_ARR_ARR_Msk = 0xffff // Bit mask of ARR field.

	// RCR: repetition counter register
	TIM_RCR_REP_Pos = 0x0  // Position of REP field.
	TIM_RCR_REP_Msk = 0xff // Bit mask of REP field.

	// CCR1: capture/compare register 1
	TIM_CCR1_CCR1_Pos = 0x0    // Position of CCR1 field.
	TIM_CCR1_CCR1_Msk = 0xffff // Bit mask of CCR1 field.

	// CCR2: capture/compare register 2
	TIM_CCR2_CCR2_Pos = 0x0    // Position of CCR2 field.
	TIM_CCR2_CCR2_Msk = 0xffff // Bit mask of CCR2 field.

	// CCR3: capture/compare register 3
	TIM_CCR3_CCR3_Pos = 0x0    // Position of CCR3 field.
	TIM_CCR3_CCR3_Msk = 0xffff // Bit mask of CCR3 field.

	// CCR4: capture/compare register 4
	TIM_CCR4_CCR4_Pos = 0x0    // Position of CCR4 field.
	TIM_CCR4_CCR4_Msk = 0xffff // Bit mask of CCR4 field.

	// BDTR: break and dead-time register
	TIM_BDTR_MOE_Pos  = 0xf    // Position of MOE field.
	TIM_BDTR_MOE_Msk  = 0x8000 // Bit mask of MOE field.
	TIM_BDTR_MOE      = 0x8000 // Bit MOE.
	TIM_BDTR_AOE_Pos  = 0xe    // Position of AOE field.
	TIM_BDTR_AOE_Msk  = 0x4000 // Bit mask of AOE field.
	TIM_BDTR_AOE      = 0x4000 // Bit AOE.
	TIM_BDTR_BKP_Pos  = 0xd    // Position of BKP field.
	TIM_BDTR_BKP_Msk  = 0x2000 // Bit mask of BKP field.
	TIM_BDTR_BKP      = 0x2000 // Bit BKP.
	TIM_BDTR_BKE_Pos  = 0xc    // Position of BKE field.
	TIM_BDTR_BKE_Msk  = 0x1000 // Bit mask of BKE field.
	TIM_BDTR_BKE      = 0x1000 // Bit BKE.
	TIM_BDTR_OSSR_Pos = 0xb    // Position of OSSR field.
	TIM_BDTR_OSSR_Msk = 0x800  // Bit mask of OSSR field.
	TIM_BDTR_OSSR     = 0x800  // Bit OSSR.
	TIM_BDTR_OSSI_Pos = 0xa    // Position of OSSI field.
	TIM_BDTR_OSSI_Msk = 0x400  // Bit mask of OSSI field.
	TIM_BDTR_OSSI     = 0x400  // Bit OSSI.
	TIM_BDTR_LOCK_Pos = 0x8    // Position of LOCK field.
	TIM_BDTR_LOCK_Msk = 0x300  // Bit mask of LOCK field.
	TIM_BDTR_DTG_Pos  = 0x0    // Position of DTG field.
	TIM_BDTR_DTG_Msk  = 0xff   // Bit mask of DTG field.

	// DCR: DMA control register
	TIM_DCR_DBL_Pos = 0x8    // Position of DBL field.
	TIM_DCR_DBL_Msk = 0x1f00 // Bit mask of DBL field.
	TIM_DCR_DBA_Pos = 0x0    // Position of DBA field.
	TIM_DCR_DBA_Msk = 0x1f   // Bit mask of DBA field.

	// DMAR: DMA address for full transfer
	TIM_DMAR_DMAB_Pos = 0x0    // Position of DMAB field.
	TIM_DMAR_DMAB_Msk = 0xffff // Bit mask of DMAB field.
)

// Bitfields for USART1: Universal synchronous asynchronous receiver transmitter
const (
	// SR: Status register
	USART_SR_CTS_Pos  = 0x9   // Position of CTS field.
	USART_SR_CTS_Msk  = 0x200 // Bit mask of CTS field.
	USART_SR_CTS      = 0x200 // Bit CTS.
	USART_SR_LBD_Pos  = 0x8   // Position of LBD field.
	USART_SR_LBD_Msk  = 0x100 // Bit mask of LBD field.
	USART_SR_LBD      = 0x100 // Bit LBD.
	USART_SR_TXE_Pos  = 0x7   // Position of TXE field.
	USART_SR_TXE_Msk  = 0x80  // Bit mask of TXE field.
	USART_SR_TXE      = 0x80  // Bit TXE.
	USART_SR_TC_Pos   = 0x6   // Position of TC field.
	USART_SR_TC_Msk   = 0x40  // Bit mask of TC field.
	USART_SR_TC       = 0x40  // Bit TC.
	USART_SR_RXNE_Pos = 0x5   // Position of RXNE field.
	USART_SR_RXNE_Msk = 0x20  // Bit mask of RXNE field.
	USART_SR_RXNE     = 0x20  // Bit RXNE.
	USART_SR_IDLE_Pos = 0x4   // Position of IDLE field.
	USART_SR_IDLE_Msk = 0x10  // Bit mask of IDLE field.
	USART_SR_IDLE     = 0x10  // Bit IDLE.
	USART_SR_ORE_Pos  = 0x3   // Position of ORE field.
	USART_SR_ORE_Msk  = 0x8   // Bit mask of ORE field.
	USART_SR_ORE      = 0x8   // Bit ORE.
	USART_SR_NF_Pos   = 0x2   // Position of NF field.
	USART_SR_NF_Msk   = 0x4   // Bit mask of NF field.
	USART_SR_NF       = 0x4   // Bit NF.
	USART_SR_FE_Pos   = 0x1   // Position of FE field.
	USART_SR_FE_Msk   = 0x2   // Bit mask of FE field.
	USART_SR_FE       = 0x2   // Bit FE.
	USART_SR_PE_Pos   = 0x0   // Position of PE field.
	USART_SR_PE_Msk   = 0x1   // Bit mask of PE field.
	USART_SR_PE       = 0x1   // Bit PE.

	// DR: Data register
	USART_DR_DR_Pos = 0x0   // Position of DR field.
	USART_DR_DR_Msk = 0x1ff // Bit mask of DR field.

	// BRR: Baud rate register
	USART_BRR_DIV_Mantissa_Pos = 0x4    // Position of DIV_Mantissa field.
	USART_BRR_DIV_Mantissa_Msk = 0xfff0 // Bit mask of DIV_Mantissa field.
	USART_BRR_DIV_Fraction_Pos = 0x0    // Position of DIV_Fraction field.
	USART_BRR_DIV_Fraction_Msk = 0xf    // Bit mask of DIV_Fraction field.

	// CR1: Control register 1
	USART_CR1_OVER8_Pos  = 0xf    // Position of OVER8 field.
	USART_CR1_OVER8_Msk  = 0x8000 // Bit mask of OVER8 field.
	USART_CR1_OVER8      = 0x8000 // Bit OVER8.
	USART_CR1_UE_Pos     = 0xd    // Position of UE field.
	USART_CR1_UE_Msk     = 0x2000 // Bit mask of UE field.
	USART_CR1_UE         = 0x2000 // Bit UE.
	USART_CR1_M_Pos      = 0xc    // Position of M field.
	USART_CR1_M_Msk      = 0x1000 // Bit mask of M field.
	USART_CR1_M          = 0x1000 // Bit M.
	USART_CR1_WAKE_Pos   = 0xb    // Position of WAKE field.
	USART_CR1_WAKE_Msk   = 0x800  // Bit mask of WAKE field.
	USART_CR1_WAKE       = 0x800  // Bit WAKE.
	USART_CR1_PCE_Pos    = 0xa    // Position of PCE field.
	USART_CR1_PCE_Msk    = 0x400  // Bit mask of PCE field.
	USART_CR1_PCE        = 0x400  // Bit PCE.
	USART_CR1_PS_Pos     = 0x9    // Position of PS field.
	USART_CR1_PS_Msk     = 0x200  // Bit mask of PS field.
	USART_CR1_PS         = 0x200  // Bit PS.
	USART_CR1_PEIE_Pos   = 0x8    // Position of PEIE field.
	USART_CR1_PEIE_Msk   = 0x100  // Bit mask of PEIE field.
	USART_CR1_PEIE       = 0x100  // Bit PEIE.
	USART_CR1_TXEIE_Pos  = 0x7    // Position of TXEIE field.
	USART_CR1_TXEIE_Msk  = 0x80   // Bit mask of TXEIE field.
	USART_CR1_TXEIE      = 0x80   // Bit TXEIE.
	USART_CR1_TCIE_Pos   = 0x6    // Position of TCIE field.
	USART_CR1_TCIE_Msk   = 0x40   // Bit mask of TCIE field.
	USART_CR1_TCIE       = 0x40   // Bit TCIE.
	USART_CR1_RXNEIE_Pos = 0x5    // Position of RXNEIE field.
	USART_CR1_RXNEIE_Msk = 0x20   // Bit mask of RXNEIE field.
	USART_CR1_RXNEIE     = 0x20   // Bit RXNEIE.
	USART_CR1_IDLEIE_Pos = 0x4    // Position of IDLEIE field.
	USART_CR1_IDLEIE_Msk = 0x10   // Bit mask of IDLEIE field.
	USART_CR1_IDLEIE     = 0x10   // Bit IDLEIE.
	USART_CR1_TE_Pos     = 0x3    // Position of TE field.
	USART_CR1_TE_Msk     = 0x8    // Bit mask of TE field.
	USART_CR1_TE         = 0x8    // Bit TE.
	USART_CR1_RE_Pos     = 0x2    // Position of RE field.
	USART_CR1_RE_Msk     = 0x4    // Bit mask of RE field.
	USART_CR1_RE         = 0x4    // Bit RE.
	USART_CR1_RWU_Pos    = 0x1    // Position of RWU field.
	USART_CR1_RWU_Msk    = 0x2    // Bit mask of RWU field.
	USART_CR1_RWU        = 0x2    // Bit RWU.
	USART_CR1_SBK_Pos    = 0x0    // Position of SBK field.
	USART_CR1_SBK_Msk    = 0x1    // Bit mask of SBK field.
	USART_CR1_SBK        = 0x1    // Bit SBK.

	// CR2: Control register 2
	USART_CR2_LINEN_Pos = 0xe    // Position of LINEN field.
	USART_CR2_LINEN_Msk = 0x4000 // Bit mask of LINEN field.
	USART_CR2_LINEN     = 0x4000 // Bit LINEN.
	USART_CR2_STOP_Pos  = 0xc    // Position of STOP field.
	USART_CR2_STOP_Msk  = 0x3000 // Bit mask of STOP field.
	USART_CR2_CLKEN_Pos = 0xb    // Position of CLKEN field.
	USART_CR2_CLKEN_Msk = 0x800  // Bit mask of CLKEN field.
	USART_CR2_CLKEN     = 0x800  // Bit CLKEN.
	USART_CR2_CPOL_Pos  = 0xa    // Position of CPOL field.
	USART_CR2_CPOL_Msk  = 0x400  // Bit mask of CPOL field.
	USART_CR2_CPOL      = 0x400  // Bit CPOL.
	USART_CR2_CPHA_Pos  = 0x9    // Position of CPHA field.
	USART_CR2_CPHA_Msk  = 0x200  // Bit mask of CPHA field.
	USART_CR2_CPHA      = 0x200  // Bit CPHA.
	USART_CR2_LBCL_Pos  = 0x8    // Position of LBCL field.
	USART_CR2_LBCL_Msk  = 0x100  // Bit mask of LBCL field.
	USART_CR2_LBCL      = 0x100  // Bit LBCL.
	USART_CR2_LBDIE_Pos = 0x6    // Position of LBDIE field.
	USART_CR2_LBDIE_Msk = 0x40   // Bit mask of LBDIE field.
	USART_CR2_LBDIE     = 0x40   // Bit LBDIE.
	USART_CR2_LBDL_Pos  = 0x5    // Position of LBDL field.
	USART_CR2_LBDL_Msk  = 0x20   // Bit mask of LBDL field.
	USART_CR2_LBDL      = 0x20   // Bit LBDL.
	USART_CR2_ADD_Pos   = 0x0    // Position of ADD field.
	USART_CR2_ADD_Msk   = 0xf    // Bit mask of ADD field.

	// CR3: Control register 3
	USART_CR3_ONEBIT_Pos = 0xb   // Position of ONEBIT field.
	USART_CR3_ONEBIT_Msk = 0x800 // Bit mask of ONEBIT field.
	USART_CR3_ONEBIT     = 0x800 // Bit ONEBIT.
	USART_CR3_CTSIE_Pos  = 0xa   // Position of CTSIE field.
	USART_CR3_CTSIE_Msk  = 0x400 // Bit mask of CTSIE field.
	USART_CR3_CTSIE      = 0x400 // Bit CTSIE.
	USART_CR3_CTSE_Pos   = 0x9   // Position of CTSE field.
	USART_CR3_CTSE_Msk   = 0x200 // Bit mask of CTSE field.
	USART_CR3_CTSE       = 0x200 // Bit CTSE.
	USART_CR3_RTSE_Pos   = 0x8   // Position of RTSE field.
	USART_CR3_RTSE_Msk   = 0x100 // Bit mask of RTSE field.
	USART_CR3_RTSE       = 0x100 // Bit RTSE.
	USART_CR3_DMAT_Pos   = 0x7   // Position of DMAT field.
	USART_CR3_DMAT_Msk   = 0x80  // Bit mask of DMAT field.
	USART_CR3_DMAT       = 0x80  // Bit DMAT.
	USART_CR3_DMAR_Pos   = 0x6   // Position of DMAR field.
	USART_CR3_DMAR_Msk   = 0x40  // Bit mask of DMAR field.
	USART_CR3_DMAR       = 0x40  // Bit DMAR.
	USART_CR3_SCEN_Pos   = 0x5   // Position of SCEN field.
	USART_CR3_SCEN_Msk   = 0x20  // Bit mask of SCEN field.
	USART_CR3_SCEN       = 0x20  // Bit SCEN.
	USART_CR3_NACK_Pos   = 0x4   // Position of NACK field.
	USART_CR3_NACK_Msk   = 0x10  // Bit mask of NACK field.
	USART_CR3_NACK       = 0x10  // Bit NACK.
	USART_CR3_HDSEL_Pos  = 0x3   // Position of HDSEL field.
	USART_CR3_HDSEL_Msk  = 0x8   // Bit mask of HDSEL field.
	USART_CR3_HDSEL      = 0x8   // Bit HDSEL.
	USART_CR3_IRLP_Pos   = 0x2   // Position of IRLP field.
	USART_CR3_IRLP_Msk   = 0x4   // Bit mask of IRLP field.
	USART_CR3_IRLP       = 0x4   // Bit IRLP.
	USART_CR3_IREN_Pos   = 0x1   // Position of IREN field.
	USART_CR3_IREN_Msk   = 0x2   // Bit mask of IREN field.
	USART_CR3_IREN       = 0x2   // Bit IREN.
	USART_CR3_EIE_Pos    = 0x0   // Position of EIE field.
	USART_CR3_EIE_Msk    = 0x1   // Bit mask of EIE field.
	USART_CR3_EIE        = 0x1   // Bit EIE.

	// GTPR: Guard time and prescaler           register
	USART_GTPR_GT_Pos  = 0x8    // Position of GT field.
	USART_GTPR_GT_Msk  = 0xff00 // Bit mask of GT field.
	USART_GTPR_PSC_Pos = 0x0    // Position of PSC field.
	USART_GTPR_PSC_Msk = 0xff   // Bit mask of PSC field.
)

// Bitfields for WWDG: Window watchdog
const (
	// CR: Control register
	WWDG_CR_WDGA_Pos = 0x7  // Position of WDGA field.
	WWDG_CR_WDGA_Msk = 0x80 // Bit mask of WDGA field.
	WWDG_CR_WDGA     = 0x80 // Bit WDGA.
	WWDG_CR_T_Pos    = 0x0  // Position of T field.
	WWDG_CR_T_Msk    = 0x7f // Bit mask of T field.

	// CFR: Configuration register
	WWDG_CFR_EWI_Pos    = 0x9   // Position of EWI field.
	WWDG_CFR_EWI_Msk    = 0x200 // Bit mask of EWI field.
	WWDG_CFR_EWI        = 0x200 // Bit EWI.
	WWDG_CFR_WDGTB1_Pos = 0x8   // Position of WDGTB1 field.
	WWDG_CFR_WDGTB1_Msk = 0x100 // Bit mask of WDGTB1 field.
	WWDG_CFR_WDGTB1     = 0x100 // Bit WDGTB1.
	WWDG_CFR_WDGTB0_Pos = 0x7   // Position of WDGTB0 field.
	WWDG_CFR_WDGTB0_Msk = 0x80  // Bit mask of WDGTB0 field.
	WWDG_CFR_WDGTB0     = 0x80  // Bit WDGTB0.
	WWDG_CFR_W_Pos      = 0x0   // Position of W field.
	WWDG_CFR_W_Msk      = 0x7f  // Bit mask of W field.

	// SR: Status register
	WWDG_SR_EWIF_Pos = 0x0 // Position of EWIF field.
	WWDG_SR_EWIF_Msk = 0x1 // Bit mask of EWIF field.
	WWDG_SR_EWIF     = 0x1 // Bit EWIF.
)

// Bitfields for DMA2: DMA controller
const (
	// LISR: low interrupt status register
	DMA_LISR_TCIF3_Pos  = 0x1b      // Position of TCIF3 field.
	DMA_LISR_TCIF3_Msk  = 0x8000000 // Bit mask of TCIF3 field.
	DMA_LISR_TCIF3      = 0x8000000 // Bit TCIF3.
	DMA_LISR_HTIF3_Pos  = 0x1a      // Position of HTIF3 field.
	DMA_LISR_HTIF3_Msk  = 0x4000000 // Bit mask of HTIF3 field.
	DMA_LISR_HTIF3      = 0x4000000 // Bit HTIF3.
	DMA_LISR_TEIF3_Pos  = 0x19      // Position of TEIF3 field.
	DMA_LISR_TEIF3_Msk  = 0x2000000 // Bit mask of TEIF3 field.
	DMA_LISR_TEIF3      = 0x2000000 // Bit TEIF3.
	DMA_LISR_DMEIF3_Pos = 0x18      // Position of DMEIF3 field.
	DMA_LISR_DMEIF3_Msk = 0x1000000 // Bit mask of DMEIF3 field.
	DMA_LISR_DMEIF3     = 0x1000000 // Bit DMEIF3.
	DMA_LISR_FEIF3_Pos  = 0x16      // Position of FEIF3 field.
	DMA_LISR_FEIF3_Msk  = 0x400000  // Bit mask of FEIF3 field.
	DMA_LISR_FEIF3      = 0x400000  // Bit FEIF3.
	DMA_LISR_TCIF2_Pos  = 0x15      // Position of TCIF2 field.
	DMA_LISR_TCIF2_Msk  = 0x200000  // Bit mask of TCIF2 field.
	DMA_LISR_TCIF2      = 0x200000  // Bit TCIF2.
	DMA_LISR_HTIF2_Pos  = 0x14      // Position of HTIF2 field.
	DMA_LISR_HTIF2_Msk  = 0x100000  // Bit mask of HTIF2 field.
	DMA_LISR_HTIF2      = 0x100000  // Bit HTIF2.
	DMA_LISR_TEIF2_Pos  = 0x13      // Position of TEIF2 field.
	DMA_LISR_TEIF2_Msk  = 0x80000   // Bit mask of TEIF2 field.
	DMA_LISR_TEIF2      = 0x80000   // Bit TEIF2.
	DMA_LISR_DMEIF2_Pos = 0x12      // Position of DMEIF2 field.
	DMA_LISR_DMEIF2_Msk = 0x40000   // Bit mask of DMEIF2 field.
	DMA_LISR_DMEIF2     = 0x40000   // Bit DMEIF2.
	DMA_LISR_FEIF2_Pos  = 0x10      // Position of FEIF2 field.
	DMA_LISR_FEIF2_Msk  = 0x10000   // Bit mask of FEIF2 field.
	DMA_LISR_FEIF2      = 0x10000   // Bit FEIF2.
	DMA_LISR_TCIF1_Pos  = 0xb       // Position of TCIF1 field.
	DMA_LISR_TCIF1_Msk  = 0x800     // Bit mask of TCIF1 field.
	DMA_LISR_TCIF1      = 0x800     // Bit TCIF1.
	DMA_LISR_HTIF1_Pos  = 0xa       // Position of HTIF1 field.
	DMA_LISR_HTIF1_Msk  = 0x400     // Bit mask of HTIF1 field.
	DMA_LISR_HTIF1      = 0x400     // Bit HTIF1.
	DMA_LISR_TEIF1_Pos  = 0x9       // Position of TEIF1 field.
	DMA_LISR_TEIF1_Msk  = 0x200     // Bit mask of TEIF1 field.
	DMA_LISR_TEIF1      = 0x200     // Bit TEIF1.
	DMA_LISR_DMEIF1_Pos = 0x8       // Position of DMEIF1 field.
	DMA_LISR_DMEIF1_Msk = 0x100     // Bit mask of DMEIF1 field.
	DMA_LISR_DMEIF1     = 0x100     // Bit DMEIF1.
	DMA_LISR_FEIF1_Pos  = 0x6       // Position of FEIF1 field.
	DMA_LISR_FEIF1_Msk  = 0x40      // Bit mask of FEIF1 field.
	DMA_LISR_FEIF1      = 0x40      // Bit FEIF1.
	DMA_LISR_TCIF0_Pos  = 0x5       // Position of TCIF0 field.
	DMA_LISR_TCIF0_Msk  = 0x20      // Bit mask of TCIF0 field.
	DMA_LISR_TCIF0      = 0x20      // Bit TCIF0.
	DMA_LISR_HTIF0_Pos  = 0x4       // Position of HTIF0 field.
	DMA_LISR_HTIF0_Msk  = 0x10      // Bit mask of HTIF0 field.
	DMA_LISR_HTIF0      = 0x10      // Bit HTIF0.
	DMA_LISR_TEIF0_Pos  = 0x3       // Position of TEIF0 field.
	DMA_LISR_TEIF0_Msk  = 0x8       // Bit mask of TEIF0 field.
	DMA_LISR_TEIF0      = 0x8       // Bit TEIF0.
	DMA_LISR_DMEIF0_Pos = 0x2       // Position of DMEIF0 field.
	DMA_LISR_DMEIF0_Msk = 0x4       // Bit mask of DMEIF0 field.
	DMA_LISR_DMEIF0     = 0x4       // Bit DMEIF0.
	DMA_LISR_FEIF0_Pos  = 0x0       // Position of FEIF0 field.
	DMA_LISR_FEIF0_Msk  = 0x1       // Bit mask of FEIF0 field.
	DMA_LISR_FEIF0      = 0x1       // Bit FEIF0.

	// HISR: high interrupt status register
	DMA_HISR_TCIF7_Pos  = 0x1b      // Position of TCIF7 field.
	DMA_HISR_TCIF7_Msk  = 0x8000000 // Bit mask of TCIF7 field.
	DMA_HISR_TCIF7      = 0x8000000 // Bit TCIF7.
	DMA_HISR_HTIF7_Pos  = 0x1a      // Position of HTIF7 field.
	DMA_HISR_HTIF7_Msk  = 0x4000000 // Bit mask of HTIF7 field.
	DMA_HISR_HTIF7      = 0x4000000 // Bit HTIF7.
	DMA_HISR_TEIF7_Pos  = 0x19      // Position of TEIF7 field.
	DMA_HISR_TEIF7_Msk  = 0x2000000 // Bit mask of TEIF7 field.
	DMA_HISR_TEIF7      = 0x2000000 // Bit TEIF7.
	DMA_HISR_DMEIF7_Pos = 0x18      // Position of DMEIF7 field.
	DMA_HISR_DMEIF7_Msk = 0x1000000 // Bit mask of DMEIF7 field.
	DMA_HISR_DMEIF7     = 0x1000000 // Bit DMEIF7.
	DMA_HISR_FEIF7_Pos  = 0x16      // Position of FEIF7 field.
	DMA_HISR_FEIF7_Msk  = 0x400000  // Bit mask of FEIF7 field.
	DMA_HISR_FEIF7      = 0x400000  // Bit FEIF7.
	DMA_HISR_TCIF6_Pos  = 0x15      // Position of TCIF6 field.
	DMA_HISR_TCIF6_Msk  = 0x200000  // Bit mask of TCIF6 field.
	DMA_HISR_TCIF6      = 0x200000  // Bit TCIF6.
	DMA_HISR_HTIF6_Pos  = 0x14      // Position of HTIF6 field.
	DMA_HISR_HTIF6_Msk  = 0x100000  // Bit mask of HTIF6 field.
	DMA_HISR_HTIF6      = 0x100000  // Bit HTIF6.
	DMA_HISR_TEIF6_Pos  = 0x13      // Position of TEIF6 field.
	DMA_HISR_TEIF6_Msk  = 0x80000   // Bit mask of TEIF6 field.
	DMA_HISR_TEIF6      = 0x80000   // Bit TEIF6.
	DMA_HISR_DMEIF6_Pos = 0x12      // Position of DMEIF6 field.
	DMA_HISR_DMEIF6_Msk = 0x40000   // Bit mask of DMEIF6 field.
	DMA_HISR_DMEIF6     = 0x40000   // Bit DMEIF6.
	DMA_HISR_FEIF6_Pos  = 0x10      // Position of FEIF6 field.
	DMA_HISR_FEIF6_Msk  = 0x10000   // Bit mask of FEIF6 field.
	DMA_HISR_FEIF6      = 0x10000   // Bit FEIF6.
	DMA_HISR_TCIF5_Pos  = 0xb       // Position of TCIF5 field.
	DMA_HISR_TCIF5_Msk  = 0x800     // Bit mask of TCIF5 field.
	DMA_HISR_TCIF5      = 0x800     // Bit TCIF5.
	DMA_HISR_HTIF5_Pos  = 0xa       // Position of HTIF5 field.
	DMA_HISR_HTIF5_Msk  = 0x400     // Bit mask of HTIF5 field.
	DMA_HISR_HTIF5      = 0x400     // Bit HTIF5.
	DMA_HISR_TEIF5_Pos  = 0x9       // Position of TEIF5 field.
	DMA_HISR_TEIF5_Msk  = 0x200     // Bit mask of TEIF5 field.
	DMA_HISR_TEIF5      = 0x200     // Bit TEIF5.
	DMA_HISR_DMEIF5_Pos = 0x8       // Position of DMEIF5 field.
	DMA_HISR_DMEIF5_Msk = 0x100     // Bit mask of DMEIF5 field.
	DMA_HISR_DMEIF5     = 0x100     // Bit DMEIF5.
	DMA_HISR_FEIF5_Pos  = 0x6       // Position of FEIF5 field.
	DMA_HISR_FEIF5_Msk  = 0x40      // Bit mask of FEIF5 field.
	DMA_HISR_FEIF5      = 0x40      // Bit FEIF5.
	DMA_HISR_TCIF4_Pos  = 0x5       // Position of TCIF4 field.
	DMA_HISR_TCIF4_Msk  = 0x20      // Bit mask of TCIF4 field.
	DMA_HISR_TCIF4      = 0x20      // Bit TCIF4.
	DMA_HISR_HTIF4_Pos  = 0x4       // Position of HTIF4 field.
	DMA_HISR_HTIF4_Msk  = 0x10      // Bit mask of HTIF4 field.
	DMA_HISR_HTIF4      = 0x10      // Bit HTIF4.
	DMA_HISR_TEIF4_Pos  = 0x3       // Position of TEIF4 field.
	DMA_HISR_TEIF4_Msk  = 0x8       // Bit mask of TEIF4 field.
	DMA_HISR_TEIF4      = 0x8       // Bit TEIF4.
	DMA_HISR_DMEIF4_Pos = 0x2       // Position of DMEIF4 field.
	DMA_HISR_DMEIF4_Msk = 0x4       // Bit mask of DMEIF4 field.
	DMA_HISR_DMEIF4     = 0x4       // Bit DMEIF4.
	DMA_HISR_FEIF4_Pos  = 0x0       // Position of FEIF4 field.
	DMA_HISR_FEIF4_Msk  = 0x1       // Bit mask of FEIF4 field.
	DMA_HISR_FEIF4      = 0x1       // Bit FEIF4.

	// LIFCR: low interrupt flag clear           register
	DMA_LIFCR_CTCIF3_Pos  = 0x1b      // Position of CTCIF3 field.
	DMA_LIFCR_CTCIF3_Msk  = 0x8000000 // Bit mask of CTCIF3 field.
	DMA_LIFCR_CTCIF3      = 0x8000000 // Bit CTCIF3.
	DMA_LIFCR_CHTIF3_Pos  = 0x1a      // Position of CHTIF3 field.
	DMA_LIFCR_CHTIF3_Msk  = 0x4000000 // Bit mask of CHTIF3 field.
	DMA_LIFCR_CHTIF3      = 0x4000000 // Bit CHTIF3.
	DMA_LIFCR_CTEIF3_Pos  = 0x19      // Position of CTEIF3 field.
	DMA_LIFCR_CTEIF3_Msk  = 0x2000000 // Bit mask of CTEIF3 field.
	DMA_LIFCR_CTEIF3      = 0x2000000 // Bit CTEIF3.
	DMA_LIFCR_CDMEIF3_Pos = 0x18      // Position of CDMEIF3 field.
	DMA_LIFCR_CDMEIF3_Msk = 0x1000000 // Bit mask of CDMEIF3 field.
	DMA_LIFCR_CDMEIF3     = 0x1000000 // Bit CDMEIF3.
	DMA_LIFCR_CFEIF3_Pos  = 0x16      // Position of CFEIF3 field.
	DMA_LIFCR_CFEIF3_Msk  = 0x400000  // Bit mask of CFEIF3 field.
	DMA_LIFCR_CFEIF3      = 0x400000  // Bit CFEIF3.
	DMA_LIFCR_CTCIF2_Pos  = 0x15      // Position of CTCIF2 field.
	DMA_LIFCR_CTCIF2_Msk  = 0x200000  // Bit mask of CTCIF2 field.
	DMA_LIFCR_CTCIF2      = 0x200000  // Bit CTCIF2.
	DMA_LIFCR_CHTIF2_Pos  = 0x14      // Position of CHTIF2 field.
	DMA_LIFCR_CHTIF2_Msk  = 0x100000  // Bit mask of CHTIF2 field.
	DMA_LIFCR_CHTIF2      = 0x100000  // Bit CHTIF2.
	DMA_LIFCR_CTEIF2_Pos  = 0x13      // Position of CTEIF2 field.
	DMA_LIFCR_CTEIF2_Msk  = 0x80000   // Bit mask of CTEIF2 field.
	DMA_LIFCR_CTEIF2      = 0x80000   // Bit CTEIF2.
	DMA_LIFCR_CDMEIF2_Pos = 0x12      // Position of CDMEIF2 field.
	DMA_LIFCR_CDMEIF2_Msk = 0x40000   // Bit mask of CDMEIF2 field.
	DMA_LIFCR_CDMEIF2     = 0x40000   // Bit CDMEIF2.
	DMA_LIFCR_CFEIF2_Pos  = 0x10      // Position of CFEIF2 field.
	DMA_LIFCR_CFEIF2_Msk  = 0x10000   // Bit mask of CFEIF2 field.
	DMA_LIFCR_CFEIF2      = 0x10000   // Bit CFEIF2.
	DMA_LIFCR_CTCIF1_Pos  = 0xb       // Position of CTCIF1 field.
	DMA_LIFCR_CTCIF1_Msk  = 0x800     // Bit mask of CTCIF1 field.
	DMA_LIFCR_CTCIF1      = 0x800     // Bit CTCIF1.
	DMA_LIFCR_CHTIF1_Pos  = 0xa       // Position of CHTIF1 field.
	DMA_LIFCR_CHTIF1_Msk  = 0x400     // Bit mask of CHTIF1 field.
	DMA_LIFCR_CHTIF1      = 0x400     // Bit CHTIF1.
	DMA_LIFCR_CTEIF1_Pos  = 0x9       // Position of CTEIF1 field.
	DMA_LIFCR_CTEIF1_Msk  = 0x200     // Bit mask of CTEIF1 field.
	DMA_LIFCR_CTEIF1      = 0x200     // Bit CTEIF1.
	DMA_LIFCR_CDMEIF1_Pos = 0x8       // Position of CDMEIF1 field.
	DMA_LIFCR_CDMEIF1_Msk = 0x100     // Bit mask of CDMEIF1 field.
	DMA_LIFCR_CDMEIF1     = 0x100     // Bit CDMEIF1.
	DMA_LIFCR_CFEIF1_Pos  = 0x6       // Position of CFEIF1 field.
	DMA_LIFCR_CFEIF1_Msk  = 0x40      // Bit mask of CFEIF1 field.
	DMA_LIFCR_CFEIF1      = 0x40      // Bit CFEIF1.
	DMA_LIFCR_CTCIF0_Pos  = 0x5       // Position of CTCIF0 field.
	DMA_LIFCR_CTCIF0_Msk  = 0x20      // Bit mask of CTCIF0 field.
	DMA_LIFCR_CTCIF0      = 0x20      // Bit CTCIF0.
	DMA_LIFCR_CHTIF0_Pos  = 0x4       // Position of CHTIF0 field.
	DMA_LIFCR_CHTIF0_Msk  = 0x10      // Bit mask of CHTIF0 field.
	DMA_LIFCR_CHTIF0      = 0x10      // Bit CHTIF0.
	DMA_LIFCR_CTEIF0_Pos  = 0x3       // Position of CTEIF0 field.
	DMA_LIFCR_CTEIF0_Msk  = 0x8       // Bit mask of CTEIF0 field.
	DMA_LIFCR_CTEIF0      = 0x8       // Bit CTEIF0.
	DMA_LIFCR_CDMEIF0_Pos = 0x2       // Position of CDMEIF0 field.
	DMA_LIFCR_CDMEIF0_Msk = 0x4       // Bit mask of CDMEIF0 field.
	DMA_LIFCR_CDMEIF0     = 0x4       // Bit CDMEIF0.
	DMA_LIFCR_CFEIF0_Pos  = 0x0       // Position of CFEIF0 field.
	DMA_LIFCR_CFEIF0_Msk  = 0x1       // Bit mask of CFEIF0 field.
	DMA_LIFCR_CFEIF0      = 0x1       // Bit CFEIF0.

	// HIFCR: high interrupt flag clear           register
	DMA_HIFCR_CTCIF7_Pos  = 0x1b      // Position of CTCIF7 field.
	DMA_HIFCR_CTCIF7_Msk  = 0x8000000 // Bit mask of CTCIF7 field.
	DMA_HIFCR_CTCIF7      = 0x8000000 // Bit CTCIF7.
	DMA_HIFCR_CHTIF7_Pos  = 0x1a      // Position of CHTIF7 field.
	DMA_HIFCR_CHTIF7_Msk  = 0x4000000 // Bit mask of CHTIF7 field.
	DMA_HIFCR_CHTIF7      = 0x4000000 // Bit CHTIF7.
	DMA_HIFCR_CTEIF7_Pos  = 0x19      // Position of CTEIF7 field.
	DMA_HIFCR_CTEIF7_Msk  = 0x2000000 // Bit mask of CTEIF7 field.
	DMA_HIFCR_CTEIF7      = 0x2000000 // Bit CTEIF7.
	DMA_HIFCR_CDMEIF7_Pos = 0x18      // Position of CDMEIF7 field.
	DMA_HIFCR_CDMEIF7_Msk = 0x1000000 // Bit mask of CDMEIF7 field.
	DMA_HIFCR_CDMEIF7     = 0x1000000 // Bit CDMEIF7.
	DMA_HIFCR_CFEIF7_Pos  = 0x16      // Position of CFEIF7 field.
	DMA_HIFCR_CFEIF7_Msk  = 0x400000  // Bit mask of CFEIF7 field.
	DMA_HIFCR_CFEIF7      = 0x400000  // Bit CFEIF7.
	DMA_HIFCR_CTCIF6_Pos  = 0x15      // Position of CTCIF6 field.
	DMA_HIFCR_CTCIF6_Msk  = 0x200000  // Bit mask of CTCIF6 field.
	DMA_HIFCR_CTCIF6      = 0x200000  // Bit CTCIF6.
	DMA_HIFCR_CHTIF6_Pos  = 0x14      // Position of CHTIF6 field.
	DMA_HIFCR_CHTIF6_Msk  = 0x100000  // Bit mask of CHTIF6 field.
	DMA_HIFCR_CHTIF6      = 0x100000  // Bit CHTIF6.
	DMA_HIFCR_CTEIF6_Pos  = 0x13      // Position of CTEIF6 field.
	DMA_HIFCR_CTEIF6_Msk  = 0x80000   // Bit mask of CTEIF6 field.
	DMA_HIFCR_CTEIF6      = 0x80000   // Bit CTEIF6.
	DMA_HIFCR_CDMEIF6_Pos = 0x12      // Position of CDMEIF6 field.
	DMA_HIFCR_CDMEIF6_Msk = 0x40000   // Bit mask of CDMEIF6 field.
	DMA_HIFCR_CDMEIF6     = 0x40000   // Bit CDMEIF6.
	DMA_HIFCR_CFEIF6_Pos  = 0x10      // Position of CFEIF6 field.
	DMA_HIFCR_CFEIF6_Msk  = 0x10000   // Bit mask of CFEIF6 field.
	DMA_HIFCR_CFEIF6      = 0x10000   // Bit CFEIF6.
	DMA_HIFCR_CTCIF5_Pos  = 0xb       // Position of CTCIF5 field.
	DMA_HIFCR_CTCIF5_Msk  = 0x800     // Bit mask of CTCIF5 field.
	DMA_HIFCR_CTCIF5      = 0x800     // Bit CTCIF5.
	DMA_HIFCR_CHTIF5_Pos  = 0xa       // Position of CHTIF5 field.
	DMA_HIFCR_CHTIF5_Msk  = 0x400     // Bit mask of CHTIF5 field.
	DMA_HIFCR_CHTIF5      = 0x400     // Bit CHTIF5.
	DMA_HIFCR_CTEIF5_Pos  = 0x9       // Position of CTEIF5 field.
	DMA_HIFCR_CTEIF5_Msk  = 0x200     // Bit mask of CTEIF5 field.
	DMA_HIFCR_CTEIF5      = 0x200     // Bit CTEIF5.
	DMA_HIFCR_CDMEIF5_Pos = 0x8       // Position of CDMEIF5 field.
	DMA_HIFCR_CDMEIF5_Msk = 0x100     // Bit mask of CDMEIF5 field.
	DMA_HIFCR_CDMEIF5     = 0x100     // Bit CDMEIF5.
	DMA_HIFCR_CFEIF5_Pos  = 0x6       // Position of CFEIF5 field.
	DMA_HIFCR_CFEIF5_Msk  = 0x40      // Bit mask of CFEIF5 field.
	DMA_HIFCR_CFEIF5      = 0x40      // Bit CFEIF5.
	DMA_HIFCR_CTCIF4_Pos  = 0x5       // Position of CTCIF4 field.
	DMA_HIFCR_CTCIF4_Msk  = 0x20      // Bit mask of CTCIF4 field.
	DMA_HIFCR_CTCIF4      = 0x20      // Bit CTCIF4.
	DMA_HIFCR_CHTIF4_Pos  = 0x4       // Position of CHTIF4 field.
	DMA_HIFCR_CHTIF4_Msk  = 0x10      // Bit mask of CHTIF4 field.
	DMA_HIFCR_CHTIF4      = 0x10      // Bit CHTIF4.
	DMA_HIFCR_CTEIF4_Pos  = 0x3       // Position of CTEIF4 field.
	DMA_HIFCR_CTEIF4_Msk  = 0x8       // Bit mask of CTEIF4 field.
	DMA_HIFCR_CTEIF4      = 0x8       // Bit CTEIF4.
	DMA_HIFCR_CDMEIF4_Pos = 0x2       // Position of CDMEIF4 field.
	DMA_HIFCR_CDMEIF4_Msk = 0x4       // Bit mask of CDMEIF4 field.
	DMA_HIFCR_CDMEIF4     = 0x4       // Bit CDMEIF4.
	DMA_HIFCR_CFEIF4_Pos  = 0x0       // Position of CFEIF4 field.
	DMA_HIFCR_CFEIF4_Msk  = 0x1       // Bit mask of CFEIF4 field.
	DMA_HIFCR_CFEIF4      = 0x1       // Bit CFEIF4.

	// S0CR: stream x configuration           register
	DMA_S0CR_CHSEL_Pos  = 0x19      // Position of CHSEL field.
	DMA_S0CR_CHSEL_Msk  = 0xe000000 // Bit mask of CHSEL field.
	DMA_S0CR_MBURST_Pos = 0x17      // Position of MBURST field.
	DMA_S0CR_MBURST_Msk = 0x1800000 // Bit mask of MBURST field.
	DMA_S0CR_PBURST_Pos = 0x15      // Position of PBURST field.
	DMA_S0CR_PBURST_Msk = 0x600000  // Bit mask of PBURST field.
	DMA_S0CR_CT_Pos     = 0x13      // Position of CT field.
	DMA_S0CR_CT_Msk     = 0x80000   // Bit mask of CT field.
	DMA_S0CR_CT         = 0x80000   // Bit CT.
	DMA_S0CR_DBM_Pos    = 0x12      // Position of DBM field.
	DMA_S0CR_DBM_Msk    = 0x40000   // Bit mask of DBM field.
	DMA_S0CR_DBM        = 0x40000   // Bit DBM.
	DMA_S0CR_PL_Pos     = 0x10      // Position of PL field.
	DMA_S0CR_PL_Msk     = 0x30000   // Bit mask of PL field.
	DMA_S0CR_PINCOS_Pos = 0xf       // Position of PINCOS field.
	DMA_S0CR_PINCOS_Msk = 0x8000    // Bit mask of PINCOS field.
	DMA_S0CR_PINCOS     = 0x8000    // Bit PINCOS.
	DMA_S0CR_MSIZE_Pos  = 0xd       // Position of MSIZE field.
	DMA_S0CR_MSIZE_Msk  = 0x6000    // Bit mask of MSIZE field.
	DMA_S0CR_PSIZE_Pos  = 0xb       // Position of PSIZE field.
	DMA_S0CR_PSIZE_Msk  = 0x1800    // Bit mask of PSIZE field.
	DMA_S0CR_MINC_Pos   = 0xa       // Position of MINC field.
	DMA_S0CR_MINC_Msk   = 0x400     // Bit mask of MINC field.
	DMA_S0CR_MINC       = 0x400     // Bit MINC.
	DMA_S0CR_PINC_Pos   = 0x9       // Position of PINC field.
	DMA_S0CR_PINC_Msk   = 0x200     // Bit mask of PINC field.
	DMA_S0CR_PINC       = 0x200     // Bit PINC.
	DMA_S0CR_CIRC_Pos   = 0x8       // Position of CIRC field.
	DMA_S0CR_CIRC_Msk   = 0x100     // Bit mask of CIRC field.
	DMA_S0CR_CIRC       = 0x100     // Bit CIRC.
	DMA_S0CR_DIR_Pos    = 0x6       // Position of DIR field.
	DMA_S0CR_DIR_Msk    = 0xc0      // Bit mask of DIR field.
	DMA_S0CR_PFCTRL_Pos = 0x5       // Position of PFCTRL field.
	DMA_S0CR_PFCTRL_Msk = 0x20      // Bit mask of PFCTRL field.
	DMA_S0CR_PFCTRL     = 0x20      // Bit PFCTRL.
	DMA_S0CR_TCIE_Pos   = 0x4       // Position of TCIE field.
	DMA_S0CR_TCIE_Msk   = 0x10      // Bit mask of TCIE field.
	DMA_S0CR_TCIE       = 0x10      // Bit TCIE.
	DMA_S0CR_HTIE_Pos   = 0x3       // Position of HTIE field.
	DMA_S0CR_HTIE_Msk   = 0x8       // Bit mask of HTIE field.
	DMA_S0CR_HTIE       = 0x8       // Bit HTIE.
	DMA_S0CR_TEIE_Pos   = 0x2       // Position of TEIE field.
	DMA_S0CR_TEIE_Msk   = 0x4       // Bit mask of TEIE field.
	DMA_S0CR_TEIE       = 0x4       // Bit TEIE.
	DMA_S0CR_DMEIE_Pos  = 0x1       // Position of DMEIE field.
	DMA_S0CR_DMEIE_Msk  = 0x2       // Bit mask of DMEIE field.
	DMA_S0CR_DMEIE      = 0x2       // Bit DMEIE.
	DMA_S0CR_EN_Pos     = 0x0       // Position of EN field.
	DMA_S0CR_EN_Msk     = 0x1       // Bit mask of EN field.
	DMA_S0CR_EN         = 0x1       // Bit EN.

	// S0NDTR: stream x number of data           register
	DMA_S0NDTR_NDT_Pos = 0x0    // Position of NDT field.
	DMA_S0NDTR_NDT_Msk = 0xffff // Bit mask of NDT field.

	// S0PAR: stream x peripheral address           register
	DMA_S0PAR_PA_Pos = 0x0        // Position of PA field.
	DMA_S0PAR_PA_Msk = 0xffffffff // Bit mask of PA field.

	// S0M0AR: stream x memory 0 address           register
	DMA_S0M0AR_M0A_Pos = 0x0        // Position of M0A field.
	DMA_S0M0AR_M0A_Msk = 0xffffffff // Bit mask of M0A field.

	// S0M1AR: stream x memory 1 address           register
	DMA_S0M1AR_M1A_Pos = 0x0        // Position of M1A field.
	DMA_S0M1AR_M1A_Msk = 0xffffffff // Bit mask of M1A field.

	// S0FCR: stream x FIFO control register
	DMA_S0FCR_FEIE_Pos  = 0x7  // Position of FEIE field.
	DMA_S0FCR_FEIE_Msk  = 0x80 // Bit mask of FEIE field.
	DMA_S0FCR_FEIE      = 0x80 // Bit FEIE.
	DMA_S0FCR_FS_Pos    = 0x3  // Position of FS field.
	DMA_S0FCR_FS_Msk    = 0x38 // Bit mask of FS field.
	DMA_S0FCR_DMDIS_Pos = 0x2  // Position of DMDIS field.
	DMA_S0FCR_DMDIS_Msk = 0x4  // Bit mask of DMDIS field.
	DMA_S0FCR_DMDIS     = 0x4  // Bit DMDIS.
	DMA_S0FCR_FTH_Pos   = 0x0  // Position of FTH field.
	DMA_S0FCR_FTH_Msk   = 0x3  // Bit mask of FTH field.

	// S1CR: stream x configuration           register
	DMA_S1CR_CHSEL_Pos  = 0x19      // Position of CHSEL field.
	DMA_S1CR_CHSEL_Msk  = 0xe000000 // Bit mask of CHSEL field.
	DMA_S1CR_MBURST_Pos = 0x17      // Position of MBURST field.
	DMA_S1CR_MBURST_Msk = 0x1800000 // Bit mask of MBURST field.
	DMA_S1CR_PBURST_Pos = 0x15      // Position of PBURST field.
	DMA_S1CR_PBURST_Msk = 0x600000  // Bit mask of PBURST field.
	DMA_S1CR_ACK_Pos    = 0x14      // Position of ACK field.
	DMA_S1CR_ACK_Msk    = 0x100000  // Bit mask of ACK field.
	DMA_S1CR_ACK        = 0x100000  // Bit ACK.
	DMA_S1CR_CT_Pos     = 0x13      // Position of CT field.
	DMA_S1CR_CT_Msk     = 0x80000   // Bit mask of CT field.
	DMA_S1CR_CT         = 0x80000   // Bit CT.
	DMA_S1CR_DBM_Pos    = 0x12      // Position of DBM field.
	DMA_S1CR_DBM_Msk    = 0x40000   // Bit mask of DBM field.
	DMA_S1CR_DBM        = 0x40000   // Bit DBM.
	DMA_S1CR_PL_Pos     = 0x10      // Position of PL field.
	DMA_S1CR_PL_Msk     = 0x30000   // Bit mask of PL field.
	DMA_S1CR_PINCOS_Pos = 0xf       // Position of PINCOS field.
	DMA_S1CR_PINCOS_Msk = 0x8000    // Bit mask of PINCOS field.
	DMA_S1CR_PINCOS     = 0x8000    // Bit PINCOS.
	DMA_S1CR_MSIZE_Pos  = 0xd       // Position of MSIZE field.
	DMA_S1CR_MSIZE_Msk  = 0x6000    // Bit mask of MSIZE field.
	DMA_S1CR_PSIZE_Pos  = 0xb       // Position of PSIZE field.
	DMA_S1CR_PSIZE_Msk  = 0x1800    // Bit mask of PSIZE field.
	DMA_S1CR_MINC_Pos   = 0xa       // Position of MINC field.
	DMA_S1CR_MINC_Msk   = 0x400     // Bit mask of MINC field.
	DMA_S1CR_MINC       = 0x400     // Bit MINC.
	DMA_S1CR_PINC_Pos   = 0x9       // Position of PINC field.
	DMA_S1CR_PINC_Msk   = 0x200     // Bit mask of PINC field.
	DMA_S1CR_PINC       = 0x200     // Bit PINC.
	DMA_S1CR_CIRC_Pos   = 0x8       // Position of CIRC field.
	DMA_S1CR_CIRC_Msk   = 0x100     // Bit mask of CIRC field.
	DMA_S1CR_CIRC       = 0x100     // Bit CIRC.
	DMA_S1CR_DIR_Pos    = 0x6       // Position of DIR field.
	DMA_S1CR_DIR_Msk    = 0xc0      // Bit mask of DIR field.
	DMA_S1CR_PFCTRL_Pos = 0x5       // Position of PFCTRL field.
	DMA_S1CR_PFCTRL_Msk = 0x20      // Bit mask of PFCTRL field.
	DMA_S1CR_PFCTRL     = 0x20      // Bit PFCTRL.
	DMA_S1CR_TCIE_Pos   = 0x4       // Position of TCIE field.
	DMA_S1CR_TCIE_Msk   = 0x10      // Bit mask of TCIE field.
	DMA_S1CR_TCIE       = 0x10      // Bit TCIE.
	DMA_S1CR_HTIE_Pos   = 0x3       // Position of HTIE field.
	DMA_S1CR_HTIE_Msk   = 0x8       // Bit mask of HTIE field.
	DMA_S1CR_HTIE       = 0x8       // Bit HTIE.
	DMA_S1CR_TEIE_Pos   = 0x2       // Position of TEIE field.
	DMA_S1CR_TEIE_Msk   = 0x4       // Bit mask of TEIE field.
	DMA_S1CR_TEIE       = 0x4       // Bit TEIE.
	DMA_S1CR_DMEIE_Pos  = 0x1       // Position of DMEIE field.
	DMA_S1CR_DMEIE_Msk  = 0x2       // Bit mask of DMEIE field.
	DMA_S1CR_DMEIE      = 0x2       // Bit DMEIE.
	DMA_S1CR_EN_Pos     = 0x0       // Position of EN field.
	DMA_S1CR_EN_Msk     = 0x1       // Bit mask of EN field.
	DMA_S1CR_EN         = 0x1       // Bit EN.

	// S1NDTR: stream x number of data           register
	DMA_S1NDTR_NDT_Pos = 0x0    // Position of NDT field.
	DMA_S1NDTR_NDT_Msk = 0xffff // Bit mask of NDT field.

	// S1PAR: stream x peripheral address           register
	DMA_S1PAR_PA_Pos = 0x0        // Position of PA field.
	DMA_S1PAR_PA_Msk = 0xffffffff // Bit mask of PA field.

	// S1M0AR: stream x memory 0 address           register
	DMA_S1M0AR_M0A_Pos = 0x0        // Position of M0A field.
	DMA_S1M0AR_M0A_Msk = 0xffffffff // Bit mask of M0A field.

	// S1M1AR: stream x memory 1 address           register
	DMA_S1M1AR_M1A_Pos = 0x0        // Position of M1A field.
	DMA_S1M1AR_M1A_Msk = 0xffffffff // Bit mask of M1A field.

	// S1FCR: stream x FIFO control register
	DMA_S1FCR_FEIE_Pos  = 0x7  // Position of FEIE field.
	DMA_S1FCR_FEIE_Msk  = 0x80 // Bit mask of FEIE field.
	DMA_S1FCR_FEIE      = 0x80 // Bit FEIE.
	DMA_S1FCR_FS_Pos    = 0x3  // Position of FS field.
	DMA_S1FCR_FS_Msk    = 0x38 // Bit mask of FS field.
	DMA_S1FCR_DMDIS_Pos = 0x2  // Position of DMDIS field.
	DMA_S1FCR_DMDIS_Msk = 0x4  // Bit mask of DMDIS field.
	DMA_S1FCR_DMDIS     = 0x4  // Bit DMDIS.
	DMA_S1FCR_FTH_Pos   = 0x0  // Position of FTH field.
	DMA_S1FCR_FTH_Msk   = 0x3  // Bit mask of FTH field.

	// S2CR: stream x configuration           register
	DMA_S2CR_CHSEL_Pos  = 0x19      // Position of CHSEL field.
	DMA_S2CR_CHSEL_Msk  = 0xe000000 // Bit mask of CHSEL field.
	DMA_S2CR_MBURST_Pos = 0x17      // Position of MBURST field.
	DMA_S2CR_MBURST_Msk = 0x1800000 // Bit mask of MBURST field.
	DMA_S2CR_PBURST_Pos = 0x15      // Position of PBURST field.
	DMA_S2CR_PBURST_Msk = 0x600000  // Bit mask of PBURST field.
	DMA_S2CR_ACK_Pos    = 0x14      // Position of ACK field.
	DMA_S2CR_ACK_Msk    = 0x100000  // Bit mask of ACK field.
	DMA_S2CR_ACK        = 0x100000  // Bit ACK.
	DMA_S2CR_CT_Pos     = 0x13      // Position of CT field.
	DMA_S2CR_CT_Msk     = 0x80000   // Bit mask of CT field.
	DMA_S2CR_CT         = 0x80000   // Bit CT.
	DMA_S2CR_DBM_Pos    = 0x12      // Position of DBM field.
	DMA_S2CR_DBM_Msk    = 0x40000   // Bit mask of DBM field.
	DMA_S2CR_DBM        = 0x40000   // Bit DBM.
	DMA_S2CR_PL_Pos     = 0x10      // Position of PL field.
	DMA_S2CR_PL_Msk     = 0x30000   // Bit mask of PL field.
	DMA_S2CR_PINCOS_Pos = 0xf       // Position of PINCOS field.
	DMA_S2CR_PINCOS_Msk = 0x8000    // Bit mask of PINCOS field.
	DMA_S2CR_PINCOS     = 0x8000    // Bit PINCOS.
	DMA_S2CR_MSIZE_Pos  = 0xd       // Position of MSIZE field.
	DMA_S2CR_MSIZE_Msk  = 0x6000    // Bit mask of MSIZE field.
	DMA_S2CR_PSIZE_Pos  = 0xb       // Position of PSIZE field.
	DMA_S2CR_PSIZE_Msk  = 0x1800    // Bit mask of PSIZE field.
	DMA_S2CR_MINC_Pos   = 0xa       // Position of MINC field.
	DMA_S2CR_MINC_Msk   = 0x400     // Bit mask of MINC field.
	DMA_S2CR_MINC       = 0x400     // Bit MINC.
	DMA_S2CR_PINC_Pos   = 0x9       // Position of PINC field.
	DMA_S2CR_PINC_Msk   = 0x200     // Bit mask of PINC field.
	DMA_S2CR_PINC       = 0x200     // Bit PINC.
	DMA_S2CR_CIRC_Pos   = 0x8       // Position of CIRC field.
	DMA_S2CR_CIRC_Msk   = 0x100     // Bit mask of CIRC field.
	DMA_S2CR_CIRC       = 0x100     // Bit CIRC.
	DMA_S2CR_DIR_Pos    = 0x6       // Position of DIR field.
	DMA_S2CR_DIR_Msk    = 0xc0      // Bit mask of DIR field.
	DMA_S2CR_PFCTRL_Pos = 0x5       // Position of PFCTRL field.
	DMA_S2CR_PFCTRL_Msk = 0x20      // Bit mask of PFCTRL field.
	DMA_S2CR_PFCTRL     = 0x20      // Bit PFCTRL.
	DMA_S2CR_TCIE_Pos   = 0x4       // Position of TCIE field.
	DMA_S2CR_TCIE_Msk   = 0x10      // Bit mask of TCIE field.
	DMA_S2CR_TCIE       = 0x10      // Bit TCIE.
	DMA_S2CR_HTIE_Pos   = 0x3       // Position of HTIE field.
	DMA_S2CR_HTIE_Msk   = 0x8       // Bit mask of HTIE field.
	DMA_S2CR_HTIE       = 0x8       // Bit HTIE.
	DMA_S2CR_TEIE_Pos   = 0x2       // Position of TEIE field.
	DMA_S2CR_TEIE_Msk   = 0x4       // Bit mask of TEIE field.
	DMA_S2CR_TEIE       = 0x4       // Bit TEIE.
	DMA_S2CR_DMEIE_Pos  = 0x1       // Position of DMEIE field.
	DMA_S2CR_DMEIE_Msk  = 0x2       // Bit mask of DMEIE field.
	DMA_S2CR_DMEIE      = 0x2       // Bit DMEIE.
	DMA_S2CR_EN_Pos     = 0x0       // Position of EN field.
	DMA_S2CR_EN_Msk     = 0x1       // Bit mask of EN field.
	DMA_S2CR_EN         = 0x1       // Bit EN.

	// S2NDTR: stream x number of data           register
	DMA_S2NDTR_NDT_Pos = 0x0    // Position of NDT field.
	DMA_S2NDTR_NDT_Msk = 0xffff // Bit mask of NDT field.

	// S2PAR: stream x peripheral address           register
	DMA_S2PAR_PA_Pos = 0x0        // Position of PA field.
	DMA_S2PAR_PA_Msk = 0xffffffff // Bit mask of PA field.

	// S2M0AR: stream x memory 0 address           register
	DMA_S2M0AR_M0A_Pos = 0x0        // Position of M0A field.
	DMA_S2M0AR_M0A_Msk = 0xffffffff // Bit mask of M0A field.

	// S2M1AR: stream x memory 1 address           register
	DMA_S2M1AR_M1A_Pos = 0x0        // Position of M1A field.
	DMA_S2M1AR_M1A_Msk = 0xffffffff // Bit mask of M1A field.

	// S2FCR: stream x FIFO control register
	DMA_S2FCR_FEIE_Pos  = 0x7  // Position of FEIE field.
	DMA_S2FCR_FEIE_Msk  = 0x80 // Bit mask of FEIE field.
	DMA_S2FCR_FEIE      = 0x80 // Bit FEIE.
	DMA_S2FCR_FS_Pos    = 0x3  // Position of FS field.
	DMA_S2FCR_FS_Msk    = 0x38 // Bit mask of FS field.
	DMA_S2FCR_DMDIS_Pos = 0x2  // Position of DMDIS field.
	DMA_S2FCR_DMDIS_Msk = 0x4  // Bit mask of DMDIS field.
	DMA_S2FCR_DMDIS     = 0x4  // Bit DMDIS.
	DMA_S2FCR_FTH_Pos   = 0x0  // Position of FTH field.
	DMA_S2FCR_FTH_Msk   = 0x3  // Bit mask of FTH field.

	// S3CR: stream x configuration           register
	DMA_S3CR_CHSEL_Pos  = 0x19      // Position of CHSEL field.
	DMA_S3CR_CHSEL_Msk  = 0xe000000 // Bit mask of CHSEL field.
	DMA_S3CR_MBURST_Pos = 0x17      // Position of MBURST field.
	DMA_S3CR_MBURST_Msk = 0x1800000 // Bit mask of MBURST field.
	DMA_S3CR_PBURST_Pos = 0x15      // Position of PBURST field.
	DMA_S3CR_PBURST_Msk = 0x600000  // Bit mask of PBURST field.
	DMA_S3CR_ACK_Pos    = 0x14      // Position of ACK field.
	DMA_S3CR_ACK_Msk    = 0x100000  // Bit mask of ACK field.
	DMA_S3CR_ACK        = 0x100000  // Bit ACK.
	DMA_S3CR_CT_Pos     = 0x13      // Position of CT field.
	DMA_S3CR_CT_Msk     = 0x80000   // Bit mask of CT field.
	DMA_S3CR_CT         = 0x80000   // Bit CT.
	DMA_S3CR_DBM_Pos    = 0x12      // Position of DBM field.
	DMA_S3CR_DBM_Msk    = 0x40000   // Bit mask of DBM field.
	DMA_S3CR_DBM        = 0x40000   // Bit DBM.
	DMA_S3CR_PL_Pos     = 0x10      // Position of PL field.
	DMA_S3CR_PL_Msk     = 0x30000   // Bit mask of PL field.
	DMA_S3CR_PINCOS_Pos = 0xf       // Position of PINCOS field.
	DMA_S3CR_PINCOS_Msk = 0x8000    // Bit mask of PINCOS field.
	DMA_S3CR_PINCOS     = 0x8000    // Bit PINCOS.
	DMA_S3CR_MSIZE_Pos  = 0xd       // Position of MSIZE field.
	DMA_S3CR_MSIZE_Msk  = 0x6000    // Bit mask of MSIZE field.
	DMA_S3CR_PSIZE_Pos  = 0xb       // Position of PSIZE field.
	DMA_S3CR_PSIZE_Msk  = 0x1800    // Bit mask of PSIZE field.
	DMA_S3CR_MINC_Pos   = 0xa       // Position of MINC field.
	DMA_S3CR_MINC_Msk   = 0x400     // Bit mask of MINC field.
	DMA_S3CR_MINC       = 0x400     // Bit MINC.
	DMA_S3CR_PINC_Pos   = 0x9       // Position of PINC field.
	DMA_S3CR_PINC_Msk   = 0x200     // Bit mask of PINC field.
	DMA_S3CR_PINC       = 0x200     // Bit PINC.
	DMA_S3CR_CIRC_Pos   = 0x8       // Position of CIRC field.
	DMA_S3CR_CIRC_Msk   = 0x100     // Bit mask of CIRC field.
	DMA_S3CR_CIRC       = 0x100     // Bit CIRC.
	DMA_S3CR_DIR_Pos    = 0x6       // Position of DIR field.
	DMA_S3CR_DIR_Msk    = 0xc0      // Bit mask of DIR field.
	DMA_S3CR_PFCTRL_Pos = 0x5       // Position of PFCTRL field.
	DMA_S3CR_PFCTRL_Msk = 0x20      // Bit mask of PFCTRL field.
	DMA_S3CR_PFCTRL     = 0x20      // Bit PFCTRL.
	DMA_S3CR_TCIE_Pos   = 0x4       // Position of TCIE field.
	DMA_S3CR_TCIE_Msk   = 0x10      // Bit mask of TCIE field.
	DMA_S3CR_TCIE       = 0x10      // Bit TCIE.
	DMA_S3CR_HTIE_Pos   = 0x3       // Position of HTIE field.
	DMA_S3CR_HTIE_Msk   = 0x8       // Bit mask of HTIE field.
	DMA_S3CR_HTIE       = 0x8       // Bit HTIE.
	DMA_S3CR_TEIE_Pos   = 0x2       // Position of TEIE field.
	DMA_S3CR_TEIE_Msk   = 0x4       // Bit mask of TEIE field.
	DMA_S3CR_TEIE       = 0x4       // Bit TEIE.
	DMA_S3CR_DMEIE_Pos  = 0x1       // Position of DMEIE field.
	DMA_S3CR_DMEIE_Msk  = 0x2       // Bit mask of DMEIE field.
	DMA_S3CR_DMEIE      = 0x2       // Bit DMEIE.
	DMA_S3CR_EN_Pos     = 0x0       // Position of EN field.
	DMA_S3CR_EN_Msk     = 0x1       // Bit mask of EN field.
	DMA_S3CR_EN         = 0x1       // Bit EN.

	// S3NDTR: stream x number of data           register
	DMA_S3NDTR_NDT_Pos = 0x0    // Position of NDT field.
	DMA_S3NDTR_NDT_Msk = 0xffff // Bit mask of NDT field.

	// S3PAR: stream x peripheral address           register
	DMA_S3PAR_PA_Pos = 0x0        // Position of PA field.
	DMA_S3PAR_PA_Msk = 0xffffffff // Bit mask of PA field.

	// S3M0AR: stream x memory 0 address           register
	DMA_S3M0AR_M0A_Pos = 0x0        // Position of M0A field.
	DMA_S3M0AR_M0A_Msk = 0xffffffff // Bit mask of M0A field.

	// S3M1AR: stream x memory 1 address           register
	DMA_S3M1AR_M1A_Pos = 0x0        // Position of M1A field.
	DMA_S3M1AR_M1A_Msk = 0xffffffff // Bit mask of M1A field.

	// S3FCR: stream x FIFO control register
	DMA_S3FCR_FEIE_Pos  = 0x7  // Position of FEIE field.
	DMA_S3FCR_FEIE_Msk  = 0x80 // Bit mask of FEIE field.
	DMA_S3FCR_FEIE      = 0x80 // Bit FEIE.
	DMA_S3FCR_FS_Pos    = 0x3  // Position of FS field.
	DMA_S3FCR_FS_Msk    = 0x38 // Bit mask of FS field.
	DMA_S3FCR_DMDIS_Pos = 0x2  // Position of DMDIS field.
	DMA_S3FCR_DMDIS_Msk = 0x4  // Bit mask of DMDIS field.
	DMA_S3FCR_DMDIS     = 0x4  // Bit DMDIS.
	DMA_S3FCR_FTH_Pos   = 0x0  // Position of FTH field.
	DMA_S3FCR_FTH_Msk   = 0x3  // Bit mask of FTH field.

	// S4CR: stream x configuration           register
	DMA_S4CR_CHSEL_Pos  = 0x19      // Position of CHSEL field.
	DMA_S4CR_CHSEL_Msk  = 0xe000000 // Bit mask of CHSEL field.
	DMA_S4CR_MBURST_Pos = 0x17      // Position of MBURST field.
	DMA_S4CR_MBURST_Msk = 0x1800000 // Bit mask of MBURST field.
	DMA_S4CR_PBURST_Pos = 0x15      // Position of PBURST field.
	DMA_S4CR_PBURST_Msk = 0x600000  // Bit mask of PBURST field.
	DMA_S4CR_ACK_Pos    = 0x14      // Position of ACK field.
	DMA_S4CR_ACK_Msk    = 0x100000  // Bit mask of ACK field.
	DMA_S4CR_ACK        = 0x100000  // Bit ACK.
	DMA_S4CR_CT_Pos     = 0x13      // Position of CT field.
	DMA_S4CR_CT_Msk     = 0x80000   // Bit mask of CT field.
	DMA_S4CR_CT         = 0x80000   // Bit CT.
	DMA_S4CR_DBM_Pos    = 0x12      // Position of DBM field.
	DMA_S4CR_DBM_Msk    = 0x40000   // Bit mask of DBM field.
	DMA_S4CR_DBM        = 0x40000   // Bit DBM.
	DMA_S4CR_PL_Pos     = 0x10      // Position of PL field.
	DMA_S4CR_PL_Msk     = 0x30000   // Bit mask of PL field.
	DMA_S4CR_PINCOS_Pos = 0xf       // Position of PINCOS field.
	DMA_S4CR_PINCOS_Msk = 0x8000    // Bit mask of PINCOS field.
	DMA_S4CR_PINCOS     = 0x8000    // Bit PINCOS.
	DMA_S4CR_MSIZE_Pos  = 0xd       // Position of MSIZE field.
	DMA_S4CR_MSIZE_Msk  = 0x6000    // Bit mask of MSIZE field.
	DMA_S4CR_PSIZE_Pos  = 0xb       // Position of PSIZE field.
	DMA_S4CR_PSIZE_Msk  = 0x1800    // Bit mask of PSIZE field.
	DMA_S4CR_MINC_Pos   = 0xa       // Position of MINC field.
	DMA_S4CR_MINC_Msk   = 0x400     // Bit mask of MINC field.
	DMA_S4CR_MINC       = 0x400     // Bit MINC.
	DMA_S4CR_PINC_Pos   = 0x9       // Position of PINC field.
	DMA_S4CR_PINC_Msk   = 0x200     // Bit mask of PINC field.
	DMA_S4CR_PINC       = 0x200     // Bit PINC.
	DMA_S4CR_CIRC_Pos   = 0x8       // Position of CIRC field.
	DMA_S4CR_CIRC_Msk   = 0x100     // Bit mask of CIRC field.
	DMA_S4CR_CIRC       = 0x100     // Bit CIRC.
	DMA_S4CR_DIR_Pos    = 0x6       // Position of DIR field.
	DMA_S4CR_DIR_Msk    = 0xc0      // Bit mask of DIR field.
	DMA_S4CR_PFCTRL_Pos = 0x5       // Position of PFCTRL field.
	DMA_S4CR_PFCTRL_Msk = 0x20      // Bit mask of PFCTRL field.
	DMA_S4CR_PFCTRL     = 0x20      // Bit PFCTRL.
	DMA_S4CR_TCIE_Pos   = 0x4       // Position of TCIE field.
	DMA_S4CR_TCIE_Msk   = 0x10      // Bit mask of TCIE field.
	DMA_S4CR_TCIE       = 0x10      // Bit TCIE.
	DMA_S4CR_HTIE_Pos   = 0x3       // Position of HTIE field.
	DMA_S4CR_HTIE_Msk   = 0x8       // Bit mask of HTIE field.
	DMA_S4CR_HTIE       = 0x8       // Bit HTIE.
	DMA_S4CR_TEIE_Pos   = 0x2       // Position of TEIE field.
	DMA_S4CR_TEIE_Msk   = 0x4       // Bit mask of TEIE field.
	DMA_S4CR_TEIE       = 0x4       // Bit TEIE.
	DMA_S4CR_DMEIE_Pos  = 0x1       // Position of DMEIE field.
	DMA_S4CR_DMEIE_Msk  = 0x2       // Bit mask of DMEIE field.
	DMA_S4CR_DMEIE      = 0x2       // Bit DMEIE.
	DMA_S4CR_EN_Pos     = 0x0       // Position of EN field.
	DMA_S4CR_EN_Msk     = 0x1       // Bit mask of EN field.
	DMA_S4CR_EN         = 0x1       // Bit EN.

	// S4NDTR: stream x number of data           register
	DMA_S4NDTR_NDT_Pos = 0x0    // Position of NDT field.
	DMA_S4NDTR_NDT_Msk = 0xffff // Bit mask of NDT field.

	// S4PAR: stream x peripheral address           register
	DMA_S4PAR_PA_Pos = 0x0        // Position of PA field.
	DMA_S4PAR_PA_Msk = 0xffffffff // Bit mask of PA field.

	// S4M0AR: stream x memory 0 address           register
	DMA_S4M0AR_M0A_Pos = 0x0        // Position of M0A field.
	DMA_S4M0AR_M0A_Msk = 0xffffffff // Bit mask of M0A field.

	// S4M1AR: stream x memory 1 address           register
	DMA_S4M1AR_M1A_Pos = 0x0        // Position of M1A field.
	DMA_S4M1AR_M1A_Msk = 0xffffffff // Bit mask of M1A field.

	// S4FCR: stream x FIFO control register
	DMA_S4FCR_FEIE_Pos  = 0x7  // Position of FEIE field.
	DMA_S4FCR_FEIE_Msk  = 0x80 // Bit mask of FEIE field.
	DMA_S4FCR_FEIE      = 0x80 // Bit FEIE.
	DMA_S4FCR_FS_Pos    = 0x3  // Position of FS field.
	DMA_S4FCR_FS_Msk    = 0x38 // Bit mask of FS field.
	DMA_S4FCR_DMDIS_Pos = 0x2  // Position of DMDIS field.
	DMA_S4FCR_DMDIS_Msk = 0x4  // Bit mask of DMDIS field.
	DMA_S4FCR_DMDIS     = 0x4  // Bit DMDIS.
	DMA_S4FCR_FTH_Pos   = 0x0  // Position of FTH field.
	DMA_S4FCR_FTH_Msk   = 0x3  // Bit mask of FTH field.

	// S5CR: stream x configuration           register
	DMA_S5CR_CHSEL_Pos  = 0x19      // Position of CHSEL field.
	DMA_S5CR_CHSEL_Msk  = 0xe000000 // Bit mask of CHSEL field.
	DMA_S5CR_MBURST_Pos = 0x17      // Position of MBURST field.
	DMA_S5CR_MBURST_Msk = 0x1800000 // Bit mask of MBURST field.
	DMA_S5CR_PBURST_Pos = 0x15      // Position of PBURST field.
	DMA_S5CR_PBURST_Msk = 0x600000  // Bit mask of PBURST field.
	DMA_S5CR_ACK_Pos    = 0x14      // Position of ACK field.
	DMA_S5CR_ACK_Msk    = 0x100000  // Bit mask of ACK field.
	DMA_S5CR_ACK        = 0x100000  // Bit ACK.
	DMA_S5CR_CT_Pos     = 0x13      // Position of CT field.
	DMA_S5CR_CT_Msk     = 0x80000   // Bit mask of CT field.
	DMA_S5CR_CT         = 0x80000   // Bit CT.
	DMA_S5CR_DBM_Pos    = 0x12      // Position of DBM field.
	DMA_S5CR_DBM_Msk    = 0x40000   // Bit mask of DBM field.
	DMA_S5CR_DBM        = 0x40000   // Bit DBM.
	DMA_S5CR_PL_Pos     = 0x10      // Position of PL field.
	DMA_S5CR_PL_Msk     = 0x30000   // Bit mask of PL field.
	DMA_S5CR_PINCOS_Pos = 0xf       // Position of PINCOS field.
	DMA_S5CR_PINCOS_Msk = 0x8000    // Bit mask of PINCOS field.
	DMA_S5CR_PINCOS     = 0x8000    // Bit PINCOS.
	DMA_S5CR_MSIZE_Pos  = 0xd       // Position of MSIZE field.
	DMA_S5CR_MSIZE_Msk  = 0x6000    // Bit mask of MSIZE field.
	DMA_S5CR_PSIZE_Pos  = 0xb       // Position of PSIZE field.
	DMA_S5CR_PSIZE_Msk  = 0x1800    // Bit mask of PSIZE field.
	DMA_S5CR_MINC_Pos   = 0xa       // Position of MINC field.
	DMA_S5CR_MINC_Msk   = 0x400     // Bit mask of MINC field.
	DMA_S5CR_MINC       = 0x400     // Bit MINC.
	DMA_S5CR_PINC_Pos   = 0x9       // Position of PINC field.
	DMA_S5CR_PINC_Msk   = 0x200     // Bit mask of PINC field.
	DMA_S5CR_PINC       = 0x200     // Bit PINC.
	DMA_S5CR_CIRC_Pos   = 0x8       // Position of CIRC field.
	DMA_S5CR_CIRC_Msk   = 0x100     // Bit mask of CIRC field.
	DMA_S5CR_CIRC       = 0x100     // Bit CIRC.
	DMA_S5CR_DIR_Pos    = 0x6       // Position of DIR field.
	DMA_S5CR_DIR_Msk    = 0xc0      // Bit mask of DIR field.
	DMA_S5CR_PFCTRL_Pos = 0x5       // Position of PFCTRL field.
	DMA_S5CR_PFCTRL_Msk = 0x20      // Bit mask of PFCTRL field.
	DMA_S5CR_PFCTRL     = 0x20      // Bit PFCTRL.
	DMA_S5CR_TCIE_Pos   = 0x4       // Position of TCIE field.
	DMA_S5CR_TCIE_Msk   = 0x10      // Bit mask of TCIE field.
	DMA_S5CR_TCIE       = 0x10      // Bit TCIE.
	DMA_S5CR_HTIE_Pos   = 0x3       // Position of HTIE field.
	DMA_S5CR_HTIE_Msk   = 0x8       // Bit mask of HTIE field.
	DMA_S5CR_HTIE       = 0x8       // Bit HTIE.
	DMA_S5CR_TEIE_Pos   = 0x2       // Position of TEIE field.
	DMA_S5CR_TEIE_Msk   = 0x4       // Bit mask of TEIE field.
	DMA_S5CR_TEIE       = 0x4       // Bit TEIE.
	DMA_S5CR_DMEIE_Pos  = 0x1       // Position of DMEIE field.
	DMA_S5CR_DMEIE_Msk  = 0x2       // Bit mask of DMEIE field.
	DMA_S5CR_DMEIE      = 0x2       // Bit DMEIE.
	DMA_S5CR_EN_Pos     = 0x0       // Position of EN field.
	DMA_S5CR_EN_Msk     = 0x1       // Bit mask of EN field.
	DMA_S5CR_EN         = 0x1       // Bit EN.

	// S5NDTR: stream x number of data           register
	DMA_S5NDTR_NDT_Pos = 0x0    // Position of NDT field.
	DMA_S5NDTR_NDT_Msk = 0xffff // Bit mask of NDT field.

	// S5PAR: stream x peripheral address           register
	DMA_S5PAR_PA_Pos = 0x0        // Position of PA field.
	DMA_S5PAR_PA_Msk = 0xffffffff // Bit mask of PA field.

	// S5M0AR: stream x memory 0 address           register
	DMA_S5M0AR_M0A_Pos = 0x0        // Position of M0A field.
	DMA_S5M0AR_M0A_Msk = 0xffffffff // Bit mask of M0A field.

	// S5M1AR: stream x memory 1 address           register
	DMA_S5M1AR_M1A_Pos = 0x0        // Position of M1A field.
	DMA_S5M1AR_M1A_Msk = 0xffffffff // Bit mask of M1A field.

	// S5FCR: stream x FIFO control register
	DMA_S5FCR_FEIE_Pos  = 0x7  // Position of FEIE field.
	DMA_S5FCR_FEIE_Msk  = 0x80 // Bit mask of FEIE field.
	DMA_S5FCR_FEIE      = 0x80 // Bit FEIE.
	DMA_S5FCR_FS_Pos    = 0x3  // Position of FS field.
	DMA_S5FCR_FS_Msk    = 0x38 // Bit mask of FS field.
	DMA_S5FCR_DMDIS_Pos = 0x2  // Position of DMDIS field.
	DMA_S5FCR_DMDIS_Msk = 0x4  // Bit mask of DMDIS field.
	DMA_S5FCR_DMDIS     = 0x4  // Bit DMDIS.
	DMA_S5FCR_FTH_Pos   = 0x0  // Position of FTH field.
	DMA_S5FCR_FTH_Msk   = 0x3  // Bit mask of FTH field.

	// S6CR: stream x configuration           register
	DMA_S6CR_CHSEL_Pos  = 0x19      // Position of CHSEL field.
	DMA_S6CR_CHSEL_Msk  = 0xe000000 // Bit mask of CHSEL field.
	DMA_S6CR_MBURST_Pos = 0x17      // Position of MBURST field.
	DMA_S6CR_MBURST_Msk = 0x1800000 // Bit mask of MBURST field.
	DMA_S6CR_PBURST_Pos = 0x15      // Position of PBURST field.
	DMA_S6CR_PBURST_Msk = 0x600000  // Bit mask of PBURST field.
	DMA_S6CR_ACK_Pos    = 0x14      // Position of ACK field.
	DMA_S6CR_ACK_Msk    = 0x100000  // Bit mask of ACK field.
	DMA_S6CR_ACK        = 0x100000  // Bit ACK.
	DMA_S6CR_CT_Pos     = 0x13      // Position of CT field.
	DMA_S6CR_CT_Msk     = 0x80000   // Bit mask of CT field.
	DMA_S6CR_CT         = 0x80000   // Bit CT.
	DMA_S6CR_DBM_Pos    = 0x12      // Position of DBM field.
	DMA_S6CR_DBM_Msk    = 0x40000   // Bit mask of DBM field.
	DMA_S6CR_DBM        = 0x40000   // Bit DBM.
	DMA_S6CR_PL_Pos     = 0x10      // Position of PL field.
	DMA_S6CR_PL_Msk     = 0x30000   // Bit mask of PL field.
	DMA_S6CR_PINCOS_Pos = 0xf       // Position of PINCOS field.
	DMA_S6CR_PINCOS_Msk = 0x8000    // Bit mask of PINCOS field.
	DMA_S6CR_PINCOS     = 0x8000    // Bit PINCOS.
	DMA_S6CR_MSIZE_Pos  = 0xd       // Position of MSIZE field.
	DMA_S6CR_MSIZE_Msk  = 0x6000    // Bit mask of MSIZE field.
	DMA_S6CR_PSIZE_Pos  = 0xb       // Position of PSIZE field.
	DMA_S6CR_PSIZE_Msk  = 0x1800    // Bit mask of PSIZE field.
	DMA_S6CR_MINC_Pos   = 0xa       // Position of MINC field.
	DMA_S6CR_MINC_Msk   = 0x400     // Bit mask of MINC field.
	DMA_S6CR_MINC       = 0x400     // Bit MINC.
	DMA_S6CR_PINC_Pos   = 0x9       // Position of PINC field.
	DMA_S6CR_PINC_Msk   = 0x200     // Bit mask of PINC field.
	DMA_S6CR_PINC       = 0x200     // Bit PINC.
	DMA_S6CR_CIRC_Pos   = 0x8       // Position of CIRC field.
	DMA_S6CR_CIRC_Msk   = 0x100     // Bit mask of CIRC field.
	DMA_S6CR_CIRC       = 0x100     // Bit CIRC.
	DMA_S6CR_DIR_Pos    = 0x6       // Position of DIR field.
	DMA_S6CR_DIR_Msk    = 0xc0      // Bit mask of DIR field.
	DMA_S6CR_PFCTRL_Pos = 0x5       // Position of PFCTRL field.
	DMA_S6CR_PFCTRL_Msk = 0x20      // Bit mask of PFCTRL field.
	DMA_S6CR_PFCTRL     = 0x20      // Bit PFCTRL.
	DMA_S6CR_TCIE_Pos   = 0x4       // Position of TCIE field.
	DMA_S6CR_TCIE_Msk   = 0x10      // Bit mask of TCIE field.
	DMA_S6CR_TCIE       = 0x10      // Bit TCIE.
	DMA_S6CR_HTIE_Pos   = 0x3       // Position of HTIE field.
	DMA_S6CR_HTIE_Msk   = 0x8       // Bit mask of HTIE field.
	DMA_S6CR_HTIE       = 0x8       // Bit HTIE.
	DMA_S6CR_TEIE_Pos   = 0x2       // Position of TEIE field.
	DMA_S6CR_TEIE_Msk   = 0x4       // Bit mask of TEIE field.
	DMA_S6CR_TEIE       = 0x4       // Bit TEIE.
	DMA_S6CR_DMEIE_Pos  = 0x1       // Position of DMEIE field.
	DMA_S6CR_DMEIE_Msk  = 0x2       // Bit mask of DMEIE field.
	DMA_S6CR_DMEIE      = 0x2       // Bit DMEIE.
	DMA_S6CR_EN_Pos     = 0x0       // Position of EN field.
	DMA_S6CR_EN_Msk     = 0x1       // Bit mask of EN field.
	DMA_S6CR_EN         = 0x1       // Bit EN.

	// S6NDTR: stream x number of data           register
	DMA_S6NDTR_NDT_Pos = 0x0    // Position of NDT field.
	DMA_S6NDTR_NDT_Msk = 0xffff // Bit mask of NDT field.

	// S6PAR: stream x peripheral address           register
	DMA_S6PAR_PA_Pos = 0x0        // Position of PA field.
	DMA_S6PAR_PA_Msk = 0xffffffff // Bit mask of PA field.

	// S6M0AR: stream x memory 0 address           register
	DMA_S6M0AR_M0A_Pos = 0x0        // Position of M0A field.
	DMA_S6M0AR_M0A_Msk = 0xffffffff // Bit mask of M0A field.

	// S6M1AR: stream x memory 1 address           register
	DMA_S6M1AR_M1A_Pos = 0x0        // Position of M1A field.
	DMA_S6M1AR_M1A_Msk = 0xffffffff // Bit mask of M1A field.

	// S6FCR: stream x FIFO control register
	DMA_S6FCR_FEIE_Pos  = 0x7  // Position of FEIE field.
	DMA_S6FCR_FEIE_Msk  = 0x80 // Bit mask of FEIE field.
	DMA_S6FCR_FEIE      = 0x80 // Bit FEIE.
	DMA_S6FCR_FS_Pos    = 0x3  // Position of FS field.
	DMA_S6FCR_FS_Msk    = 0x38 // Bit mask of FS field.
	DMA_S6FCR_DMDIS_Pos = 0x2  // Position of DMDIS field.
	DMA_S6FCR_DMDIS_Msk = 0x4  // Bit mask of DMDIS field.
	DMA_S6FCR_DMDIS     = 0x4  // Bit DMDIS.
	DMA_S6FCR_FTH_Pos   = 0x0  // Position of FTH field.
	DMA_S6FCR_FTH_Msk   = 0x3  // Bit mask of FTH field.

	// S7CR: stream x configuration           register
	DMA_S7CR_CHSEL_Pos  = 0x19      // Position of CHSEL field.
	DMA_S7CR_CHSEL_Msk  = 0xe000000 // Bit mask of CHSEL field.
	DMA_S7CR_MBURST_Pos = 0x17      // Position of MBURST field.
	DMA_S7CR_MBURST_Msk = 0x1800000 // Bit mask of MBURST field.
	DMA_S7CR_PBURST_Pos = 0x15      // Position of PBURST field.
	DMA_S7CR_PBURST_Msk = 0x600000  // Bit mask of PBURST field.
	DMA_S7CR_ACK_Pos    = 0x14      // Position of ACK field.
	DMA_S7CR_ACK_Msk    = 0x100000  // Bit mask of ACK field.
	DMA_S7CR_ACK        = 0x100000  // Bit ACK.
	DMA_S7CR_CT_Pos     = 0x13      // Position of CT field.
	DMA_S7CR_CT_Msk     = 0x80000   // Bit mask of CT field.
	DMA_S7CR_CT         = 0x80000   // Bit CT.
	DMA_S7CR_DBM_Pos    = 0x12      // Position of DBM field.
	DMA_S7CR_DBM_Msk    = 0x40000   // Bit mask of DBM field.
	DMA_S7CR_DBM        = 0x40000   // Bit DBM.
	DMA_S7CR_PL_Pos     = 0x10      // Position of PL field.
	DMA_S7CR_PL_Msk     = 0x30000   // Bit mask of PL field.
	DMA_S7CR_PINCOS_Pos = 0xf       // Position of PINCOS field.
	DMA_S7CR_PINCOS_Msk = 0x8000    // Bit mask of PINCOS field.
	DMA_S7CR_PINCOS     = 0x8000    // Bit PINCOS.
	DMA_S7CR_MSIZE_Pos  = 0xd       // Position of MSIZE field.
	DMA_S7CR_MSIZE_Msk  = 0x6000    // Bit mask of MSIZE field.
	DMA_S7CR_PSIZE_Pos  = 0xb       // Position of PSIZE field.
	DMA_S7CR_PSIZE_Msk  = 0x1800    // Bit mask of PSIZE field.
	DMA_S7CR_MINC_Pos   = 0xa       // Position of MINC field.
	DMA_S7CR_MINC_Msk   = 0x400     // Bit mask of MINC field.
	DMA_S7CR_MINC       = 0x400     // Bit MINC.
	DMA_S7CR_PINC_Pos   = 0x9       // Position of PINC field.
	DMA_S7CR_PINC_Msk   = 0x200     // Bit mask of PINC field.
	DMA_S7CR_PINC       = 0x200     // Bit PINC.
	DMA_S7CR_CIRC_Pos   = 0x8       // Position of CIRC field.
	DMA_S7CR_CIRC_Msk   = 0x100     // Bit mask of CIRC field.
	DMA_S7CR_CIRC       = 0x100     // Bit CIRC.
	DMA_S7CR_DIR_Pos    = 0x6       // Position of DIR field.
	DMA_S7CR_DIR_Msk    = 0xc0      // Bit mask of DIR field.
	DMA_S7CR_PFCTRL_Pos = 0x5       // Position of PFCTRL field.
	DMA_S7CR_PFCTRL_Msk = 0x20      // Bit mask of PFCTRL field.
	DMA_S7CR_PFCTRL     = 0x20      // Bit PFCTRL.
	DMA_S7CR_TCIE_Pos   = 0x4       // Position of TCIE field.
	DMA_S7CR_TCIE_Msk   = 0x10      // Bit mask of TCIE field.
	DMA_S7CR_TCIE       = 0x10      // Bit TCIE.
	DMA_S7CR_HTIE_Pos   = 0x3       // Position of HTIE field.
	DMA_S7CR_HTIE_Msk   = 0x8       // Bit mask of HTIE field.
	DMA_S7CR_HTIE       = 0x8       // Bit HTIE.
	DMA_S7CR_TEIE_Pos   = 0x2       // Position of TEIE field.
	DMA_S7CR_TEIE_Msk   = 0x4       // Bit mask of TEIE field.
	DMA_S7CR_TEIE       = 0x4       // Bit TEIE.
	DMA_S7CR_DMEIE_Pos  = 0x1       // Position of DMEIE field.
	DMA_S7CR_DMEIE_Msk  = 0x2       // Bit mask of DMEIE field.
	DMA_S7CR_DMEIE      = 0x2       // Bit DMEIE.
	DMA_S7CR_EN_Pos     = 0x0       // Position of EN field.
	DMA_S7CR_EN_Msk     = 0x1       // Bit mask of EN field.
	DMA_S7CR_EN         = 0x1       // Bit EN.

	// S7NDTR: stream x number of data           register
	DMA_S7NDTR_NDT_Pos = 0x0    // Position of NDT field.
	DMA_S7NDTR_NDT_Msk = 0xffff // Bit mask of NDT field.

	// S7PAR: stream x peripheral address           register
	DMA_S7PAR_PA_Pos = 0x0        // Position of PA field.
	DMA_S7PAR_PA_Msk = 0xffffffff // Bit mask of PA field.

	// S7M0AR: stream x memory 0 address           register
	DMA_S7M0AR_M0A_Pos = 0x0        // Position of M0A field.
	DMA_S7M0AR_M0A_Msk = 0xffffffff // Bit mask of M0A field.

	// S7M1AR: stream x memory 1 address           register
	DMA_S7M1AR_M1A_Pos = 0x0        // Position of M1A field.
	DMA_S7M1AR_M1A_Msk = 0xffffffff // Bit mask of M1A field.

	// S7FCR: stream x FIFO control register
	DMA_S7FCR_FEIE_Pos  = 0x7  // Position of FEIE field.
	DMA_S7FCR_FEIE_Msk  = 0x80 // Bit mask of FEIE field.
	DMA_S7FCR_FEIE      = 0x80 // Bit FEIE.
	DMA_S7FCR_FS_Pos    = 0x3  // Position of FS field.
	DMA_S7FCR_FS_Msk    = 0x38 // Bit mask of FS field.
	DMA_S7FCR_DMDIS_Pos = 0x2  // Position of DMDIS field.
	DMA_S7FCR_DMDIS_Msk = 0x4  // Bit mask of DMDIS field.
	DMA_S7FCR_DMDIS     = 0x4  // Bit DMDIS.
	DMA_S7FCR_FTH_Pos   = 0x0  // Position of FTH field.
	DMA_S7FCR_FTH_Msk   = 0x3  // Bit mask of FTH field.
)

// Bitfields for GPIOH: General-purpose I/Os
const (
	// MODER: GPIO port mode register
	GPIO_MODER_MODER15_Pos = 0x1e       // Position of MODER15 field.
	GPIO_MODER_MODER15_Msk = 0xc0000000 // Bit mask of MODER15 field.
	GPIO_MODER_MODER14_Pos = 0x1c       // Position of MODER14 field.
	GPIO_MODER_MODER14_Msk = 0x30000000 // Bit mask of MODER14 field.
	GPIO_MODER_MODER13_Pos = 0x1a       // Position of MODER13 field.
	GPIO_MODER_MODER13_Msk = 0xc000000  // Bit mask of MODER13 field.
	GPIO_MODER_MODER12_Pos = 0x18       // Position of MODER12 field.
	GPIO_MODER_MODER12_Msk = 0x3000000  // Bit mask of MODER12 field.
	GPIO_MODER_MODER11_Pos = 0x16       // Position of MODER11 field.
	GPIO_MODER_MODER11_Msk = 0xc00000   // Bit mask of MODER11 field.
	GPIO_MODER_MODER10_Pos = 0x14       // Position of MODER10 field.
	GPIO_MODER_MODER10_Msk = 0x300000   // Bit mask of MODER10 field.
	GPIO_MODER_MODER9_Pos  = 0x12       // Position of MODER9 field.
	GPIO_MODER_MODER9_Msk  = 0xc0000    // Bit mask of MODER9 field.
	GPIO_MODER_MODER8_Pos  = 0x10       // Position of MODER8 field.
	GPIO_MODER_MODER8_Msk  = 0x30000    // Bit mask of MODER8 field.
	GPIO_MODER_MODER7_Pos  = 0xe        // Position of MODER7 field.
	GPIO_MODER_MODER7_Msk  = 0xc000     // Bit mask of MODER7 field.
	GPIO_MODER_MODER6_Pos  = 0xc        // Position of MODER6 field.
	GPIO_MODER_MODER6_Msk  = 0x3000     // Bit mask of MODER6 field.
	GPIO_MODER_MODER5_Pos  = 0xa        // Position of MODER5 field.
	GPIO_MODER_MODER5_Msk  = 0xc00      // Bit mask of MODER5 field.
	GPIO_MODER_MODER4_Pos  = 0x8        // Position of MODER4 field.
	GPIO_MODER_MODER4_Msk  = 0x300      // Bit mask of MODER4 field.
	GPIO_MODER_MODER3_Pos  = 0x6        // Position of MODER3 field.
	GPIO_MODER_MODER3_Msk  = 0xc0       // Bit mask of MODER3 field.
	GPIO_MODER_MODER2_Pos  = 0x4        // Position of MODER2 field.
	GPIO_MODER_MODER2_Msk  = 0x30       // Bit mask of MODER2 field.
	GPIO_MODER_MODER1_Pos  = 0x2        // Position of MODER1 field.
	GPIO_MODER_MODER1_Msk  = 0xc        // Bit mask of MODER1 field.
	GPIO_MODER_MODER0_Pos  = 0x0        // Position of MODER0 field.
	GPIO_MODER_MODER0_Msk  = 0x3        // Bit mask of MODER0 field.

	// OTYPER: GPIO port output type register
	GPIO_OTYPER_OT15_Pos = 0xf    // Position of OT15 field.
	GPIO_OTYPER_OT15_Msk = 0x8000 // Bit mask of OT15 field.
	GPIO_OTYPER_OT15     = 0x8000 // Bit OT15.
	GPIO_OTYPER_OT14_Pos = 0xe    // Position of OT14 field.
	GPIO_OTYPER_OT14_Msk = 0x4000 // Bit mask of OT14 field.
	GPIO_OTYPER_OT14     = 0x4000 // Bit OT14.
	GPIO_OTYPER_OT13_Pos = 0xd    // Position of OT13 field.
	GPIO_OTYPER_OT13_Msk = 0x2000 // Bit mask of OT13 field.
	GPIO_OTYPER_OT13     = 0x2000 // Bit OT13.
	GPIO_OTYPER_OT12_Pos = 0xc    // Position of OT12 field.
	GPIO_OTYPER_OT12_Msk = 0x1000 // Bit mask of OT12 field.
	GPIO_OTYPER_OT12     = 0x1000 // Bit OT12.
	GPIO_OTYPER_OT11_Pos = 0xb    // Position of OT11 field.
	GPIO_OTYPER_OT11_Msk = 0x800  // Bit mask of OT11 field.
	GPIO_OTYPER_OT11     = 0x800  // Bit OT11.
	GPIO_OTYPER_OT10_Pos = 0xa    // Position of OT10 field.
	GPIO_OTYPER_OT10_Msk = 0x400  // Bit mask of OT10 field.
	GPIO_OTYPER_OT10     = 0x400  // Bit OT10.
	GPIO_OTYPER_OT9_Pos  = 0x9    // Position of OT9 field.
	GPIO_OTYPER_OT9_Msk  = 0x200  // Bit mask of OT9 field.
	GPIO_OTYPER_OT9      = 0x200  // Bit OT9.
	GPIO_OTYPER_OT8_Pos  = 0x8    // Position of OT8 field.
	GPIO_OTYPER_OT8_Msk  = 0x100  // Bit mask of OT8 field.
	GPIO_OTYPER_OT8      = 0x100  // Bit OT8.
	GPIO_OTYPER_OT7_Pos  = 0x7    // Position of OT7 field.
	GPIO_OTYPER_OT7_Msk  = 0x80   // Bit mask of OT7 field.
	GPIO_OTYPER_OT7      = 0x80   // Bit OT7.
	GPIO_OTYPER_OT6_Pos  = 0x6    // Position of OT6 field.
	GPIO_OTYPER_OT6_Msk  = 0x40   // Bit mask of OT6 field.
	GPIO_OTYPER_OT6      = 0x40   // Bit OT6.
	GPIO_OTYPER_OT5_Pos  = 0x5    // Position of OT5 field.
	GPIO_OTYPER_OT5_Msk  = 0x20   // Bit mask of OT5 field.
	GPIO_OTYPER_OT5      = 0x20   // Bit OT5.
	GPIO_OTYPER_OT4_Pos  = 0x4    // Position of OT4 field.
	GPIO_OTYPER_OT4_Msk  = 0x10   // Bit mask of OT4 field.
	GPIO_OTYPER_OT4      = 0x10   // Bit OT4.
	GPIO_OTYPER_OT3_Pos  = 0x3    // Position of OT3 field.
	GPIO_OTYPER_OT3_Msk  = 0x8    // Bit mask of OT3 field.
	GPIO_OTYPER_OT3      = 0x8    // Bit OT3.
	GPIO_OTYPER_OT2_Pos  = 0x2    // Position of OT2 field.
	GPIO_OTYPER_OT2_Msk  = 0x4    // Bit mask of OT2 field.
	GPIO_OTYPER_OT2      = 0x4    // Bit OT2.
	GPIO_OTYPER_OT1_Pos  = 0x1    // Position of OT1 field.
	GPIO_OTYPER_OT1_Msk  = 0x2    // Bit mask of OT1 field.
	GPIO_OTYPER_OT1      = 0x2    // Bit OT1.
	GPIO_OTYPER_OT0_Pos  = 0x0    // Position of OT0 field.
	GPIO_OTYPER_OT0_Msk  = 0x1    // Bit mask of OT0 field.
	GPIO_OTYPER_OT0      = 0x1    // Bit OT0.

	// OSPEEDR: GPIO port output speed           register
	GPIO_OSPEEDR_OSPEEDR15_Pos = 0x1e       // Position of OSPEEDR15 field.
	GPIO_OSPEEDR_OSPEEDR15_Msk = 0xc0000000 // Bit mask of OSPEEDR15 field.
	GPIO_OSPEEDR_OSPEEDR14_Pos = 0x1c       // Position of OSPEEDR14 field.
	GPIO_OSPEEDR_OSPEEDR14_Msk = 0x30000000 // Bit mask of OSPEEDR14 field.
	GPIO_OSPEEDR_OSPEEDR13_Pos = 0x1a       // Position of OSPEEDR13 field.
	GPIO_OSPEEDR_OSPEEDR13_Msk = 0xc000000  // Bit mask of OSPEEDR13 field.
	GPIO_OSPEEDR_OSPEEDR12_Pos = 0x18       // Position of OSPEEDR12 field.
	GPIO_OSPEEDR_OSPEEDR12_Msk = 0x3000000  // Bit mask of OSPEEDR12 field.
	GPIO_OSPEEDR_OSPEEDR11_Pos = 0x16       // Position of OSPEEDR11 field.
	GPIO_OSPEEDR_OSPEEDR11_Msk = 0xc00000   // Bit mask of OSPEEDR11 field.
	GPIO_OSPEEDR_OSPEEDR10_Pos = 0x14       // Position of OSPEEDR10 field.
	GPIO_OSPEEDR_OSPEEDR10_Msk = 0x300000   // Bit mask of OSPEEDR10 field.
	GPIO_OSPEEDR_OSPEEDR9_Pos  = 0x12       // Position of OSPEEDR9 field.
	GPIO_OSPEEDR_OSPEEDR9_Msk  = 0xc0000    // Bit mask of OSPEEDR9 field.
	GPIO_OSPEEDR_OSPEEDR8_Pos  = 0x10       // Position of OSPEEDR8 field.
	GPIO_OSPEEDR_OSPEEDR8_Msk  = 0x30000    // Bit mask of OSPEEDR8 field.
	GPIO_OSPEEDR_OSPEEDR7_Pos  = 0xe        // Position of OSPEEDR7 field.
	GPIO_OSPEEDR_OSPEEDR7_Msk  = 0xc000     // Bit mask of OSPEEDR7 field.
	GPIO_OSPEEDR_OSPEEDR6_Pos  = 0xc        // Position of OSPEEDR6 field.
	GPIO_OSPEEDR_OSPEEDR6_Msk  = 0x3000     // Bit mask of OSPEEDR6 field.
	GPIO_OSPEEDR_OSPEEDR5_Pos  = 0xa        // Position of OSPEEDR5 field.
	GPIO_OSPEEDR_OSPEEDR5_Msk  = 0xc00      // Bit mask of OSPEEDR5 field.
	GPIO_OSPEEDR_OSPEEDR4_Pos  = 0x8        // Position of OSPEEDR4 field.
	GPIO_OSPEEDR_OSPEEDR4_Msk  = 0x300      // Bit mask of OSPEEDR4 field.
	GPIO_OSPEEDR_OSPEEDR3_Pos  = 0x6        // Position of OSPEEDR3 field.
	GPIO_OSPEEDR_OSPEEDR3_Msk  = 0xc0       // Bit mask of OSPEEDR3 field.
	GPIO_OSPEEDR_OSPEEDR2_Pos  = 0x4        // Position of OSPEEDR2 field.
	GPIO_OSPEEDR_OSPEEDR2_Msk  = 0x30       // Bit mask of OSPEEDR2 field.
	GPIO_OSPEEDR_OSPEEDR1_Pos  = 0x2        // Position of OSPEEDR1 field.
	GPIO_OSPEEDR_OSPEEDR1_Msk  = 0xc        // Bit mask of OSPEEDR1 field.
	GPIO_OSPEEDR_OSPEEDR0_Pos  = 0x0        // Position of OSPEEDR0 field.
	GPIO_OSPEEDR_OSPEEDR0_Msk  = 0x3        // Bit mask of OSPEEDR0 field.

	// PUPDR: GPIO port pull-up/pull-down           register
	GPIO_PUPDR_PUPDR15_Pos = 0x1e       // Position of PUPDR15 field.
	GPIO_PUPDR_PUPDR15_Msk = 0xc0000000 // Bit mask of PUPDR15 field.
	GPIO_PUPDR_PUPDR14_Pos = 0x1c       // Position of PUPDR14 field.
	GPIO_PUPDR_PUPDR14_Msk = 0x30000000 // Bit mask of PUPDR14 field.
	GPIO_PUPDR_PUPDR13_Pos = 0x1a       // Position of PUPDR13 field.
	GPIO_PUPDR_PUPDR13_Msk = 0xc000000  // Bit mask of PUPDR13 field.
	GPIO_PUPDR_PUPDR12_Pos = 0x18       // Position of PUPDR12 field.
	GPIO_PUPDR_PUPDR12_Msk = 0x3000000  // Bit mask of PUPDR12 field.
	GPIO_PUPDR_PUPDR11_Pos = 0x16       // Position of PUPDR11 field.
	GPIO_PUPDR_PUPDR11_Msk = 0xc00000   // Bit mask of PUPDR11 field.
	GPIO_PUPDR_PUPDR10_Pos = 0x14       // Position of PUPDR10 field.
	GPIO_PUPDR_PUPDR10_Msk = 0x300000   // Bit mask of PUPDR10 field.
	GPIO_PUPDR_PUPDR9_Pos  = 0x12       // Position of PUPDR9 field.
	GPIO_PUPDR_PUPDR9_Msk  = 0xc0000    // Bit mask of PUPDR9 field.
	GPIO_PUPDR_PUPDR8_Pos  = 0x10       // Position of PUPDR8 field.
	GPIO_PUPDR_PUPDR8_Msk  = 0x30000    // Bit mask of PUPDR8 field.
	GPIO_PUPDR_PUPDR7_Pos  = 0xe        // Position of PUPDR7 field.
	GPIO_PUPDR_PUPDR7_Msk  = 0xc000     // Bit mask of PUPDR7 field.
	GPIO_PUPDR_PUPDR6_Pos  = 0xc        // Position of PUPDR6 field.
	GPIO_PUPDR_PUPDR6_Msk  = 0x3000     // Bit mask of PUPDR6 field.
	GPIO_PUPDR_PUPDR5_Pos  = 0xa        // Position of PUPDR5 field.
	GPIO_PUPDR_PUPDR5_Msk  = 0xc00      // Bit mask of PUPDR5 field.
	GPIO_PUPDR_PUPDR4_Pos  = 0x8        // Position of PUPDR4 field.
	GPIO_PUPDR_PUPDR4_Msk  = 0x300      // Bit mask of PUPDR4 field.
	GPIO_PUPDR_PUPDR3_Pos  = 0x6        // Position of PUPDR3 field.
	GPIO_PUPDR_PUPDR3_Msk  = 0xc0       // Bit mask of PUPDR3 field.
	GPIO_PUPDR_PUPDR2_Pos  = 0x4        // Position of PUPDR2 field.
	GPIO_PUPDR_PUPDR2_Msk  = 0x30       // Bit mask of PUPDR2 field.
	GPIO_PUPDR_PUPDR1_Pos  = 0x2        // Position of PUPDR1 field.
	GPIO_PUPDR_PUPDR1_Msk  = 0xc        // Bit mask of PUPDR1 field.
	GPIO_PUPDR_PUPDR0_Pos  = 0x0        // Position of PUPDR0 field.
	GPIO_PUPDR_PUPDR0_Msk  = 0x3        // Bit mask of PUPDR0 field.

	// IDR: GPIO port input data register
	GPIO_IDR_IDR15_Pos = 0xf    // Position of IDR15 field.
	GPIO_IDR_IDR15_Msk = 0x8000 // Bit mask of IDR15 field.
	GPIO_IDR_IDR15     = 0x8000 // Bit IDR15.
	GPIO_IDR_IDR14_Pos = 0xe    // Position of IDR14 field.
	GPIO_IDR_IDR14_Msk = 0x4000 // Bit mask of IDR14 field.
	GPIO_IDR_IDR14     = 0x4000 // Bit IDR14.
	GPIO_IDR_IDR13_Pos = 0xd    // Position of IDR13 field.
	GPIO_IDR_IDR13_Msk = 0x2000 // Bit mask of IDR13 field.
	GPIO_IDR_IDR13     = 0x2000 // Bit IDR13.
	GPIO_IDR_IDR12_Pos = 0xc    // Position of IDR12 field.
	GPIO_IDR_IDR12_Msk = 0x1000 // Bit mask of IDR12 field.
	GPIO_IDR_IDR12     = 0x1000 // Bit IDR12.
	GPIO_IDR_IDR11_Pos = 0xb    // Position of IDR11 field.
	GPIO_IDR_IDR11_Msk = 0x800  // Bit mask of IDR11 field.
	GPIO_IDR_IDR11     = 0x800  // Bit IDR11.
	GPIO_IDR_IDR10_Pos = 0xa    // Position of IDR10 field.
	GPIO_IDR_IDR10_Msk = 0x400  // Bit mask of IDR10 field.
	GPIO_IDR_IDR10     = 0x400  // Bit IDR10.
	GPIO_IDR_IDR9_Pos  = 0x9    // Position of IDR9 field.
	GPIO_IDR_IDR9_Msk  = 0x200  // Bit mask of IDR9 field.
	GPIO_IDR_IDR9      = 0x200  // Bit IDR9.
	GPIO_IDR_IDR8_Pos  = 0x8    // Position of IDR8 field.
	GPIO_IDR_IDR8_Msk  = 0x100  // Bit mask of IDR8 field.
	GPIO_IDR_IDR8      = 0x100  // Bit IDR8.
	GPIO_IDR_IDR7_Pos  = 0x7    // Position of IDR7 field.
	GPIO_IDR_IDR7_Msk  = 0x80   // Bit mask of IDR7 field.
	GPIO_IDR_IDR7      = 0x80   // Bit IDR7.
	GPIO_IDR_IDR6_Pos  = 0x6    // Position of IDR6 field.
	GPIO_IDR_IDR6_Msk  = 0x40   // Bit mask of IDR6 field.
	GPIO_IDR_IDR6      = 0x40   // Bit IDR6.
	GPIO_IDR_IDR5_Pos  = 0x5    // Position of IDR5 field.
	GPIO_IDR_IDR5_Msk  = 0x20   // Bit mask of IDR5 field.
	GPIO_IDR_IDR5      = 0x20   // Bit IDR5.
	GPIO_IDR_IDR4_Pos  = 0x4    // Position of IDR4 field.
	GPIO_IDR_IDR4_Msk  = 0x10   // Bit mask of IDR4 field.
	GPIO_IDR_IDR4      = 0x10   // Bit IDR4.
	GPIO_IDR_IDR3_Pos  = 0x3    // Position of IDR3 field.
	GPIO_IDR_IDR3_Msk  = 0x8    // Bit mask of IDR3 field.
	GPIO_IDR_IDR3      = 0x8    // Bit IDR3.
	GPIO_IDR_IDR2_Pos  = 0x2    // Position of IDR2 field.
	GPIO_IDR_IDR2_Msk  = 0x4    // Bit mask of IDR2 field.
	GPIO_IDR_IDR2      = 0x4    // Bit IDR2.
	GPIO_IDR_IDR1_Pos  = 0x1    // Position of IDR1 field.
	GPIO_IDR_IDR1_Msk  = 0x2    // Bit mask of IDR1 field.
	GPIO_IDR_IDR1      = 0x2    // Bit IDR1.
	GPIO_IDR_IDR0_Pos  = 0x0    // Position of IDR0 field.
	GPIO_IDR_IDR0_Msk  = 0x1    // Bit mask of IDR0 field.
	GPIO_IDR_IDR0      = 0x1    // Bit IDR0.

	// ODR: GPIO port output data register
	GPIO_ODR_ODR15_Pos = 0xf    // Position of ODR15 field.
	GPIO_ODR_ODR15_Msk = 0x8000 // Bit mask of ODR15 field.
	GPIO_ODR_ODR15     = 0x8000 // Bit ODR15.
	GPIO_ODR_ODR14_Pos = 0xe    // Position of ODR14 field.
	GPIO_ODR_ODR14_Msk = 0x4000 // Bit mask of ODR14 field.
	GPIO_ODR_ODR14     = 0x4000 // Bit ODR14.
	GPIO_ODR_ODR13_Pos = 0xd    // Position of ODR13 field.
	GPIO_ODR_ODR13_Msk = 0x2000 // Bit mask of ODR13 field.
	GPIO_ODR_ODR13     = 0x2000 // Bit ODR13.
	GPIO_ODR_ODR12_Pos = 0xc    // Position of ODR12 field.
	GPIO_ODR_ODR12_Msk = 0x1000 // Bit mask of ODR12 field.
	GPIO_ODR_ODR12     = 0x1000 // Bit ODR12.
	GPIO_ODR_ODR11_Pos = 0xb    // Position of ODR11 field.
	GPIO_ODR_ODR11_Msk = 0x800  // Bit mask of ODR11 field.
	GPIO_ODR_ODR11     = 0x800  // Bit ODR11.
	GPIO_ODR_ODR10_Pos = 0xa    // Position of ODR10 field.
	GPIO_ODR_ODR10_Msk = 0x400  // Bit mask of ODR10 field.
	GPIO_ODR_ODR10     = 0x400  // Bit ODR10.
	GPIO_ODR_ODR9_Pos  = 0x9    // Position of ODR9 field.
	GPIO_ODR_ODR9_Msk  = 0x200  // Bit mask of ODR9 field.
	GPIO_ODR_ODR9      = 0x200  // Bit ODR9.
	GPIO_ODR_ODR8_Pos  = 0x8    // Position of ODR8 field.
	GPIO_ODR_ODR8_Msk  = 0x100  // Bit mask of ODR8 field.
	GPIO_ODR_ODR8      = 0x100  // Bit ODR8.
	GPIO_ODR_ODR7_Pos  = 0x7    // Position of ODR7 field.
	GPIO_ODR_ODR7_Msk  = 0x80   // Bit mask of ODR7 field.
	GPIO_ODR_ODR7      = 0x80   // Bit ODR7.
	GPIO_ODR_ODR6_Pos  = 0x6    // Position of ODR6 field.
	GPIO_ODR_ODR6_Msk  = 0x40   // Bit mask of ODR6 field.
	GPIO_ODR_ODR6      = 0x40   // Bit ODR6.
	GPIO_ODR_ODR5_Pos  = 0x5    // Position of ODR5 field.
	GPIO_ODR_ODR5_Msk  = 0x20   // Bit mask of ODR5 field.
	GPIO_ODR_ODR5      = 0x20   // Bit ODR5.
	GPIO_ODR_ODR4_Pos  = 0x4    // Position of ODR4 field.
	GPIO_ODR_ODR4_Msk  = 0x10   // Bit mask of ODR4 field.
	GPIO_ODR_ODR4      = 0x10   // Bit ODR4.
	GPIO_ODR_ODR3_Pos  = 0x3    // Position of ODR3 field.
	GPIO_ODR_ODR3_Msk  = 0x8    // Bit mask of ODR3 field.
	GPIO_ODR_ODR3      = 0x8    // Bit ODR3.
	GPIO_ODR_ODR2_Pos  = 0x2    // Position of ODR2 field.
	GPIO_ODR_ODR2_Msk  = 0x4    // Bit mask of ODR2 field.
	GPIO_ODR_ODR2      = 0x4    // Bit ODR2.
	GPIO_ODR_ODR1_Pos  = 0x1    // Position of ODR1 field.
	GPIO_ODR_ODR1_Msk  = 0x2    // Bit mask of ODR1 field.
	GPIO_ODR_ODR1      = 0x2    // Bit ODR1.
	GPIO_ODR_ODR0_Pos  = 0x0    // Position of ODR0 field.
	GPIO_ODR_ODR0_Msk  = 0x1    // Bit mask of ODR0 field.
	GPIO_ODR_ODR0      = 0x1    // Bit ODR0.

	// BSRR: GPIO port bit set/reset           register
	GPIO_BSRR_BR15_Pos = 0x1f       // Position of BR15 field.
	GPIO_BSRR_BR15_Msk = 0x80000000 // Bit mask of BR15 field.
	GPIO_BSRR_BR15     = 0x80000000 // Bit BR15.
	GPIO_BSRR_BR14_Pos = 0x1e       // Position of BR14 field.
	GPIO_BSRR_BR14_Msk = 0x40000000 // Bit mask of BR14 field.
	GPIO_BSRR_BR14     = 0x40000000 // Bit BR14.
	GPIO_BSRR_BR13_Pos = 0x1d       // Position of BR13 field.
	GPIO_BSRR_BR13_Msk = 0x20000000 // Bit mask of BR13 field.
	GPIO_BSRR_BR13     = 0x20000000 // Bit BR13.
	GPIO_BSRR_BR12_Pos = 0x1c       // Position of BR12 field.
	GPIO_BSRR_BR12_Msk = 0x10000000 // Bit mask of BR12 field.
	GPIO_BSRR_BR12     = 0x10000000 // Bit BR12.
	GPIO_BSRR_BR11_Pos = 0x1b       // Position of BR11 field.
	GPIO_BSRR_BR11_Msk = 0x8000000  // Bit mask of BR11 field.
	GPIO_BSRR_BR11     = 0x8000000  // Bit BR11.
	GPIO_BSRR_BR10_Pos = 0x1a       // Position of BR10 field.
	GPIO_BSRR_BR10_Msk = 0x4000000  // Bit mask of BR10 field.
	GPIO_BSRR_BR10     = 0x4000000  // Bit BR10.
	GPIO_BSRR_BR9_Pos  = 0x19       // Position of BR9 field.
	GPIO_BSRR_BR9_Msk  = 0x2000000  // Bit mask of BR9 field.
	GPIO_BSRR_BR9      = 0x2000000  // Bit BR9.
	GPIO_BSRR_BR8_Pos  = 0x18       // Position of BR8 field.
	GPIO_BSRR_BR8_Msk  = 0x1000000  // Bit mask of BR8 field.
	GPIO_BSRR_BR8      = 0x1000000  // Bit BR8.
	GPIO_BSRR_BR7_Pos  = 0x17       // Position of BR7 field.
	GPIO_BSRR_BR7_Msk  = 0x800000   // Bit mask of BR7 field.
	GPIO_BSRR_BR7      = 0x800000   // Bit BR7.
	GPIO_BSRR_BR6_Pos  = 0x16       // Position of BR6 field.
	GPIO_BSRR_BR6_Msk  = 0x400000   // Bit mask of BR6 field.
	GPIO_BSRR_BR6      = 0x400000   // Bit BR6.
	GPIO_BSRR_BR5_Pos  = 0x15       // Position of BR5 field.
	GPIO_BSRR_BR5_Msk  = 0x200000   // Bit mask of BR5 field.
	GPIO_BSRR_BR5      = 0x200000   // Bit BR5.
	GPIO_BSRR_BR4_Pos  = 0x14       // Position of BR4 field.
	GPIO_BSRR_BR4_Msk  = 0x100000   // Bit mask of BR4 field.
	GPIO_BSRR_BR4      = 0x100000   // Bit BR4.
	GPIO_BSRR_BR3_Pos  = 0x13       // Position of BR3 field.
	GPIO_BSRR_BR3_Msk  = 0x80000    // Bit mask of BR3 field.
	GPIO_BSRR_BR3      = 0x80000    // Bit BR3.
	GPIO_BSRR_BR2_Pos  = 0x12       // Position of BR2 field.
	GPIO_BSRR_BR2_Msk  = 0x40000    // Bit mask of BR2 field.
	GPIO_BSRR_BR2      = 0x40000    // Bit BR2.
	GPIO_BSRR_BR1_Pos  = 0x11       // Position of BR1 field.
	GPIO_BSRR_BR1_Msk  = 0x20000    // Bit mask of BR1 field.
	GPIO_BSRR_BR1      = 0x20000    // Bit BR1.
	GPIO_BSRR_BR0_Pos  = 0x10       // Position of BR0 field.
	GPIO_BSRR_BR0_Msk  = 0x10000    // Bit mask of BR0 field.
	GPIO_BSRR_BR0      = 0x10000    // Bit BR0.
	GPIO_BSRR_BS15_Pos = 0xf        // Position of BS15 field.
	GPIO_BSRR_BS15_Msk = 0x8000     // Bit mask of BS15 field.
	GPIO_BSRR_BS15     = 0x8000     // Bit BS15.
	GPIO_BSRR_BS14_Pos = 0xe        // Position of BS14 field.
	GPIO_BSRR_BS14_Msk = 0x4000     // Bit mask of BS14 field.
	GPIO_BSRR_BS14     = 0x4000     // Bit BS14.
	GPIO_BSRR_BS13_Pos = 0xd        // Position of BS13 field.
	GPIO_BSRR_BS13_Msk = 0x2000     // Bit mask of BS13 field.
	GPIO_BSRR_BS13     = 0x2000     // Bit BS13.
	GPIO_BSRR_BS12_Pos = 0xc        // Position of BS12 field.
	GPIO_BSRR_BS12_Msk = 0x1000     // Bit mask of BS12 field.
	GPIO_BSRR_BS12     = 0x1000     // Bit BS12.
	GPIO_BSRR_BS11_Pos = 0xb        // Position of BS11 field.
	GPIO_BSRR_BS11_Msk = 0x800      // Bit mask of BS11 field.
	GPIO_BSRR_BS11     = 0x800      // Bit BS11.
	GPIO_BSRR_BS10_Pos = 0xa        // Position of BS10 field.
	GPIO_BSRR_BS10_Msk = 0x400      // Bit mask of BS10 field.
	GPIO_BSRR_BS10     = 0x400      // Bit BS10.
	GPIO_BSRR_BS9_Pos  = 0x9        // Position of BS9 field.
	GPIO_BSRR_BS9_Msk  = 0x200      // Bit mask of BS9 field.
	GPIO_BSRR_BS9      = 0x200      // Bit BS9.
	GPIO_BSRR_BS8_Pos  = 0x8        // Position of BS8 field.
	GPIO_BSRR_BS8_Msk  = 0x100      // Bit mask of BS8 field.
	GPIO_BSRR_BS8      = 0x100      // Bit BS8.
	GPIO_BSRR_BS7_Pos  = 0x7        // Position of BS7 field.
	GPIO_BSRR_BS7_Msk  = 0x80       // Bit mask of BS7 field.
	GPIO_BSRR_BS7      = 0x80       // Bit BS7.
	GPIO_BSRR_BS6_Pos  = 0x6        // Position of BS6 field.
	GPIO_BSRR_BS6_Msk  = 0x40       // Bit mask of BS6 field.
	GPIO_BSRR_BS6      = 0x40       // Bit BS6.
	GPIO_BSRR_BS5_Pos  = 0x5        // Position of BS5 field.
	GPIO_BSRR_BS5_Msk  = 0x20       // Bit mask of BS5 field.
	GPIO_BSRR_BS5      = 0x20       // Bit BS5.
	GPIO_BSRR_BS4_Pos  = 0x4        // Position of BS4 field.
	GPIO_BSRR_BS4_Msk  = 0x10       // Bit mask of BS4 field.
	GPIO_BSRR_BS4      = 0x10       // Bit BS4.
	GPIO_BSRR_BS3_Pos  = 0x3        // Position of BS3 field.
	GPIO_BSRR_BS3_Msk  = 0x8        // Bit mask of BS3 field.
	GPIO_BSRR_BS3      = 0x8        // Bit BS3.
	GPIO_BSRR_BS2_Pos  = 0x2        // Position of BS2 field.
	GPIO_BSRR_BS2_Msk  = 0x4        // Bit mask of BS2 field.
	GPIO_BSRR_BS2      = 0x4        // Bit BS2.
	GPIO_BSRR_BS1_Pos  = 0x1        // Position of BS1 field.
	GPIO_BSRR_BS1_Msk  = 0x2        // Bit mask of BS1 field.
	GPIO_BSRR_BS1      = 0x2        // Bit BS1.
	GPIO_BSRR_BS0_Pos  = 0x0        // Position of BS0 field.
	GPIO_BSRR_BS0_Msk  = 0x1        // Bit mask of BS0 field.
	GPIO_BSRR_BS0      = 0x1        // Bit BS0.

	// LCKR: GPIO port configuration lock           register
	GPIO_LCKR_LCKK_Pos  = 0x10    // Position of LCKK field.
	GPIO_LCKR_LCKK_Msk  = 0x10000 // Bit mask of LCKK field.
	GPIO_LCKR_LCKK      = 0x10000 // Bit LCKK.
	GPIO_LCKR_LCK15_Pos = 0xf     // Position of LCK15 field.
	GPIO_LCKR_LCK15_Msk = 0x8000  // Bit mask of LCK15 field.
	GPIO_LCKR_LCK15     = 0x8000  // Bit LCK15.
	GPIO_LCKR_LCK14_Pos = 0xe     // Position of LCK14 field.
	GPIO_LCKR_LCK14_Msk = 0x4000  // Bit mask of LCK14 field.
	GPIO_LCKR_LCK14     = 0x4000  // Bit LCK14.
	GPIO_LCKR_LCK13_Pos = 0xd     // Position of LCK13 field.
	GPIO_LCKR_LCK13_Msk = 0x2000  // Bit mask of LCK13 field.
	GPIO_LCKR_LCK13     = 0x2000  // Bit LCK13.
	GPIO_LCKR_LCK12_Pos = 0xc     // Position of LCK12 field.
	GPIO_LCKR_LCK12_Msk = 0x1000  // Bit mask of LCK12 field.
	GPIO_LCKR_LCK12     = 0x1000  // Bit LCK12.
	GPIO_LCKR_LCK11_Pos = 0xb     // Position of LCK11 field.
	GPIO_LCKR_LCK11_Msk = 0x800   // Bit mask of LCK11 field.
	GPIO_LCKR_LCK11     = 0x800   // Bit LCK11.
	GPIO_LCKR_LCK10_Pos = 0xa     // Position of LCK10 field.
	GPIO_LCKR_LCK10_Msk = 0x400   // Bit mask of LCK10 field.
	GPIO_LCKR_LCK10     = 0x400   // Bit LCK10.
	GPIO_LCKR_LCK9_Pos  = 0x9     // Position of LCK9 field.
	GPIO_LCKR_LCK9_Msk  = 0x200   // Bit mask of LCK9 field.
	GPIO_LCKR_LCK9      = 0x200   // Bit LCK9.
	GPIO_LCKR_LCK8_Pos  = 0x8     // Position of LCK8 field.
	GPIO_LCKR_LCK8_Msk  = 0x100   // Bit mask of LCK8 field.
	GPIO_LCKR_LCK8      = 0x100   // Bit LCK8.
	GPIO_LCKR_LCK7_Pos  = 0x7     // Position of LCK7 field.
	GPIO_LCKR_LCK7_Msk  = 0x80    // Bit mask of LCK7 field.
	GPIO_LCKR_LCK7      = 0x80    // Bit LCK7.
	GPIO_LCKR_LCK6_Pos  = 0x6     // Position of LCK6 field.
	GPIO_LCKR_LCK6_Msk  = 0x40    // Bit mask of LCK6 field.
	GPIO_LCKR_LCK6      = 0x40    // Bit LCK6.
	GPIO_LCKR_LCK5_Pos  = 0x5     // Position of LCK5 field.
	GPIO_LCKR_LCK5_Msk  = 0x20    // Bit mask of LCK5 field.
	GPIO_LCKR_LCK5      = 0x20    // Bit LCK5.
	GPIO_LCKR_LCK4_Pos  = 0x4     // Position of LCK4 field.
	GPIO_LCKR_LCK4_Msk  = 0x10    // Bit mask of LCK4 field.
	GPIO_LCKR_LCK4      = 0x10    // Bit LCK4.
	GPIO_LCKR_LCK3_Pos  = 0x3     // Position of LCK3 field.
	GPIO_LCKR_LCK3_Msk  = 0x8     // Bit mask of LCK3 field.
	GPIO_LCKR_LCK3      = 0x8     // Bit LCK3.
	GPIO_LCKR_LCK2_Pos  = 0x2     // Position of LCK2 field.
	GPIO_LCKR_LCK2_Msk  = 0x4     // Bit mask of LCK2 field.
	GPIO_LCKR_LCK2      = 0x4     // Bit LCK2.
	GPIO_LCKR_LCK1_Pos  = 0x1     // Position of LCK1 field.
	GPIO_LCKR_LCK1_Msk  = 0x2     // Bit mask of LCK1 field.
	GPIO_LCKR_LCK1      = 0x2     // Bit LCK1.
	GPIO_LCKR_LCK0_Pos  = 0x0     // Position of LCK0 field.
	GPIO_LCKR_LCK0_Msk  = 0x1     // Bit mask of LCK0 field.
	GPIO_LCKR_LCK0      = 0x1     // Bit LCK0.

	// AFRL: GPIO alternate function low           register
	GPIO_AFRL_AFRL7_Pos = 0x1c       // Position of AFRL7 field.
	GPIO_AFRL_AFRL7_Msk = 0xf0000000 // Bit mask of AFRL7 field.
	GPIO_AFRL_AFRL6_Pos = 0x18       // Position of AFRL6 field.
	GPIO_AFRL_AFRL6_Msk = 0xf000000  // Bit mask of AFRL6 field.
	GPIO_AFRL_AFRL5_Pos = 0x14       // Position of AFRL5 field.
	GPIO_AFRL_AFRL5_Msk = 0xf00000   // Bit mask of AFRL5 field.
	GPIO_AFRL_AFRL4_Pos = 0x10       // Position of AFRL4 field.
	GPIO_AFRL_AFRL4_Msk = 0xf0000    // Bit mask of AFRL4 field.
	GPIO_AFRL_AFRL3_Pos = 0xc        // Position of AFRL3 field.
	GPIO_AFRL_AFRL3_Msk = 0xf000     // Bit mask of AFRL3 field.
	GPIO_AFRL_AFRL2_Pos = 0x8        // Position of AFRL2 field.
	GPIO_AFRL_AFRL2_Msk = 0xf00      // Bit mask of AFRL2 field.
	GPIO_AFRL_AFRL1_Pos = 0x4        // Position of AFRL1 field.
	GPIO_AFRL_AFRL1_Msk = 0xf0       // Bit mask of AFRL1 field.
	GPIO_AFRL_AFRL0_Pos = 0x0        // Position of AFRL0 field.
	GPIO_AFRL_AFRL0_Msk = 0xf        // Bit mask of AFRL0 field.

	// AFRH: GPIO alternate function high           register
	GPIO_AFRH_AFRH15_Pos = 0x1c       // Position of AFRH15 field.
	GPIO_AFRH_AFRH15_Msk = 0xf0000000 // Bit mask of AFRH15 field.
	GPIO_AFRH_AFRH14_Pos = 0x18       // Position of AFRH14 field.
	GPIO_AFRH_AFRH14_Msk = 0xf000000  // Bit mask of AFRH14 field.
	GPIO_AFRH_AFRH13_Pos = 0x14       // Position of AFRH13 field.
	GPIO_AFRH_AFRH13_Msk = 0xf00000   // Bit mask of AFRH13 field.
	GPIO_AFRH_AFRH12_Pos = 0x10       // Position of AFRH12 field.
	GPIO_AFRH_AFRH12_Msk = 0xf0000    // Bit mask of AFRH12 field.
	GPIO_AFRH_AFRH11_Pos = 0xc        // Position of AFRH11 field.
	GPIO_AFRH_AFRH11_Msk = 0xf000     // Bit mask of AFRH11 field.
	GPIO_AFRH_AFRH10_Pos = 0x8        // Position of AFRH10 field.
	GPIO_AFRH_AFRH10_Msk = 0xf00      // Bit mask of AFRH10 field.
	GPIO_AFRH_AFRH9_Pos  = 0x4        // Position of AFRH9 field.
	GPIO_AFRH_AFRH9_Msk  = 0xf0       // Bit mask of AFRH9 field.
	GPIO_AFRH_AFRH8_Pos  = 0x0        // Position of AFRH8 field.
	GPIO_AFRH_AFRH8_Msk  = 0xf        // Bit mask of AFRH8 field.
)

// Bitfields for I2C3: Inter-integrated circuit
const (
	// CR1: Control register 1
	I2C_CR1_SWRST_Pos     = 0xf    // Position of SWRST field.
	I2C_CR1_SWRST_Msk     = 0x8000 // Bit mask of SWRST field.
	I2C_CR1_SWRST         = 0x8000 // Bit SWRST.
	I2C_CR1_ALERT_Pos     = 0xd    // Position of ALERT field.
	I2C_CR1_ALERT_Msk     = 0x2000 // Bit mask of ALERT field.
	I2C_CR1_ALERT         = 0x2000 // Bit ALERT.
	I2C_CR1_PEC_Pos       = 0xc    // Position of PEC field.
	I2C_CR1_PEC_Msk       = 0x1000 // Bit mask of PEC field.
	I2C_CR1_PEC           = 0x1000 // Bit PEC.
	I2C_CR1_POS_Pos       = 0xb    // Position of POS field.
	I2C_CR1_POS_Msk       = 0x800  // Bit mask of POS field.
	I2C_CR1_POS           = 0x800  // Bit POS.
	I2C_CR1_ACK_Pos       = 0xa    // Position of ACK field.
	I2C_CR1_ACK_Msk       = 0x400  // Bit mask of ACK field.
	I2C_CR1_ACK           = 0x400  // Bit ACK.
	I2C_CR1_STOP_Pos      = 0x9    // Position of STOP field.
	I2C_CR1_STOP_Msk      = 0x200  // Bit mask of STOP field.
	I2C_CR1_STOP          = 0x200  // Bit STOP.
	I2C_CR1_START_Pos     = 0x8    // Position of START field.
	I2C_CR1_START_Msk     = 0x100  // Bit mask of START field.
	I2C_CR1_START         = 0x100  // Bit START.
	I2C_CR1_NOSTRETCH_Pos = 0x7    // Position of NOSTRETCH field.
	I2C_CR1_NOSTRETCH_Msk = 0x80   // Bit mask of NOSTRETCH field.
	I2C_CR1_NOSTRETCH     = 0x80   // Bit NOSTRETCH.
	I2C_CR1_ENGC_Pos      = 0x6    // Position of ENGC field.
	I2C_CR1_ENGC_Msk      = 0x40   // Bit mask of ENGC field.
	I2C_CR1_ENGC          = 0x40   // Bit ENGC.
	I2C_CR1_ENPEC_Pos     = 0x5    // Position of ENPEC field.
	I2C_CR1_ENPEC_Msk     = 0x20   // Bit mask of ENPEC field.
	I2C_CR1_ENPEC         = 0x20   // Bit ENPEC.
	I2C_CR1_ENARP_Pos     = 0x4    // Position of ENARP field.
	I2C_CR1_ENARP_Msk     = 0x10   // Bit mask of ENARP field.
	I2C_CR1_ENARP         = 0x10   // Bit ENARP.
	I2C_CR1_SMBTYPE_Pos   = 0x3    // Position of SMBTYPE field.
	I2C_CR1_SMBTYPE_Msk   = 0x8    // Bit mask of SMBTYPE field.
	I2C_CR1_SMBTYPE       = 0x8    // Bit SMBTYPE.
	I2C_CR1_SMBUS_Pos     = 0x1    // Position of SMBUS field.
	I2C_CR1_SMBUS_Msk     = 0x2    // Bit mask of SMBUS field.
	I2C_CR1_SMBUS         = 0x2    // Bit SMBUS.
	I2C_CR1_PE_Pos        = 0x0    // Position of PE field.
	I2C_CR1_PE_Msk        = 0x1    // Bit mask of PE field.
	I2C_CR1_PE            = 0x1    // Bit PE.

	// CR2: Control register 2
	I2C_CR2_LAST_Pos    = 0xc    // Position of LAST field.
	I2C_CR2_LAST_Msk    = 0x1000 // Bit mask of LAST field.
	I2C_CR2_LAST        = 0x1000 // Bit LAST.
	I2C_CR2_DMAEN_Pos   = 0xb    // Position of DMAEN field.
	I2C_CR2_DMAEN_Msk   = 0x800  // Bit mask of DMAEN field.
	I2C_CR2_DMAEN       = 0x800  // Bit DMAEN.
	I2C_CR2_ITBUFEN_Pos = 0xa    // Position of ITBUFEN field.
	I2C_CR2_ITBUFEN_Msk = 0x400  // Bit mask of ITBUFEN field.
	I2C_CR2_ITBUFEN     = 0x400  // Bit ITBUFEN.
	I2C_CR2_ITEVTEN_Pos = 0x9    // Position of ITEVTEN field.
	I2C_CR2_ITEVTEN_Msk = 0x200  // Bit mask of ITEVTEN field.
	I2C_CR2_ITEVTEN     = 0x200  // Bit ITEVTEN.
	I2C_CR2_ITERREN_Pos = 0x8    // Position of ITERREN field.
	I2C_CR2_ITERREN_Msk = 0x100  // Bit mask of ITERREN field.
	I2C_CR2_ITERREN     = 0x100  // Bit ITERREN.
	I2C_CR2_FREQ_Pos    = 0x0    // Position of FREQ field.
	I2C_CR2_FREQ_Msk    = 0x3f   // Bit mask of FREQ field.

	// OAR1: Own address register 1
	I2C_OAR1_ADDMODE_Pos = 0xf    // Position of ADDMODE field.
	I2C_OAR1_ADDMODE_Msk = 0x8000 // Bit mask of ADDMODE field.
	I2C_OAR1_ADDMODE     = 0x8000 // Bit ADDMODE.
	I2C_OAR1_ADD10_Pos   = 0x8    // Position of ADD10 field.
	I2C_OAR1_ADD10_Msk   = 0x300  // Bit mask of ADD10 field.
	I2C_OAR1_ADD7_Pos    = 0x1    // Position of ADD7 field.
	I2C_OAR1_ADD7_Msk    = 0xfe   // Bit mask of ADD7 field.
	I2C_OAR1_ADD0_Pos    = 0x0    // Position of ADD0 field.
	I2C_OAR1_ADD0_Msk    = 0x1    // Bit mask of ADD0 field.
	I2C_OAR1_ADD0        = 0x1    // Bit ADD0.

	// OAR2: Own address register 2
	I2C_OAR2_ADD2_Pos   = 0x1  // Position of ADD2 field.
	I2C_OAR2_ADD2_Msk   = 0xfe // Bit mask of ADD2 field.
	I2C_OAR2_ENDUAL_Pos = 0x0  // Position of ENDUAL field.
	I2C_OAR2_ENDUAL_Msk = 0x1  // Bit mask of ENDUAL field.
	I2C_OAR2_ENDUAL     = 0x1  // Bit ENDUAL.

	// DR: Data register
	I2C_DR_DR_Pos = 0x0  // Position of DR field.
	I2C_DR_DR_Msk = 0xff // Bit mask of DR field.

	// SR1: Status register 1
	I2C_SR1_SMBALERT_Pos = 0xf    // Position of SMBALERT field.
	I2C_SR1_SMBALERT_Msk = 0x8000 // Bit mask of SMBALERT field.
	I2C_SR1_SMBALERT     = 0x8000 // Bit SMBALERT.
	I2C_SR1_TIMEOUT_Pos  = 0xe    // Position of TIMEOUT field.
	I2C_SR1_TIMEOUT_Msk  = 0x4000 // Bit mask of TIMEOUT field.
	I2C_SR1_TIMEOUT      = 0x4000 // Bit TIMEOUT.
	I2C_SR1_PECERR_Pos   = 0xc    // Position of PECERR field.
	I2C_SR1_PECERR_Msk   = 0x1000 // Bit mask of PECERR field.
	I2C_SR1_PECERR       = 0x1000 // Bit PECERR.
	I2C_SR1_OVR_Pos      = 0xb    // Position of OVR field.
	I2C_SR1_OVR_Msk      = 0x800  // Bit mask of OVR field.
	I2C_SR1_OVR          = 0x800  // Bit OVR.
	I2C_SR1_AF_Pos       = 0xa    // Position of AF field.
	I2C_SR1_AF_Msk       = 0x400  // Bit mask of AF field.
	I2C_SR1_AF           = 0x400  // Bit AF.
	I2C_SR1_ARLO_Pos     = 0x9    // Position of ARLO field.
	I2C_SR1_ARLO_Msk     = 0x200  // Bit mask of ARLO field.
	I2C_SR1_ARLO         = 0x200  // Bit ARLO.
	I2C_SR1_BERR_Pos     = 0x8    // Position of BERR field.
	I2C_SR1_BERR_Msk     = 0x100  // Bit mask of BERR field.
	I2C_SR1_BERR         = 0x100  // Bit BERR.
	I2C_SR1_TxE_Pos      = 0x7    // Position of TxE field.
	I2C_SR1_TxE_Msk      = 0x80   // Bit mask of TxE field.
	I2C_SR1_TxE          = 0x80   // Bit TxE.
	I2C_SR1_RxNE_Pos     = 0x6    // Position of RxNE field.
	I2C_SR1_RxNE_Msk     = 0x40   // Bit mask of RxNE field.
	I2C_SR1_RxNE         = 0x40   // Bit RxNE.
	I2C_SR1_STOPF_Pos    = 0x4    // Position of STOPF field.
	I2C_SR1_STOPF_Msk    = 0x10   // Bit mask of STOPF field.
	I2C_SR1_STOPF        = 0x10   // Bit STOPF.
	I2C_SR1_ADD10_Pos    = 0x3    // Position of ADD10 field.
	I2C_SR1_ADD10_Msk    = 0x8    // Bit mask of ADD10 field.
	I2C_SR1_ADD10        = 0x8    // Bit ADD10.
	I2C_SR1_BTF_Pos      = 0x2    // Position of BTF field.
	I2C_SR1_BTF_Msk      = 0x4    // Bit mask of BTF field.
	I2C_SR1_BTF          = 0x4    // Bit BTF.
	I2C_SR1_ADDR_Pos     = 0x1    // Position of ADDR field.
	I2C_SR1_ADDR_Msk     = 0x2    // Bit mask of ADDR field.
	I2C_SR1_ADDR         = 0x2    // Bit ADDR.
	I2C_SR1_SB_Pos       = 0x0    // Position of SB field.
	I2C_SR1_SB_Msk       = 0x1    // Bit mask of SB field.
	I2C_SR1_SB           = 0x1    // Bit SB.

	// SR2: Status register 2
	I2C_SR2_PEC_Pos        = 0x8    // Position of PEC field.
	I2C_SR2_PEC_Msk        = 0xff00 // Bit mask of PEC field.
	I2C_SR2_DUALF_Pos      = 0x7    // Position of DUALF field.
	I2C_SR2_DUALF_Msk      = 0x80   // Bit mask of DUALF field.
	I2C_SR2_DUALF          = 0x80   // Bit DUALF.
	I2C_SR2_SMBHOST_Pos    = 0x6    // Position of SMBHOST field.
	I2C_SR2_SMBHOST_Msk    = 0x40   // Bit mask of SMBHOST field.
	I2C_SR2_SMBHOST        = 0x40   // Bit SMBHOST.
	I2C_SR2_SMBDEFAULT_Pos = 0x5    // Position of SMBDEFAULT field.
	I2C_SR2_SMBDEFAULT_Msk = 0x20   // Bit mask of SMBDEFAULT field.
	I2C_SR2_SMBDEFAULT     = 0x20   // Bit SMBDEFAULT.
	I2C_SR2_GENCALL_Pos    = 0x4    // Position of GENCALL field.
	I2C_SR2_GENCALL_Msk    = 0x10   // Bit mask of GENCALL field.
	I2C_SR2_GENCALL        = 0x10   // Bit GENCALL.
	I2C_SR2_TRA_Pos        = 0x2    // Position of TRA field.
	I2C_SR2_TRA_Msk        = 0x4    // Bit mask of TRA field.
	I2C_SR2_TRA            = 0x4    // Bit TRA.
	I2C_SR2_BUSY_Pos       = 0x1    // Position of BUSY field.
	I2C_SR2_BUSY_Msk       = 0x2    // Bit mask of BUSY field.
	I2C_SR2_BUSY           = 0x2    // Bit BUSY.
	I2C_SR2_MSL_Pos        = 0x0    // Position of MSL field.
	I2C_SR2_MSL_Msk        = 0x1    // Bit mask of MSL field.
	I2C_SR2_MSL            = 0x1    // Bit MSL.

	// CCR: Clock control register
	I2C_CCR_F_S_Pos  = 0xf    // Position of F_S field.
	I2C_CCR_F_S_Msk  = 0x8000 // Bit mask of F_S field.
	I2C_CCR_F_S      = 0x8000 // Bit F_S.
	I2C_CCR_DUTY_Pos = 0xe    // Position of DUTY field.
	I2C_CCR_DUTY_Msk = 0x4000 // Bit mask of DUTY field.
	I2C_CCR_DUTY     = 0x4000 // Bit DUTY.
	I2C_CCR_CCR_Pos  = 0x0    // Position of CCR field.
	I2C_CCR_CCR_Msk  = 0xfff  // Bit mask of CCR field.

	// TRISE: TRISE register
	I2C_TRISE_TRISE_Pos = 0x0  // Position of TRISE field.
	I2C_TRISE_TRISE_Msk = 0x3f // Bit mask of TRISE field.
)

// Bitfields for I2S2ext: Serial peripheral interface
const (
	// CR1: control register 1
	SPI_CR1_BIDIMODE_Pos = 0xf    // Position of BIDIMODE field.
	SPI_CR1_BIDIMODE_Msk = 0x8000 // Bit mask of BIDIMODE field.
	SPI_CR1_BIDIMODE     = 0x8000 // Bit BIDIMODE.
	SPI_CR1_BIDIOE_Pos   = 0xe    // Position of BIDIOE field.
	SPI_CR1_BIDIOE_Msk   = 0x4000 // Bit mask of BIDIOE field.
	SPI_CR1_BIDIOE       = 0x4000 // Bit BIDIOE.
	SPI_CR1_CRCEN_Pos    = 0xd    // Position of CRCEN field.
	SPI_CR1_CRCEN_Msk    = 0x2000 // Bit mask of CRCEN field.
	SPI_CR1_CRCEN        = 0x2000 // Bit CRCEN.
	SPI_CR1_CRCNEXT_Pos  = 0xc    // Position of CRCNEXT field.
	SPI_CR1_CRCNEXT_Msk  = 0x1000 // Bit mask of CRCNEXT field.
	SPI_CR1_CRCNEXT      = 0x1000 // Bit CRCNEXT.
	SPI_CR1_DFF_Pos      = 0xb    // Position of DFF field.
	SPI_CR1_DFF_Msk      = 0x800  // Bit mask of DFF field.
	SPI_CR1_DFF          = 0x800  // Bit DFF.
	SPI_CR1_RXONLY_Pos   = 0xa    // Position of RXONLY field.
	SPI_CR1_RXONLY_Msk   = 0x400  // Bit mask of RXONLY field.
	SPI_CR1_RXONLY       = 0x400  // Bit RXONLY.
	SPI_CR1_SSM_Pos      = 0x9    // Position of SSM field.
	SPI_CR1_SSM_Msk      = 0x200  // Bit mask of SSM field.
	SPI_CR1_SSM          = 0x200  // Bit SSM.
	SPI_CR1_SSI_Pos      = 0x8    // Position of SSI field.
	SPI_CR1_SSI_Msk      = 0x100  // Bit mask of SSI field.
	SPI_CR1_SSI          = 0x100  // Bit SSI.
	SPI_CR1_LSBFIRST_Pos = 0x7    // Position of LSBFIRST field.
	SPI_CR1_LSBFIRST_Msk = 0x80   // Bit mask of LSBFIRST field.
	SPI_CR1_LSBFIRST     = 0x80   // Bit LSBFIRST.
	SPI_CR1_SPE_Pos      = 0x6    // Position of SPE field.
	SPI_CR1_SPE_Msk      = 0x40   // Bit mask of SPE field.
	SPI_CR1_SPE          = 0x40   // Bit SPE.
	SPI_CR1_BR_Pos       = 0x3    // Position of BR field.
	SPI_CR1_BR_Msk       = 0x38   // Bit mask of BR field.
	SPI_CR1_MSTR_Pos     = 0x2    // Position of MSTR field.
	SPI_CR1_MSTR_Msk     = 0x4    // Bit mask of MSTR field.
	SPI_CR1_MSTR         = 0x4    // Bit MSTR.
	SPI_CR1_CPOL_Pos     = 0x1    // Position of CPOL field.
	SPI_CR1_CPOL_Msk     = 0x2    // Bit mask of CPOL field.
	SPI_CR1_CPOL         = 0x2    // Bit CPOL.
	SPI_CR1_CPHA_Pos     = 0x0    // Position of CPHA field.
	SPI_CR1_CPHA_Msk     = 0x1    // Bit mask of CPHA field.
	SPI_CR1_CPHA         = 0x1    // Bit CPHA.

	// CR2: control register 2
	SPI_CR2_TXEIE_Pos   = 0x7  // Position of TXEIE field.
	SPI_CR2_TXEIE_Msk   = 0x80 // Bit mask of TXEIE field.
	SPI_CR2_TXEIE       = 0x80 // Bit TXEIE.
	SPI_CR2_RXNEIE_Pos  = 0x6  // Position of RXNEIE field.
	SPI_CR2_RXNEIE_Msk  = 0x40 // Bit mask of RXNEIE field.
	SPI_CR2_RXNEIE      = 0x40 // Bit RXNEIE.
	SPI_CR2_ERRIE_Pos   = 0x5  // Position of ERRIE field.
	SPI_CR2_ERRIE_Msk   = 0x20 // Bit mask of ERRIE field.
	SPI_CR2_ERRIE       = 0x20 // Bit ERRIE.
	SPI_CR2_FRF_Pos     = 0x4  // Position of FRF field.
	SPI_CR2_FRF_Msk     = 0x10 // Bit mask of FRF field.
	SPI_CR2_FRF         = 0x10 // Bit FRF.
	SPI_CR2_SSOE_Pos    = 0x2  // Position of SSOE field.
	SPI_CR2_SSOE_Msk    = 0x4  // Bit mask of SSOE field.
	SPI_CR2_SSOE        = 0x4  // Bit SSOE.
	SPI_CR2_TXDMAEN_Pos = 0x1  // Position of TXDMAEN field.
	SPI_CR2_TXDMAEN_Msk = 0x2  // Bit mask of TXDMAEN field.
	SPI_CR2_TXDMAEN     = 0x2  // Bit TXDMAEN.
	SPI_CR2_RXDMAEN_Pos = 0x0  // Position of RXDMAEN field.
	SPI_CR2_RXDMAEN_Msk = 0x1  // Bit mask of RXDMAEN field.
	SPI_CR2_RXDMAEN     = 0x1  // Bit RXDMAEN.

	// SR: status register
	SPI_SR_TIFRFE_Pos = 0x8   // Position of TIFRFE field.
	SPI_SR_TIFRFE_Msk = 0x100 // Bit mask of TIFRFE field.
	SPI_SR_TIFRFE     = 0x100 // Bit TIFRFE.
	SPI_SR_BSY_Pos    = 0x7   // Position of BSY field.
	SPI_SR_BSY_Msk    = 0x80  // Bit mask of BSY field.
	SPI_SR_BSY        = 0x80  // Bit BSY.
	SPI_SR_OVR_Pos    = 0x6   // Position of OVR field.
	SPI_SR_OVR_Msk    = 0x40  // Bit mask of OVR field.
	SPI_SR_OVR        = 0x40  // Bit OVR.
	SPI_SR_MODF_Pos   = 0x5   // Position of MODF field.
	SPI_SR_MODF_Msk   = 0x20  // Bit mask of MODF field.
	SPI_SR_MODF       = 0x20  // Bit MODF.
	SPI_SR_CRCERR_Pos = 0x4   // Position of CRCERR field.
	SPI_SR_CRCERR_Msk = 0x10  // Bit mask of CRCERR field.
	SPI_SR_CRCERR     = 0x10  // Bit CRCERR.
	SPI_SR_UDR_Pos    = 0x3   // Position of UDR field.
	SPI_SR_UDR_Msk    = 0x8   // Bit mask of UDR field.
	SPI_SR_UDR        = 0x8   // Bit UDR.
	SPI_SR_CHSIDE_Pos = 0x2   // Position of CHSIDE field.
	SPI_SR_CHSIDE_Msk = 0x4   // Bit mask of CHSIDE field.
	SPI_SR_CHSIDE     = 0x4   // Bit CHSIDE.
	SPI_SR_TXE_Pos    = 0x1   // Position of TXE field.
	SPI_SR_TXE_Msk    = 0x2   // Bit mask of TXE field.
	SPI_SR_TXE        = 0x2   // Bit TXE.
	SPI_SR_RXNE_Pos   = 0x0   // Position of RXNE field.
	SPI_SR_RXNE_Msk   = 0x1   // Bit mask of RXNE field.
	SPI_SR_RXNE       = 0x1   // Bit RXNE.

	// DR: data register
	SPI_DR_DR_Pos = 0x0    // Position of DR field.
	SPI_DR_DR_Msk = 0xffff // Bit mask of DR field.

	// CRCPR: CRC polynomial register
	SPI_CRCPR_CRCPOLY_Pos = 0x0    // Position of CRCPOLY field.
	SPI_CRCPR_CRCPOLY_Msk = 0xffff // Bit mask of CRCPOLY field.

	// RXCRCR: RX CRC register
	SPI_RXCRCR_RxCRC_Pos = 0x0    // Position of RxCRC field.
	SPI_RXCRCR_RxCRC_Msk = 0xffff // Bit mask of RxCRC field.

	// TXCRCR: TX CRC register
	SPI_TXCRCR_TxCRC_Pos = 0x0    // Position of TxCRC field.
	SPI_TXCRCR_TxCRC_Msk = 0xffff // Bit mask of TxCRC field.

	// I2SCFGR: I2S configuration register
	SPI_I2SCFGR_I2SMOD_Pos  = 0xb   // Position of I2SMOD field.
	SPI_I2SCFGR_I2SMOD_Msk  = 0x800 // Bit mask of I2SMOD field.
	SPI_I2SCFGR_I2SMOD      = 0x800 // Bit I2SMOD.
	SPI_I2SCFGR_I2SE_Pos    = 0xa   // Position of I2SE field.
	SPI_I2SCFGR_I2SE_Msk    = 0x400 // Bit mask of I2SE field.
	SPI_I2SCFGR_I2SE        = 0x400 // Bit I2SE.
	SPI_I2SCFGR_I2SCFG_Pos  = 0x8   // Position of I2SCFG field.
	SPI_I2SCFGR_I2SCFG_Msk  = 0x300 // Bit mask of I2SCFG field.
	SPI_I2SCFGR_PCMSYNC_Pos = 0x7   // Position of PCMSYNC field.
	SPI_I2SCFGR_PCMSYNC_Msk = 0x80  // Bit mask of PCMSYNC field.
	SPI_I2SCFGR_PCMSYNC     = 0x80  // Bit PCMSYNC.
	SPI_I2SCFGR_I2SSTD_Pos  = 0x4   // Position of I2SSTD field.
	SPI_I2SCFGR_I2SSTD_Msk  = 0x30  // Bit mask of I2SSTD field.
	SPI_I2SCFGR_CKPOL_Pos   = 0x3   // Position of CKPOL field.
	SPI_I2SCFGR_CKPOL_Msk   = 0x8   // Bit mask of CKPOL field.
	SPI_I2SCFGR_CKPOL       = 0x8   // Bit CKPOL.
	SPI_I2SCFGR_DATLEN_Pos  = 0x1   // Position of DATLEN field.
	SPI_I2SCFGR_DATLEN_Msk  = 0x6   // Bit mask of DATLEN field.
	SPI_I2SCFGR_CHLEN_Pos   = 0x0   // Position of CHLEN field.
	SPI_I2SCFGR_CHLEN_Msk   = 0x1   // Bit mask of CHLEN field.
	SPI_I2SCFGR_CHLEN       = 0x1   // Bit CHLEN.

	// I2SPR: I2S prescaler register
	SPI_I2SPR_MCKOE_Pos  = 0x9   // Position of MCKOE field.
	SPI_I2SPR_MCKOE_Msk  = 0x200 // Bit mask of MCKOE field.
	SPI_I2SPR_MCKOE      = 0x200 // Bit MCKOE.
	SPI_I2SPR_ODD_Pos    = 0x8   // Position of ODD field.
	SPI_I2SPR_ODD_Msk    = 0x100 // Bit mask of ODD field.
	SPI_I2SPR_ODD        = 0x100 // Bit ODD.
	SPI_I2SPR_I2SDIV_Pos = 0x0   // Position of I2SDIV field.
	SPI_I2SPR_I2SDIV_Msk = 0xff  // Bit mask of I2SDIV field.
)

// Bitfields for NVIC: Nested Vectored Interrupt Controller
const (
	// ISER0: Interrupt Set-Enable Register
	NVIC_ISER0_SETENA_Pos = 0x0        // Position of SETENA field.
	NVIC_ISER0_SETENA_Msk = 0xffffffff // Bit mask of SETENA field.

	// ISER1: Interrupt Set-Enable Register
	NVIC_ISER1_SETENA_Pos = 0x0        // Position of SETENA field.
	NVIC_ISER1_SETENA_Msk = 0xffffffff // Bit mask of SETENA field.

	// ISER2: Interrupt Set-Enable Register
	NVIC_ISER2_SETENA_Pos = 0x0        // Position of SETENA field.
	NVIC_ISER2_SETENA_Msk = 0xffffffff // Bit mask of SETENA field.

	// ICER0: Interrupt Clear-Enable           Register
	NVIC_ICER0_CLRENA_Pos = 0x0        // Position of CLRENA field.
	NVIC_ICER0_CLRENA_Msk = 0xffffffff // Bit mask of CLRENA field.

	// ICER1: Interrupt Clear-Enable           Register
	NVIC_ICER1_CLRENA_Pos = 0x0        // Position of CLRENA field.
	NVIC_ICER1_CLRENA_Msk = 0xffffffff // Bit mask of CLRENA field.

	// ICER2: Interrupt Clear-Enable           Register
	NVIC_ICER2_CLRENA_Pos = 0x0        // Position of CLRENA field.
	NVIC_ICER2_CLRENA_Msk = 0xffffffff // Bit mask of CLRENA field.

	// ISPR0: Interrupt Set-Pending Register
	NVIC_ISPR0_SETPEND_Pos = 0x0        // Position of SETPEND field.
	NVIC_ISPR0_SETPEND_Msk = 0xffffffff // Bit mask of SETPEND field.

	// ISPR1: Interrupt Set-Pending Register
	NVIC_ISPR1_SETPEND_Pos = 0x0        // Position of SETPEND field.
	NVIC_ISPR1_SETPEND_Msk = 0xffffffff // Bit mask of SETPEND field.

	// ISPR2: Interrupt Set-Pending Register
	NVIC_ISPR2_SETPEND_Pos = 0x0        // Position of SETPEND field.
	NVIC_ISPR2_SETPEND_Msk = 0xffffffff // Bit mask of SETPEND field.

	// ICPR0: Interrupt Clear-Pending           Register
	NVIC_ICPR0_CLRPEND_Pos = 0x0        // Position of CLRPEND field.
	NVIC_ICPR0_CLRPEND_Msk = 0xffffffff // Bit mask of CLRPEND field.

	// ICPR1: Interrupt Clear-Pending           Register
	NVIC_ICPR1_CLRPEND_Pos = 0x0        // Position of CLRPEND field.
	NVIC_ICPR1_CLRPEND_Msk = 0xffffffff // Bit mask of CLRPEND field.

	// ICPR2: Interrupt Clear-Pending           Register
	NVIC_ICPR2_CLRPEND_Pos = 0x0        // Position of CLRPEND field.
	NVIC_ICPR2_CLRPEND_Msk = 0xffffffff // Bit mask of CLRPEND field.

	// IABR0: Interrupt Active Bit Register
	NVIC_IABR0_ACTIVE_Pos = 0x0        // Position of ACTIVE field.
	NVIC_IABR0_ACTIVE_Msk = 0xffffffff // Bit mask of ACTIVE field.

	// IABR1: Interrupt Active Bit Register
	NVIC_IABR1_ACTIVE_Pos = 0x0        // Position of ACTIVE field.
	NVIC_IABR1_ACTIVE_Msk = 0xffffffff // Bit mask of ACTIVE field.

	// IABR2: Interrupt Active Bit Register
	NVIC_IABR2_ACTIVE_Pos = 0x0        // Position of ACTIVE field.
	NVIC_IABR2_ACTIVE_Msk = 0xffffffff // Bit mask of ACTIVE field.

	// IPR0: Interrupt Priority Register
	NVIC_IPR0_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR0_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR0_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR0_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR0_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR0_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR0_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR0_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR1: Interrupt Priority Register
	NVIC_IPR1_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR1_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR1_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR1_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR1_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR1_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR1_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR1_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR2: Interrupt Priority Register
	NVIC_IPR2_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR2_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR2_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR2_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR2_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR2_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR2_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR2_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR3: Interrupt Priority Register
	NVIC_IPR3_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR3_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR3_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR3_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR3_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR3_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR3_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR3_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR4: Interrupt Priority Register
	NVIC_IPR4_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR4_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR4_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR4_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR4_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR4_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR4_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR4_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR5: Interrupt Priority Register
	NVIC_IPR5_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR5_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR5_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR5_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR5_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR5_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR5_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR5_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR6: Interrupt Priority Register
	NVIC_IPR6_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR6_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR6_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR6_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR6_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR6_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR6_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR6_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR7: Interrupt Priority Register
	NVIC_IPR7_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR7_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR7_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR7_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR7_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR7_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR7_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR7_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR8: Interrupt Priority Register
	NVIC_IPR8_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR8_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR8_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR8_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR8_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR8_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR8_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR8_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR9: Interrupt Priority Register
	NVIC_IPR9_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR9_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR9_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR9_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR9_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR9_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR9_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR9_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR10: Interrupt Priority Register
	NVIC_IPR10_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR10_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR10_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR10_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR10_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR10_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR10_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR10_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR11: Interrupt Priority Register
	NVIC_IPR11_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR11_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR11_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR11_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR11_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR11_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR11_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR11_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR12: Interrupt Priority Register
	NVIC_IPR12_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR12_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR12_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR12_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR12_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR12_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR12_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR12_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR13: Interrupt Priority Register
	NVIC_IPR13_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR13_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR13_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR13_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR13_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR13_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR13_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR13_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR14: Interrupt Priority Register
	NVIC_IPR14_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR14_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR14_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR14_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR14_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR14_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR14_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR14_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR15: Interrupt Priority Register
	NVIC_IPR15_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR15_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR15_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR15_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR15_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR15_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR15_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR15_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR16: Interrupt Priority Register
	NVIC_IPR16_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR16_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR16_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR16_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR16_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR16_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR16_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR16_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR17: Interrupt Priority Register
	NVIC_IPR17_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR17_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR17_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR17_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR17_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR17_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR17_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR17_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR18: Interrupt Priority Register
	NVIC_IPR18_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR18_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR18_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR18_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR18_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR18_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR18_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR18_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR19: Interrupt Priority Register
	NVIC_IPR19_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR19_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR19_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR19_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR19_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR19_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR19_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR19_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.
)

// Bitfields for FPU: Floting point unit
const (
	// FPCCR: Floating-point context control           register
	FPU_FPCCR_LSPACT_Pos = 0x0        // Position of LSPACT field.
	FPU_FPCCR_LSPACT_Msk = 0x1        // Bit mask of LSPACT field.
	FPU_FPCCR_LSPACT     = 0x1        // Bit LSPACT.
	FPU_FPCCR_USER_Pos   = 0x1        // Position of USER field.
	FPU_FPCCR_USER_Msk   = 0x2        // Bit mask of USER field.
	FPU_FPCCR_USER       = 0x2        // Bit USER.
	FPU_FPCCR_THREAD_Pos = 0x3        // Position of THREAD field.
	FPU_FPCCR_THREAD_Msk = 0x8        // Bit mask of THREAD field.
	FPU_FPCCR_THREAD     = 0x8        // Bit THREAD.
	FPU_FPCCR_HFRDY_Pos  = 0x4        // Position of HFRDY field.
	FPU_FPCCR_HFRDY_Msk  = 0x10       // Bit mask of HFRDY field.
	FPU_FPCCR_HFRDY      = 0x10       // Bit HFRDY.
	FPU_FPCCR_MMRDY_Pos  = 0x5        // Position of MMRDY field.
	FPU_FPCCR_MMRDY_Msk  = 0x20       // Bit mask of MMRDY field.
	FPU_FPCCR_MMRDY      = 0x20       // Bit MMRDY.
	FPU_FPCCR_BFRDY_Pos  = 0x6        // Position of BFRDY field.
	FPU_FPCCR_BFRDY_Msk  = 0x40       // Bit mask of BFRDY field.
	FPU_FPCCR_BFRDY      = 0x40       // Bit BFRDY.
	FPU_FPCCR_MONRDY_Pos = 0x8        // Position of MONRDY field.
	FPU_FPCCR_MONRDY_Msk = 0x100      // Bit mask of MONRDY field.
	FPU_FPCCR_MONRDY     = 0x100      // Bit MONRDY.
	FPU_FPCCR_LSPEN_Pos  = 0x1e       // Position of LSPEN field.
	FPU_FPCCR_LSPEN_Msk  = 0x40000000 // Bit mask of LSPEN field.
	FPU_FPCCR_LSPEN      = 0x40000000 // Bit LSPEN.
	FPU_FPCCR_ASPEN_Pos  = 0x1f       // Position of ASPEN field.
	FPU_FPCCR_ASPEN_Msk  = 0x80000000 // Bit mask of ASPEN field.
	FPU_FPCCR_ASPEN      = 0x80000000 // Bit ASPEN.

	// FPCAR: Floating-point context address           register
	FPU_FPCAR_ADDRESS_Pos = 0x3        // Position of ADDRESS field.
	FPU_FPCAR_ADDRESS_Msk = 0xfffffff8 // Bit mask of ADDRESS field.

	// FPSCR: Floating-point status control           register
	FPU_FPSCR_IOC_Pos   = 0x0        // Position of IOC field.
	FPU_FPSCR_IOC_Msk   = 0x1        // Bit mask of IOC field.
	FPU_FPSCR_IOC       = 0x1        // Bit IOC.
	FPU_FPSCR_DZC_Pos   = 0x1        // Position of DZC field.
	FPU_FPSCR_DZC_Msk   = 0x2        // Bit mask of DZC field.
	FPU_FPSCR_DZC       = 0x2        // Bit DZC.
	FPU_FPSCR_OFC_Pos   = 0x2        // Position of OFC field.
	FPU_FPSCR_OFC_Msk   = 0x4        // Bit mask of OFC field.
	FPU_FPSCR_OFC       = 0x4        // Bit OFC.
	FPU_FPSCR_UFC_Pos   = 0x3        // Position of UFC field.
	FPU_FPSCR_UFC_Msk   = 0x8        // Bit mask of UFC field.
	FPU_FPSCR_UFC       = 0x8        // Bit UFC.
	FPU_FPSCR_IXC_Pos   = 0x4        // Position of IXC field.
	FPU_FPSCR_IXC_Msk   = 0x10       // Bit mask of IXC field.
	FPU_FPSCR_IXC       = 0x10       // Bit IXC.
	FPU_FPSCR_IDC_Pos   = 0x7        // Position of IDC field.
	FPU_FPSCR_IDC_Msk   = 0x80       // Bit mask of IDC field.
	FPU_FPSCR_IDC       = 0x80       // Bit IDC.
	FPU_FPSCR_RMode_Pos = 0x16       // Position of RMode field.
	FPU_FPSCR_RMode_Msk = 0xc00000   // Bit mask of RMode field.
	FPU_FPSCR_FZ_Pos    = 0x18       // Position of FZ field.
	FPU_FPSCR_FZ_Msk    = 0x1000000  // Bit mask of FZ field.
	FPU_FPSCR_FZ        = 0x1000000  // Bit FZ.
	FPU_FPSCR_DN_Pos    = 0x19       // Position of DN field.
	FPU_FPSCR_DN_Msk    = 0x2000000  // Bit mask of DN field.
	FPU_FPSCR_DN        = 0x2000000  // Bit DN.
	FPU_FPSCR_AHP_Pos   = 0x1a       // Position of AHP field.
	FPU_FPSCR_AHP_Msk   = 0x4000000  // Bit mask of AHP field.
	FPU_FPSCR_AHP       = 0x4000000  // Bit AHP.
	FPU_FPSCR_V_Pos     = 0x1c       // Position of V field.
	FPU_FPSCR_V_Msk     = 0x10000000 // Bit mask of V field.
	FPU_FPSCR_V         = 0x10000000 // Bit V.
	FPU_FPSCR_C_Pos     = 0x1d       // Position of C field.
	FPU_FPSCR_C_Msk     = 0x20000000 // Bit mask of C field.
	FPU_FPSCR_C         = 0x20000000 // Bit C.
	FPU_FPSCR_Z_Pos     = 0x1e       // Position of Z field.
	FPU_FPSCR_Z_Msk     = 0x40000000 // Bit mask of Z field.
	FPU_FPSCR_Z         = 0x40000000 // Bit Z.
	FPU_FPSCR_N_Pos     = 0x1f       // Position of N field.
	FPU_FPSCR_N_Msk     = 0x80000000 // Bit mask of N field.
	FPU_FPSCR_N         = 0x80000000 // Bit N.
)

// Bitfields for MPU: Memory protection unit
const (
	// MPU_TYPER: MPU type register
	MPU_MPU_TYPER_SEPARATE_Pos = 0x0      // Position of SEPARATE field.
	MPU_MPU_TYPER_SEPARATE_Msk = 0x1      // Bit mask of SEPARATE field.
	MPU_MPU_TYPER_SEPARATE     = 0x1      // Bit SEPARATE.
	MPU_MPU_TYPER_DREGION_Pos  = 0x8      // Position of DREGION field.
	MPU_MPU_TYPER_DREGION_Msk  = 0xff00   // Bit mask of DREGION field.
	MPU_MPU_TYPER_IREGION_Pos  = 0x10     // Position of IREGION field.
	MPU_MPU_TYPER_IREGION_Msk  = 0xff0000 // Bit mask of IREGION field.

	// MPU_CTRL: MPU control register
	MPU_MPU_CTRL_ENABLE_Pos     = 0x0 // Position of ENABLE field.
	MPU_MPU_CTRL_ENABLE_Msk     = 0x1 // Bit mask of ENABLE field.
	MPU_MPU_CTRL_ENABLE         = 0x1 // Bit ENABLE.
	MPU_MPU_CTRL_HFNMIENA_Pos   = 0x1 // Position of HFNMIENA field.
	MPU_MPU_CTRL_HFNMIENA_Msk   = 0x2 // Bit mask of HFNMIENA field.
	MPU_MPU_CTRL_HFNMIENA       = 0x2 // Bit HFNMIENA.
	MPU_MPU_CTRL_PRIVDEFENA_Pos = 0x2 // Position of PRIVDEFENA field.
	MPU_MPU_CTRL_PRIVDEFENA_Msk = 0x4 // Bit mask of PRIVDEFENA field.
	MPU_MPU_CTRL_PRIVDEFENA     = 0x4 // Bit PRIVDEFENA.

	// MPU_RNR: MPU region number register
	MPU_MPU_RNR_REGION_Pos = 0x0  // Position of REGION field.
	MPU_MPU_RNR_REGION_Msk = 0xff // Bit mask of REGION field.

	// MPU_RBAR: MPU region base address           register
	MPU_MPU_RBAR_REGION_Pos = 0x0        // Position of REGION field.
	MPU_MPU_RBAR_REGION_Msk = 0xf        // Bit mask of REGION field.
	MPU_MPU_RBAR_VALID_Pos  = 0x4        // Position of VALID field.
	MPU_MPU_RBAR_VALID_Msk  = 0x10       // Bit mask of VALID field.
	MPU_MPU_RBAR_VALID      = 0x10       // Bit VALID.
	MPU_MPU_RBAR_ADDR_Pos   = 0x5        // Position of ADDR field.
	MPU_MPU_RBAR_ADDR_Msk   = 0xffffffe0 // Bit mask of ADDR field.

	// MPU_RASR: MPU region attribute and size           register
	MPU_MPU_RASR_ENABLE_Pos = 0x0        // Position of ENABLE field.
	MPU_MPU_RASR_ENABLE_Msk = 0x1        // Bit mask of ENABLE field.
	MPU_MPU_RASR_ENABLE     = 0x1        // Bit ENABLE.
	MPU_MPU_RASR_SIZE_Pos   = 0x1        // Position of SIZE field.
	MPU_MPU_RASR_SIZE_Msk   = 0x3e       // Bit mask of SIZE field.
	MPU_MPU_RASR_SRD_Pos    = 0x8        // Position of SRD field.
	MPU_MPU_RASR_SRD_Msk    = 0xff00     // Bit mask of SRD field.
	MPU_MPU_RASR_B_Pos      = 0x10       // Position of B field.
	MPU_MPU_RASR_B_Msk      = 0x10000    // Bit mask of B field.
	MPU_MPU_RASR_B          = 0x10000    // Bit B.
	MPU_MPU_RASR_C_Pos      = 0x11       // Position of C field.
	MPU_MPU_RASR_C_Msk      = 0x20000    // Bit mask of C field.
	MPU_MPU_RASR_C          = 0x20000    // Bit C.
	MPU_MPU_RASR_S_Pos      = 0x12       // Position of S field.
	MPU_MPU_RASR_S_Msk      = 0x40000    // Bit mask of S field.
	MPU_MPU_RASR_S          = 0x40000    // Bit S.
	MPU_MPU_RASR_TEX_Pos    = 0x13       // Position of TEX field.
	MPU_MPU_RASR_TEX_Msk    = 0x380000   // Bit mask of TEX field.
	MPU_MPU_RASR_AP_Pos     = 0x18       // Position of AP field.
	MPU_MPU_RASR_AP_Msk     = 0x7000000  // Bit mask of AP field.
	MPU_MPU_RASR_XN_Pos     = 0x1c       // Position of XN field.
	MPU_MPU_RASR_XN_Msk     = 0x10000000 // Bit mask of XN field.
	MPU_MPU_RASR_XN         = 0x10000000 // Bit XN.
)

// Bitfields for STK: SysTick timer
const (
	// CTRL: SysTick control and status           register
	STK_CTRL_ENABLE_Pos    = 0x0     // Position of ENABLE field.
	STK_CTRL_ENABLE_Msk    = 0x1     // Bit mask of ENABLE field.
	STK_CTRL_ENABLE        = 0x1     // Bit ENABLE.
	STK_CTRL_TICKINT_Pos   = 0x1     // Position of TICKINT field.
	STK_CTRL_TICKINT_Msk   = 0x2     // Bit mask of TICKINT field.
	STK_CTRL_TICKINT       = 0x2     // Bit TICKINT.
	STK_CTRL_CLKSOURCE_Pos = 0x2     // Position of CLKSOURCE field.
	STK_CTRL_CLKSOURCE_Msk = 0x4     // Bit mask of CLKSOURCE field.
	STK_CTRL_CLKSOURCE     = 0x4     // Bit CLKSOURCE.
	STK_CTRL_COUNTFLAG_Pos = 0x10    // Position of COUNTFLAG field.
	STK_CTRL_COUNTFLAG_Msk = 0x10000 // Bit mask of COUNTFLAG field.
	STK_CTRL_COUNTFLAG     = 0x10000 // Bit COUNTFLAG.

	// LOAD: SysTick reload value register
	STK_LOAD_RELOAD_Pos = 0x0      // Position of RELOAD field.
	STK_LOAD_RELOAD_Msk = 0xffffff // Bit mask of RELOAD field.

	// VAL: SysTick current value register
	STK_VAL_CURRENT_Pos = 0x0      // Position of CURRENT field.
	STK_VAL_CURRENT_Msk = 0xffffff // Bit mask of CURRENT field.

	// CALIB: SysTick calibration value           register
	STK_CALIB_TENMS_Pos = 0x0        // Position of TENMS field.
	STK_CALIB_TENMS_Msk = 0xffffff   // Bit mask of TENMS field.
	STK_CALIB_SKEW_Pos  = 0x1e       // Position of SKEW field.
	STK_CALIB_SKEW_Msk  = 0x40000000 // Bit mask of SKEW field.
	STK_CALIB_SKEW      = 0x40000000 // Bit SKEW.
	STK_CALIB_NOREF_Pos = 0x1f       // Position of NOREF field.
	STK_CALIB_NOREF_Msk = 0x80000000 // Bit mask of NOREF field.
	STK_CALIB_NOREF     = 0x80000000 // Bit NOREF.
)

// Bitfields for SCB: System control block
const (
	// CPUID: CPUID base register
	SCB_CPUID_Revision_Pos    = 0x0        // Position of Revision field.
	SCB_CPUID_Revision_Msk    = 0xf        // Bit mask of Revision field.
	SCB_CPUID_PartNo_Pos      = 0x4        // Position of PartNo field.
	SCB_CPUID_PartNo_Msk      = 0xfff0     // Bit mask of PartNo field.
	SCB_CPUID_Constant_Pos    = 0x10       // Position of Constant field.
	SCB_CPUID_Constant_Msk    = 0xf0000    // Bit mask of Constant field.
	SCB_CPUID_Variant_Pos     = 0x14       // Position of Variant field.
	SCB_CPUID_Variant_Msk     = 0xf00000   // Bit mask of Variant field.
	SCB_CPUID_Implementer_Pos = 0x18       // Position of Implementer field.
	SCB_CPUID_Implementer_Msk = 0xff000000 // Bit mask of Implementer field.

	// ICSR: Interrupt control and state           register
	SCB_ICSR_VECTACTIVE_Pos  = 0x0        // Position of VECTACTIVE field.
	SCB_ICSR_VECTACTIVE_Msk  = 0x1ff      // Bit mask of VECTACTIVE field.
	SCB_ICSR_RETTOBASE_Pos   = 0xb        // Position of RETTOBASE field.
	SCB_ICSR_RETTOBASE_Msk   = 0x800      // Bit mask of RETTOBASE field.
	SCB_ICSR_RETTOBASE       = 0x800      // Bit RETTOBASE.
	SCB_ICSR_VECTPENDING_Pos = 0xc        // Position of VECTPENDING field.
	SCB_ICSR_VECTPENDING_Msk = 0x7f000    // Bit mask of VECTPENDING field.
	SCB_ICSR_ISRPENDING_Pos  = 0x16       // Position of ISRPENDING field.
	SCB_ICSR_ISRPENDING_Msk  = 0x400000   // Bit mask of ISRPENDING field.
	SCB_ICSR_ISRPENDING      = 0x400000   // Bit ISRPENDING.
	SCB_ICSR_PENDSTCLR_Pos   = 0x19       // Position of PENDSTCLR field.
	SCB_ICSR_PENDSTCLR_Msk   = 0x2000000  // Bit mask of PENDSTCLR field.
	SCB_ICSR_PENDSTCLR       = 0x2000000  // Bit PENDSTCLR.
	SCB_ICSR_PENDSTSET_Pos   = 0x1a       // Position of PENDSTSET field.
	SCB_ICSR_PENDSTSET_Msk   = 0x4000000  // Bit mask of PENDSTSET field.
	SCB_ICSR_PENDSTSET       = 0x4000000  // Bit PENDSTSET.
	SCB_ICSR_PENDSVCLR_Pos   = 0x1b       // Position of PENDSVCLR field.
	SCB_ICSR_PENDSVCLR_Msk   = 0x8000000  // Bit mask of PENDSVCLR field.
	SCB_ICSR_PENDSVCLR       = 0x8000000  // Bit PENDSVCLR.
	SCB_ICSR_PENDSVSET_Pos   = 0x1c       // Position of PENDSVSET field.
	SCB_ICSR_PENDSVSET_Msk   = 0x10000000 // Bit mask of PENDSVSET field.
	SCB_ICSR_PENDSVSET       = 0x10000000 // Bit PENDSVSET.
	SCB_ICSR_NMIPENDSET_Pos  = 0x1f       // Position of NMIPENDSET field.
	SCB_ICSR_NMIPENDSET_Msk  = 0x80000000 // Bit mask of NMIPENDSET field.
	SCB_ICSR_NMIPENDSET      = 0x80000000 // Bit NMIPENDSET.

	// VTOR: Vector table offset register
	SCB_VTOR_TBLOFF_Pos = 0x9        // Position of TBLOFF field.
	SCB_VTOR_TBLOFF_Msk = 0x3ffffe00 // Bit mask of TBLOFF field.

	// AIRCR: Application interrupt and reset control           register
	SCB_AIRCR_VECTRESET_Pos     = 0x0        // Position of VECTRESET field.
	SCB_AIRCR_VECTRESET_Msk     = 0x1        // Bit mask of VECTRESET field.
	SCB_AIRCR_VECTRESET         = 0x1        // Bit VECTRESET.
	SCB_AIRCR_VECTCLRACTIVE_Pos = 0x1        // Position of VECTCLRACTIVE field.
	SCB_AIRCR_VECTCLRACTIVE_Msk = 0x2        // Bit mask of VECTCLRACTIVE field.
	SCB_AIRCR_VECTCLRACTIVE     = 0x2        // Bit VECTCLRACTIVE.
	SCB_AIRCR_SYSRESETREQ_Pos   = 0x2        // Position of SYSRESETREQ field.
	SCB_AIRCR_SYSRESETREQ_Msk   = 0x4        // Bit mask of SYSRESETREQ field.
	SCB_AIRCR_SYSRESETREQ       = 0x4        // Bit SYSRESETREQ.
	SCB_AIRCR_PRIGROUP_Pos      = 0x8        // Position of PRIGROUP field.
	SCB_AIRCR_PRIGROUP_Msk      = 0x700      // Bit mask of PRIGROUP field.
	SCB_AIRCR_ENDIANESS_Pos     = 0xf        // Position of ENDIANESS field.
	SCB_AIRCR_ENDIANESS_Msk     = 0x8000     // Bit mask of ENDIANESS field.
	SCB_AIRCR_ENDIANESS         = 0x8000     // Bit ENDIANESS.
	SCB_AIRCR_VECTKEYSTAT_Pos   = 0x10       // Position of VECTKEYSTAT field.
	SCB_AIRCR_VECTKEYSTAT_Msk   = 0xffff0000 // Bit mask of VECTKEYSTAT field.

	// SCR: System control register
	SCB_SCR_SLEEPONEXIT_Pos = 0x1  // Position of SLEEPONEXIT field.
	SCB_SCR_SLEEPONEXIT_Msk = 0x2  // Bit mask of SLEEPONEXIT field.
	SCB_SCR_SLEEPONEXIT     = 0x2  // Bit SLEEPONEXIT.
	SCB_SCR_SLEEPDEEP_Pos   = 0x2  // Position of SLEEPDEEP field.
	SCB_SCR_SLEEPDEEP_Msk   = 0x4  // Bit mask of SLEEPDEEP field.
	SCB_SCR_SLEEPDEEP       = 0x4  // Bit SLEEPDEEP.
	SCB_SCR_SEVEONPEND_Pos  = 0x4  // Position of SEVEONPEND field.
	SCB_SCR_SEVEONPEND_Msk  = 0x10 // Bit mask of SEVEONPEND field.
	SCB_SCR_SEVEONPEND      = 0x10 // Bit SEVEONPEND.

	// CCR: Configuration and control           register
	SCB_CCR_NONBASETHRDENA_Pos = 0x0   // Position of NONBASETHRDENA field.
	SCB_CCR_NONBASETHRDENA_Msk = 0x1   // Bit mask of NONBASETHRDENA field.
	SCB_CCR_NONBASETHRDENA     = 0x1   // Bit NONBASETHRDENA.
	SCB_CCR_USERSETMPEND_Pos   = 0x1   // Position of USERSETMPEND field.
	SCB_CCR_USERSETMPEND_Msk   = 0x2   // Bit mask of USERSETMPEND field.
	SCB_CCR_USERSETMPEND       = 0x2   // Bit USERSETMPEND.
	SCB_CCR_UNALIGN__TRP_Pos   = 0x3   // Position of UNALIGN__TRP field.
	SCB_CCR_UNALIGN__TRP_Msk   = 0x8   // Bit mask of UNALIGN__TRP field.
	SCB_CCR_UNALIGN__TRP       = 0x8   // Bit UNALIGN__TRP.
	SCB_CCR_DIV_0_TRP_Pos      = 0x4   // Position of DIV_0_TRP field.
	SCB_CCR_DIV_0_TRP_Msk      = 0x10  // Bit mask of DIV_0_TRP field.
	SCB_CCR_DIV_0_TRP          = 0x10  // Bit DIV_0_TRP.
	SCB_CCR_BFHFNMIGN_Pos      = 0x8   // Position of BFHFNMIGN field.
	SCB_CCR_BFHFNMIGN_Msk      = 0x100 // Bit mask of BFHFNMIGN field.
	SCB_CCR_BFHFNMIGN          = 0x100 // Bit BFHFNMIGN.
	SCB_CCR_STKALIGN_Pos       = 0x9   // Position of STKALIGN field.
	SCB_CCR_STKALIGN_Msk       = 0x200 // Bit mask of STKALIGN field.
	SCB_CCR_STKALIGN           = 0x200 // Bit STKALIGN.

	// SHPR1: System handler priority           registers
	SCB_SHPR1_PRI_4_Pos = 0x0      // Position of PRI_4 field.
	SCB_SHPR1_PRI_4_Msk = 0xff     // Bit mask of PRI_4 field.
	SCB_SHPR1_PRI_5_Pos = 0x8      // Position of PRI_5 field.
	SCB_SHPR1_PRI_5_Msk = 0xff00   // Bit mask of PRI_5 field.
	SCB_SHPR1_PRI_6_Pos = 0x10     // Position of PRI_6 field.
	SCB_SHPR1_PRI_6_Msk = 0xff0000 // Bit mask of PRI_6 field.

	// SHPR2: System handler priority           registers
	SCB_SHPR2_PRI_11_Pos = 0x18       // Position of PRI_11 field.
	SCB_SHPR2_PRI_11_Msk = 0xff000000 // Bit mask of PRI_11 field.

	// SHPR3: System handler priority           registers
	SCB_SHPR3_PRI_14_Pos = 0x10       // Position of PRI_14 field.
	SCB_SHPR3_PRI_14_Msk = 0xff0000   // Bit mask of PRI_14 field.
	SCB_SHPR3_PRI_15_Pos = 0x18       // Position of PRI_15 field.
	SCB_SHPR3_PRI_15_Msk = 0xff000000 // Bit mask of PRI_15 field.

	// SHCRS: System handler control and state           register
	SCB_SHCRS_MEMFAULTACT_Pos    = 0x0     // Position of MEMFAULTACT field.
	SCB_SHCRS_MEMFAULTACT_Msk    = 0x1     // Bit mask of MEMFAULTACT field.
	SCB_SHCRS_MEMFAULTACT        = 0x1     // Bit MEMFAULTACT.
	SCB_SHCRS_BUSFAULTACT_Pos    = 0x1     // Position of BUSFAULTACT field.
	SCB_SHCRS_BUSFAULTACT_Msk    = 0x2     // Bit mask of BUSFAULTACT field.
	SCB_SHCRS_BUSFAULTACT        = 0x2     // Bit BUSFAULTACT.
	SCB_SHCRS_USGFAULTACT_Pos    = 0x3     // Position of USGFAULTACT field.
	SCB_SHCRS_USGFAULTACT_Msk    = 0x8     // Bit mask of USGFAULTACT field.
	SCB_SHCRS_USGFAULTACT        = 0x8     // Bit USGFAULTACT.
	SCB_SHCRS_SVCALLACT_Pos      = 0x7     // Position of SVCALLACT field.
	SCB_SHCRS_SVCALLACT_Msk      = 0x80    // Bit mask of SVCALLACT field.
	SCB_SHCRS_SVCALLACT          = 0x80    // Bit SVCALLACT.
	SCB_SHCRS_MONITORACT_Pos     = 0x8     // Position of MONITORACT field.
	SCB_SHCRS_MONITORACT_Msk     = 0x100   // Bit mask of MONITORACT field.
	SCB_SHCRS_MONITORACT         = 0x100   // Bit MONITORACT.
	SCB_SHCRS_PENDSVACT_Pos      = 0xa     // Position of PENDSVACT field.
	SCB_SHCRS_PENDSVACT_Msk      = 0x400   // Bit mask of PENDSVACT field.
	SCB_SHCRS_PENDSVACT          = 0x400   // Bit PENDSVACT.
	SCB_SHCRS_SYSTICKACT_Pos     = 0xb     // Position of SYSTICKACT field.
	SCB_SHCRS_SYSTICKACT_Msk     = 0x800   // Bit mask of SYSTICKACT field.
	SCB_SHCRS_SYSTICKACT         = 0x800   // Bit SYSTICKACT.
	SCB_SHCRS_USGFAULTPENDED_Pos = 0xc     // Position of USGFAULTPENDED field.
	SCB_SHCRS_USGFAULTPENDED_Msk = 0x1000  // Bit mask of USGFAULTPENDED field.
	SCB_SHCRS_USGFAULTPENDED     = 0x1000  // Bit USGFAULTPENDED.
	SCB_SHCRS_MEMFAULTPENDED_Pos = 0xd     // Position of MEMFAULTPENDED field.
	SCB_SHCRS_MEMFAULTPENDED_Msk = 0x2000  // Bit mask of MEMFAULTPENDED field.
	SCB_SHCRS_MEMFAULTPENDED     = 0x2000  // Bit MEMFAULTPENDED.
	SCB_SHCRS_BUSFAULTPENDED_Pos = 0xe     // Position of BUSFAULTPENDED field.
	SCB_SHCRS_BUSFAULTPENDED_Msk = 0x4000  // Bit mask of BUSFAULTPENDED field.
	SCB_SHCRS_BUSFAULTPENDED     = 0x4000  // Bit BUSFAULTPENDED.
	SCB_SHCRS_SVCALLPENDED_Pos   = 0xf     // Position of SVCALLPENDED field.
	SCB_SHCRS_SVCALLPENDED_Msk   = 0x8000  // Bit mask of SVCALLPENDED field.
	SCB_SHCRS_SVCALLPENDED       = 0x8000  // Bit SVCALLPENDED.
	SCB_SHCRS_MEMFAULTENA_Pos    = 0x10    // Position of MEMFAULTENA field.
	SCB_SHCRS_MEMFAULTENA_Msk    = 0x10000 // Bit mask of MEMFAULTENA field.
	SCB_SHCRS_MEMFAULTENA        = 0x10000 // Bit MEMFAULTENA.
	SCB_SHCRS_BUSFAULTENA_Pos    = 0x11    // Position of BUSFAULTENA field.
	SCB_SHCRS_BUSFAULTENA_Msk    = 0x20000 // Bit mask of BUSFAULTENA field.
	SCB_SHCRS_BUSFAULTENA        = 0x20000 // Bit BUSFAULTENA.
	SCB_SHCRS_USGFAULTENA_Pos    = 0x12    // Position of USGFAULTENA field.
	SCB_SHCRS_USGFAULTENA_Msk    = 0x40000 // Bit mask of USGFAULTENA field.
	SCB_SHCRS_USGFAULTENA        = 0x40000 // Bit USGFAULTENA.

	// CFSR_UFSR_BFSR_MMFSR: Configurable fault status           register
	SCB_CFSR_UFSR_BFSR_MMFSR_IACCVIOL_Pos    = 0x1       // Position of IACCVIOL field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IACCVIOL_Msk    = 0x2       // Bit mask of IACCVIOL field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IACCVIOL        = 0x2       // Bit IACCVIOL.
	SCB_CFSR_UFSR_BFSR_MMFSR_MUNSTKERR_Pos   = 0x3       // Position of MUNSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MUNSTKERR_Msk   = 0x8       // Bit mask of MUNSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MUNSTKERR       = 0x8       // Bit MUNSTKERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_MSTKERR_Pos     = 0x4       // Position of MSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MSTKERR_Msk     = 0x10      // Bit mask of MSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MSTKERR         = 0x10      // Bit MSTKERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_MLSPERR_Pos     = 0x5       // Position of MLSPERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MLSPERR_Msk     = 0x20      // Bit mask of MLSPERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MLSPERR         = 0x20      // Bit MLSPERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_MMARVALID_Pos   = 0x7       // Position of MMARVALID field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MMARVALID_Msk   = 0x80      // Bit mask of MMARVALID field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MMARVALID       = 0x80      // Bit MMARVALID.
	SCB_CFSR_UFSR_BFSR_MMFSR_IBUSERR_Pos     = 0x8       // Position of IBUSERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IBUSERR_Msk     = 0x100     // Bit mask of IBUSERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IBUSERR         = 0x100     // Bit IBUSERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_PRECISERR_Pos   = 0x9       // Position of PRECISERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_PRECISERR_Msk   = 0x200     // Bit mask of PRECISERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_PRECISERR       = 0x200     // Bit PRECISERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_IMPRECISERR_Pos = 0xa       // Position of IMPRECISERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IMPRECISERR_Msk = 0x400     // Bit mask of IMPRECISERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IMPRECISERR     = 0x400     // Bit IMPRECISERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNSTKERR_Pos    = 0xb       // Position of UNSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNSTKERR_Msk    = 0x800     // Bit mask of UNSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNSTKERR        = 0x800     // Bit UNSTKERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_STKERR_Pos      = 0xc       // Position of STKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_STKERR_Msk      = 0x1000    // Bit mask of STKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_STKERR          = 0x1000    // Bit STKERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_LSPERR_Pos      = 0xd       // Position of LSPERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_LSPERR_Msk      = 0x2000    // Bit mask of LSPERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_LSPERR          = 0x2000    // Bit LSPERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_BFARVALID_Pos   = 0xf       // Position of BFARVALID field.
	SCB_CFSR_UFSR_BFSR_MMFSR_BFARVALID_Msk   = 0x8000    // Bit mask of BFARVALID field.
	SCB_CFSR_UFSR_BFSR_MMFSR_BFARVALID       = 0x8000    // Bit BFARVALID.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNDEFINSTR_Pos  = 0x10      // Position of UNDEFINSTR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNDEFINSTR_Msk  = 0x10000   // Bit mask of UNDEFINSTR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNDEFINSTR      = 0x10000   // Bit UNDEFINSTR.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVSTATE_Pos    = 0x11      // Position of INVSTATE field.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVSTATE_Msk    = 0x20000   // Bit mask of INVSTATE field.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVSTATE        = 0x20000   // Bit INVSTATE.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVPC_Pos       = 0x12      // Position of INVPC field.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVPC_Msk       = 0x40000   // Bit mask of INVPC field.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVPC           = 0x40000   // Bit INVPC.
	SCB_CFSR_UFSR_BFSR_MMFSR_NOCP_Pos        = 0x13      // Position of NOCP field.
	SCB_CFSR_UFSR_BFSR_MMFSR_NOCP_Msk        = 0x80000   // Bit mask of NOCP field.
	SCB_CFSR_UFSR_BFSR_MMFSR_NOCP            = 0x80000   // Bit NOCP.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNALIGNED_Pos   = 0x18      // Position of UNALIGNED field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNALIGNED_Msk   = 0x1000000 // Bit mask of UNALIGNED field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNALIGNED       = 0x1000000 // Bit UNALIGNED.
	SCB_CFSR_UFSR_BFSR_MMFSR_DIVBYZERO_Pos   = 0x19      // Position of DIVBYZERO field.
	SCB_CFSR_UFSR_BFSR_MMFSR_DIVBYZERO_Msk   = 0x2000000 // Bit mask of DIVBYZERO field.
	SCB_CFSR_UFSR_BFSR_MMFSR_DIVBYZERO       = 0x2000000 // Bit DIVBYZERO.

	// HFSR: Hard fault status register
	SCB_HFSR_VECTTBL_Pos  = 0x1        // Position of VECTTBL field.
	SCB_HFSR_VECTTBL_Msk  = 0x2        // Bit mask of VECTTBL field.
	SCB_HFSR_VECTTBL      = 0x2        // Bit VECTTBL.
	SCB_HFSR_FORCED_Pos   = 0x1e       // Position of FORCED field.
	SCB_HFSR_FORCED_Msk   = 0x40000000 // Bit mask of FORCED field.
	SCB_HFSR_FORCED       = 0x40000000 // Bit FORCED.
	SCB_HFSR_DEBUG_VT_Pos = 0x1f       // Position of DEBUG_VT field.
	SCB_HFSR_DEBUG_VT_Msk = 0x80000000 // Bit mask of DEBUG_VT field.
	SCB_HFSR_DEBUG_VT     = 0x80000000 // Bit DEBUG_VT.

	// MMFAR: Memory management fault address           register
	SCB_MMFAR_MMFAR_Pos = 0x0        // Position of MMFAR field.
	SCB_MMFAR_MMFAR_Msk = 0xffffffff // Bit mask of MMFAR field.

	// BFAR: Bus fault address register
	SCB_BFAR_BFAR_Pos = 0x0        // Position of BFAR field.
	SCB_BFAR_BFAR_Msk = 0xffffffff // Bit mask of BFAR field.

	// AFSR: Auxiliary fault status           register
	SCB_AFSR_IMPDEF_Pos = 0x0        // Position of IMPDEF field.
	SCB_AFSR_IMPDEF_Msk = 0xffffffff // Bit mask of IMPDEF field.
)
