
#ifndef THREADWEAVER_EXPORT_H
#define THREADWEAVER_EXPORT_H

#ifdef THREADWEAVER_STATIC_DEFINE
#  define THREADWEAVER_EXPORT
#  define THREADWEAVER_NO_EXPORT
#else
#  ifndef THREADWEAVER_EXPORT
#    ifdef KF5ThreadWeaver_EXPORTS
        /* We are building this library */
#      define THREADWEAVER_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define THREADWEAVER_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef THREADWEAVER_NO_EXPORT
#    define THREADWEAVER_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef THREADWEAVER_DECL_DEPRECATED
#  define THREADWEAVER_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef THREADWEAVER_DECL_DEPRECATED_EXPORT
#  define THREADWEAVER_DECL_DEPRECATED_EXPORT THREADWEAVER_EXPORT THREADWEAVER_DECL_DEPRECATED
#endif

#ifndef THREADWEAVER_DECL_DEPRECATED_NO_EXPORT
#  define THREADWEAVER_DECL_DEPRECATED_NO_EXPORT THREADWEAVER_NO_EXPORT THREADWEAVER_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef THREADWEAVER_NO_DEPRECATED
#    define THREADWEAVER_NO_DEPRECATED
#  endif
#endif

#define THREADWEAVER_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#define ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, patch) ((major<<16)|(minor<<8)|(patch))

/* Take any defaults from group settings */
#if !defined(THREADWEAVER_NO_DEPRECATED) && !defined(THREADWEAVER_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define THREADWEAVER_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define THREADWEAVER_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(THREADWEAVER_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define THREADWEAVER_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(THREADWEAVER_NO_DEPRECATED_WARNINGS) && !defined(THREADWEAVER_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define THREADWEAVER_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define THREADWEAVER_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(THREADWEAVER_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define THREADWEAVER_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(THREADWEAVER_NO_DEPRECATED)
#  undef THREADWEAVER_DEPRECATED
#  define THREADWEAVER_DEPRECATED_EXPORT THREADWEAVER_EXPORT
#  define THREADWEAVER_DEPRECATED_NO_EXPORT THREADWEAVER_NO_EXPORT
#elif defined(THREADWEAVER_NO_DEPRECATED_WARNINGS)
#  define THREADWEAVER_DEPRECATED
#  define THREADWEAVER_DEPRECATED_EXPORT THREADWEAVER_EXPORT
#  define THREADWEAVER_DEPRECATED_NO_EXPORT THREADWEAVER_NO_EXPORT
#else
#  define THREADWEAVER_DEPRECATED THREADWEAVER_DECL_DEPRECATED
#  define THREADWEAVER_DEPRECATED_EXPORT THREADWEAVER_DECL_DEPRECATED_EXPORT
#  define THREADWEAVER_DEPRECATED_NO_EXPORT THREADWEAVER_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define THREADWEAVER_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define THREADWEAVER_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef THREADWEAVER_NO_DEPRECATED
#  define THREADWEAVER_DISABLE_DEPRECATED_BEFORE_AND_AT 0x54f00
#endif
#ifdef THREADWEAVER_NO_DEPRECATED_WARNINGS
#  define THREADWEAVER_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef THREADWEAVER_DEPRECATED_WARNINGS_SINCE
#  ifdef THREADWEAVER_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define THREADWEAVER_DEPRECATED_WARNINGS_SINCE THREADWEAVER_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define THREADWEAVER_DEPRECATED_WARNINGS_SINCE 0x54f00
#  endif
#endif

#ifndef THREADWEAVER_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define THREADWEAVER_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef THREADWEAVER_DEPRECATED
#  define THREADWEAVER_ENABLE_DEPRECATED_SINCE(major, minor) (ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, 0) > THREADWEAVER_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define THREADWEAVER_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if THREADWEAVER_DEPRECATED_WARNINGS_SINCE >= 0x50000
#  define THREADWEAVER_DEPRECATED_VERSION_5_0(text) THREADWEAVER_DECL_DEPRECATED_TEXT(text)
#else
#  define THREADWEAVER_DEPRECATED_VERSION_5_0(text)
#endif
#define THREADWEAVER_DEPRECATED_VERSION_5(minor, text)      THREADWEAVER_DEPRECATED_VERSION_5_##minor(text)
#define THREADWEAVER_DEPRECATED_VERSION(major, minor, text) THREADWEAVER_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define THREADWEAVER_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) THREADWEAVER_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)

#endif /* THREADWEAVER_EXPORT_H */
