/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class BlockList<T>
extends AbstractList<T> {
    private static final int BLOCK_BITS = 10;
    static final int BLOCK_SIZE = 1024;
    private static final int BLOCK_MASK = 1023;
    T[][] directory;
    int size;
    private int tailDirIdx;
    private int tailBlkIdx;
    private T[] tailBlock;

    public BlockList() {
        this.directory = BlockList.newDirectory(256);
        this.directory[0] = BlockList.newBlock();
        this.tailBlock = this.directory[0];
    }

    public BlockList(int capacity) {
        int dirSize = BlockList.toDirectoryIndex(capacity);
        if ((capacity & 0x3FF) != 0 || dirSize == 0) {
            ++dirSize;
        }
        this.directory = BlockList.newDirectory(dirSize);
        this.directory[0] = BlockList.newBlock();
        this.tailBlock = this.directory[0];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        for (Object[] objectArray : this.directory) {
            if (objectArray == null) continue;
            Arrays.fill(objectArray, null);
        }
        this.size = 0;
        this.tailDirIdx = 0;
        this.tailBlkIdx = 0;
        this.tailBlock = this.directory[0];
    }

    @Override
    public T get(int index2) {
        if (index2 < 0 || this.size <= index2) {
            throw new IndexOutOfBoundsException(String.valueOf(index2));
        }
        return this.directory[BlockList.toDirectoryIndex(index2)][BlockList.toBlockIndex(index2)];
    }

    @Override
    public T set(int index2, T element) {
        if (index2 < 0 || this.size <= index2) {
            throw new IndexOutOfBoundsException(String.valueOf(index2));
        }
        T[] blockRef = this.directory[BlockList.toDirectoryIndex(index2)];
        int blockIdx = BlockList.toBlockIndex(index2);
        T old = blockRef[blockIdx];
        blockRef[blockIdx] = element;
        return old;
    }

    public void addAll(BlockList<T> src) {
        if (src.size == 0) {
            return;
        }
        for (int srcDirIdx = 0; srcDirIdx < src.tailDirIdx; ++srcDirIdx) {
            this.addAll(src.directory[srcDirIdx], 0, 1024);
        }
        if (src.tailBlkIdx != 0) {
            this.addAll(src.tailBlock, 0, src.tailBlkIdx);
        }
    }

    public void addAll(T[] src, int srcIdx, int srcCnt) {
        while (0 < srcCnt) {
            int i = this.tailBlkIdx;
            int n = Math.min(srcCnt, 1024 - i);
            if (n == 0) {
                this.add(src[srcIdx++]);
                --srcCnt;
                continue;
            }
            System.arraycopy(src, srcIdx, this.tailBlock, i, n);
            this.tailBlkIdx += n;
            this.size += n;
            srcIdx += n;
            srcCnt -= n;
        }
    }

    @Override
    public boolean add(T element) {
        T[] blockRef;
        int i = this.tailBlkIdx;
        if (i < 1024) {
            this.tailBlock[i] = element;
            this.tailBlkIdx = i + 1;
            ++this.size;
            return true;
        }
        if (++this.tailDirIdx == this.directory.length) {
            T[][] newDir = BlockList.newDirectory(this.directory.length << 1);
            System.arraycopy(this.directory, 0, newDir, 0, this.directory.length);
            this.directory = newDir;
        }
        if ((blockRef = this.directory[this.tailDirIdx]) == null) {
            blockRef = BlockList.newBlock();
            this.directory[this.tailDirIdx] = blockRef;
        }
        blockRef[0] = element;
        this.tailBlock = blockRef;
        this.tailBlkIdx = 1;
        ++this.size;
        return true;
    }

    @Override
    public void add(int index2, T element) {
        if (index2 == this.size) {
            this.add(element);
        } else {
            if (index2 < 0 || this.size < index2) {
                throw new IndexOutOfBoundsException(String.valueOf(index2));
            }
            this.add((T)null);
            for (int oldIdx = this.size - 2; index2 <= oldIdx; --oldIdx) {
                this.set(oldIdx + 1, this.get(oldIdx));
            }
            this.set(index2, element);
        }
    }

    @Override
    public T remove(int index2) {
        if (index2 == this.size - 1) {
            T[] blockRef = this.directory[BlockList.toDirectoryIndex(index2)];
            int blockIdx = BlockList.toBlockIndex(index2);
            T old = blockRef[blockIdx];
            blockRef[blockIdx] = null;
            --this.size;
            if (0 < this.tailBlkIdx) {
                --this.tailBlkIdx;
            } else {
                this.resetTailBlock();
            }
            return old;
        }
        if (index2 < 0 || this.size <= index2) {
            throw new IndexOutOfBoundsException(String.valueOf(index2));
        }
        T old = this.get(index2);
        while (index2 < this.size - 1) {
            this.set(index2, this.get(index2 + 1));
            ++index2;
        }
        this.set(this.size - 1, (T)null);
        --this.size;
        this.resetTailBlock();
        return old;
    }

    private void resetTailBlock() {
        this.tailDirIdx = BlockList.toDirectoryIndex(this.size);
        this.tailBlkIdx = BlockList.toBlockIndex(this.size);
        this.tailBlock = this.directory[this.tailDirIdx];
    }

    @Override
    public Iterator<T> iterator() {
        return new MyIterator();
    }

    static final int toDirectoryIndex(int index2) {
        return index2 >>> 10;
    }

    static final int toBlockIndex(int index2) {
        return index2 & 0x3FF;
    }

    private static <T> T[][] newDirectory(int size) {
        return new Object[size][];
    }

    private static <T> T[] newBlock() {
        return new Object[1024];
    }

    private class MyIterator
    implements Iterator<T> {
        private int index;
        private int dirIdx;
        private int blkIdx;
        private T[] block;

        private MyIterator() {
            this.block = BlockList.this.directory[0];
        }

        @Override
        public boolean hasNext() {
            return this.index < BlockList.this.size;
        }

        @Override
        public T next() {
            if (BlockList.this.size <= this.index) {
                throw new NoSuchElementException();
            }
            Object res2 = this.block[this.blkIdx];
            if (++this.blkIdx == 1024) {
                this.block = ++this.dirIdx < BlockList.this.directory.length ? BlockList.this.directory[this.dirIdx] : null;
                this.blkIdx = 0;
            }
            ++this.index;
            return res2;
        }

        @Override
        public void remove() {
            if (this.index == 0) {
                throw new IllegalStateException();
            }
            BlockList.this.remove(--this.index);
            this.dirIdx = BlockList.toDirectoryIndex(this.index);
            this.blkIdx = BlockList.toBlockIndex(this.index);
            this.block = BlockList.this.directory[this.dirIdx];
        }
    }
}

