/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.util;

import java.util.ArrayList;
import java.util.List;

public class CommandLineTokenizer {
    private String commandLine;

    public CommandLineTokenizer(String commandLine) {
        this.commandLine = commandLine;
    }

    public List<String> tokenize() {
        State state = State.NORMAL;
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder token = new StringBuilder();
        int index = 0;
        while (index < this.commandLine.length()) {
            char character = this.commandLine.charAt(index);
            block0 : switch (state) {
                case NORMAL: {
                    switch (character) {
                        case '\'': {
                            state = State.SINGLE_QUOTE;
                            break block0;
                        }
                        case '\"': {
                            state = State.DOUBLE_QUOTE;
                            break block0;
                        }
                        case ' ': {
                            if (token.length() <= 0) break block0;
                            result.add(token.toString());
                            token = new StringBuilder();
                            break block0;
                        }
                    }
                    token.append(character);
                    break;
                }
                case SINGLE_QUOTE: {
                    if (character == '\'') {
                        state = State.NORMAL;
                        break;
                    }
                    token.append(character);
                    break;
                }
                case DOUBLE_QUOTE: {
                    if (character == '\"') {
                        state = State.NORMAL;
                        break;
                    }
                    token.append(character);
                    break;
                }
            }
            ++index;
        }
        if (token.length() > 0) {
            result.add(token.toString());
        }
        return result;
    }

    private static enum State {
        NORMAL,
        SINGLE_QUOTE,
        DOUBLE_QUOTE;

    }
}

