/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.nmea;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.io.IGpxReader;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.nmea.Sentence;
import org.openstreetmap.josm.io.nmea.TalkerId;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.date.DateUtils;
import org.xml.sax.SAXException;

public class NmeaReader
implements IGpxReader {
    private final InputStream source;
    GpxData data;
    private static final Pattern DATE_TIME_PATTERN = Pattern.compile("(\\d{12})(\\.\\d+)?");
    private final SimpleDateFormat rmcTimeFmt = new SimpleDateFormat("ddMMyyHHmmss.SSS", Locale.ENGLISH);
    public NMEAParserState ps;

    private Date readTime(String p) throws IllegalDataException {
        Matcher m = DATE_TIME_PATTERN.matcher(p);
        if (m.matches()) {
            Date d;
            String date = m.group(1);
            double milliseconds = 0.0;
            if (m.groupCount() > 1 && m.group(2) != null) {
                milliseconds = 1000.0 * Double.parseDouble("0" + m.group(2));
            }
            if ((d = this.rmcTimeFmt.parse(date = date + String.format(".%03d", (int)milliseconds), new ParsePosition(0))) != null) {
                return d;
            }
        }
        throw new IllegalDataException("Date is malformed: '" + p + "'");
    }

    public int getParserUnknown() {
        return this.ps.unknown;
    }

    public int getParserZeroCoordinates() {
        return this.ps.zeroCoord;
    }

    public int getParserChecksumErrors() {
        return this.ps.checksumErrors + this.ps.noChecksum;
    }

    public int getParserMalformed() {
        return this.ps.malformed;
    }

    public int getNumberOfCoordinates() {
        return this.ps.success;
    }

    public NmeaReader(InputStream source) throws IOException {
        this.source = Objects.requireNonNull(source);
        this.rmcTimeFmt.setTimeZone(DateUtils.UTC);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean parse(boolean tryToFinish) throws SAXException, IOException {
        this.data = new GpxData();
        ArrayList<Collection<WayPoint>> currentTrack = new ArrayList<Collection<WayPoint>>();
        try (BufferedReader rd = new BufferedReader(new InputStreamReader(this.source, StandardCharsets.UTF_8));){
            StringBuilder sb = new StringBuilder(1024);
            int loopstartChar = rd.read();
            this.ps = new NMEAParserState();
            if (loopstartChar == -1) {
                boolean bl = false;
                return bl;
            }
            sb.append((char)loopstartChar);
            this.ps.pDate = "010100";
            while (true) {
                int c;
                if (sb.length() >= 1020) {
                    sb.delete(0, sb.length() - 1);
                }
                if ((c = rd.read()) == 36) {
                    this.parseNMEASentence(sb.toString(), this.ps);
                    sb.delete(0, sb.length());
                    sb.append('$');
                    continue;
                }
                if (c == -1) {
                    this.parseNMEASentence(sb.toString(), this.ps);
                    currentTrack.add(this.ps.waypoints);
                    this.data.tracks.add(new GpxTrack((Collection<Collection<WayPoint>>)currentTrack, Collections.emptyMap()));
                    return true;
                }
                sb.append((char)c);
            }
        }
        catch (IllegalDataException e) {
            Logging.warn(e);
            return false;
        }
    }

    static boolean isSentence(String address, Sentence formatter) {
        return Arrays.stream(TalkerId.values()).anyMatch(talker -> address.equals('$' + talker.name() + formatter.name()));
    }

    private boolean parseNMEASentence(String s, NMEAParserState ps) throws IllegalDataException {
        try {
            if (s.isEmpty()) {
                throw new IllegalArgumentException("s is empty");
            }
            String[] chkstrings = s.split("\\*", -1);
            if (chkstrings.length > 1) {
                byte[] chb = chkstrings[0].getBytes(StandardCharsets.UTF_8);
                int chk = 0;
                for (int i = 1; i < chb.length; ++i) {
                    chk ^= chb[i];
                }
                if (Integer.parseInt(chkstrings[1].substring(0, 2), 16) != chk) {
                    ++ps.checksumErrors;
                    ps.pWp = null;
                    return false;
                }
            } else {
                ++ps.noChecksum;
            }
            String[] e = chkstrings[0].split(",", -1);
            WayPoint currentwp = ps.pWp;
            String currentDate = ps.pDate;
            if (NmeaReader.isSentence(e[0], Sentence.GGA)) {
                LatLon latLon = NmeaReader.parseLatLon(e[GGA.LATITUDE_NAME.position], e[GGA.LONGITUDE_NAME.position], e[GGA.LATITUDE.position], e[GGA.LONGITUDE.position]);
                if (latLon == null) {
                    throw new IllegalDataException("Malformed lat/lon");
                }
                if (LatLon.ZERO.equals(latLon)) {
                    ++ps.zeroCoord;
                    return false;
                }
                String accu = e[GGA.TIME.position];
                Date d = this.readTime(currentDate + accu);
                if (ps.pTime == null || currentwp == null || !ps.pTime.equals(accu)) {
                    ps.pTime = accu;
                    currentwp = new WayPoint(latLon);
                }
                if (!currentwp.attr.containsKey("time")) {
                    currentwp.setTime(d);
                }
                if ("M".equals(accu = e[GGA.HEIGHT_UNTIS.position]) && !(accu = e[GGA.HEIGHT.position]).isEmpty()) {
                    Double.parseDouble(accu);
                    if (!accu.isEmpty()) {
                        currentwp.put("ele", accu);
                    }
                }
                accu = e[GGA.SATELLITE_COUNT.position];
                int sat = 0;
                if (!accu.isEmpty()) {
                    sat = Integer.parseInt(accu);
                    currentwp.put("sat", accu);
                }
                if (!(accu = e[GGA.HDOP.position]).isEmpty()) {
                    currentwp.put("hdop", Float.valueOf(accu));
                }
                if (!(accu = e[GGA.QUALITY.position]).isEmpty()) {
                    int fixtype = Integer.parseInt(accu);
                    switch (fixtype) {
                        case 0: {
                            currentwp.put("fix", "none");
                            break;
                        }
                        case 1: {
                            if (sat < 4) {
                                currentwp.put("fix", "2d");
                                break;
                            }
                            currentwp.put("fix", "3d");
                            break;
                        }
                        case 2: {
                            currentwp.put("fix", "dgps");
                            break;
                        }
                        case 3: {
                            currentwp.put("fix", "pps");
                            break;
                        }
                        case 4: {
                            currentwp.put("fix", "rtk");
                            break;
                        }
                        case 5: {
                            currentwp.put("fix", "float rtk");
                            break;
                        }
                        case 6: {
                            currentwp.put("fix", "estimated");
                            break;
                        }
                        case 7: {
                            currentwp.put("fix", "manual");
                            break;
                        }
                        case 8: {
                            currentwp.put("fix", "simulated");
                            break;
                        }
                    }
                }
            } else if (NmeaReader.isSentence(e[0], Sentence.VTG)) {
                String accu = e[VTG.COURSE_REF.position];
                if ("T".equals(accu) && !(accu = e[VTG.COURSE.position]).isEmpty() && currentwp != null) {
                    Double.parseDouble(accu);
                    currentwp.put("course", accu);
                }
                if ((accu = e[VTG.SPEED_KMH_UNIT.position]).startsWith("K") && !(accu = e[VTG.SPEED_KMH.position]).isEmpty() && currentwp != null) {
                    double speed = Double.parseDouble(accu);
                    currentwp.put("speed", Double.toString(speed));
                }
            } else if (NmeaReader.isSentence(e[0], Sentence.GSA)) {
                String accu = e[GSA.VDOP.position];
                if (!accu.isEmpty() && currentwp != null) {
                    currentwp.put("vdop", Float.valueOf(accu));
                }
                if (!(accu = e[GSA.HDOP.position]).isEmpty() && currentwp != null) {
                    currentwp.put("hdop", Float.valueOf(accu));
                }
                if (!(accu = e[GSA.PDOP.position]).isEmpty() && currentwp != null) {
                    currentwp.put("pdop", Float.valueOf(accu));
                }
            } else if (NmeaReader.isSentence(e[0], Sentence.RMC)) {
                LatLon latLon = NmeaReader.parseLatLon(e[RMC.WIDTH_NORTH_NAME.position], e[RMC.LENGTH_EAST_NAME.position], e[RMC.WIDTH_NORTH.position], e[RMC.LENGTH_EAST.position]);
                if (LatLon.ZERO.equals(latLon)) {
                    ++ps.zeroCoord;
                    return false;
                }
                currentDate = e[RMC.DATE.position];
                String time = e[RMC.TIME.position];
                Date d = this.readTime(currentDate + time);
                if (ps.pTime == null || currentwp == null || !ps.pTime.equals(time)) {
                    ps.pTime = time;
                    currentwp = new WayPoint(latLon);
                }
                currentwp.setTime(d);
                String accu = e[RMC.SPEED.position];
                if (!accu.isEmpty() && !currentwp.attr.containsKey("speed")) {
                    double speed = Double.parseDouble(accu);
                    currentwp.put("speed", Double.toString(speed *= 1.8519999984));
                }
                if (!(accu = e[RMC.COURSE.position]).isEmpty() && !currentwp.attr.containsKey("course")) {
                    Double.parseDouble(accu);
                    currentwp.put("course", accu);
                }
            } else if (NmeaReader.isSentence(e[0], Sentence.GLL)) {
                LatLon latLon = NmeaReader.parseLatLon(e[GLL.LATITUDE_NS.position], e[GLL.LONGITUDE_EW.position], e[GLL.LATITUDE.position], e[GLL.LONGITUDE.position]);
                if (LatLon.ZERO.equals(latLon)) {
                    ++ps.zeroCoord;
                    return false;
                }
                if (!"A".equals(e[GLL.STATUS.position])) {
                    return false;
                }
                if (ps.pTime == null || currentwp == null) {
                    currentwp = new WayPoint(latLon);
                }
            } else {
                ++ps.unknown;
                return false;
            }
            ps.pDate = currentDate;
            if (ps.pWp != currentwp) {
                if (ps.pWp != null) {
                    ps.pWp.getDate();
                }
                ps.pWp = currentwp;
                ps.waypoints.add(currentwp);
                ++ps.success;
                return true;
            }
            return true;
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException | IllegalDataException ex) {
            if (ps.malformed < 5) {
                Logging.warn(ex);
            } else {
                Logging.debug(ex);
            }
            ++ps.malformed;
            ps.pWp = null;
            return false;
        }
    }

    private static LatLon parseLatLon(String ns, String ew, String dlat, String dlon) {
        int londegsep;
        String widthNorth = dlat.trim();
        String lengthEast = dlon.trim();
        if (widthNorth.isEmpty() && lengthEast.isEmpty()) {
            return LatLon.ZERO;
        }
        int latdegsep = widthNorth.indexOf(46) - 2;
        if (latdegsep < 0) {
            return null;
        }
        int latdeg = Integer.parseInt(widthNorth.substring(0, latdegsep));
        double latmin = Double.parseDouble(widthNorth.substring(latdegsep));
        if (latdeg < 0) {
            latmin *= -1.0;
        }
        double lat = (double)latdeg + latmin / 60.0;
        if ("S".equals(ns)) {
            lat = -lat;
        }
        if ((londegsep = lengthEast.indexOf(46) - 2) < 0) {
            return null;
        }
        int londeg = Integer.parseInt(lengthEast.substring(0, londegsep));
        double lonmin = Double.parseDouble(lengthEast.substring(londegsep));
        if (londeg < 0) {
            lonmin *= -1.0;
        }
        double lon = (double)londeg + lonmin / 60.0;
        if ("W".equals(ew)) {
            lon = -lon;
        }
        return new LatLon(lat, lon);
    }

    @Override
    public GpxData getGpxData() {
        return this.data;
    }

    private static class NMEAParserState {
        protected Collection<WayPoint> waypoints = new ArrayList<WayPoint>();
        protected String pTime;
        protected String pDate;
        protected WayPoint pWp;
        protected int success;
        protected int malformed;
        protected int checksumErrors;
        protected int noChecksum;
        protected int unknown;
        protected int zeroCoord;

        private NMEAParserState() {
        }
    }

    static enum GLL {
        LATITUDE(1),
        LATITUDE_NS(2),
        LONGITUDE(3),
        LONGITUDE_EW(4),
        UTC(5),
        STATUS(6),
        MODE(7);

        final int position;

        private GLL(int position) {
            this.position = position;
        }
    }

    static enum GSA {
        AUTOMATIC(1),
        FIX_TYPE(2),
        PRN_1(3),
        PRN_2(4),
        PRN_3(5),
        PRN_4(6),
        PRN_5(7),
        PRN_6(8),
        PRN_7(9),
        PRN_8(10),
        PRN_9(11),
        PRN_10(12),
        PRN_11(13),
        PRN_12(14),
        PDOP(15),
        HDOP(16),
        VDOP(17);

        final int position;

        private GSA(int position) {
            this.position = position;
        }
    }

    static enum GGA {
        TIME(1),
        LATITUDE(2),
        LATITUDE_NAME(3),
        LONGITUDE(4),
        LONGITUDE_NAME(5),
        QUALITY(6),
        SATELLITE_COUNT(7),
        HDOP(8),
        HEIGHT(9),
        HEIGHT_UNTIS(10),
        HEIGHT_2(11),
        HEIGHT_2_UNTIS(12),
        GPS_AGE(13),
        REF(14);

        final int position;

        private GGA(int position) {
            this.position = position;
        }
    }

    static enum RMC {
        TIME(1),
        RECEIVER_WARNING(2),
        WIDTH_NORTH(3),
        WIDTH_NORTH_NAME(4),
        LENGTH_EAST(5),
        LENGTH_EAST_NAME(6),
        SPEED(7),
        COURSE(8),
        DATE(9),
        MAGNETIC_DECLINATION(10),
        UNKNOWN(11),
        MODE(12);

        final int position;

        private RMC(int position) {
            this.position = position;
        }
    }

    static enum VTG {
        COURSE(1),
        COURSE_REF(2),
        COURSE_M(3),
        COURSE_M_REF(4),
        SPEED_KN(5),
        SPEED_KN_UNIT(6),
        SPEED_KMH(7),
        SPEED_KMH_UNIT(8),
        REST(9);

        final int position;

        private VTG(int position) {
            this.position = position;
        }
    }
}

