/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import mediathek.config.Daten;
import mediathek.config.MVConfig;
import mediathek.daten.DatenDownload;
import mediathek.daten.DatenMediaPath;
import mediathek.daten.DatenProg;
import mediathek.daten.DatenPset;
import mediathek.daten.abo.DatenAbo;
import mediathek.daten.blacklist.BlacklistRule;
import mediathek.tool.ReplaceList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IoXmlLesen {
    private static final Logger logger = LogManager.getLogger(IoXmlLesen.class);
    private final XMLInputFactory inFactory = XMLInputFactory.newInstance();
    private final Daten daten;

    public IoXmlLesen() {
        this.inFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
        this.daten = Daten.getInstance();
    }

    private boolean get(XMLStreamReader parser, String xmlElem, String[] xmlNames, String[] strRet) {
        boolean ret = true;
        int maxElem = strRet.length;
        for (int i = 0; i < maxElem; ++i) {
            if (strRet[i] != null) continue;
            strRet[i] = "";
        }
        try {
            int event;
            block3: while (parser.hasNext() && ((event = parser.next()) != 2 || !parser.getLocalName().equals(xmlElem))) {
                if (event != 1) continue;
                for (int i = 0; i < maxElem; ++i) {
                    if (!parser.getLocalName().equals(xmlNames[i])) continue;
                    strRet[i] = parser.getElementText();
                    continue block3;
                }
            }
        }
        catch (Exception ex) {
            ret = false;
            logger.error("get", (Throwable)ex);
        }
        return ret;
    }

    private void readSystemConfiguration(XMLStreamReader parser) {
        try {
            int event;
            while (parser.hasNext() && ((event = parser.next()) != 2 || !parser.getLocalName().equals("system"))) {
                if (event != 1) continue;
                String s2 = parser.getLocalName();
                String n = parser.getElementText();
                MVConfig.add(s2, n);
            }
        }
        catch (Exception ex) {
            logger.error("readSystemConfiguration", (Throwable)ex);
        }
    }

    private void readReplacementList(XMLStreamReader parser) {
        String[] sa = new String[2];
        if (this.get(parser, "Ersetzungstabelle", ReplaceList.COLUMN_NAMES, sa)) {
            ReplaceList.list.add(sa);
        }
    }

    private void readAboEntry(XMLStreamReader parser) {
        try {
            DatenAbo datenAbo = new DatenAbo();
            datenAbo.readFromConfig(parser);
            this.daten.getListeAbo().addAbo(datenAbo);
        }
        catch (XMLStreamException e) {
            logger.error("Failed to read abo entry", (Throwable)e);
        }
    }

    private void readDownloadEntry(XMLStreamReader parser) {
        try {
            DatenDownload dl = DatenDownload.getFromConfig(parser);
            if (!dl.isFromAbo()) {
                this.daten.getListeDownloads().add(dl);
            }
        }
        catch (Exception e) {
            logger.error("readDownloadEntry", (Throwable)e);
        }
    }

    private void readBlacklist(XMLStreamReader parser) {
        BlacklistRule blacklistRule = new BlacklistRule();
        if (this.get(parser, "Blacklist", BlacklistRule.XML_NAMES, blacklistRule.arr)) {
            this.daten.getListeBlacklist().addWithoutNotification(blacklistRule);
        }
    }

    private void readMediaPath(XMLStreamReader parser) {
        DatenMediaPath mp = new DatenMediaPath();
        if (this.get(parser, "MediaPath", DatenMediaPath.XML_NAMES, mp.arr)) {
            this.daten.getListeMediaPath().add(mp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean datenLesen(Path xmlFilePath) {
        boolean ret = false;
        if (Files.exists(xmlFilePath, new LinkOption[0])) {
            DatenPset datenPset = null;
            XMLStreamReader parser = null;
            try (InputStream is = Files.newInputStream(xmlFilePath, new OpenOption[0]);
                 InputStreamReader in = new InputStreamReader(is, StandardCharsets.UTF_8);){
                parser = this.inFactory.createXMLStreamReader(in);
                block41: while (parser.hasNext()) {
                    int event = parser.next();
                    if (event != 1) continue;
                    switch (parser.getLocalName()) {
                        case "system": {
                            this.readSystemConfiguration(parser);
                            break;
                        }
                        case "Programmset": {
                            datenPset = new DatenPset();
                            if (!this.get(parser, "Programmset", DatenPset.XML_NAMES, datenPset.arr)) break;
                            Daten.listePset.add(datenPset);
                            break;
                        }
                        case "Programm": {
                            DatenProg datenProg = new DatenProg();
                            if (!this.get(parser, "Programm", DatenProg.XML_NAMES, datenProg.arr) || datenPset == null) continue block41;
                            datenPset.addProg(datenProg);
                            break;
                        }
                        case "Ersetzungstabelle": {
                            this.readReplacementList(parser);
                            break;
                        }
                        case "Abonnement": {
                            this.readAboEntry(parser);
                            break;
                        }
                        case "Downlad": {
                            this.readDownloadEntry(parser);
                            break;
                        }
                        case "Blacklist": {
                            this.readBlacklist(parser);
                            break;
                        }
                        case "MediaPath": {
                            this.readMediaPath(parser);
                        }
                    }
                }
                ret = true;
            }
            catch (Exception ex) {
                ret = false;
                logger.error("datenLesen", (Throwable)ex);
            }
            finally {
                if (parser != null) {
                    try {
                        parser.close();
                    }
                    catch (XMLStreamException xMLStreamException) {}
                }
            }
            this.sortLists();
            MVConfig.loadSystemParameter();
        }
        return ret;
    }

    private void sortLists() {
        this.daten.getListeDownloads().listeNummerieren();
        this.daten.getListeAbo().sort();
    }
}

