/*
 * Decompiled with CFR 0.152.
 */
package mediathek.mac;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Taskbar;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import mediathek.config.Daten;
import mediathek.gui.actions.ShowAboutAction;
import mediathek.gui.messages.DownloadFinishedEvent;
import mediathek.gui.messages.DownloadStartEvent;
import mediathek.gui.messages.InstallTabSwitchListenerEvent;
import mediathek.mac.OsxIndicatorThread;
import mediathek.mac.OsxPowerManager;
import mediathek.mac.tabs.TabDownloadsMac;
import mediathek.mac.tabs.TabFilmeMac;
import mediathek.mac.touchbar.TouchBarUtils;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.notification.GenericNotificationCenter;
import mediathek.tool.notification.INotificationCenter;
import mediathek.tool.notification.MacNotificationCenter;
import mediathek.tool.notification.NullNotificationCenter;
import mediathek.tool.threads.IndicatorThread;
import net.engio.mbassy.listener.Handler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class MediathekGuiMac
extends MediathekGui {
    protected static final Logger logger = LogManager.getLogger(MediathekGuiMac.class);
    private final OsxPowerManager powerManager = new OsxPowerManager();

    public MediathekGuiMac() {
        this.setupDockIcon();
    }

    @Override
    public void setVisible(boolean visible) {
        Component comp;
        super.setVisible(visible);
        if (TouchBarUtils.isTouchBarSupported() && (comp = this.tabbedPane.getSelectedComponent()).equals(this.tabFilme)) {
            this.tabFilme.showTouchBar();
        }
    }

    @Override
    protected boolean officialLauncherInUse() {
        boolean macOSBinaryInuse = true;
        String osxOfficialApp = System.getProperty("OSX_OFFICIAL_APP");
        if (osxOfficialApp == null || osxOfficialApp.isEmpty() || osxOfficialApp.equalsIgnoreCase("false")) {
            macOSBinaryInuse = false;
        }
        return macOSBinaryInuse;
    }

    @Override
    protected void installAdditionalHelpEntries() {
    }

    @Override
    public void initializeSystemTray() {
    }

    @Override
    protected void installTouchBarSupport() {
        logger.trace("install touch bar support");
        if (TouchBarUtils.isTouchBarSupported()) {
            this.tabbedPane.addChangeListener(e -> {
                Component comp = this.tabbedPane.getSelectedComponent();
                if (comp.equals(this.tabFilme)) {
                    this.tabDownloads.hideTouchBar();
                    this.tabFilme.showTouchBar();
                } else if (comp.equals(this.tabDownloads)) {
                    this.tabFilme.hideTouchBar();
                    this.tabDownloads.showTouchBar();
                }
            });
        }
    }

    @Override
    protected void setupNotificationCenter() {
        try {
            INotificationCenter notificationCenter = this.daten.notificationCenter();
            if (notificationCenter != null) {
                notificationCenter.close();
            }
        }
        catch (IOException e) {
            logger.error("error closing notification center", (Throwable)e);
        }
        boolean showNotifications = this.config.getBoolean("application.notifications.show", true);
        this.config.setProperty("application.notifications.native_support", false);
        if (!showNotifications) {
            this.daten.setNotificationCenter(new NullNotificationCenter());
        } else if (this.config.getBoolean("application.notifications.show_native", false)) {
            this.daten.setNotificationCenter(new MacNotificationCenter());
        } else {
            this.daten.setNotificationCenter(new GenericNotificationCenter());
        }
    }

    @Override
    protected JPanel createTabFilme(@NotNull Daten daten) {
        return new TabFilmeMac(daten, this);
    }

    @Override
    protected JPanel createTabDownloads(@NotNull Daten daten) {
        return new TabDownloadsMac(daten, this);
    }

    @Override
    protected void shutdownComputer() {
        try {
            Runtime.getRuntime().exec("nohup bin/mv_shutdown_helper");
        }
        catch (IOException e) {
            logger.error(e);
        }
    }

    @Override
    protected void installMenuTabSwitchListener() {
    }

    @Override
    @Handler
    protected void handleInstallTabSwitchListenerEvent(InstallTabSwitchListenerEvent msg) {
    }

    @Override
    protected void initMenus() {
        super.initMenus();
        this.setupUserInterfaceForOsx();
    }

    @Override
    protected IndicatorThread createProgressIndicatorThread() {
        return new OsxIndicatorThread();
    }

    @Override
    protected void handleDownloadStart(DownloadStartEvent msg) {
        super.handleDownloadStart(msg);
        this.powerManager.disablePowerManagement();
        this.setDownloadsBadge(this.numDownloadsStarted.get());
    }

    @Override
    protected void handleDownloadFinishedEvent(DownloadFinishedEvent msg) {
        super.handleDownloadFinishedEvent(msg);
        int numDownloads = this.numDownloadsStarted.get();
        if (numDownloads == 0) {
            this.powerManager.enablePowerManagement();
        }
        this.setDownloadsBadge(numDownloads);
    }

    private void setDownloadsBadge(int numDownloads) {
        Taskbar taskbar;
        if (Taskbar.isTaskbarSupported() && (taskbar = Taskbar.getTaskbar()).isSupported(Taskbar.Feature.ICON_BADGE_NUMBER)) {
            if (numDownloads > 0) {
                taskbar.setIconBadge(Integer.toString(numDownloads));
            } else {
                taskbar.setIconBadge("");
            }
        }
    }

    private void setupUserInterfaceForOsx() {
        Desktop desktop = Desktop.getDesktop();
        desktop.disableSuddenTermination();
        desktop.setQuitHandler((e, response) -> {
            if (!this.beenden(false, false)) {
                response.cancelQuit();
            } else {
                response.performQuit();
            }
        });
        desktop.setAboutHandler(e -> new ShowAboutAction().actionPerformed(null));
        desktop.setPreferencesHandler(e -> this.getSettingsDialog().setVisible(true));
    }

    private void setupDockIcon() {
        try {
            Taskbar taskbar;
            if (Taskbar.isTaskbarSupported() && (taskbar = Taskbar.getTaskbar()).isSupported(Taskbar.Feature.ICON_IMAGE)) {
                URL url = this.getClass().getResource("/mediathek/res/MediathekView.png");
                BufferedImage appImage = ImageIO.read(url);
                Taskbar.getTaskbar().setIconImage(appImage);
            }
        }
        catch (IOException ex) {
            logger.error("OS X Application image could not be loaded", (Throwable)ex);
        }
    }
}

