/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.http;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import mediathek.config.Config;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.dns.DnsSelector;
import mediathek.tool.dns.IPvPreferenceMode;
import mediathek.tool.http.ByteCounter;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.apache.commons.configuration2.Configuration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MVHttpClient {
    private static final MVHttpClient ourInstance = new MVHttpClient();
    private static final String HTTP_PROXY_AUTHORIZATION = "Proxy-Authorization";
    private final Logger logger;
    private final Configuration config;
    private final ByteCounter byteCounter;
    private OkHttpClient httpClient;
    private OkHttpClient copyClient;

    private MVHttpClient() {
        block6: {
            this.logger = LogManager.getLogger(MVHttpClient.class);
            this.config = ApplicationConfiguration.getConfiguration();
            this.byteCounter = new ByteCounter();
            String proxyHost = System.getProperty("http.proxyHost");
            String proxyPort = System.getProperty("http.proxyPort");
            try {
                if (proxyHost != null && proxyPort != null && !proxyHost.isEmpty() && !proxyPort.isEmpty()) {
                    Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, Integer.parseInt(proxyPort)));
                    this.setupProxyClients(proxy);
                    this.logger.info("MVHttpClient: Proxy configured from environment variables: ({})", (Object)proxyHost);
                    break block6;
                }
                try {
                    proxyHost = this.config.getString("http.proxy.hostname");
                    proxyPort = this.config.getString("http.proxy.port");
                    if (!proxyHost.isEmpty() && !proxyPort.isEmpty()) {
                        Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, Integer.parseInt(proxyPort)));
                        this.setupProxyClients(proxy);
                        this.logger.info("MVHttpClient: Proxy configured from application config: ({})", (Object)proxyHost);
                        break block6;
                    }
                    this.setupNonProxyClients();
                }
                catch (NoSuchElementException e) {
                    this.setupNonProxyClients();
                }
            }
            catch (NumberFormatException ex) {
                this.setupNonProxyClients();
                this.logger.error("PROXY config failed. Creating non proxy config", (Throwable)ex);
            }
        }
    }

    public static MVHttpClient getInstance() {
        return ourInstance;
    }

    private OkHttpClient.Builder getDefaultClientBuilder() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (Config.isHttpTrafficDebuggingEnabled()) {
            HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor(this.logger::trace);
            HttpLoggingInterceptor.Level level = HttpLoggingInterceptor.Level.BASIC;
            try {
                String levelName = ApplicationConfiguration.getConfiguration().getString("application.debug.http_traffic_trace_level");
                level = HttpLoggingInterceptor.Level.valueOf(levelName);
            }
            catch (Exception ignored) {
                this.logger.error("Error reading http traffic debug trace level, using BASIC");
            }
            interceptor.level(level);
            builder.addInterceptor(interceptor);
            this.logger.debug("HTTP Logging interceptor installed");
        }
        Configuration config = ApplicationConfiguration.getConfiguration();
        IPvPreferenceMode mode = IPvPreferenceMode.fromString(config.getString("application.networking.dns.ip_mode", String.valueOf((Object)IPvPreferenceMode.IPV4_ONLY)));
        builder.connectTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).socketFactory(this.byteCounter.socketFactory()).dns(new DnsSelector(mode));
        return builder;
    }

    public ByteCounter getByteCounter() {
        return this.byteCounter;
    }

    private Authenticator createAuthenticator(String prxUser, String prxPassword) {
        return (route, response) -> {
            if (response.request().header(HTTP_PROXY_AUTHORIZATION) != null) {
                return null;
            }
            String credential = Credentials.basic(prxUser, prxPassword);
            return response.request().newBuilder().header(HTTP_PROXY_AUTHORIZATION, credential).build();
        };
    }

    private Authenticator setupProxyAuthenticator() {
        String prxUser = System.getProperty("http.proxyUser");
        String prxPassword = System.getProperty("http.proxyPassword");
        Authenticator proxyAuthenticator = null;
        if (prxUser != null && prxPassword != null && !prxUser.isEmpty() && !prxPassword.isEmpty()) {
            proxyAuthenticator = this.createAuthenticator(prxUser, prxPassword);
            this.logger.info("Proxy Authentication from environment vars: ({})", (Object)prxUser);
        } else {
            try {
                prxUser = this.config.getString("http.proxy.user");
                prxPassword = this.config.getString("http.proxy.password");
                if (!prxUser.isEmpty() && !prxPassword.isEmpty()) {
                    proxyAuthenticator = this.createAuthenticator(prxUser, prxPassword);
                    this.logger.info("Proxy Authentication from application settings: ({})", (Object)prxUser);
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        return proxyAuthenticator;
    }

    private void setupProxyClients(Proxy proxy) {
        Authenticator proxyAuthenticator = this.setupProxyAuthenticator();
        OkHttpClient.Builder tmpBuilder = this.getDefaultClientBuilder().proxy(proxy);
        if (proxyAuthenticator != null) {
            tmpBuilder.proxyAuthenticator(proxyAuthenticator);
        }
        this.httpClient = tmpBuilder.build();
        tmpBuilder = this.getDefaultClientBuilder().connectTimeout(5L, TimeUnit.SECONDS).readTimeout(5L, TimeUnit.SECONDS).writeTimeout(2L, TimeUnit.SECONDS).proxy(proxy);
        if (proxyAuthenticator != null) {
            tmpBuilder.proxyAuthenticator(proxyAuthenticator);
        }
        this.copyClient = tmpBuilder.build();
    }

    private void setupNonProxyClients() {
        this.httpClient = this.getDefaultClientBuilder().build();
        this.copyClient = this.getDefaultClientBuilder().connectTimeout(5L, TimeUnit.SECONDS).readTimeout(5L, TimeUnit.SECONDS).writeTimeout(2L, TimeUnit.SECONDS).build();
        this.logger.info("MVHttpClient: Proxy not configured");
    }

    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    public OkHttpClient getReducedTimeOutClient() {
        return this.copyClient;
    }
}

