/*
 * Decompiled with CFR 0.152.
 */
package org.h2.pagestore;

import java.util.BitSet;
import org.h2.engine.Session;
import org.h2.pagestore.Page;
import org.h2.pagestore.PageStore;
import org.h2.store.Data;

public class PageFreeList
extends Page {
    private static final int DATA_START = 3;
    private final PageStore store;
    private final BitSet used;
    private final int pageCount;
    private boolean full;
    private Data data;

    private PageFreeList(PageStore pageStore, int n, int n2, BitSet bitSet) {
        this.setPos(n);
        this.store = pageStore;
        this.pageCount = n2;
        this.used = bitSet;
    }

    static PageFreeList read(PageStore pageStore, Data data, int n) {
        data.reset();
        data.readByte();
        data.readShortInt();
        int n2 = pageStore.getPageSize() - 3;
        byte[] byArray = new byte[n2];
        data.read(byArray, 0, byArray.length);
        PageFreeList pageFreeList = new PageFreeList(pageStore, n, n2 * 8, BitSet.valueOf(byArray));
        pageFreeList.data = data;
        pageFreeList.full = false;
        return pageFreeList;
    }

    static PageFreeList create(PageStore pageStore, int n) {
        int n2 = (pageStore.getPageSize() - 3) * 8;
        BitSet bitSet = new BitSet(n2);
        bitSet.set(0);
        return new PageFreeList(pageStore, n, n2, bitSet);
    }

    int allocate(BitSet bitSet, int n) {
        int n2;
        block4: {
            if (this.full) {
                return -1;
            }
            int n3 = Math.max(0, n - this.getPos());
            do {
                if ((n2 = this.used.nextClearBit(n3)) >= this.pageCount) {
                    if (n3 == 0) {
                        this.full = true;
                    }
                    return -1;
                }
                if (bitSet == null || !bitSet.get(n2 + this.getPos())) break block4;
            } while ((n3 = bitSet.nextClearBit(n2 + this.getPos()) - this.getPos()) < this.pageCount);
            return -1;
        }
        this.used.set(n2);
        this.store.logUndo(this, this.data);
        this.store.update(this);
        return n2 + this.getPos();
    }

    int getFirstFree(int n) {
        if (this.full) {
            return -1;
        }
        int n2 = Math.max(0, n - this.getPos());
        int n3 = this.used.nextClearBit(n2);
        if (n3 >= this.pageCount) {
            return -1;
        }
        return n3 + this.getPos();
    }

    int getLastUsed() {
        int n = this.used.length() - 1;
        return n <= 0 ? -1 : n + this.getPos();
    }

    void allocate(int n) {
        int n2 = n - this.getPos();
        if (n2 >= 0 && !this.used.get(n2)) {
            this.used.set(n2);
            this.store.logUndo(this, this.data);
            this.store.update(this);
        }
    }

    void free(int n) {
        this.full = false;
        this.store.logUndo(this, this.data);
        this.used.clear(n - this.getPos());
        this.store.update(this);
    }

    @Override
    public void write() {
        this.data = this.store.createData();
        this.data.writeByte((byte)6);
        this.data.writeShortInt(0);
        int n = this.pageCount >>> 3;
        byte[] byArray = this.used.toByteArray();
        int n2 = Math.min(byArray.length, n);
        this.data.write(byArray, 0, n2);
        for (int i = n - n2; i > 0; --i) {
            this.data.writeByte((byte)0);
        }
        this.store.writePage(this.getPos(), this.data);
    }

    public static int getPagesAddressed(int n) {
        return (n - 3) * 8;
    }

    @Override
    public int getMemory() {
        return this.store.getPageSize() >> 2;
    }

    boolean isUsed(int n) {
        return this.used.get(n - this.getPos());
    }

    @Override
    public void moveTo(Session session, int n) {
        this.store.free(this.getPos(), false);
    }

    public String toString() {
        return "page [" + this.getPos() + "] freeList" + (this.full ? "full" : "");
    }

    @Override
    public boolean canRemove() {
        return true;
    }

    @Override
    public boolean canMove() {
        return false;
    }
}

