/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus.views.mapwidgets;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import net.osmand.data.RotatedTileBox;
import net.osmand.plus.OsmAndFormatter;
import net.osmand.plus.views.OsmandMapLayer;
import net.sourceforge.offroad.OsmWindow;
import net.sourceforge.offroad.ui.OsmBitmapPanel;
import net.sourceforge.offroad.ui.Paint;

public class RouteInfoWidgetsFactory {

    public static class RulerWidget {
        private OsmBitmapPanel ma;
        private String cacheRulerText;
        private int maxWidth;
        private int cacheRulerZoom;
        private double cacheRulerTileX;
        private double cacheRulerTileY;
        private BufferedImage mRulerIcon;
        private BufferedImage mRulerNightIcon;
        private Paint mRulerPaint = new Paint();
        private Paint mRulerShadowPaint = new Paint();

        public RulerWidget(OsmWindow app, OsmBitmapPanel ma) {
            this.ma = ma;
            this.mRulerIcon = app.readImage("ruler.9");
            this.mRulerNightIcon = app.readImage("ruler_night.9");
            this.mRulerPaint.setTextSize(20.0f);
        }

        public void updateTextSize(boolean isNight, int textColor, int textShadowColor, int shadowRadius) {
            this.mRulerPaint.setColor(textColor);
            this.mRulerShadowPaint.setColor(textShadowColor);
        }

        public boolean updateInfo(Graphics2D pCanvas, RotatedTileBox tb, OsmandMapLayer.DrawSettings nightMode) {
            boolean visible = true;
            this.maxWidth = this.ma.getWidth() / 4;
            this.cacheRulerZoom = tb.getZoom();
            this.cacheRulerTileX = tb.getCenterTileX();
            this.cacheRulerTileY = tb.getCenterTileY();
            double dist = tb.getDistance(0, tb.getPixHeight() / 2, tb.getPixWidth(), tb.getPixHeight() / 2);
            double pixDensity = (double)tb.getPixWidth() / dist;
            double roundedDist = OsmAndFormatter.calculateRoundedDist((double)this.maxWidth / pixDensity, this.ma.getApplication());
            int cacheRulerDistPix = (int)(pixDensity * roundedDist);
            this.cacheRulerText = OsmAndFormatter.getFormattedDistance((float)roundedDist, this.ma.getApplication());
            BufferedImage icon = this.mRulerIcon;
            if (nightMode.isNightMode()) {
                icon = this.mRulerNightIcon;
            }
            Rectangle rect = new Rectangle(cacheRulerDistPix, icon.getHeight());
            rect.translate(100, this.ma.getHeight() - 100);
            this.mRulerPaint.updateGraphics(pCanvas);
            int maxpxY = (int)rect.getMaxY();
            int maxpxX = (int)rect.getMaxX();
            int midpxY = (rect.y + maxpxY) / 2;
            int midpxX = (rect.x + maxpxX) / 2;
            pCanvas.drawLine(rect.x, rect.y, rect.x, maxpxY);
            pCanvas.drawLine(maxpxX, rect.y, maxpxX, maxpxY);
            pCanvas.drawLine(rect.x, midpxY, maxpxX, midpxY);
            int stringWidth = pCanvas.getFontMetrics().stringWidth(this.cacheRulerText);
            pCanvas.drawString(this.cacheRulerText, midpxX - stringWidth / 2, midpxY - 5);
            return true;
        }
    }
}

